/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VarListModel;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.controls.drag_drop.ListDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.VarListDropListener;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.DropEvent;
import com.spss.uitools.controls.drag_drop.IDropListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Window;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class OptimalScalingDropListener
extends VarListDropListener {
    private VariableList mDropTarget = null;
    private Timer mTimer = null;
    private Point mLastPosition = null;
    private BaseSubDialog mParent;
    private SrcVariableList[] mSrcList;
    private TargetVariableList[] mTargetList;

    public OptimalScalingDropListener(VariableList variableList) {
        super(variableList);
        this.mDropTarget = variableList;
    }

    public OptimalScalingDropListener(VariableList variableList, SrcVariableList[] srcVariableListArray, TargetVariableList[] targetVariableListArray, BaseSubDialog baseSubDialog) {
        super(variableList);
        this.mSrcList = srcVariableListArray;
        this.mTargetList = targetVariableListArray;
        this.mDropTarget = variableList;
        this.mParent = baseSubDialog;
    }

    public static void addDragAdapters(DragPane dragPane, Component component, BaseSubDialog baseSubDialog, SrcVariableList[] srcVariableListArray, TargetVariableList[] targetVariableListArray) {
        if (component instanceof VariableList) {
            VariableList variableList = (VariableList)component;
            ListDragAdapter listDragAdapter = new ListDragAdapter(variableList, dragPane, "VariableList");
            DialogUtil.modifyMouseInputListeners(variableList, listDragAdapter);
            dragPane.addDropListener((IDropListener)new OptimalScalingDropListener(variableList, srcVariableListArray, targetVariableListArray, baseSubDialog));
        } else if (component instanceof Container) {
            Container container = (Container)component;
            for (Component component2 : container.getComponents()) {
                OptimalScalingDropListener.addDragAdapters(dragPane, component2, baseSubDialog, srcVariableListArray, targetVariableListArray);
            }
        }
    }

    @Override
    public void itemDropped(DropEvent dropEvent) {
        Component component = dropEvent.getSource();
        if (this.mLastPosition != null) {
            this.mLastPosition = null;
            if (this.mTimer != null) {
                this.mTimer.stop();
            }
        }
        this.mDropTarget.getFocusHighlighter().setHighlightBorder(false);
        VariableList variableList = (VariableList)component;
        boolean bl = false;
        if (variableList.equals(this.mSrcList[0]) && this.mDropTarget.equals(this.mTargetList[0]) && this.contains(dropEvent.getDropLocation())) {
            bl = true;
        } else if (variableList.equals(this.mTargetList[0]) && this.mDropTarget.equals(this.mSrcList[0]) && this.contains(dropEvent.getDropLocation())) {
            bl = true;
        } else if (variableList.equals(this.mSrcList[1]) && this.mDropTarget.equals(this.mTargetList[1]) && this.contains(dropEvent.getDropLocation())) {
            bl = true;
        } else if (variableList.equals(this.mTargetList[1]) && this.mDropTarget.equals(this.mSrcList[1]) && this.contains(dropEvent.getDropLocation())) {
            bl = true;
        }
        if (bl) {
            Object object = dropEvent.getTransferData();
            if (object == null) {
                return;
            }
            if (!(object instanceof VariableList.TransferData)) {
                assert (false);
                return;
            }
            VariableList.TransferData transferData = (VariableList.TransferData)object;
            ISpssVariable[] iSpssVariableArray = transferData.getVariables();
            int[] nArray = transferData.getSelectedIndices();
            VarListModel varListModel = this.mDropTarget.getModel();
            Point point = (Point)dropEvent.getDropLocation().clone();
            SwingUtilities.convertPointFromScreen(point, this.mDropTarget);
            int n = this.mDropTarget.locationToIndex(point);
            int n2 = varListModel.getSize();
            if (n < 0) {
                n = n2;
            } else {
                if (!this.mDropTarget.itemInUpperHalf(point)) {
                    ++n;
                }
                if (n > n2) {
                    n = n2;
                }
            }
            if (this.mDropTarget instanceof TargetVariableList && !((TargetVariableList)this.mDropTarget).isDataSource() && this.mDropTarget.mMaxLimitOfList != -1 && iSpssVariableArray.length + this.mDropTarget.getModel().getSize() > this.mDropTarget.mMaxLimitOfList) {
                String string = String.format(ComponentState.getSPSSLocale(), ResUtil.getCommonDlgString("ERR_LIST_MAX_LIMIT_EXCEEDED_WARNING"), this.mDropTarget.mMaxLimitOfList);
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mParent), string, VersionInfo.getAppVersionString());
                final VariableList variableList2 = variableList;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        variableList2.requestFocus();
                    }
                });
                return;
            }
            this.importData(iSpssVariableArray, variableList, n);
            if (!this.mSwapFlag) {
                this.finish(variableList, iSpssVariableArray.length, nArray, n);
            }
        } else {
            return;
        }
        this.mSwapFlag = false;
    }
}

