/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public abstract class CommonOneSetMainDlg
extends BaseProcedureDialog
implements ActionListener,
DocumentListener,
ListDataListener {
    protected JButton mOptBtnDiscretize;
    protected JButton mOptBtnMissing;
    protected JButton mOptBtnOptions;
    protected JButton mOptBtnOutput;
    protected JButton mOptBtnSave;
    protected JButton mOptBtnBootstrap;
    protected JButton mOptBtnPlotsObject;
    protected JButton mOptBtnPlotsVariable;
    protected JButton mOptBtnPlotsCategory;
    protected JButton mOptBtnPlotsLoading;
    protected IntTextField mDimensionsEdit;
    protected SrcVariableList mSrcVariableList;
    protected TargetVariableList mAnalysisVarsVarList;
    protected TargetVariableList mSuppleVarsVarList;
    protected TargetVariableList mLabelingVarsVarList;
    protected ArrowButton mAnaVarsArrow;
    protected ArrowButton mSuppleVarsArrow;
    protected ArrowButton mLabelingVarsArrow;

    public CommonOneSetMainDlg(JFrame jFrame, boolean bl, String string, String string2) {
        super(jFrame, bl, string, string2);
    }

    public static void setMnemonicOnContinueButton(JPanel jPanel, Integer n) {
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            String string = ResUtil.getCommonDlgString("IDS_CONTINUE");
            for (Component component : jPanel.getComponents()) {
                JButton jButton;
                if (!(component instanceof JButton) || !(jButton = (JButton)component).getText().equals(string)) continue;
                jButton.setMnemonic(n);
            }
        }
    }

    public static void fillVectorWithPanelComponents(JPanel jPanel, Vector<Object> vector) {
        vector.addAll(Arrays.asList(jPanel.getComponents()));
    }

    @Override
    public void reset() {
        super.reset();
        this.mAnalysisVarsVarList.removeAll();
        this.mSuppleVarsVarList.removeAll();
        this.mLabelingVarsVarList.removeAll();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.mOptBtnDiscretize) {
            this.runDiscretizeSubDialog();
        } else if (actionEvent.getSource() == this.mOptBtnMissing) {
            this.runMissingSubDialog();
        } else if (actionEvent.getSource() == this.mOptBtnOptions) {
            this.runOptionsSubDialog();
        } else if (actionEvent.getSource() == this.mOptBtnOutput) {
            this.runOutputSubDialog();
        } else if (actionEvent.getSource() == this.mOptBtnSave) {
            this.runSaveSubDialog();
        } else if (actionEvent.getSource() == this.mOptBtnBootstrap) {
            this.runBootstrapSubDialog();
        } else if (actionEvent.getSource() == this.mOptBtnPlotsObject) {
            this.runPlotsObjectSubDialog();
        } else if (actionEvent.getSource() == this.mOptBtnPlotsVariable) {
            this.runPlotsVariableSubDialog();
        } else if (actionEvent.getSource() == this.mOptBtnPlotsCategory) {
            this.runPlotsCategorySubDialog();
        } else if (actionEvent.getSource() == this.mOptBtnPlotsLoading) {
            this.runPlotsLoadingSubDialog();
        } else {
            this.runDefineSubDialog(actionEvent);
        }
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.updateOkPaste();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.updateOkPaste();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.updateOkPaste();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateOkPaste();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateOkPaste();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateOkPaste();
    }

    @Override
    public boolean okPastePressed() {
        boolean bl = super.okPastePressed();
        int n = this.mAnalysisVarsVarList.getModel().getSize();
        int n2 = this.mSuppleVarsVarList.getModel().getSize();
        if (n2 > n - 2) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_DROS_TOO_MANY_VARS_MSG"), VersionInfo.getAppVersionString());
            return false;
        }
        return bl;
    }

    protected void setupViewPanel(JPanel jPanel) {
        this.mAnaVarsArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.left);
        this.mAnaVarsArrow.registerVariableList(this.mSrcVariableList, SpssArrowButton.ButtonOrientation.right);
        this.mAnaVarsArrow.registerVariableList(this.mAnalysisVarsVarList, SpssArrowButton.ButtonOrientation.left);
        this.mSuppleVarsArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.left);
        this.mSuppleVarsArrow.registerVariableList(this.mSrcVariableList, SpssArrowButton.ButtonOrientation.right);
        this.mSuppleVarsArrow.registerVariableList(this.mSuppleVarsVarList, SpssArrowButton.ButtonOrientation.left);
        this.mLabelingVarsArrow = new ArrowButton(SpssArrowButton.ButtonOrientation.left);
        this.mLabelingVarsArrow.registerVariableList(this.mSrcVariableList, SpssArrowButton.ButtonOrientation.right);
        this.mLabelingVarsArrow.registerVariableList(this.mLabelingVarsVarList, SpssArrowButton.ButtonOrientation.left);
        this.mDimensionsEdit.getDocument().addDocumentListener(this);
        this.mAnalysisVarsVarList.getModel().addListDataListener(this);
        this.mSuppleVarsVarList.getModel().addListDataListener(this);
        this.mLabelingVarsVarList.getModel().addListDataListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 17;
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_CORR_ANA_SOURCE_LIST_LABEL");
        jLabel.setLabelFor(this.mSrcVariableList);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.getScrollPaneForList(this.mSrcVariableList), gridBagConstraints, 0, 1, 1, 9, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.getScrollPaneForList(this.mAnalysisVarsVarList), gridBagConstraints, 2, 1, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.getScrollPaneForList(this.mSuppleVarsVarList), gridBagConstraints, 2, 4, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.getScrollPaneForList(this.mLabelingVarsVarList), gridBagConstraints, 2, 7, 2, 1, n, insets);
        n = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mAnaVarsArrow, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mSuppleVarsArrow, gridBagConstraints, 1, 4, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mLabelingVarsArrow, gridBagConstraints, 1, 7, 1, 1, n, insets2);
        insets = new Insets(n2, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mDimensionsEdit, gridBagConstraints, 3, 8, 1, 1, n, insets);
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.setupOptionButtons();
        this.mOptBtnDiscretize.addActionListener(this);
        this.mOptBtnMissing.addActionListener(this);
        this.mOptBtnOptions.addActionListener(this);
        this.mOptBtnOutput.addActionListener(this);
        this.mOptBtnSave.addActionListener(this);
        if (this.mOptBtnBootstrap != null) {
            this.mOptBtnBootstrap.addActionListener(this);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 10;
        Insets insets = DialogUtil.getStandardButtonInsets();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mOptBtnDiscretize, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mOptBtnMissing, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mOptBtnOptions, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mOptBtnOutput, gridBagConstraints, 0, 3, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mOptBtnSave, gridBagConstraints, 0, 4, 1, 1, n, insets);
        if (this.mOptBtnBootstrap != null) {
            DialogUtil.addUsingGBL(jPanel, this.mOptBtnBootstrap, gridBagConstraints, 0, 5, 1, 1, n, insets);
        }
        JPanel jPanel2 = this.getOptionsPlotPanel();
        gridBagConstraints.weighty = 1.0;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 6, 1, 1, n, insets);
        DialogUtil.normalizeButtonWidths((JPanel)jPanel2);
        return jPanel;
    }

    protected abstract JPanel getOptionsPlotPanel();

    protected JButton createButtonWithKey(String string) {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, string);
        return new JButton(toggleButtonAction);
    }

    protected void updateOkPaste() {
        this.enableOkPaste(this.mDimensionsEdit.getText().length() > 0 && this.mAnalysisVarsVarList.getModel().getSize() > 0);
    }

    protected void updateDialogDataModel(String string, boolean bl, boolean bl2, boolean bl3) {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        ISpssVariable[] iSpssVariableArray = dialogDataModel.getVarArray(string);
        Vector<ISpssVariable> vector = new Vector<ISpssVariable>();
        if (iSpssVariableArray != null) {
            for (ISpssVariable iSpssVariable : iSpssVariableArray) {
                if (bl && this.isItemPresent(iSpssVariable.getId(), this.mAnalysisVarsVarList)) {
                    vector.add(iSpssVariable);
                }
                if (bl2 && this.isItemPresent(iSpssVariable.getId(), this.mSuppleVarsVarList)) {
                    vector.add(iSpssVariable);
                }
                if (!bl3 || !this.isItemPresent(iSpssVariable.getId(), this.mLabelingVarsVarList)) continue;
                vector.add(iSpssVariable);
            }
            if (vector.size() > 0) {
                ISpssVariable[] iSpssVariableArray2 = new ISpssVariable[vector.size()];
                dialogDataModel.putVarArray(string, vector.toArray(iSpssVariableArray2));
            } else {
                dialogDataModel.putVarArray(string, null);
            }
        }
    }

    protected boolean isItemPresent(LocallyUniqueId locallyUniqueId, TargetVariableList targetVariableList) {
        for (int i = 0; i < targetVariableList.getModel().getSize(); ++i) {
            LocallyUniqueId locallyUniqueId2 = targetVariableList.getModel().getElementAt(i).getId();
            if (!locallyUniqueId2.equals((Object)locallyUniqueId)) continue;
            return true;
        }
        return false;
    }

    protected abstract void runDefineSubDialog(ActionEvent var1);

    protected abstract void setupOptionButtons();

    protected abstract void runDiscretizeSubDialog();

    protected abstract void runMissingSubDialog();

    protected abstract void runOptionsSubDialog();

    protected abstract void runOutputSubDialog();

    protected abstract void runSaveSubDialog();

    protected void runBootstrapSubDialog() {
    }

    protected abstract void runPlotsObjectSubDialog();

    protected abstract void runPlotsVariableSubDialog();

    protected abstract void runPlotsCategorySubDialog();

    protected abstract void runPlotsLoadingSubDialog();

    private JScrollPane getScrollPaneForList(VariableList variableList) {
        JScrollPane jScrollPane = new JScrollPane(variableList);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        int n = 0;
        if (variableList == this.mAnalysisVarsVarList) {
            n = 5;
        }
        if (variableList == this.mSuppleVarsVarList) {
            n = 3;
        }
        if (variableList == this.mLabelingVarsVarList) {
            n = 2;
        }
        variableList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth(), variableList.getFixedCellHeight() * n + 2));
        jScrollPane.setPreferredSize(variableList.getMinimumSize());
        return jScrollPane;
    }
}

