/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.multi_correspond_analysis_opt_scaling;

import com.spss.java_client.ui.controls.BasicACREvent;
import com.spss.java_client.ui.controls.BasicACRWidget;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.IBasicACRListener;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.uitools.controls.ContextEnabledTextField;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class BaseOptionsSubDlg
extends BaseSubDialog
implements FocusListener,
DocumentListener,
IBasicACRListener,
ItemListener,
ActionListener {
    private static final String EMPTY_STR = "";
    private static final String SPACE = " ";
    private static final String HYPHEN = "-";
    protected JRadioButton mRangeOfCasesRadio;
    protected JLabel mFirstLabel;
    protected ContextEnabledTextField mFirstTextField;
    protected JLabel mLastLabel;
    protected ContextEnabledTextField mLastTextField;
    protected JRadioButton mSingleCaseRadio;
    protected ContextEnabledTextField mSingleCaseTextField;
    protected BasicACRWidget mBasicACRWidget;
    protected JLabel mConvergenceLabel;
    protected FloatTextField mConvergenceTextField;
    protected JLabel mMaximumIterationsLabel;
    protected ContextEnabledTextField mMaximumIterationsTextField;
    protected JRadioButton mVariableLabelsRadio;
    protected JRadioButton mVariableNamesRadio;
    protected JLabel mLimitForLengthLabel;
    protected IntTextField mLimitForLengthTextField;
    protected SpssButtonGroup mSuppObjectsGroup;
    protected SpssButtonGroup mLabelPlotsGroup;
    protected SpssButtonGroup mPlotDimsGroup;
    protected SpssButtonGroup mRotationGroup;
    protected JComboBox mNormalizationMethodCombo;
    protected JLabel mNormCustomValue;
    protected FloatTextField mNormCustomValueEdit;
    protected JRadioButton mPlotDimDisplayAll;
    protected JRadioButton mPlotDimRestrict;
    protected JLabel mPlotDimLoDim;
    protected IntTextField mPlotDimLoDimEdit;
    protected JLabel mPlotDimHiDim;
    protected IntTextField mPlotDimHiDimEdit;
    protected JComboBox mConfigurationCombo;
    protected JButton mConfigFileButton;
    protected FileTextField mConfigFile;
    protected String[] mNormMethodArr;
    protected String[] mConfigOptionsArr;
    protected JRadioButton mNoneRadio;
    protected JRadioButton mVarimaxRadio;
    protected JRadioButton mObliminRadio;
    protected JLabel mDeltaLabel;
    protected FloatTextField mDeltaFloatEdit;
    protected JRadioButton mQuartimaxRadio;
    protected JRadioButton mEquimaxRadio;
    protected JRadioButton mPromaxRadio;
    protected JLabel mKappaLabel;
    protected FloatTextField mKappaFloatEdit;
    protected JCheckBox mKaiserCheck;
    protected JPanel mNormMethodPanel;
    protected JPanel mConfigPanel;
    protected JPanel mPlotDimPanel;
    protected JPanel mRotationPanel;
    protected JPanel mSuppObjectsPanel;
    protected JPanel mCriteriaPanel;
    protected JPanel mLabelPlotsByPanel;

    public BaseOptionsSubDlg(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, bl);
        this.pack();
        this.setLocationRelativeTo((Component)((Object)baseProcedureDialog));
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mFirstTextField)) {
            this.mFirstTextField.selectAll();
        } else if (focusEvent.getSource().equals(this.mLastTextField)) {
            this.mLastTextField.selectAll();
        } else if (focusEvent.getSource().equals(this.mSingleCaseTextField)) {
            this.mSingleCaseTextField.selectAll();
        } else if (focusEvent.getSource().equals(this.mConvergenceTextField)) {
            this.mConvergenceTextField.selectAll();
        } else if (focusEvent.getSource().equals(this.mMaximumIterationsTextField)) {
            this.mMaximumIterationsTextField.selectAll();
        } else if (focusEvent.getSource().equals(this.mLimitForLengthTextField)) {
            this.mLimitForLengthTextField.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument().equals(this.mFirstTextField.getDocument())) {
            this.updateAddChangeButton();
            this.mBasicACRWidget.setRemoveEnabled(false);
        } else if (documentEvent.getDocument().equals(this.mLastTextField.getDocument())) {
            this.updateAddChangeButton();
            this.mBasicACRWidget.setRemoveEnabled(false);
        } else if (documentEvent.getDocument().equals(this.mSingleCaseTextField.getDocument())) {
            this.updateAddChangeButton();
            this.mBasicACRWidget.setRemoveEnabled(false);
        } else {
            this.updateContinue();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument().equals(this.mFirstTextField.getDocument())) {
            this.updateAddChangeButton();
            this.mBasicACRWidget.setRemoveEnabled(false);
        } else if (documentEvent.getDocument().equals(this.mLastTextField.getDocument())) {
            this.updateAddChangeButton();
            this.mBasicACRWidget.setRemoveEnabled(false);
        } else if (documentEvent.getDocument().equals(this.mSingleCaseTextField.getDocument())) {
            this.updateAddChangeButton();
            this.mBasicACRWidget.setRemoveEnabled(false);
        } else {
            this.updateContinue();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mVariableLabelsRadio || itemEvent.getSource() == this.mVariableNamesRadio) {
            boolean bl = this.mVariableLabelsRadio.isSelected();
            this.mLimitForLengthLabel.setEnabled(bl);
            this.mLimitForLengthTextField.setEnabled(bl);
            this.mLimitForLengthTextField.setOpaque(bl);
        } else if (itemEvent.getSource() == this.mRangeOfCasesRadio || itemEvent.getSource() == this.mSingleCaseRadio) {
            boolean bl = this.mRangeOfCasesRadio.isSelected();
            this.mFirstTextField.setEnabled(bl);
            this.mFirstTextField.setOpaque(bl);
            this.mLastTextField.setEnabled(bl);
            this.mLastTextField.setOpaque(bl);
            this.mSingleCaseTextField.setEnabled(!bl);
            this.mSingleCaseTextField.setOpaque(!bl);
            this.updateAddChangeButton();
        } else if (itemEvent.getSource() == this.mPlotDimDisplayAll || itemEvent.getSource() == this.mPlotDimRestrict) {
            boolean bl = this.mPlotDimRestrict.isSelected();
            this.mPlotDimHiDim.setEnabled(bl);
            this.mPlotDimHiDimEdit.setEnabled(bl);
            this.mPlotDimHiDimEdit.setOpaque(bl);
            this.mPlotDimLoDim.setEnabled(bl);
            this.mPlotDimLoDimEdit.setEnabled(bl);
            this.mPlotDimLoDimEdit.setOpaque(bl);
        } else if (itemEvent.getSource() == this.mNormalizationMethodCombo) {
            boolean bl = this.mNormalizationMethodCombo.getSelectedItem().toString().equals(this.mNormMethodArr[4]);
            this.mNormCustomValue.setEnabled(bl);
            this.mNormCustomValueEdit.setEnabled(bl);
            this.mNormCustomValueEdit.setOpaque(bl);
        } else if (itemEvent.getSource() == this.mConfigurationCombo) {
            boolean bl = this.mConfigurationCombo.getSelectedItem().toString().equals(this.mConfigOptionsArr[0]);
            this.mConfigFileButton.setEnabled(!bl);
            this.mConfigFile.setEnabled(!bl);
        } else if (itemEvent.getSource() == this.mObliminRadio) {
            this.mDeltaLabel.setEnabled(this.mObliminRadio.isSelected());
            this.mDeltaFloatEdit.setEnabled(this.mObliminRadio.isSelected());
        } else if (itemEvent.getSource() == this.mPromaxRadio) {
            this.mKappaLabel.setEnabled(this.mPromaxRadio.isSelected());
            this.mKappaFloatEdit.setEnabled(this.mPromaxRadio.isSelected());
        } else if (itemEvent.getSource() == this.mNoneRadio) {
            this.mKaiserCheck.setEnabled(!this.mNoneRadio.isSelected());
        }
        this.updateContinue();
    }

    @Override
    public void acrEventOccured(BasicACREvent basicACREvent) {
        if (basicACREvent.getEventType() == BasicACREvent.EventType.addButtonPress) {
            if (!this.processAddButtonPress()) {
                this.mBasicACRWidget.setAddEnabled(false);
                this.mBasicACRWidget.setChangeEnabled(false);
                this.mBasicACRWidget.setRemoveEnabled(false);
                this.mBasicACRWidget.getList().requestFocus();
            }
        } else if (basicACREvent.getEventType() == BasicACREvent.EventType.changeButtonPress) {
            if (!this.processChangeButtonPress()) {
                this.mBasicACRWidget.setAddEnabled(false);
                this.mBasicACRWidget.setChangeEnabled(false);
                this.mBasicACRWidget.setRemoveEnabled(false);
            }
        } else if (basicACREvent.getEventType() == BasicACREvent.EventType.removeButtonPress) {
            this.processRemoveButtonPress();
            this.mBasicACRWidget.setRemoveEnabled(false);
        } else if (basicACREvent.getEventType() == BasicACREvent.EventType.listSelectionValueChange) {
            this.processListSelectionValueChange();
            this.mBasicACRWidget.setAddEnabled(false);
            this.mBasicACRWidget.setChangeEnabled(false);
            this.mBasicACRWidget.setRemoveEnabled(this.mBasicACRWidget.getList().getModel().getSize() > 0);
            this.mBasicACRWidget.getList().requestFocus();
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.addComponentsToPanel(jPanel);
        this.setTabTraversal();
        this.pack();
    }

    protected abstract void initVars();

    protected abstract void setDefaults();

    protected abstract void updateContinue();

    protected abstract void showValueOutOfRangeWarning();

    protected abstract void showInvalideRangeWarning();

    protected boolean isTextZero(String string) {
        return 0 == Integer.parseInt(string);
    }

    protected boolean isTextTooBig(String string) {
        return Integer.parseInt(string) > 99999999;
    }

    protected boolean isRangeInvalid() {
        BigDecimal bigDecimal = new BigDecimal(this.mFirstTextField.getText());
        BigDecimal bigDecimal2 = new BigDecimal(this.mLastTextField.getText());
        return bigDecimal2.compareTo(bigDecimal) == -1;
    }

    private boolean processChangeButtonPress() {
        boolean bl = false;
        if (this.mRangeOfCasesRadio.isSelected()) {
            if (this.isRangeInvalid()) {
                this.showInvalideRangeWarning();
                this.mFirstTextField.selectAll();
                this.mFirstTextField.requestFocus();
                bl = true;
            }
            if (this.isTextZero(this.mLastTextField.getText())) {
                this.showValueOutOfRangeWarning();
                this.mLastTextField.selectAll();
                this.mLastTextField.requestFocus();
                bl = true;
            }
            if (!bl) {
                String string = this.mFirstTextField.getText() + SPACE + HYPHEN + SPACE + this.mLastTextField.getText();
                int n = this.mBasicACRWidget.getListSelectedIndex();
                this.mBasicACRWidget.removeListItemAt(n);
                this.mBasicACRWidget.addListItemAt(n, string);
                this.mFirstTextField.setText(EMPTY_STR);
                this.mLastTextField.setText(EMPTY_STR);
            }
        } else if (this.mSingleCaseTextField.isEnabled()) {
            if (this.isTextZero(this.mSingleCaseTextField.getText())) {
                this.showValueOutOfRangeWarning();
                bl = true;
            } else {
                int n = this.mBasicACRWidget.getListSelectedIndex();
                String string = this.mSingleCaseTextField.getText();
                this.mBasicACRWidget.removeListItemAt(n);
                this.mBasicACRWidget.addListItemAt(n, string);
                this.mSingleCaseTextField.setText(EMPTY_STR);
            }
        }
        return bl;
    }

    private void processRemoveButtonPress() {
        int[] nArray = this.mBasicACRWidget.getList().getSelectedIndices();
        for (int i = nArray.length - 1; i >= 0; --i) {
            String string = (String)this.mBasicACRWidget.getListItemAt(nArray[i]);
            if (string.contains(HYPHEN)) {
                this.mFirstTextField.setText(EMPTY_STR);
                this.mLastTextField.setText(EMPTY_STR);
            } else {
                this.mSingleCaseTextField.setText(EMPTY_STR);
            }
            this.mBasicACRWidget.removeListItemAt(nArray[i]);
        }
    }

    private void processListSelectionValueChange() {
        int[] nArray = this.mBasicACRWidget.getList().getSelectedIndices();
        if (nArray.length == 1) {
            if (this.mBasicACRWidget.getListSelectedIndex() != -1) {
                String string = (String)this.mBasicACRWidget.getListItemAt(this.mBasicACRWidget.getListSelectedIndex());
                if (string.contains(HYPHEN)) {
                    String string2 = string.substring(0, string.indexOf(SPACE));
                    String string3 = string.substring(string.indexOf(SPACE) + 3, string.length());
                    this.mRangeOfCasesRadio.setSelected(true);
                    this.mFirstTextField.setEnabled(true);
                    this.mFirstTextField.setOpaque(true);
                    this.mLastTextField.setEnabled(true);
                    this.mLastTextField.setOpaque(true);
                    this.mSingleCaseTextField.setEnabled(false);
                    this.mSingleCaseTextField.setOpaque(false);
                    this.mFirstTextField.setText(string2);
                    this.mLastTextField.setText(string3);
                } else {
                    this.mSingleCaseRadio.setSelected(true);
                    this.mFirstTextField.setEnabled(false);
                    this.mFirstTextField.setOpaque(false);
                    this.mLastTextField.setEnabled(false);
                    this.mLastTextField.setOpaque(false);
                    this.mSingleCaseTextField.setEnabled(true);
                    this.mSingleCaseTextField.setOpaque(true);
                    this.mSingleCaseTextField.setText(string);
                }
            }
        } else {
            this.mFirstTextField.setText(EMPTY_STR);
            this.mLastTextField.setText(EMPTY_STR);
            this.mSingleCaseTextField.setText(EMPTY_STR);
        }
    }

    private void updateAddChangeButton() {
        if (this.mSingleCaseTextField.isEnabled()) {
            this.mBasicACRWidget.setAddEnabled(this.mSingleCaseTextField.getText().length() > 0);
            this.mBasicACRWidget.setChangeEnabled(this.mSingleCaseTextField.getText().length() > 0 && this.mBasicACRWidget.getListSelectedIndex() != -1);
        } else if (this.mFirstTextField.isEnabled() && this.mLastTextField.isEnabled()) {
            this.mBasicACRWidget.setAddEnabled(this.mFirstTextField.getText().length() > 0 && this.mLastTextField.getText().length() > 0);
            this.mBasicACRWidget.setChangeEnabled(this.mFirstTextField.getText().length() > 0 && this.mLastTextField.getText().length() > 0 && this.mBasicACRWidget.getListSelectedIndex() != -1);
        }
    }

    private boolean processAddButtonPress() {
        boolean bl = false;
        if (this.mRangeOfCasesRadio.isSelected()) {
            if (this.isRangeInvalid()) {
                this.showInvalideRangeWarning();
                this.mFirstTextField.selectAll();
                this.mFirstTextField.requestFocus();
                bl = true;
            }
            if (!bl && (this.isTextZero(this.mFirstTextField.getText()) || this.isTextTooBig(this.mFirstTextField.getText()))) {
                this.showValueOutOfRangeWarning();
                this.mFirstTextField.selectAll();
                this.mFirstTextField.requestFocus();
                bl = true;
            }
            if (!bl && (this.isTextZero(this.mLastTextField.getText()) || this.isTextTooBig(this.mFirstTextField.getText()))) {
                this.showValueOutOfRangeWarning();
                this.mLastTextField.selectAll();
                this.mLastTextField.requestFocus();
                bl = true;
            }
            if (!bl) {
                String string = this.mFirstTextField.getText() + SPACE + HYPHEN + SPACE + this.mLastTextField.getText();
                this.mBasicACRWidget.addListItemAt(this.mBasicACRWidget.getListItemCount(), string);
                this.mFirstTextField.setText(EMPTY_STR);
                this.mLastTextField.setText(EMPTY_STR);
            }
        } else if (this.mSingleCaseTextField.isEnabled()) {
            if (this.isTextZero(this.mSingleCaseTextField.getText()) || this.isTextTooBig(this.mSingleCaseTextField.getText())) {
                this.showValueOutOfRangeWarning();
                bl = true;
            } else {
                this.mBasicACRWidget.addListItemAt(this.mBasicACRWidget.getListItemCount(), this.mSingleCaseTextField.getText());
                this.mSingleCaseTextField.setText(EMPTY_STR);
            }
        }
        return bl;
    }

    private void addComponentsToPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        JPanel jPanel2 = this.setupSuppObjectsPanel();
        JPanel jPanel3 = this.setupNormMethodPanel();
        JPanel jPanel4 = this.setupCriteriaPanel();
        JPanel jPanel5 = this.setupLabelPlotsByPanel();
        JPanel jPanel6 = this.setupPlotDimPanel();
        JPanel jPanel7 = this.setupConfigPanel();
        JPanel jPanel8 = this.setupRotationPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 3, n, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 1, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel5, gridBagConstraints, 1, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel6, gridBagConstraints, 0, 3, jPanel8 != null ? 1 : 2, 1, n, insets);
        if (jPanel8 != null) {
            DialogUtil.addUsingGBL(jPanel, jPanel8, gridBagConstraints, 1, 3, 1, 1, n, insets);
        }
        DialogUtil.addUsingGBL(jPanel, jPanel7, gridBagConstraints, 0, 4, 2, 1, n, insets);
    }

    private JPanel setupNormMethodPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 21;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(this.mNormMethodPanel, this.mNormalizationMethodCombo, gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(this.mNormMethodPanel, this.mNormCustomValue, gridBagConstraints, 0, 1, 1, 1, n, insets);
        n = 22;
        DialogUtil.addUsingGBL(this.mNormMethodPanel, (JComponent)this.mNormCustomValueEdit, gridBagConstraints, 1, 1, 1, 1, n, insets);
        JLabel jLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_MCA_OPTS_NORM_METHOD");
        jLabel.setLabelFor(this.mNormalizationMethodCombo);
        this.mNormMethodPanel = PanelFactory.setupMnemonickey(this.mNormMethodPanel, jLabel);
        return this.mNormMethodPanel;
    }

    private JPanel setupConfigPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 21;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(this.mConfigPanel, this.mConfigurationCombo, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(this.mConfigPanel, this.mConfigFileButton, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(this.mConfigPanel, (JComponent)((Object)this.mConfigFile), gridBagConstraints, 2, 0, 1, 1, n, insets);
        JLabel jLabel = DialogUtil.createLabel(this.mParentDlg, "IDS_MCA_OPTS_CONFIG_TITLE");
        jLabel.setLabelFor(this.mConfigurationCombo);
        this.mConfigPanel = PanelFactory.setupMnemonickey(this.mConfigPanel, jLabel);
        return this.mConfigPanel;
    }

    private JPanel setupPlotDimPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        int n = 21;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(this.mPlotDimPanel, this.mPlotDimDisplayAll, gridBagConstraints, 0, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(this.mPlotDimPanel, this.mPlotDimRestrict, gridBagConstraints, 0, 1, 2, 1, n, insets);
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        gridBagConstraints.weightx = 0.0;
        insets = new Insets(n2, n2 * 2, insets.bottom, 0);
        DialogUtil.addUsingGBL(this.mPlotDimPanel, this.mPlotDimLoDim, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this.mPlotDimPanel, (JComponent)this.mPlotDimLoDimEdit, gridBagConstraints, 1, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this.mPlotDimPanel, this.mPlotDimHiDim, gridBagConstraints, 0, 3, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this.mPlotDimPanel, (JComponent)this.mPlotDimHiDimEdit, gridBagConstraints, 1, 3, 1, 1, n, insets);
        return this.mPlotDimPanel;
    }

    private JPanel setupSuppObjectsPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, 0, 0);
        DialogUtil.addUsingGBL(this.mSuppObjectsPanel, this.mRangeOfCasesRadio, gridBagConstraints, 0, 0, 3, 1, n, insets);
        insets.set(0, 40, 0, 0);
        DialogUtil.addUsingGBL(this.mSuppObjectsPanel, this.mFirstLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        insets.set(0, n2, 0, 0);
        DialogUtil.addUsingGBL(this.mSuppObjectsPanel, (JComponent)this.mFirstTextField, gridBagConstraints, 1, 1, 1, 1, n, insets);
        insets.set(n2, 40, 0, 0);
        DialogUtil.addUsingGBL(this.mSuppObjectsPanel, this.mLastLabel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        insets.set(n2, n2, 0, 0);
        DialogUtil.addUsingGBL(this.mSuppObjectsPanel, (JComponent)this.mLastTextField, gridBagConstraints, 1, 2, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mSuppObjectsPanel, this.mSingleCaseRadio, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(8, n2, 0, DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(this.mSuppObjectsPanel, (JComponent)this.mSingleCaseTextField, gridBagConstraints, 2, 3, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(n2, n2, DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(this.mSuppObjectsPanel, this.mBasicACRWidget, gridBagConstraints, 0, 4, 3, 1, n, insets);
        return this.mSuppObjectsPanel;
    }

    private JPanel setupCriteriaPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, 0, 0);
        DialogUtil.addUsingGBL(this.mCriteriaPanel, this.mConvergenceLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mCriteriaPanel, (JComponent)this.mConvergenceTextField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        insets.set(DialogUtil.getComponentGroupGap(), n2, 0, 0);
        DialogUtil.addUsingGBL(this.mCriteriaPanel, this.mMaximumIterationsLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(DialogUtil.getComponentGroupGap(), n2, n2, 0);
        DialogUtil.addUsingGBL(this.mCriteriaPanel, (JComponent)this.mMaximumIterationsTextField, gridBagConstraints, 1, 1, 1, 1, n, insets);
        return this.mCriteriaPanel;
    }

    private JPanel setupLabelPlotsByPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, 0, 0);
        DialogUtil.addUsingGBL(this.mLabelPlotsByPanel, this.mVariableLabelsRadio, gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(0, 35, 0, 0);
        DialogUtil.addUsingGBL(this.mLabelPlotsByPanel, this.mLimitForLengthLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets.set(0, DialogUtil.getComponentGroupGap(), 0, DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(this.mLabelPlotsByPanel, (JComponent)this.mLimitForLengthTextField, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        insets.set(0, n2, 0, 0);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this.mLabelPlotsByPanel, this.mVariableNamesRadio, gridBagConstraints, 0, 2, 1, 1, n, insets);
        return this.mLabelPlotsByPanel;
    }

    protected JPanel setupRotationPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_CATPCA_OPTS_ROTATION_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mNoneRadio, gridBagConstraints, 0, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mVarimaxRadio, gridBagConstraints, 0, 1, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mObliminRadio, gridBagConstraints, 0, 2, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mQuartimaxRadio, gridBagConstraints, 2, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mEquimaxRadio, gridBagConstraints, 2, 1, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mPromaxRadio, gridBagConstraints, 2, 2, 2, 1, n, insets);
        Insets insets2 = new Insets(insets.top, insets.left + 10, insets.bottom, 0);
        n = 12;
        DialogUtil.addUsingGBL(jPanel, this.mKappaLabel, gridBagConstraints, 2, 3, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mDeltaLabel, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        n = 18;
        insets2.left = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mDeltaFloatEdit, gridBagConstraints, 1, 3, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mKappaFloatEdit, gridBagConstraints, 3, 3, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mKaiserCheck, gridBagConstraints, 0, 4, 4, 1, n, insets);
        return jPanel;
    }

    private void setTabTraversal() {
        Component[] componentArray;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSuppObjectsGroup);
        vector.add(this.mFirstTextField);
        vector.add(this.mLastTextField);
        vector.add(this.mSingleCaseTextField);
        Component[] componentArray2 = new Component[3];
        for (int i = 0; i < this.mBasicACRWidget.getComponentCount() - 1; ++i) {
            if (this.mBasicACRWidget.getComponent(i) instanceof JPanel) {
                for (int j = 0; j < ((JPanel)this.mBasicACRWidget.getComponent(i)).getComponentCount(); ++j) {
                    componentArray2[j] = ((JPanel)this.mBasicACRWidget.getComponent(i)).getComponent(j);
                }
                break;
            }
            componentArray2[i] = this.mBasicACRWidget.getComponent(i);
        }
        vector.add(componentArray2[0]);
        vector.add(componentArray2[1]);
        vector.add(componentArray2[2]);
        vector.add(this.mBasicACRWidget.getList());
        vector.add(this.mPlotDimsGroup);
        vector.add(this.mPlotDimLoDimEdit);
        vector.add(this.mPlotDimHiDimEdit);
        vector.add(this.mConfigurationCombo);
        vector.add(this.mConfigFileButton);
        vector.add(this.mNormalizationMethodCombo);
        vector.add(this.mNormCustomValueEdit);
        vector.add(this.mConvergenceTextField);
        vector.add(this.mMaximumIterationsTextField);
        vector.add(this.mLabelPlotsGroup);
        vector.add(this.mLimitForLengthTextField);
        vector.add(this.mRotationGroup);
        vector.add(this.mDeltaFloatEdit);
        vector.add(this.mKappaFloatEdit);
        vector.add(this.mKaiserCheck);
        for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
            vector.add(component);
        }
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(vector, false));
    }
}

