/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.correspond_analysis;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.market_research.correspond_analysis.CorrespondenceAnalysisDlg;
import com.spss.uitools.controls.ContextEnabledTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class CorrespondenceStatistics
extends BaseSubDialog
implements ItemListener,
FocusListener,
DocumentListener {
    public static final String TABEL_KEY = "IDS_CORR_TABLE";
    public static final String ROW_PTS_KEY = "IDS_ROW_POINTS";
    public static final String COL_PTS_KEY = "IDS_COL_POINTS";
    public static final String ROW_PROF_KEY = "IDS_ROW_PROFILE";
    public static final String COL_PROF_KEY = "IDS_COL_PROFILE";
    public static final String PERMUTATION_KEY = "IDS_PERMUTATIONS_CORR";
    public static final String ST_ROW_PTS_KEY = "IDS_STAT_ROW_POINTS";
    public static final String ST_COL_PTS_KEY = "IDS_STAT_COL_POINTS";
    public static final String PERMUTATION_TEXT_KEY = "IDS_PERMUTATION2432423";
    private static final String PERM_DEAFULT_VALUE = "1";
    private JCheckBox mPermutationsCheckBox;
    private JCheckBox mStatRowPointsCheckBox;
    private JCheckBox mStatColPointsCheckBox;
    private JLabel mPermuationLabel;
    private ContextEnabledTextField mPermuationField;
    private JPanel mMainPanel;

    public CorrespondenceStatistics(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, bl);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mPermuationField)) {
            this.mPermuationField.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public String getDialogHelpID() {
        return "idh_cors_stat";
    }

    @Override
    public boolean continuePressed() {
        super.continuePressed();
        if (this.mPermutationsCheckBox.isSelected()) {
            Double d;
            DialogDataModel dialogDataModel = ((CorrespondenceAnalysisDlg)this.mParentDlg).getDialogDataModel();
            String string = dialogDataModel.getString("IDS_DIMENSION_KEY123");
            int n = 2;
            if (string != null) {
                n = Integer.parseInt(string);
            }
            if ((d = Double.valueOf(Double.parseDouble(this.mPermuationField.getText()))) > (double)n) {
                this.showDialog(this.getResString("ERR_STAT_DIM_MSG"));
                this.mPermuationField.setText(new Integer(n).toString());
                return false;
            }
        }
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.mPermuationLabel.setEnabled(this.mPermutationsCheckBox.isSelected());
        this.mPermuationField.setEnabled(this.mPermutationsCheckBox.isSelected());
        this.mPermuationField.setOpaque(this.mPermutationsCheckBox.isSelected());
        if (this.mPermutationsCheckBox.isSelected()) {
            this.enableContinue(this.mPermuationField.getText().length() > 0);
        } else {
            this.enableContinue(true);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.mPermuationField.getText().length() > 0);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.mPermuationField.getText().length() > 0);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.mPermuationField.getText().length() > 0);
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setUpUI(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        if (this.mPermutationsCheckBox.isSelected()) {
            int n;
            DialogDataModel dialogDataModel2 = ((CorrespondenceAnalysisDlg)this.mParentDlg).getDialogDataModel();
            String string = dialogDataModel2.getString("IDS_DIMENSION_KEY123");
            int n2 = 2;
            if (string != null) {
                n2 = Integer.parseInt(string);
            }
            if ((n = Integer.parseInt(this.mPermuationField.getText())) > n2) {
                this.mPermuationField.setText(new Integer(n2).toString());
            }
        }
    }

    private void setFocusTraversalPolicy() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        int n2 = this.mMainPanel.getComponentCount();
        for (n = 0; n < 3; ++n) {
            vector.add(this.mMainPanel.getComponent(n));
        }
        vector.add(this.mPermutationsCheckBox);
        vector.add(this.mPermuationField);
        for (n = 4; n < n2 - 1; ++n) {
            vector.add(this.mMainPanel.getComponent(n));
        }
        vector.add(this.mStatRowPointsCheckBox);
        vector.add(this.mStatColPointsCheckBox);
        n2 = this.mCmdButtonPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            vector.add(this.mCmdButtonPanel.getComponent(n));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setUpUI(JPanel jPanel) {
        JCheckBox jCheckBox = new JCheckBox(new ToggleButtonAction(this, TABEL_KEY));
        JCheckBox jCheckBox2 = new JCheckBox(new ToggleButtonAction(this, ROW_PTS_KEY));
        JCheckBox jCheckBox3 = new JCheckBox(new ToggleButtonAction(this, COL_PTS_KEY));
        JCheckBox jCheckBox4 = new JCheckBox(new ToggleButtonAction(this, ROW_PROF_KEY));
        JCheckBox jCheckBox5 = new JCheckBox(new ToggleButtonAction(this, COL_PROF_KEY));
        jCheckBox.setSelected(true);
        jCheckBox2.setSelected(true);
        jCheckBox3.setSelected(true);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(jCheckBox);
        spssButtonGroup.add(jCheckBox2);
        spssButtonGroup.add(jCheckBox3);
        spssButtonGroup.add(this.mPermutationsCheckBox);
        spssButtonGroup.add(jCheckBox4);
        spssButtonGroup.add(jCheckBox5);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, jCheckBox, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jCheckBox2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jCheckBox3, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.setUpPermutationPanel(), gridBagConstraints, 0, 3, 2, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, jCheckBox4, gridBagConstraints, 0, 4, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jCheckBox5, gridBagConstraints, 0, 5, 1, 1, n, insets);
        insets = new Insets(n2, n2 - 6, 5, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.setUpConfiStatsPanel(), gridBagConstraints, 0, 6, 1, 1, n, insets);
        this.mMainPanel = jPanel;
    }

    private JPanel setUpConfiStatsPanel() {
        JComponent[] jComponentArray = new JComponent[]{this.mStatRowPointsCheckBox, this.mStatColPointsCheckBox};
        JPanel jPanel = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.xaxis, this.getResString("IDS_CONF_STATS"));
        return jPanel;
    }

    private JPanel setUpPermutationPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mPermutationsCheckBox, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        insets = new Insets(0, n2 + 40, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mPermuationLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets = new Insets(0, n2, 0, n2 + 50);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mPermuationField, gridBagConstraints, 1, 1, 1, 1, n, insets);
        return jPanel;
    }

    private void initVars() {
        this.mPermutationsCheckBox = new JCheckBox(new ToggleButtonAction(this, PERMUTATION_KEY));
        this.mPermuationLabel = DialogUtil.createLabel(this, "IDS_MAX_DIMENSION_PER");
        this.mPermuationField = new ContextEnabledTextField();
        this.mPermuationField.setDocument((Document)new FixedLengthNumericDocument(29, true, false));
        this.mPermuationField.setAction((Action)new TextFieldAction(this, "IDS_UPPER_BOUND"));
        this.mPermuationField.setColumns(2);
        this.mPermuationField.addFocusListener((FocusListener)this);
        this.mPermuationField.getDocument().addDocumentListener(this);
        this.mPermuationLabel.setLabelFor((Component)this.mPermuationField);
        this.mPermutationsCheckBox.addItemListener(this);
        this.mPermuationField.setAction((Action)new TextFieldAction(this.mParentDlg, PERMUTATION_TEXT_KEY));
        this.mStatRowPointsCheckBox = new JCheckBox(new ToggleButtonAction(this, ST_ROW_PTS_KEY));
        this.mStatColPointsCheckBox = new JCheckBox(new ToggleButtonAction(this, ST_COL_PTS_KEY));
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mStatRowPointsCheckBox);
        spssButtonGroup.add(this.mStatColPointsCheckBox);
        this.setDefaults();
    }

    private void setDefaults() {
        this.mPermuationLabel.setEnabled(false);
        this.mPermuationField.setEnabled(false);
        this.mPermuationField.setOpaque(false);
        this.mPermuationField.setText(PERM_DEAFULT_VALUE);
    }

    private void showDialog(String string) {
        SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string, VersionInfo.getAppVersionString());
    }
}

