/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.correspond_analysis;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.market_research.correspond_analysis.CorrespondenceAnalysisDlg;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CorrespondencePlots
extends BaseSubDialog
implements ItemListener,
DocumentListener,
FocusListener,
PropertyChangeListener {
    public static final String BIPLOT_KEY = "IDS_BIPLOT";
    public static final String ROW_PTS_KEY = "IDS_ROW_PTS";
    public static final String COL_PTS_KEY = "IDS_COL_PTS";
    public static final String SCATTER_PLOT_KEY = "IDS_SCATTER";
    public static final String TRANS_ROW_KEY = "IDS_TRANS_ROW_CATEG";
    public static final String TRANS_COL_KEY = "IDS_TRANS_COL_CATEG";
    public static final String LINE_PLOT_KEY = "IDS_LINE_PLOT";
    public static final String ALL_DIM_KEY = "IDS_DISPLAY_ALL";
    public static final String RESTRCIT_DIM_KEY = "IDS_RESTRICT_DIM";
    public static final String LOW_DIM_KEY = "IDS_MIN_VALUE88";
    public static final String HIGHEST_DIM_KEY = "IDS_MAX_VALUE88";
    private static final String ID_LINE_PLOTS_DEFAULT = "20";
    private static final String ID_SCATTER_PLOT_DEFAULT = "20";
    private JRadioButton mDisplayAllRadioButton;
    private JRadioButton mRestrictDimRadioButton;
    private SpssButtonGroup mPlotDimGroup;
    private JCheckBox mBiplotCheckBox;
    private JCheckBox mRowPtsCheckBox;
    private JCheckBox mColPtsCheckBox;
    private JCheckBox mTransRowCheckBox;
    private JCheckBox mTransColCheckBox;
    private IntTextField mIdScatterField;
    private IntTextField mIdLineField;
    private IntTextField mLowestField;
    private IntTextField mHighestField;
    private JLabel mIdScatterLabel;
    private JLabel mIdLineLabel;
    private JLabel mLowestLabel;
    private JLabel mHighestLabel;

    public CorrespondencePlots(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, bl);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mIdScatterField)) {
            this.mIdScatterField.selectAll();
        }
        if (focusEvent.getSource().equals(this.mIdLineField)) {
            this.mIdLineField.selectAll();
        }
        if (focusEvent.getSource().equals(this.mLowestField)) {
            this.mLowestField.selectAll();
        }
        if (focusEvent.getSource().equals(this.mHighestField)) {
            this.mHighestField.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public String getDialogHelpID() {
        return "idh_cors_plots";
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.canContinueEnable();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.canContinueEnable();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.canContinueEnable();
    }

    @Override
    public boolean continuePressed() {
        super.continuePressed();
        if (this.mLowestField.isEnabled() && this.mHighestField.isEnabled()) {
            DialogDataModel dialogDataModel = ((CorrespondenceAnalysisDlg)this.mParentDlg).getDialogDataModel();
            String string = dialogDataModel.getString("IDS_DIMENSION_KEY123");
            int n = 2;
            int n2 = -1;
            int n3 = -1;
            if (string != null) {
                n = Integer.parseInt(string);
            }
            int n4 = this.mLowestField.getText().length();
            int n5 = this.mHighestField.getText().length();
            boolean bl = this.isValidNumber(n4, (JTextField)this.mLowestField, n);
            if (!bl) {
                return bl;
            }
            bl = this.isValidNumber(n5, (JTextField)this.mHighestField, n);
            if (!bl) {
                return bl;
            }
            n2 = Integer.parseInt(this.mLowestField.getText());
            if (n2 >= (n3 = Integer.parseInt(this.mHighestField.getText()))) {
                this.showDialog(this.getResString("ERR_INVALID_DIM_MSG"));
                this.mLowestField.grabFocus();
                this.mLowestField.setSelectionStart(0);
                this.mLowestField.setSelectionEnd(this.mLowestField.getText().length());
                return false;
            }
        }
        this.saveState(((BaseProcedureDialog)((Object)this.getParent())).getDialogDataModel());
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mTransColCheckBox || itemEvent.getSource() == this.mTransRowCheckBox) {
            this.mIdLineLabel.setEnabled(this.mTransColCheckBox.isSelected() || this.mTransRowCheckBox.isSelected());
            this.mIdLineField.setEnabled(this.mTransColCheckBox.isSelected() || this.mTransRowCheckBox.isSelected());
            this.mIdLineField.setOpaque(this.mTransColCheckBox.isSelected() || this.mTransRowCheckBox.isSelected());
        } else if (itemEvent.getSource() == this.mBiplotCheckBox || itemEvent.getSource() == this.mRowPtsCheckBox || itemEvent.getSource() == this.mColPtsCheckBox) {
            this.mIdScatterLabel.setEnabled(this.mBiplotCheckBox.isSelected() || this.mRowPtsCheckBox.isSelected() || this.mColPtsCheckBox.isSelected());
            this.mIdScatterField.setEnabled(this.mBiplotCheckBox.isSelected() || this.mRowPtsCheckBox.isSelected() || this.mColPtsCheckBox.isSelected());
            this.mIdScatterField.setOpaque(this.mBiplotCheckBox.isSelected() || this.mRowPtsCheckBox.isSelected() || this.mColPtsCheckBox.isSelected());
        } else if (itemEvent.getSource() == this.mRestrictDimRadioButton) {
            this.mLowestField.setEnabled(this.mRestrictDimRadioButton.isSelected());
            this.mHighestField.setEnabled(this.mRestrictDimRadioButton.isSelected());
            this.mLowestField.setOpaque(this.mRestrictDimRadioButton.isSelected());
            this.mHighestField.setOpaque(this.mRestrictDimRadioButton.isSelected());
            this.mLowestLabel.setEnabled(this.mRestrictDimRadioButton.isSelected());
            this.mHighestLabel.setEnabled(this.mRestrictDimRadioButton.isSelected());
        }
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setDefaults();
        this.setUpUI(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    private void canContinueEnable() {
        if (this.mIdLineField.isEnabled() && this.mIdLineField.getText().length() == 0) {
            this.enableContinue(false);
        } else if (this.mIdScatterField.isEnabled() && this.mIdScatterField.getText().length() == 0) {
            this.enableContinue(false);
        } else if (this.mLowestField.isEnabled() && this.mLowestField.getText().length() == 0) {
            this.enableContinue(false);
        } else if (this.mHighestField.isEnabled() && this.mHighestField.getText().length() == 0) {
            this.enableContinue(false);
        } else {
            this.enableContinue(true);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("enabled")) {
            this.canContinueEnable();
        }
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mBiplotCheckBox);
        vector.add(this.mRowPtsCheckBox);
        vector.add(this.mColPtsCheckBox);
        vector.add(this.mIdScatterField);
        vector.add(this.mTransRowCheckBox);
        vector.add(this.mTransColCheckBox);
        vector.add(this.mIdLineField);
        vector.add(this.mPlotDimGroup);
        vector.add(this.mLowestField);
        vector.add(this.mHighestField);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setUpUI(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.setUpScatterPlotsPanel(), gridBagConstraints, 0, 0, 1, 1, n, null);
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.setUpLinePlotsPanel(), gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.setUpDimensionPanel(), gridBagConstraints, 0, 2, 1, 1, n, insets);
    }

    private JPanel setUpScatterPlotsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_SCATTERPLOTS")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mBiplotCheckBox, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mRowPtsCheckBox, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mColPtsCheckBox, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.setUpIDScatterPanel(), gridBagConstraints, 0, 3, 1, 1, n, null);
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setUpIDScatterPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, n2 - 5, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mIdScatterLabel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        insets = new Insets(n2, 0, n2, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mIdScatterField, gridBagConstraints, 1, 2, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setUpLinePlotsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_LINE_PLOTS")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mTransRowCheckBox, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mTransColCheckBox, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.setUpIDLinePlotsPanel(), gridBagConstraints, 0, 2, 1, 1, n, null);
        DialogUtil.createButtonGroup(jPanel);
        return jPanel;
    }

    private JPanel setUpIDLinePlotsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap() - 5, DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap());
        DialogUtil.addUsingGBL(jPanel, this.mIdLineLabel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        insets = new Insets(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap() - 2, DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mIdLineField, gridBagConstraints, 1, 2, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setUpDimensionPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_PLOT_DIMENSIONS")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mDisplayAllRadioButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mRestrictDimRadioButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.setUpDimPanel(), gridBagConstraints, 0, 2, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setUpDimPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, n2 + 5, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mLowestLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets = new Insets(n2, 0, n2, n2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mLowestField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        insets = new Insets(0, n2 + 5, n2, 0);
        DialogUtil.addUsingGBL(jPanel, this.mHighestLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets = new Insets(0, 0, n2, n2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mHighestField, gridBagConstraints, 1, 1, 1, 1, n, insets);
        return jPanel;
    }

    private void initVars() {
        this.mDisplayAllRadioButton = new JRadioButton(new ToggleButtonAction(this, ALL_DIM_KEY));
        this.mRestrictDimRadioButton = new JRadioButton(new ToggleButtonAction(this, RESTRCIT_DIM_KEY));
        this.mBiplotCheckBox = new JCheckBox(new ToggleButtonAction(this, BIPLOT_KEY));
        this.mBiplotCheckBox.addItemListener(this);
        this.mRowPtsCheckBox = new JCheckBox(new ToggleButtonAction(this, ROW_PTS_KEY));
        this.mRowPtsCheckBox.addItemListener(this);
        this.mColPtsCheckBox = new JCheckBox(new ToggleButtonAction(this, COL_PTS_KEY));
        this.mColPtsCheckBox.addItemListener(this);
        this.mTransRowCheckBox = new JCheckBox(new ToggleButtonAction(this, TRANS_ROW_KEY));
        this.mTransRowCheckBox.addItemListener(this);
        this.mTransColCheckBox = new JCheckBox(new ToggleButtonAction(this, TRANS_COL_KEY));
        this.mTransColCheckBox.addItemListener(this);
        this.mIdScatterField = new IntTextField(0, 60, true);
        this.mIdScatterField.addFocusListener((FocusListener)this);
        this.mIdLineField = new IntTextField(0, 20, true);
        this.mIdLineField.addFocusListener((FocusListener)this);
        this.mLowestField = new IntTextField(1, 98, true);
        FocusListener[] focusListenerArray = this.mLowestField.getFocusListeners();
        if (focusListenerArray != null) {
            for (FocusListener focusListener : focusListenerArray) {
                if (!(focusListener instanceof IntTextField)) continue;
                this.mLowestField.removeFocusListener(focusListener);
            }
        }
        this.mLowestField.addFocusListener((FocusListener)this);
        this.mHighestField = new IntTextField(2, 99, true);
        focusListenerArray = this.mHighestField.getFocusListeners();
        if (focusListenerArray != null) {
            for (FocusListener focusListener : focusListenerArray) {
                if (!(focusListener instanceof IntTextField)) continue;
                this.mHighestField.removeFocusListener(focusListener);
            }
        }
        this.mHighestField.addFocusListener((FocusListener)this);
        this.mLowestField.setColumns(5);
        this.mHighestField.setColumns(5);
        this.mIdLineField.setColumns(5);
        this.mIdScatterField.setColumns(5);
        this.mIdLineLabel = new JLabel(this.getResString("IDS_ID_LINE_PLOTS"));
        this.mIdScatterLabel = new JLabel(this.getResString("IDS_ID_SCATTERPLOT"));
        this.mLowestLabel = DialogUtil.createLabel(this, "IDS_LOWEST_DIM");
        this.mHighestLabel = DialogUtil.createLabel(this, "IDS_HIGHEST_DIM");
        this.mLowestLabel.setLabelFor((Component)this.mLowestField);
        this.mHighestLabel.setLabelFor((Component)this.mHighestField);
        this.mLowestField.setAction((Action)new TextFieldAction(this.mParentDlg, LOW_DIM_KEY));
        this.mHighestField.setAction((Action)new TextFieldAction(this.mParentDlg, HIGHEST_DIM_KEY));
        this.mIdLineField.setAction((Action)new TextFieldAction(this.mParentDlg, LINE_PLOT_KEY));
        this.mIdScatterField.setAction((Action)new TextFieldAction(this.mParentDlg, SCATTER_PLOT_KEY));
        this.mPlotDimGroup = new SpssButtonGroup();
        this.mPlotDimGroup.add(this.mDisplayAllRadioButton);
        this.mPlotDimGroup.add(this.mRestrictDimRadioButton);
        this.mIdScatterField.getDocument().addDocumentListener(this);
        this.mIdLineField.getDocument().addDocumentListener(this);
        this.mLowestField.getDocument().addDocumentListener(this);
        this.mHighestField.getDocument().addDocumentListener(this);
        this.mDisplayAllRadioButton.addItemListener(this);
        this.mRestrictDimRadioButton.addItemListener(this);
        this.mIdLineField.addPropertyChangeListener((PropertyChangeListener)this);
        this.mIdScatterField.addPropertyChangeListener((PropertyChangeListener)this);
        this.mLowestField.addPropertyChangeListener((PropertyChangeListener)this);
        this.mHighestField.addPropertyChangeListener((PropertyChangeListener)this);
    }

    private void showDialog(String string) {
        SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string, VersionInfo.getAppVersionString());
    }

    private void setDefaults() {
        this.mBiplotCheckBox.setSelected(true);
        this.mDisplayAllRadioButton.setSelected(true);
        this.mIdLineLabel.setEnabled(false);
        this.mIdScatterLabel.setEnabled(true);
        this.mIdLineField.setEnabled(false);
        this.mIdLineField.setOpaque(false);
        this.mLowestField.setEnabled(false);
        this.mHighestField.setEnabled(false);
        this.mLowestLabel.setEnabled(false);
        this.mHighestLabel.setEnabled(false);
        this.mLowestField.setOpaque(false);
        this.mHighestField.setOpaque(false);
        this.mIdLineField.setText("20");
        this.mIdScatterField.setEnabled(true);
        this.mIdScatterField.setText("20");
        DialogDataModel dialogDataModel = ((CorrespondenceAnalysisDlg)this.mParentDlg).getDialogDataModel();
        Boolean bl = dialogDataModel.getBoolean("IDS_PRINCIPAL");
        if (bl != null && bl.booleanValue()) {
            this.mBiplotCheckBox.setEnabled(false);
        } else {
            this.mBiplotCheckBox.setEnabled(true);
        }
    }

    private boolean isValidNumber(int n, JTextField jTextField, int n2) {
        try {
            boolean bl;
            if (n == 0) {
                this.showDialog(this.getResString("ERR_INVALID_DIM_MSG"));
                jTextField.requestFocus();
                return false;
            }
            int n3 = Integer.parseInt(jTextField.getText());
            boolean bl2 = jTextField == this.mHighestField ? n3 > n2 : (bl = n3 >= n2);
            if (n3 == 0 || bl) {
                this.showDialog(this.getResString("ERR_INVALID_DIM_MSG"));
                jTextField.grabFocus();
                jTextField.setSelectionStart(0);
                jTextField.setSelectionEnd(jTextField.getText().length());
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            this.showDialog(this.getResString("ERR_INVALID_DIM_MSG"));
            jTextField.grabFocus();
            jTextField.setSelectionStart(0);
            jTextField.setSelectionEnd(jTextField.getText().length());
            return false;
        }
    }
}

