/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.correspond_analysis;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.market_research.correspond_analysis.CorrespondenceAnalysisDlg;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CorrespondenceModel
extends BaseSubDialog
implements ItemListener,
DocumentListener,
FocusListener {
    static final String DIMENSION_KEY = "IDS_DIMENSION_KEY123";
    static final String CHI_SQUARE_KEY = "IDS_CHI_SQUARE";
    static final String EUCLIDEAN_KEY = "IDS_ECLIDEAN_MODEL";
    static final String RNC_REMOVED_KEY = "IDS_RNC_REMOVED";
    static final String ROW_REMOVED_KEY = "IDS_ROW_REMOVED";
    static final String COL_REMOVED_KEY = "IDS_COL_REMOVED";
    static final String ROW_TOTAL_KEY = "IDS_ROW_EQUALIZED";
    static final String COL_TOTAL_KEY = "IDS_COL_EQUALIZED";
    static final String SYMMETRICAL_KEY = "IDS_SYMMETRICAL";
    static final String ROW_PRIN_KEY = "IDS_ROW_PRINCIPAL";
    static final String COL_PRIN_KEY = "IDS_COL_PRINCIPAL";
    static final String PRINCIPAL_KEY = "IDS_PRINCIPAL";
    static final String CUSTOM_KEY = "IDS_CUSTOM";
    static final String CUSTOM_VALUE_KEY = "IDS_CUSTOM_VALUE";
    private static final String DIMENSION_DEFAULT_VALUE = "2";
    private static final String CUSTOM_DEAFAULT_VALUE = "0";
    private JRadioButton mChiSquareRadioButton;
    private JRadioButton mEuclideanRadioButton;
    private JRadioButton mRNCRemovedRadioButton;
    private JRadioButton mRowRemovedRadioButton;
    private JRadioButton mColRemovdRadioButton;
    private JRadioButton mRowTotalsRadioButton;
    private JRadioButton mColTotalsRadioButton;
    private JRadioButton mSymmetricalRadioButton;
    private JRadioButton mRowPrincipalRadioButton;
    private JRadioButton mCustomRadioButton;
    private JRadioButton mPrincipalRadioButton;
    private JRadioButton mColPrincipalRadioButton;
    private SpssButtonGroup mDistanceGroup;
    private SpssButtonGroup mStandardizeGroup;
    private SpssButtonGroup mNormGroup;
    private IntTextField mDimensionsField;
    private FloatTextField mCustomField;

    public CorrespondenceModel(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, bl);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_cors_model";
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mDimensionsField)) {
            this.mDimensionsField.selectAll();
        }
        if (focusEvent.getSource().equals(this.mCustomField)) {
            this.mCustomField.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.mDimensionsField.getText().length() > 0 && this.mCustomField.getText().length() > 0);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.mDimensionsField.getText().length() > 0 && this.mCustomField.getText().length() > 0);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinue(this.mDimensionsField.getText().length() > 0 && this.mCustomField.getText().length() > 0);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.mCustomField.setEnabled(this.mCustomRadioButton.isSelected());
        this.mCustomField.setOpaque(this.mCustomRadioButton.isSelected());
        this.mRowRemovedRadioButton.setEnabled(this.mEuclideanRadioButton.isSelected());
        this.mColRemovdRadioButton.setEnabled(this.mEuclideanRadioButton.isSelected());
        this.mRowTotalsRadioButton.setEnabled(this.mEuclideanRadioButton.isSelected());
        this.mColTotalsRadioButton.setEnabled(this.mEuclideanRadioButton.isSelected());
        if (this.mChiSquareRadioButton.isSelected()) {
            this.mRNCRemovedRadioButton.setSelected(true);
        }
    }

    @Override
    public boolean continuePressed() {
        int n;
        String string;
        int n2;
        super.continuePressed();
        DialogDataModel dialogDataModel = ((CorrespondenceAnalysisDlg)this.mParentDlg).getDialogDataModel();
        Boolean bl = dialogDataModel.getBoolean("IDS_RESTRICT_DIM");
        if (bl != null && bl.booleanValue() && (n2 = Integer.parseInt(string = dialogDataModel.getString("IDS_MAX_VALUE88"))) > (n = Integer.parseInt(this.mDimensionsField.getText()))) {
            int n3 = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_MODEL_WARNING_MESSAGE"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
            if (n3 == 0) {
                dialogDataModel.putBoolean("IDS_DISPLAY_ALL", true);
                dialogDataModel.putBoolean("IDS_RESTRICT_DIM", null);
                return true;
            }
            this.mDimensionsField.grabFocus();
            this.mDimensionsField.setSelectionStart(0);
            this.mDimensionsField.setSelectionEnd(this.mDimensionsField.getText().length());
            return false;
        }
        return true;
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setDefaults();
        this.setUpUI(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mDimensionsField);
        vector.add(this.mDistanceGroup);
        vector.add(this.mStandardizeGroup);
        vector.add(this.mNormGroup);
        vector.add(this.mCustomField);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setUpUI(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        DialogUtil.addUsingGBL(jPanel, this.setUpDimensionPanel(), gridBagConstraints, 0, 0, 1, 1, n, null);
        Insets insets = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.setUpDistanceMeasurePanel(), gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.setUpStandardizePanel(), gridBagConstraints, 0, 2, 1, 1, n, insets);
        insets = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.setUpNormalizationPanel(), gridBagConstraints, 0, 3, 1, 1, n, insets);
    }

    private JPanel setUpDistanceMeasurePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_DIS_MEASURE")));
        this.mDistanceGroup.add(this.mChiSquareRadioButton);
        this.mDistanceGroup.add(this.mEuclideanRadioButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mChiSquareRadioButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mEuclideanRadioButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setUpStandardizePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_STAND_METHOD")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mRNCRemovedRadioButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mRowRemovedRadioButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mColRemovdRadioButton, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mRowTotalsRadioButton, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mColTotalsRadioButton, gridBagConstraints, 0, 4, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setUpNormalizationPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_NORM_METHOD")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mSymmetricalRadioButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mRowPrincipalRadioButton, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mCustomRadioButton, gridBagConstraints, 3, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mCustomField, gridBagConstraints, 4, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mPrincipalRadioButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mColPrincipalRadioButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setUpDimensionPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_DIMENSIONS_SOL");
        jLabel.setLabelFor((Component)this.mDimensionsField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n2 - 4, 0, n2);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets = new Insets(0, n2, 0, n2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mDimensionsField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private void initVars() {
        this.mChiSquareRadioButton = new JRadioButton(new ToggleButtonAction(this, CHI_SQUARE_KEY));
        this.mEuclideanRadioButton = new JRadioButton(new ToggleButtonAction(this, EUCLIDEAN_KEY));
        this.mRNCRemovedRadioButton = new JRadioButton(new ToggleButtonAction(this, RNC_REMOVED_KEY));
        this.mRowRemovedRadioButton = new JRadioButton(new ToggleButtonAction(this, ROW_REMOVED_KEY));
        this.mColRemovdRadioButton = new JRadioButton(new ToggleButtonAction(this, COL_REMOVED_KEY));
        this.mRowTotalsRadioButton = new JRadioButton(new ToggleButtonAction(this, ROW_TOTAL_KEY));
        this.mColTotalsRadioButton = new JRadioButton(new ToggleButtonAction(this, COL_TOTAL_KEY));
        this.mSymmetricalRadioButton = new JRadioButton(new ToggleButtonAction(this, SYMMETRICAL_KEY));
        this.mRowPrincipalRadioButton = new JRadioButton(new ToggleButtonAction(this, ROW_PRIN_KEY));
        this.mCustomRadioButton = new JRadioButton(new ToggleButtonAction(this, CUSTOM_KEY));
        this.mPrincipalRadioButton = new JRadioButton(new ToggleButtonAction(this, PRINCIPAL_KEY));
        this.mColPrincipalRadioButton = new JRadioButton(new ToggleButtonAction(this, COL_PRIN_KEY));
        this.mDimensionsField = new IntTextField(1, 99, true);
        this.mDimensionsField.addFocusListener((FocusListener)this);
        this.mDimensionsField.setColumns(2);
        this.mCustomField = new FloatTextField(-1.0, 1.0, 15, false);
        this.mCustomField.setColumns(5);
        this.mCustomField.addFocusListener((FocusListener)this);
        this.mDistanceGroup = new SpssButtonGroup();
        this.mStandardizeGroup = new SpssButtonGroup();
        this.mNormGroup = new SpssButtonGroup();
        this.mDimensionsField.getDocument().addDocumentListener(this);
        this.mCustomField.getDocument().addDocumentListener(this);
        this.mEuclideanRadioButton.addItemListener(this);
        this.mChiSquareRadioButton.addItemListener(this);
        this.mCustomRadioButton.addItemListener(this);
        this.mDimensionsField.setAction((Action)new TextFieldAction(this.mParentDlg, DIMENSION_KEY));
        this.mCustomField.setAction((Action)new TextFieldAction(this.mParentDlg, CUSTOM_VALUE_KEY));
        this.mNormGroup.add(this.mSymmetricalRadioButton);
        this.mNormGroup.add(this.mPrincipalRadioButton);
        this.mNormGroup.add(this.mRowPrincipalRadioButton);
        this.mNormGroup.add(this.mColPrincipalRadioButton);
        this.mNormGroup.add(this.mCustomRadioButton);
        this.mStandardizeGroup.add(this.mRNCRemovedRadioButton);
        this.mStandardizeGroup.add(this.mRowRemovedRadioButton);
        this.mStandardizeGroup.add(this.mColRemovdRadioButton);
        this.mStandardizeGroup.add(this.mRowTotalsRadioButton);
        this.mStandardizeGroup.add(this.mColTotalsRadioButton);
    }

    private void setDefaults() {
        this.mRNCRemovedRadioButton.setSelected(true);
        this.mChiSquareRadioButton.setSelected(true);
        this.mSymmetricalRadioButton.setSelected(true);
        this.mCustomField.setEnabled(false);
        this.mCustomField.setOpaque(false);
        this.mRowRemovedRadioButton.setEnabled(false);
        this.mColRemovdRadioButton.setEnabled(false);
        this.mRowTotalsRadioButton.setEnabled(false);
        this.mColTotalsRadioButton.setEnabled(false);
        this.mCustomField.setText(CUSTOM_DEAFAULT_VALUE);
        this.mDimensionsField.setText(DIMENSION_DEFAULT_VALUE);
        this.mDimensionsField.setSelectionStart(0);
        this.mDimensionsField.setSelectionEnd(this.mDimensionsField.getText().length());
        this.mDimensionsField.requestFocus();
    }
}

