/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.correspond_analysis;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.SerializableList;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.market_research.correspond_analysis.CorrespondenceAnalysisDlg;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;

public class CorrespondenceDefineColRange
extends BaseSubDialog
implements ActionListener,
DocumentListener,
ItemListener,
ListSelectionListener {
    public static final String MIN_VALUE_KEY = "IDS_MIN_VALUE_COL324";
    public static final String MAX_VALUE_KEY = "IDS_MAX_VALUE_COL324";
    public static final String IDS_COL_CONS_LIST = "IDS_COL_CONS_LIST";
    public static final String IDS_NONE_COL_CONSTR = "IDS_COL_NONE_CONS";
    public static final String IDS_EQUAL_COL_CONSTR = "IDS_COL_CATEGORY_EQ";
    public static final String IDS_SUPP_COL_CONSTR = "IDS_COL_CATEGORY_SUPP";
    private JLabel mMinValueLabel;
    private JLabel mMaxValueLabel;
    private IntTextField mMinValueField;
    private IntTextField mMaxValueField;
    private JButton mUpdateButton;
    private SerializableList mConstraintsList;
    private JScrollPane mConstraintScrollpane;
    private JRadioButton mNoneRadioButton;
    private JRadioButton mCategoryEqualRadioButton;
    private JRadioButton mCategorySupplementalRadioButton;
    private DefaultListModel mListModel;
    private SpssButtonGroup mRadiogroup;
    private int mFlagComponents = 0;
    private int mFlagContinue = 0;
    private Map<String, String> mMap;

    public CorrespondenceDefineColRange(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, bl);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_cors_crange";
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton(documentEvent);
        this.updateComponents(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton(documentEvent);
        this.updateComponents(documentEvent);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateContinueButton(documentEvent);
        this.updateComponents(documentEvent);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.mUpdateButton)) {
            int n = 0;
            int n2 = 0;
            if (this.mMinValueField.getText().length() > 0) {
                n = Integer.parseInt(this.mMinValueField.getText());
            }
            if (this.mMaxValueField.getText().length() > 0) {
                n2 = Integer.parseInt(this.mMaxValueField.getText());
            }
            if (n == n2) {
                this.showDialog(this.getResString("ERR_RANGE_EQUAL_MSG"));
            } else if (n > n2) {
                this.showDialog(this.getResString("ERR_OUT_OF_RANGE_MSG"));
            } else if (n2 - n > 3000) {
                this.showDialog(this.getResString("ERR_OUT_OF_LIMIT_MSG"));
            } else {
                if (this.mListModel.getSize() > 0) {
                    int n3;
                    String string = this.mListModel.getElementAt(0).toString();
                    String string2 = this.mListModel.getElementAt(this.mListModel.getSize() - 1).toString();
                    if (string.endsWith(this.getResString("IDS_DOT_EQUAL")) || string.endsWith(this.getResString("IDS_DOT_SUPPLEMENTAL"))) {
                        string = string.substring(0, string.indexOf(":"));
                    }
                    if (string2.endsWith(this.getResString("IDS_DOT_EQUAL")) || string2.endsWith(this.getResString("IDS_DOT_SUPPLEMENTAL"))) {
                        string2 = string2.substring(0, string2.indexOf(":"));
                    }
                    DefaultListModel defaultListModel = new DefaultListModel();
                    for (n3 = 0; n3 < this.mListModel.getSize(); ++n3) {
                        defaultListModel.add(n3, this.mListModel.get(n3));
                    }
                    this.mListModel.removeAllElements();
                    int n4 = Integer.parseInt(string);
                    int n5 = Integer.parseInt(string2);
                    n3 = 0;
                    if (n <= n4 && n2 <= n5) {
                        int n6;
                        if (n < n4) {
                            for (n6 = n; n6 < n4; ++n6) {
                                this.mListModel.add(n3, n6);
                                ++n3;
                            }
                        }
                        int n7 = 0;
                        for (n6 = n4; n6 <= n2; ++n6) {
                            this.mListModel.add(n3, defaultListModel.get(n7));
                            ++n3;
                            ++n7;
                        }
                    } else if (n >= n4 && n2 >= n5) {
                        int n8;
                        int n9 = n - n4;
                        for (n8 = n; n8 <= n5; ++n8) {
                            this.mListModel.add(n3, defaultListModel.get(n9));
                            ++n9;
                            ++n3;
                        }
                        if (n2 > n5) {
                            for (n8 = n5 + 1; n8 <= n2; ++n8) {
                                this.mListModel.add(n3, n8);
                                ++n3;
                            }
                        }
                    } else if (n < n4 && n2 > n2) {
                        int n10;
                        for (n10 = n; n10 < n4; ++n10) {
                            this.mListModel.add(n3, n10);
                            ++n3;
                        }
                        int n11 = 0;
                        for (n10 = n4; n10 <= n5; ++n10) {
                            this.mListModel.add(n3, defaultListModel.get(n11));
                            ++n11;
                            ++n3;
                        }
                        for (n10 = n5 + 1; n10 <= n2; ++n10) {
                            this.mListModel.add(n3, n10);
                            ++n3;
                        }
                    } else {
                        for (int i = n; i <= n2; ++i) {
                            this.mListModel.addElement(i);
                        }
                    }
                } else {
                    for (int i = n; i <= n2; ++i) {
                        this.mListModel.addElement(i);
                    }
                }
                this.mConstraintsList.setSelectedIndex(0);
                this.enableComponents(true);
            }
            this.enableContinue(this.mMinValueField.getText().length() >= 0 && this.mMaxValueField.getText().length() > 0 && this.mListModel.getSize() > 0);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        String string;
        int n = this.mConstraintsList.getSelectedIndex();
        String string2 = null;
        int n2 = -1;
        if (this.mListModel.getSize() > 0 && n != -1) {
            string2 = this.mListModel.get(n).toString();
            n2 = string2.indexOf(":");
        }
        if (this.mCategoryEqualRadioButton.isSelected()) {
            if (this.mListModel.getSize() > 1 && n != -1) {
                if (n2 != -1) {
                    string2 = string2.substring(0, n2);
                }
                string = string2 + this.getResString("IDS_DOT_EQUAL");
                this.mMap.put(string2, string);
                this.mListModel.setElementAt(string, n);
            }
            if (this.mListModel.getSize() == 0) {
                this.mListModel.insertElementAt(this.getResString("IDS_DOT_EQUAL"), 0);
            }
            if (this.mListModel.getSize() == 1) {
                this.mListModel.setElementAt(this.getResString("IDS_DOT_EQUAL"), 0);
            }
        }
        if (this.mNoneRadioButton.isSelected()) {
            if (this.mListModel.getSize() > 1 && n != -1) {
                if (n2 != -1) {
                    string2 = string2.substring(0, n2);
                }
                this.mMap.put(string2, null);
                this.mListModel.setElementAt(string2, n);
            }
            if (this.mListModel.getSize() == 1) {
                this.mListModel.remove(0);
            }
        }
        if (this.mCategorySupplementalRadioButton.isSelected()) {
            if (this.mListModel.getSize() > 1 && n != -1) {
                if (n2 != -1) {
                    string2 = string2.substring(0, n2);
                }
                string = string2 + this.getResString("IDS_DOT_SUPPLEMENTAL");
                this.mMap.put(string2, string);
                this.mListModel.setElementAt(string, n);
            }
            if (this.mListModel.getSize() == 0) {
                this.mListModel.insertElementAt(this.getResString("IDS_DOT_SUPPLEMENTAL"), 0);
            }
            if (this.mListModel.getSize() == 1) {
                this.mListModel.setElementAt(this.getResString("IDS_DOT_SUPPLEMENTAL"), 0);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource().equals(this.mConstraintsList) && this.mConstraintsList.getSelectedValue() != null) {
            String string = this.mConstraintsList.getSelectedValue().toString();
            String string2 = string.substring(1);
            if (string2.equals(this.getResString("IDS_DOT_EQUAL"))) {
                this.mCategoryEqualRadioButton.setSelected(true);
            } else if (string2.equals(this.getResString("IDS_DOT_SUPPLEMENTAL"))) {
                this.mCategorySupplementalRadioButton.setSelected(true);
            } else {
                this.mNoneRadioButton.setSelected(true);
            }
        }
    }

    @Override
    public boolean continuePressed() {
        super.continuePressed();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = Integer.parseInt(this.mMinValueField.getText());
        int n5 = Integer.parseInt(this.mMaxValueField.getText());
        for (int i = n4; i <= n5; ++i) {
            String string = Integer.toString(i);
            String string2 = this.mMap.get(string);
            if (string2 != null) {
                int n6 = string2.length();
                int n7 = string2.indexOf(":");
                if (n7 == -1) continue;
                String string3 = string2.substring(n7 + 1, n6);
                if (string3.equals(this.getResString("IDS_DOT_EQUAL").substring(1))) {
                    ++n;
                }
                if (!string3.equals(this.getResString("IDS_DOT_SUPPLEMENTAL").substring(1))) continue;
                ++n2;
                continue;
            }
            ++n3;
        }
        if (n == 1) {
            this.showDialog(this.getResString("ERR_EQUAL_CONS_TWO"));
            return false;
        }
        if (n > 1 && n3 == 0) {
            this.showDialog(this.getResString("ERR_EQUAL_CONS_ONE"));
            return false;
        }
        if (n2 >= 1 && n3 <= 1 && n < 2) {
            this.showDialog(this.getResString("ERR_EQUAL_NOT_CONS_TWO"));
            return false;
        }
        ((CorrespondenceAnalysisDlg)this.mParentDlg).setColRange(this.mMinValueField.getText(), this.mMaxValueField.getText());
        return true;
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setUpUI(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    private void setUpUI(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, this.setUpCategoryRangePanel(), gridBagConstraints, 0, 0, 1, 1, n, null);
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.setUpCategoryConstraintsPanel(), gridBagConstraints, 0, 1, 1, 1, n, insets);
    }

    private JPanel setUpCategoryRangePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        ISpssVariable[] iSpssVariableArray = this.mParentDlg.getDialogDataModel().getVarArray("IDS_COL_TARGET_VAR_KEY");
        ISpssVariable iSpssVariable = iSpssVariableArray[0];
        String string = this.getResString("IDS_COL_CATEGORY_RANGE") + "  " + iSpssVariable.getName();
        jPanel.setBorder(BorderFactory.createTitledBorder(string));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mMinValueLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets = new Insets(0, n2 + 25, 0, 0);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMinValueField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        insets = new Insets(n2, n2, 0, n2);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mMaxValueLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets = new Insets(n2, n2 + 25, n2, 0);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mMaxValueField, gridBagConstraints, 1, 1, 1, 1, n, insets);
        insets = new Insets(n2 + 5, n2 + 25, 0, n2 + 30);
        DialogUtil.addUsingGBL(jPanel, this.mUpdateButton, gridBagConstraints, 2, 0, 1, 2, n, insets);
        return jPanel;
    }

    private JPanel setUpCategoryConstraintsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_COL_CATEGORY_CONS")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n2, n2, 0);
        DialogUtil.addUsingGBL(jPanel, this.mConstraintScrollpane, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets = new Insets(0, n2, n2, n2 + 10);
        n = 10;
        DialogUtil.addUsingGBL(jPanel, this.setUpCategoryPanel(), gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setUpCategoryPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mNoneRadioButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mCategoryEqualRadioButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mCategorySupplementalRadioButton, gridBagConstraints, 0, 2, 1, 1, n, insets);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mMinValueField);
        vector.add(this.mMaxValueField);
        vector.add(this.mUpdateButton);
        vector.add(this.mConstraintsList);
        vector.add(this.mRadiogroup);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void initVars() {
        this.mListModel = new DefaultListModel();
        this.mMinValueLabel = DialogUtil.createLabel(this, "IDS_COL_MIN_VALUE_DOT");
        this.mMaxValueLabel = DialogUtil.createLabel(this, "IDS_COL_MAX_VALUE_DOT");
        this.mMinValueField = new IntTextField(-999999, 9999999, false);
        this.mMaxValueField = new IntTextField(-999999, 9999999, false);
        this.mMaxValueField.setColumns(6);
        this.mMinValueField.setColumns(6);
        this.mMinValueLabel.setLabelFor((Component)this.mMinValueField);
        this.mMaxValueLabel.setLabelFor((Component)this.mMaxValueField);
        this.mUpdateButton = new JButton(new ToggleButtonAction(this, "IDS_COL_UPDATE"));
        this.mConstraintsList = new SerializableList(IDS_COL_CONS_LIST);
        this.mConstraintsList.setModel(this.mListModel);
        this.mConstraintScrollpane = new JScrollPane(this.mConstraintsList);
        Dimension dimension = this.mConstraintsList.getMinimumSize();
        dimension.width += 60;
        dimension.height += 130;
        this.mConstraintScrollpane.setPreferredSize(dimension);
        this.mNoneRadioButton = new JRadioButton(new ToggleButtonAction(this, IDS_NONE_COL_CONSTR));
        this.mCategoryEqualRadioButton = new JRadioButton(new ToggleButtonAction(this, IDS_EQUAL_COL_CONSTR));
        this.mCategorySupplementalRadioButton = new JRadioButton(new ToggleButtonAction(this, IDS_SUPP_COL_CONSTR));
        this.mMinValueField.getDocument().addDocumentListener(this);
        this.mMaxValueField.getDocument().addDocumentListener(this);
        this.mMinValueField.getDocument().putProperty("name", "minValue");
        this.mMaxValueField.getDocument().putProperty("name", "maxValue");
        this.mMinValueField.setAction((Action)new TextFieldAction(this.mParentDlg, MIN_VALUE_KEY));
        this.mMaxValueField.setAction((Action)new TextFieldAction(this.mParentDlg, MAX_VALUE_KEY));
        this.mUpdateButton.addActionListener(this);
        this.mNoneRadioButton.setSelected(true);
        this.mNoneRadioButton.addItemListener(this);
        this.mCategoryEqualRadioButton.addItemListener(this);
        this.mCategorySupplementalRadioButton.addItemListener(this);
        this.mConstraintsList.addListSelectionListener(this);
        this.mMap = new HashMap<String, String>();
        this.mRadiogroup = new SpssButtonGroup();
        this.mRadiogroup.add(this.mNoneRadioButton);
        this.mRadiogroup.add(this.mCategoryEqualRadioButton);
        this.mRadiogroup.add(this.mCategorySupplementalRadioButton);
        this.enableContinue();
    }

    private void enableContinue() {
        DialogDataModel dialogDataModel = this.mParentDlg.getDialogDataModel();
        String string = dialogDataModel.getString(MIN_VALUE_KEY);
        String string2 = dialogDataModel.getString(MAX_VALUE_KEY);
        if (string == null && string2 == null) {
            this.enableContinue(false);
        } else if (this.mFlagContinue < 2) {
            ++this.mFlagContinue;
            this.enableContinue(true);
        }
    }

    private void updateContinueButton(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        if (document.getProperty("name").equals("minValue") || document.getProperty("name").equals("maxValue")) {
            this.enableContinue(false);
            this.enableContinue();
        }
    }

    private void updateComponents(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        DialogDataModel dialogDataModel = this.mParentDlg.getDialogDataModel();
        String string = dialogDataModel.getString(MIN_VALUE_KEY);
        String string2 = dialogDataModel.getString(MAX_VALUE_KEY);
        if (document.getProperty("name").equals("minValue") || document.getProperty("name").equals("maxValue")) {
            if (string != null && string2 != null && this.mFlagComponents < 2) {
                ++this.mFlagComponents;
                this.enableComponents(true);
            } else {
                this.enableComponents(false);
            }
        }
    }

    private void enableComponents(boolean bl) {
        this.mNoneRadioButton.setEnabled(bl);
        this.mCategoryEqualRadioButton.setEnabled(bl);
        this.mCategorySupplementalRadioButton.setEnabled(bl);
        this.mConstraintsList.setEnabled(bl);
        this.mConstraintScrollpane.setEnabled(bl);
    }

    private void showDialog(String string) {
        SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string, VersionInfo.getAppVersionString());
    }
}

