/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research.correspond_analysis;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.CustomVarListCellRenderer;
import com.spss.java_client.ui.controls.CustomVarListModel;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssVarFilter;
import com.spss.java_client.ui.controls.SpssVarFormatter;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.controls.TargetVariableList;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.market_research.correspond_analysis.CorrespondenceDefineColRange;
import com.spss.java_client.ui.dialogs.market_research.correspond_analysis.CorrespondenceDefineRowRange;
import com.spss.java_client.ui.dialogs.market_research.correspond_analysis.CorrespondenceModel;
import com.spss.java_client.ui.dialogs.market_research.correspond_analysis.CorrespondencePlots;
import com.spss.java_client.ui.dialogs.market_research.correspond_analysis.CorrespondenceStatistics;
import com.spss.java_client.ui.dialogs.market_research.res.MarketResearchResBundle;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CorrespondenceAnalysisDlg
extends BaseProcedureDialog
implements ListDataListener,
ActionListener,
ListSelectionListener,
FocusListener {
    public static final String TARGET_ROW_VAR_LIST_KEY = "IDS_ROW_TARGET_VAR_KEY";
    public static final String TARGET_COL_VAR_LIST_KEY = "IDS_COL_TARGET_VAR_KEY";
    private SrcVariableList mSrcVarList;
    private TargetVariableList mRowTargetVarList;
    private TargetVariableList mColTargetVarList;
    private JScrollPane mSrcScrollPane;
    private JScrollPane mRowTargetScrollPane;
    private JScrollPane mColTargetScrollPane;
    private ArrowButton mRowArrowButton;
    private ArrowButton mColArrowButton;
    private JButton mRowDefineButton;
    private JButton mColDefineButton;
    private boolean mBCol;
    private boolean mBRow;
    private String mColValue;
    private String mRowValue;
    private CorrespondenceSpssVarFormatter mFormatterRow;
    private CorrespondenceSpssVarFormatter mFormatterCol;

    public CorrespondenceAnalysisDlg(JFrame jFrame) {
        super(jFrame, false, MarketResearchResBundle.getDefaultResourceBundleName(), MarketResearchResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_CORRES_ANALYSIS"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_cors";
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mRowTargetVarList)) {
            this.mRowDefineButton.setEnabled(this.mRowTargetVarList.getModel().getSize() == 1 && !this.mRowTargetVarList.isSelectionEmpty());
            this.mRowArrowButton.setEnabled(this.mRowTargetVarList.getModel().getSize() == 1 && !this.mRowTargetVarList.isSelectionEmpty());
        }
        if (focusEvent.getSource().equals(this.mColTargetVarList)) {
            this.mColDefineButton.setEnabled(this.mColTargetVarList.getModel().getSize() == 1 && !this.mColTargetVarList.isSelectionEmpty());
            this.mColArrowButton.setEnabled(this.mColTargetVarList.getModel().getSize() == 1 && !this.mColTargetVarList.isSelectionEmpty());
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public String generateSyntax() {
        Object object;
        int n;
        int n2;
        String string;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        stringBuffer.append(SyntaxUtil.getMainCommand("CORRESPONDENCE"));
        stringBuffer.append(SyntaxUtil.getMainCommandParamters("TABLE="));
        stringBuffer.append(this.mRowTargetVarList.getVariablesStringList());
        String string2 = "(" + dialogDataModel.getString("IDS_MIN_VALUE_ROW34") + " " + dialogDataModel.getString("IDS_MAX_VALUE_ROW3432") + ")";
        stringBuffer.append(string2);
        stringBuffer.append(" BY ");
        stringBuffer.append(this.mColTargetVarList.getVariablesStringList());
        string2 = "(" + dialogDataModel.getString("IDS_MIN_VALUE_COL324") + " " + dialogDataModel.getString("IDS_MAX_VALUE_COL324") + ")";
        stringBuffer.append(string2);
        Object[] objectArray = dialogDataModel.getArray("IDS_ROW_CONS_LIST");
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        for (int i = 0; i < objectArray.length; ++i) {
            string = objectArray[i].toString();
            if (string.endsWith(this.getResString("IDS_DOT_EQUAL"))) {
                vector.add(string.substring(0, string.indexOf(":")));
            }
            if (!string.endsWith(this.getResString("IDS_DOT_SUPPLEMENTAL"))) continue;
            vector2.add(string.substring(0, string.indexOf(":")));
        }
        objectArray = dialogDataModel.getArray("IDS_COL_CONS_LIST");
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            string = objectArray[n2].toString();
            if (string.endsWith(this.getResString("IDS_DOT_EQUAL"))) {
                vector3.add(string.substring(0, string.indexOf(":")));
            }
            if (!string.endsWith(this.getResString("IDS_DOT_SUPPLEMENTAL"))) continue;
            vector4.add(string.substring(0, string.indexOf(":")));
        }
        boolean bl = false;
        if (vector.size() > 0 || vector3.size() > 0) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/EQUAL="));
            if (vector != null && (n2 = vector.size()) >= 1) {
                stringBuffer.append(this.mRowTargetVarList.getVariablesStringList());
                stringBuffer.append("(");
                for (n = 0; n < n2 - 1; ++n) {
                    stringBuffer.append((String)vector.get(n));
                    stringBuffer.append(",");
                }
                if (n == n2 - 1) {
                    stringBuffer.append((String)vector.get(n));
                }
                stringBuffer.append(")");
                bl = true;
            }
            if (vector3 != null && (n2 = vector3.size()) >= 1) {
                if (bl) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(this.mColTargetVarList.getVariablesStringList());
                stringBuffer.append("(");
                for (n = 0; n < n2 - 1; ++n) {
                    stringBuffer.append((String)vector3.get(n));
                    stringBuffer.append(",");
                }
                if (n == n2 - 1) {
                    stringBuffer.append((String)vector3.get(n));
                }
                stringBuffer.append(")");
            }
        }
        bl = false;
        if (vector2.size() > 0 || vector4.size() > 0) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/SUPPLEMENTARY="));
            if (vector2 != null && (n2 = vector2.size()) >= 1) {
                stringBuffer.append(this.mRowTargetVarList.getVariablesStringList());
                stringBuffer.append("(");
                for (n = 0; n < n2 - 1; ++n) {
                    stringBuffer.append((String)vector2.get(n));
                    stringBuffer.append(",");
                }
                if (n == n2 - 1) {
                    stringBuffer.append((String)vector2.get(n));
                }
                stringBuffer.append(")");
                bl = true;
            }
            if (vector4 != null && (n2 = vector4.size()) >= 1) {
                if (bl) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(this.mColTargetVarList.getVariablesStringList());
                stringBuffer.append("(");
                for (n = 0; n < n2 - 1; ++n) {
                    stringBuffer.append((String)vector4.get(n));
                    stringBuffer.append(",");
                }
                if (n == n2 - 1) {
                    stringBuffer.append((String)vector4.get(n));
                }
                stringBuffer.append(")");
            }
        }
        String string3 = dialogDataModel.getString("IDS_DIMENSION_KEY123");
        stringBuffer.append("\n");
        if (string3 != null) {
            stringBuffer.append(SyntaxUtil.getSubCommand("/DIMENSIONS="));
            stringBuffer.append(string3);
        } else {
            stringBuffer.append(SyntaxUtil.getSubCommand("/DIMENSIONS=2"));
        }
        Boolean bl2 = dialogDataModel.getBoolean("IDS_CHI_SQUARE");
        Boolean bl3 = dialogDataModel.getBoolean("IDS_ECLIDEAN_MODEL");
        if (bl2 != null && bl2.booleanValue() || bl3 != null && bl3.booleanValue()) {
            stringBuffer.append("\n" + SyntaxUtil.getSubCommand("/MEASURE="));
            if (bl2 != null && bl2.booleanValue()) {
                stringBuffer.append("CHISQ");
            }
            if (bl3 != null && bl3.booleanValue()) {
                stringBuffer.append("EUCLID");
            }
        } else {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/MEASURE=CHISQ"));
        }
        String string4 = "RCMEAN";
        if (bl2 != null && bl2.booleanValue()) {
            string4 = "RCMEAN";
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_ROW_REMOVED")) != null && bl2.booleanValue()) {
            string4 = "RMEAN";
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_COL_REMOVED")) != null && bl2.booleanValue()) {
            string4 = "CMEAN";
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_ROW_EQUALIZED")) != null && bl2.booleanValue()) {
            string4 = "RSUM";
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_COL_EQUALIZED")) != null && bl2.booleanValue()) {
            string4 = "CSUM";
        }
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/STANDARDIZE=") + string4);
        String string5 = "SYMMETRICAL";
        bl2 = dialogDataModel.getBoolean("IDS_SYMMETRICAL");
        if (bl2 != null && bl2.booleanValue()) {
            string5 = "SYMMETRICAL";
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_ROW_PRINCIPAL")) != null && bl2.booleanValue()) {
            string5 = "RPRINCIPAL";
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_PRINCIPAL")) != null && bl2.booleanValue()) {
            string5 = "PRINCIPAL";
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_COL_PRINCIPAL")) != null && bl2.booleanValue()) {
            string5 = "CPRINCIPAL";
        }
        if ((bl2 = dialogDataModel.getBoolean("IDS_CUSTOM")) != null && bl2.booleanValue()) {
            string5 = dialogDataModel.getString("IDS_CUSTOM_VALUE");
        }
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getSubCommand("/NORMALIZATION=") + string5);
        bl2 = dialogDataModel.getBoolean("IDS_CORR_TABLE");
        bl3 = dialogDataModel.getBoolean("IDS_ROW_POINTS");
        Boolean bl4 = dialogDataModel.getBoolean("IDS_ROW_PROFILE");
        Boolean bl5 = dialogDataModel.getBoolean("IDS_COL_POINTS");
        Boolean bl6 = dialogDataModel.getBoolean("IDS_COL_PROFILE");
        Boolean bl7 = dialogDataModel.getBoolean("IDS_PERMUTATIONS_CORR");
        Boolean bl8 = dialogDataModel.getBoolean("IDS_STAT_ROW_POINTS");
        Boolean bl9 = dialogDataModel.getBoolean("IDS_STAT_COL_POINTS");
        int n3 = 0;
        if (bl2 != null && bl2 != false || bl3 != null && bl3 != false || bl4 != null && bl4 != false || bl5 != null && bl5 != false || bl6 != null && bl6 != false || bl5 != null && bl5 != false || bl6 != null && bl6 != false || bl7 != null && bl7 != false || bl8 != null && bl8 != false || bl9 != null && bl9.booleanValue()) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/PRINT="));
            if (bl2 != null && bl2.booleanValue()) {
                stringBuffer.append("TABLE ");
            }
            if (bl3 != null && bl3.booleanValue()) {
                stringBuffer.append("RPOINTS ");
            }
            if (bl5 != null && bl5.booleanValue()) {
                stringBuffer.append("CPOINTS ");
            }
            if (bl7 != null && bl7.booleanValue()) {
                stringBuffer.append("PERMUTATION");
                object = "(" + dialogDataModel.getString("IDS_PERMUTATION2432423") + ")" + " ";
                stringBuffer.append((String)object);
            }
            if (bl4 != null && bl4.booleanValue()) {
                stringBuffer.append("RPROFILES ");
            }
            if (bl6 != null && bl6.booleanValue()) {
                stringBuffer.append("CPROFILES ");
            }
            if (bl8 != null && bl8.booleanValue()) {
                stringBuffer.append("RCONF ");
            }
            if (bl9 != null && bl9.booleanValue()) {
                stringBuffer.append("CCONF");
            }
        } else if (bl2 != null && bl2 == false || bl3 != null && bl3 == false || bl4 != null && bl4 == false || bl5 != null && bl5 == false || bl6 != null && bl6 == false || bl7 != null && bl7 == false || bl8 != null && bl8 == false || bl9 != null && !bl9.booleanValue()) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/PRINT=NONE"));
        } else {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/PRINT=TABLE RPOINTS CPOINTS"));
        }
        if (stringBuffer.toString().endsWith(" ")) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        bl4 = dialogDataModel.getBoolean("IDS_BIPLOT");
        bl5 = dialogDataModel.getBoolean("IDS_ROW_PTS");
        bl6 = dialogDataModel.getBoolean("IDS_COL_PTS");
        bl7 = dialogDataModel.getBoolean("IDS_TRANS_ROW_CATEG");
        bl8 = dialogDataModel.getBoolean("IDS_TRANS_COL_CATEG");
        bl2 = dialogDataModel.getBoolean("IDS_DISPLAY_ALL");
        bl3 = dialogDataModel.getBoolean("IDS_RESTRICT_DIM");
        object = dialogDataModel.getBoolean("IDS_PRINCIPAL");
        n3 = 0;
        boolean bl10 = false;
        if (bl2 != null && bl2 != false || bl3 != null && bl3 != false || bl4 != null && bl4 != false || bl5 != null && bl5 != false || bl6 != null && bl6 != false || bl7 != null && bl7 != false || bl8 != null && bl8.booleanValue()) {
            String string6;
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/PLOT="));
            if (bl2 != null && bl2.booleanValue()) {
                n3 = 2;
                stringBuffer.append("NDIM(1,MAX) ");
            }
            if (bl3 != null && bl3.booleanValue()) {
                n3 = 2;
                stringBuffer.append("NDIM");
                string6 = "(" + dialogDataModel.getString("IDS_MIN_VALUE88") + ",";
                stringBuffer.append(string6);
                string6 = dialogDataModel.getString("IDS_MAX_VALUE88") + ")" + " ";
                stringBuffer.append(string6);
            }
            string6 = "(" + dialogDataModel.getString("IDS_SCATTER") + ")" + " ";
            if (bl4 != null && bl4.booleanValue()) {
                bl10 = true;
                stringBuffer.append("BIPLOT");
                stringBuffer.append(string6);
            }
            if (bl5 != null && bl5.booleanValue()) {
                bl10 = true;
                stringBuffer.append("RPOINTS");
                stringBuffer.append(string6);
            }
            if (bl6 != null && bl6.booleanValue()) {
                bl10 = true;
                stringBuffer.append("CPOINTS");
                stringBuffer.append(string6);
            }
            string6 = "(" + dialogDataModel.getString("IDS_LINE_PLOT") + ")" + " ";
            if (bl7 != null && bl7.booleanValue()) {
                bl10 = true;
                stringBuffer.append("TRROWS");
                stringBuffer.append(string6);
            }
            if (bl8 != null && bl8.booleanValue()) {
                bl10 = true;
                stringBuffer.append("TRCOLUMNS");
                stringBuffer.append(string6);
            }
        }
        if ((object != null && ((Boolean)object).booleanValue() || bl10) && n3 != 2) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/PLOT=NDIM(1,MAX) NONE "));
        } else if (n3 == 2 && !bl10) {
            stringBuffer.append("NONE");
        } else if (n3 == 0 && !bl10) {
            stringBuffer.append("\n");
            stringBuffer.append(SyntaxUtil.getSubCommand("/PLOT=NDIM(1,MAX) BIPLOT(20) "));
        }
        if (stringBuffer.toString().endsWith(" ")) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public String getIActionKey() {
        return "analyze_data_reduction_corr_analysis";
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.SetDefineButtonEnabled(listDataEvent);
        this.updateOKPaste();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.SetDefineButtonEnabled(listDataEvent);
        this.updateOKPaste();
        if (listDataEvent.getSource().equals(this.mRowTargetVarList.getModel())) {
            this.resetRowComponents();
        }
        if (listDataEvent.getSource().equals(this.mColTargetVarList.getModel())) {
            this.resetColComponents();
        }
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.SetDefineButtonEnabled(listDataEvent);
        this.updateOKPaste();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.mRowDefineButton)) {
            this.mBRow = this.runSubDialog(new CorrespondenceDefineRowRange(this, this.getResString("IDS_DEFINE_RANGE_ROW"), true));
        }
        if (actionEvent.getSource().equals(this.mColDefineButton)) {
            this.mBCol = this.runSubDialog(new CorrespondenceDefineColRange(this, this.getResString("IDS_DEFINE_RANGE_COL"), true));
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.mRowArrowButton.getArrowOrientation().equals((Object)SpssArrowButton.ButtonOrientation.right) && this.mRowTargetVarList.getModel().getSize() == 0 && (SpssVariable)this.mSrcVarList.getSelectedValue() != null) {
            this.mRowValue = ((SpssVariable)this.mSrcVarList.getSelectedValue()).getName();
        }
        if (this.mColArrowButton.getArrowOrientation().equals((Object)SpssArrowButton.ButtonOrientation.right) && this.mColTargetVarList.getModel().getSize() == 0 && (SpssVariable)this.mSrcVarList.getSelectedValue() != null) {
            this.mColValue = ((SpssVariable)this.mSrcVarList.getSelectedValue()).getName();
        }
        if (listSelectionEvent.getSource().equals(this.mRowTargetVarList)) {
            this.mRowDefineButton.setEnabled(!this.mRowTargetVarList.isSelectionEmpty());
            this.mRowArrowButton.setEnabled(!this.mRowTargetVarList.isSelectionEmpty());
        }
        if (listSelectionEvent.getSource().equals(this.mColTargetVarList)) {
            this.mColDefineButton.setEnabled(!this.mColTargetVarList.isSelectionEmpty());
            this.mColArrowButton.setEnabled(!this.mColTargetVarList.isSelectionEmpty());
        }
    }

    public void setRowRange(String string, String string2) {
        String string3 = "(" + string + " " + string2 + ")";
        ((CorrespondenceListModel)this.mRowTargetVarList.getModel()).setElementPropertyAt(0, string3);
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        String string4 = dialogDataModel.getString("IDS_MIN_VALUE_COL324");
        String string5 = dialogDataModel.getString("IDS_MAX_VALUE_COL324");
        if (string4 != null && string5 != null) {
            this.enableOkPaste(true);
        } else if (this.mBCol) {
            this.enableOkPaste(true);
        } else {
            this.mBCol = false;
            this.enableOkPaste(false);
        }
    }

    public void setColRange(String string, String string2) {
        String string3 = "(" + string + " " + string2 + ")";
        ((CorrespondenceListModel)this.mColTargetVarList.getModel()).setElementPropertyAt(0, string3);
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        String string4 = dialogDataModel.getString("IDS_MIN_VALUE_ROW34");
        String string5 = dialogDataModel.getString("IDS_MAX_VALUE_ROW3432");
        if (string4 != null && string5 != null) {
            this.enableOkPaste(true);
        } else if (this.mBRow) {
            this.enableOkPaste(true);
        } else {
            this.mBRow = false;
            this.enableOkPaste(false);
        }
    }

    public String getSelectedRowVariable() {
        return this.mRowValue;
    }

    public String getSelectedColVariable() {
        return this.mColValue;
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        this.mFormatterRow.setVarMap(this.getDialogDataModel().getMap(this.mRowTargetVarList.getIdentifier()));
        this.mFormatterCol.setVarMap(this.getDialogDataModel().getMap(this.mColTargetVarList.getIdentifier()));
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        if (dialogDataModel.getString("IDS_MIN_VALUE_COL324") != null && dialogDataModel.getString("IDS_MAX_VALUE_COL324") != null && dialogDataModel.getString("IDS_MIN_VALUE_ROW34") != null && dialogDataModel.getString("IDS_MAX_VALUE_ROW3432") != null) {
            this.enableOkPaste(true);
        }
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        this.getDialogDataModel().putMap(this.mRowTargetVarList.getIdentifier(), this.mFormatterRow.getVarMapForSerialization());
        this.getDialogDataModel().putMap(this.mColTargetVarList.getIdentifier(), this.mFormatterCol.getVarMapForSerialization());
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.setupComponents(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    @Override
    protected JPanel setupOptionsButtonPanel() {
        JPanel jPanel = super.setupOptionsButtonPanel();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction("IDS_COMMON_MODEL_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CorrespondenceAnalysisDlg.this.runModelSubDialog();
            }
        };
        ToggleButtonAction toggleButtonAction2 = new ToggleButtonAction("IDS_COMMON_STATS_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CorrespondenceAnalysisDlg.this.runStatSubDialog();
            }
        };
        ToggleButtonAction toggleButtonAction3 = new ToggleButtonAction("IDS_COMMON_PLOTS_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CorrespondenceAnalysisDlg.this.runPlotSubDialog();
            }
        };
        JButton jButton = new JButton(toggleButtonAction2);
        JButton jButton2 = new JButton(toggleButtonAction);
        JButton jButton3 = new JButton(toggleButtonAction3);
        this.addOptionsPanelButton(jPanel, jButton2);
        this.addOptionsPanelButton(jPanel, jButton);
        this.addOptionsPanelButton(jPanel, jButton3);
        return jPanel;
    }

    private void runStatSubDialog() {
        this.runSubDialog(new CorrespondenceStatistics(this, this.getResString("IDS_CORR_STATS"), true));
    }

    private void runModelSubDialog() {
        this.runSubDialog(new CorrespondenceModel(this, this.getResString("IDS_CORR_MODEL"), true));
    }

    private void runPlotSubDialog() {
        this.runSubDialog(new CorrespondencePlots(this, this.getResString("IDS_CORR_PLOT"), true));
    }

    private void setFocusTraversalPolicy() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcVarList);
        vector.add(this.mRowArrowButton);
        vector.add(this.mRowTargetVarList);
        vector.add(this.mRowDefineButton);
        vector.add(this.mColArrowButton);
        vector.add(this.mColTargetVarList);
        vector.add(this.mColDefineButton);
        int n2 = this.mOptionButtonPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            Component component = this.mOptionButtonPanel.getComponent(n);
            if (!(component instanceof JButton)) continue;
            vector.add(component);
        }
        n2 = this.mCmdButtonPanel.getComponentCount();
        for (n = 0; n < n2; ++n) {
            vector.add(this.mCmdButtonPanel.getComponent(n));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setupComponents(JPanel jPanel) {
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_ROW");
        jLabel.setLabelFor(this.mRowTargetVarList);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_COL");
        jLabel2.setLabelFor(this.mColTargetVarList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        gridBagConstraints.fill = 2;
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_CORRESPOND_ANALYSIS_SOURCE_LABEL");
        jLabel3.setLabelFor(this.mSrcVarList);
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getComponentGroupGap();
        DialogUtil.addUsingGBL(jPanel, this.mSrcScrollPane, gridBagConstraints, 0, 1, 1, 5, n, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 20;
        Insets insets = new Insets(0, DialogUtil.getArrowButtonInsets().left, 0, DialogUtil.getArrowButtonInsets().right);
        DialogUtil.addUsingGBL(jPanel, this.mRowArrowButton, gridBagConstraints, 1, 0, 1, 2, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 0, 1, 1, n, null);
        Insets insets2 = new Insets(n2 - 8, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mRowTargetScrollPane, gridBagConstraints, 2, 1, 1, 1, n, insets2);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mRowDefineButton, gridBagConstraints, 2, 2, 1, 1, n, DialogUtil.getStandardButtonInsets());
        gridBagConstraints.weightx = 0.0;
        n = 20;
        insets = new Insets(0, DialogUtil.getArrowButtonInsets().left, 0, DialogUtil.getArrowButtonInsets().right);
        DialogUtil.addUsingGBL(jPanel, this.mColArrowButton, gridBagConstraints, 1, 3, 1, 2, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        n = 23;
        insets2 = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 2, 3, 1, 1, n, insets2);
        insets2 = new Insets(n2 - 8, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mColTargetScrollPane, gridBagConstraints, 2, 4, 1, 1, n, insets2);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mColDefineButton, gridBagConstraints, 2, 5, 1, 1, n, DialogUtil.getStandardButtonInsets());
    }

    private void initVars() {
        this.mSrcVarList = new SrcVariableList(VariableList.VarMoveType.eMoveOriginal);
        this.mSrcScrollPane = new JScrollPane(this.mSrcVarList);
        this.mSrcScrollPane.setPreferredSize(this.mSrcVarList.getMinimumSize());
        this.mRowTargetVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mRowTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mRowTargetScrollPane = new JScrollPane(this.mRowTargetVarList);
        this.mRowTargetScrollPane.setPreferredSize(this.mRowTargetVarList.getMinimumSize());
        this.mRowTargetScrollPane.setHorizontalScrollBarPolicy(31);
        this.mRowTargetScrollPane.setVerticalScrollBarPolicy(21);
        this.mColTargetVarList = new TargetVariableList(TargetVariableList.TargetListType.single_item);
        this.mColTargetVarList.setDragType(VariableList.VarMoveType.eMoveOriginal);
        this.mColTargetScrollPane = new JScrollPane(this.mColTargetVarList);
        this.mColTargetScrollPane.setPreferredSize(this.mColTargetVarList.getMinimumSize());
        this.mColTargetScrollPane.setHorizontalScrollBarPolicy(31);
        this.mColTargetScrollPane.setVerticalScrollBarPolicy(21);
        this.mFormatterRow = new CorrespondenceSpssVarFormatter(this.mRowTargetVarList);
        this.mRowTargetVarList.setModel(new CorrespondenceListModel(this.mFormatterRow));
        this.mRowTargetVarList.setCellRenderer(new CustomVarListCellRenderer(this.mFormatterRow));
        this.mFormatterCol = new CorrespondenceSpssVarFormatter(this.mColTargetVarList);
        this.mColTargetVarList.setModel(new CorrespondenceListModel(this.mFormatterCol));
        this.mColTargetVarList.setCellRenderer(new CustomVarListCellRenderer(this.mFormatterCol));
        this.mRowArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mRowArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mRowArrowButton.registerVariableList(this.mRowTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mColArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mColArrowButton.registerVariableList(this.mSrcVarList, SpssArrowButton.ButtonOrientation.right);
        this.mColArrowButton.registerVariableList(this.mColTargetVarList, SpssArrowButton.ButtonOrientation.left);
        this.mRowDefineButton = new JButton(new ToggleButtonAction(this, "IDS_DEFINE_3DOT_ROW"));
        this.mColDefineButton = new JButton(new ToggleButtonAction(this, "IDS_DEFINE_3DOT_COL"));
        this.mSrcVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mRowTargetVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mColTargetVarList.addVarFilter(new SpssVarFilter(8, false));
        this.mSrcVarList.getModel().addListDataListener(this);
        this.mRowTargetVarList.getModel().addListDataListener(this);
        this.mColTargetVarList.getModel().addListDataListener(this);
        this.mRowTargetVarList.addListSelectionListener(this);
        this.mColTargetVarList.addListSelectionListener(this);
        this.mRowTargetVarList.addFocusListener(this);
        this.mColTargetVarList.addFocusListener(this);
        this.mRowDefineButton.addActionListener(this);
        this.mColDefineButton.addActionListener(this);
        this.mRowTargetVarList.setIdentifier(TARGET_ROW_VAR_LIST_KEY);
        this.mColTargetVarList.setIdentifier(TARGET_COL_VAR_LIST_KEY);
        this.mColTargetVarList.setShowIcon(false);
        this.mRowTargetVarList.setShowIcon(false);
    }

    private void setDefaults() {
        this.mRowTargetVarList.removeAll();
        this.mColTargetVarList.removeAll();
        this.mSrcVarList.loadFromActiveDataset();
        this.mSrcVarList.setSelectedIndex(0);
        this.mSrcVarList.requestFocus();
        this.enableOkPaste(false);
        this.mRowDefineButton.setEnabled(false);
        this.mColDefineButton.setEnabled(false);
    }

    private void SetDefineButtonEnabled(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource().equals(this.mRowTargetVarList.getModel())) {
            this.mRowDefineButton.setEnabled(this.mRowTargetVarList.getModel().getSize() == 1);
        }
        if (listDataEvent.getSource().equals(this.mColTargetVarList.getModel())) {
            this.mColDefineButton.setEnabled(this.mColTargetVarList.getModel().getSize() == 1);
        }
    }

    private void updateOKPaste() {
        if (this.mRowTargetVarList.getModel().getSize() == 0) {
            this.mBRow = false;
            this.enableOkPaste(false);
        }
        if (this.mColTargetVarList.getModel().getSize() == 0) {
            this.mBCol = false;
            this.enableOkPaste(false);
        }
    }

    private void resetRowComponents() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        dialogDataModel.putString("IDS_MIN_VALUE_ROW34", null);
        dialogDataModel.putString("IDS_MAX_VALUE_ROW3432", null);
        dialogDataModel.putArray("IDS_ROW_CONS_LIST", null);
        dialogDataModel.putBoolean("IDS_NONE_CONS", true);
        dialogDataModel.putBoolean("IDS_CATEGORY_EQ", null);
        dialogDataModel.putBoolean("IDS_CATEGORY_SUPP", null);
    }

    private void resetColComponents() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        dialogDataModel.putString("IDS_MIN_VALUE_COL324", null);
        dialogDataModel.putString("IDS_MAX_VALUE_COL324", null);
        dialogDataModel.putArray("IDS_COL_CONS_LIST", null);
        dialogDataModel.putBoolean("IDS_COL_NONE_CONS", true);
        dialogDataModel.putBoolean("IDS_COL_CATEGORY_EQ", null);
        dialogDataModel.putBoolean("IDS_COL_CATEGORY_SUPP", null);
    }

    private class CorrespondenceSpssVarFormatter
    extends SpssVarFormatter {
        public CorrespondenceSpssVarFormatter(TargetVariableList targetVariableList) {
            super(targetVariableList);
        }

        @Override
        public String getDisplayText(ISpssVariable iSpssVariable) {
            return iSpssVariable.getName() + this.getVarMap().get(iSpssVariable.getId().asInt());
        }
    }

    private class CorrespondenceListModel
    extends CustomVarListModel {
        public CorrespondenceListModel(SpssVarFormatter spssVarFormatter) {
            super(spssVarFormatter);
        }

        @Override
        public boolean insertElementAt(ISpssVariable iSpssVariable, int n) {
            this.mVarFormatter.getVarMap().put(iSpssVariable.getId().asInt(), "(? ?)");
            return super.insertElementAt(iSpssVariable, n);
        }

        @Override
        public boolean addElement(ISpssVariable iSpssVariable) {
            this.mVarFormatter.getVarMap().put(iSpssVariable.getId().asInt(), "(? ?)");
            return super.addElement(iSpssVariable);
        }

        public void setElementPropertyAt(int n, String string) {
            if (n < 0 || n >= this.mVariables.size()) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
            ISpssVariable iSpssVariable = this.getElementAt(n);
            this.mVarFormatter.getVarMap().put(iSpssVariable.getId().asInt(), string);
            this.fireContentsChanged(iSpssVariable, n, n);
        }

        @Override
        public void fireContentsChanged(Object object, int n, int n2) {
            super.fireContentsChanged(object, n, n2);
        }
    }
}

