/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research;

import com.spss.java_client.ui.controls.ACRWidget;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class MultidimensionalPlots
implements ItemListener,
FocusListener {
    private String[] mKeys;
    private JRadioButton mAllRadioButton;
    private JLabel mListLabel;
    private JRadioButton mSelectRadioButton;
    private JLabel mNumberLabel;
    private IntTextField mNumberTextField;
    private ACRWidget mWidget;
    private BaseDialog mBaseDialog;
    private SpssButtonGroup mGroup;
    private boolean ignoreContinueEnable;

    public MultidimensionalPlots(String[] stringArray, BaseDialog baseDialog) {
        this.mBaseDialog = baseDialog;
        this.mKeys = stringArray;
        this.initVars();
    }

    public JPanel setupSourcePlotsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.mBaseDialog.getResString(this.mKeys[4])));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(0, 0, 0, 0);
        insets2.set(n2, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mAllRadioButton, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        insets2.set(n2 + 5, 88, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mListLabel, gridBagConstraints, 2, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        insets2.set(insets.top, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mSelectRadioButton, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        insets2.set(n2 + 7, n2 * 15, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mNumberLabel, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        insets2.set(n2 + 7, 25, 0, 20);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mNumberTextField, gridBagConstraints, 1, 2, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets2.set(0, insets.left, 10, 25);
        DialogUtil.addUsingGBL(jPanel, this.mWidget, gridBagConstraints, 2, 1, 1, 2, n, insets2);
        return jPanel;
    }

    public void setEnabled(boolean bl) {
        this.mAllRadioButton.setEnabled(bl);
        this.mSelectRadioButton.setEnabled(bl);
        if (this.mSelectRadioButton.isSelected() && this.mSelectRadioButton.isEnabled()) {
            this.enableComponents(true);
        } else {
            this.enableComponents(false);
        }
    }

    public void clearNumberTextField() {
        this.mNumberTextField.setText("");
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mAllRadioButton) {
            this.enableComponents(false);
            this.canContinueEnable(true);
        } else if (object == this.mSelectRadioButton && this.mSelectRadioButton.isEnabled()) {
            this.enableComponents(true);
            boolean bl = this.mWidget.getList().isEnabled();
            if (bl) {
                String[] stringArray = this.mWidget.getListItems();
                if (stringArray != null && stringArray.length > 0) {
                    this.canContinueEnable(true);
                } else {
                    this.canContinueEnable(false);
                }
            } else {
                this.canContinueEnable(true);
            }
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.mNumberTextField.selectAll();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    public List<Object> getTraversalComponents() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(this.mGroup);
        arrayList.addAll(this.mWidget.getTraversalComponents());
        return arrayList;
    }

    public ACRWidget getACRWidget() {
        return this.mWidget;
    }

    public void setIgnoreContinueEnable(boolean bl) {
        this.ignoreContinueEnable = bl;
    }

    private void canContinueEnable(boolean bl) {
        if (this.mBaseDialog instanceof BaseSubDialog && !this.ignoreContinueEnable) {
            ((BaseSubDialog)this.mBaseDialog).enableContinue(bl);
        }
    }

    private void enableComponents(boolean bl) {
        this.mNumberLabel.setEnabled(bl);
        this.mNumberTextField.setText("");
        this.mNumberTextField.setEnabled(bl);
        this.mNumberTextField.setOpaque(bl);
        this.mListLabel.setEnabled(bl);
        this.mWidget.getList().clearSelection();
        this.mWidget.setEnabled(bl);
        if (!bl) {
            this.canContinueEnable(true);
        }
        if (bl) {
            if (this.mAllRadioButton.isSelected()) {
                this.canContinueEnable(true);
            } else if (this.mWidget.getList().getModel().getSize() > 0) {
                this.canContinueEnable(true);
            } else {
                this.canContinueEnable(false);
            }
        }
    }

    private void initVars() {
        this.mAllRadioButton = new JRadioButton(new ToggleButtonAction(this.mBaseDialog, this.mKeys[0]));
        this.mSelectRadioButton = new JRadioButton(new ToggleButtonAction(this.mBaseDialog, this.mKeys[1]));
        this.mGroup = new SpssButtonGroup();
        this.mGroup.add(this.mAllRadioButton);
        this.mGroup.add(this.mSelectRadioButton);
        this.mAllRadioButton.setSelected(true);
        this.mNumberTextField = new IntTextField(1, 99999999, true);
        this.mNumberLabel = DialogUtil.createLabel(this.mBaseDialog, this.mKeys[2]);
        this.mNumberLabel.setLabelFor((Component)this.mNumberTextField);
        this.mNumberTextField.setAction((Action)new TextFieldAction(this.mBaseDialog, this.mKeys[2]));
        this.mNumberTextField.addFocusListener((FocusListener)this);
        this.mListLabel = DialogUtil.createLabel(this.mBaseDialog, this.mKeys[3]);
        this.mWidget = new ACRWidget((JTextField)this.mNumberTextField);
        this.mWidget.setAddMnemonic(this.mBaseDialog.getDlgAccessKey("IDK_MULTI_UNFOLD_PLOT_ADD_KEY"));
        this.mWidget.setChangeMnemonic(this.mBaseDialog.getDlgAccessKey("IDK_MULTI_UNFOLD_PLOT_CHANGE_KEY"));
        this.mWidget.setRemoveMnemonic(this.mBaseDialog.getDlgAccessKey("IDK_MULTI_UNFOLD_PLOT_REMOVE_KEY"));
        this.mListLabel.setLabelFor(this.mWidget.getList());
        this.mWidget.getList().getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
                if (listDataEvent.getSource() instanceof DefaultListModel) {
                    int n;
                    DefaultListModel defaultListModel = (DefaultListModel)listDataEvent.getSource();
                    defaultListModel.removeListDataListener(this);
                    Object[] objectArray = defaultListModel.toArray();
                    int[] nArray = new int[objectArray.length];
                    for (n = 0; n < objectArray.length; ++n) {
                        nArray[n] = Integer.parseInt((String)objectArray[n]);
                    }
                    Arrays.sort(nArray);
                    defaultListModel.removeAllElements();
                    for (n = 0; n < nArray.length; ++n) {
                        defaultListModel.addElement(Integer.toString(nArray[n]));
                    }
                    defaultListModel.addListDataListener(this);
                }
                MultidimensionalPlots.this.canContinueEnable(true);
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
                if (MultidimensionalPlots.this.mBaseDialog instanceof BaseSubDialog) {
                    if (MultidimensionalPlots.this.mWidget.getList().getModel().getSize() == 0) {
                        MultidimensionalPlots.this.canContinueEnable(false);
                    } else {
                        MultidimensionalPlots.this.canContinueEnable(true);
                    }
                }
            }

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
            }
        });
        this.mAllRadioButton.addItemListener(this);
        this.mSelectRadioButton.addItemListener(this);
        this.enableComponents(false);
    }
}

