/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research;

import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

public class MultiDimensionalCommonSavePanel
extends JPanel
implements ActionListener,
ItemListener,
DocumentListener,
FocusListener {
    static final String CREATE_NEW_DATASET = "IDS_SAVE_CREATE_NEW_DATASET_RADIO";
    static final String WRITE_NEW_DATAFILE = "IDS_SAVE_WRITE_NEW_DATA_FILE_RADIO";
    static final String DATASET_NAME_LABEL = "IDS_SAVE_DATASET_NAME";
    static final String DATASET_NAME_TEXT = "IDS_DATASET_NAME_TEXT";
    static final String FILE_PATH = "IDS_FILE_PATH";
    private BaseSubDialog mBaseDialog;
    private String mFileChooserTitle;
    private String mFileChooserFilter;
    private String mFileChooserExt;
    private JCheckBox mCreateCheck;
    private String mCreateCheckKeyName;
    private JButton mFileButton;
    private FileTextField mFileText;
    private JRadioButton mCreateNewDataSetRadio;
    private JRadioButton mWriteNewDataFileRadio;
    private SpssButtonGroup mDataButtonGroup;
    private JTextField mDatasetNameText;
    private JLabel mDataSetNameLabel;

    public MultiDimensionalCommonSavePanel(BaseSubDialog baseSubDialog, String string, String string2, String string3, String string4, String string5) {
        this.mBaseDialog = baseSubDialog;
        this.mFileChooserTitle = string2;
        this.mFileChooserFilter = string3;
        this.mFileChooserExt = string4;
        this.mCreateCheckKeyName = string5;
        this.setLayout(new GridBagLayout());
        if (string.trim().length() > 0) {
            this.setBorder(new TitledBorder(string));
        }
        this.initVars();
        this.addComponentsToPanel(this);
        this.setDefaults();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mFileButton) {
            String string = this.saveFileChooseDialog(this.mFileChooserTitle, this.mFileChooserFilter, this.mFileChooserExt);
            this.mFileText.setText(string);
            boolean bl = string.equals("");
            this.mBaseDialog.enableContinue(this.saveToNewFileSelectedAndChecked(bl));
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (!this.mCreateCheck.isSelected()) {
            this.mCreateNewDataSetRadio.setEnabled(false);
            this.mWriteNewDataFileRadio.setEnabled(false);
            this.mFileButton.setEnabled(false);
            this.mFileText.setEnabled(false);
            this.mDatasetNameText.setEnabled(false);
            this.mDataSetNameLabel.setEnabled(false);
        } else if (object == this.mCreateCheck) {
            this.mCreateNewDataSetRadio.setEnabled(true);
            this.mWriteNewDataFileRadio.setEnabled(true);
            if (!this.mCreateNewDataSetRadio.isSelected() && !this.mWriteNewDataFileRadio.isSelected()) {
                this.mCreateNewDataSetRadio.setSelected(true);
            }
            if (this.mCreateNewDataSetRadio.isSelected()) {
                this.mDatasetNameText.setEnabled(true);
                this.mDataSetNameLabel.setEnabled(true);
                this.mFileButton.setEnabled(false);
                this.mFileText.setEnabled(false);
            } else {
                this.mDatasetNameText.setEnabled(false);
                this.mDataSetNameLabel.setEnabled(false);
                this.mFileButton.setEnabled(true);
                this.mFileText.setEnabled(true);
            }
        } else if (object == this.mCreateNewDataSetRadio) {
            this.mFileButton.setEnabled(false);
            this.mFileText.setEnabled(false);
            this.mDatasetNameText.setEnabled(true);
            this.mDataSetNameLabel.setEnabled(true);
        } else if (object == this.mWriteNewDataFileRadio) {
            this.mFileButton.setEnabled(true);
            this.mFileText.setEnabled(true);
            this.mDatasetNameText.setEnabled(false);
            this.mDataSetNameLabel.setEnabled(false);
        }
        this.mBaseDialog.enableContinue(this.saveToNewFileSelectedAndChecked(false));
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.setContinueEnabled();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.setContinueEnabled();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.setContinueEnabled();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        JTextField jTextField = (JTextField)focusEvent.getSource();
        jTextField.setSelectionStart(0);
        jTextField.setSelectionEnd(jTextField.getText().length());
    }

    private void setContinueEnabled() {
        if (this.mCreateCheck.isSelected() && this.mWriteNewDataFileRadio.isSelected() && this.mFileText.isEnabled() && this.mFileText.getText().length() > 0) {
            this.mBaseDialog.enableContinue(true);
        } else if (this.mCreateCheck.isSelected() && this.mCreateNewDataSetRadio.isSelected() && this.mDatasetNameText.isEnabled() && this.mDatasetNameText.getText().length() > 0) {
            this.mBaseDialog.enableContinue(true);
        } else {
            this.mBaseDialog.enableContinue(false);
        }
    }

    public void setFileSelectionEnabled(boolean bl) {
        this.mFileButton.setEnabled(bl);
        this.mFileText.setOpaque(bl);
        this.mFileText.setEditable(bl);
    }

    public boolean isSelected() {
        return this.mCreateCheck.isEnabled() && this.mCreateCheck.isSelected();
    }

    public JCheckBox getCheckBox() {
        return this.mCreateCheck;
    }

    public JButton getFileButton() {
        return this.mFileButton;
    }

    public FileTextField getTextField() {
        return this.mFileText;
    }

    public String getFileName() {
        return this.mFileText.getText();
    }

    public void setCreateCheckEnabled(boolean bl) {
        this.mCreateCheck.setEnabled(bl);
        if (!this.mCreateCheck.isSelected()) {
            this.mCreateNewDataSetRadio.setEnabled(false);
            this.mWriteNewDataFileRadio.setEnabled(false);
            this.mFileButton.setEnabled(false);
            this.mFileText.setEnabled(false);
            this.mDatasetNameText.setEnabled(false);
            this.mDataSetNameLabel.setEnabled(false);
        } else {
            if (!this.mCreateNewDataSetRadio.isSelected() && !this.mWriteNewDataFileRadio.isSelected()) {
                this.mCreateNewDataSetRadio.setSelected(true);
            }
            if (this.mCreateNewDataSetRadio.isSelected()) {
                this.mDatasetNameText.setEnabled(true);
                this.mDataSetNameLabel.setEnabled(true);
                this.mFileButton.setEnabled(false);
                this.mFileText.setEnabled(false);
            } else if (this.mWriteNewDataFileRadio.isSelected()) {
                this.mDatasetNameText.setEnabled(false);
                this.mDataSetNameLabel.setEnabled(false);
                this.mFileButton.setEnabled(true);
                this.mFileText.setEnabled(true);
                this.mFileText.setEditable(false);
            }
        }
    }

    public void setFileText(String string) {
        this.mFileText.setText(string);
    }

    public String getFileText() {
        return this.mFileText.getText();
    }

    public void setDatasetNameText(String string) {
        this.mDatasetNameText.setText(string);
    }

    public String getDatasetNameText() {
        return this.mDatasetNameText.getText();
    }

    public boolean isCreateNewDataSetRadioSelected() {
        return this.mCreateNewDataSetRadio.isSelected();
    }

    public void setCreateNewDataSetRadio(boolean bl) {
        this.mCreateNewDataSetRadio.setSelected(bl);
        this.mWriteNewDataFileRadio.setSelected(!bl);
    }

    public boolean saveToNewFileSelectedAndChecked(boolean bl) {
        if (this.mCreateCheck.isSelected()) {
            if (bl) {
                return false;
            }
            if (this.mWriteNewDataFileRadio.isSelected() && (this.mFileText.getText() == null || this.mFileText.getText().trim().length() == 0)) {
                return false;
            }
            if (this.mCreateNewDataSetRadio.isSelected() && (this.mDatasetNameText.getText() == null || this.mDatasetNameText.getText().trim().length() == 0)) {
                return false;
            }
        }
        return true;
    }

    private String saveFileChooseDialog(String string, String string2, String string3) {
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
        remoteFileChooser.setDialogTitle(string);
        remoteFileChooser.setFileFilter((FileFilter)new RefFileFilter(string2, string3));
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        remoteFileChooser.setFileSelectionMode(0);
        int n = remoteFileChooser.showSaveDialog(this.getParent());
        if (n == 0) {
            FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            String string4 = remoteFileChooser.getSelectedFilePath();
            if (!string4.endsWith(string3)) {
                string4 = string4 + string3;
                return string4;
            }
            return string4;
        }
        return "";
    }

    private void setDefaults() {
        this.mCreateCheck.setSelected(false);
        this.mFileText.setText("");
        this.mFileText.setEnabled(false);
        this.mFileButton.setEnabled(false);
        this.mCreateNewDataSetRadio.setEnabled(false);
        this.mCreateNewDataSetRadio.setSelected(true);
        this.mDataSetNameLabel.setEnabled(false);
        this.mDatasetNameText.setText("");
        this.mDatasetNameText.setEnabled(false);
        this.mWriteNewDataFileRadio.setEnabled(false);
        this.setContinueEnabled();
    }

    private void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mBaseDialog, this.mCreateCheckKeyName);
        this.mCreateCheck = new JCheckBox(toggleButtonAction);
        this.mCreateCheck.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mBaseDialog, "IDS_MULTI_UNFOLD_FILE_THREE_DOT");
        this.mFileButton = new JButton(toggleButtonAction);
        this.mFileButton.addActionListener(this);
        this.mFileText = new FileTextField();
        this.mFileText.setAction(new TextFieldAction(this.mBaseDialog, FILE_PATH));
        this.mFileText.setBorder(BorderFactory.createEmptyBorder());
        toggleButtonAction = new ToggleButtonAction(this.mBaseDialog, CREATE_NEW_DATASET);
        this.mCreateNewDataSetRadio = new JRadioButton(toggleButtonAction);
        this.mCreateNewDataSetRadio.addItemListener(this);
        this.mDataSetNameLabel = DialogUtil.createLabel(this.mBaseDialog, DATASET_NAME_LABEL);
        this.mDatasetNameText = new StringTextField(14);
        this.mDatasetNameText.setAction(new TextFieldAction(this.mBaseDialog, DATASET_NAME_TEXT));
        this.mDatasetNameText.setEnabled(false);
        this.mDatasetNameText.setPreferredSize((Dimension)this.mDatasetNameText.getPreferredSize().clone());
        this.mDataSetNameLabel.setLabelFor(this.mDatasetNameText);
        this.mDatasetNameText.getDocument().addDocumentListener(this);
        this.mDatasetNameText.addFocusListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mBaseDialog, WRITE_NEW_DATAFILE);
        this.mWriteNewDataFileRadio = new JRadioButton(toggleButtonAction);
        this.mWriteNewDataFileRadio.addItemListener(this);
        this.mDataButtonGroup = new SpssButtonGroup();
        this.mDataButtonGroup.add(this.mCreateNewDataSetRadio);
        this.mDataButtonGroup.add(this.mWriteNewDataFileRadio);
    }

    private void addComponentsToPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, insets.left * 13, insets.bottom, insets.right);
        Insets insets3 = new Insets(insets.top, insets.left * 23, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mCreateCheck, gridBagConstraints, 0, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mCreateNewDataSetRadio, gridBagConstraints, 0, 1, 2, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mDataSetNameLabel, gridBagConstraints, 0, 2, 1, 1, n, insets3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mDatasetNameText, gridBagConstraints, 1, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mWriteNewDataFileRadio, gridBagConstraints, 0, 3, 2, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mFileButton, gridBagConstraints, 0, 4, 1, 1, n, insets3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mFileText), gridBagConstraints, 1, 4, 1, 1, n, insets);
    }
}

