/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.market_research;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.comp_util.SysFileProxy;
import com.spss.java_client.core.error_handler.ErrorDispatcher;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.core.server.messages.sysfilemsg.VariableBlock;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.PlainListArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.ContentValidatorFileChooser;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.FocusableLabel;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;

public class MultiDimensionalCommonPanel
extends JPanel
implements ItemListener {
    static String sFILE_NAME_KEY = "";
    static final String COMBO_KEY = "IDS_OPEN_DATASET_RADIO";
    static LocallyUniqueId sLOCALLY_UNIQUE_DATASETID_KEY = null;
    static String sMAX_DIMENSION_LABEL;
    private static final int FILETEXTWIDTH = 19;
    private boolean mAllVisible = true;
    private String mMaxDimension;
    private String mFileChooserTitle;
    private BaseSubDialog mBaseDialog;
    private JRadioButton mOpenDatasetRadio;
    private JRadioButton mExternalDatafileRadio;
    private SpssButtonGroup mGrpDataSelect;
    private JComboBox mOpenDatasetCombo;
    private JPanel mButtonTextReadPanel;
    private JButton mFileButton;
    private FileTextField mFileText;
    private String mPreviousFileText;
    private JLabel mReadVariableLabel;
    private FocusableLabel mNumberMatchCountLabel;
    private JTextArea mInfoTextArea;
    private JLabel mAvailableLabel;
    private JLabel mSelectedLabel;
    private JScrollPane mSrcLstScrollPane;
    private JScrollPane mTargetLstScrollPane;
    private PlainList mAvailableList;
    private PlainList mSelectedList;
    private PlainListArrowButton mArrowButton;

    public MultiDimensionalCommonPanel(BaseSubDialog baseSubDialog, String string, String string2, String string3, String string4, String string5, String string6, boolean bl) {
        this.mBaseDialog = baseSubDialog;
        this.mMaxDimension = string5;
        this.mAllVisible = bl;
        this.setLayout(new GridBagLayout());
        if (string.trim().length() > 0) {
            this.setBorder(new TitledBorder(string));
        }
        this.initVars(string2, string3, string4, this.mMaxDimension, string6);
        if (this.mAllVisible) {
            this.addComponentsToPanel(this);
        } else {
            this.addVisibleComponentsToPanel(this);
        }
    }

    public void getElementsForFocusVector(Vector<Object> vector) {
        if (this.mAllVisible) {
            vector.addElement(this.mFileButton);
        }
        vector.addElement(this.mNumberMatchCountLabel);
        vector.addElement(this.mAvailableList);
        vector.addElement(this.mArrowButton);
        vector.addElement(this.mSelectedList);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object.equals(this.mOpenDatasetRadio) && this.mOpenDatasetRadio.isSelected()) {
            this.mOpenDatasetCombo.setEnabled(true);
            this.mOpenDatasetCombo.setOpaque(true);
            this.mFileButton.setEnabled(false);
            this.mFileText.setEnabled(true);
            if (this.mOpenDatasetCombo.getSelectedObjects().length > 0) {
                String string = this.getFilenameFromDataset(this.mOpenDatasetCombo.getSelectedItem().toString());
                String string2 = this.mOpenDatasetCombo.getSelectedItem().toString();
                String string3 = string2.substring(string2.indexOf("[") + 1, string2.length() - 1);
                this.mFileText.setText(string3);
                this.loadAvailableList(string);
            }
        } else if (object.equals(this.mExternalDatafileRadio) && this.mExternalDatafileRadio.isSelected()) {
            this.mOpenDatasetCombo.setEnabled(false);
            this.mOpenDatasetCombo.setOpaque(false);
            this.mFileButton.setEnabled(true);
            this.mFileText.setEnabled(true);
            if (this.mPreviousFileText == null) {
                this.mFileText.setText("");
            } else {
                this.mFileText.setText(this.mPreviousFileText);
            }
            this.loadAvailableList(this.mFileText.getText());
        } else if (object.equals(this.mOpenDatasetCombo) && this.mOpenDatasetCombo.getSelectedObjects().length > 0) {
            String string = this.getFilenameFromDataset(this.mOpenDatasetCombo.getSelectedItem().toString());
            String string4 = this.mOpenDatasetCombo.getSelectedItem().toString();
            String string5 = string4.substring(string4.indexOf("[") + 1, string4.length() - 1);
            this.mFileText.setText(string5);
            this.loadAvailableList(string);
        }
    }

    public void enableComponents(boolean bl) {
        this.mReadVariableLabel.setEnabled(bl);
        this.mOpenDatasetRadio.setEnabled(bl);
        this.mExternalDatafileRadio.setEnabled(bl);
        if (this.mOpenDatasetCombo.getItemCount() > 0) {
            this.mOpenDatasetRadio.setSelected(true);
            this.mOpenDatasetCombo.setEnabled(bl);
            this.mFileButton.setEnabled(false);
            this.mFileText.setEnabled(bl);
            if (bl && this.mOpenDatasetCombo.getSelectedObjects().length > 0) {
                String string = this.getFilenameFromDataset(this.mOpenDatasetCombo.getSelectedItem().toString());
                String string2 = this.mOpenDatasetCombo.getSelectedItem().toString();
                String string3 = string2.substring(string2.indexOf("[") + 1, string2.length() - 1);
                this.mFileText.setText(string3);
                this.loadAvailableList(string);
            }
        } else {
            this.mExternalDatafileRadio.setSelected(true);
            this.mOpenDatasetCombo.setEnabled(false);
            this.mFileButton.setEnabled(bl);
            this.mFileText.setEnabled(bl);
        }
        this.mNumberMatchCountLabel.setEnabled(bl);
        this.mAvailableLabel.setEnabled(bl);
        this.mSelectedLabel.setEnabled(bl);
        this.mAvailableList.setEnabled(bl);
        this.mSelectedList.setEnabled(bl);
        if (!bl) {
            final boolean bl2 = bl;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MultiDimensionalCommonPanel.this.mArrowButton.setEnabled(bl2);
                }
            });
        } else if (this.mAvailableList.getModel().getSize() > 0 || this.mSelectedList.getModel().getSize() > 0) {
            this.mArrowButton.setEnabled(bl);
        }
        if (this.mInfoTextArea.getText().trim().length() > 0) {
            this.mInfoTextArea.setEnabled(bl);
        }
        if (this.mAvailableList.getModel().getSize() > 0) {
            this.mAvailableList.setSelectedIndex(0);
        }
    }

    public void enableVisibleComponents(boolean bl) {
        this.mAvailableLabel.setEnabled(bl);
        this.mSelectedLabel.setEnabled(bl);
        this.mAvailableList.setEnabled(bl);
        this.mSelectedList.setEnabled(bl);
        if (!bl) {
            this.mArrowButton.setEnabled(bl);
        } else if (this.mAvailableList.getModel().getSize() > 0 || this.mSelectedList.getModel().getSize() > 0) {
            this.mArrowButton.setEnabled(bl);
        }
    }

    public void makeLabelVisible(boolean bl) {
        if (bl) {
            this.mNumberMatchCountLabel.setText(sMAX_DIMENSION_LABEL);
        } else {
            this.mNumberMatchCountLabel.setText(" ");
        }
    }

    public boolean isMaxDimensionMatchesTargetListCount(String string) {
        int n;
        int n2 = Integer.parseInt(this.mMaxDimension);
        if (string != null) {
            n2 = Integer.parseInt(string);
        }
        return n2 == (n = this.mSelectedList.getModel().getSize());
    }

    public void replaceDefaultMnemonic(String string, String string2, String string3) {
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            this.mFileButton.getAction().putValue("MnemonicKey", this.mBaseDialog.getDlgAccessKey(string));
            this.mAvailableLabel.setDisplayedMnemonic(this.mBaseDialog.getDlgAccessKey(string2));
            this.mSelectedLabel.setDisplayedMnemonic(this.mBaseDialog.getDlgAccessKey(string3));
        }
    }

    public void replaceDefaultFileChooserTitleKey(String string) {
        this.mFileChooserTitle = string;
    }

    public PlainList getTargetList() {
        return this.mSelectedList;
    }

    public PlainList getSourceList() {
        return this.mAvailableList;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        super.validate();
    }

    private void initVars(String string, String string2, String string3, String string4, String string5) {
        this.mFileChooserTitle = "";
        this.mReadVariableLabel = new JLabel(this.mBaseDialog.getResString("IDS_MULTI_UNFOLD_CMN_READ_FROM"));
        String string6 = "IDS_MULTI_UNFOLD_ROW_OPEN_DATASET_RADIO";
        String string7 = "IDS_MULTI_UNFOLD_ROW_EXTERNAL_DATAFILE_RADIO";
        if (string3.equals("IDS_COL_TARGET_LST")) {
            string6 = "IDS_MULTI_UNFOLD_COL_OPEN_DATASET_RADIO";
            string7 = "IDS_MULTI_UNFOLD_COL_EXTERNAL_DATAFILE_RADIO";
        }
        ControlAction controlAction = new ToggleButtonAction(this.mBaseDialog, string6);
        this.mOpenDatasetRadio = new JRadioButton(controlAction);
        controlAction = new ToggleButtonAction(this.mBaseDialog, string7);
        this.mExternalDatafileRadio = new JRadioButton(controlAction);
        controlAction = new ToggleButtonAction(this.mBaseDialog, "IDS_MULTI_UNFOLD_CMN_FILE_THREE_DOT");
        this.mFileButton = new JButton(controlAction);
        this.mFileButton.addActionListener(new fileActionListener());
        this.mOpenDatasetCombo = new JComboBox<Object>(this.getDataSetList().toArray());
        controlAction = new ComboboxAction(this.mBaseDialog, COMBO_KEY);
        if (this.mOpenDatasetCombo.getItemCount() > 0) {
            this.mOpenDatasetRadio.setSelected(true);
        } else {
            this.mExternalDatafileRadio.setSelected(true);
        }
        this.mOpenDatasetCombo.setAction(controlAction);
        this.mOpenDatasetCombo.setMinimumSize(new Dimension(205, 20));
        this.mOpenDatasetCombo.setPreferredSize(this.mOpenDatasetCombo.getMinimumSize());
        this.mFileText = new FileTextField();
        this.mFileText.setAction(new TextFieldAction(this.mBaseDialog, string));
        this.mFileText.setColumns(19);
        this.mFileText.setBorder(BorderFactory.createEmptyBorder());
        this.mFileText.setEditable(false);
        this.mFileText.setOpaque(true);
        this.mButtonTextReadPanel = this.setupButtonTextReadPanel();
        sMAX_DIMENSION_LABEL = String.format(this.mBaseDialog.getResString("IDS_MULTI_UNFOLD_CMN_NUMBER_MATCH"), string4);
        this.mNumberMatchCountLabel = new FocusableLabel(sMAX_DIMENSION_LABEL);
        this.mInfoTextArea = new JTextArea();
        this.mInfoTextArea.setText(string5);
        this.mInfoTextArea.setEditable(false);
        this.mInfoTextArea.setOpaque(false);
        this.mAvailableLabel = DialogUtil.createLabel(this.mBaseDialog, "IDS_MULTI_UNFOLD_CMN_AVAILABLE");
        this.mSelectedLabel = new JLabel(this.mBaseDialog.getResString("IDS_MULTI_UNFOLD_CMN_SELECTED"));
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            if (this.mInfoTextArea.getText().trim().length() > 0) {
                this.mSelectedLabel.setDisplayedMnemonic(this.mBaseDialog.getDlgAccessKey("IDK_MULTI_UNFOLD_CMN_OPTION_SELECTED_KEY"));
            } else {
                this.mSelectedLabel.setDisplayedMnemonic(this.mBaseDialog.getDlgAccessKey("IDK_MULTI_UNFOLD_CMN_RESTRICT_SELECTED_KEY"));
            }
        }
        Dimension dimension = new Dimension(DialogUtil.getVarListWidth(), DialogUtil.getVarListHeight() / 2);
        this.mAvailableList = new PlainList(string2, PlainList.DragType.eAutoDragCopy);
        this.mAvailableList.setModel(new DefaultListModel());
        this.mAvailableList.setDataSource(true);
        this.mAvailableList.setAllowDuplicates(false);
        this.mAvailableList.setMinimumSize(dimension);
        this.mSrcLstScrollPane = new JScrollPane(this.mAvailableList);
        this.mSrcLstScrollPane.setPreferredSize(this.mAvailableList.getMinimumSize());
        this.mAvailableLabel.setLabelFor(this.mAvailableList);
        this.mSelectedList = new PlainList(string3, PlainList.DragType.eAutoDragCopy);
        this.mSelectedList.setModel(new DefaultListModel());
        this.mAvailableList.setAllowDuplicates(false);
        this.mSelectedList.setMinimumSize(dimension);
        this.mTargetLstScrollPane = new JScrollPane(this.mSelectedList);
        this.mTargetLstScrollPane.setPreferredSize(this.mSelectedList.getMinimumSize());
        this.mSelectedLabel.setLabelFor(this.mSelectedList);
        this.mArrowButton = new PlainListArrowButton(SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mAvailableList, SpssArrowButton.ButtonOrientation.right);
        this.mArrowButton.registerVariableList(this.mSelectedList, SpssArrowButton.ButtonOrientation.left);
        this.mArrowButton.setEnabled(false);
        this.mOpenDatasetRadio.addItemListener(this);
        this.mExternalDatafileRadio.addItemListener(this);
        this.mOpenDatasetCombo.addItemListener(this);
        this.mGrpDataSelect = new SpssButtonGroup();
        this.mGrpDataSelect.add(this.mOpenDatasetRadio);
        this.mGrpDataSelect.add(this.mExternalDatafileRadio);
    }

    private JPanel setupButtonTextReadPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(0, DialogUtil.getComponentGroupGap(), 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mFileButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        Insets insets2 = new Insets(DialogUtil.getStandardControlInsets().top * 3, DialogUtil.getComponentGroupGap(), 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mFileText), gridBagConstraints, 1, 0, 1, 1, n, insets2);
        return jPanel;
    }

    private void addComponentsToPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = new JPanel(new GridBagLayout(), true);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n, n, 0, n);
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        gridBagConstraints.fill = 0;
        Insets insets3 = DialogUtil.getStandardControlInsets();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets4 = new Insets(0, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        int n2 = 21;
        DialogUtil.addUsingGBL(jPanel2, this.mReadVariableLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets4);
        Insets insets5 = new Insets(insets3.top, DialogUtil.getGroupBoxInnerMargin() * 3, insets3.bottom, insets3.right);
        DialogUtil.addUsingGBL(jPanel2, this.mOpenDatasetRadio, gridBagConstraints, 0, 1, 1, 1, n2, insets5);
        DialogUtil.addUsingGBL(jPanel2, this.mExternalDatafileRadio, gridBagConstraints, 0, 2, 1, 1, n2, insets5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        Insets insets6 = new Insets(insets3.top + 2, DialogUtil.getComponentGroupGap(), insets3.bottom, DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(jPanel2, this.mOpenDatasetCombo, gridBagConstraints, 1, 1, 1, 1, n2, insets6);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel2, this.mButtonTextReadPanel, gridBagConstraints, 1, 2, 1, 1, n2, new Insets(insets3.top + 1, 0, insets3.bottom, insets3.right));
        gridBagConstraints.weightx = 0.0;
        n2 = 23;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 3, 1, n2, null);
        gridBagConstraints.weightx = 0.0;
        n2 = 23;
        gridBagConstraints.fill = 0;
        insets = new Insets(n, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mNumberMatchCountLabel, gridBagConstraints, 0, 1, 3, 1, n2, insets);
        if (this.mInfoTextArea.getText().trim().length() > 0) {
            n2 = 23;
            gridBagConstraints.fill = 0;
            insets = new Insets(n, n, 0, 0);
            gridBagConstraints.weightx = 0.0;
            DialogUtil.addUsingGBL(jPanel, this.mInfoTextArea, gridBagConstraints, 0, 2, 3, 1, n2, insets);
            DialogUtil.addUsingGBL(jPanel, this.mAvailableLabel, gridBagConstraints, 0, 3, 1, 1, n2, insets);
            insets = new Insets(n, 0, 0, 0);
            DialogUtil.addUsingGBL(jPanel, this.mSelectedLabel, gridBagConstraints, 2, 3, 1, 1, n2, insets);
            n2 = 10;
            DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 4, 1, 1, n2, insets2);
            n2 = 23;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            insets = new Insets(0, n, n, 0);
            DialogUtil.addUsingGBL(jPanel, this.mSrcLstScrollPane, gridBagConstraints, 0, 4, 1, 1, n2, insets);
            insets = new Insets(0, 0, n, n);
            DialogUtil.addUsingGBL(jPanel, this.mTargetLstScrollPane, gridBagConstraints, 2, 4, 1, 1, n2, insets);
        } else {
            n2 = 23;
            gridBagConstraints.fill = 0;
            insets = new Insets(n, n, 0, 0);
            gridBagConstraints.weightx = 0.0;
            DialogUtil.addUsingGBL(jPanel, this.mAvailableLabel, gridBagConstraints, 0, 2, 1, 1, n2, insets);
            insets = new Insets(n, 0, 0, 0);
            DialogUtil.addUsingGBL(jPanel, this.mSelectedLabel, gridBagConstraints, 2, 2, 1, 1, n2, insets);
            n2 = 10;
            DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 3, 1, 1, n2, insets2);
            n2 = 23;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            insets = new Insets(0, n, n, 0);
            DialogUtil.addUsingGBL(jPanel, this.mSrcLstScrollPane, gridBagConstraints, 0, 3, 1, 1, n2, insets);
            insets = new Insets(0, 0, n, n);
            DialogUtil.addUsingGBL(jPanel, this.mTargetLstScrollPane, gridBagConstraints, 2, 3, 1, 1, n2, insets);
        }
    }

    private void addVisibleComponentsToPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = new Insets(n2, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mAvailableLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mSelectedLabel, gridBagConstraints, 2, 0, 1, 1, n, insets);
        insets = new Insets(0, n2, 0, n2);
        n = 10;
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
        n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets = new Insets(0, n2, n2, 0);
        DialogUtil.addUsingGBL(jPanel, this.mSrcLstScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets = new Insets(0, 0, n2, 6 * n2);
        DialogUtil.addUsingGBL(jPanel, this.mTargetLstScrollPane, gridBagConstraints, 2, 1, 1, 1, n, insets);
    }

    private ArrayList<String> getDataSetList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        SpssFrame[] spssFrameArray = SpssFrameMgr.getSpssFrameMgr().getOpenDocuments();
        for (int i = 0; i < spssFrameArray.length; ++i) {
            if (!(spssFrameArray[i] instanceof DataFrame)) continue;
            DataFrame dataFrame = (DataFrame)spssFrameArray[i];
            String string = dataFrame.getCoreDocument().getDocName();
            String string2 = dataFrame.getDatasetName();
            String string3 = string + " [" + string2 + "]";
            if (SpssFrameMgr.getSpssFrameMgr().isDesignated(dataFrame)) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    private String getFilenameFromDataset(String string) {
        String string2 = null;
        SpssFrame[] spssFrameArray = SpssFrameMgr.getSpssFrameMgr().getOpenDocuments();
        for (int i = 0; i < spssFrameArray.length; ++i) {
            if (!(spssFrameArray[i] instanceof DataFrame)) continue;
            DataFrame dataFrame = (DataFrame)spssFrameArray[i];
            String string3 = dataFrame.getCoreDocument().getDocName();
            String string4 = dataFrame.getDatasetName();
            String string5 = string3 + " [" + string4 + "]";
            if (!string.equals(string5)) continue;
            string2 = dataFrame.getDataSource().getFileSpec();
            break;
        }
        return string2;
    }

    private boolean loadAvailableList(String string) {
        boolean bl = false;
        ((DefaultListModel)this.mSelectedList.getModel()).removeAllElements();
        ((DefaultListModel)this.mAvailableList.getModel()).removeAllElements();
        if (string.trim().length() > 0 && string != null) {
            ErrorDispatcher errorDispatcher = ErrorDispatcher.getErrorDispatcher();
            errorDispatcher.setInterceptErrors(true);
            Vector vector = new Vector();
            short s = SysFileProxy.getSysFileProxy().getSysFileVarInfo(string, vector);
            if (s == 0) {
                for (VariableBlock variableBlock : vector) {
                    if (variableBlock.getDiType() != 0) continue;
                    ((DefaultListModel)this.mAvailableList.getModel()).addElement(variableBlock.getVarName());
                }
                this.mAvailableList.requestFocus();
                if (this.mAvailableList.getModel().getSize() > 0) {
                    this.mAvailableList.setSelectedIndex(0);
                }
                bl = true;
            }
        }
        return bl;
    }

    private class fileActionListener
    implements ActionListener {
        private fileActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            Object object = actionEvent.getSource();
            if (object == MultiDimensionalCommonPanel.this.mFileButton && (string = this.readFileChooseDialog()).trim().length() > 0 && string != null) {
                MultiDimensionalCommonPanel.this.mPreviousFileText = string;
                if (MultiDimensionalCommonPanel.this.loadAvailableList(string)) {
                    MultiDimensionalCommonPanel.this.mFileText.setText(string);
                    MultiDimensionalCommonPanel.this.mFileText.setCaretPosition(0);
                }
            }
        }

        private String readFileChooseDialog() {
            ContentValidatorFileChooser contentValidatorFileChooser = new ContentValidatorFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getDataFilesDirectoryPath(), DataServerProxy.getDataProxy().isRemoteConnection());
            if (MultiDimensionalCommonPanel.this.mFileChooserTitle.trim().length() > 0) {
                contentValidatorFileChooser.setDialogTitle(MultiDimensionalCommonPanel.this.mBaseDialog.getResString(MultiDimensionalCommonPanel.this.mFileChooserTitle));
            }
            RefFileFilter refFileFilter = new RefFileFilter(MultiDimensionalCommonPanel.this.mBaseDialog.getResString("IDS_MULTI_UNFOLD_FILE_FILTER"), MultiDimensionalCommonPanel.this.mBaseDialog.getResString("IDS_MULTI_UNFOLD_FILE_EXTENSION"));
            contentValidatorFileChooser.addChoosableFileFilter((FileFilter)refFileFilter);
            contentValidatorFileChooser.setAcceptAllFileFilterUsed(true);
            contentValidatorFileChooser.setFileFilter((FileFilter)refFileFilter);
            contentValidatorFileChooser.setFileSelectionMode(0);
            contentValidatorFileChooser.showOpenDialog(MultiDimensionalCommonPanel.this.mBaseDialog.getParent());
            String string = contentValidatorFileChooser.getPath();
            return string;
        }
    }
}

