/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.fopen;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFile;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.common.fopen.RemoteFileSystemView;
import com.spss.java_client.core.comp_util.IFileBrowseCallback;
import com.spss.java_client.core.comp_util.LocalFileSysUtil;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.core.comp_util.RemoteFileStatus;
import com.spss.java_client.core.comp_util.RemoteFileSysUtil;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.syntax.SyntaxEncodingMarkerUtils;
import com.spss.java_client.core.error_handler.ErrorDispatcher;
import com.spss.java_client.core.resources.CoreResUtil;
import com.spss.java_client.core.script.engine.IScriptLanguageMgr;
import com.spss.java_client.core.script.engine.ScriptLanguageMgr;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.core.server.messages.fopenmsg.DirEntryNode;
import com.spss.java_client.core.server.messages.fopenmsg.OpenFolderResponseMsg;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.dialogs.base.file.EncryptionPasswordDlg;
import com.spss.java_client.ui.dialogs.base.file.SaveDataVariablesDlg;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.fopen.ChooserUIFactory;
import com.spss.java_client.ui.dialogs.fopen.FileDialogKeyAdapter;
import com.spss.java_client.ui.dialogs.fopen.FileViewBidi;
import com.spss.java_client.ui.dialogs.fopen.FilenameTextFieldPrompter;
import com.spss.java_client.ui.dialogs.fopen.RefWindowsFileChooserUI;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileView;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.repository.client.application.jaxws.RepositoryFolder;
import com.spss.shared.core_tools.format.CommonState;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.DlgKeyPressListener;
import com.spss.uitools.dialogs.IDlgKeyPressListener;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.util.EncodingValidator;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.charset.CoderResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.text.MessageFormat;
import java.util.BitSet;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FileChooserUI;

public class RemoteFileChooser
extends JFileChooser {
    private static final byte WRITE_PERMISSION = 0;
    private static final byte NO_WRITE_PERMISSION = 1;
    private static final byte INVALID_RESOURCE = 2;
    protected static final String SHOW_HIDDEN_PROP = "awt.file.showHiddenFiles";
    protected ChooserType mChooserType = ChooserType.OpenFile;
    protected PropertyChangeListener mShowFilesListener = null;
    protected boolean mUseFileHiding = true;
    protected String mDefaultExt = null;
    protected Vector<RefFileFilter> mFilters = new Vector(5);
    protected boolean mUseAcceptAllFileFilter = true;
    protected RefFile mCurrentDirectory = null;
    protected ChooserOption mChooserOption = ChooserOption.Generic;
    protected boolean mLockEnabled = false;
    protected boolean mPasteSelected = false;
    protected boolean mUseServerFileSystem = false;
    protected transient FileView mUIFileView = null;
    protected transient RefFile mDefaultServerDir;
    protected boolean mUseSaveAsFileChooserUI = false;
    protected boolean mShowLastSelectedFile = false;
    protected boolean mUseQuaqua = false;
    public RefFileFilter mDefaultFileFilter;
    protected Component mParentComponent;
    protected WeakReference<Component> mDialogReference;
    protected String mEncodingSelection = "";
    protected boolean mIsMinStringWidths = false;
    protected boolean mReaderLock = false;
    protected boolean mIsEncryptFileWithPassword = false;
    protected boolean mStoreModelSystemFile = false;
    protected String mEncryptFilePassword = null;
    protected String mPythonVersionSelection = "";
    protected boolean mOverwriteAlert = true;
    protected JCheckBox mWriteCheckBox;
    protected JRadioButton mWriteNamesRB;
    protected JRadioButton mWriteLabelsRB;
    protected JCheckBox mSaveValueLabelsCheckBox;
    protected JCheckBox mSaveValueLabelsToFileCheckBox;
    protected SaveDataVariablesDlg mSaveVariables;
    private FilenameTextFieldPrompter mFilenamePrompter = null;
    private boolean mAllowPesButton = true;
    private boolean mShowDownloadInfoMsg = false;
    private static IFileBrowseCallback sFileBrowseCallback = null;
    RemoteFileDialog mDialog;
    MyAWTKeyEventListener mMyAWTKeyEventListener = new MyAWTKeyEventListener();
    private boolean mActivateKeyboardMonitor = false;

    public RemoteFileChooser(ChooserType chooserType, ChooserOption chooserOption, String string, boolean bl) {
        this(chooserType, chooserOption, string, bl, false);
    }

    public RemoteFileChooser(ChooserType chooserType, ChooserOption chooserOption, String string, boolean bl, boolean bl2) {
        this(chooserType, chooserOption, string, bl, bl2, false);
    }

    public RemoteFileChooser(ChooserType chooserType, ChooserOption chooserOption, String string, boolean bl, boolean bl2, boolean bl3) {
        this(chooserType, chooserOption, string, bl, bl2, bl3, true);
    }

    public RemoteFileChooser(ChooserType chooserType, ChooserOption chooserOption, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(chooserType, chooserOption, string, bl, bl2, bl3, bl4, false);
    }

    public RemoteFileChooser(ChooserType chooserType, ChooserOption chooserOption, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        super((String)null);
        Object object;
        String string2;
        this.mChooserType = chooserType;
        this.mChooserOption = chooserOption;
        this.mUseSaveAsFileChooserUI = bl2;
        this.mShowLastSelectedFile = bl3;
        this.mUseQuaqua = ChooserUIFactory.isUseQuaqua();
        this.mAllowPesButton = bl4;
        this.mShowDownloadInfoMsg = bl5;
        if (!(!bl || ComponentState.getProcessorAvailable() || CommandLine.isClementineCaller() && RemoteFileChooser.enableSaveInModeler())) {
            this.displayProcessorLostCommunicationAlert(null);
            return;
        }
        this.mUseServerFileSystem = DataServerProxy.getDataProxy().isRemoteConnection() && bl;
        this.mDefaultExt = "";
        if (this.mChooserType == ChooserType.OpenFolder) {
            this.setFileSelectionMode(1);
            this.setAcceptAllFileFilterUsed(false);
            string2 = new RefFileFilter(CoreResUtil.getString((String)"IDS_FILE_FOLDER_FILTER"), "");
            this.setFileFilter((FileFilter)((Object)string2));
        } else {
            this.setFileSelectionMode(0);
        }
        this.setTitle();
        this.setup(null);
        string2 = string;
        if (this.mUseServerFileSystem) {
            object = (RemoteFileSystemView)this.getFileSystemView();
            object.setFoldersOnlyMode(this.mChooserType == ChooserType.OpenFolder);
            this.mCurrentDirectory = (RefFile)object.getDirectoryForPath(string2);
            if (this.mCurrentDirectory == null) {
                this.mCurrentDirectory = null;
                this.mDefaultServerDir = null;
                string2 = "";
                object.textEditString(string2);
            } else {
                object.textEditString(string2);
                object.getFiles((File)this.mCurrentDirectory, true);
                this.firePropertyChange("directoryChanged", null, this.mCurrentDirectory);
            }
        }
        ComponentState.trace1((String)("Initial file chooser path requested: " + string2), (int)15);
        if (string2 == null || string2.length() == 0) {
            this.setCurrentDirectory(null);
        } else {
            this.setCurrentDirectory(this.getFileSystemView().createFileObject(string2));
        }
        object = new FileDialogKeyAdapter(this);
        ((FileDialogKeyAdapter)object).addDlgKeyPressListener((IDlgKeyPressListener)new DlgKeyPressListener());
        if (null == System.getenv("spss.no.file.dialog.prompter") && !this.mUseServerFileSystem && !VersionInfo.IsApplicationOnCloud()) {
            this.scan(this);
            if (this.mFilenamePrompter != null) {
                this.addPropertyChangeListener(this.mFilenamePrompter.getDirectoryChangedListener());
                this.mFilenamePrompter.setRemoteFileSystemView(this.mUseServerFileSystem);
            }
        }
    }

    public int showSaveDialog(Component component, String string, String string2) throws HeadlessException {
        this.setDialogType(1);
        return this.showDialog(component, null, string, string2);
    }

    public int showSaveDialog(Component component, String string) throws HeadlessException {
        this.setDialogType(1);
        return this.showDialog(component, null, string);
    }

    public boolean isSaveDataAsFileChooser() {
        return this.mUseSaveAsFileChooserUI;
    }

    public ChooserType getChooserType() {
        return this.mChooserType;
    }

    public ChooserOption getChooserOption() {
        return this.mChooserOption;
    }

    @Deprecated
    public void setChooserOption(ChooserOption chooserOption) {
        this.mChooserOption = chooserOption;
        this.updateUI();
    }

    @Deprecated
    public String getDefaultExt() {
        return this.mDefaultExt;
    }

    public void setDefaultExt(String string) {
        this.mDefaultExt = string;
    }

    public boolean isPasteSelected() {
        return this.mPasteSelected;
    }

    public void setPasteSelected(boolean bl) {
        this.mPasteSelected = bl;
    }

    public boolean isLockSelected() {
        return this.mLockEnabled;
    }

    public void setLockSelected(boolean bl) {
        this.mLockEnabled = bl;
    }

    public boolean isServerFileSystem() {
        return this.mUseServerFileSystem;
    }

    @Deprecated
    public void setUseServerFileSystem(boolean bl) {
        this.mUseServerFileSystem = bl;
    }

    public boolean getAllowPesButton() {
        return this.mAllowPesButton;
    }

    public boolean ShowDownloadInfoMsg() {
        return this.mShowDownloadInfoMsg;
    }

    public void doHelp() {
        if (DataServerProxy.getDataProxy().isRemoteConnection()) {
            StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_file_open_dacc_id");
        } else {
            StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_fopen_help_button");
        }
    }

    @Override
    public void rescanCurrentDirectory() {
        FileSystemView fileSystemView = this.getFileSystemView();
        if (fileSystemView instanceof RemoteFileSystemView) {
            ((RemoteFileSystemView)fileSystemView).reset();
        }
        this.getUI().rescanCurrentDirectory(this);
    }

    @Override
    public int showDialog(Component component, String string) throws HeadlessException {
        return this.showDialog(component, string, null, null);
    }

    public int showDialog(Component component, String string, String string2, String string3) throws HeadlessException {
        Toolkit.getDefaultToolkit().addAWTEventListener(this.mMyAWTKeyEventListener, 8L);
        if (!ComponentState.getProcessorAvailable() && !CommandLine.isClementineCaller() && CommonState.getApplicationType() != CommonState.AppType.MODELER && CommonState.getApplicationType() != CommonState.AppType.MODELERCLOUD) {
            return 128;
        }
        if (!(component instanceof SpssFrame) && CommandLine.isClementineCaller()) {
            IFileBrowseCallback iFileBrowseCallback = RemoteFileChooser.getFileBrowseCallback();
            if (iFileBrowseCallback != null) {
                return iFileBrowseCallback.browseForServerFile(component, this.getDialogType(), this.getDialogTitle(), this.getChoosableFileFilters(), string2, string);
            }
            return 128;
        }
        if (string2 != null || !this.mShowLastSelectedFile) {
            this.setFileNameTextField(string2);
        }
        if (string3 != null && string3.length() != 0) {
            this.setEncryptFileWithPassword(true);
            this.setEncryptFilePassword(string3);
        }
        if (this.mDefaultFileFilter != null) {
            this.setFileFilter((FileFilter)this.mDefaultFileFilter);
        }
        String string4 = null;
        if (this.mUseQuaqua && this.getDialogType() == 1) {
            string4 = this.mFilenamePrompter.getPrompterTextField().getText();
        } else if (this.getUI() instanceof RefWindowsFileChooserUI) {
            string4 = this.getRefWindowsFileChooserUI().getFileNameTextField().getText();
        }
        if (string4 != null && string4.length() > 0 && FileTextField.isPathBidiProcessingNeeded(string4)) {
            if (this.mUseQuaqua && this.getDialogType() == 1) {
                this.mFilenamePrompter.getPrompterTextField().setText(FileTextField.insertLRM(string4));
            } else if (this.getUI() instanceof RefWindowsFileChooserUI) {
                this.getRefWindowsFileChooserUI().getFileNameTextField().setText(FileTextField.insertLRM(string4));
            }
        }
        int n = super.showDialog(component, string);
        FileSystemView fileSystemView = this.getFileSystemView();
        if (fileSystemView instanceof RemoteFileSystemView) {
            ((RemoteFileSystemView)fileSystemView).reset();
        }
        this.onDispose();
        return n;
    }

    public int showDialog(Component component, String string, String string2) throws HeadlessException {
        return this.showDialog(component, string, string2, null);
    }

    @Override
    public void updateUI() {
        this.installStrings();
        if (this.mUseServerFileSystem) {
            FileSystemView fileSystemView;
            if (this.isAcceptAllFileFilterUsed()) {
                this.removeChoosableFileFilter(this.getAcceptAllFileFilter());
            }
            if ((fileSystemView = this.getFileSystemView()) == null) {
                this.setFileSystemView((FileSystemView)RemoteFileSystemView.getFileSystemView());
            }
            this.setUI(null);
            this.mUIFileView = this.getUI().getFileView(this);
            if (this.isAcceptAllFileFilterUsed()) {
                this.addChoosableFileFilter(this.getAcceptAllFileFilter());
            }
        } else {
            super.updateUI();
        }
    }

    @Override
    public String getName(File file) {
        String string = null;
        if (file instanceof RefFile) {
            if (this.getFileView() != null) {
                string = this.getFileView().getName(file);
            }
            if (string == null && this.mUIFileView != null) {
                string = this.mUIFileView.getName(file);
            }
        } else {
            string = super.getName(file);
        }
        return string;
    }

    @Override
    public String getDescription(File file) {
        String string = file.getName();
        if (file instanceof RefFile) {
            if (this.getFileView() != null) {
                string = this.getFileView().getDescription(file);
            }
            if (string == null && this.mUIFileView != null) {
                string = this.mUIFileView.getDescription(file);
            }
        } else {
            string = super.getDescription(file);
        }
        return string;
    }

    @Override
    public String getTypeDescription(File file) {
        String string = null;
        if (file instanceof RefFile) {
            if (this.getFileView() != null) {
                string = this.getFileView().getTypeDescription(file);
            }
            if (string == null && this.mUIFileView != null) {
                string = this.mUIFileView.getTypeDescription(file);
            }
        } else {
            string = super.getTypeDescription(file);
        }
        return string;
    }

    @Override
    public Icon getIcon(File file) {
        Icon icon = null;
        if (file instanceof RefFile || OSInfo.getOSType() == OSInfo.OSType.MAC) {
            if (this.getFileView() != null) {
                icon = this.getFileView().getIcon(file);
            }
            if (icon == null && this.mUIFileView != null) {
                icon = this.mUIFileView.getIcon(file);
            }
            if (icon instanceof ImageIcon && icon.getIconHeight() > 26) {
                icon = this.resizeImage((ImageIcon)icon, 16, 16);
            }
        } else {
            icon = super.getIcon(file);
        }
        return icon;
    }

    @Override
    public boolean isTraversable(File file) {
        Boolean bl = null;
        if (file instanceof RefFile) {
            if (this.getFileView() != null) {
                bl = this.getFileView().isTraversable(file);
            }
            if (bl == null && this.mUIFileView != null) {
                bl = this.mUIFileView.isTraversable(file);
            }
            if (bl == null) {
                bl = this.getFileSystemView().isTraversable(file);
            }
        } else {
            bl = super.isTraversable(file);
        }
        return bl != null && bl != false;
    }

    @Override
    public void setSelectedFile(File file) {
        if (file != null) {
            String string = file.getAbsolutePath();
            if (string.length() > 0 && string.indexOf(8206) != -1) {
                string = FileTextField.removeLRM(string);
            }
            if (this.mChooserType == ChooserType.OpenFolder && string.indexOf(":\\", 4) > -1) {
                int n = string.indexOf(":\\", 4);
                int n2 = string.lastIndexOf(File.separator, n - 1);
                file = new File(string.substring(n2 + 1));
            }
            if (FileTextField.isPathBidiProcessingNeeded(file.getAbsolutePath())) {
                String string2 = FileTextField.insertLRM(file.getAbsolutePath());
                file = new File(string2);
            }
        }
        super.setSelectedFile(file);
    }

    @Override
    public void approveSelection() {
        String string = null;
        try {
            if (this.getChooserType().equals((Object)ChooserType.SaveFile) || this.getChooserType().equals((Object)ChooserType.OpenCreateFile)) {
                Object object;
                boolean bl;
                File file = this.getSelectedFile();
                boolean bl2 = bl = !file.exists();
                if (file instanceof RefFile && (object = (RefFile)file).isDirectory()) {
                    bl = false;
                }
                if (bl) {
                    Object object2;
                    object = this.getChooserOption();
                    String string2 = "";
                    if (((Enum)object).equals((Object)ChooserOption.Data)) {
                        object2 = this.getFileFilter();
                        string2 = object2 instanceof RefFileFilter ? "." + ((RefFileFilter)object2).getExtension() : ".sav";
                    } else if (((Enum)object).equals((Object)ChooserOption.Syntax)) {
                        object2 = this.getFileFilter();
                        string2 = object2 instanceof RefFileFilter ? "." + ((RefFileFilter)object2).getExtension() : ".sav";
                    } else if (((Enum)object).equals((Object)ChooserOption.Output)) {
                        object2 = this.getFileFilter();
                        string2 = object2 instanceof RefFileFilter ? "." + ((RefFileFilter)object2).getExtension() : ".spv";
                    } else if (((Enum)object).equals((Object)ChooserOption.Script)) {
                        string2 = this.getScriptFileDefaultExtension();
                    } else {
                        object2 = this.getFileFilter();
                        if (object2 instanceof RefFileFilter && ((RefFileFilter)object2).getExtension().length() > 0) {
                            string2 = "." + ((RefFileFilter)object2).getExtension();
                        }
                    }
                    string = file.getName();
                    object2 = "\"";
                    boolean bl3 = string.startsWith((String)object2) && string.endsWith((String)object2);
                    boolean bl4 = false;
                    String string3 = this.getRefWindowsFileChooserUI().GetEnteredText();
                    if (string3 != null) {
                        boolean bl5 = bl4 = string3.startsWith((String)object2) && string3.endsWith((String)object2);
                    }
                    if (bl3 || bl4) {
                        String string4 = string;
                        if (bl3) {
                            string4 = string.substring(1, string.length() - 1);
                        }
                        string = RemoteFileChooser.getDirectoryName(file, this.isServerFileSystem());
                        string = string + "\\" + string4;
                        this.setSelectedFile(new File(string));
                    } else if (string2.length() > 0 && !this.hasDesiredExtension(string, string2)) {
                        if (this.isServerFileSystem()) {
                            string = file.getCanonicalPath();
                            string = string + string2;
                            this.setSelectedFile((File)new RefFile(string));
                        } else {
                            string = file.getAbsolutePath();
                            string = string + string2;
                            this.setSelectedFile(new File(string));
                        }
                    }
                }
            }
        }
        catch (IOException iOException) {
            this.displayCannotSaveInFolderAlert(this.getDialogComponent());
            return;
        }
        ComponentState.trace1((String)("Selected file chooser path: " + string), (int)15);
        if (this.canProceed(this.getDialogComponent())) {
            ProcedureDlgMgr.getMgr().saveDialogSize(this.getClass().getName(), this.mDialog.getSize());
            ProcedureDlgMgr.getMgr().saveDialogLocation(this.getClass().getName(), this.mDialog.getLocation());
            super.approveSelection();
        }
    }

    private boolean hasDesiredExtension(String string, String string2) {
        String string3 = "";
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string3 = string.substring(n).trim();
            string3 = string3.toLowerCase(ComponentState.getSystemLocale());
        }
        return string3.equals(string2);
    }

    private String getScriptFileDefaultExtension() {
        Vector vector;
        String string = "";
        IScriptLanguageMgr iScriptLanguageMgr = ScriptLanguageMgr.getInstance();
        Vector vector2 = iScriptLanguageMgr.getAllLanguages();
        if (!vector2.isEmpty() && !(vector = iScriptLanguageMgr.getDefaultLanguage().getFileExtensions()).isEmpty()) {
            string = "." + (String)vector.get(0);
        }
        return string;
    }

    private void displayCannotSaveInFolderAlert(Component component) {
        if (component instanceof Window) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)component, CoreResUtil.getString((String)"ERR_CANNOT_SAVE_IN_SPECIFIED_FOLDER"), VersionInfo.getAppVersionString());
        } else if (component instanceof JComponent) {
            SpssAlertOptionPane.showWarningMessageDialog((JComponent)component, CoreResUtil.getString((String)"ERR_CANNOT_SAVE_IN_SPECIFIED_FOLDER"), VersionInfo.getAppVersionString());
        } else {
            JOptionPane.showMessageDialog(this, CoreResUtil.getString((String)"ERR_CANNOT_SAVE_IN_SPECIFIED_FOLDER"), VersionInfo.getAppVersionString(), 2);
        }
    }

    @Override
    public void setFileSystemView(FileSystemView fileSystemView) {
        if (this.mUseServerFileSystem && !(fileSystemView instanceof RemoteFileSystemView)) {
            assert (false);
            return;
        }
        super.setFileSystemView(fileSystemView);
    }

    @Override
    public FileFilter[] getChoosableFileFilters() {
        if (this.mUseServerFileSystem) {
            int n = this.mFilters != null ? this.mFilters.size() : 0;
            Object[] objectArray = new RefFileFilter[n];
            if (this.mFilters != null) {
                this.mFilters.copyInto(objectArray);
            }
            return objectArray;
        }
        return super.getChoosableFileFilters();
    }

    @Override
    public void addChoosableFileFilter(FileFilter fileFilter) {
        if (this.mUseServerFileSystem && fileFilter instanceof RefFileFilter) {
            RefFileFilter refFileFilter = (RefFileFilter)fileFilter;
            if (!this.mFilters.contains(refFileFilter)) {
                FileFilter[] fileFilterArray = this.getChoosableFileFilters();
                this.mFilters.addElement(refFileFilter);
                this.firePropertyChange("ChoosableFileFilterChangedProperty", fileFilterArray, this.getChoosableFileFilters());
            }
            this.setFileFilter(fileFilter);
        } else {
            super.addChoosableFileFilter(fileFilter);
        }
    }

    @Override
    public boolean removeChoosableFileFilter(FileFilter fileFilter) {
        if (this.mUseServerFileSystem) {
            if (!(fileFilter instanceof RefFileFilter)) {
                assert (false);
                return false;
            }
            if (this.hasFilter((RefFileFilter)fileFilter)) {
                if (this.getFileFilter() == fileFilter) {
                    this.setFileFilter(null);
                }
                FileFilter[] fileFilterArray = this.getChoosableFileFilters();
                this.mFilters.removeElementAt(this.getFilterIndex((RefFileFilter)fileFilter));
                this.firePropertyChange("ChoosableFileFilterChangedProperty", fileFilterArray, this.getChoosableFileFilters());
                return true;
            }
            return false;
        }
        return super.removeChoosableFileFilter(fileFilter);
    }

    @Override
    public void resetChoosableFileFilters() {
        if (this.mUseServerFileSystem) {
            RefFileFilter[] refFileFilterArray = (RefFileFilter[])this.getChoosableFileFilters();
            this.setFileFilter(null);
            this.mFilters.removeAllElements();
            if (this.isAcceptAllFileFilterUsed()) {
                this.addChoosableFileFilter(this.getAcceptAllFileFilter());
            }
            this.firePropertyChange("ChoosableFileFilterChangedProperty", refFileFilterArray, this.getChoosableFileFilters());
        } else {
            super.resetChoosableFileFilters();
        }
    }

    @Override
    public FileFilter getAcceptAllFileFilter() {
        if (this.mUseServerFileSystem) {
            String string = CoreResUtil.getString((String)"IDS_FILE_CHOOSER_ACCEPT_ALL_FILE_FILTER_TEXT");
            return new RefFileFilter(string, "");
        }
        return super.getAcceptAllFileFilter();
    }

    @Override
    public boolean isAcceptAllFileFilterUsed() {
        if (this.mUseServerFileSystem) {
            return this.mUseAcceptAllFileFilter;
        }
        return super.isAcceptAllFileFilterUsed();
    }

    @Override
    public void setAcceptAllFileFilterUsed(boolean bl) {
        if (this.mUseServerFileSystem) {
            boolean bl2 = this.mUseAcceptAllFileFilter;
            this.mUseAcceptAllFileFilter = bl;
            if (!bl) {
                this.removeChoosableFileFilter(this.getAcceptAllFileFilter());
            } else {
                this.removeChoosableFileFilter(this.getAcceptAllFileFilter());
                this.addChoosableFileFilter(this.getAcceptAllFileFilter());
            }
            this.firePropertyChange("acceptAllFileFilterUsedChanged", bl2, this.mUseAcceptAllFileFilter);
        } else {
            super.setAcceptAllFileFilterUsed(bl);
        }
    }

    @Override
    public File getCurrentDirectory() {
        if (this.mUseServerFileSystem) {
            return this.mCurrentDirectory;
        }
        return super.getCurrentDirectory();
    }

    public RemoteFileStatus validateServerFile(String string) {
        RemoteFileStatus remoteFileStatus = null;
        File file = this.getCurrentDirectory();
        if (file instanceof RefFile) {
            RefFile refFile = (RefFile)file;
            RemoteFileSystemView remoteFileSystemView = (RemoteFileSystemView)this.getFileSystemView();
            Vector vector = refFile.getPathNodes();
            if (!vector.isEmpty()) {
                DirEntryNode dirEntryNode = (DirEntryNode)vector.get(vector.size() - 1);
                if (string.compareToIgnoreCase(dirEntryNode.getNodeName()) == 0) {
                    string = "";
                }
                boolean bl = this.getChooserType() == ChooserType.SaveFile || this.getChooserType() == ChooserType.OpenCreateFile;
                OpenFolderResponseMsg openFolderResponseMsg = remoteFileSystemView.validateFile(refFile.getPathNodes(), string, bl ? 2 : 1);
                remoteFileStatus = new RemoteFileStatus();
                if (openFolderResponseMsg.errorExists() != 0) {
                    short s = (short)openFolderResponseMsg.errorExists();
                    String string2 = openFolderResponseMsg.getError().getText1();
                    if (s == 2011) {
                        s = 2010;
                        String string3 = ResUtil.getComponentString(DataMgr.getErrorResId((int)s));
                        string2 = String.format(string3, string2);
                    }
                    ErrorDispatcher.getErrorDispatcher().dispatchError(s, string2);
                    remoteFileStatus.setErrorOccurred(true);
                } else if (openFolderResponseMsg.fileState() == 0 || openFolderResponseMsg.fileState() == 1 || openFolderResponseMsg.fileState() == 2 && bl) {
                    Vector vector2;
                    remoteFileStatus = RemoteFileSysUtil.getRemoteFileSysUtil().validateFile(openFolderResponseMsg.getPathString());
                    if (!remoteFileStatus.errorOccurred() && !(vector2 = openFolderResponseMsg.getSelectedNodePath()).isEmpty()) {
                        RefFile refFile2;
                        RefFile refFile3 = new RefFile((DirEntryNode)vector2.get(vector2.size() - 1), vector2);
                        if (remoteFileStatus.getFilePathIsDirectory()) {
                            if (this.mChooserType != ChooserType.OpenFolder) {
                                this.getRefWindowsFileChooserUI().getFileNameTextField().setText("");
                            } else {
                                refFile3 = new RefFile(openFolderResponseMsg.getPathString());
                            }
                            refFile2 = null;
                        } else if (!bl) {
                            refFile2 = new RefFile(openFolderResponseMsg.getPathString());
                        } else {
                            refFile2 = new RefFile(openFolderResponseMsg.getPathString());
                            refFile3 = new RefFile((DirEntryNode)vector2.get(vector2.size() - 1), vector2);
                        }
                        this.setCurrentDirectory((File)refFile3);
                        if (this.mChooserType != ChooserType.OpenFolder) {
                            this.setSelectedFile((File)refFile2);
                        }
                    }
                } else {
                    remoteFileStatus.setFileStatus(RemoteFileStatus.FileNodeStatus.RFS_DOES_NOT_EXIST);
                    remoteFileStatus.setParentDirStatus(RemoteFileStatus.FileNodeStatus.RFS_DOES_NOT_EXIST);
                }
            }
        }
        return remoteFileStatus;
    }

    public RemoteFileStatus getServerFileStatus(String string) {
        RemoteFileStatus remoteFileStatus = null;
        File file = this.getCurrentDirectory();
        if (file instanceof RefFile) {
            RefFile refFile = (RefFile)file;
            RemoteFileSystemView remoteFileSystemView = (RemoteFileSystemView)this.getFileSystemView();
            Vector vector = refFile.getPathNodes();
            if (!vector.isEmpty()) {
                DirEntryNode dirEntryNode = (DirEntryNode)vector.get(vector.size() - 1);
                if (string.compareToIgnoreCase(dirEntryNode.getNodeName()) == 0) {
                    string = "";
                }
                boolean bl = this.getChooserType() == ChooserType.SaveFile || this.getChooserType() == ChooserType.OpenCreateFile;
                OpenFolderResponseMsg openFolderResponseMsg = remoteFileSystemView.validateFile(vector, string, bl ? 2 : 1);
                remoteFileStatus = new RemoteFileStatus();
                if (openFolderResponseMsg.errorExists() != 0) {
                    ErrorDispatcher.getErrorDispatcher().dispatchError((short)openFolderResponseMsg.errorExists(), openFolderResponseMsg.getError().getText1());
                    remoteFileStatus.setErrorOccurred(true);
                } else if (openFolderResponseMsg.fileState() == 0 || openFolderResponseMsg.fileState() == 1 || openFolderResponseMsg.fileState() == 2 && bl) {
                    remoteFileStatus = RemoteFileSysUtil.getRemoteFileSysUtil().validateFile(openFolderResponseMsg.getPathString());
                } else {
                    remoteFileStatus.setFileStatus(RemoteFileStatus.FileNodeStatus.RFS_DOES_NOT_EXIST);
                    remoteFileStatus.setParentDirStatus(RemoteFileStatus.FileNodeStatus.RFS_DOES_NOT_EXIST);
                }
            }
        }
        return remoteFileStatus;
    }

    @Override
    public void setCurrentDirectory(File file) {
        if (this.mFilters == null) {
            return;
        }
        if (this.mUseServerFileSystem) {
            assert (file == null || file instanceof RefFile);
            RefFile refFile = this.mCurrentDirectory;
            if (file == null || file.getPath().length() == 0) {
                if (this.mDefaultServerDir == null) {
                    this.mDefaultServerDir = (RefFile)this.getFileSystemView().getDefaultDirectory();
                    file = this.mDefaultServerDir;
                } else {
                    file = this.mCurrentDirectory != null ? this.mCurrentDirectory.getParentFile() : this.mDefaultServerDir;
                }
            }
            if (this.mCurrentDirectory != null && this.mCurrentDirectory.equals((Object)file)) {
                return;
            }
            RemoteFileSystemView remoteFileSystemView = (RemoteFileSystemView)this.getFileSystemView();
            while (file != null && !this.isTraversable(file)) {
                file = remoteFileSystemView.getParentDirectory(file);
            }
            if (this.mFilters != null && file != null) {
                String string = this.getRefWindowsFileChooserUI().getFileNameTextField().getText();
                remoteFileSystemView.textEditString(string);
                RefFile refFile2 = (RefFile)file;
                if (refFile2.getPathNodes() == null || refFile2.getPathNodes().size() == 0) {
                    try {
                        refFile2 = (RefFile)remoteFileSystemView.getDirectoryForPath(file.getPath());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        refFile2 = (RefFile)file;
                    }
                }
                this.mCurrentDirectory = refFile2;
                this.firePropertyChange("directoryChanged", refFile, this.mCurrentDirectory);
            } else {
                remoteFileSystemView.textEditString("");
            }
            this.rescanCurrentDirectory();
        } else {
            super.setCurrentDirectory(file);
        }
        if (file != null && !this.mUseQuaqua && !this.mUseServerFileSystem) {
            ((RefWindowsFileChooserUI)((Object)this.getUI())).enableNewFolderButton(this.canWriteFile(file.getAbsolutePath()) == 0);
        }
        if (VersionInfo.IsApplicationOnCloud() && file != null) {
            ((RefWindowsFileChooserUI)((Object)this.getUI())).enableUpFolderButton(file.getAbsolutePath().startsWith("/UserData/") && !file.getAbsolutePath().equalsIgnoreCase("/UserData/"));
        }
    }

    @Override
    public boolean isFileHidingEnabled() {
        if (this.mUseServerFileSystem) {
            return this.mUseFileHiding;
        }
        return super.isFileHidingEnabled();
    }

    @Override
    public void setFileHidingEnabled(boolean bl) {
        if (this.mUseServerFileSystem) {
            if (this.mShowFilesListener != null) {
                Toolkit.getDefaultToolkit().removePropertyChangeListener(SHOW_HIDDEN_PROP, this.mShowFilesListener);
                this.mShowFilesListener = null;
            }
            boolean bl2 = this.mUseFileHiding;
            this.mUseFileHiding = bl;
            ((RemoteFileSystemView)this.getFileSystemView()).reset();
            this.firePropertyChange("FileHidingChanged", bl2, this.mUseFileHiding);
        } else {
            super.setFileHidingEnabled(bl);
        }
    }

    @Override
    public FileSystemView getFileSystemView() {
        Object object = this.mUseServerFileSystem ? RemoteFileSystemView.getFileSystemView() : FileSystemView.getFileSystemView();
        this.setFileSystemView((FileSystemView)object);
        return object;
    }

    public void setFileFilter(FileFilter fileFilter, boolean bl) {
        this.setFileFilter(fileFilter);
        if (bl && fileFilter instanceof RefFileFilter) {
            this.mDefaultFileFilter = (RefFileFilter)fileFilter;
        }
    }

    @Override
    public void setFileFilter(FileFilter fileFilter) {
        String string;
        if (fileFilter == null) {
            super.setFileFilter(null);
            return;
        }
        if (fileFilter instanceof RefFileFilter) {
            super.setFileFilter(fileFilter);
            if (ChooserOption.Script == this.mChooserOption) {
                boolean bl = fileFilter.getDescription().toLowerCase().contains("python");
                this.getRefWindowsFileChooserUI().setPythonVersionControlsEnabled(bl);
            }
            return;
        }
        for (FileFilter object2 : this.getChoosableFileFilters()) {
            if (!fileFilter.getDescription().equals(object2.getDescription())) continue;
            super.setFileFilter(fileFilter);
            return;
        }
        int n = fileFilter.getDescription().lastIndexOf(File.separator);
        if (n > -1) {
            string = fileFilter.getDescription().substring(n + 1, fileFilter.getDescription().length());
            this.setCurrentDirectory(new File(fileFilter.getDescription().substring(0, n + 1)));
        } else {
            string = fileFilter.getDescription();
        }
        final String string2 = string;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RemoteFileChooser.this.setSelectedFile(new File(string2));
            }
        });
        ComponentState.trace1((String)("File Filter Value: " + string), (int)1024);
        int n2 = fileFilter.getDescription().lastIndexOf("*.*");
        if (n2 > -1) {
            super.setFileFilter(fileFilter);
            return;
        }
        FilenameTextFieldPrompter.PatternFileFilter patternFileFilter = new FilenameTextFieldPrompter.PatternFileFilter(string);
        this.addChoosableFileFilter(patternFileFilter);
        super.setFileFilter(patternFileFilter);
    }

    public Component getParentComponent() {
        return this.mParentComponent;
    }

    public Component getDialogComponent() {
        Component component = (Component)this.mDialogReference.get();
        if (component != null) {
            return component;
        }
        return this.mParentComponent;
    }

    @Deprecated
    public void setSaveCheckBoxes(JCheckBox jCheckBox, JCheckBox jCheckBox2, JCheckBox jCheckBox3) {
        this.mWriteCheckBox = jCheckBox;
        this.mSaveValueLabelsCheckBox = jCheckBox2;
        this.mSaveValueLabelsToFileCheckBox = jCheckBox3;
    }

    @Deprecated
    public void setSaveVariablesDlg(SaveDataVariablesDlg saveDataVariablesDlg) {
        this.mSaveVariables = saveDataVariablesDlg;
    }

    public JCheckBox getWriteCheckBox() {
        return this.mWriteCheckBox;
    }

    public JRadioButton getWriteVarLabelsRB() {
        return this.mWriteLabelsRB;
    }

    public JCheckBox getSaveValueLabelsCheckBox() {
        return this.mSaveValueLabelsCheckBox;
    }

    public JCheckBox getSaveValueLabelsToFileCheckBox() {
        return this.mSaveValueLabelsToFileCheckBox;
    }

    public boolean getIsMinimizeStringWidths() {
        return this.mUseQuaqua ? this.mIsMinStringWidths : this.getRefWindowsFileChooserUI().getIsMinimizeStringWidths();
    }

    @Deprecated
    public void setIsMinimizeStringWidths(boolean bl) {
        if (this.mUseQuaqua) {
            this.mIsMinStringWidths = bl;
        } else {
            this.getRefWindowsFileChooserUI().setIsMinimizeStringWidths(bl);
        }
    }

    public boolean readerLock() {
        return this.mUseQuaqua ? this.mReaderLock : this.getRefWindowsFileChooserUI().readerLock();
    }

    public void readerLock(boolean bl) {
        if (this.mUseQuaqua) {
            this.mReaderLock = bl;
        } else {
            this.getRefWindowsFileChooserUI().readerLock(bl);
        }
    }

    public boolean isEncryptFileWithPassword() {
        return this.mUseQuaqua ? this.mIsEncryptFileWithPassword : this.getRefWindowsFileChooserUI().isEncryptFileWithPasswordSelected();
    }

    public void setEncryptFileWithPassword(boolean bl) {
        if (this.mUseQuaqua) {
            this.mIsEncryptFileWithPassword = bl;
        } else {
            this.getRefWindowsFileChooserUI().selectEncryptFileWithPassword(bl);
        }
    }

    public String getEncryptFilePassword() {
        return this.mUseQuaqua ? this.mEncryptFilePassword : this.getRefWindowsFileChooserUI().getEncryptFilePassword();
    }

    public void setEncryptFilePassword(String string) {
        if (this.mUseQuaqua) {
            this.mEncryptFilePassword = string;
        } else {
            this.getRefWindowsFileChooserUI().setEncryptFilePassword(string);
        }
    }

    public boolean getStoreModelSystemFileFlag() {
        return this.mUseQuaqua ? this.mStoreModelSystemFile : this.getRefWindowsFileChooserUI().getStoreModelSystemFileFlag();
    }

    public String getDropVariablesSyntax() {
        if (this.mSaveVariables == null) {
            return null;
        }
        return this.mSaveVariables.getDropSyntaxString();
    }

    public String getKeptVariablesString() {
        if (this.mSaveVariables == null) {
            return null;
        }
        return this.mSaveVariables.getKeepSyntaxString();
    }

    public boolean isEncodingSelectionEnabled() {
        boolean bl = false;
        RefWindowsFileChooserUI refWindowsFileChooserUI = (RefWindowsFileChooserUI)((Object)this.getUI());
        if (refWindowsFileChooserUI != null) {
            bl = refWindowsFileChooserUI.isEncodingEnabled();
        }
        return bl;
    }

    public String getEncodingSelection() {
        String string;
        if (this.mUseQuaqua) {
            string = this.mEncodingSelection;
        } else {
            RefWindowsFileChooserUI refWindowsFileChooserUI = (RefWindowsFileChooserUI)((Object)this.getUI());
            string = refWindowsFileChooserUI.getSelectedEncoding();
        }
        return string;
    }

    public void setEncodingSelection(String string) {
        if (this.mUseQuaqua) {
            this.mEncodingSelection = string;
        } else {
            RefWindowsFileChooserUI refWindowsFileChooserUI = (RefWindowsFileChooserUI)((Object)this.getUI());
            refWindowsFileChooserUI.setSelectedEncoding(string);
        }
    }

    public static void setFilebrowseCallback(IFileBrowseCallback iFileBrowseCallback) {
        sFileBrowseCallback = iFileBrowseCallback;
    }

    public static IFileBrowseCallback getFileBrowseCallback() {
        return sFileBrowseCallback;
    }

    public static boolean enableSaveInModeler() {
        return !CommandLine.isClementineCaller() || RemoteFileChooser.getFileBrowseCallback() != null && !RemoteFileChooser.getFileBrowseCallback().isFromModelerModelNode();
    }

    public String getPythonVersionSelection() {
        String string;
        if (this.mUseQuaqua) {
            string = this.mPythonVersionSelection;
        } else {
            RefWindowsFileChooserUI refWindowsFileChooserUI = (RefWindowsFileChooserUI)((Object)this.getUI());
            string = refWindowsFileChooserUI.getSelectedPythonVersion();
        }
        return string;
    }

    public void setPythonVersionSelection(String string) {
        if (this.mUseQuaqua) {
            this.mPythonVersionSelection = string;
        } else {
            RefWindowsFileChooserUI refWindowsFileChooserUI = (RefWindowsFileChooserUI)((Object)this.getUI());
            refWindowsFileChooserUI.setSelectedPythonVersion(string);
        }
    }

    public void setPythonVersionControlsVisible(boolean bl) {
        RefWindowsFileChooserUI refWindowsFileChooserUI = (RefWindowsFileChooserUI)((Object)this.getUI());
        refWindowsFileChooserUI.setPythonVersionControlsVisible(bl);
    }

    protected void installStrings() {
        this.putClientProperty("FileChooser.useShellFolder", !this.mUseServerFileSystem);
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            this.putClientProperty("FileChooser.useShellFolder", false);
        }
        UIManager.getDefaults().put("FileChooser.lookInLabelText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_LOOK_IN_LABEL_TEXT"));
        if (this.hasResource("IDS_FILE_CHOOSER_LOOK_IN_LABEL_KEY")) {
            UIManager.getDefaults().put("FileChooser.lookInLabelMnemonic", CoreResUtil.getDlgAccessKey((String)"IDS_FILE_CHOOSER_LOOK_IN_LABEL"));
        }
        UIManager.getDefaults().put("FileChooser.fileNameLabelText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_FILE_NAME_LABEL_TEXT"));
        if (this.hasResource("IDS_FILE_CHOOSER_FILE_NAME_LABEL_KEY")) {
            UIManager.getDefaults().put("FileChooser.fileNameLabelMnemonic", CoreResUtil.getDlgAccessKey((String)"IDS_FILE_CHOOSER_FILE_NAME_LABEL"));
        }
        UIManager.getDefaults().put("FileChooser.filesOfTypeLabelText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_FILES_OF_TYPE_LABEL_TEXT"));
        if (this.hasResource("IDS_FILE_CHOOSER_FILES_OF_TYPE_LABEL_KEY")) {
            UIManager.getDefaults().put("FileChooser.filesOfTypeLabelMnemonic", CoreResUtil.getDlgAccessKey((String)"IDS_FILE_CHOOSER_FILES_OF_TYPE_LABEL"));
        }
        UIManager.getDefaults().put("FileChooser.saveInLabelText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_SAVE_IN_LABEL_TEXT"));
        UIManager.getDefaults().put("FileChooser.acceptAllFileFilterText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_ACCEPT_ALL_FILE_FILTER_TEXT"));
        UIManager.getDefaults().put("FileChooser.readOnly", (Object)this.mUseServerFileSystem);
        if (CoreResUtil.getString((String)"IDS_FILE_CHOOSER_OPEN_BUTTON_TEXT") != null) {
            UIManager.getDefaults().put("FileChooser.openButtonText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_OPEN_BUTTON_TEXT"));
        }
        if (CoreResUtil.getString((String)"IDS_FILE_CHOOSER_CANCEL_BUTTON_TEXT") != null) {
            UIManager.getDefaults().put("FileChooser.cancelButtonText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_CANCEL_BUTTON_TEXT"));
        }
        if (CoreResUtil.getString((String)"IDS_FILE_CHOOSER_UP_FOLDER_TOOLTIP_TEXT") != null) {
            UIManager.getDefaults().put("FileChooser.upFolderToolTipText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_UP_FOLDER_TOOLTIP_TEXT"));
        }
        if (CoreResUtil.getString((String)"IDS_FILE_CHOOSER_DETAILS_VIEW_TOOLTIP_TEXT") != null) {
            UIManager.getDefaults().put("FileChooser.detailsViewButtonToolTipText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_DETAILS_VIEW_TOOLTIP_TEXT"));
        }
        if (CoreResUtil.getString((String)"IDS_FILE_CHOOSER_SAVE_BUTTON_TEXT") != null) {
            UIManager.getDefaults().put("FileChooser.saveButtonText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_SAVE_BUTTON_TEXT"));
        }
        if (CoreResUtil.getString((String)"IDS_FILE_CHOOSER_NEW_FOLDER_TOOLTIP_TEXT") != null) {
            UIManager.getDefaults().put("FileChooser.newFolderToolTipText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_NEW_FOLDER_TOOLTIP_TEXT"));
        }
        if (CoreResUtil.getString((String)"IDS_FILE_CHOOSER_LIST_VIEW_TOOLTIP_TEXT") != null) {
            UIManager.getDefaults().put("FileChooser.listViewButtonToolTipTextlist", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_LIST_VIEW_TOOLTIP_TEXT"));
        }
        if (this.hasResource("IDK_FILE_CHOOSER_OPEN_BUTTON_KEY")) {
            UIManager.getDefaults().put("FileChooser.openButtonMnemonic", CoreResUtil.getDlgAccessKey((String)"IDK_FILE_CHOOSER_OPEN_BUTTON"));
        }
        UIManager.getDefaults().put("FileChooser.cancelButtonMnemonic", CoreResUtil.getDlgAccessKey((String)"IDK_FILE_CHOOSER_CANCEL_BUTTON"));
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            UIManager.getDefaults().put("FileChooser.lookInLabelMnemonic", (Object)35);
            UIManager.getDefaults().put("FileChooser.fileNameLabelMnemonic", (Object)35);
            UIManager.getDefaults().put("FileChooser.filesOfTypeLabelMnemonic", (Object)35);
            UIManager.getDefaults().put("FileChooser.saveButtonMnemonic", (Object)35);
            UIManager.getDefaults().put("FileChooser.openButtonMnemonic", (Object)35);
            UIManager.getDefaults().put("FileChooser.newFolderTitleText", UIManager.getString("FileChooser.win32.newFolder"));
        } else {
            this.convertMnemonicKeyValues(true);
        }
        if (this.getChooserType().equals((Object)ChooserType.SaveFile)) {
            UIManager.getDefaults().put("FileChooser.filesOfTypeLabelText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_SAVE_FILES_OF_TYPE_LABEL_TEXT"));
            if (this.hasResource("IDS_FILE_CHOOSER_SAVE_FILES_OF_TYPE_LABEL_KEY")) {
                UIManager.getDefaults().put("FileChooser.filesOfTypeLabelMnemonic", CoreResUtil.getDlgAccessKey((String)"IDS_FILE_CHOOSER_SAVE_FILES_OF_TYPE_LABEL"));
            }
        }
        if (this.mChooserType == ChooserType.OpenFolder) {
            UIManager.getDefaults().put("FileChooser.fileNameLabelText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_FOLDER_LABEL_TEXT"));
            if (this.hasResource("IDS_FILE_CHOOSER_FOLDER_LABEL_KEY")) {
                UIManager.getDefaults().put("FileChooser.fileNameLabelMnemonic", CoreResUtil.getDlgAccessKey((String)"IDS_FILE_CHOOSER_FOLDER_LABEL"));
            }
        }
    }

    public void convertMnemonicKeyValues(boolean bl) {
        UIToolDialogUtil.CommonLAFFileChooser.convertMnemonicKeyValues((String)"FileChooser.lookInLabelMnemonic", (boolean)bl);
        UIToolDialogUtil.CommonLAFFileChooser.convertMnemonicKeyValues((String)"FileChooser.fileNameLabelMnemonic", (boolean)bl);
        UIToolDialogUtil.CommonLAFFileChooser.convertMnemonicKeyValues((String)"FileChooser.filesOfTypeLabelMnemonic", (boolean)bl);
    }

    private boolean hasResource(String string) {
        ResourceBundle resourceBundle = CoreResUtil.getBundle(null, null);
        if (resourceBundle != null) {
            try {
                return resourceBundle.getObject(string) != null;
            }
            catch (MissingResourceException missingResourceException) {
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return false;
    }

    @Override
    protected void setUI(ComponentUI componentUI) {
        if (this.mUseQuaqua) {
            FileChooserUI fileChooserUI = ChooserUIFactory.getMacChooserUI(this, this.mChooserType == ChooserType.SaveFile);
            super.setUI(fileChooserUI);
        } else {
            FileChooserUI fileChooserUI = ChooserUIFactory.getChooserUI(this);
            super.setUI(fileChooserUI);
        }
    }

    protected boolean hasFilter(RefFileFilter refFileFilter) {
        return this.mUseServerFileSystem && this.getFilterIndex(refFileFilter) > -1;
    }

    protected int getFilterIndex(RefFileFilter refFileFilter) {
        for (int i = 0; i < this.mFilters.size(); ++i) {
            RefFileFilter refFileFilter2 = this.mFilters.get(i);
            if (!refFileFilter2.getDescription().equals(refFileFilter.getDescription()) || !refFileFilter2.getExtension().equals(refFileFilter.getExtension())) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected void setup(FileSystemView fileSystemView) {
        if (this.mFilters == null) {
            return;
        }
        if (this.mUseServerFileSystem || OSInfo.getOSType() == OSInfo.OSType.MAC) {
            assert (fileSystemView == null || fileSystemView instanceof RemoteFileSystemView);
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Object object = toolkit.getDesktopProperty(SHOW_HIDDEN_PROP);
            if (object instanceof Boolean) {
                this.mUseFileHiding = (Boolean)object == false;
                this.mShowFilesListener = new WeakPCL(this);
                toolkit.addPropertyChangeListener(SHOW_HIDDEN_PROP, this.mShowFilesListener);
            }
            RemoteFileView remoteFileView = new RemoteFileView();
            this.setFileView(remoteFileView);
            if (fileSystemView == null) {
                fileSystemView = RemoteFileSystemView.getFileSystemView();
            }
            this.setFileSystemView(fileSystemView);
            this.updateUI();
        } else {
            super.setup(fileSystemView);
            if (ComponentState.isBtdRtlOrLtr()) {
                super.setFileView(new FileViewBidi());
            }
        }
    }

    @Deprecated
    protected String getFilterString() {
        RefFileFilter refFileFilter;
        String string = "";
        FileFilter fileFilter = this.getFileFilter();
        RefFileFilter refFileFilter2 = refFileFilter = fileFilter instanceof RefFileFilter ? (RefFileFilter)fileFilter : null;
        if (refFileFilter != null) {
            string = "*." + refFileFilter.getExtension();
        }
        return string;
    }

    @Override
    protected JDialog createDialog(Component component) throws HeadlessException {
        JButton jButton;
        Point point;
        boolean bl;
        Container container;
        RemoteFileDialog remoteFileDialog;
        String string = this.getUI().getDialogTitle(this);
        this.getAccessibleContext().setAccessibleDescription(string);
        this.mParentComponent = component;
        if (component instanceof JDialog) {
            remoteFileDialog = new RemoteFileDialog((JDialog)component, string);
        } else {
            container = JOptionPane.getFrameForComponent(component);
            remoteFileDialog = new RemoteFileDialog((Frame)container, string);
        }
        this.mDialogReference = new WeakReference<RemoteFileDialog>(remoteFileDialog);
        remoteFileDialog.setComponentOrientation(this.getComponentOrientation());
        container = remoteFileDialog.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this, "Center");
        if (JDialog.isDefaultLookAndFeelDecorated() && (bl = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            remoteFileDialog.getRootPane().setWindowDecorationStyle(6);
        }
        remoteFileDialog.pack();
        Dimension dimension = ProcedureDlgMgr.getMgr().getDialogSize(this.getClass().getName());
        if (dimension != null) {
            remoteFileDialog.setSize(dimension);
        }
        if ((point = ProcedureDlgMgr.getMgr().getDialogLocation(this.getClass().getName())) != null) {
            remoteFileDialog.setLocation(point);
        } else {
            remoteFileDialog.setLocationRelativeTo(component);
        }
        if (this.mUseQuaqua) {
            super.getUI().update(null, null);
        }
        if ((jButton = this.getApproveButton()) != null) {
            remoteFileDialog.getRootPane().setDefaultButton(jButton);
        }
        this.mDialog = remoteFileDialog;
        return remoteFileDialog;
    }

    protected void setFocusOnFileNameTextField() {
        this.getRefWindowsFileChooserUI().getFileNameTextField().requestFocusInWindow();
        this.getRefWindowsFileChooserUI().getFileNameTextField().selectAll();
    }

    public void setFileNameTextField(String string) {
        String string2 = string = string != null ? string : "";
        if (FileTextField.isPathBidiProcessingNeeded(string)) {
            string = FileTextField.insertLRM(string);
        }
        if (this.mUseQuaqua && this.getDialogType() == 1) {
            this.mFilenamePrompter.getPrompterTextField().setText(string);
        } else if (this.getUI() instanceof RefWindowsFileChooserUI) {
            this.getRefWindowsFileChooserUI().getFileNameTextField().setText(string);
        }
    }

    public String getSelectedFilePath() {
        Object object;
        if (CommandLine.isClementineCaller() && (object = RemoteFileChooser.getFileBrowseCallback()) != null) {
            return object.getSelectedFilePath();
        }
        object = this.getSelectedFile();
        String string = null;
        if (object != null) {
            if (this.mChooserType == ChooserType.OpenFolder && (string = ((File)object).getPath()).indexOf(":\\", 4) > -1) {
                return string;
            }
            string = ((File)object).getAbsolutePath();
            PesFile pesFile = PES_Repository.getPesFile((String)string);
            if (pesFile != null) {
                string = pesFile.getUri();
            }
        }
        return string;
    }

    public String getSelectedFileName() {
        String string = null;
        File file = this.getSelectedFile();
        if (file != null) {
            string = file.getName();
            PesFile pesFile = PES_Repository.getPesFile((String)file.getAbsolutePath());
            if (pesFile != null) {
                string = pesFile.getUri();
            }
        }
        return string;
    }

    @Override
    public File getSelectedFile() {
        CharSequence charSequence;
        File file = super.getSelectedFile();
        if (file != null && file.getPath().length() > 0 && file.getPath().indexOf(8206) != -1) {
            charSequence = FileTextField.removeLRM(file.getPath());
            file = new File((String)charSequence);
        }
        if (this.getChooserType().equals((Object)ChooserType.OpenFile) && file != null && file.getName().length() > 1 && ((StringBuffer)(charSequence = new StringBuffer(file.getName()))).charAt(0) == '\"' && ((StringBuffer)charSequence).charAt(((StringBuffer)charSequence).length() - 1) == '\"') {
            charSequence = ((StringBuffer)charSequence).deleteCharAt(0).deleteCharAt(((StringBuffer)charSequence).length() - 1);
            StringBuilder stringBuilder = new StringBuilder(file.getParent());
            file = stringBuilder.length() < 1 ? new File(((StringBuffer)charSequence).toString()) : new File(stringBuilder.toString() + File.separatorChar + ((StringBuffer)charSequence).toString());
        }
        if (!this.isServerFileSystem() && OSInfo.getOSType() == OSInfo.OSType.WIN && this.getChooserType() == ChooserType.SaveFile && file != null) {
            file = LocalFileSysUtil.getLocalFileSysUtil().getPhysicalLocationFromWin7LibraryPath(file);
        }
        return file;
    }

    @Override
    public void setFileSelectionMode(int n) {
        super.setFileSelectionMode(n);
    }

    public boolean canProceed(Component component) {
        Object object;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        String string = this.getSelectedFilePath();
        this.mActivateKeyboardMonitor = this.isActivateKeyboardMonitor(string);
        if (this.mActivateKeyboardMonitor) {
            return true;
        }
        if (this.getChooserType() == ChooserType.OpenFolder && string.indexOf(":\\", 4) > -1) {
            RepositoryFolder repositoryFolder;
            int n = string.indexOf(":\\", 4);
            String string2 = "/" + string.substring(n + 2);
            try {
                repositoryFolder = PES_Repository.getRepository().getFolder(string2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.displayFolderDoesNotExistAlert(string, component);
                return false;
            }
            return repositoryFolder != null;
        }
        Object object2 = PES_Repository.getPesFile((String)string);
        if (object2 != null) {
            string = object2.getUri();
            bl2 = object2.existsInPES();
            bl3 = bl2 ? !object2.canWriteToPesFile() : !object2.canWriteToPesFileFolder();
        } else if (this.isServerFileSystem()) {
            String string3;
            object = this.getSelectedFilePath();
            if (object == null) {
                return false;
            }
            if (!((String)object).startsWith("\\\\") && (string3 = this.getSelectedFileName()).length() > 0) {
                object = string3;
            }
            boolean bl7 = bl = !(string3 = this.validateServerFile((String)object)).errorOccurred();
            if (bl) {
                bl2 = string3.getFileStatus() != RemoteFileStatus.FileNodeStatus.RFS_DOES_NOT_EXIST;
                bl3 = string3.getFileStatus() == RemoteFileStatus.FileNodeStatus.RFS_READ_ONLY;
                bl4 = string3.getFilePathIsDirectory();
            }
        } else {
            bl2 = this.getSelectedFile().exists();
            object = this.getSelectedFile().getParentFile();
            boolean bl8 = bl3 = object != null && !((File)object).canWrite();
            if (OSInfo.getOSType() == OSInfo.OSType.WIN && (this.getChooserType() == ChooserType.SaveFile || this.getChooserType() == ChooserType.OpenCreateFile)) {
                try {
                    byte by = this.canWriteFile(this.getCurrentDirectory().getCanonicalPath());
                    if (by == 0) {
                        bl3 = false;
                    } else {
                        bl3 = true;
                        if (this.getCurrentDirectory().getCanonicalPath().startsWith("\\\\") && by == 1) {
                            this.displaySecurityPrivilegesAlert(component);
                            return false;
                        }
                    }
                }
                catch (Exception exception) {
                    if (LocalFileSysUtil.getLocalFileSysUtil().isPathAWindows7LibraryPath(this.getCurrentDirectory())) {
                        if (LocalFileSysUtil.getLocalFileSysUtil().isPathWindows7RootLibraryPath(this.getCurrentDirectory())) {
                            bl3 = true;
                            bl5 = true;
                        } else if (LocalFileSysUtil.getLocalFileSysUtil().isWindows7LibraryEmpty(this.getCurrentDirectory())) {
                            bl3 = true;
                            bl6 = true;
                        } else {
                            bl3 = false;
                        }
                    }
                    bl3 = true;
                }
            }
        }
        if (bl4 && this.getChooserType() != ChooserType.OpenFolder) {
            return false;
        }
        if (!bl && !ComponentState.getProcessorAvailable()) {
            this.displayProcessorLostCommunicationAlert(component);
        }
        if (this.mChooserType == ChooserType.SaveFile) {
            if (bl3) {
                if (bl5) {
                    this.displayWin7LibraryRootAlert(component);
                } else if (bl6) {
                    this.displayWin7LibraryEmptyAlert(component);
                } else {
                    this.displayDirectoryReadOnlyAlert(component, true);
                }
                bl = false;
            } else if (bl2) {
                if (component != null && this.isEncryptFileWithPassword()) {
                    bl = this.doEncryptPasswordDlg(component);
                }
                if (((String)(object2 = this.getRefWindowsFileChooserUI().getSelectedFileTypeDescription())).equals(CoreResUtil.getString((String)"IDS_SAVE_SAV_CP_FILE_FILTER"))) {
                    this.mOverwriteAlert = false;
                }
                if (bl && this.mOverwriteAlert && !(bl = this.displayConfirmFileExistsAlert(this.getSelectedFilePath(), component))) {
                    this.setFocusOnFileNameTextField();
                    this.getRefWindowsFileChooserUI().setErrorOccurred(true);
                }
            } else {
                if (this.isEncryptFileWithPassword()) {
                    bl = this.doEncryptPasswordDlg(component);
                }
                if (bl && !this.checkEncoding(string, component)) {
                    return false;
                }
            }
        } else if (this.mChooserType == ChooserType.OpenFile || this.mChooserType == ChooserType.OpenCreateFile || this.mChooserType == ChooserType.OpenFolder) {
            if (this.mChooserType == ChooserType.OpenCreateFile) {
                if (bl3) {
                    this.displayDirectoryReadOnlyAlert(component, false);
                    bl = false;
                } else {
                    try {
                        if (this.getSelectedFile().createNewFile()) {
                            bl2 = true;
                            bl = true;
                        } else {
                            bl = false;
                        }
                    }
                    catch (IOException iOException) {
                        this.displayCannotCreateFileAlert(string, component);
                        bl = false;
                    }
                }
            }
            if (this.mChooserType == ChooserType.OpenFile && this.mChooserOption == ChooserOption.Syntax) {
                object2 = new SyntaxEncodingMarkerUtils();
                switch (this.getRefWindowsFileChooserUI().getEncodingComboBoxSelectedItem()) {
                    case 0: {
                        object = "UTF-8";
                        break;
                    }
                    case 1: {
                        object = "Locale";
                        break;
                    }
                    case 2: {
                        object = "As Declared";
                        break;
                    }
                    default: {
                        object = null;
                    }
                }
                BitSet bitSet = object2.getDocumentEncodingMarkerValidation(this.getSelectedFile(), (String)object);
                if (bitSet.get(0) && bitSet.get(1) && bitSet.get(2) && bitSet.get(3) && !bitSet.get(4)) {
                    bl = this.displayConfirmBadEncodingAlert(component);
                }
            }
            if (bl && !bl2) {
                if (this.mChooserType == ChooserType.OpenFolder) {
                    this.displayFolderDoesNotExistAlert(string, component);
                } else {
                    this.displayFileDoesNotExistAlert(string, component);
                }
                bl = false;
            } else if (!this.checkEncoding(string, component)) {
                return false;
            }
        }
        return bl;
    }

    public boolean isActivateKeyboardMonitor(String string) {
        return string.endsWith("KEYBOARDMONITOR");
    }

    public String trimActivateKeyboardMonitorKeyword(String string) {
        int n;
        String string2 = string;
        if (string.endsWith("KEYBOARDMONITOR") && (n = string.indexOf("KEYBOARDMONITOR")) > 0) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    private SpssFrame getSpssFrame(Component component) {
        Frame frame = JOptionPane.getFrameForComponent(component);
        return frame instanceof SpssFrame ? (SpssFrame)frame : null;
    }

    private boolean doEncryptPasswordDlg(Component component) {
        boolean bl = true;
        SpssFrame spssFrame = this.getSpssFrame(component);
        EncryptionPasswordDlg encryptionPasswordDlg = new EncryptionPasswordDlg(spssFrame);
        encryptionPasswordDlg.setEncryptFilePassword(this.getEncryptFilePassword());
        if (this.mChooserOption == ChooserOption.Syntax) {
            encryptionPasswordDlg.useSyntaxCaution(true);
        } else {
            encryptionPasswordDlg.useSyntaxCaution(false);
        }
        encryptionPasswordDlg.setVisible(true);
        if (!encryptionPasswordDlg.isOkSelected()) {
            bl = false;
        } else {
            String string = encryptionPasswordDlg.getEncryptFilePassword();
            if (string != null) {
                this.setEncryptFilePassword(string);
            }
        }
        return bl;
    }

    private void displaySecurityPrivilegesAlert(Component component) {
        if (component instanceof Window) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)component, this.getSelectedFile().getName() + "\n" + CoreResUtil.getString((String)"ERR_SECURITY_PRIVILEGES_OVER_NETWORK"), VersionInfo.getAppVersionString());
        } else if (component instanceof JComponent) {
            SpssAlertOptionPane.showWarningMessageDialog((JComponent)component, this.getSelectedFile().getName() + "\n" + CoreResUtil.getString((String)"ERR_SECURITY_PRIVILEGES_OVER_NETWORK"), VersionInfo.getAppVersionString());
        } else {
            JOptionPane.showMessageDialog(this, this.getSelectedFile().getName() + "\n" + CoreResUtil.getString((String)"ERR_SECURITY_PRIVILEGES_OVER_NETWORK"), VersionInfo.getAppVersionString(), 2);
        }
    }

    private void displayProcessorLostCommunicationAlert(Component component) {
        String string = CoreResUtil.getString((String)"ERR_processorLostCommunication");
        if (component instanceof Window) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)component, string, VersionInfo.getAppVersionString());
        } else if (component instanceof JComponent) {
            SpssAlertOptionPane.showWarningMessageDialog((JComponent)component, string, VersionInfo.getAppVersionString());
        } else {
            JOptionPane.showMessageDialog(this, string, VersionInfo.getAppVersionString(), -1);
        }
    }

    private boolean displayConfirmFileExistsAlert(String string, Component component) {
        int n;
        int n2;
        PesFile pesFile = PES_Repository.getPesFile((String)string);
        String string2 = string + "\n";
        string2 = pesFile != null ? string2 + CoreResUtil.getString((String)"ERR_FILE_PES_EXIST_WARNING_MESSAGE") : string2 + CoreResUtil.getString((String)"ERR_FILE_EXIST_WARNING_MESSAGE");
        boolean bl = component instanceof Window ? (n2 = SpssAlertOptionPane.showConfirmDialog((Window)component, string2, VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.YES_NO_OPTION)) == 1 : (component instanceof JComponent ? (n = SpssAlertOptionPane.showConfirmDialog((JComponent)component, string2, VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.YES_NO_OPTION)) == 1 : JOptionPane.showConfirmDialog(this, string2, VersionInfo.getAppVersionString(), 0, 2, new ImageIcon(ResUtil.getImageResource("warning_core.png"))) == 0);
        return bl;
    }

    private void displayCannotCreateFileAlert(String string, Component component) {
        String string2 = string + "\n" + CoreResUtil.getString((String)"ERR_FILE_CANNOT_CREATE_WARNING_MESSAGE");
        if (component instanceof Window) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)component, string2, VersionInfo.getAppVersionString());
        } else if (component instanceof JComponent) {
            SpssAlertOptionPane.showWarningMessageDialog((JComponent)component, string2, VersionInfo.getAppVersionString());
        } else {
            JOptionPane.showMessageDialog(this, string2, VersionInfo.getAppVersionString(), 0);
        }
    }

    public static boolean displayConfirmFileInUseAlert(String string, Component component) {
        JFrame jFrame;
        int n;
        int n2;
        int n3;
        String string2 = CoreResUtil.getString((String)"IDS_FILE_IN_USE_STRING");
        String string3 = string.substring(string.lastIndexOf(File.separatorChar) + 1);
        String string4 = MessageFormat.format(CoreResUtil.getString((String)"ERR_FILE_IN_USE_WARNING_MESSAGE"), string3);
        boolean bl = component instanceof Window ? (n3 = SpssAlertOptionPane.showConfirmDialog((Window)component, string4, string2, SpssAlertOptionPane.IconType.eQuestion, SpssAlertOptionPane.OptionType.YES_NO_OPTION)) == 1 : (component instanceof JComponent ? (n2 = SpssAlertOptionPane.showConfirmDialog((JComponent)component, string4, string2, SpssAlertOptionPane.IconType.eQuestion, SpssAlertOptionPane.OptionType.YES_NO_OPTION)) == 1 : (n = SpssAlertOptionPane.showConfirmDialog(jFrame = new JFrame(), string4, string2, SpssAlertOptionPane.IconType.eQuestion, SpssAlertOptionPane.OptionType.YES_NO_OPTION)) == 1);
        return bl;
    }

    private void displayFileDoesNotExistAlert(String string, Component component) {
        String string2 = string + "\n" + CoreResUtil.getString((String)"ERR_FILE_DOESNT_EXIST_WARNING_MESSAGE");
        if (component instanceof Window) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)component, string2, VersionInfo.getAppVersionString());
        } else if (component instanceof JComponent) {
            SpssAlertOptionPane.showWarningMessageDialog((JComponent)component, string2, VersionInfo.getAppVersionString());
        } else {
            JOptionPane.showMessageDialog(this, string2, VersionInfo.getAppVersionString(), -1, new ImageIcon(ResUtil.getImageResource("warning_core.png")));
        }
    }

    private void displayFolderDoesNotExistAlert(String string, Component component) {
        String string2 = string + "\n" + CoreResUtil.getString((String)"ERR_FOLDER_DOESNT_EXIST_WARNING_MESSAGE");
        if (component instanceof Window) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)component, string2, VersionInfo.getAppVersionString());
        } else if (component instanceof JComponent) {
            SpssAlertOptionPane.showWarningMessageDialog((JComponent)component, string2, VersionInfo.getAppVersionString());
        } else {
            JOptionPane.showMessageDialog(this, string2, VersionInfo.getAppVersionString(), -1, new ImageIcon(ResUtil.getImageResource("warning_core.png")));
        }
    }

    private void displayDirectoryReadOnlyAlert(Component component, boolean bl) {
        String string = this.getSelectedFile().getPath();
        if (this.getSelectedFile().getParent() != null) {
            string = this.getSelectedFile().getParent();
        }
        String string2 = bl ? String.format(CoreResUtil.getString((String)"ERR_FILE_READ_ONLY_FILE_MESSAGE"), string) : string + "\n" + CoreResUtil.getString((String)"ERR_DIR_READ_ONLY_ERROR_MESSAGE");
        if (component instanceof Window) {
            SpssAlertOptionPane.showErrorMessageDialog((Window)component, string2, VersionInfo.getAppVersionString());
        } else if (component instanceof JComponent) {
            SpssAlertOptionPane.showErrorMessageDialog((JComponent)component, string2, VersionInfo.getAppVersionString());
        } else {
            JOptionPane.showMessageDialog(this, string2, VersionInfo.getAppVersionString(), 0);
        }
    }

    private void displayWin7LibraryRootAlert(Component component) {
        LocalFileSysUtil.getLocalFileSysUtil();
        String string = CoreResUtil.getString((String)"ERR_WIN7_LIBRARY_ROOT_ERROR_MESSAGE");
        if (component instanceof Window) {
            SpssAlertOptionPane.showErrorMessageDialog((Window)component, string, VersionInfo.getAppVersionString());
        } else if (component instanceof JComponent) {
            SpssAlertOptionPane.showErrorMessageDialog((JComponent)component, string, VersionInfo.getAppVersionString());
        } else {
            JOptionPane.showMessageDialog(this, string, VersionInfo.getAppVersionString(), 0);
        }
    }

    private void displayWin7LibraryEmptyAlert(Component component) {
        String string = CoreResUtil.getString((String)"ERR_WIN7_LIBRARY_EMPTY_ERROR_MESSAGE");
        if (component instanceof Window) {
            SpssAlertOptionPane.showErrorMessageDialog((Window)component, string, VersionInfo.getAppVersionString());
        } else if (component instanceof JComponent) {
            SpssAlertOptionPane.showErrorMessageDialog((JComponent)component, string, VersionInfo.getAppVersionString());
        } else {
            JOptionPane.showMessageDialog(this, string, VersionInfo.getAppVersionString(), 0);
        }
    }

    private boolean displayConfirmBadEncodingAlert(Component component) {
        JFrame jFrame;
        int n;
        int n2;
        int n3;
        String string = CoreResUtil.getString((String)"IDS_FILE_CHOOSER_OPEN_SYNTAX_TITLE");
        String string2 = CoreResUtil.getString((String)"IDS_SYNTAX_ENCODING_ERROR");
        boolean bl = component instanceof Window ? (n3 = SpssAlertOptionPane.showConfirmDialog((Window)component, string2, string, SpssAlertOptionPane.IconType.eQuestion, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) == 0 : (component instanceof JComponent ? (n2 = SpssAlertOptionPane.showConfirmDialog((JComponent)component, string2, string, SpssAlertOptionPane.IconType.eQuestion, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) == 0 : (n = SpssAlertOptionPane.showConfirmDialog(jFrame = new JFrame(), string2, string, SpssAlertOptionPane.IconType.eQuestion, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) == 0);
        return bl;
    }

    private boolean checkEncoding(String string, Component component) {
        EncodingValidator encodingValidator = new EncodingValidator(ComponentState.getCurrentCharset());
        boolean bl = encodingValidator.validateString(string);
        if (!bl) {
            boolean bl2 = encodingValidator.getResult().equals(CoderResult.OVERFLOW);
            String string2 = bl2 ? "ERR_STRING_OVERFLOW_MSG" : "ERR_STRING_UNMAPPABLE_MSG";
            String string3 = UIToolResUtil.getString((String)string2);
            if (component instanceof Window) {
                SpssAlertOptionPane.showErrorMessageDialog((Window)component, string3, VersionInfo.getAppVersionString());
            } else {
                SpssAlertOptionPane.showErrorMessageDialog((JComponent)component, string3, VersionInfo.getAppVersionString());
            }
            JTextField jTextField = null;
            if (this.getUI() instanceof RefWindowsFileChooserUI) {
                jTextField = this.getRefWindowsFileChooserUI().getFileNameTextField();
            }
            if (jTextField != null) {
                jTextField.selectAll();
                jTextField.requestFocus();
            }
            return false;
        }
        return true;
    }

    private void setTitle() {
        if (this.mChooserType == ChooserType.OpenFile) {
            if (this.mChooserOption == ChooserOption.Data) {
                if (this.mUseServerFileSystem) {
                    this.setDialogTitle(CoreResUtil.getString((String)"IDS_FILE_CHOOSER_OPEN_DATA_REMOTE_TITLE"));
                } else {
                    this.setDialogTitle(CoreResUtil.getString((String)"IDS_FILE_CHOOSER_OPEN_DATA_LOCAL_TITLE"));
                }
            } else if (this.mChooserOption == ChooserOption.Syntax) {
                this.setDialogTitle(CoreResUtil.getString((String)"IDS_FILE_CHOOSER_OPEN_SYNTAX_TITLE"));
            } else if (this.mChooserOption == ChooserOption.Output) {
                this.setDialogTitle(CoreResUtil.getString((String)"IDS_FILE_CHOOSER_OPEN_OUTPUT_TITLE"));
            } else if (this.mChooserOption == ChooserOption.Script) {
                this.setDialogTitle(CoreResUtil.getString((String)"IDS_FILE_CHOOSER_OPEN_SCRIPT_TITLE"));
            }
        } else if (this.mChooserType == ChooserType.SaveFile) {
            if (this.mChooserOption == ChooserOption.Data) {
                if (this.mUseServerFileSystem) {
                    this.setDialogTitle(CoreResUtil.getString((String)"IDS_FILE_CHOOSER_SAVE_DATA_REMOTE_TITLE"));
                } else {
                    this.setDialogTitle(CoreResUtil.getString((String)"IDS_FILE_CHOOSER_SAVE_DATA_LOCAL_TITLE"));
                }
            } else if (this.mChooserOption == ChooserOption.Syntax) {
                this.setDialogTitle(CoreResUtil.getString((String)"IDS_FILE_CHOOSER_SAVE_SYNTAX_TITLE"));
            } else if (this.mChooserOption == ChooserOption.Output) {
                this.setDialogTitle(CoreResUtil.getString((String)"IDS_FILE_CHOOSER_SAVE_OUTPUT_TITLE"));
            } else if (this.mChooserOption == ChooserOption.Script) {
                this.setDialogTitle(CoreResUtil.getString((String)"IDS_FILE_CHOOSER_SAVE_SCRIPT_TITLE"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte canWriteFile(String string) {
        int n = 0;
        if (this.mUseServerFileSystem) {
            RemoteFileStatus.FileNodeStatus fileNodeStatus;
            RemoteFileStatus remoteFileStatus = this.getServerFileStatus(string);
            n = remoteFileStatus == null ? 2 : ((fileNodeStatus = remoteFileStatus.getFilePathIsDirectory() ? remoteFileStatus.getFileStatus() : remoteFileStatus.getParentDirStatus()) == RemoteFileStatus.FileNodeStatus.RFS_DOES_NOT_EXIST ? 2 : (fileNodeStatus == RemoteFileStatus.FileNodeStatus.RFS_WRITEABLE ? 0 : 1));
        } else {
            File file = null;
            try {
                FileOutputStream fileOutputStream;
                if (OSInfo.getOSType() == OSInfo.OSType.WIN) {
                    file = new File(string + "\\spss_dummy");
                    fileOutputStream = new FileOutputStream(file);
                    Files.setAttribute(file.toPath(), "dos:hidden", Boolean.TRUE, LinkOption.NOFOLLOW_LINKS);
                } else {
                    file = new File(string + "\\.spss_dummy");
                    fileOutputStream = new FileOutputStream(file);
                }
                fileOutputStream.flush();
                fileOutputStream.close();
                if (!file.delete()) {
                    file.deleteOnExit();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                n = 1;
            }
            catch (IOException iOException) {
                n = 2;
            }
            finally {
                if (file != null && file.exists() && !file.delete()) {
                    file.deleteOnExit();
                }
            }
        }
        return (byte)n;
    }

    private RefWindowsFileChooserUI getRefWindowsFileChooserUI() {
        return (RefWindowsFileChooserUI)((Object)this.getUI());
    }

    public void setOverwriteAlert(boolean bl) {
        this.mOverwriteAlert = bl;
    }

    public static String getDirectoryName(File file, boolean bl) {
        String string = file.getAbsolutePath();
        if (bl) {
            try {
                string = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return RemoteFileChooser.getDirectoryName(string);
    }

    public static String getDirectoryName(String string) {
        int n = Math.max(string.lastIndexOf(File.separatorChar), string.lastIndexOf(47));
        if (n > 0) {
            return string.substring(0, n);
        }
        return string;
    }

    private void scan(Container container) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (component instanceof JTextField) {
                JTextField jTextField = (JTextField)component;
                this.mFilenamePrompter = new FilenameTextFieldPrompter(jTextField, true);
                this.mFilenamePrompter.setAssociatedFileChooser(this);
                this.mFilenamePrompter.setCurrentDirectory(this.getCurrentDirectory());
            }
            if (!(component instanceof Container)) continue;
            this.scan((Container)component);
        }
    }

    public JButton getApproveButton() {
        Component[] componentArray;
        FileChooserUI fileChooserUI = this.getUI();
        if (fileChooserUI instanceof RefWindowsFileChooserUI) {
            return ((RefWindowsFileChooserUI)((Object)fileChooserUI)).getApproveButton(this);
        }
        String string = this.getUI().getApproveButtonText(this);
        for (Component component : componentArray = this.getComponents()) {
            JButton jButton = this.searchByText(component, string);
            if (jButton == null) continue;
            return jButton;
        }
        return null;
    }

    private JButton searchByText(Component component, String string) {
        if (component instanceof JButton) {
            JButton jButton = (JButton)component;
            String string2 = jButton.getText();
            if (string.equals(string2)) {
                return jButton;
            }
            return null;
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                JButton jButton = this.searchByText(container.getComponent(i), string);
                if (jButton == null) continue;
                return jButton;
            }
        }
        return null;
    }

    private ImageIcon resizeImage(ImageIcon imageIcon, int n, int n2) {
        Image image = imageIcon.getImage();
        Image image2 = image.getScaledInstance(n, n2, 4);
        return new ImageIcon(image2);
    }

    @Deprecated
    public static RemoteFileChooser showClientSelectFolderDialog(Component component, String string, String string2, boolean bl) {
        RemoteFileChooser remoteFileChooser = bl ? new RemoteFileChooser(ChooserType.OpenFolder, ChooserOption.Generic, string2, false) : new SaveFolderChooser(ChooserType.OpenFolder, ChooserOption.Generic, string2, false);
        return RemoteFileChooser.chooseDirectoryFolder(component, string, remoteFileChooser);
    }

    @Deprecated
    public static RemoteFileChooser showServerSelectFolderDialog(Component component, String string, String string2, boolean bl) {
        RemoteFileChooser remoteFileChooser = bl ? new RemoteFileChooser(ChooserType.OpenFolder, ChooserOption.Generic, string2, true) : new SaveFolderChooser(ChooserType.OpenFolder, ChooserOption.Generic, string2, true);
        return RemoteFileChooser.chooseDirectoryFolder(component, string, remoteFileChooser);
    }

    public void onDispose() {
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            this.convertMnemonicKeyValues(false);
        }
    }

    private static RemoteFileChooser chooseDirectoryFolder(Component component, String string, RemoteFileChooser remoteFileChooser) {
        int n = -1;
        remoteFileChooser.setDialogTitle(string);
        ResourceBundle resourceBundle = CoreResUtil.getBundle(null, null);
        if (resourceBundle != null) {
            try {
                if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                    remoteFileChooser.setApproveButtonMnemonic(CoreResUtil.getDlgAccessKey((ResourceBundle)resourceBundle, (String)"IDK_FILE_FOLDER"));
                }
                n = remoteFileChooser.showDialog(component, CoreResUtil.getString((String)"IDS_FILE_FOLDER_TEXT"));
                if (remoteFileChooser instanceof SaveFolderChooser) {
                    ((SaveFolderChooser)remoteFileChooser).resetStrings();
                }
            }
            catch (MissingResourceException missingResourceException) {
                missingResourceException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return n == 0 ? remoteFileChooser : null;
    }

    public boolean isActivateKeyboardMonitor() {
        return this.mActivateKeyboardMonitor;
    }

    private class ResizeConstrainer
    extends ComponentAdapter {
        private Component mComponent = null;
        private Dimension mSizeConstraints = null;

        public ResizeConstrainer(Component component, Dimension dimension) {
            this.mComponent = component;
            this.mSizeConstraints = (Dimension)dimension.clone();
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            if (this.mSizeConstraints != null) {
                boolean bl = false;
                Dimension dimension = this.mComponent.getSize();
                if (dimension.width < this.mSizeConstraints.width) {
                    dimension.width = this.mSizeConstraints.width;
                    bl = true;
                }
                if (dimension.height < this.mSizeConstraints.height) {
                    dimension.height = this.mSizeConstraints.height;
                    bl = true;
                }
                if (bl) {
                    this.mComponent.setSize(dimension);
                }
            }
        }

        public Dimension getSizeConstraints() {
            return (Dimension)this.mSizeConstraints.clone();
        }

        public void setSizeConstraints(Dimension dimension) {
            this.mSizeConstraints = (Dimension)dimension.clone();
        }
    }

    private class MyAWTKeyEventListener
    implements AWTEventListener {
        private MyAWTKeyEventListener() {
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            Object object = aWTEvent.getSource();
            if (object instanceof Component && aWTEvent instanceof KeyEvent && ((KeyEvent)aWTEvent).getKeyCode() == 27) {
                RemoteFileChooser.this.mDialog.dispose();
                Toolkit.getDefaultToolkit().removeAWTEventListener(RemoteFileChooser.this.mMyAWTKeyEventListener);
            }
        }
    }

    private class RemoteFileDialog
    extends JDialog {
        private ResizeConstrainer mResizeConstrainer;

        public RemoteFileDialog(JDialog jDialog, String string) {
            super(jDialog, string, true);
            this.mResizeConstrainer = null;
        }

        public RemoteFileDialog(Frame frame, String string) {
            super(frame, string, true);
            this.mResizeConstrainer = null;
        }

        @Override
        public void pack() {
            this.removeComponentListener(this.mResizeConstrainer);
            super.pack();
            Dimension dimension = this.getSizeConstraints();
            Dimension dimension2 = this.getSize();
            dimension2.width = dimension2.width > dimension.width ? dimension2.width : dimension.width;
            dimension2.height = dimension2.height > dimension.height ? dimension2.height : dimension.height;
            this.setSizeConstraints(dimension2);
            this.addComponentListener(this.mResizeConstrainer);
        }

        public Dimension getSizeConstraints() {
            if (this.mResizeConstrainer == null) {
                this.mResizeConstrainer = new ResizeConstrainer(this, new Dimension(0, 0));
            }
            return this.mResizeConstrainer.getSizeConstraints();
        }

        public void setSizeConstraints(Dimension dimension) {
            if (this.mResizeConstrainer == null) {
                this.mResizeConstrainer = new ResizeConstrainer(this, dimension);
            } else {
                this.mResizeConstrainer.setSizeConstraints(dimension);
            }
        }
    }

    private static class WeakPCL
    implements PropertyChangeListener {
        WeakReference<RemoteFileChooser> jfcRef;

        public WeakPCL(RemoteFileChooser remoteFileChooser) {
            this.jfcRef = new WeakReference<RemoteFileChooser>(remoteFileChooser);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            assert (propertyChangeEvent.getPropertyName().equals(RemoteFileChooser.SHOW_HIDDEN_PROP));
            RemoteFileChooser remoteFileChooser = (RemoteFileChooser)this.jfcRef.get();
            if (remoteFileChooser == null) {
                Toolkit.getDefaultToolkit().removePropertyChangeListener(RemoteFileChooser.SHOW_HIDDEN_PROP, this);
            } else {
                boolean bl = remoteFileChooser.isFileHidingEnabled();
                remoteFileChooser.mUseFileHiding = (Boolean)propertyChangeEvent.getNewValue() == false;
                remoteFileChooser.firePropertyChange("FileHidingChanged", bl, remoteFileChooser.mUseFileHiding);
            }
        }
    }

    private static class SaveFolderChooser
    extends RemoteFileChooser {
        public SaveFolderChooser(ChooserType chooserType, ChooserOption chooserOption, String string, boolean bl) {
            super(chooserType, chooserOption, string, bl);
        }

        @Override
        protected void installStrings() {
            super.installStrings();
            UIManager.getDefaults().put("FileChooser.lookInLabelText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_SAVE_IN_LABEL_TEXT"));
            UIManager.getDefaults().put("FileChooser.filesOfTypeLabelText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_SAVE_FILES_OF_TYPE_LABEL_TEXT"));
            UIManager.getDefaults().put("FileChooser.fileNameLabelText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_OPEN_FOLDER_LABEL_TEXT"));
        }

        public void resetStrings() {
            UIManager.getDefaults().put("FileChooser.lookInLabelText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_LOOK_IN_LABEL_TEXT"));
            UIManager.getDefaults().put("FileChooser.filesOfTypeLabelText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_FILES_OF_TYPE_LABEL_TEXT"));
            UIManager.getDefaults().put("FileChooser.fileNameLabelText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_FOLDER_LABEL_TEXT"));
        }
    }

    public static enum ChooserOption {
        Generic,
        Data,
        DataWithEncryption,
        Syntax,
        Output,
        Script,
        ExportDimensions,
        GenericWithPaste,
        GenericWithoutPES;

    }

    public static enum ChooserType {
        OpenFile,
        SaveFile,
        OpenFolder,
        OpenCreateFile;

    }
}

