/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.fopen;

import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.dialogs.fopen.RefWindowsFileChooserUI;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.AbstractTextFieldPrompter;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.text.BadLocationException;

public class FilenameTextFieldPrompter
extends AbstractTextFieldPrompter {
    private File mCurrentDirectory;
    private RemoteFileChooser mAssociatedFileChooser;
    private boolean mRemoteFileSystemView = false;
    private boolean isCopyEvt = false;
    private int caretPosBkp = -1;
    private int selectionStartBkp = -1;
    private int selectionEndBkp = -1;
    protected static boolean mProcessingUNCPaste;
    protected boolean mKnownCaretUpdate = false;
    private Action filenameTextFieldEnterAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Action action = null;
            if (FilenameTextFieldPrompter.this.mAssociatedFileChooser.getUI() instanceof RefWindowsFileChooserUI) {
                action = ((RefWindowsFileChooserUI)((Object)FilenameTextFieldPrompter.this.mAssociatedFileChooser.getUI())).getApproveSelectionAction();
            } else if (FilenameTextFieldPrompter.this.mAssociatedFileChooser.getUI() instanceof BasicFileChooserUI) {
                action = ((BasicFileChooserUI)FilenameTextFieldPrompter.this.mAssociatedFileChooser.getUI()).getApproveSelectionAction();
            }
            if (action != null) {
                action.actionPerformed(actionEvent);
            }
        }
    };
    private Action filenameTextFieldEscapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (FilenameTextFieldPrompter.this.isPrompterVisible()) {
                FilenameTextFieldPrompter.this.dismissPrompter();
            } else if (FilenameTextFieldPrompter.this.mAssociatedFileChooser.getUI() instanceof BasicFileChooserUI) {
                ((BasicFileChooserUI)FilenameTextFieldPrompter.this.mAssociatedFileChooser.getUI()).getCancelSelectionAction().actionPerformed(actionEvent);
            }
        }
    };
    private static Action processPrompterTextFieldPasteEvent;
    private CaretListener processCaretListenerEvent = new CaretListener(){

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            int n;
            int n2 = caretEvent.getDot();
            if (n2 != (n = caretEvent.getMark())) {
                if (FilenameTextFieldPrompter.this.mKnownRequestFocus && !FilenameTextFieldPrompter.this.mKnownCaretUpdate) {
                    FilenameTextFieldPrompter.this.mKnownCaretUpdate = true;
                    FilenameTextFieldPrompter.this.mPrompterTextField.setSelectionStart(0);
                    FilenameTextFieldPrompter.this.mPrompterTextField.setSelectionEnd(0);
                    FilenameTextFieldPrompter.this.mPrompterTextField.setCaretPosition(FilenameTextFieldPrompter.this.mPrompterTextField.getDocument().getLength());
                } else if (FilenameTextFieldPrompter.this.mKnownRequestFocus && FilenameTextFieldPrompter.this.mKnownCaretUpdate) {
                    FilenameTextFieldPrompter.this.mKnownCaretUpdate = false;
                    FilenameTextFieldPrompter.this.mKnownRequestFocus = false;
                }
            }
        }
    };
    private KeyListener processKeyEvent = new KeyListener(){

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (FilenameTextFieldPrompter.this.mPrompterTextField == null) {
                return;
            }
            String string = FilenameTextFieldPrompter.this.mPrompterTextField.getText();
            String string2 = null;
            if ((keyEvent.getModifiersEx() & 0x80) == 128 && keyEvent.getKeyCode() == 67 && FileTextField.isPathBidiProcessingNeeded(string)) {
                FilenameTextFieldPrompter.this.isCopyEvt = true;
                if (FilenameTextFieldPrompter.this.mPrompterTextField.getSelectedText() != null && FilenameTextFieldPrompter.this.mPrompterTextField.getSelectedText().length() > 0) {
                    int n;
                    int n2 = FilenameTextFieldPrompter.this.mPrompterTextField.getSelectionStart();
                    int n3 = FilenameTextFieldPrompter.this.mPrompterTextField.getSelectionEnd();
                    FilenameTextFieldPrompter.this.selectionStartBkp = n2;
                    FilenameTextFieldPrompter.this.selectionEndBkp = n3;
                    FilenameTextFieldPrompter.this.caretPosBkp = FilenameTextFieldPrompter.this.mPrompterTextField.getCaretPosition();
                    int n4 = 0;
                    int n5 = 0;
                    for (n = 0; n < n2; ++n) {
                        if (string.charAt(n) != '\u200e') continue;
                        ++n4;
                    }
                    n5 = n4;
                    while (n < n3) {
                        if (string.charAt(n) == '\u200e') {
                            ++n5;
                        }
                        ++n;
                    }
                    string2 = FileTextField.removeLRM(string);
                    FilenameTextFieldPrompter.this.mPrompterTextField.setText(string2);
                    FilenameTextFieldPrompter.this.mPrompterTextField.setCaretPosition(n3 - n5);
                    FilenameTextFieldPrompter.this.mPrompterTextField.setSelectionStart(n2 - n4);
                    FilenameTextFieldPrompter.this.mPrompterTextField.setSelectionStart(n3 - n5);
                    FilenameTextFieldPrompter.this.mPrompterTextField.select(n2 - n4, n3 - n5);
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            String string = FilenameTextFieldPrompter.this.mPrompterTextField.getText();
            int n = FilenameTextFieldPrompter.this.mPrompterTextField.getCaretPosition();
            if (string != null) {
                String string2 = null;
                if (keyEvent.getKeyCode() != 17 && keyEvent.getKeyCode() != 37 && keyEvent.getKeyCode() != 39) {
                    if (Character.toString(keyEvent.getKeyChar()).equals(System.getProperty("file.separator")) && string.length() > 2 && Character.toString(string.charAt(n - 1)).equals(System.getProperty("file.separator")) && (n == 1 || n > 1 && string.charAt(n - 2) != '\u200e')) {
                        string2 = n == 1 ? '\u200e' + string.substring(0) : string.substring(0, n - 1) + '\u200e' + string.substring(n - 1);
                        FilenameTextFieldPrompter.this.mPrompterTextField.setText(string2);
                        FilenameTextFieldPrompter.this.mPrompterTextField.setCaretPosition(n + 1);
                    }
                } else if (keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 8) {
                    if (n > 0 && Character.toString(string.charAt(n - 1)).equals(Character.valueOf('\u200e'))) {
                        string2 = n + 1 < string.length() ? string.substring(0, n) + string.substring(n + 1) : string.substring(0, n);
                        FilenameTextFieldPrompter.this.mPrompterTextField.setText(string2);
                        FilenameTextFieldPrompter.this.mPrompterTextField.setCaretPosition(n - 1);
                    }
                } else if (keyEvent.getKeyCode() == 17 && FilenameTextFieldPrompter.this.isCopyEvt) {
                    FilenameTextFieldPrompter.this.isCopyEvt = false;
                    string2 = FileTextField.insertLRM(string);
                    FilenameTextFieldPrompter.this.mPrompterTextField.setText(string2);
                    FilenameTextFieldPrompter.this.mPrompterTextField.setCaretPosition(FilenameTextFieldPrompter.this.caretPosBkp);
                    FilenameTextFieldPrompter.this.caretPosBkp = -1;
                    FilenameTextFieldPrompter.this.mPrompterTextField.setSelectionStart(FilenameTextFieldPrompter.this.selectionStartBkp);
                    FilenameTextFieldPrompter.this.mPrompterTextField.setSelectionEnd(FilenameTextFieldPrompter.this.selectionEndBkp);
                    FilenameTextFieldPrompter.this.mPrompterTextField.select(FilenameTextFieldPrompter.this.selectionStartBkp, FilenameTextFieldPrompter.this.selectionEndBkp);
                    FilenameTextFieldPrompter.this.selectionStartBkp = -1;
                    FilenameTextFieldPrompter.this.selectionEndBkp = -1;
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }
    };
    private PropertyChangeListener mDirectoryChangedListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("directoryChanged".equals(string)) {
                if (OSInfo.isMacOSXLeopardOrLater()) {
                    FilenameTextFieldPrompter.this.setCurrentDirectory(FilenameTextFieldPrompter.this.mAssociatedFileChooser.getSelectedFile());
                } else {
                    FilenameTextFieldPrompter.this.setCurrentDirectory(FilenameTextFieldPrompter.this.mAssociatedFileChooser.getCurrentDirectory());
                }
                if (FilenameTextFieldPrompter.this.getPrompterTextField().hasFocus()) {
                    FilenameTextFieldPrompter.this.setPrompterTextFieldTextHighlighted();
                } else if (FileTextField.isPathBidiProcessingNeeded(FilenameTextFieldPrompter.this.getPrompterTextField().getText())) {
                    FilenameTextFieldPrompter.this.getPrompterTextField().setText(FileTextField.insertLRM(FilenameTextFieldPrompter.this.getPrompterTextField().getText()));
                }
            }
        }
    };

    public FilenameTextFieldPrompter(JTextField jTextField) {
        super(jTextField);
        this.init();
    }

    public FilenameTextFieldPrompter(JTextField jTextField, boolean bl) {
        super(jTextField, bl);
        this.init();
    }

    void init() {
        this.registerEnterAction();
        this.registerEscapeAction();
        this.registerPasteAction();
        this.registerCaretListener();
        this.registerKeyListener();
    }

    public PropertyChangeListener getDirectoryChangedListener() {
        return this.mDirectoryChangedListener;
    }

    public void setAssociatedFileChooser(RemoteFileChooser remoteFileChooser) {
        this.mAssociatedFileChooser = remoteFileChooser;
    }

    public void setRemoteFileSystemView(boolean bl) {
        this.mRemoteFileSystemView = bl;
    }

    public void setCurrentDirectory(File file) {
        this.mCurrentDirectory = file;
    }

    protected boolean updateListOfPrompts() {
        String string = this.mPrompterTextField.getText();
        if (string.indexOf(8206) != -1 && string != null && string.length() > 0) {
            string = FileTextField.removeLRM(string);
        }
        File file = new File(string);
        if (string == null || string.length() == 0) {
            return false;
        }
        int n = string.lastIndexOf(File.separator);
        String string2 = file.isAbsolute() ? string.substring(0, n + 1) : (this.mCurrentDirectory == null ? "" : this.mCurrentDirectory.getPath()) + File.separator + string.substring(0, n + 1);
        final String string3 = n == string.length() - 1 ? null : string.substring(n + 1).toLowerCase();
        String[] stringArray = null;
        if (!this.mRemoteFileSystemView && !mProcessingUNCPaste) {
            stringArray = new File(string2).list(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return string3 == null || string.toLowerCase().startsWith(string3);
                }
            });
        } else {
            mProcessingUNCPaste = false;
        }
        if (stringArray == null) {
            this.mListOfPrompts.setListData(new String[0]);
            return false;
        }
        if (stringArray.length == 1 && stringArray[0].equalsIgnoreCase(string3)) {
            this.mListOfPrompts.setListData(new String[0]);
            return false;
        }
        this.mListOfPrompts.setListData(stringArray);
        return true;
    }

    protected void promptItemSelected(String string, int n) {
        if (string == null) {
            return;
        }
        String string2 = this.mPrompterTextField.getText();
        int n2 = string2.lastIndexOf(File.separator);
        int n3 = this.mPrompterTextField.getDocument().getLength() - n2 - 1;
        String string3 = (this.mCurrentDirectory == null ? "" : this.mCurrentDirectory.getPath()) + File.separator + string2 + string.substring(n3);
        try {
            this.mPrompterTextField.getDocument().insertString(this.mPrompterTextField.getCaretPosition(), string.substring(n3), null);
            this.setPrompterTextFieldTextHighlighted();
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        if (this.mAssociatedFileChooser != null && n == 1) {
            File file = new File(string3);
            File file2 = new File(string2 + string.substring(n3));
            if (file.isDirectory()) {
                this.mAssociatedFileChooser.setCurrentDirectory(file);
            } else if (file2.isDirectory()) {
                this.mAssociatedFileChooser.setCurrentDirectory(file2);
            }
        }
    }

    private void registerEnterAction() {
        this.mPrompterTextField.registerKeyboardAction(this.filenameTextFieldEnterAction, KeyStroke.getKeyStroke(10, 0), 0);
    }

    private void registerEscapeAction() {
        this.mPrompterTextField.registerKeyboardAction(this.filenameTextFieldEscapeAction, KeyStroke.getKeyStroke(27, 0), 0);
    }

    private void registerPasteAction() {
        this.mPrompterTextField.registerKeyboardAction(processPrompterTextFieldPasteEvent, KeyStroke.getKeyStroke(86, 2), 0);
        this.mPrompterTextField.registerKeyboardAction(processPrompterTextFieldPasteEvent, KeyStroke.getKeyStroke(65487, 0), 0);
    }

    private void registerCaretListener() {
        if (OSInfo.isMacOSXLeopardOrLater()) {
            this.mPrompterTextField.addCaretListener(this.processCaretListenerEvent);
        }
    }

    private void registerKeyListener() {
        this.mPrompterTextField.addKeyListener(this.processKeyEvent);
    }

    static {
        processPrompterTextFieldPasteEvent = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComponent jComponent = (JComponent)actionEvent.getSource();
                AbstractTextFieldPrompter abstractTextFieldPrompter = (AbstractTextFieldPrompter)jComponent.getClientProperty("TEXTFIELDPROMPTER");
                if (jComponent.isEnabled()) {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    try {
                        String string = (String)clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor);
                        if (string.startsWith("\\\\")) {
                            mProcessingUNCPaste = true;
                        }
                        if (!FileTextField.isPathBidiProcessingNeeded(string)) {
                            abstractTextFieldPrompter.getPrompterTextField().replaceSelection(string);
                        } else {
                            FileTextField.doReplaceSelection(abstractTextFieldPrompter.getPrompterTextField(), FileTextField.insertLRM(string));
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        };
    }

    public static class PatternFileFilter
    extends FileFilter {
        String mDescription;
        Pattern mPattern;

        public PatternFileFilter(String string) {
            this.mDescription = string;
            string = PatternFileFilter.replaceWildcards(string);
            this.mPattern = OSInfo.getOSType() == OSInfo.OSType.WIN ? Pattern.compile(string.toLowerCase()) : Pattern.compile(string);
        }

        private static String replaceWildcards(String string) {
            char[] cArray;
            StringBuffer stringBuffer = new StringBuffer();
            for (char c : cArray = string.toCharArray()) {
                if (c == '*') {
                    stringBuffer.append(".*");
                    continue;
                }
                if (c == '?') {
                    stringBuffer.append(".");
                    continue;
                }
                if ("+()^$.{}[]".indexOf(c) != -1) {
                    stringBuffer.append('\\').append(c);
                    continue;
                }
                stringBuffer.append(c);
            }
            return stringBuffer.toString();
        }

        @Override
        public boolean accept(File file) {
            boolean bl = file.isDirectory();
            boolean bl2 = false;
            bl2 = OSInfo.getOSType() == OSInfo.OSType.WIN ? this.mPattern.matcher(file.getName().toLowerCase()).matches() : this.mPattern.matcher(file.getName()).matches();
            return bl || bl2;
        }

        @Override
        public String getDescription() {
            return this.mDescription;
        }
    }
}

