/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.fopen;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFile;
import com.spss.java_client.core.common.fopen.RemoteFileSystemView;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.comp_util.IFileBrowseCallback;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.core.comp_util.RemoteFileStatus;
import com.spss.java_client.core.comp_util.RemoteFileSysUtil;
import com.spss.java_client.core.resources.CoreResUtil;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.core.server.messages.fopenmsg.OpenFolderResponseMsg;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class FileValidator {
    public static final short VALIDATION_SUCCESS = 0;
    public static final short DIRECTORY_DOES_NOT_EXISTS = 1;
    public static final short DIRECTORY_READ_ONLY = 2;
    public static final short FILE_EXISTS_READ_ONLY = 3;
    public static final short FILE_EXISTS_WRITABLE = 4;
    public static final short FILE_DOES_NOT_EXISTS = 5;
    private static String sMessage;
    private static boolean sAskUser;
    private static short sResult;

    public static boolean validatePath(Component component, String string, boolean bl, boolean bl2) {
        IFileBrowseCallback iFileBrowseCallback;
        if (CommandLine.isClementineCaller() && (iFileBrowseCallback = RemoteFileChooser.getFileBrowseCallback()) != null) {
            return iFileBrowseCallback.validateFilePath(component, string);
        }
        FileValidator.reset();
        if (string.length() == 0) {
            return true;
        }
        iFileBrowseCallback = PES_Repository.getPesFile((String)string);
        if (iFileBrowseCallback != null && iFileBrowseCallback.canWriteToPesFileFolder() || iFileBrowseCallback == null && PES_Repository.isPesUri((String)string)) {
            return true;
        }
        boolean bl3 = false;
        String string2 = System.getProperty("file.separator");
        if (string.indexOf(47) != -1) {
            string2 = "/";
        } else if (string.indexOf(92) != -1) {
            string2 = "\\";
        }
        int n = string.lastIndexOf(string2);
        if (n == -1 && !FileValidator.isServerFileSystem(bl2)) {
            string = FileValidator.getDirectoryPath(string) + string2 + string;
        }
        try {
            n = string.lastIndexOf(string2);
            String string3 = string.substring(0, n);
            if (FileValidator.isServerFileSystem(bl2)) {
                OpenFolderResponseMsg openFolderResponseMsg;
                RemoteFileSystemView remoteFileSystemView = RemoteFileSystemView.getFileSystemView();
                Vector vector = null;
                File file = remoteFileSystemView.getDirectoryForPath(string3);
                if (file instanceof RefFile) {
                    vector = ((RefFile)file).getPathNodes();
                }
                bl3 = (openFolderResponseMsg = remoteFileSystemView.validateFile(vector, string3, 0)).errorExists() != 0 || openFolderResponseMsg.fileState() != 0;
            } else {
                File file = new File(string3);
                if (!file.exists()) {
                    bl3 = true;
                }
            }
        }
        catch (Exception exception) {
            bl3 = true;
        }
        if (bl3) {
            sAskUser = false;
            sMessage = CoreResUtil.getString((String)"ERR_CANNOT_SAVE_IN_SPECIFIED_FOLDER");
            if (bl) {
                FileValidator.showMessage(component);
            }
            return false;
        }
        if (!FileValidator.validateReadOnlyStatus(string, new boolean[0])) {
            return bl && FileValidator.showMessage(component);
        }
        return true;
    }

    public static String validatePath(Component component, String string, boolean bl) {
        boolean bl2 = FileValidator.validatePath(component, string, false, bl);
        return bl2 ? null : sMessage;
    }

    public static int validatePath(Component component, String string, boolean bl, boolean bl2, boolean bl3) {
        if (string.length() == 0) {
            return -2;
        }
        PesFile pesFile = PES_Repository.getPesFile((String)string);
        if (pesFile != null && pesFile.canWriteToPesFileFolder() || pesFile == null && PES_Repository.isPesUri((String)string)) {
            return -2;
        }
        boolean bl4 = false;
        String string2 = System.getProperty("file.separator");
        if (string.indexOf(47) != -1) {
            string2 = "/";
        } else if (string.indexOf(92) != -1) {
            string2 = "\\";
        }
        int n = string.lastIndexOf(string2);
        if (n == -1 && !FileValidator.isServerFileSystem(bl2)) {
            string = FileValidator.getDirectoryPath(string) + string2 + string;
        }
        try {
            n = string.lastIndexOf(string2);
            String string3 = string.substring(0, n);
            if (FileValidator.isServerFileSystem(bl2)) {
                RemoteFileSystemView remoteFileSystemView = RemoteFileSystemView.getFileSystemView();
                OpenFolderResponseMsg openFolderResponseMsg = remoteFileSystemView.validateFile(null, string3, 0);
                bl4 = openFolderResponseMsg.errorExists() != 0 || openFolderResponseMsg.fileState() != 0;
            } else {
                File file = new File(string3);
                if (!file.exists()) {
                    bl4 = true;
                }
            }
        }
        catch (Exception exception) {
            bl4 = true;
        }
        if (bl4) {
            if (bl) {
                sAskUser = false;
                sMessage = CoreResUtil.getString((String)"ERR_CANNOT_SAVE_IN_SPECIFIED_FOLDER");
                return FileValidator.showMessage2(component);
            }
            return -1;
        }
        if (!FileValidator.validateReadOnlyStatus(string, bl3)) {
            if (bl) {
                return FileValidator.showMessage2(component);
            }
            return 3;
        }
        return -2;
    }

    public static boolean validateOpenFile(Component component, String string, boolean bl, boolean bl2) {
        FileValidator.evaluateOpenFile(component, string, bl, bl2);
        if (sResult == 2 || sResult == 3) {
            return bl2;
        }
        return sResult == 4;
    }

    public static short evaluateOpenFile(Component component, String string, boolean bl, boolean bl2) {
        PesFile pesFile = PES_Repository.getPesFile((String)string);
        if (pesFile == null && PES_Repository.isPesUri((String)string)) {
            sResult = (short)5;
        } else if (pesFile != null && PES_Repository.isPesUri((String)string)) {
            sResult = 0;
            sResult = pesFile.canWriteToPesFile() ? (short)4 : (short)3;
        } else {
            FileValidator.validateReadOnlyStatus(string, true);
            if (sResult == 2 || sResult == 3) {
                if (!bl2 && bl) {
                    sAskUser = false;
                    FileValidator.showMessage(component);
                }
            } else if (sResult == 5 && bl) {
                sAskUser = false;
                sMessage = String.format(CoreResUtil.getString((String)"ERR_FILE_NOT_FOUND_MESSAGE"), FileValidator.addDirectoryPath(string));
                FileValidator.showMessage(component);
            }
        }
        return sResult;
    }

    public static String getDirectoryPath(String string) {
        int n = string.lastIndexOf(46);
        boolean bl = false;
        if (n > -1 && string.substring(n + 1).equalsIgnoreCase("sav")) {
            bl = true;
        }
        if (bl) {
            return FileLocationsUtil.getDataFilesDirectoryPath();
        }
        return FileLocationsUtil.getOtherFilesDirectoryPath();
    }

    public static String addDirectoryPath(String string) {
        return FileValidator.addDirectoryPath(string, false);
    }

    public static short result() {
        return sResult;
    }

    private static void reset() {
        sResult = 0;
    }

    public static String addDirectoryPath(String string, boolean bl) {
        if (PES_Repository.isPesUri((String)string)) {
            return string;
        }
        String string2 = System.getProperty("file.separator");
        int n = string.lastIndexOf(string2);
        if (n == -1) {
            if (!FileValidator.isServerFileSystem(bl)) {
                string = FileValidator.getDirectoryPath(string) + string2 + string;
            }
        } else {
            int n2 = string.lastIndexOf(string2 + "xxx");
            if (n2 > -1) {
                string = string.substring(0, n2);
            }
        }
        return string;
    }

    private static boolean validateReadOnlyStatus(String string, boolean ... blArray) {
        RemoteFileSysUtil remoteFileSysUtil = RemoteFileSysUtil.getRemoteFileSysUtil();
        RemoteFileStatus remoteFileStatus = remoteFileSysUtil.validateFile(string);
        if (!remoteFileStatus.errorOccurred()) {
            boolean bl;
            boolean bl2 = remoteFileStatus.getFileStatus() != RemoteFileStatus.FileNodeStatus.RFS_DOES_NOT_EXIST;
            boolean bl3 = bl = remoteFileStatus.getFileStatus() == RemoteFileStatus.FileNodeStatus.RFS_READ_ONLY;
            if (bl2) {
                if (bl) {
                    sAskUser = false;
                    File file = new File(string);
                    if (file.isDirectory()) {
                        sMessage = String.format(CoreResUtil.getString((String)"ERR_FILE_READ_ONLY_MESSAGE"), FileValidator.addDirectoryPath(string));
                        sResult = (short)2;
                    } else {
                        sMessage = String.format(CoreResUtil.getString((String)"ERR_FILE_READ_ONLY_FILE_MESSAGE"), FileValidator.addDirectoryPath(string));
                        sResult = (short)3;
                    }
                } else {
                    sAskUser = true;
                    sMessage = blArray != null && blArray.length > 0 && blArray[0] ? String.format(CoreResUtil.getString((String)"ERR_FILE_EXISTS_OVERWRITE_WARNING"), FileValidator.addDirectoryPath(string)) : String.format(CoreResUtil.getString((String)"ERR_FILE_EXISTS_WARNING"), FileValidator.addDirectoryPath(string));
                    sResult = (short)4;
                }
                return false;
            }
            sResult = (short)5;
            return true;
        }
        sResult = (short)5;
        sAskUser = false;
        sMessage = CoreResUtil.getString((String)"ERR_CANNOT_SAVE_IN_SPECIFIED_FOLDER");
        return false;
    }

    public static boolean showMessage(Component component) {
        return FileValidator.showMessage(component, sMessage);
    }

    public static boolean showMessage(Component component, String string) {
        String string2 = VersionInfo.getAppVersionString();
        if (string.length() < 1) {
            string = CoreResUtil.getString((String)"ERR_CANNOT_SAVE_IN_SPECIFIED_FOLDER");
        }
        if (sAskUser) {
            if (component instanceof Window) {
                int n = SpssAlertOptionPane.showConfirmDialog((Window)component, sMessage, string2, SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.YES_NO_OPTION);
                return n != 2;
            }
            if (component instanceof JComponent) {
                int n = SpssAlertOptionPane.showConfirmDialog((JComponent)component, sMessage, string2, SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.YES_NO_OPTION);
                return n != 2;
            }
            int n = JOptionPane.showConfirmDialog(null, sMessage, string2, 0, 2, new ImageIcon(ResUtil.getImageResource("warning_core.png")));
            return n == 0;
        }
        if (component instanceof Window) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)component, sMessage, string2);
        } else if (component instanceof JComponent) {
            SpssAlertOptionPane.showWarningMessageDialog((JComponent)component, sMessage, string2);
        } else {
            JOptionPane.showMessageDialog(null, sMessage, string2, 2);
        }
        return false;
    }

    private static int showMessage2(Component component) {
        String string = VersionInfo.getAppVersionString();
        if (sMessage.length() < 1) {
            sMessage = CoreResUtil.getString((String)"ERR_CANNOT_SAVE_IN_SPECIFIED_FOLDER");
        }
        if (sAskUser) {
            Object[] objectArray = new Object[]{ResUtil.getCommonDlgString("IDS_YES"), ResUtil.getCommonDlgString("IDS_YES_TO_ALL"), ResUtil.getCommonDlgString("IDS_NO")};
            if (component instanceof Window) {
                return SpssAlertOptionPane.showOptionDialog((Window)component, sMessage, string, SpssAlertOptionPane.IconType.eQuestion, objectArray, objectArray[0]);
            }
            if (component instanceof JComponent) {
                return SpssAlertOptionPane.showOptionDialog((JComponent)component, sMessage, string, SpssAlertOptionPane.IconType.eQuestion, objectArray, objectArray[0]);
            }
            return JOptionPane.showOptionDialog(null, sMessage, string, -1, -1, null, objectArray, objectArray[0]);
        }
        if (component instanceof Window) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)component, sMessage, string);
        } else if (component instanceof JComponent) {
            SpssAlertOptionPane.showWarningMessageDialog((JComponent)component, sMessage, string);
        } else {
            JOptionPane.showMessageDialog(null, sMessage, string, 2);
        }
        return 3;
    }

    private static boolean isServerFileSystem(boolean bl) {
        return DataServerProxy.getDataProxy().isRemoteConnection() && bl;
    }

    static {
        sResult = 0;
    }
}

