/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.fopen;

import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.uitools.dialogs.IDlgKeyPressListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.JComponent;

public class FileDialogKeyAdapter
implements KeyListener,
ContainerListener {
    protected JComponent mFileDialog;
    protected Vector<IDlgKeyPressListener> mListeners = new Vector();

    public FileDialogKeyAdapter(JComponent jComponent) {
        this.mFileDialog = jComponent;
        this.addKeyAndContainerListenerRecursively(this.mFileDialog);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 112 && this.mFileDialog instanceof RemoteFileChooser) {
            ((RemoteFileChooser)this.mFileDialog).doHelp();
        }
        for (IDlgKeyPressListener iDlgKeyPressListener : this.mListeners) {
            iDlgKeyPressListener.dialogKeyEvent(keyEvent);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    public void addDlgKeyPressListener(IDlgKeyPressListener iDlgKeyPressListener) {
        this.mListeners.add(iDlgKeyPressListener);
    }

    public void removeDlgKeyPressListener(IDlgKeyPressListener iDlgKeyPressListener) {
        this.mListeners.remove(iDlgKeyPressListener);
    }

    @Override
    public void componentAdded(ContainerEvent containerEvent) {
        this.addKeyAndContainerListenerRecursively(containerEvent.getChild());
    }

    @Override
    public void componentRemoved(ContainerEvent containerEvent) {
        this.removeKeyAndContainerListenerRecursively(containerEvent.getChild());
    }

    private void addKeyAndContainerListenerRecursively(Component component) {
        component.removeKeyListener(this);
        component.addKeyListener(this);
        if (component instanceof Container) {
            Container container = (Container)component;
            container.removeContainerListener(this);
            container.addContainerListener(this);
            for (Component component2 : container.getComponents()) {
                this.addKeyAndContainerListenerRecursively(component2);
            }
        }
    }

    private void removeKeyAndContainerListenerRecursively(Component component) {
        component.removeKeyListener(this);
        if (component instanceof Container) {
            Container container = (Container)component;
            container.removeContainerListener(this);
            for (Component component2 : container.getComponents()) {
                this.removeKeyAndContainerListenerRecursively(component2);
            }
        }
    }
}

