/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.documents.output.pagesetup;

import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.output.IOutputDocument;
import com.spss.java_client.core.documents.output.IPageSetupInfo;
import com.spss.java_client.core.documents.output.PageSetupInfo;
import com.spss.java_client.core.documents.output.export.OutputExporter;
import com.spss.java_client.core.resources.ComponentResBundle;
import com.spss.java_client.core.resources.CoreResUtil;
import com.spss.java_client.ui.doc_types.output.IViewerWindow;
import com.spss.shared.export.ExportCopyParams;
import com.spss.shared.export.IExportOptions;
import com.spss.shared.export.ISpssExportable;
import java.awt.print.Paper;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;

public class PageSetupUtil {
    public static int getOrientation(IViewerWindow iViewerWindow, int n) {
        IOutputDocument iOutputDocument = iViewerWindow.getDocument().getCoreDocument();
        String string = PageSetupUtil.getDocOrientation(iOutputDocument);
        if (iOutputDocument.getPageSetupInfo() != null && string.length() > 0) {
            if (string.equals(PageSetupUtil.getCoreResString("IDS_PAGE_SETUP_LANDSCAPE_ORIENTATION"))) {
                return 0;
            }
            return 1;
        }
        return PageSetupUtil.getValueFromOption("page_setup_orientation", 1);
    }

    public static boolean setOrientation(IViewerWindow iViewerWindow, int n) {
        boolean bl = false;
        IOutputDocument iOutputDocument = iViewerWindow.getDocument().getCoreDocument();
        String string = PageSetupUtil.getDocOrientation(iOutputDocument);
        String string2 = PageSetupUtil.getCoreResString("IDS_PAGE_SETUP_LANDSCAPE_ORIENTATION");
        String string3 = PageSetupUtil.getCoreResString("IDS_PAGE_SETUP_PORTRAIT_ORIENTATION");
        if (string.equals(string2)) {
            if (n != 0) {
                PageSetupUtil.setDocOrientation(iOutputDocument, string3);
                bl = true;
            }
        } else if (string.equals(string3) && n != 1) {
            PageSetupUtil.setDocOrientation(iOutputDocument, string2);
            bl = true;
        }
        return bl;
    }

    public static Paper getPaper(IViewerWindow iViewerWindow, Paper paper) {
        boolean bl;
        block6: {
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance(Locale.US);
            decimalFormat.applyLocalizedPattern("###.##in");
            IOutputDocument iOutputDocument = iViewerWindow.getDocument().getCoreDocument();
            bl = false;
            if (iOutputDocument.getPageSetupInfo() != null) {
                try {
                    double d = 72.0 * decimalFormat.parse(PageSetupUtil.getDocPaperWidth(iOutputDocument)).doubleValue();
                    double d2 = 72.0 * decimalFormat.parse(PageSetupUtil.getDocPaperHeight(iOutputDocument)).doubleValue();
                    double d3 = 72.0 * decimalFormat.parse(PageSetupUtil.getDocLeftMargin(iOutputDocument)).doubleValue();
                    double d4 = 72.0 * decimalFormat.parse(PageSetupUtil.getDocTopMargin(iOutputDocument)).doubleValue();
                    double d5 = 72.0 * decimalFormat.parse(PageSetupUtil.getDocRightMargin(iOutputDocument)).doubleValue();
                    double d6 = 72.0 * decimalFormat.parse(PageSetupUtil.getDocBottomMargin(iOutputDocument)).doubleValue();
                    double d7 = d - d3 - d5;
                    double d8 = d2 - d4 - d6;
                    if (d7 <= 0.0 || d8 <= 0.0) {
                        bl = true;
                        break block6;
                    }
                    paper.setSize(d, d2);
                    paper.setImageableArea(d3, d4, d7, d8);
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace();
                }
            } else {
                bl = true;
            }
        }
        if (bl) {
            return PageSetupUtil.getPaperFromOption(paper, PageSetupUtil.getOrientation(iViewerWindow, 0));
        }
        return paper;
    }

    private static Paper getPaperFromOption(Paper paper, int n) {
        double d;
        String string = PageSetupUtil.getMeasurementUnit();
        double d2 = 1.0;
        if (string.equalsIgnoreCase("inches")) {
            d = 72.0;
        } else if (string.equalsIgnoreCase("mm")) {
            d = 2.834645669291339;
            d2 = 25.0;
        } else {
            return paper;
        }
        double d3 = paper.getWidth();
        double d4 = paper.getHeight();
        double d5 = PageSetupUtil.getValueFromOption("page_setup_left_margin", d2);
        double d6 = PageSetupUtil.getValueFromOption("page_setup_right_margin", d2);
        double d7 = PageSetupUtil.getValueFromOption("page_setup_bottom_margin", d2);
        double d8 = PageSetupUtil.getValueFromOption("page_setup_top_margin", d2);
        paper.setSize(d3, d4);
        if (n == 1) {
            double d9 = d3 - d5 * d - d6 * d;
            double d10 = d4 - d8 * d - d7 * d;
            paper.setImageableArea(d5 * d, d8 * d, d9, d10);
        } else {
            double d11 = d3 - d8 * d - d7 * d;
            double d12 = d4 - d5 * d - d6 * d;
            paper.setImageableArea(d8 * d, d6 * d, d11, d12);
        }
        return paper;
    }

    public static boolean setPaper(IViewerWindow iViewerWindow, Paper paper) {
        boolean bl = false;
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance(Locale.US);
        decimalFormat.applyLocalizedPattern("###.##########in");
        IOutputDocument iOutputDocument = iViewerWindow.getDocument().getCoreDocument();
        double d = paper.getWidth();
        double d2 = paper.getHeight();
        double d3 = paper.getImageableX();
        double d4 = paper.getImageableY();
        double d5 = paper.getImageableWidth();
        double d6 = paper.getImageableHeight();
        double d7 = d - d3 - d5;
        double d8 = d2 - d4 - d6;
        try {
            String string;
            double d9 = 72.0 * decimalFormat.parse(PageSetupUtil.getDocLeftMargin(iOutputDocument)).doubleValue();
            if (Double.compare(d9, d3) != 0) {
                string = decimalFormat.format(d3 / 72.0);
                PageSetupUtil.setDocLeftMargin(iOutputDocument, string);
                bl = true;
            }
            if (Double.compare(d9 = 72.0 * decimalFormat.parse(PageSetupUtil.getDocTopMargin(iOutputDocument)).doubleValue(), d4) != 0) {
                string = decimalFormat.format(d4 / 72.0);
                PageSetupUtil.setDocTopMargin(iOutputDocument, string);
                bl |= true;
            }
            if (Double.compare(d9 = 72.0 * decimalFormat.parse(PageSetupUtil.getDocRightMargin(iOutputDocument)).doubleValue(), d7) != 0) {
                string = decimalFormat.format(d7 / 72.0);
                PageSetupUtil.setDocRightMargin(iOutputDocument, string);
                bl |= true;
            }
            if (Double.compare(d9 = 72.0 * decimalFormat.parse(PageSetupUtil.getDocBottomMargin(iOutputDocument)).doubleValue(), d8) != 0) {
                string = decimalFormat.format(d8 / 72.0);
                PageSetupUtil.setDocBottomMargin(iOutputDocument, string);
                bl |= true;
            }
            if (Double.compare(d9 = 72.0 * decimalFormat.parse(PageSetupUtil.getDocPaperWidth(iOutputDocument)).doubleValue(), d) != 0) {
                string = decimalFormat.format(d / 72.0);
                PageSetupUtil.setDocPaperWidth(iOutputDocument, string);
                bl |= true;
            }
            if (Double.compare(d9 = 72.0 * decimalFormat.parse(PageSetupUtil.getDocPaperHeight(iOutputDocument)).doubleValue(), d2) != 0) {
                string = decimalFormat.format(d2 / 72.0);
                PageSetupUtil.setDocPaperHeight(iOutputDocument, string);
                bl |= true;
            }
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        return bl;
    }

    public static ExportCopyParams collectExportCopyParams(IViewerWindow iViewerWindow) {
        ISpssExportable.TextStyle textStyle = OutputExporter.getPrefTextStyle();
        Paper paper = PageSetupUtil.getPaper(iViewerWindow, new Paper());
        IExportOptions.WideTablesOptions wideTablesOptions = PrefsMgr.getPrefsMgr().getUserWideTableOptions();
        return new ExportCopyParams(paper, wideTablesOptions, textStyle);
    }

    private static String getDocOrientation(IOutputDocument iOutputDocument) {
        int n;
        IPageSetupInfo iPageSetupInfo = iOutputDocument.getPageSetupInfo();
        if (iPageSetupInfo != null) {
            String string = iPageSetupInfo.getReferenceOrientation();
            String string2 = PageSetupUtil.getCoreResString("IDS_PAGE_SETUP_LANDSCAPE_ORIENTATION");
            String string3 = PageSetupUtil.getCoreResString("IDS_PAGE_SETUP_PORTRAIT_ORIENTATION");
            if (string.equals(string2)) {
                return string2;
            }
            if (string.equals(string3)) {
                return string3;
            }
        }
        if ((n = PageSetupUtil.getValueFromOption("page_setup_orientation", 1)) == 0) {
            return PageSetupUtil.getCoreResString("IDS_PAGE_SETUP_LANDSCAPE_ORIENTATION");
        }
        return PageSetupUtil.getCoreResString("IDS_PAGE_SETUP_PORTRAIT_ORIENTATION");
    }

    private static void setDocOrientation(IOutputDocument iOutputDocument, String string) {
        IPageSetupInfo iPageSetupInfo = iOutputDocument.getPageSetupInfo();
        if (iPageSetupInfo == null) {
            iPageSetupInfo = new PageSetupInfo();
        }
        iPageSetupInfo.setReferenceOrientation(string);
        iOutputDocument.setPageSetupInfo(iPageSetupInfo);
    }

    private static String getDocLeftMargin(IOutputDocument iOutputDocument) {
        IPageSetupInfo iPageSetupInfo = iOutputDocument.getPageSetupInfo();
        if (iPageSetupInfo != null) {
            String string = iPageSetupInfo.getMarginLeft();
            if (string.length() != 0) {
                return string;
            }
            return "0in";
        }
        return PageSetupUtil.getCoreResString("IDS_PAGE_SETUP_DEFAULT_MARGIN_LEFT");
    }

    private static void setDocLeftMargin(IOutputDocument iOutputDocument, String string) {
        IPageSetupInfo iPageSetupInfo = iOutputDocument.getPageSetupInfo();
        if (iPageSetupInfo == null) {
            iPageSetupInfo = new PageSetupInfo();
        }
        iPageSetupInfo.setMarginLeft(string);
        iOutputDocument.setPageSetupInfo(iPageSetupInfo);
    }

    private static String getDocTopMargin(IOutputDocument iOutputDocument) {
        IPageSetupInfo iPageSetupInfo = iOutputDocument.getPageSetupInfo();
        if (iPageSetupInfo != null) {
            String string = iPageSetupInfo.getMarginTop();
            if (string.length() != 0) {
                return string;
            }
            return "0in";
        }
        return PageSetupUtil.getCoreResString("IDS_PAGE_SETUP_DEFAULT_MARGIN_TOP");
    }

    private static void setDocTopMargin(IOutputDocument iOutputDocument, String string) {
        IPageSetupInfo iPageSetupInfo = iOutputDocument.getPageSetupInfo();
        if (iPageSetupInfo == null) {
            iPageSetupInfo = new PageSetupInfo();
        }
        iPageSetupInfo.setMarginTop(string);
        iOutputDocument.setPageSetupInfo(iPageSetupInfo);
    }

    private static String getDocRightMargin(IOutputDocument iOutputDocument) {
        IPageSetupInfo iPageSetupInfo = iOutputDocument.getPageSetupInfo();
        if (iPageSetupInfo != null) {
            String string = iPageSetupInfo.getMarginRight();
            if (string.length() != 0) {
                return string;
            }
            return "0in";
        }
        return PageSetupUtil.getCoreResString("IDS_PAGE_SETUP_DEFAULT_MARGIN_RIGHT");
    }

    private static void setDocRightMargin(IOutputDocument iOutputDocument, String string) {
        IPageSetupInfo iPageSetupInfo = iOutputDocument.getPageSetupInfo();
        if (iPageSetupInfo == null) {
            iPageSetupInfo = new PageSetupInfo();
        }
        iPageSetupInfo.setMarginRight(string);
        iOutputDocument.setPageSetupInfo(iPageSetupInfo);
    }

    private static String getDocBottomMargin(IOutputDocument iOutputDocument) {
        IPageSetupInfo iPageSetupInfo = iOutputDocument.getPageSetupInfo();
        if (iPageSetupInfo != null) {
            String string = iPageSetupInfo.getMarginBottom();
            if (string.length() != 0) {
                return string;
            }
            return "0in";
        }
        return PageSetupUtil.getCoreResString("IDS_PAGE_SETUP_DEFAULT_MARGIN_BOTTOM");
    }

    private static void setDocBottomMargin(IOutputDocument iOutputDocument, String string) {
        IPageSetupInfo iPageSetupInfo = iOutputDocument.getPageSetupInfo();
        if (iPageSetupInfo == null) {
            iPageSetupInfo = new PageSetupInfo();
        }
        iPageSetupInfo.setMarginBottom(string);
        iOutputDocument.setPageSetupInfo(iPageSetupInfo);
    }

    private static String getDocPaperWidth(IOutputDocument iOutputDocument) {
        IPageSetupInfo iPageSetupInfo = iOutputDocument.getPageSetupInfo();
        if (iPageSetupInfo != null) {
            String string = iPageSetupInfo.getPaperWidth();
            if (string.length() != 0) {
                return string;
            }
            return "0in";
        }
        return PageSetupUtil.getCoreResString("IDS_PAGE_SETUP_DEFAULT_PAPER_WIDTH");
    }

    private static void setDocPaperWidth(IOutputDocument iOutputDocument, String string) {
        IPageSetupInfo iPageSetupInfo = iOutputDocument.getPageSetupInfo();
        if (iPageSetupInfo == null) {
            iPageSetupInfo = new PageSetupInfo();
        }
        iPageSetupInfo.setPaperWidth(string);
        iOutputDocument.setPageSetupInfo(iPageSetupInfo);
    }

    private static String getDocPaperHeight(IOutputDocument iOutputDocument) {
        IPageSetupInfo iPageSetupInfo = iOutputDocument.getPageSetupInfo();
        if (iPageSetupInfo != null) {
            String string = iPageSetupInfo.getPaperHeight();
            if (string.length() != 0) {
                return string;
            }
            return "0in";
        }
        return PageSetupUtil.getCoreResString("IDS_PAGE_SETUP_DEFAULT_PAPER_HEIGHT");
    }

    private static void setDocPaperHeight(IOutputDocument iOutputDocument, String string) {
        IPageSetupInfo iPageSetupInfo = iOutputDocument.getPageSetupInfo();
        if (iPageSetupInfo == null) {
            iPageSetupInfo = new PageSetupInfo();
        }
        iPageSetupInfo.setPaperHeight(string);
        iOutputDocument.setPageSetupInfo(iPageSetupInfo);
    }

    private static String getCoreResString(String string) {
        ResourceBundle resourceBundle = CoreResUtil.getBundle((String)ComponentResBundle.getDefaultResourceBundleName(), (Locale)CoreResUtil.getLocale());
        return CoreResUtil.getString((ResourceBundle)resourceBundle, (String)string);
    }

    public static String getMeasurementUnit() {
        String string = System.getProperty("user.country");
        if (string != null && (string.equals("") || string.equals(Locale.US.getCountry()) || string.equals(Locale.CANADA.getCountry()))) {
            return "inches";
        }
        return "mm";
    }

    private static int getValueFromOption(String string, int n) {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options");
        Preferences preferences2 = preferences.node("viewer");
        return preferences2.getInt(string, n);
    }

    private static double getValueFromOption(String string, double d) {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options");
        Preferences preferences2 = preferences.node("viewer");
        return preferences2.getDouble(string, d);
    }
}

