/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.documents.output.pageattributes;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.output.IPageSetupInfo;
import com.spss.java_client.core.template.viewer.PageAttributes;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseSpssTab;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.documents.output.pageattributes.PageAttributesDlg;
import com.spss.uitools.controls.NumberSpinner;
import com.spss.uitools.util.IOptionConstants;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.Enumeration;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SwingUtilities;

public class OptionsTab
extends BaseSpssTab
implements ItemListener {
    private final int NUMBER_PAGES_SPINNER_MAX_LIMIT = 1000;
    private final int NUMBER_PAGES_SPINNER_MIN_LIMIT = 1;
    private final int SPACES_SPINNER_MAX_LIMIT = 720;
    private final int SPACES_SPINNER_MIN_LIMIT = 1;
    private final int SPACES_SPINNER_DEFAULT_VALUE = 12;
    private JRadioButton mAsIsRadio;
    private JRadioButton mFullPageRadio;
    private JRadioButton mHalfPageRadio;
    private JRadioButton mQuarterPageRadio;
    private GridBagConstraints mConstraints;
    private Insets mInsets;
    private JLabel mLabelIcon;
    private JSpinner mSpaceSpinner;
    private String mUserUnit;
    private JSpinner mNumberSpinner;
    private SpssButtonGroup mButtonGroup;

    public OptionsTab(PageAttributesDlg pageAttributesDlg, boolean bl) {
        super(pageAttributesDlg, bl);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (OptionsTab.this.isDisplayable()) {
                    OptionsTab.this.loadOptions();
                }
            }
        });
    }

    public void saveChanges(IPageSetupInfo iPageSetupInfo) {
        iPageSetupInfo.setChartSize(this.getSelectedButtonName());
        int n = this.getValueInPointFromSpinner(this.mSpaceSpinner.getValue());
        iPageSetupInfo.setSpaceAfter(String.valueOf(n));
        iPageSetupInfo.setInitPageNumber(Integer.parseInt(this.mNumberSpinner.getValue().toString()));
    }

    public void savePrefs() {
        PageAttributes.setPrefChartSize((String)this.getSelectedButtonName());
        PageAttributes.setPrefInitialPageNumber((String)this.mNumberSpinner.getValue().toString());
        int n = this.getValueInPointFromSpinner(this.mSpaceSpinner.getValue());
        PageAttributes.setPrefSpaceAfter((String)String.valueOf(n));
    }

    public JSpinner getSpaceSpinner() {
        return this.mSpaceSpinner;
    }

    public JSpinner getNumberSpinner() {
        return this.mNumberSpinner;
    }

    public void loadOptions() {
        String string;
        int n;
        String string2;
        IPageSetupInfo iPageSetupInfo = ((PageAttributesDlg)this.mParent).getPageSetupInfo();
        if (iPageSetupInfo != null) {
            string2 = iPageSetupInfo.getSpaceAfter();
            n = iPageSetupInfo.getInitPageNumber();
            string = iPageSetupInfo.getChartSize();
        } else {
            string2 = PageAttributes.getPrefSpaceAfter();
            n = Integer.parseInt(PageAttributes.getPrefInitialPageNumber());
            string = PageAttributes.getPrefChartSize();
        }
        int n2 = string2.indexOf("pt");
        if (n2 != -1) {
            string2 = string2.substring(0, n2);
        }
        if (!string2.trim().equals("")) {
            double d = Double.parseDouble(string2);
            this.mSpaceSpinner.setValue(this.getValueInUserUnitForSpinner(d, this.mUserUnit));
        }
        this.mNumberSpinner.setValue(n);
        this.setSelectedButton(string);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        URL uRL = null;
        if (this.mAsIsRadio.isSelected()) {
            uRL = this.getResImageURL("IDS_PAGESETUP_OPTIONS_TAB_AS_IS_IMAGE");
        } else if (this.mFullPageRadio.isSelected()) {
            uRL = this.getResImageURL("IDS_PAGESETUP_OPTIONS_TAB_FULL_IMAGE");
        } else if (this.mHalfPageRadio.isSelected()) {
            uRL = this.getResImageURL("IDS_PAGESETUP_OPTIONS_TAB_HALF_IMAGE");
        } else if (this.mQuarterPageRadio.isSelected()) {
            uRL = this.getResImageURL("IDS_PAGESETUP_OPTIONS_TAB_QUARTER_IMAGE");
        }
        if (uRL != null) {
            this.mLabelIcon.setIcon(new ImageIcon(uRL));
        }
    }

    @Override
    public void initPanel() {
        super.initPanel();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.setupPrinterChartSize();
        JPanel jPanel2 = this.setupRemainingComponents();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 2;
        this.mInsets.set(n2, n2, 0, n2);
        DialogUtil.addUsingGBL(this, jPanel, this.mConstraints, 0, 0, 1, 1, n, this.mInsets);
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        DialogUtil.addUsingGBL(this, jPanel2, this.mConstraints, 0, 1, 1, 1, n, this.mInsets);
        this.setTabTraversal();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_pgsp_op";
    }

    @Override
    protected boolean validateTab() {
        String string = this.mSpaceSpinner.getValue().toString();
        String string2 = this.mNumberSpinner.getValue().toString();
        boolean bl = true;
        boolean bl2 = true;
        if (string2.equals("")) {
            bl = false;
        } else {
            int n = Integer.parseInt(string2);
            if (n < 1 || n > 1000) {
                bl = false;
                this.mSpaceSpinner.getEditor().requestFocus();
                return false;
            }
        }
        if (string.equals("")) {
            bl2 = false;
        } else {
            double d = Double.parseDouble(string);
            if (d < this.getDefaultMinInUserUnit() || d > this.getDefaultMaxInUserUnit()) {
                bl2 = false;
                this.mNumberSpinner.getEditor().requestFocus();
                return false;
            }
        }
        if (!bl) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_PAGESETUP_OPTIONS_TAB_NUMBERSPINNER_INVALID_NUMBER_MSG"), VersionInfo.getAppVersionString());
            this.mNumberSpinner.getEditor().requestFocus();
            return false;
        }
        if (!bl2) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, this.getResString("ERR_PAGESETUP_OPTIONS_TAB_SPACESPINNER_INVALID_NUMBER_MSG"), VersionInfo.getAppVersionString());
            this.mSpaceSpinner.getEditor().requestFocus();
            return false;
        }
        return true;
    }

    @Override
    protected void aboutToShowTab() {
        this.mAsIsRadio.requestFocus();
    }

    private String getSelectedButtonName() {
        int n = 0;
        Enumeration<AbstractButton> enumeration = this.mButtonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            AbstractButton abstractButton = enumeration.nextElement();
            if (((JRadioButton)abstractButton).isSelected()) {
                return PageAttributes.CHART_SIZE[n];
            }
            ++n;
        }
        return PageAttributes.CHART_SIZE[n];
    }

    private void setSelectedButton(String string) {
        int n = 0;
        for (int i = 0; i < PageAttributes.CHART_SIZE.length; ++i) {
            if (!PageAttributes.CHART_SIZE[i].equals(string)) continue;
            n = i;
        }
        Enumeration<AbstractButton> enumeration = this.mButtonGroup.getElements();
        JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
        for (int i = 0; i < n; ++i) {
            jRadioButton = (JRadioButton)enumeration.nextElement();
        }
        jRadioButton.setSelected(true);
    }

    private void setTabTraversal() {
        Component[] componentArray;
        this.mButtonGroup = new SpssButtonGroup();
        this.mButtonGroup.add(this.mAsIsRadio);
        this.mButtonGroup.add(this.mFullPageRadio);
        this.mButtonGroup.add(this.mHalfPageRadio);
        this.mButtonGroup.add(this.mQuarterPageRadio);
        this.addToComponentOrder(this.mButtonGroup);
        this.addToComponentOrder(this.mSpaceSpinner.getEditor());
        this.addToComponentOrder(this.mNumberSpinner.getEditor());
        JPanel jPanel = ((PageAttributesDlg)this.mParent).getCmdButtonPanel();
        for (Component component : componentArray = jPanel.getComponents()) {
            this.addToComponentOrder(component);
        }
    }

    private void initVars() {
        this.mAsIsRadio = new JRadioButton(new ToggleButtonAction(this.mParent, "IDS_PAGESETUP_OPTIONS_TAB_AS_IS_RADIOBUTTON"));
        this.mHalfPageRadio = new JRadioButton(new ToggleButtonAction(this.mParent, "IDS_PAGESETUP_OPTIONS_TAB_HALF_PAGE_RADIOBUTTON"));
        this.mFullPageRadio = new JRadioButton(new ToggleButtonAction(this.mParent, "IDS_PAGESETUP_OPTIONS_TAB_FULL_PAGE_RADIOBUTTON"));
        this.mQuarterPageRadio = new JRadioButton(new ToggleButtonAction(this.mParent, "IDS_PAGESETUP_OPTIONS_TAB_QUARTER_PAGE_RADIOBUTTON"));
        this.mConstraints = new GridBagConstraints();
        this.mInsets = new Insets(0, 0, 0, 0);
        this.mLabelIcon = new JLabel();
        int n = 1;
        this.mUserUnit = this.getMeasurementStr();
        this.mSpaceSpinner = new NumberSpinner(this.getDefaultInUserUnit(), this.getDefaultMinInUserUnit(), this.getDefaultMaxInUserUnit(), 1, true, (double)n);
        this.mNumberSpinner = new NumberSpinner(1, 1, 1000, true, n);
    }

    private void setDefaults() {
        this.mAsIsRadio.addItemListener(this);
        this.mHalfPageRadio.addItemListener(this);
        this.mFullPageRadio.addItemListener(this);
        this.mQuarterPageRadio.addItemListener(this);
        this.mAsIsRadio.setSelected(true);
        this.mSpaceSpinner.getModel().setValue(this.getDefaultInUserUnit());
        this.mSpaceSpinner.setPreferredSize(new Dimension(50, (int)this.mSpaceSpinner.getPreferredSize().getHeight()));
        this.mNumberSpinner.getModel().setValue(1);
        this.mNumberSpinner.setPreferredSize(new Dimension(50, (int)this.mNumberSpinner.getPreferredSize().getHeight()));
    }

    private JPanel setupPrinterChartSize() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_PAGESETUP_OPTIONS_TAB_PRINTED_CHART_PANEL")));
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        int n3 = DialogUtil.getComponentGroupGap();
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 1.0;
        JPanel jPanel2 = PanelFactory.getBasicPanel(new JComponent[]{this.mAsIsRadio, this.mFullPageRadio, this.mHalfPageRadio, this.mQuarterPageRadio}, PanelFactory.PanelType.yaxis, null);
        this.mInsets.set(n2, n2, n2, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, this.mConstraints, 0, 0, 1, 1, n, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mInsets.set(n2 * n2, n3, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mLabelIcon, this.mConstraints, 1, 0, 1, 1, n, this.mInsets);
        return jPanel;
    }

    private JPanel setupRemainingComponents() {
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        int n3 = DialogUtil.getComponentGroupGap();
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.mInsets.set(n2, n2, 0, 0);
        JLabel jLabel = DialogUtil.createLabel(this.mParent, "IDS_PAGESETUP_OPTIONS_TAB_SPACE_BET_LABEL");
        jLabel.setLabelFor(this.mSpaceSpinner.getEditor());
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, this.mConstraints, 0, 0, 1, 1, n, this.mInsets);
        this.mInsets.set(n2, n3, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mSpaceSpinner, this.mConstraints, 1, 0, 1, 1, n, this.mInsets);
        this.mInsets.set(n2, n3, 0, n2);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.fill = 2;
        JLabel jLabel2 = this.mUserUnit.startsWith("points") ? new JLabel(this.getResString("IDS_PAGESETUP_OPTIONS_TAB_PTS_LABEL")) : (this.mUserUnit.startsWith("inches") ? new JLabel(this.getResString("IDS_PAGESETUP_OPTIONS_TAB_INS_LABEL")) : new JLabel(this.getResString("IDS_PAGESETUP_OPTIONS_TAB_CMS_LABEL")));
        DialogUtil.addUsingGBL(jPanel, jLabel2, this.mConstraints, 2, 0, 1, 1, n, this.mInsets);
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 0;
        this.mInsets.set(n2 + n2 + 3, n2, n2, 0);
        JLabel jLabel3 = DialogUtil.createLabel(this.mParent, "IDS_PAGESETUP_OPTIONS_TAB_NUMBER_PAGES_LABEL");
        jLabel3.setLabelFor(this.mNumberSpinner.getEditor());
        DialogUtil.addUsingGBL(jPanel, jLabel3, this.mConstraints, 0, 1, 1, 1, n, this.mInsets);
        this.mConstraints.weightx = 0.0;
        this.mInsets.set(n3, n3, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mNumberSpinner, this.mConstraints, 1, 1, 1, 1, n, this.mInsets);
        return jPanel;
    }

    private double getDefaultInUserUnit() {
        return (Double)this.getValueInUserUnitForSpinner(12.0, this.mUserUnit);
    }

    private double getDefaultMinInUserUnit() {
        return (Double)this.getValueInUserUnitForSpinner(1.0, this.mUserUnit);
    }

    private double getDefaultMaxInUserUnit() {
        return (Double)this.getValueInUserUnitForSpinner(720.0, this.mUserUnit);
    }

    private String getMeasurementStr() {
        Preferences preferences = Preferences.userRoot().node(PrefsMgr.getPrefsMgr().getUIUserPrefs().absolutePath());
        String string = "";
        if (preferences != null) {
            Preferences preferences2 = preferences.node("options");
            Preferences preferences3 = preferences2.node("general");
            string = preferences3.get("measurement_system", PrefDefaults.DEF_MEASUREMENT_UNITS);
        }
        if (string.length() == 0) {
            string = IOptionConstants.OUTPUT_MEASUREMENT_SYSTEM_VALUES[0];
        }
        return string;
    }

    private int getValueInPointFromSpinner(Object object) {
        int n = 0;
        String string = this.getMeasurementStr();
        if (string.equals("points")) {
            if (object instanceof Integer) {
                n = (Integer)object;
            } else if (object instanceof Double) {
                n = (int)((Double)object * 1.0);
            }
        } else if (string.equals("inches")) {
            if (object instanceof Integer) {
                n = (Integer)object * 72;
            } else if (object instanceof Double) {
                n = (int)((Double)object * 72.0);
            }
        } else if (string.equals("centimeters")) {
            if (object instanceof Integer) {
                n = (Integer)object * 72;
            } else if (object instanceof Double) {
                n = (int)((Double)object * 72.0 / 2.54);
            }
        }
        return n;
    }

    private Object getValueInUserUnitForSpinner(double d, String string) {
        Double d2 = null;
        if (string.equals("points")) {
            d2 = d;
        } else if (string.equals("inches")) {
            d2 = d / 72.0;
        } else if (string.equals("centimeters")) {
            d2 = d * 2.54 / 72.0;
        }
        return d2;
    }
}

