/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.documents.output.pageattributes;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.documents.output.IPageSetupInfo;
import com.spss.java_client.core.template.viewer.PageAttributes;
import com.spss.java_client.ui.dialogs.common.BaseSpssTab;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SPSSFontChooser;
import com.spss.java_client.ui.dialogs.documents.output.pageattributes.PageAttributesDlg;
import com.spss.java_client.ui.print.OutputViewPrintable;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.core_tools.utils.FontUtil;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;

public class HeaderFooterTab
extends BaseSpssTab
implements CaretListener,
FocusListener,
KeyListener {
    private boolean mSpaceEntered = false;
    final float[] physicalSizes = new float[]{10.0f, 12.0f, 14.0f, 18.0f, 24.0f, 36.0f};
    private static final char[] sAsciiChas = new char[]{'\u00e1', '\u00ed'};
    private static final String[] sAscii_codes = new String[]{"&#225;", "&#237;"};
    private Hashtable<String, String> mAsciiCodesTable = new Hashtable();
    private Hashtable<String, String[]> mAccentcodeTable = new Hashtable();
    private JTextPane mLastFocusedPane;
    private JTextPane mHeaderTextPane;
    private JTextPane mFooterTextPane;
    private JScrollPane mHeaderScrollPane;
    private JScrollPane mFooterScrollPane;
    private GridBagConstraints mConstraints;
    private Insets mInsets;
    private JButton mDate;
    private JButton mTime;
    private JButton mFileName;
    private JButton mPageNumber;
    private JButton mHeading1;
    private JButton mHeading2;
    private JButton mHeading3;
    private JButton mHeading4;
    private JButton mFont;
    private JButton mPageTitle;
    private JButton mLeftAlignButton;
    private JButton mRightAlignButton;
    private JButton mCenterAlignButton;
    private int mLastHeaderAlignment = 1;
    private int mLastFooterAlignment = 2;
    private Border mOriginalBorder;
    private UndoHandler mHeaderUndoHandler;
    private UndoHandler mFooterUndoHandler;
    private DocumentListener mHeaderDocListener;
    private DocumentListener mFooterDocListener;
    private HTMLDocument mHeaderDocument;
    private HTMLDocument mFooterDocument;
    private static String footerAlign = "<p align=\"right\" style=\"margin-top: 0\">";
    private MutableAttributeSet mHeaderAttr = null;
    private MutableAttributeSet mFooterAttr = null;
    private boolean mHeaderAlignChanged = false;
    private boolean mFooterAlignChanged = false;
    static final String[] ENGLISH_KEY_STRING = new String[]{"&[PageTitle]", "&[Date]", "&[Time]", "&[Filename]", "&[Page]", "&[Head1]", "&[Head2]", "&[Head3]", "&[Head4]"};
    private String[] LOCALIZED_KEY_STRING = new String[]{this.getResString(ButtonNames.PAGE_TITLE.getValue()), this.getResString(ButtonNames.DATE.getValue()), this.getResString(ButtonNames.TIME.getValue()), this.getResString(ButtonNames.FILE_NAME.getValue()), this.getResString(ButtonNames.PAGE_NUMBER.getValue()), this.getResString(ButtonNames.HEAD1.getValue()), this.getResString(ButtonNames.HEAD2.getValue()), this.getResString(ButtonNames.HEAD3.getValue()), this.getResString(ButtonNames.HEAD4.getValue())};
    static final String[] ENGLISH_KEY_STRING_AMP = new String[]{"&amp;[PageTitle]", "&amp;[Date]", "&amp;[Time]", "&amp;[Filename]", "&amp;[Page]", "&amp;[Head1]", "&amp;[Head2]", "&amp;[Head3]", "&amp;[Head4]"};
    private String[] LOCALIZED_KEY_STRING_AMP = new String[]{this.replaceAmp(this.getResString(ButtonNames.PAGE_TITLE.getValue())), this.replaceAmp(this.getResString(ButtonNames.DATE.getValue())), this.replaceAmp(this.getResString(ButtonNames.TIME.getValue())), this.replaceAmp(this.getResString(ButtonNames.FILE_NAME.getValue())), this.replaceAmp(this.getResString(ButtonNames.PAGE_NUMBER.getValue())), this.replaceAmp(this.getResString(ButtonNames.HEAD1.getValue())), this.replaceAmp(this.getResString(ButtonNames.HEAD2.getValue())), this.replaceAmp(this.getResString(ButtonNames.HEAD3.getValue())), this.replaceAmp(this.getResString(ButtonNames.HEAD4.getValue()))};
    private Hashtable<String, String[]> doubleByteEncoding = new Hashtable();
    private static final String[] Ja_unicodes = new String[]{"&amp;[&#12506;&#12540;&#12472; &#12479;&#12452;&#12488;&#12523;]", "&amp;[&#26085;&#20184;]", "&amp;[&#26178;&#21051;]", "&amp;[&#12501;&#12449;&#12452;&#12523;&#21517;]", "&amp;[&#12506;&#12540;&#12472;]", "&amp;[&#12504;&#12483;&#12489;1]", "&amp;[&#12504;&#12483;&#12489;2]", "&amp;[&#12504;&#12483;&#12489;3]", "&amp;[&#12504;&#12483;&#12489;4]"};
    private static final String[] tw_CN_unicodes = new String[]{"&amp;[&#38913;&#38754;&#27161;&#38988;]", "&amp;[&#26085;&#26399;]", "&amp;[&#26102;&#38388;]", "&amp;[&#25991;&#20214;&#21517;]", "&amp;[&#38913;]", "&amp;[&#26631;&#39064;1]", "&amp;[&#26631;&#39064;2]", "&amp;[&#26631;&#39064;3]", "&amp;[&#26631;&#39064;4]"};
    private static final String[] zh_CN_unicodes = new String[]{"&amp;[&#39029;&#38754;&#26631;&#39064;]", "&amp;[&#26085;&#26399;]", "&amp;[&#26102;&#38388;]", "&amp;[&#25991;&#20214;&#21517;]", "&amp;[&#39029;&#38754;]", "&amp;[&#26631;&#39064;1]", "&amp;[&#26631;&#39064;2]", "&amp;[&#26631;&#39064;3]", "&amp;[&#26631;&#39064;4]"};
    private static final String[] ko_unicodes = new String[]{"&amp;[&#54168;&#51060;&#51648; &#51228;&#47785;]", "&amp;[&#45216;&#51676;]", "&amp;[&#49884;&#44036;]", "&amp;[&#54168;&#51060;&#51648;]", "&amp;[&#54028;&#51068; &#51060;&#47492;]", "&amp;[&#54756;&#46300;1]", "&amp;[&#54756;&#46300;2]", "&amp;[&#54756;&#46300;3]", "&amp;[&#54756;&#46300;4]"};
    private static final String[] de_header_unicodes = new String[]{"&amp;[&#220;berschrift1]", "&amp;[&#220;berschrift2]", "&amp;[&#220;berschrift3]", "&amp;[&#220;berschrift4]"};
    private static final String[] fr_header_unicodes = new String[]{"&amp;[EnT&#234;te1]", "&amp;[EnT&#234;te2]", "&amp;[EnT&#234;te3]", "&amp;[EnT&#234;te4]"};

    public HeaderFooterTab(BaseDialog baseDialog, boolean bl) {
        super(baseDialog, bl);
        for (int i = 0; i < sAsciiChas.length; ++i) {
            char[] cArray = new char[]{sAsciiChas[i]};
            this.mAsciiCodesTable.put(sAscii_codes[i], new String(cArray));
        }
        this.doubleByteEncoding.put("ja", Ja_unicodes);
        this.doubleByteEncoding.put("zh_CN", zh_CN_unicodes);
        this.doubleByteEncoding.put("zh_TW", tw_CN_unicodes);
        this.doubleByteEncoding.put("ko", ko_unicodes);
        this.mAccentcodeTable.put("de", de_header_unicodes);
        this.mAccentcodeTable.put("fr", fr_header_unicodes);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (HeaderFooterTab.this.isDisplayable()) {
                    HeaderFooterTab.this.loadHeaderFooter();
                    HeaderFooterTab.this.mHeaderTextPane.selectAll();
                    HeaderFooterTab.this.mFooterTextPane.selectAll();
                    HeaderFooterTab.this.mFooterTextPane.setCaretPosition(0);
                }
            }
        });
    }

    @Override
    public void initPanel() {
        super.initPanel();
        this.initVars();
        this.setDefaults();
        this.mHeaderTextPane.addCaretListener(this);
        this.mFooterTextPane.addCaretListener(this);
        Dimension dimension = new Dimension(450, 150);
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        int n3 = DialogUtil.getComponentGroupGap();
        JPanel jPanel = this.setupHeaderPanel();
        jPanel.setPreferredSize(dimension);
        JPanel jPanel2 = this.setupToolBarPanel();
        JPanel jPanel3 = this.setupFooterPanel();
        jPanel3.setPreferredSize(dimension);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.fill = 1;
        this.mInsets.set(n2, n2, 0, n2);
        DialogUtil.addUsingGBL(this, jPanel, this.mConstraints, 0, 0, 1, 1, n, this.mInsets);
        this.mInsets.set(n3, n2, 0, n2);
        this.mConstraints.fill = 2;
        this.mConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this, jPanel2, this.mConstraints, 0, 1, 1, 1, n, this.mInsets);
        this.mConstraints.fill = 1;
        this.mConstraints.weighty = 1.0;
        this.mInsets.set(n3, n2, n2, n2);
        DialogUtil.addUsingGBL(this, jPanel3, this.mConstraints, 0, 2, 1, 1, n, this.mInsets);
        this.setTabTraversal();
        this.mOriginalBorder = this.mLeftAlignButton.getBorder();
    }

    public void loadHeaderFooter() {
        String string;
        String string2;
        IPageSetupInfo iPageSetupInfo = ((PageAttributesDlg)this.mParent).getPageSetupInfo();
        if (iPageSetupInfo != null) {
            string2 = iPageSetupInfo.getHeaderHTML();
            string = iPageSetupInfo.getFootnoteHTML();
            string2 = string2.equals("") ? PageAttributes.getPrefPageHeader() : OutputViewPrintable.deleteHeadElement(string2);
            string = string.equals("") ? PageAttributes.getPrefPageFooter() : OutputViewPrintable.deleteHeadElement(string);
        } else {
            string2 = PageAttributes.getPrefPageHeader();
            string = PageAttributes.getPrefPageFooter();
        }
        string2 = this.replaceKeyString(string2, false);
        string = this.replaceKeyString(string, false);
        this.loadDataToPanes(string2, string);
        this.mHeaderDocument.addUndoableEditListener(this.mHeaderUndoHandler);
        this.mHeaderDocument.addDocumentListener(this.mHeaderDocListener);
        this.mHeaderTextPane.setDocument(this.mHeaderDocument);
        this.mHeaderUndoHandler.clean();
        this.mFooterDocument.addUndoableEditListener(this.mFooterUndoHandler);
        this.mFooterDocument.addDocumentListener(this.mFooterDocListener);
        this.mFooterTextPane.setDocument(this.mFooterDocument);
        this.mFooterUndoHandler.clean();
        this.initAlignment(this.mFooterTextPane);
        this.initAlignment(this.mHeaderTextPane);
        this.mHeaderTextPane.selectAll();
    }

    public void savePrefs(IPageSetupInfo iPageSetupInfo) {
        ComponentState.trace1((String)("header===>" + this.mHeaderTextPane.getText()), (int)15);
        ComponentState.trace1((String)("footer===>" + this.mFooterTextPane.getText()), (int)15);
        PageAttributes.setPrefPageHeader((String)iPageSetupInfo.getHeaderHTML());
        PageAttributes.setPrefPageFooter((String)iPageSetupInfo.getFootnoteHTML());
    }

    public void saveChanges(IPageSetupInfo iPageSetupInfo) {
        ComponentState.trace1((String)("header===>" + this.mHeaderTextPane.getText()), (int)15);
        ComponentState.trace1((String)("footer===>" + this.mFooterTextPane.getText()), (int)15);
        String string = this.replaceString(this.mHeaderTextPane);
        iPageSetupInfo.setHeaderHTML(this.replaceKeyString(string, true));
        iPageSetupInfo.setModified(true);
        string = this.replaceString(this.mFooterTextPane);
        iPageSetupInfo.setFootnoteHTML(this.replaceKeyString(string, true));
    }

    @Override
    public String getDialogHelpID() {
        return "idh_pgsp_hf";
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        this.setAlignmentButtonBorder(this.mLastFocusedPane);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getSource() instanceof JTextPane && keyEvent.getKeyCode() == 32) {
            int n = ((JTextPane)keyEvent.getSource()).getCaretPosition();
            ((JTextPane)keyEvent.getSource()).select(n - 1, n);
            ((JTextPane)keyEvent.getSource()).replaceSelection("\u00a0");
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.mLastFocusedPane = (JTextPane)focusEvent.getComponent();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    protected void aboutToShowTab() {
        this.mHeaderTextPane.requestFocusInWindow();
    }

    private void loadDataToPanes(String string, String string2) {
        Document document = this.mHeaderTextPane.getDocument();
        if (document != null) {
            document.removeUndoableEditListener(this.mHeaderUndoHandler);
        }
        HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
        this.mHeaderDocument = (HTMLDocument)hTMLEditorKit.createDefaultDocument();
        Document document2 = this.mFooterTextPane.getDocument();
        if (document2 != null) {
            document2.removeUndoableEditListener(this.mFooterUndoHandler);
        }
        HTMLEditorKit hTMLEditorKit2 = new HTMLEditorKit();
        this.mFooterDocument = (HTMLDocument)hTMLEditorKit2.createDefaultDocument();
        StringReader stringReader = new StringReader(string);
        StringReader stringReader2 = new StringReader(string2);
        try {
            hTMLEditorKit.read(stringReader, (Document)this.mHeaderDocument, 0);
            hTMLEditorKit2.read(stringReader2, (Document)this.mFooterDocument, 0);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    private void initVars() {
        HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
        this.mHeaderDocument = (HTMLDocument)hTMLEditorKit.createDefaultDocument();
        this.mHeaderDocListener = new PaneDocumentListener();
        this.mHeaderUndoHandler = new UndoHandler(this.mHeaderDocListener);
        this.mHeaderDocument.addUndoableEditListener(this.mHeaderUndoHandler);
        this.mHeaderDocument.addDocumentListener(this.mHeaderDocListener);
        this.mHeaderTextPane = new JTextPane(this.mHeaderDocument);
        this.mHeaderTextPane.setContentType("text/html");
        this.mHeaderTextPane.addFocusListener(this);
        this.mHeaderTextPane.setFocusTraversalKeys(0, null);
        this.mHeaderTextPane.setFocusTraversalKeys(1, null);
        this.mHeaderTextPane.addKeyListener(this);
        Keymap keymap = JTextComponent.addKeymap("HeaderTextKeyMap", this.mHeaderTextPane.getKeymap());
        this.mHeaderTextPane.setKeymap(keymap);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        keymap.addActionForKeyStroke(keyStroke, new UndoAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeaderFooterTab.this.mHeaderUndoHandler.doUndo(actionEvent);
            }
        });
        keyStroke = KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        keymap.addActionForKeyStroke(keyStroke, new RedoAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeaderFooterTab.this.mHeaderUndoHandler.doRedo(actionEvent);
            }
        });
        this.mHeaderScrollPane = new JScrollPane(this.mHeaderTextPane, 21, 31);
        HTMLEditorKit hTMLEditorKit2 = new HTMLEditorKit();
        this.mFooterDocument = (HTMLDocument)hTMLEditorKit2.createDefaultDocument();
        this.mFooterDocListener = new PaneDocumentListener();
        this.mFooterUndoHandler = new UndoHandler(this.mFooterDocListener);
        this.mFooterDocument.addUndoableEditListener(this.mFooterUndoHandler);
        this.mFooterDocument.addDocumentListener(this.mFooterDocListener);
        this.mFooterTextPane = new JTextPane(this.mFooterDocument);
        this.mFooterTextPane.setContentType("text/html");
        this.mFooterTextPane.addFocusListener(this);
        this.mFooterTextPane.setFocusTraversalKeys(0, null);
        this.mFooterTextPane.setFocusTraversalKeys(1, null);
        this.mFooterTextPane.addKeyListener(this);
        Keymap keymap2 = JTextComponent.addKeymap("FooterTextKeyMap", this.mFooterTextPane.getKeymap());
        this.mFooterTextPane.setKeymap(keymap2);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        keymap2.addActionForKeyStroke(keyStroke2, new UndoAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeaderFooterTab.this.mFooterUndoHandler.doUndo(actionEvent);
            }
        });
        keyStroke2 = KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        keymap2.addActionForKeyStroke(keyStroke2, new RedoAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeaderFooterTab.this.mFooterUndoHandler.doRedo(actionEvent);
            }
        });
        this.mFooterScrollPane = new JScrollPane(this.mFooterTextPane, 21, 31);
        this.mConstraints = new GridBagConstraints();
        this.mInsets = new Insets(0, 0, 0, 0);
    }

    private void setDefaults() {
        this.mHeaderTextPane.setFont(new Font("Sans Serif", 0, 10));
        this.mLastFocusedPane = this.mHeaderTextPane;
    }

    private void setTabTraversal() {
        Component[] componentArray;
        this.addToComponentOrder(this.mHeaderTextPane);
        this.addToComponentOrder(this.mFont);
        this.addToComponentOrder(this.mLeftAlignButton);
        this.addToComponentOrder(this.mCenterAlignButton);
        this.addToComponentOrder(this.mRightAlignButton);
        this.addToComponentOrder(this.mDate);
        this.addToComponentOrder(this.mTime);
        this.addToComponentOrder(this.mPageNumber);
        this.addToComponentOrder(this.mFileName);
        this.addToComponentOrder(this.mPageTitle);
        this.addToComponentOrder(this.mHeading1);
        this.addToComponentOrder(this.mHeading2);
        this.addToComponentOrder(this.mHeading3);
        this.addToComponentOrder(this.mHeading4);
        this.addToComponentOrder(this.mFooterTextPane);
        JPanel jPanel = ((PageAttributesDlg)this.mParent).getCmdButtonPanel();
        for (Component component : componentArray = jPanel.getComponents()) {
            this.addToComponentOrder(component);
        }
    }

    private JPanel setupHeaderPanel() {
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_PAGESETUP_HEADER_TAB_HEADER_LABEL")));
        String string = this.getResString("IDS_PAGESETUP_HEADER_TAB_TOP_PAGE_MARGIN_LABEL");
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            string = string.substring(14, string.length() - 14);
        } else if (OSInfo.getOSType() == OSInfo.OSType.LINUX) {
            string = string.substring(5, string.length() - 5);
        }
        JLabel jLabel = new JLabel(string);
        jLabel.setEnabled(false);
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = 23;
        this.mConstraints.weightx = 1.0;
        this.mInsets.set(n, n, 0, n);
        DialogUtil.addUsingGBL(jPanel, jLabel, this.mConstraints, 0, 0, 1, 1, 19, this.mInsets);
        this.mConstraints.weighty = 1.0;
        this.mInsets.set(insets.top, n, n, n);
        this.mConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mHeaderScrollPane, this.mConstraints, 0, 1, 1, 1, n2, this.mInsets);
        return jPanel;
    }

    private JPanel setupToolBarPanel() {
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        int n = 19;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(""));
        JToolBar jToolBar = new JToolBar();
        this.mDate = this.createButtonsForToolBar("IDS_PAGESETUP_HEADER_TAB_DATE_IMAGE", "IDS_PAGESETUP_HEADER_TAB_DATE_TOOLTIP", ButtonNames.DATE);
        this.mTime = this.createButtonsForToolBar("IDS_PAGESETUP_HEADER_TAB_TIME_IMAGE", "IDS_PAGESETUP_HEADER_TAB_TIME_TOOLTIP", ButtonNames.TIME);
        this.mFileName = this.createButtonsForToolBar("IDS_PAGESETUP_HEADER_TAB_FILENAME_IMAGE", "IDS_PAGESETUP_HEADER_TAB_FILENAME_TOOLTIP", ButtonNames.FILE_NAME);
        this.mPageNumber = this.createButtonsForToolBar("IDS_PAGESETUP_HEADER_TAB_PAGENUMBER_IMAGE", "IDS_PAGESETUP_HEADER_TAB_PAGENUMBER_TOOLTIP", ButtonNames.PAGE_NUMBER);
        this.mHeading1 = this.createButtonsForToolBar("IDS_PAGESETUP_HEADER_TAB_HEADING1_IMAGE", "IDS_PAGESETUP_HEADER_TAB_HEADING1_TOOLTIP", ButtonNames.HEAD1);
        this.mHeading2 = this.createButtonsForToolBar("IDS_PAGESETUP_HEADER_TAB_HEADING2_IMAGE", "IDS_PAGESETUP_HEADER_TAB_HEADING2_TOOLTIP", ButtonNames.HEAD2);
        this.mHeading3 = this.createButtonsForToolBar("IDS_PAGESETUP_HEADER_TAB_HEADING3_IMAGE", "IDS_PAGESETUP_HEADER_TAB_HEADING3_TOOLTIP", ButtonNames.HEAD3);
        this.mHeading4 = this.createButtonsForToolBar("IDS_PAGESETUP_HEADER_TAB_HEADING4_IMAGE", "IDS_PAGESETUP_HEADER_TAB_HEADING4_TOOLTIP", ButtonNames.HEAD4);
        this.mFont = this.createButtonsForToolBar("IDS_PAGESETUP_HEADER_TAB_FONT_IMAGE", "IDS_PAGESETUP_HEADER_TAB_FONT_TOOLTIP", ButtonNames.FONT);
        this.mLeftAlignButton = this.createButtonsForToolBar("IDS_PAGESETUP_HEADER_TAB_ALIGN_LEFT_IMAGE", "IDS_PAGESETUP_HEADER_TAB_ALIGN_LEFT_TOOLTIP", ButtonNames.LEFT_ALIGN);
        this.mRightAlignButton = this.createButtonsForToolBar("IDS_PAGESETUP_HEADER_TAB_ALIGN_RIGHT_IMAGE", "IDS_PAGESETUP_HEADER_TAB_ALIGN_RIGHT_TOOLTIP", ButtonNames.RIGHT_ALIGN);
        this.mCenterAlignButton = this.createButtonsForToolBar("IDS_PAGESETUP_HEADER_TAB_ALIGN_CENTER_IMAGE", "IDS_PAGESETUP_HEADER_TAB_ALIGN_CENTER_TOOLTIP", ButtonNames.CENTER);
        this.mPageTitle = this.createButtonsForToolBar("IDS_PAGESETUP_HEADER_TAB_PAGETITLE_IMAGE", "IDS_PAGESETUP_HEADER_TAB_PAGETITLE_TOOLTIP", ButtonNames.PAGE_TITLE);
        jToolBar.add(this.mFont);
        jToolBar.add(this.mLeftAlignButton);
        jToolBar.add(this.mCenterAlignButton);
        jToolBar.add(this.mRightAlignButton);
        jToolBar.add(this.mDate);
        jToolBar.add(this.mTime);
        jToolBar.add(this.mPageNumber);
        jToolBar.add(this.mFileName);
        jToolBar.add(this.mPageTitle);
        jToolBar.add(this.mHeading1);
        jToolBar.add(this.mHeading2);
        jToolBar.add(this.mHeading3);
        jToolBar.add(this.mHeading4);
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        this.mInsets.set(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, jToolBar, this.mConstraints, 0, 0, 1, 1, n, this.mInsets);
        return jPanel;
    }

    private JPanel setupFooterPanel() {
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_PAGESETUP_HEADER_TAB_FOOTER_LABEL")));
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = 23;
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 1.0;
        this.mInsets.set(n, n, 0, n);
        this.mConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mFooterScrollPane, this.mConstraints, 0, 0, 1, 1, n2, this.mInsets);
        String string = this.getResString("IDS_PAGESETUP_HEADER_TAB_BOTTOM_PAGE_MARGIN_LABEL");
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            string = string.substring(14, string.length() - 14);
        } else if (OSInfo.getOSType() == OSInfo.OSType.LINUX) {
            string = string.substring(5, string.length() - 5);
        }
        JLabel jLabel = new JLabel(string);
        jLabel.setEnabled(false);
        this.mConstraints.weighty = 0.0;
        this.mConstraints.fill = 0;
        this.mInsets.set(insets.top, n, n, n);
        DialogUtil.addUsingGBL(jPanel, jLabel, this.mConstraints, 0, 1, 1, 1, 19, this.mInsets);
        return jPanel;
    }

    private JButton createButtonsForToolBar(String string, String string2, ButtonNames buttonNames) {
        URL uRL = this.getResImageURL(string);
        ImageIcon imageIcon = new ImageIcon(uRL);
        JButton jButton = new JButton();
        if (buttonNames == ButtonNames.LEFT_ALIGN) {
            jButton.setAction(new TextPaneAlignAction("", 0));
        } else if (buttonNames == ButtonNames.CENTER) {
            jButton.setAction(new TextPaneAlignAction("", 1));
        } else if (buttonNames == ButtonNames.RIGHT_ALIGN) {
            jButton.setAction(new TextPaneAlignAction("", 2));
        } else if (buttonNames == ButtonNames.FONT) {
            jButton.setAction(new FontStyleAction(""));
        } else {
            jButton.setAction(new InsertStringAction());
        }
        jButton.setIcon(imageIcon);
        jButton.getAction().putValue("ActionCommandKey", buttonNames.name());
        jButton.setToolTipText(this.getResString(string2));
        return jButton;
    }

    private void setAlignmentButtonBorder(JTextPane jTextPane) {
        Element element = jTextPane.getStyledDocument().getParagraphElement(jTextPane.getCaretPosition());
        if (element == null) {
            return;
        }
        MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)element.getAttributes();
        if (mutableAttributeSet == null) {
            return;
        }
        Object object = mutableAttributeSet.getAttribute(StyleConstants.Alignment);
        if (object == null) {
            this.setResetBorder(100, jTextPane == this.mHeaderTextPane);
            return;
        }
        int n = (Integer)object;
        this.setResetBorder(n, jTextPane == this.mHeaderTextPane);
    }

    private void setResetBorder(int n, boolean bl) {
        switch (n) {
            case 0: {
                this.mLeftAlignButton.setBorder(BorderFactory.createLineBorder(Color.BLACK));
                this.mCenterAlignButton.setBorder(this.mOriginalBorder);
                this.mRightAlignButton.setBorder(this.mOriginalBorder);
                break;
            }
            case 1: {
                this.mCenterAlignButton.setBorder(BorderFactory.createLineBorder(Color.BLACK));
                this.mLeftAlignButton.setBorder(this.mOriginalBorder);
                this.mRightAlignButton.setBorder(this.mOriginalBorder);
                break;
            }
            case 2: {
                this.mRightAlignButton.setBorder(BorderFactory.createLineBorder(Color.BLACK));
                this.mCenterAlignButton.setBorder(this.mOriginalBorder);
                this.mLeftAlignButton.setBorder(this.mOriginalBorder);
                break;
            }
            default: {
                this.mRightAlignButton.setBorder(this.mOriginalBorder);
                this.mCenterAlignButton.setBorder(this.mOriginalBorder);
                this.mLeftAlignButton.setBorder(this.mOriginalBorder);
            }
        }
    }

    public static String getAlignmentString(String string, int n) {
        String string2 = string;
        StringBuffer stringBuffer = new StringBuffer("align=\"");
        String string3 = "\"";
        String string4 = "";
        switch (n) {
            case 0: {
                string4 = stringBuffer.append("left").append(string3).toString();
                break;
            }
            case 1: {
                string4 = stringBuffer.append("center").append(string3).toString();
                break;
            }
            case 2: {
                string4 = stringBuffer.append("right").append(string3).toString();
            }
        }
        if (string4.length() > 0) {
            string2 = string2.indexOf("align=\"right\"") >= 0 ? string2.replace("align=\"right\"", string4) : (string2.indexOf("align=\"left\"") >= 0 ? string2.replace("align=\"left\"", string4) : string2.replace("align=\"center\"", string4));
        }
        return string2;
    }

    public float getFontSize(String string) {
        float f = -1.0f;
        try {
            int n = Integer.parseInt(string) - 2;
            if (n < this.physicalSizes.length && n >= 0) {
                f = this.physicalSizes[n];
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return f;
    }

    private String replaceKeyString(String string, boolean bl) {
        String string2 = UIToolResUtil.getLocale().toString();
        String string3 = string;
        if (bl) {
            for (int i = 0; i < this.mAsciiCodesTable.size(); ++i) {
                string3 = string3.replaceAll(sAscii_codes[i], this.mAsciiCodesTable.get(sAscii_codes[i]));
            }
        }
        StringBuffer stringBuffer = null;
        int n = 0;
        for (n = 0; n < ENGLISH_KEY_STRING.length; ++n) {
            int n2;
            int n3;
            String string4 = ENGLISH_KEY_STRING[n];
            String string5 = this.LOCALIZED_KEY_STRING[n];
            String string6 = ENGLISH_KEY_STRING_AMP[n];
            String string7 = this.LOCALIZED_KEY_STRING_AMP[n];
            if (bl) {
                String[] stringArray;
                n3 = string3.indexOf(string5);
                stringBuffer = new StringBuffer(string3);
                if (n3 >= 0) {
                    n2 = string5.length();
                    string3 = stringBuffer.replace(n3, n3 + n2, string4).toString();
                }
                if ((n3 = string3.indexOf(string7)) >= 0) {
                    n2 = string7.length();
                    string3 = stringBuffer.replace(n3, n3 + n2, string6).toString();
                }
                if (n3 >= 0) continue;
                n2 = -1;
                String[] stringArray2 = this.doubleByteEncoding.get(string2);
                if (stringArray2 != null && (n3 = string3.indexOf(stringArray2[n])) > 0) {
                    n2 = stringArray2[n].length();
                    string3 = stringBuffer.replace(n3, n3 + n2, string4).toString();
                    continue;
                }
                if (n <= 4 || !string2.equals("de") && !string2.equals("fr") || (stringArray = this.mAccentcodeTable.get(string2)) == null || (n3 = string3.indexOf(stringArray[n - 5])) < 0) continue;
                n2 = stringArray[n - 5].length();
                string3 = stringBuffer.replace(n3, n3 + n2, string4).toString();
                continue;
            }
            n3 = string3.indexOf(string4);
            if (n3 >= 0) {
                n2 = string4.length();
                stringBuffer = new StringBuffer(string3);
                string3 = stringBuffer.replace(n3, n3 + n2, string5).toString();
            }
            if ((n3 = string3.indexOf(string6)) < 0) continue;
            n2 = string6.length();
            stringBuffer = new StringBuffer(string3);
            string3 = stringBuffer.replace(n3, n3 + n2, string7).toString();
        }
        return string3;
    }

    private String replaceAmp(String string) {
        return string.replaceAll("&", "&amp;");
    }

    private void initAlignment(JTextPane jTextPane) {
        Element element = jTextPane.getStyledDocument().getParagraphElement(0);
        if (element == null) {
            return;
        }
        MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)element.getAttributes();
        if (mutableAttributeSet == null) {
            return;
        }
        if (jTextPane == this.mHeaderTextPane) {
            this.mLastHeaderAlignment = StyleConstants.getAlignment(mutableAttributeSet);
        } else {
            this.mLastFooterAlignment = StyleConstants.getAlignment(mutableAttributeSet);
        }
    }

    private String replaceString(JTextPane jTextPane) {
        StringBuffer stringBuffer = new StringBuffer(jTextPane.getText());
        HTMLDocument hTMLDocument = (HTMLDocument)jTextPane.getStyledDocument();
        int n = hTMLDocument.getLength();
        int n2 = stringBuffer.indexOf("<p");
        int n3 = stringBuffer.indexOf("</p>");
        if (n == 0 || n2 < 0 || n3 < 0) {
            return stringBuffer.toString();
        }
        while (n2 > 0 && n3 > 0) {
            String string = stringBuffer.substring(n2, n3);
            String string2 = "align=\"";
            int n4 = string.indexOf(string2);
            int n5 = string.indexOf("\"", n4 + string2.length());
            if (n4 > 0 && n5 > 0) {
                String string3;
                String string4 = string.substring(n4 + string2.length(), n5);
                StringBuffer stringBuffer2 = new StringBuffer(string).replace(n4, n5 + 1, "");
                int n6 = stringBuffer2.indexOf(string3 = "style=\"");
                if (n6 > 0) {
                    stringBuffer2.insert(n6 + string3.length(), "text-align:" + string4 + "; ");
                    stringBuffer = stringBuffer.replace(n2, n3, stringBuffer2.toString());
                }
            }
            if ((n2 = stringBuffer.indexOf("<p", n3 + 5)) < 0) break;
            n3 = stringBuffer.indexOf("</p>", n2);
        }
        return stringBuffer.toString();
    }

    abstract class RedoAction
    extends AbstractAction {
        RedoAction() {
        }
    }

    abstract class UndoAction
    extends AbstractAction {
        UndoAction() {
        }
    }

    class PaneDocumentListener
    implements DocumentListener {
        private boolean mIsInsertRemove;

        PaneDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.mIsInsertRemove = true;
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.mIsInsertRemove = true;
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.mIsInsertRemove = false;
        }

        public boolean isInsertRemove() {
            return this.mIsInsertRemove;
        }

        public void resetInsertRemove() {
            this.mIsInsertRemove = false;
        }
    }

    class UndoHandler
    implements UndoableEditListener {
        private CompoundEdit mCompoundEdit;
        private DocumentListener mListener;
        private UndoManager mUndoManager = new UndoManager();

        UndoHandler(DocumentListener documentListener) {
            this.mListener = documentListener;
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            if (((PaneDocumentListener)this.mListener).isInsertRemove() && this.mCompoundEdit == null) {
                this.mCompoundEdit = new CompoundEdit();
                this.mUndoManager.addEdit(this.mCompoundEdit);
            }
            this.mUndoManager.addEdit(undoableEditEvent.getEdit());
        }

        public void doUndo(ActionEvent actionEvent) {
            this.endCompoundEdit();
            if (this.mUndoManager.canUndo()) {
                this.mUndoManager.undo();
            }
        }

        public void doRedo(ActionEvent actionEvent) {
            this.endCompoundEdit();
            if (this.mUndoManager.canRedo()) {
                this.mUndoManager.redo();
            }
        }

        public void endCompoundEdit() {
            if (this.mCompoundEdit != null) {
                this.mCompoundEdit.end();
            }
            this.mCompoundEdit = null;
        }

        public void clean() {
            this.mUndoManager.die();
            ((PaneDocumentListener)this.mListener).resetInsertRemove();
        }
    }

    private static enum ButtonNames {
        FONT(""),
        LEFT_ALIGN(""),
        CENTER(""),
        RIGHT_ALIGN(""),
        DATE("IDS_PAGESETUP_HEADER_TAB_DATE_INSERT_STRING"),
        TIME("IDS_PAGESETUP_HEADER_TAB_TIME_INSERT_STRING"),
        PAGE_NUMBER("IDS_PAGESETUP_HEADER_TAB_PAGENUMBER_INSERT_STRING"),
        PAGE_TITLE("IDS_PAGESETUP_HEADER_TAB_PAGE_TITLE_INSERT_STRING"),
        FILE_NAME("IDS_PAGESETUP_HEADER_TAB_FILENAME_INSERT_STRING"),
        HEAD1("IDS_PAGESETUP_HEADER_TAB_HEADING1_INSERT_STRING"),
        HEAD2("IDS_PAGESETUP_HEADER_TAB_HEADING2_INSERT_STRING"),
        HEAD3("IDS_PAGESETUP_HEADER_TAB_HEADING3_INSERT_STRING"),
        HEAD4("IDS_PAGESETUP_HEADER_TAB_HEADING4_INSERT_STRING");

        private final String mValue;

        private ButtonNames(String string2) {
            this.mValue = string2;
        }

        String getValue() {
            return this.mValue;
        }
    }

    private class InsertStringAction
    extends AbstractAction {
        private InsertStringAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            HeaderFooterTab.this.mLastFocusedPane.requestFocusInWindow();
            JButton jButton = (JButton)actionEvent.getSource();
            ButtonNames buttonNames = ButtonNames.valueOf(jButton.getActionCommand());
            String string = buttonNames.getValue();
            String string2 = ResUtil.getCommonDlgString(string);
            HeaderFooterTab.this.mLastFocusedPane.replaceSelection(string2);
        }
    }

    private class FontStyleAction
    extends StyledEditorKit.StyledTextAction {
        public FontStyleAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            if (HeaderFooterTab.this.mLastFocusedPane == null) {
                return;
            }
            HeaderFooterTab.this.mLastFocusedPane.requestFocusInWindow();
            int n = HeaderFooterTab.this.mLastFocusedPane.getSelectionStart();
            if (n < 0) {
                n = HeaderFooterTab.this.mLastFocusedPane.getCaretPosition();
            }
            Element element = HeaderFooterTab.this.mLastFocusedPane.getStyledDocument().getCharacterElement(n);
            String string = "SansSerif";
            int n2 = 12;
            int n3 = 0;
            Color color = Color.BLACK;
            boolean bl = false;
            boolean bl2 = false;
            int n4 = -1;
            if (element != null) {
                object4 = element.getAttributes();
                if (element instanceof HTMLDocument.RunElement) {
                    object3 = (HTMLDocument.RunElement)element;
                    object2 = ((AbstractDocument.AbstractElement)object3).getAttributeNames();
                    while (object2.hasMoreElements()) {
                        object = object2.nextElement();
                        if (!object.toString().equals("font-size")) continue;
                        n4 = (int)HeaderFooterTab.this.getFontSize(((AbstractDocument.AbstractElement)object3).getAttribute(object).toString());
                    }
                }
                string = StyleConstants.getFontFamily((AttributeSet)object4);
                n2 = n4 == -1 ? StyleConstants.getFontSize((AttributeSet)object4) : n4;
                n3 = StyleConstants.isBold((AttributeSet)object4) && StyleConstants.isItalic((AttributeSet)object4) ? 3 : (StyleConstants.isBold((AttributeSet)object4) ? 1 : (StyleConstants.isItalic((AttributeSet)object4) ? 2 : 0));
                color = StyleConstants.getForeground((AttributeSet)object4);
                bl = StyleConstants.isUnderline((AttributeSet)object4);
                bl2 = StyleConstants.isStrikeThrough((AttributeSet)object4);
            }
            object4 = new LinkedHashMap();
            ((HashMap)object4).put("IDS_COLOR_VALUE", color);
            ((HashMap)object4).put("IDS_UNDERLINE_VALUE", bl);
            ((HashMap)object4).put("IDS_STRIKE_VALUE", bl2);
            object3 = new SPSSFontChooser((JFrame)HeaderFooterTab.this.mParent.getParent(), true, string, n3, n2, true, true, (LinkedHashMap<String, Object>)object4, false);
            object2 = ((SPSSFontChooser)object3).getSelectedFont();
            if (object2 != null && ((SPSSFontChooser)object3).getReturnValue() == 0) {
                if (HeaderFooterTab.this.mLastFocusedPane == HeaderFooterTab.this.mHeaderTextPane) {
                    HeaderFooterTab.this.mHeaderAttr = new SimpleAttributeSet();
                    object = FontUtil.convertIndexToColor((int)((SPSSFontChooser)object3).getSelectedColorIndex());
                    StyleConstants.setForeground(HeaderFooterTab.this.mHeaderAttr, object);
                    StyleConstants.setUnderline(HeaderFooterTab.this.mHeaderAttr, ((SPSSFontChooser)object3).isUnderLine());
                    StyleConstants.setStrikeThrough(HeaderFooterTab.this.mHeaderAttr, ((SPSSFontChooser)object3).isStrikeThrough());
                    StyleConstants.setFontSize(HeaderFooterTab.this.mHeaderAttr, ((Font)object2).getSize());
                    StyleConstants.setFontFamily(HeaderFooterTab.this.mHeaderAttr, ((Font)object2).getFamily());
                    StyleConstants.setBold(HeaderFooterTab.this.mHeaderAttr, ((Font)object2).isBold());
                    StyleConstants.setItalic(HeaderFooterTab.this.mHeaderAttr, ((Font)object2).isItalic());
                    HeaderFooterTab.this.mHeaderTextPane.setCharacterAttributes(HeaderFooterTab.this.mHeaderAttr, false);
                } else {
                    HeaderFooterTab.this.mFooterAttr = new SimpleAttributeSet();
                    object = FontUtil.convertIndexToColor((int)((SPSSFontChooser)object3).getSelectedColorIndex());
                    StyleConstants.setForeground(HeaderFooterTab.this.mFooterAttr, object);
                    StyleConstants.setUnderline(HeaderFooterTab.this.mFooterAttr, ((SPSSFontChooser)object3).isUnderLine());
                    StyleConstants.setStrikeThrough(HeaderFooterTab.this.mFooterAttr, ((SPSSFontChooser)object3).isStrikeThrough());
                    StyleConstants.setFontSize(HeaderFooterTab.this.mFooterAttr, ((Font)object2).getSize());
                    StyleConstants.setFontFamily(HeaderFooterTab.this.mFooterAttr, ((Font)object2).getFamily());
                    StyleConstants.setBold(HeaderFooterTab.this.mFooterAttr, ((Font)object2).isBold());
                    StyleConstants.setItalic(HeaderFooterTab.this.mFooterAttr, ((Font)object2).isItalic());
                    HeaderFooterTab.this.mFooterTextPane.setCharacterAttributes(HeaderFooterTab.this.mFooterAttr, false);
                }
            }
        }
    }

    private class TextPaneAlignAction
    extends StyledEditorKit.AlignmentAction {
        private int align;

        public TextPaneAlignAction(String string, int n) {
            super(string, n);
            this.align = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (HeaderFooterTab.this.mLastFocusedPane == null) {
                return;
            }
            HeaderFooterTab.this.mLastFocusedPane.requestFocusInWindow();
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setAlignment(simpleAttributeSet, this.align);
            HeaderFooterTab.this.mLastFocusedPane.setParagraphAttributes(simpleAttributeSet, false);
            HeaderFooterTab.this.mLastFocusedPane.validate();
            HeaderFooterTab.this.mLastFocusedPane.repaint();
            ComponentState.trace1((String)("************ Alignment Changes *********\n" + HeaderFooterTab.this.mLastFocusedPane.getText()), (int)15);
            HeaderFooterTab.this.replaceString(HeaderFooterTab.this.mLastFocusedPane);
            if (HeaderFooterTab.this.mLastFocusedPane == HeaderFooterTab.this.mHeaderTextPane) {
                HeaderFooterTab.this.mLastHeaderAlignment = this.align;
                HeaderFooterTab.this.mHeaderAlignChanged = true;
            } else {
                HeaderFooterTab.this.mLastFooterAlignment = this.align;
                HeaderFooterTab.this.mFooterAlignChanged = true;
            }
            HeaderFooterTab.this.setResetBorder(this.align, HeaderFooterTab.this.mLastFocusedPane == HeaderFooterTab.this.mHeaderTextPane);
        }
    }
}

