/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.documents.output.output_export;

import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.documents.output.output_export.BaseExportDialog;
import com.spss.shared.export.IExportOptions;
import com.spss.uitools.util.IExportOptionConstants;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class WideTablesButtonGroup {
    private BaseExportDialog mParent;
    private JRadioButton mWrapRadio;
    private JRadioButton mShrinkRadio;
    private JRadioButton mExtendRadio;
    private SpssButtonGroup mWTButtonGroup;
    private JPanel mWTPanel;

    public WideTablesButtonGroup(BaseExportDialog baseExportDialog) {
        this.mParent = baseExportDialog;
        this.initVars();
    }

    public JPanel getPanel() {
        return this.mWTPanel;
    }

    public SpssButtonGroup getButtonGroup() {
        return this.mWTButtonGroup;
    }

    public String getSelectedOption() {
        if (this.mWrapRadio.isSelected()) {
            return IExportOptionConstants.WORD_WIDETABLE_VALUES[0];
        }
        if (this.mShrinkRadio.isSelected()) {
            return IExportOptionConstants.WORD_WIDETABLE_VALUES[1];
        }
        return IExportOptionConstants.WORD_WIDETABLE_VALUES[2];
    }

    public IExportOptions.WideTablesOptions getSelectedOptionMV() {
        if (this.mWrapRadio.isSelected()) {
            return IExportOptions.WideTablesOptions.WT_Wrap;
        }
        if (this.mShrinkRadio.isSelected()) {
            return IExportOptions.WideTablesOptions.WT_Shrink;
        }
        return IExportOptions.WideTablesOptions.WT_Extend;
    }

    public String getSelectedOptionUI() {
        if (this.mWrapRadio.isSelected()) {
            return this.mWrapRadio.getText();
        }
        if (this.mShrinkRadio.isSelected()) {
            return this.mShrinkRadio.getText();
        }
        return this.mExtendRadio.getText();
    }

    private void initVars() {
        this.mWrapRadio = new JRadioButton(new ToggleButtonAction(this.mParent, "IDS_EXPORTOUTPUT_WIDETABLE_WRAP_RADIO"));
        this.mShrinkRadio = new JRadioButton(new ToggleButtonAction(this.mParent, "IDS_EXPORTOUTPUT_WIDETABLE_SHRINK_RADIO"));
        this.mExtendRadio = new JRadioButton(new ToggleButtonAction(this.mParent, "IDS_EXPORTOUTPUT_WIDETABLE_EXTEND_RADIO"));
        this.mWTButtonGroup = new SpssButtonGroup();
        this.mWTButtonGroup.add(this.mWrapRadio);
        this.mWTButtonGroup.add(this.mShrinkRadio);
        this.mWTButtonGroup.add(this.mExtendRadio);
        this.mWrapRadio.setSelected(true);
        JComponent[] jComponentArray = new JComponent[]{this.mWrapRadio, this.mShrinkRadio, this.mExtendRadio};
        this.mWTPanel = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.mParent.getResString("IDS_EXPORTOUTPUT_WIDETABLE_GROUP_TITLE"));
    }
}

