/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.documents.output.output_export;

import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssMultiLineRadioButton;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.documents.output.output_export.BaseExportDialog;
import com.spss.shared.export.IExportOptions;
import com.spss.uitools.util.IExportOptionConstants;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ViewsOfModelsButtonGroup {
    private BaseExportDialog mParent;
    private JRadioButton mPrintSetRadio;
    private JRadioButton mAllViewsRadio;
    private JRadioButton mVisibleViewsRadio;
    private SpssButtonGroup mVMButtonGroup;
    private JPanel mVMPanel;
    int mMultiWidth;

    public ViewsOfModelsButtonGroup(BaseExportDialog baseExportDialog) {
        this.mParent = baseExportDialog;
        this.mMultiWidth = 0;
        this.initVars();
    }

    public ViewsOfModelsButtonGroup(BaseExportDialog baseExportDialog, int n) {
        this.mParent = baseExportDialog;
        this.mMultiWidth = n;
        this.initVars();
    }

    public JPanel getPanel() {
        return this.mVMPanel;
    }

    public SpssButtonGroup getButtonGroup() {
        return this.mVMButtonGroup;
    }

    public String getSelectedOption() {
        if (this.mPrintSetRadio.isSelected()) {
            return IExportOptionConstants.HTML_MODELVIEW_VALUES[0];
        }
        if (this.mAllViewsRadio.isSelected()) {
            return IExportOptionConstants.HTML_MODELVIEW_VALUES[1];
        }
        return IExportOptionConstants.HTML_MODELVIEW_VALUES[2];
    }

    public IExportOptions.ModelViewOptions getSelectedOptionMV() {
        if (this.mPrintSetRadio.isSelected()) {
            return IExportOptions.ModelViewOptions.MVPrintSetting;
        }
        if (this.mAllViewsRadio.isSelected()) {
            return IExportOptions.ModelViewOptions.MVExportAll;
        }
        return IExportOptions.ModelViewOptions.MVExportVisible;
    }

    public String getSelectedOptionUI() {
        if (this.mPrintSetRadio.isSelected()) {
            return this.mParent.getResString("IDS_EXPORTOUTPUT_MODEL_PRINT_SET_RADIO");
        }
        if (this.mAllViewsRadio.isSelected()) {
            return this.mAllViewsRadio.getText();
        }
        return this.mVisibleViewsRadio.getText();
    }

    public void setRadioButtonSize() {
        if (this.mMultiWidth > 0) {
            this.mPrintSetRadio.setMinimumSize(new Dimension(this.mMultiWidth, this.mAllViewsRadio.getPreferredSize().height * 2));
            this.mPrintSetRadio.setPreferredSize(new Dimension(this.mMultiWidth, this.mAllViewsRadio.getPreferredSize().height * 2));
        }
    }

    private void initVars() {
        this.mPrintSetRadio = this.mMultiWidth > 0 ? new SpssMultiLineRadioButton(new ToggleButtonAction(this.mParent, "IDS_EXPORTOUTPUT_MODEL_PRINT_SET_RADIO"), this.mMultiWidth) : new JRadioButton(new ToggleButtonAction(this.mParent, "IDS_EXPORTOUTPUT_MODEL_PRINT_SET_RADIO"));
        this.mAllViewsRadio = new JRadioButton(new ToggleButtonAction(this.mParent, "IDS_EXPORTOUTPUT_MODEL_ALL_RADIO"));
        this.mVisibleViewsRadio = new JRadioButton(new ToggleButtonAction(this.mParent, "IDS_EXPORTOUTPUT_MODEL_VISIBLE_RADIO"));
        this.mVMButtonGroup = new SpssButtonGroup();
        this.mVMButtonGroup.add(this.mPrintSetRadio);
        this.mVMButtonGroup.add(this.mAllViewsRadio);
        this.mVMButtonGroup.add(this.mVisibleViewsRadio);
        this.mPrintSetRadio.setSelected(true);
        JComponent[] jComponentArray = new JComponent[]{this.mPrintSetRadio, this.mAllViewsRadio, this.mVisibleViewsRadio};
        this.mVMPanel = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.mParent.getResString("IDS_EXPORTOUTPUT_MODEL_GROUP_TITLE"));
        this.setRadioButtonSize();
    }
}

