/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.documents.output.output_export;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.dialogs.documents.output.output_export.BaseExportDialog;
import com.spss.java_client.ui.dialogs.documents.output.output_export.ExportOutputDlg;
import com.spss.shared.export.IExportOptions;
import com.spss.shared.export.TextDocumentExportOptions;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;

public class ExportOutputWebReportOptions
extends BaseExportDialog
implements ItemListener,
DocumentListener,
ListSelectionListener {
    public static final int TEXT = 0;
    public static final int LOGS = 1;
    public static final int NOTES = 2;
    public static final int WARNINGS = 3;
    private static final String CHECKSERVER_APPEND = "/CheckServer";
    private ExportOutputDlg mParent;
    private JRadioButton mFilenameRadio;
    private JRadioButton mCustomRadio;
    private JLabel mTitleLabel;
    private StringTextField mTitleEdit;
    private JRadioButton mSpssWebReportRadio;
    private JRadioButton mCognoReportRadio;
    private JCheckBox[] mExcludeChecks;
    private JCheckBox mRestyleCheck;
    private PlainTable mServersTable;
    private JButton mUpButton;
    private JButton mDownButton;
    private JButton mValidateButton;
    private JButton mDeleteButton;
    private SpssButtonGroup mTitleButtonGroup;
    private SpssButtonGroup mFormatButtonGroup;

    public ExportOutputWebReportOptions(ExportOutputDlg exportOutputDlg, String string, boolean bl) {
        super(exportOutputDlg, string, bl, false, CommonDlgResBundle.getDefaultResourceBundleName(), CommonDlgResBundle.getImageFolder());
        this.mParent = exportOutputDlg;
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_exp_web_export_options";
    }

    @Override
    public String getPreferenceName() {
        return "web_report_options";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getItem();
        if (object == this.mFilenameRadio || object == this.mCustomRadio) {
            this.mTitleEdit.setEnabled(this.mCustomRadio.isSelected());
            this.enableContinue(!this.mCustomRadio.isSelected() || this.mTitleEdit.getText().length() > 0);
        } else if (object == this.mCognoReportRadio) {
            this.enableServerConnControls(!this.mCognoReportRadio.isSelected());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableContinue(!this.mCustomRadio.isSelected() || this.mTitleEdit.getText().length() > 0);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableContinue(!this.mCustomRadio.isSelected() || this.mTitleEdit.getText().length() > 0);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableContinue(!this.mCustomRadio.isSelected() || this.mTitleEdit.getText().length() > 0);
    }

    @Override
    public boolean okContinuePressed() {
        return true;
    }

    @Override
    public HashMap<Object, Object> getPreferenceValues() {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        hashMap.put("web_report_custom_title_key", this.mTitleEdit.isEnabled() ? this.mTitleEdit.getText() : "No");
        hashMap.put("web_report_spss_format_key", this.mSpssWebReportRadio.isSelected());
        hashMap.put("web_report_text_key", this.mExcludeChecks[0].isSelected());
        hashMap.put("web_report_logs_key", this.mExcludeChecks[1].isSelected());
        hashMap.put("web_report_notes_key", this.mExcludeChecks[2].isSelected());
        hashMap.put("web_report_warnings_key", this.mExcludeChecks[3].isSelected());
        hashMap.put("web_report_restyle_key", this.mRestyleCheck.isSelected());
        hashMap.put("web_report_servers_key", this.getStringRepresentationForServers());
        return hashMap;
    }

    @Override
    public HashMap<Object, Object> getValuesToLoadSubDlg() {
        return this.mParent.getWebReportUIMap();
    }

    @Override
    public void loadStateFromPref(HashMap hashMap) {
        String[] stringArray;
        String string;
        Set set = hashMap.keySet();
        Iterator iterator = set.iterator();
        String string2 = "Yes";
        while (iterator.hasNext()) {
            string = iterator.next().toString();
            stringArray = hashMap.get(string).toString();
            if (string.equals("web_report_custom_title_key")) {
                boolean bl = !stringArray.equals("No");
                DialogUtil.setSelectedButton(this.mTitleButtonGroup, bl ? 1 : 0);
                if (!bl) continue;
                this.mTitleEdit.setText((String)stringArray);
                continue;
            }
            if (string.equals("web_report_spss_format_key")) {
                DialogUtil.setSelectedButton(this.mFormatButtonGroup, stringArray.equals(string2) ? 0 : 1);
                continue;
            }
            if (string.equals("web_report_text_key")) {
                this.mExcludeChecks[0].setSelected(stringArray.equals(string2));
                continue;
            }
            if (string.equals("web_report_logs_key")) {
                this.mExcludeChecks[1].setSelected(stringArray.equals(string2));
                continue;
            }
            if (string.equals("web_report_notes_key")) {
                this.mExcludeChecks[2].setSelected(stringArray.equals(string2));
                continue;
            }
            if (string.equals("web_report_warnings_key")) {
                this.mExcludeChecks[3].setSelected(stringArray.equals(string2));
                continue;
            }
            if (!string.equals("web_report_restyle_key")) continue;
            this.mRestyleCheck.setSelected(stringArray.equals(string2));
        }
        string = (String)hashMap.get("web_report_servers_key");
        if (string != null && string.length() > 0) {
            for (String string3 : stringArray = string.split(";")) {
                Object[] objectArray = string3.split(",");
                ((DefaultTableModel)this.mServersTable.getModel()).addRow(objectArray);
            }
        }
        this.addEmptyRowAsNeeded();
        if (this.mServersTable.getRowCount() > 0) {
            this.mServersTable.setRowSelectionInterval(0, 0);
        }
        this.enableServerConnControls(!this.mCognoReportRadio.isSelected());
    }

    @Override
    public void updateDataStructure() {
        TextDocumentExportOptions textDocumentExportOptions = this.mParent.getWebReportDocumentExportOptions();
        textDocumentExportOptions.setDocumentType(IExportOptions.ExportDocumentType.HTML);
        textDocumentExportOptions.setCustomReportTitle(this.mCustomRadio.isSelected() ? this.mTitleEdit.getText() : "No");
        textDocumentExportOptions.setIsSpssFormat(this.mSpssWebReportRadio.isSelected());
        textDocumentExportOptions.setIsTextExcluded(this.mExcludeChecks[0].isSelected());
        textDocumentExportOptions.setIsLogsExcluded(this.mExcludeChecks[1].isSelected());
        textDocumentExportOptions.setIsNotesExcluded(this.mExcludeChecks[2].isSelected());
        textDocumentExportOptions.setIsWarningsExcluded(this.mExcludeChecks[3].isSelected());
        textDocumentExportOptions.setRestyle(this.mRestyleCheck.isSelected());
        textDocumentExportOptions.setWebServerURLs(this.getStringRepresentationForServers());
        LinkedHashMap<Object, Object> linkedHashMap = this.mParent.getWebReportOptionsHashMap();
        linkedHashMap.put(this.getResString("IDS_EXPORTOUTPUT_WREPORT_REPORT_TITLE"), this.mFilenameRadio.isSelected() ? this.mFilenameRadio.getText() : this.mTitleEdit.getText());
        linkedHashMap.put(this.getResString("IDS_EXPORTOUTPUT_WREPORT_FORMAT_TITLE"), this.mSpssWebReportRadio.isSelected() ? this.mSpssWebReportRadio.getText() : this.mCognoReportRadio.getText());
        StringBuilder stringBuilder = new StringBuilder();
        int n = -1;
        for (int i = 0; i <= 3; ++i) {
            if (!this.mExcludeChecks[i].isSelected()) continue;
            if (n > -1) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.mExcludeChecks[i].getText());
            if (n >= 0) continue;
            n = i;
        }
        linkedHashMap.put(this.getResString("IDS_EXPORTOUTPUT_WREPORT_EXCLUDE_TITLE"), stringBuilder.length() > 0 ? stringBuilder.toString() : this.getResString("IDS_ROLE_NONE"));
        String string = this.getResString("IDS_EXPORTOUTPUT_OPTION_SELECTED");
        String string2 = this.getResString("IDS_EXPORTOUTPUT_OPTION_NOT_SELECTED");
        linkedHashMap.put(this.getResString("IDS_EXPORTOUTPUT_WREPORT_RESTYLE_TITLE"), this.mRestyleCheck.isSelected() ? string : string2);
        String string3 = textDocumentExportOptions.getServerURLsForGrid();
        linkedHashMap.put(this.getResString("IDS_EXPORTOUTPUT_WREPORT_SERVERCONN_TITLE"), string3.length() > 0 ? string3 : this.getResString("IDS_ROLE_NONE"));
        this.loadPrefMapWebReport(this.mParent.getWebReportUIMap());
    }

    @Override
    public boolean exportData() {
        return true;
    }

    @Override
    public void reset() {
        this.setDefaults();
    }

    private void setDefaults() {
        DialogUtil.setSelectedButton(this.mTitleButtonGroup, 0);
        this.mTitleEdit.setText("");
        DialogUtil.setSelectedButton(this.mFormatButtonGroup, 0);
        for (int i = 0; i <= 3; ++i) {
            this.mExcludeChecks[i].setSelected(false);
        }
        this.mRestyleCheck.setSelected(true);
        this.mUpButton.setEnabled(false);
        this.mDownButton.setEnabled(false);
        this.mDeleteButton.setEnabled(false);
        this.mValidateButton.setEnabled(false);
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.mServersTable.getModel();
        for (int i = defaultTableModel.getRowCount() - 1; i >= 0; --i) {
            defaultTableModel.removeRow(i);
        }
    }

    private void addEmptyRowAsNeeded() {
        boolean bl = false;
        for (int i = 0; i < this.mServersTable.getRowCount(); ++i) {
            String string = (String)this.mServersTable.getValueAt(i, 1);
            String string2 = (String)this.mServersTable.getValueAt(i, 2);
            if (string.length() != 0 || string2.length() != 0) continue;
            bl = true;
            break;
        }
        if (!bl) {
            Object[] objectArray = new Object[]{false, "", ""};
            ((DefaultTableModel)this.mServersTable.getModel()).addRow(objectArray);
            int n = this.mServersTable.getModel().getRowCount();
            this.mServersTable.setValueAt(true, n - 1, 0);
        }
    }

    private void loadPrefMapWebReport(HashMap<Object, Object> hashMap) {
        String string = this.mFilenameRadio.isSelected() ? "No" : this.mTitleEdit.getText();
        hashMap.put("web_report_custom_title_key", string);
        String string2 = this.mSpssWebReportRadio.isSelected() ? "Yes" : "No";
        hashMap.put("web_report_spss_format_key", string2);
        hashMap.put("web_report_text_key", this.mExcludeChecks[0].isSelected() ? "Yes" : "No");
        hashMap.put("web_report_logs_key", this.mExcludeChecks[1].isSelected() ? "Yes" : "No");
        hashMap.put("web_report_notes_key", this.mExcludeChecks[2].isSelected() ? "Yes" : "No");
        hashMap.put("web_report_warnings_key", this.mExcludeChecks[3].isSelected() ? "Yes" : "No");
        hashMap.put("web_report_restyle_key", this.mRestyleCheck.isSelected() ? "Yes" : "No");
        hashMap.put("web_report_servers_key", this.getStringRepresentationForServers());
    }

    private String getStringRepresentationForServers() {
        Vector<Vector> vector = ((DefaultTableModel)this.mServersTable.getModel()).getDataVector();
        StringBuilder stringBuilder = new StringBuilder();
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                Vector vector2 = vector.get(i);
                if (((String)vector2.get(2)).length() <= 0) continue;
                for (int j = 0; j < vector2.size(); ++j) {
                    stringBuilder.append(vector2.get(j));
                    if (j >= vector2.size() - 1) continue;
                    stringBuilder.append(",");
                }
                if (i >= vector.size() - 1) continue;
                stringBuilder.append(";");
            }
        }
        return stringBuilder.toString();
    }

    private void initVars() {
        this.mExcludeChecks = new JCheckBox[4];
        this.mFilenameRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_EXPORTOUTPUT_WREPORT_FILENAME_RADIO"));
        this.mCustomRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_EXPORTOUTPUT_WREPORT_CUSTOM_RADIO"));
        this.mTitleLabel = DialogUtil.createLabel(this, "IDS_EXPORTOUTPUT_WREPORT_TITLE_LABEL");
        this.mTitleEdit = new StringTextField(35);
        this.mTitleLabel.setLabelFor((Component)((Object)this.mTitleEdit));
        this.mSpssWebReportRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_EXPORTOUTPUT_WREPORT_SPSS_RADIO"));
        this.mCognoReportRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_EXPORTOUTPUT_WREPORT_COGNO_RADIO"));
        for (int i = 0; i <= 3; ++i) {
            this.mExcludeChecks[i] = new JCheckBox(new ToggleButtonAction(this, "IDS_EXPORTOUTPUT_WREPORT_EXC_CHECK" + i));
        }
        this.mTitleButtonGroup = new SpssButtonGroup();
        this.mTitleButtonGroup.add(this.mFilenameRadio);
        this.mTitleButtonGroup.add(this.mCustomRadio);
        this.mFormatButtonGroup = new SpssButtonGroup();
        this.mFormatButtonGroup.add(this.mSpssWebReportRadio);
        this.mFormatButtonGroup.add(this.mCognoReportRadio);
        this.mFilenameRadio.addItemListener(this);
        this.mCustomRadio.addItemListener(this);
        this.mCognoReportRadio.addItemListener(this);
        this.mTitleEdit.getDocument().addDocumentListener(this);
        this.mRestyleCheck = new JCheckBox(new ToggleButtonAction(this, "IDS_EXPORTOUTPUT_WREPORT_RESTYLE_CHECK"));
        this.mServersTable = this.createServersTable();
        this.createServerButtons();
        this.setDefaults();
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, 1, n2);
        JPanel jPanel2 = this.createTitlePanel();
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JComponent[] jComponentArray = new JComponent[]{this.mSpssWebReportRadio, this.mCognoReportRadio};
        JPanel jPanel3 = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.getResString("IDS_EXPORTOUTPUT_WREPORT_FORMAT_TITLE"));
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JLabel jLabel = new JLabel(this.getResString("IDS_EXPORTOUTPUT_WREPORT_EXCLUDE_LABEL"));
        JComponent[] jComponentArray2 = new JComponent[]{jLabel, this.mExcludeChecks[0], this.mExcludeChecks[1], this.mExcludeChecks[2], this.mExcludeChecks[3]};
        JPanel jPanel4 = this.createTrimPanel(jComponentArray2);
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 2, 1, 1, n, insets);
        Insets insets2 = (Insets)insets.clone();
        insets2.left += n2;
        insets2.top += n2;
        insets2.bottom += n2;
        DialogUtil.addUsingGBL(jPanel, this.mRestyleCheck, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        JPanel jPanel5 = this.createWebServerPanel();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel5, gridBagConstraints, 0, 4, 1, 1, n, insets);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    private PlainTable createServersTable() {
        PlainTable plainTable = new PlainTable(){

            @Override
            public boolean editCellAt(int n, int n2) {
                boolean bl = super.editCellAt(n, n2);
                final Component component = this.getEditorComponent();
                if (component != null && component instanceof JTextComponent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ((JTextComponent)component).selectAll();
                            component.requestFocus();
                        }
                    });
                }
                return bl;
            }
        };
        Object[] objectArray = new String[]{this.getResString("IDS_EXPORTOUTPUT_WREPORT_SERVER_USE"), this.getResString("IDS_EXPORTOUTPUT_WREPORT_SERVER_LABEL"), this.getResString("IDS_EXPORTOUTPUT_WREPORT_SERVER_URL")};
        DefaultTableModel defaultTableModel = new DefaultTableModel(null, objectArray){

            @Override
            public Class<?> getColumnClass(int n) {
                if (n == 0) {
                    return Boolean.class;
                }
                return String.class;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                boolean bl = true;
                if (n2 == 0) {
                    bl = ((String)this.getValueAt(n, 2)).length() > 0;
                }
                return bl;
            }
        };
        plainTable.setModel(defaultTableModel);
        plainTable.setRowHeight(plainTable.getRowHeight() + 3);
        plainTable.setRowSelectionAllowed(true);
        plainTable.setSelectionMode(0);
        plainTable.getSelectionModel().addListSelectionListener(this);
        plainTable.setAutoResizeMode(3);
        plainTable.getColumnModel().getColumn(0).setPreferredWidth(40);
        plainTable.getColumnModel().getColumn(0).setMinWidth(40);
        plainTable.getColumnModel().getColumn(0).setMaxWidth(55);
        plainTable.getColumnModel().getColumn(1).setPreferredWidth(130);
        plainTable.getColumnModel().getColumn(1).setMinWidth(80);
        plainTable.getColumnModel().getColumn(2).setPreferredWidth(150);
        plainTable.getColumnModel().getColumn(2).setMinWidth(100);
        JTableHeader jTableHeader = plainTable.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.setDefaultRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? (JLabel)super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                jLabel.setHorizontalAlignment(0);
                jLabel.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                jLabel.setBackground(jTable.getTableHeader().getBackground());
                jLabel.setForeground(jTable.getTableHeader().getForeground());
                jLabel.setFont(jTable.getTableHeader().getFont().deriveFont(1));
                jLabel.setEnabled(jTable.isEnabled());
                return jLabel;
            }
        });
        plainTable.getColumnModel().getColumn(0).setCellRenderer(new CheckBoxCellRenderer());
        plainTable.getColumnModel().getColumn(1).setCellRenderer(new ATableCellRenderer());
        plainTable.getColumnModel().getColumn(2).setCellRenderer(new ATableCellRenderer());
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
            }
        };
        plainTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        plainTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 0), "tabOut");
        plainTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 1), "tabIn");
        plainTable.getActionMap().put("tabIn", abstractAction2);
        plainTable.getActionMap().put("tabOut", abstractAction);
        CellEditorListener cellEditorListener = new CellEditorListener(){

            @Override
            public void editingCanceled(ChangeEvent changeEvent) {
            }

            @Override
            public void editingStopped(ChangeEvent changeEvent) {
                ExportOutputWebReportOptions.this.updateEnableStateForTableButtons();
                ExportOutputWebReportOptions.this.addEmptyRowAsNeeded();
            }
        };
        plainTable.getDefaultEditor(String.class).addCellEditorListener(cellEditorListener);
        return plainTable;
    }

    private void createServerButtons() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction("IDS_EXPORTOUTPUT_WREPORT_SERVER_UP"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExportOutputWebReportOptions.this.moveUp();
            }
        };
        this.mUpButton = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction("IDS_EXPORTOUTPUT_WREPORT_SERVER_DOWN"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExportOutputWebReportOptions.this.moveDown();
            }
        };
        this.mDownButton = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction("IDS_EXPORTOUTPUT_WREPORT_SERVER_VALIDATE"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ExportOutputWebReportOptions.this.mServersTable.getSelectedRow();
                ExportOutputWebReportOptions.this.validateServer(n);
            }
        };
        this.mValidateButton = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction("IDS_EXPORTOUTPUT_WREPORT_SERVER_DELETE"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExportOutputWebReportOptions.this.deleteServer();
            }
        };
        this.mDeleteButton = new JButton(toggleButtonAction);
    }

    private JPanel createTitlePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_EXPORTOUTPUT_WREPORT_REPORT_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mFilenameRadio, gridBagConstraints, 0, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mCustomRadio, gridBagConstraints, 0, 1, 2, 1, n, insets);
        Insets insets2 = (Insets)insets.clone();
        insets2.left += 20;
        DialogUtil.addUsingGBL(jPanel, this.mTitleLabel, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        insets.bottom += 2;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mTitleEdit), gridBagConstraints, 1, 2, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel createTrimPanel(JComponent[] jComponentArray) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_EXPORTOUTPUT_WREPORT_EXCLUDE_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, jComponentArray[0], gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jComponentArray[1], gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jComponentArray[2], gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jComponentArray[3], gridBagConstraints, 1, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jComponentArray[4], gridBagConstraints, 1, 2, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel createWebServerPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_EXPORTOUTPUT_WREPORT_SERVER_TITLE")));
        JPanel jPanel2 = this.createSideButtonPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_EXPORTOUTPUT_WREPORT_URL");
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        this.mServersTable.setPreferredScrollableViewportSize(new Dimension(380, 120));
        jLabel.setLabelFor(this.mServersTable);
        JScrollPane jScrollPane = new JScrollPane(this.mServersTable);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel createSideButtonPanel() {
        JPanel jPanel = new JPanel();
        Insets insets = DialogUtil.getStandardButtonInsets();
        int n = (insets.top + insets.bottom) * 2;
        BoxLayout boxLayout = new BoxLayout(jPanel, 1);
        jPanel.setLayout(boxLayout);
        jPanel.add(Box.createVerticalStrut(n));
        jPanel.add(this.mUpButton);
        jPanel.add(Box.createVerticalStrut(n));
        jPanel.add(this.mDownButton);
        jPanel.add(Box.createVerticalStrut(n));
        jPanel.add(this.mValidateButton);
        jPanel.add(Box.createVerticalStrut(n));
        jPanel.add(this.mDeleteButton);
        UIToolDialogUtil.normalizeButtonWidths((JPanel)jPanel);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        int n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mTitleButtonGroup);
        vector.add(this.mTitleEdit);
        vector.add(this.mFormatButtonGroup);
        for (n = 0; n <= 3; ++n) {
            vector.add(this.mExcludeChecks[n]);
        }
        vector.add(this.mRestyleCheck);
        vector.add(this.mServersTable);
        vector.add(this.mUpButton);
        vector.add(this.mDownButton);
        vector.add(this.mValidateButton);
        vector.add(this.mDeleteButton);
        n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void moveUp() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.mServersTable.getModel();
        int n = this.mServersTable.getSelectedRow();
        defaultTableModel.moveRow(n, n, n - 1);
        this.mServersTable.setRowSelectionInterval(n - 1, n - 1);
    }

    private void moveDown() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.mServersTable.getModel();
        int n = this.mServersTable.getSelectedRow();
        defaultTableModel.moveRow(n, n, n + 1);
        this.mServersTable.setRowSelectionInterval(n + 1, n + 1);
    }

    private void deleteServer() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.mServersTable.getModel();
        int n = this.mServersTable.getSelectedRow();
        if (n > -1) {
            defaultTableModel.removeRow(n);
        }
    }

    private void validateServer(int n) {
        boolean bl;
        int n2;
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.mServersTable.getModel();
        Vector vector = defaultTableModel.getDataVector().get(n);
        String string = (String)vector.get(2);
        String string2 = "http://";
        String string3 = "/webreport";
        String string4 = string;
        if (string.indexOf(string2) < 0) {
            string4 = string2 + string4;
        }
        if ((n2 = string4.indexOf(string3)) > -1) {
            string4 = string4.substring(0, n2);
        }
        if (!(bl = this.checkWebServer(string4))) {
            this.processInvalidAddress(true, n);
            return;
        }
        boolean bl2 = this.checkSpssWebServer((string4 = string4 + string3) + CHECKSERVER_APPEND);
        if (bl2) {
            JOptionPane.showMessageDialog((Component)((Object)this), this.getResString("IDS_EXPORTOUTPUT_WREPORT_SERVER_VALID_MSG"), this.getResString("IDS_EXPORTOUTPUT_WREPORT_SERVER_TITLE"), 1);
        } else {
            this.processInvalidAddress(false, n);
        }
    }

    private void processInvalidAddress(boolean bl, final int n) {
        int n2 = bl ? this.showInvalidDialog(this.getResString("IDS_EXPORTOUTPUT_WREPORT_SERVER_INVALID_MSG1")) : this.showInvalidDialog(this.getResString("IDS_EXPORTOUTPUT_WREPORT_SERVER_INVALID_MSG2"));
        if (n2 == 1) {
            this.deleteServer();
        } else if (n2 == 2) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExportOutputWebReportOptions.this.mServersTable.requestFocusInWindow();
                    ExportOutputWebReportOptions.this.mServersTable.editCellAt(n, 2);
                }
            });
        }
    }

    private int showInvalidDialog(String string) {
        Object[] objectArray = new String[]{this.getResString("IDS_EXPORTOUTPUT_WREPORT_SERVER_IGNORE"), this.getResString("IDS_EXPORTOUTPUT_WREPORT_SERVER_DELETE"), this.getResString("IDS_EXPORTOUTPUT_WREPORT_SERVER_EDIT")};
        return JOptionPane.showOptionDialog(null, string, this.getResString("IDS_EXPORTOUTPUT_WREPORT_SERVER_TITLE"), 0, 0, null, objectArray, objectArray[0]);
    }

    private boolean checkWebServer(String string) {
        try {
            URL uRL = new URL(string);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setConnectTimeout(10000);
            httpURLConnection.setReadTimeout(10000);
            httpURLConnection.setRequestMethod("HEAD");
            int n = httpURLConnection.getResponseCode();
            return 200 <= n && n <= 399;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private boolean checkSpssWebServer(String string) {
        try {
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            byte[] byArray = new byte[100];
            int n = inputStream.read(byArray, 0, byArray.length);
            inputStream.close();
            String string2 = new String(byArray, 0, n);
            if (string2.contains("CheckServer")) {
                return true;
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateEnableStateForTableButtons();
    }

    private void updateEnableStateForTableButtons() {
        int n = this.mServersTable.getSelectedRow();
        this.mUpButton.setEnabled(n > -1 && n > 0);
        this.mDownButton.setEnabled(n > -1 && n < this.mServersTable.getRowCount() - 1);
        this.mDeleteButton.setEnabled(n > -1 && ((String)this.mServersTable.getValueAt(n, 2)).length() > 0);
        this.mValidateButton.setEnabled(n > -1 && ((String)this.mServersTable.getValueAt(n, 2)).length() > 0);
    }

    private void enableServerConnControls(boolean bl) {
        this.mServersTable.setEnabled(bl);
        this.mUpButton.setEnabled(bl);
        this.mDownButton.setEnabled(bl);
        this.mDeleteButton.setEnabled(bl);
        this.mValidateButton.setEnabled(bl);
        if (bl) {
            this.updateEnableStateForTableButtons();
        }
    }

    private class ATableCellRenderer
    extends DefaultTableCellRenderer {
        private ATableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? (JLabel)super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jLabel.setBackground(jTable.getBackground());
            jLabel.setForeground(jTable.getForeground());
            jLabel.setFont(jTable.getFont());
            jLabel.setEnabled(jTable.isEnabled());
            return jLabel;
        }
    }

    private class CheckBoxCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public CheckBoxCellRenderer() {
            this.setBorderPainted(true);
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                super.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            this.setEnabled(jTable.isEnabled() && ((String)jTable.getValueAt(n, 2)).length() > 0);
            this.setSelected(object != null && (object instanceof String && object.equals("true") || object instanceof Boolean && (Boolean)object != false));
            this.setBorder(bl2 ? UIManager.getBorder("Table.focusSelectedCellHighlightBorder") : this.noFocusBorder);
            return this;
        }
    }
}

