/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.documents.output.output_export;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.dialogs.documents.output.output_export.BaseExportDialog;
import com.spss.java_client.ui.dialogs.documents.output.output_export.ExportOutputDlg;
import com.spss.shared.export.IExportOptions;
import com.spss.shared.export.PNGGraphExportOptions;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.NumberSpinner;
import com.spss.uitools.util.IExportOptionConstants;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

public class ExportOutputPNGOptions
extends BaseExportDialog {
    private JLabel mImageSizeLabel;
    private JLabel mColorDepthLabel;
    private NumberSpinner mImageSizeSpinner;
    private JComboBox mColorDepthCombo;
    private ExportOutputDlg mParent;

    public ExportOutputPNGOptions(ExportOutputDlg exportOutputDlg, String string, boolean bl) {
        super(exportOutputDlg, string, bl, false, CommonDlgResBundle.getDefaultResourceBundleName(), CommonDlgResBundle.getImageFolder());
        this.mParent = exportOutputDlg;
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idh_png_options";
    }

    @Override
    public String getPreferenceName() {
        return "png_export_options";
    }

    @Override
    public HashMap<Object, Object> getPreferenceValues() {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        hashMap.put("png_size", ((JTextField)this.mImageSizeSpinner.getEditor()).getText());
        int n = this.mColorDepthCombo.getSelectedIndex();
        hashMap.put("png_color_depth_key", IExportOptionConstants.PNG_COLOR_DEPTH_VALUES[n]);
        return hashMap;
    }

    @Override
    HashMap<Object, Object> getValuesToLoadSubDlg() {
        return this.mParent.getPNGUIMap();
    }

    @Override
    public void loadStateFromPref(HashMap hashMap) {
        Set set = hashMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            String string2 = hashMap.get(string).toString();
            if (string.equals("png_size")) {
                JTextField jTextField = (JTextField)this.mImageSizeSpinner.getEditor();
                jTextField.setText(string2);
                continue;
            }
            if (!string.equals("png_color_depth_key")) continue;
            int n = DialogUtil.getIndexOfItem(IExportOptionConstants.PNG_COLOR_DEPTH_VALUES, string2);
            this.mColorDepthCombo.setSelectedIndex(n);
        }
    }

    @Override
    public void updateDataStructure() {
        PNGGraphExportOptions pNGGraphExportOptions = this.mParent.getMPNGGraphExportOptions();
        LinkedHashMap<Object, Object> linkedHashMap = this.mParent.getMPNGOptionsHashMap();
        HashMap<Object, Object> hashMap = this.mParent.getPNGUIMap();
        int n = Integer.parseInt(((JTextField)this.mImageSizeSpinner.getEditor()).getText());
        pNGGraphExportOptions.setGraphImageSize(n);
        int n2 = this.mColorDepthCombo.getSelectedIndex();
        String[] stringArray = this.getResStringArray("IDS_EXPORTOUTPUT_GRAPHICS_PNG_OPTIONS_NAMES");
        linkedHashMap.put(stringArray[0], ((JTextField)this.mImageSizeSpinner.getEditor()).getText());
        hashMap.put("png_size", ((JTextField)this.mImageSizeSpinner.getEditor()).getText());
        if (n2 == 0) {
            pNGGraphExportOptions.setPNGColorDepth(IExportOptions.PNGColorDepth.Current);
        } else if (n2 == 1) {
            pNGGraphExportOptions.setPNGColorDepth(IExportOptions.PNGColorDepth.BlackWhite);
        } else if (n2 == 2) {
            pNGGraphExportOptions.setPNGColorDepth(IExportOptions.PNGColorDepth.Grays);
        } else if (n2 == 3) {
            pNGGraphExportOptions.setPNGColorDepth(IExportOptions.PNGColorDepth.SixteenColors);
        } else if (n2 == 4) {
            pNGGraphExportOptions.setPNGColorDepth(IExportOptions.PNGColorDepth.TwoFiftySixColors);
        } else if (n2 == 5) {
            pNGGraphExportOptions.setPNGColorDepth(IExportOptions.PNGColorDepth.TrueColor24);
        } else if (n2 == 6) {
            pNGGraphExportOptions.setPNGColorDepth(IExportOptions.PNGColorDepth.TrueColor36);
        }
        linkedHashMap.put(stringArray[1], this.mColorDepthCombo.getItemAt(n2));
        hashMap.put("png_color_depth_key", IExportOptionConstants.PNG_COLOR_DEPTH_VALUES[n2]);
    }

    @Override
    public boolean exportData() {
        return true;
    }

    @Override
    public void reset() {
        this.setDefaults();
    }

    @Override
    public boolean okContinuePressed() {
        JTextField jTextField = (JTextField)this.mImageSizeSpinner.getEditor();
        if (jTextField.getText().length() == 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_EXPORTOUTPUT_IMG_SIZE_EMPTY_ERROR_MSG"), VersionInfo.getAppVersionString());
            jTextField.requestFocus();
            return false;
        }
        int n = Integer.parseInt(jTextField.getText());
        if (n > 200) {
            int n2 = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_EXPORTOUTPUT_IMG_SIZE_GREATER_ERROR_MSG"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, SpssAlertOptionPane.OptionType.YES_NO_OPTION);
            if (n2 != 1) {
                jTextField.requestFocus();
                return false;
            }
            jTextField.setText("200");
            return true;
        }
        return true;
    }

    private void initVars() {
        this.mImageSizeLabel = DialogUtil.createLabel(this, "IDS_EXPORTOUTPUT_GRAPHICS_IMAGE_SIZE_LABEL");
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(100, 1, 200, 1);
        IntTextField intTextField = new IntTextField(1, 200, true);
        intTextField.setAction((Action)new TextFieldAction(this, "IMAGE_SIZE_KEY"));
        this.mImageSizeSpinner = new NumberSpinner(intTextField, spinnerNumberModel);
        this.mImageSizeLabel.setLabelFor(this.mImageSizeSpinner.getEditor());
        this.mColorDepthLabel = DialogUtil.createLabel(this, "IDS_EXPORTOUTPUT_PNG_COLOR_DEPTH_LABEL");
        this.mColorDepthCombo = new JComboBox<String>(this.getResStringArray("IDS_EXPORTOUTPUT_PNG_COLOR_DEPTH_COMBO"));
        this.mColorDepthLabel.setLabelFor(this.mColorDepthCombo);
        this.setDefaults();
    }

    private void setDefaults() {
        ((JTextField)this.mImageSizeSpinner.getEditor()).setText(String.valueOf(100));
        this.mColorDepthCombo.setSelectedIndex(this.mColorDepthCombo.getItemCount() - 1);
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(DialogUtil.getGroupBoxInnerMargin(), insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mImageSizeLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mImageSizeSpinner, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mColorDepthLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mColorDepthCombo, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mImageSizeSpinner.getEditor());
        vector.add(this.mColorDepthCombo);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }
}

