/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.documents.output.output_export;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssMultiLineRadioButton;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.dialogs.documents.output.output_export.BaseExportDialog;
import com.spss.java_client.ui.dialogs.documents.output.output_export.ExportOutputDlg;
import com.spss.java_client.ui.dialogs.documents.output.output_export.ViewsOfModelsButtonGroup;
import com.spss.shared.export.IExportOptions;
import com.spss.shared.export.TextDocumentExportOptions;
import com.spss.uitools.util.IExportOptionConstants;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextArea;

public class ExportOutputExcelOptions
extends BaseExportDialog
implements ItemListener {
    private static final int TEXT_AREA_WIDTH = 280;
    private static final int RADIO_BUTTON_WIDTH = 300;
    private ExportOutputDlg mParent;
    private String mPreferenceName = "excel_export_options";
    private JRadioButton mCreateWorkbookRadio;
    private JTextArea mWorkbookText;
    private JRadioButton mCreateWorksheetRadio;
    private JTextArea mWorksheetText;
    private JRadioButton mModifyWorksheetRadio;
    private JTextArea mModifySheetText;
    private SpssButtonGroup mToDoButtonGroup;
    private JLabel mWorksheetNameLabel;
    private StringTextField mWorksheetNameEdit;
    private JRadioButton mColumnRadio;
    private JRadioButton mRowRadio;
    private JRadioButton mCellRadio;
    private JLabel mStartingCellLabel;
    private StringTextField mStartingCellEdit;
    private JTextArea mStartingCellText;
    private SpssButtonGroup mLocationButtonGroup;
    private JRadioButton mHonorPrintLayerRadio;
    private JRadioButton mAllLayerRadio;
    private JRadioButton mVisibleLayerRadio;
    private SpssButtonGroup mPivotTablesButtonGroup;
    private JCheckBox mFootNoteCaptionCheckBox;
    private ViewsOfModelsButtonGroup mViewsOfModels;

    public ExportOutputExcelOptions(ExportOutputDlg exportOutputDlg, String string, boolean bl, String string2) {
        super(exportOutputDlg, string, bl, false, CommonDlgResBundle.getDefaultResourceBundleName(), CommonDlgResBundle.getImageFolder());
        this.mParent = exportOutputDlg;
        this.mPreferenceName = string2;
        this.setLocationRelativeTo(this.getParent());
        if (this.mPreferenceName.equals("excelx_export_options") || this.mPreferenceName.equals("excelm_export_options")) {
            this.mModifySheetText.setText("");
        }
        this.setVisible(true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_exp_excel_options_dlg";
    }

    @Override
    public String getPreferenceName() {
        return this.mPreferenceName;
    }

    @Override
    HashMap<Object, Object> getValuesToLoadSubDlg() {
        if (this.mPreferenceName.equals("excelx_export_options")) {
            return this.mParent.getEXCELXUIMap();
        }
        if (this.mPreferenceName.equals("excelm_export_options")) {
            return this.mParent.getEXCELMUIMap();
        }
        return this.mParent.getEXCELUIMap();
    }

    @Override
    public HashMap<Object, Object> getPreferenceValues() {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        this.loadPreferencesMap(hashMap);
        return hashMap;
    }

    private void loadPreferencesMap(HashMap<Object, Object> hashMap) {
        String string = "Yes";
        String string2 = "No";
        String string3 = this.mHonorPrintLayerRadio.isSelected() ? IExportOptionConstants.XLS_LAYER_PIVOT_TABLE_VALUES[0] : (this.mAllLayerRadio.isSelected() ? IExportOptionConstants.XLS_LAYER_PIVOT_TABLE_VALUES[1] : IExportOptionConstants.XLS_LAYER_PIVOT_TABLE_VALUES[2]);
        hashMap.put("xls_layer_pivot_table_key", string3);
        hashMap.put("xls_footnote_caption", this.mFootNoteCaptionCheckBox.isSelected() ? string : string2);
        hashMap.put("xls_modelview_key", this.mViewsOfModels.getSelectedOption());
        string3 = this.mCreateWorkbookRadio.isSelected() ? IExportOptionConstants.XLS_OUTPUT_OPERATION_VALUES[0] : (this.mCreateWorksheetRadio.isSelected() ? IExportOptionConstants.XLS_OUTPUT_OPERATION_VALUES[1] : IExportOptionConstants.XLS_OUTPUT_OPERATION_VALUES[2]);
        hashMap.put("xls_output_operation_key", string3);
        string3 = this.mColumnRadio.isSelected() ? IExportOptionConstants.XLS_OUTPUT_LOCATION_VALUES[0] : (this.mRowRadio.isSelected() ? IExportOptionConstants.XLS_OUTPUT_LOCATION_VALUES[1] : IExportOptionConstants.XLS_OUTPUT_LOCATION_VALUES[2]);
        hashMap.put("xls_output_location_key", string3);
        hashMap.put("xls_sheet_name_caption", this.mWorksheetNameEdit.getText());
        hashMap.put("xls_starting_cell_ref_caption", this.mStartingCellEdit.getText());
    }

    @Override
    public void loadStateFromPref(HashMap hashMap) {
        Set set = hashMap.keySet();
        for (Object k : set) {
            int n;
            String string = k.toString();
            String string2 = hashMap.get(string).toString();
            if (string.equals("xls_layer_pivot_table_key")) {
                n = DialogUtil.getIndexOfItem(IExportOptionConstants.XLS_LAYER_PIVOT_TABLE_VALUES, string2);
                DialogUtil.setSelectedButton(this.mPivotTablesButtonGroup, n);
                continue;
            }
            if (string.equals("xls_footnote_caption")) {
                this.mFootNoteCaptionCheckBox.setSelected(string2.equals("Yes"));
                continue;
            }
            if (string.equals("xls_modelview_key")) {
                n = DialogUtil.getIndexOfItem(IExportOptionConstants.HTML_MODELVIEW_VALUES, string2);
                DialogUtil.setSelectedButton(this.mViewsOfModels.getButtonGroup(), n);
                continue;
            }
            if (string.equals("xls_output_operation_key")) {
                n = DialogUtil.getIndexOfItem(IExportOptionConstants.XLS_OUTPUT_OPERATION_VALUES, string2);
                DialogUtil.setSelectedButton(this.mToDoButtonGroup, n);
                continue;
            }
            if (string.equals("xls_output_location_key")) {
                n = DialogUtil.getIndexOfItem(IExportOptionConstants.XLS_OUTPUT_LOCATION_VALUES, string2);
                DialogUtil.setSelectedButton(this.mLocationButtonGroup, n);
                continue;
            }
            if (string.equals("xls_sheet_name_caption")) {
                this.mWorksheetNameEdit.setText(string2);
                continue;
            }
            if (!string.equals("xls_starting_cell_ref_caption")) continue;
            this.mStartingCellEdit.setText(string2);
        }
    }

    @Override
    public void updateDataStructure() {
        TextDocumentExportOptions textDocumentExportOptions = null;
        if (this.mPreferenceName.equals("excelx_export_options")) {
            textDocumentExportOptions = this.mParent.getMEXCELXDocumentExportOptions();
            textDocumentExportOptions.setDocumentType(IExportOptions.ExportDocumentType.Excelx);
        } else if (this.mPreferenceName.equals("excelm_export_options")) {
            textDocumentExportOptions = this.mParent.getMEXCELMDocumentExportOptions();
            textDocumentExportOptions.setDocumentType(IExportOptions.ExportDocumentType.Excelm);
        } else {
            textDocumentExportOptions = this.mParent.getMEXCELDocumentExportOptions();
            textDocumentExportOptions.setDocumentType(IExportOptions.ExportDocumentType.Excel);
        }
        textDocumentExportOptions.setPivotTableOption(this.mHonorPrintLayerRadio.isSelected() ? IExportOptions.PivotTableOptions.PTUsePrintLayerSetting : (this.mAllLayerRadio.isSelected() ? IExportOptions.PivotTableOptions.PTExportAllLayers : IExportOptions.PivotTableOptions.PTExportVisibleLayer));
        textDocumentExportOptions.setModelViewOption(this.mViewsOfModels.getSelectedOptionMV());
        textDocumentExportOptions.setIncludeFootnotesAndCaptions(this.mFootNoteCaptionCheckBox.isSelected());
        textDocumentExportOptions.setExcelSheetname(this.mWorksheetNameEdit.getText());
        String string = this.mStartingCellEdit.isEnabled() ? this.mStartingCellEdit.getText() : "";
        textDocumentExportOptions.setExcelStartingCellRef(string);
        textDocumentExportOptions.setExcelOperationOption(this.mCreateWorkbookRadio.isSelected() ? IExportOptions.ExcelOperationOptions.CreateWorkbook : (this.mCreateWorksheetRadio.isSelected() ? IExportOptions.ExcelOperationOptions.CreateWorksheet : IExportOptions.ExcelOperationOptions.ModifyWorksheet));
        textDocumentExportOptions.setExcelLocationOption(this.mColumnRadio.isSelected() ? IExportOptions.ExcelLocationOptions.AddColumns : (this.mRowRadio.isSelected() ? IExportOptions.ExcelLocationOptions.AddRows : IExportOptions.ExcelLocationOptions.OverwriteAtCellRef));
        LinkedHashMap<Object, Object> linkedHashMap = null;
        linkedHashMap = this.mPreferenceName.equals("excelx_export_options") ? this.mParent.getMEXCELXOptionsHashMap() : (this.mPreferenceName.equals("excelm_export_options") ? this.mParent.getMEXCELMOptionsHashMap() : this.mParent.getMEXCELOptionsHashMap());
        String string2 = this.getResString("IDS_EXPORTOUTPUT_OPTION_SELECTED");
        String string3 = this.getResString("IDS_EXPORTOUTPUT_OPTION_NOT_SELECTED");
        String[] stringArray = this.mParent.getResStringArray("IDS_EXPORTOUTPUT_XLS_OPTIONS");
        linkedHashMap.clear();
        String string4 = this.mCreateWorkbookRadio.isSelected() ? this.mCreateWorkbookRadio.getText() : (this.mCreateWorksheetRadio.isSelected() ? this.mCreateWorksheetRadio.getText() : this.mModifyWorksheetRadio.getText());
        linkedHashMap.put(this.getResString("IDS_EXPORTOUTPUT_XLS_DO_GROUP_TITLE"), string4);
        linkedHashMap.put(stringArray[0], this.mWorksheetNameEdit.getText());
        string4 = this.mColumnRadio.isSelected() ? this.mColumnRadio.getText() : (this.mRowRadio.isSelected() ? this.mRowRadio.getText() : this.mCellRadio.getText());
        linkedHashMap.put(this.getResString("IDS_EXPORTOUTPUT_XLS_LOC_GROUP_TITLE"), string4);
        if (this.mCellRadio.isSelected()) {
            linkedHashMap.put(stringArray[1], string);
        }
        string4 = this.mHonorPrintLayerRadio.isSelected() ? this.getResString("IDS_EXPORTOUTPUT_DOC_COMMON_HONOR_PRINT_RADIO") : (this.mAllLayerRadio.isSelected() ? this.mAllLayerRadio.getText() : this.mVisibleLayerRadio.getText());
        linkedHashMap.put(this.getResString("IDS_EXPORTOUTPUT_DOC_COMMON_PIVOT_TABLE_PANEL_TITLE"), string4);
        linkedHashMap.put(this.mFootNoteCaptionCheckBox.getText(), this.mFootNoteCaptionCheckBox.isSelected() ? string2 : string3);
        linkedHashMap.put(this.getResString("IDS_EXPORTOUTPUT_MODEL_GROUP_TITLE"), this.mViewsOfModels.getSelectedOptionUI());
        if (this.mPreferenceName.equals("excelx_export_options")) {
            this.loadPreferencesMap(this.mParent.getEXCELXUIMap());
        } else if (this.mPreferenceName.equals("excelm_export_options")) {
            this.loadPreferencesMap(this.mParent.getEXCELMUIMap());
        } else {
            this.loadPreferencesMap(this.mParent.getEXCELUIMap());
        }
    }

    @Override
    public boolean exportData() {
        return true;
    }

    @Override
    public void reset() {
        this.setDefaults();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mCellRadio) {
            boolean bl = this.mCellRadio.isSelected();
            this.mStartingCellLabel.setEnabled(bl);
            this.mStartingCellEdit.setEnabled(bl);
        }
    }

    @Override
    public boolean okContinuePressed() {
        return this.validateGUI();
    }

    private boolean validateGUI() {
        int n = this.mWorksheetNameEdit.getText().length();
        if (this.mModifyWorksheetRadio.isSelected() && n == 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_EXPORTOUTPUT_XLS_SHEET_ENTER_NAME"), VersionInfo.getAppVersionString());
            this.mWorksheetNameEdit.requestFocus();
            return false;
        }
        if (n > 31) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_EXPORTOUTPUT_XLS_SHEET_LONG_NAME"), VersionInfo.getAppVersionString());
            this.mWorksheetNameEdit.requestFocus();
            return false;
        }
        if (n > 0 && !this.isValidName(this.mWorksheetNameEdit.getText())) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_EXPORTOUTPUT_XLS_SHEET_BAD_NAME"), VersionInfo.getAppVersionString());
            this.mWorksheetNameEdit.requestFocus();
            return false;
        }
        if (this.mCellRadio.isSelected() && this.mStartingCellEdit.getText().length() == 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_EXPORTOUTPUT_XLS_CELL_ENTER_NAME"), VersionInfo.getAppVersionString());
            this.mStartingCellEdit.requestFocus();
            return false;
        }
        return true;
    }

    private boolean isValidName(String string) {
        if (string.length() > 0) {
            String[] stringArray;
            for (String string2 : stringArray = new String[]{"/", "\\", "?", "*", "[", "]"}) {
                if (!string.contains(string2)) continue;
                return false;
            }
        }
        return true;
    }

    private void initVars() {
        this.mCreateWorkbookRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_EXPORTOUTPUT_XLS_DO_FILE_RADIO"));
        this.mCreateWorksheetRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_EXPORTOUTPUT_XLS_DO_SHEET_RADIO"));
        this.mModifyWorksheetRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_EXPORTOUTPUT_XLS_DO_MODIFY_RADIO"));
        this.mToDoButtonGroup = new SpssButtonGroup();
        this.mToDoButtonGroup.add(this.mCreateWorkbookRadio);
        this.mToDoButtonGroup.add(this.mCreateWorksheetRadio);
        this.mToDoButtonGroup.add(this.mModifyWorksheetRadio);
        this.mWorkbookText = new JTextArea(this.getResString("IDS_EXPORTOUTPUT_XLS_DO_FILE_TXT"));
        this.mWorkbookText.setOpaque(false);
        this.mWorkbookText.setEditable(false);
        this.mWorkbookText.setFocusable(false);
        this.mWorkbookText.setRows(2);
        this.mWorkbookText.setWrapStyleWord(true);
        this.mWorkbookText.setLineWrap(true);
        this.mWorksheetText = new JTextArea(this.getResString("IDS_EXPORTOUTPUT_XLS_DO_SHEET_TXT"));
        this.mWorksheetText.setOpaque(false);
        this.mWorksheetText.setEditable(false);
        this.mWorksheetText.setFocusable(false);
        this.mWorksheetText.setRows(2);
        this.mWorksheetText.setWrapStyleWord(true);
        this.mWorksheetText.setLineWrap(true);
        this.mModifySheetText = new JTextArea(this.getResString("IDS_EXPORTOUTPUT_XLS_DO_MODIFY_TXT"));
        this.mModifySheetText.setOpaque(false);
        this.mModifySheetText.setEditable(false);
        this.mModifySheetText.setFocusable(false);
        this.mModifySheetText.setRows(1);
        this.mModifySheetText.setWrapStyleWord(true);
        this.mModifySheetText.setLineWrap(true);
        this.mWorksheetNameLabel = DialogUtil.createLabel(this, "IDS_EXPORTOUTPUT_XLS_SHEET_NAME");
        this.mWorksheetNameEdit = new StringTextField();
        this.mWorksheetNameLabel.setLabelFor((Component)((Object)this.mWorksheetNameEdit));
        this.mColumnRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_EXPORTOUTPUT_XLS_LOC_COLUMN_RADIO"));
        this.mRowRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_EXPORTOUTPUT_XLS_LOC_ROW_RADIO"));
        this.mCellRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_EXPORTOUTPUT_XLS_LOC_CELL_RADIO"));
        this.mCellRadio.addItemListener(this);
        this.mLocationButtonGroup = new SpssButtonGroup();
        this.mLocationButtonGroup.add(this.mColumnRadio);
        this.mLocationButtonGroup.add(this.mRowRadio);
        this.mLocationButtonGroup.add(this.mCellRadio);
        this.mStartingCellLabel = DialogUtil.createLabel(this, "IDS_EXPORTOUTPUT_XLS_LOC_START_TXT");
        this.mStartingCellEdit = new StringTextField();
        this.mStartingCellText = new JTextArea(this.getResString("IDS_EXPORTOUTPUT_XLS_LOC_DATA_TXT"));
        this.mStartingCellText.setOpaque(false);
        this.mStartingCellText.setEditable(false);
        this.mStartingCellText.setFocusable(false);
        this.mStartingCellText.setRows(2);
        this.mStartingCellText.setWrapStyleWord(true);
        this.mStartingCellText.setLineWrap(true);
        this.mHonorPrintLayerRadio = new SpssMultiLineRadioButton(new ToggleButtonAction(this, "IDS_EXPORTOUTPUT_DOC_COMMON_HONOR_PRINT_RADIO"), 300);
        this.mAllLayerRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_EXPORTOUTPUT_DOC_COMMON_EXPORT_ALL_RADIO"));
        this.mVisibleLayerRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_EXPORTOUTPUT_DOC_COMMON_EXPORT_VISIBLE_RADIO"));
        this.mPivotTablesButtonGroup = new SpssButtonGroup();
        this.mPivotTablesButtonGroup.add(this.mHonorPrintLayerRadio);
        this.mPivotTablesButtonGroup.add(this.mAllLayerRadio);
        this.mPivotTablesButtonGroup.add(this.mVisibleLayerRadio);
        this.mFootNoteCaptionCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_EXPORTOUTPUT_DOC_COMMON_FOOTNOTE_CAPTION_CHECK"));
        this.mViewsOfModels = new ViewsOfModelsButtonGroup(this, 300);
        this.setDefaults();
    }

    private void setDefaults() {
        this.mCreateWorkbookRadio.setSelected(true);
        this.mColumnRadio.setSelected(true);
        this.mHonorPrintLayerRadio.setSelected(true);
        this.mFootNoteCaptionCheckBox.setSelected(true);
        DialogUtil.setSelectedButton(this.mViewsOfModels.getButtonGroup(), 0);
        this.mStartingCellLabel.setEnabled(false);
        this.mStartingCellEdit.setEnabled(false);
        this.mWorkbookText.setMinimumSize(new Dimension(280, this.mWorkbookText.getPreferredSize().height));
        this.mWorkbookText.setPreferredSize(new Dimension(280, this.mWorkbookText.getPreferredSize().height));
        this.mHonorPrintLayerRadio.setMinimumSize(new Dimension(300, this.mAllLayerRadio.getPreferredSize().height * 2));
        this.mHonorPrintLayerRadio.setPreferredSize(new Dimension(300, this.mAllLayerRadio.getPreferredSize().height * 2));
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        JPanel jPanel2 = this.setupToDoPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        JComponent[] jComponentArray = new JComponent[]{this.mHonorPrintLayerRadio, this.mAllLayerRadio, this.mVisibleLayerRadio};
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel3 = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.getResString("IDS_EXPORTOUTPUT_DOC_COMMON_PIVOT_TABLE_PANEL_TITLE"));
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 2, 3, n, insets);
        int n2 = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, n2, 0, 1, 1, n, insets);
        int n3 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(n3, insets.left, insets.bottom, insets.right);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mFootNoteCaptionCheckBox, gridBagConstraints, n2, 1, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mViewsOfModels.getPanel(), gridBagConstraints, n2, 2, 1, 1, n, insets2);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    private JPanel setupToDoPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = DialogUtil.getGroupingIndent();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, insets.left + n2, insets.bottom, insets.right);
        Insets insets3 = new Insets(n, n, n, n);
        int n3 = 23;
        JSeparator jSeparator = new JSeparator(0);
        jSeparator.setEnabled(true);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel2, this.mWorksheetNameLabel, gridBagConstraints, 0, 0, 1, 1, n3, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel2, (JComponent)((Object)this.mWorksheetNameEdit), gridBagConstraints, 1, 0, 1, 1, n3, insets);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel3, this.mStartingCellLabel, gridBagConstraints, 0, 0, 1, 1, n3, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel3, (JComponent)((Object)this.mStartingCellEdit), gridBagConstraints, 1, 0, 1, 1, n3, insets);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_EXPORTOUTPUT_XLS_LOC_GROUP_TITLE")));
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel4, this.mColumnRadio, gridBagConstraints, 0, 0, 1, 1, n3, insets);
        DialogUtil.addUsingGBL(jPanel4, this.mRowRadio, gridBagConstraints, 0, 1, 1, 1, n3, insets);
        DialogUtil.addUsingGBL(jPanel4, this.mCellRadio, gridBagConstraints, 0, 2, 1, 1, n3, insets);
        DialogUtil.addUsingGBL(jPanel4, this.mStartingCellText, gridBagConstraints, 0, 3, 1, 1, n3, insets2);
        gridBagConstraints.weighty = 1.0;
        Insets insets4 = new Insets(insets.top, insets.left + n2, n, n);
        DialogUtil.addUsingGBL(jPanel4, jPanel3, gridBagConstraints, 0, 4, 1, 1, n3, insets4);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_EXPORTOUTPUT_XLS_DO_GROUP_TITLE")));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mCreateWorkbookRadio, gridBagConstraints, 0, 0, 1, 1, n3, insets);
        DialogUtil.addUsingGBL(jPanel, this.mWorkbookText, gridBagConstraints, 0, 1, 1, 1, n3, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mCreateWorksheetRadio, gridBagConstraints, 0, 2, 1, 1, n3, insets);
        DialogUtil.addUsingGBL(jPanel, this.mWorksheetText, gridBagConstraints, 0, 3, 1, 1, n3, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mModifyWorksheetRadio, gridBagConstraints, 0, 4, 1, 1, n3, insets);
        DialogUtil.addUsingGBL(jPanel, this.mModifySheetText, gridBagConstraints, 0, 5, 1, 1, n3, insets2);
        DialogUtil.addUsingGBL(jPanel, jSeparator, gridBagConstraints, 0, 6, 2, 1, n3, insets3);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 7, 2, 1, n3, insets3);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 8, 2, 2, n3, insets3);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mToDoButtonGroup);
        vector.add(this.mWorksheetNameEdit);
        vector.add(this.mLocationButtonGroup);
        vector.add(this.mStartingCellEdit);
        vector.add(this.mPivotTablesButtonGroup);
        vector.add(this.mFootNoteCaptionCheckBox);
        vector.add(this.mViewsOfModels.getButtonGroup());
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }
}

