/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.documents.output.output_export;

import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.dialogs.documents.output.output_export.BaseExportDialog;
import com.spss.java_client.ui.dialogs.documents.output.output_export.ExportOutputDlg;
import com.spss.shared.export.EPSGraphExportOptions;
import com.spss.shared.export.IExportOptions;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.NumberSpinner;
import com.spss.uitools.util.IExportOptionConstants;
import com.spss.uitools.util.IOptionConstants;
import com.spss.vis.specification.Length;
import com.spss.vis.specification.UnitType;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ExportOutputEPSOptions
extends BaseExportDialog
implements ItemListener,
DocumentListener {
    private JRadioButton mCurrentSizeRadio;
    private JLabel mPercentageLabel;
    private NumberSpinner mPercentageSpinner;
    private JRadioButton mPhysicalSizeRadio;
    private JLabel mWidthPointsLabel;
    private NumberSpinner mWidthPointsSpinner;
    private SpssButtonGroup mImageSizeButtonGroup;
    private JCheckBox mPreviewImageCheck;
    private JRadioButton mFontReferencesRadio;
    private JRadioButton mReplaceFontsRadio;
    private SpssButtonGroup mFontsButtonGroup;
    private ExportOutputDlg mParent;
    int mSizeIndex = 0;

    public ExportOutputEPSOptions(ExportOutputDlg exportOutputDlg, String string, boolean bl) {
        super(exportOutputDlg, string, bl, false, CommonDlgResBundle.getDefaultResourceBundleName(), CommonDlgResBundle.getImageFolder());
        this.mParent = exportOutputDlg;
        this.setImageSizeUnits();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idh_export_opts_eps1";
    }

    @Override
    public String getPreferenceName() {
        return "eps_export_options";
    }

    @Override
    HashMap<Object, Object> getValuesToLoadSubDlg() {
        return this.mParent.getEPSUIMap();
    }

    @Override
    public HashMap<Object, Object> getPreferenceValues() {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        String string = "Yes";
        String string2 = "No";
        hashMap.put("eps_image_size_key", this.mCurrentSizeRadio.isSelected() ? IExportOptionConstants.EPS_IMAGE_SIZE_VALUES[0] : IExportOptionConstants.EPS_IMAGE_SIZE_VALUES[1]);
        if (!((JTextField)this.mPercentageSpinner.getEditor()).getText().equals("")) {
            hashMap.put("eps_percentage", ((JTextField)this.mPercentageSpinner.getEditor()).getText());
        }
        if (!((JTextField)this.mWidthPointsSpinner.getEditor()).getText().equals("")) {
            hashMap.put("eps_width_points", ((JTextField)this.mWidthPointsSpinner.getEditor()).getText());
        }
        hashMap.put("eps_preview_image", this.mPreviewImageCheck.isSelected() ? string : string2);
        hashMap.put("eps_fonts_key", this.mFontReferencesRadio.isSelected() ? IExportOptionConstants.EPS_FONTS_VALUES[0] : IExportOptionConstants.EPS_FONTS_VALUES[1]);
        return hashMap;
    }

    @Override
    public void loadStateFromPref(HashMap hashMap) {
        Set set = hashMap.keySet();
        Iterator iterator = set.iterator();
        String string = "Yes";
        while (iterator.hasNext()) {
            int n;
            String string2 = iterator.next().toString();
            String string3 = hashMap.get(string2).toString();
            if (string2.equals("eps_image_size_key")) {
                n = DialogUtil.getIndexOfItem(IExportOptionConstants.EPS_IMAGE_SIZE_VALUES, string3);
                DialogUtil.setSelectedButton(this.mImageSizeButtonGroup, n);
                continue;
            }
            if (string2.equals("eps_percentage")) {
                ((JTextField)this.mPercentageSpinner.getEditor()).setText(string3);
                continue;
            }
            if (string2.equals("eps_width_points")) {
                double d;
                Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
                Preferences preferences2 = preferences.node("options/general");
                String string4 = preferences2.get("measurement_system", IOptionConstants.OUTPUT_MEASUREMENT_SYSTEM_VALUES[0]);
                int n2 = DialogUtil.getIndexOfItem(IOptionConstants.OUTPUT_MEASUREMENT_SYSTEM_VALUES, string4);
                if (n2 == 0) {
                    ((JTextField)this.mWidthPointsSpinner.getEditor()).setText(string3);
                    continue;
                }
                NumberFormat numberFormat = NumberFormat.getNumberInstance();
                numberFormat.setMaximumFractionDigits(2);
                int n3 = Integer.parseInt(string3);
                if (n2 == 1) {
                    d = new Length((float)n3, UnitType.PT).getValueInUnits(UnitType.IN, (float)n3);
                    ((JTextField)this.mWidthPointsSpinner.getEditor()).setText(numberFormat.format(d));
                    continue;
                }
                if (n2 != 2) continue;
                d = new Length((float)n3, UnitType.PT).getValueInUnits(UnitType.CM, (float)n3);
                ((JTextField)this.mWidthPointsSpinner.getEditor()).setText(numberFormat.format(d));
                continue;
            }
            if (string2.equals("eps_preview_image")) {
                this.mPreviewImageCheck.setSelected(string3.equals(string));
                continue;
            }
            if (!string2.equals("eps_fonts_key")) continue;
            n = DialogUtil.getIndexOfItem(IExportOptionConstants.EPS_FONTS_VALUES, string3);
            DialogUtil.setSelectedButton(this.mFontsButtonGroup, n);
        }
    }

    @Override
    public void updateDataStructure() {
        LinkedHashMap<Object, Object> linkedHashMap = this.mParent.getMEPSOptionsHashMap();
        linkedHashMap.clear();
        HashMap<Object, Object> hashMap = this.mParent.getEPSUIMap();
        EPSGraphExportOptions ePSGraphExportOptions = this.mParent.getMEPSGraphExportOptions();
        String string = this.getResString("IDS_EXPORTOUTPUT_OPTION_SELECTED");
        String string2 = this.getResString("IDS_EXPORTOUTPUT_OPTION_NOT_SELECTED");
        String string3 = "Yes";
        String string4 = "No";
        ePSGraphExportOptions.setImageSizeType(this.mCurrentSizeRadio.isSelected() ? EPSGraphExportOptions.EPSImageSizeType.Percentage : EPSGraphExportOptions.EPSImageSizeType.PhysicalSize);
        String[] stringArray = this.getResStringArray("IDS_EXPORTOUTPUT_GRAPHICS_EPS_OPTIONS_NAMES");
        linkedHashMap.put(stringArray[0], this.mCurrentSizeRadio.isSelected() ? this.mCurrentSizeRadio.getText() : this.mPhysicalSizeRadio.getText());
        hashMap.put("eps_image_size_key", this.mCurrentSizeRadio.isSelected() ? IExportOptionConstants.EPS_IMAGE_SIZE_VALUES[0] : IExportOptionConstants.EPS_IMAGE_SIZE_VALUES[1]);
        if (this.mCurrentSizeRadio.isSelected()) {
            String string5 = ((JTextField)this.mPercentageSpinner.getEditor()).getText();
            ePSGraphExportOptions.setSizePercentage(Integer.parseInt(string5));
            linkedHashMap.put(stringArray[1], string5);
            hashMap.put("eps_percentage", ((JTextField)this.mPercentageSpinner.getEditor()).getText());
            if (!((JTextField)this.mWidthPointsSpinner.getEditor()).getText().equals("")) {
                hashMap.put("eps_width_points", ((JTextField)this.mWidthPointsSpinner.getEditor()).getText());
            }
        } else {
            int n;
            String string6 = ((JTextField)this.mWidthPointsSpinner.getEditor()).getText();
            Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
            Preferences preferences2 = preferences.node("options/general");
            String string7 = preferences2.get("measurement_system", IOptionConstants.OUTPUT_MEASUREMENT_SYSTEM_VALUES[0]);
            int n2 = DialogUtil.getIndexOfItem(IOptionConstants.OUTPUT_MEASUREMENT_SYSTEM_VALUES, string7);
            if (n2 == 0) {
                ePSGraphExportOptions.setWidthPoints(Integer.parseInt(string6));
                hashMap.put("eps_width_points", string6);
            } else if (n2 == 1) {
                n = (int)Math.round(new Length(string6 + "IN").getValueInUnits(UnitType.PT, Float.parseFloat(string6)));
                ePSGraphExportOptions.setWidthPoints(n);
                hashMap.put("eps_width_points", String.valueOf(n));
            } else if (n2 == 2) {
                n = (int)Math.round(new Length(string6 + "CM").getValueInUnits(UnitType.PT, Float.parseFloat(string6)));
                ePSGraphExportOptions.setWidthPoints(n);
                hashMap.put("eps_width_points", String.valueOf(n));
            }
            String[] stringArray2 = new String[]{"IDS_EXPORTOUTPUT_EPS_POINTS", "IDS_EXPORTOUTPUT_EPS_INCHES", "IDS_EXPORTOUTPUT_EPS_CENTIMETERS"};
            String string8 = MessageFormat.format(stringArray[2], this.getResString(stringArray2[n2]));
            linkedHashMap.put(string8, string6);
            if (!((JTextField)this.mPercentageSpinner.getEditor()).getText().equals("")) {
                hashMap.put("eps_percentage", ((JTextField)this.mPercentageSpinner.getEditor()).getText());
            }
        }
        hashMap.put("eps_preview_image", this.mPreviewImageCheck.isSelected() ? string3 : string4);
        hashMap.put("eps_fonts_key", this.mFontReferencesRadio.isSelected() ? IExportOptionConstants.EPS_FONTS_VALUES[0] : IExportOptionConstants.EPS_FONTS_VALUES[1]);
        ePSGraphExportOptions.setIncludeTIFFIamge(this.mPreviewImageCheck.isSelected());
        linkedHashMap.put(stringArray[3], this.mPreviewImageCheck.isSelected() ? string : string2);
        linkedHashMap.put(stringArray[4], this.mFontReferencesRadio.isSelected() ? this.mFontReferencesRadio.getText() : this.mReplaceFontsRadio.getText());
        ePSGraphExportOptions.setEPSFonts(this.mFontReferencesRadio.isSelected() ? EPSGraphExportOptions.EPSFonts.UseFontRef : EPSGraphExportOptions.EPSFonts.UseCurve);
    }

    @Override
    public boolean exportData() {
        return true;
    }

    @Override
    public void reset() {
        this.setDefaults();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mCurrentSizeRadio) {
            boolean bl = this.mCurrentSizeRadio.isSelected();
            this.mPercentageLabel.setEnabled(bl);
            this.mPercentageSpinner.setEnabled(bl);
            this.mPercentageSpinner.getEditor().setOpaque(bl);
            this.enableContinue(((JTextField)this.mPercentageSpinner.getEditor()).getText().length() > 0);
        } else if (object == this.mPhysicalSizeRadio) {
            boolean bl = this.mPhysicalSizeRadio.isSelected();
            this.mWidthPointsLabel.setEnabled(bl);
            this.mWidthPointsSpinner.setEnabled(bl);
            this.mWidthPointsSpinner.getEditor().setOpaque(bl);
            this.enableContinue(((JTextField)this.mWidthPointsSpinner.getEditor()).getText().length() > 0);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.mCurrentSizeRadio.isSelected()) {
            this.enableContinue(((JTextField)this.mPercentageSpinner.getEditor()).getText().length() > 0);
        } else {
            this.enableContinue(((JTextField)this.mWidthPointsSpinner.getEditor()).getText().length() > 0);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.mCurrentSizeRadio.isSelected()) {
            this.enableContinue(((JTextField)this.mPercentageSpinner.getEditor()).getText().length() > 0);
        } else {
            this.enableContinue(((JTextField)this.mWidthPointsSpinner.getEditor()).getText().length() > 0);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.mCurrentSizeRadio.isSelected()) {
            this.enableContinue(((JTextField)this.mPercentageSpinner.getEditor()).getText().length() > 0);
        } else {
            this.enableContinue(((JTextField)this.mWidthPointsSpinner.getEditor()).getText().length() > 0);
        }
    }

    private void initVars() {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("options/general");
        String string = preferences2.get("measurement_system", IOptionConstants.OUTPUT_MEASUREMENT_SYSTEM_VALUES[0]);
        String[] stringArray = new String[]{"IDS_EXPORTOUTPUT_EPS_POINTS_WIDTH_LABEL", "IDS_EXPORTOUTPUT_EPS_INCHES_WIDTH_LABEL", "IDS_EXPORTOUTPUT_EPS_CENTIMETER_WIDTH_LABEL"};
        this.mSizeIndex = DialogUtil.getIndexOfItem(IOptionConstants.OUTPUT_MEASUREMENT_SYSTEM_VALUES, string);
        this.mCurrentSizeRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_EXPORTOUTPUT_EPS_CURRENT_SIZE_RADIO"));
        this.mCurrentSizeRadio.addItemListener(this);
        this.mPercentageLabel = DialogUtil.createLabel(this, "IDS_EXPORTOUTPUT_EPS_PERCENTAGE_LABEL");
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(100, 1, 200, 1);
        IntTextField intTextField = new IntTextField(1, 200, true);
        intTextField.setAction((Action)new TextFieldAction(this, "IMAGE_SIZE_KEY"));
        this.mPercentageSpinner = new NumberSpinner(intTextField, spinnerNumberModel);
        this.mPercentageLabel.setLabelFor(this.mPercentageSpinner.getEditor());
        ((JTextField)this.mPercentageSpinner.getEditor()).getDocument().addDocumentListener(this);
        this.mPhysicalSizeRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_EXPORTOUTPUT_EPS_PHYSICAL_SIZE_RADIO"));
        this.mPhysicalSizeRadio.addItemListener(this);
        this.mWidthPointsLabel = DialogUtil.createLabel(this, stringArray[this.mSizeIndex]);
        this.mWidthPointsSpinner = this.createSpinnerByUnit(this.mSizeIndex);
        this.mWidthPointsLabel.setLabelFor(this.mWidthPointsSpinner.getEditor());
        ((JTextField)this.mWidthPointsSpinner.getEditor()).getDocument().addDocumentListener(this);
        this.mImageSizeButtonGroup = new SpssButtonGroup();
        this.mImageSizeButtonGroup.add(this.mCurrentSizeRadio);
        this.mImageSizeButtonGroup.add(this.mPhysicalSizeRadio);
        this.mPreviewImageCheck = new JCheckBox(new ToggleButtonAction(this, "IDS_EXPORTOUTPUT_EPS_TIFF_PREVIEW_CHECK"));
        this.mFontReferencesRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_EXPORTOUTPUT_EPS_USE_FONTS_RADIO"));
        this.mReplaceFontsRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_EXPORTOUTPUT_EPS_REPLACE_FONTS_RADIO"));
        this.mFontsButtonGroup = new SpssButtonGroup();
        this.mFontsButtonGroup.add(this.mFontReferencesRadio);
        this.mFontsButtonGroup.add(this.mReplaceFontsRadio);
        this.setDefaults();
    }

    private void setDefaults() {
        this.mCurrentSizeRadio.setSelected(true);
        ((JTextField)this.mPercentageSpinner.getEditor()).setText(String.valueOf(100));
        ((JTextField)this.mWidthPointsSpinner.getEditor()).setText(String.valueOf(300));
        this.mPreviewImageCheck.setSelected(true);
        this.mFontReferencesRadio.setSelected(true);
        this.mWidthPointsSpinner.setEnabled(false);
        this.mWidthPointsSpinner.getEditor().setOpaque(false);
    }

    private void setImageSizeUnits() {
        EPSGraphExportOptions ePSGraphExportOptions = this.mParent.getMEPSGraphExportOptions();
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("options/general");
        String string = preferences2.get("measurement_system", IOptionConstants.OUTPUT_MEASUREMENT_SYSTEM_VALUES[0]);
        int n = DialogUtil.getIndexOfItem(IOptionConstants.OUTPUT_MEASUREMENT_SYSTEM_VALUES, string);
        if (n == 1) {
            ePSGraphExportOptions.setSizeUnits(IExportOptions.ImageSizeUnits.Inches);
        } else if (n == 2) {
            ePSGraphExportOptions.setSizeUnits(IExportOptions.ImageSizeUnits.Centimeters);
        } else {
            ePSGraphExportOptions.setSizeUnits(IExportOptions.ImageSizeUnits.Points);
        }
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, insets.left + 10, insets.bottom, insets.right);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.setUpImageSizePanel(), gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mPreviewImageCheck, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.fill = 1;
        JComponent[] jComponentArray = new JComponent[]{this.mFontReferencesRadio, this.mReplaceFontsRadio};
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        JPanel jPanel2 = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.getResString("IDS_EXPORTOUTPUT_EPS_FONTS_PANEL_TITLE"));
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n, insets);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    private JPanel setUpImageSizePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_EXPORTOUTPUT_EPS_IMAGE_SIZE_PANEL_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, insets.left + 20, insets.bottom, insets.right);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mCurrentSizeRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.setUpPercentagePanel(), gridBagConstraints, 0, 1, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mPhysicalSizeRadio, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.setUpWidthPointsPanel(), gridBagConstraints, 0, 3, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setUpPercentagePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mPercentageLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mPercentageSpinner, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setUpWidthPointsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mWidthPointsLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mWidthPointsSpinner, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mImageSizeButtonGroup);
        vector.add(this.mPercentageSpinner.getEditor());
        vector.add(this.mWidthPointsSpinner.getEditor());
        vector.add(this.mPreviewImageCheck);
        vector.add(this.mFontsButtonGroup);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private NumberSpinner createSpinnerByUnit(int n) {
        NumberSpinner numberSpinner = n == 0 ? new NumberSpinner(100.0, 1.0, 300.0, 2, true, 1.0) : (n == 1 ? new NumberSpinner(1.39, 0.01, 4.17, 2, true, 0.01) : (n == 2 ? new NumberSpinner(3.53, 0.01, 10.58, 2, true, 0.04) : new NumberSpinner(100.0, 1.0, 300.0, 2, true, 1.0)));
        return numberSpinner;
    }
}

