/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.documents.output.output_export;

import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.dialogs.documents.output.output_export.BaseExportDialog;
import com.spss.java_client.ui.dialogs.documents.output.output_export.ExportOutputDlg;
import com.spss.java_client.ui.dialogs.documents.output.output_export.ViewsOfModelsButtonGroup;
import com.spss.java_client.ui.dialogs.documents.output.output_export.WideTablesButtonGroup;
import com.spss.java_client.ui.dialogs.documents.output.pagesetup.PageSetupUtil;
import com.spss.java_client.ui.doc_types.output.IViewerWindow;
import com.spss.java_client.ui.doc_types.output.ViewerFrame;
import com.spss.shared.export.IExportOptions;
import com.spss.shared.export.PPTDocumentExportOptions;
import com.spss.shared.export.PageSetupExportOptions;
import com.spss.shared.export.TextDocumentExportOptions;
import com.spss.uitools.util.IExportOptionConstants;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ExportOutputDocCommonOptions
extends BaseExportDialog
implements ItemListener {
    private JRadioButton mHonorPrintLayerRadio;
    private JRadioButton mAllLayerRadio;
    private JRadioButton mVisibleLayerRadio;
    private JCheckBox mInteractiveLayerCheckBox;
    private JCheckBox mFootNoteCaptionCheckBox;
    private JCheckBox mUseViewerOutlineCheckBox;
    private SpssButtonGroup mPivotTablesButtonGroup;
    private ExportOutputDlg mParent;
    private boolean mIsPowerPoint;
    private ViewsOfModelsButtonGroup mViewsOfModels;
    private WideTablesButtonGroup mWideTables;
    private IExportOptions.ExportDocumentType mCurrentDocType;
    private JButton mPageSetupButton;
    private JRadioButton mHtmlExportStyleRadio;
    private JRadioButton mHtmlExportNoStyleRadio;
    private SpssButtonGroup mTablesTHMLButtonGroup;
    private JCheckBox mPreserveBreakPointsCheckBox;

    public ExportOutputDocCommonOptions(ExportOutputDlg exportOutputDlg, String string, boolean bl) {
        super(exportOutputDlg, string, bl, false, CommonDlgResBundle.getDefaultResourceBundleName(), CommonDlgResBundle.getImageFolder());
        this.mParent = exportOutputDlg;
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    @Override
    public String getDialogHelpID() {
        if (this.mCurrentDocType == IExportOptions.ExportDocumentType.WordRTF) {
            return "idh_exp_word_options_dlg";
        }
        if (this.mCurrentDocType == IExportOptions.ExportDocumentType.HTML) {
            return "idh_exp_html_options_dlg";
        }
        if (this.mCurrentDocType == IExportOptions.ExportDocumentType.PPT) {
            return "idh_exp_ppt_export_options";
        }
        return "";
    }

    @Override
    HashMap<Object, Object> getValuesToLoadSubDlg() {
        String string = this.mParent.getSelectedItemOfDocCombo();
        if (string.equals(this.getResString("IDS_EXPORTOUTPUT_DOC_TYPE_HTML"))) {
            return this.mParent.getHTMLUIMap();
        }
        if (string.equals(this.getResString("IDS_EXPORTOUTPUT_DOC_TYPE_WORD_RTF"))) {
            return this.mParent.getWORDRTFUIMap();
        }
        return this.mParent.getPPTUIMap();
    }

    @Override
    public String getPreferenceName() {
        String string = this.mParent.getSelectedItemOfDocCombo();
        if (string.equals(this.getResString("IDS_EXPORTOUTPUT_DOC_TYPE_HTML"))) {
            return "html_export_options";
        }
        if (string.equals(this.getResString("IDS_EXPORTOUTPUT_DOC_TYPE_WORD_RTF"))) {
            return "word_rtf_export_options";
        }
        return "ppt_export_options";
    }

    @Override
    public HashMap<Object, Object> getPreferenceValues() {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        if (this.mCurrentDocType == IExportOptions.ExportDocumentType.HTML) {
            this.loadPrefMapHtml(hashMap);
        } else if (this.mCurrentDocType == IExportOptions.ExportDocumentType.WordRTF) {
            this.loadPrefMapWordRtf(hashMap);
        } else if (this.mCurrentDocType == IExportOptions.ExportDocumentType.PPT) {
            this.loadPrefMapPpt(hashMap);
        }
        return hashMap;
    }

    private void loadPrefMapHtml(HashMap<Object, Object> hashMap) {
        String string = this.mHonorPrintLayerRadio.isSelected() ? IExportOptionConstants.HTML_LAYER_PIVOT_TABLE_VALUES[0] : (this.mAllLayerRadio.isSelected() ? IExportOptionConstants.HTML_LAYER_PIVOT_TABLE_VALUES[1] : IExportOptionConstants.HTML_LAYER_PIVOT_TABLE_VALUES[2]);
        hashMap.put("html_layer_pivot_table_key", string);
        String string2 = this.mHtmlExportStyleRadio.isSelected() ? IExportOptionConstants.TABLES_AS_HTML_VALUES[0] : IExportOptionConstants.TABLES_AS_HTML_VALUES[1];
        hashMap.put("html_tables_as_html_key", string2);
        hashMap.put("html_modelview_key", this.mViewsOfModels.getSelectedOption());
        hashMap.put("html_footnote_caption", this.mFootNoteCaptionCheckBox.isSelected() ? "Yes" : "No");
        hashMap.put("html_interactive_layer", this.mInteractiveLayerCheckBox.isSelected() ? "Yes" : "No");
    }

    private void loadPrefMapWordRtf(HashMap<Object, Object> hashMap) {
        String string = this.mHonorPrintLayerRadio.isSelected() ? IExportOptionConstants.WORD_RTF_LAYER_PIVOT_TABLE_VALUES[0] : (this.mAllLayerRadio.isSelected() ? IExportOptionConstants.WORD_RTF_LAYER_PIVOT_TABLE_VALUES[1] : IExportOptionConstants.WORD_RTF_LAYER_PIVOT_TABLE_VALUES[2]);
        hashMap.put("word_rtf_layer_pivot_table_key", string);
        hashMap.put("word_wide_table_key", this.mWideTables.getSelectedOption());
        hashMap.put("word_rtf_preserve_break_points", this.mPreserveBreakPointsCheckBox.isSelected() ? "Yes" : "No");
        hashMap.put("word_rtf_footnote_caption", this.mFootNoteCaptionCheckBox.isSelected() ? "Yes" : "No");
        hashMap.put("word_modelview_key", this.mViewsOfModels.getSelectedOption());
        this.savePageSetupWord(hashMap);
    }

    private void savePageSetupWord(HashMap<Object, Object> hashMap) {
        PageSetupExportOptions pageSetupExportOptions = this.mParent.getPageSetupWord();
        IExportOptions.MeasurementUnits measurementUnits = pageSetupExportOptions.getUnits();
        hashMap.put("word_meas_units_key", IExportOptionConstants.PAGE_MEAS_UNITS_VALUES[this.getIndex(measurementUnits)]);
        int n = pageSetupExportOptions.getOrientation() == 0 ? 1 : 0;
        hashMap.put("word_orientation_key", IExportOptionConstants.PAGE_ORIENTATION_VALUES[n]);
        hashMap.put("word_page_width_key", Double.toString(pageSetupExportOptions.getWidth()));
        hashMap.put("word_page_height_key", Double.toString(pageSetupExportOptions.getHeight()));
        hashMap.put("word_page_lmargin_key", Double.toString(pageSetupExportOptions.getLeftMargin()));
        hashMap.put("word_page_tmargin_key", Double.toString(pageSetupExportOptions.getTopMargin()));
        hashMap.put("word_page_rmargin_key", Double.toString(pageSetupExportOptions.getRightMargin()));
        hashMap.put("word_page_bmargin_key", Double.toString(pageSetupExportOptions.getBottomMargin()));
    }

    private int getIndex(IExportOptions.MeasurementUnits measurementUnits) {
        if (measurementUnits == IExportOptions.MeasurementUnits.Inches) {
            return 0;
        }
        if (measurementUnits == IExportOptions.MeasurementUnits.Millimeters) {
            return 1;
        }
        if (measurementUnits == IExportOptions.MeasurementUnits.Centimeters) {
            return 2;
        }
        if (measurementUnits == IExportOptions.MeasurementUnits.PrintPoints) {
            return 3;
        }
        return 0;
    }

    private void loadPrefMapPpt(HashMap<Object, Object> hashMap) {
        String string = this.mHonorPrintLayerRadio.isSelected() ? IExportOptionConstants.POWERPOINT_LAYER_PIVOT_TABLE_VALUES[0] : (this.mAllLayerRadio.isSelected() ? IExportOptionConstants.POWERPOINT_LAYER_PIVOT_TABLE_VALUES[1] : IExportOptionConstants.POWERPOINT_LAYER_PIVOT_TABLE_VALUES[2]);
        hashMap.put("powerpoint_layer_pivot_table_key", string);
        hashMap.put("powerpoint_wide_table_key", this.mWideTables.getSelectedOption());
        hashMap.put("powerpoint_footnote_caption", this.mFootNoteCaptionCheckBox.isSelected() ? "Yes" : "No");
        hashMap.put("powerpoint_slide_titles", this.mUseViewerOutlineCheckBox.isSelected() ? "Yes" : "No");
        hashMap.put("powerpoint_modelview_key", this.mViewsOfModels.getSelectedOption());
        this.savePageSetupPpt(hashMap);
    }

    private void savePageSetupPpt(HashMap<Object, Object> hashMap) {
        PageSetupExportOptions pageSetupExportOptions = this.mParent.getPageSetupPpt();
        IExportOptions.MeasurementUnits measurementUnits = pageSetupExportOptions.getUnits();
        hashMap.put("ppt_meas_units_key", IExportOptionConstants.PAGE_MEAS_UNITS_VALUES[this.getIndex(measurementUnits)]);
        int n = pageSetupExportOptions.getOrientation() == 0 ? 1 : 0;
        hashMap.put("ppt_orientation_key", IExportOptionConstants.PAGE_ORIENTATION_VALUES[n]);
        hashMap.put("ppt_page_width_key", Double.toString(pageSetupExportOptions.getWidth()));
        hashMap.put("ppt_page_height_key", Double.toString(pageSetupExportOptions.getHeight()));
        hashMap.put("ppt_page_lmargin_key", Double.toString(pageSetupExportOptions.getLeftMargin()));
        hashMap.put("ppt_page_tmargin_key", Double.toString(pageSetupExportOptions.getTopMargin()));
        hashMap.put("ppt_page_rmargin_key", Double.toString(pageSetupExportOptions.getRightMargin()));
        hashMap.put("ppt_page_bmargin_key", Double.toString(pageSetupExportOptions.getBottomMargin()));
    }

    @Override
    public void loadStateFromPref(HashMap hashMap) {
        block20: {
            String string;
            Iterator iterator;
            block21: {
                block19: {
                    Set set = hashMap.keySet();
                    iterator = set.iterator();
                    string = "Yes";
                    if (this.mCurrentDocType != IExportOptions.ExportDocumentType.HTML) break block19;
                    while (iterator.hasNext()) {
                        int n;
                        String string2 = iterator.next().toString();
                        String string3 = hashMap.get(string2).toString();
                        if (string2.equals("html_layer_pivot_table_key")) {
                            n = DialogUtil.getIndexOfItem(IExportOptionConstants.HTML_LAYER_PIVOT_TABLE_VALUES, string3);
                            DialogUtil.setSelectedButton(this.mPivotTablesButtonGroup, n);
                        }
                        if (string2.equals("html_tables_as_html_key")) {
                            n = DialogUtil.getIndexOfItem(IExportOptionConstants.TABLES_AS_HTML_VALUES, string3);
                            DialogUtil.setSelectedButton(this.mTablesTHMLButtonGroup, n);
                        }
                        if (string2.equals("html_modelview_key")) {
                            n = DialogUtil.getIndexOfItem(IExportOptionConstants.HTML_MODELVIEW_VALUES, string3);
                            DialogUtil.setSelectedButton(this.mViewsOfModels.getButtonGroup(), n);
                            continue;
                        }
                        if (string2.equals("html_footnote_caption")) {
                            this.mFootNoteCaptionCheckBox.setSelected(string3.equals(string));
                            continue;
                        }
                        if (!string2.equals("html_interactive_layer")) continue;
                        this.mInteractiveLayerCheckBox.setSelected(string3.equals(string));
                    }
                    break block20;
                }
                if (this.mCurrentDocType != IExportOptions.ExportDocumentType.WordRTF) break block21;
                while (iterator.hasNext()) {
                    int n;
                    String string4 = iterator.next().toString();
                    String string5 = hashMap.get(string4).toString();
                    if (string4.equals("word_rtf_layer_pivot_table_key")) {
                        n = DialogUtil.getIndexOfItem(IExportOptionConstants.WORD_RTF_LAYER_PIVOT_TABLE_VALUES, string5);
                        DialogUtil.setSelectedButton(this.mPivotTablesButtonGroup, n);
                    } else if (string4.equals("word_rtf_footnote_caption")) {
                        this.mFootNoteCaptionCheckBox.setSelected(string5.equals(string));
                    } else if (string4.equals("word_rtf_preserve_break_points")) {
                        this.mPreserveBreakPointsCheckBox.setSelected(string5.equals(string));
                    }
                    if (string4.equals("word_wide_table_key")) {
                        n = DialogUtil.getIndexOfItem(IExportOptionConstants.WORD_WIDETABLE_VALUES, string5);
                        DialogUtil.setSelectedButton(this.mWideTables.getButtonGroup(), n);
                    }
                    if (!string4.equals("word_modelview_key")) continue;
                    n = DialogUtil.getIndexOfItem(IExportOptionConstants.HTML_MODELVIEW_VALUES, string5);
                    DialogUtil.setSelectedButton(this.mViewsOfModels.getButtonGroup(), n);
                }
                break block20;
            }
            if (this.mCurrentDocType != IExportOptions.ExportDocumentType.PPT) break block20;
            while (iterator.hasNext()) {
                int n;
                String string6 = iterator.next().toString();
                String string7 = hashMap.get(string6).toString();
                if (string6.equals("powerpoint_layer_pivot_table_key")) {
                    n = DialogUtil.getIndexOfItem(IExportOptionConstants.POWERPOINT_LAYER_PIVOT_TABLE_VALUES, string7);
                    DialogUtil.setSelectedButton(this.mPivotTablesButtonGroup, n);
                } else if (string6.equals("powerpoint_footnote_caption")) {
                    this.mFootNoteCaptionCheckBox.setSelected(string7.equals(string));
                } else if (string6.equals("powerpoint_slide_titles")) {
                    this.mUseViewerOutlineCheckBox.setSelected(string7.equals(string));
                }
                if (string6.equals("powerpoint_wide_table_key")) {
                    n = DialogUtil.getIndexOfItem(IExportOptionConstants.WORD_WIDETABLE_VALUES, string7);
                    DialogUtil.setSelectedButton(this.mWideTables.getButtonGroup(), n);
                }
                if (!string6.equals("powerpoint_modelview_key")) continue;
                n = DialogUtil.getIndexOfItem(IExportOptionConstants.HTML_MODELVIEW_VALUES, string7);
                DialogUtil.setSelectedButton(this.mViewsOfModels.getButtonGroup(), n);
            }
        }
    }

    @Override
    public void updateDataStructure() {
        if (this.mCurrentDocType == IExportOptions.ExportDocumentType.WordRTF) {
            this.updateDataStructureWordRtf();
        } else if (this.mCurrentDocType == IExportOptions.ExportDocumentType.HTML) {
            this.updateDataStructureHtml();
        } else if (this.mCurrentDocType == IExportOptions.ExportDocumentType.PPT) {
            this.updateDataStructurePpt();
        }
    }

    private void updateDataStructureHtml() {
        TextDocumentExportOptions textDocumentExportOptions = this.mParent.getMHTMLDocumentExportOptions();
        textDocumentExportOptions.setDocumentType(IExportOptions.ExportDocumentType.HTML);
        textDocumentExportOptions.setPivotTableOption(this.mHonorPrintLayerRadio.isSelected() ? IExportOptions.PivotTableOptions.PTUsePrintLayerSetting : (this.mAllLayerRadio.isSelected() ? IExportOptions.PivotTableOptions.PTExportAllLayers : IExportOptions.PivotTableOptions.PTExportVisibleLayer));
        textDocumentExportOptions.setModelViewOption(this.mViewsOfModels.getSelectedOptionMV());
        textDocumentExportOptions.setIncludeFootnotesAndCaptions(this.mFootNoteCaptionCheckBox.isSelected());
        textDocumentExportOptions.setHtmlWithStyle(this.mHtmlExportStyleRadio.isSelected());
        textDocumentExportOptions.setInteractiveLayer(this.mInteractiveLayerCheckBox.isEnabled() && this.mInteractiveLayerCheckBox.isSelected());
        LinkedHashMap<Object, Object> linkedHashMap = this.mParent.getMHTMLOptionsHashMap();
        String[] stringArray = this.getResStringArray("IDS_EXPORTOUTPUT_DOC_COMMON_OPTIONS_NAMES");
        String string = this.getResString("IDS_EXPORTOUTPUT_OPTION_SELECTED");
        String string2 = this.getResString("IDS_EXPORTOUTPUT_OPTION_NOT_SELECTED");
        linkedHashMap.put(stringArray[0], this.mHonorPrintLayerRadio.isSelected() ? this.mHonorPrintLayerRadio.getText() : (this.mAllLayerRadio.isSelected() ? this.mAllLayerRadio.getText() : this.mVisibleLayerRadio.getText()));
        linkedHashMap.put(this.getResString("IDS_EXPORTOUTPUT_DOC_COMMON_HTML_TABLES_AS_HTML"), this.mHtmlExportStyleRadio.isSelected() ? this.getResString("IDS_EXPORTOUTPUT_DOC_COMMON_HTML_STYLE_RADIO") : this.getResString("IDS_EXPORTOUTPUT_DOC_COMMON_HTML_NOSTYLE_RADIO"));
        linkedHashMap.put(stringArray[1], this.mFootNoteCaptionCheckBox.isSelected() ? string : string2);
        linkedHashMap.put(this.getResString("IDS_EXPORTOUTPUT_MODEL_GROUP_TITLE"), this.mViewsOfModels.getSelectedOptionUI());
        linkedHashMap.put(this.getResString("IDS_EXPORTOUTPUT_DOC_COMMON_EXPORT_INTERACTIVE_CHECK"), this.mInteractiveLayerCheckBox.isEnabled() && this.mInteractiveLayerCheckBox.isSelected() ? string : string2);
        this.loadPrefMapHtml(this.mParent.getHTMLUIMap());
    }

    private void updateDataStructureWordRtf() {
        TextDocumentExportOptions textDocumentExportOptions = this.mParent.getMWORDRTFDocumentExportOptions();
        textDocumentExportOptions.setDocumentType(IExportOptions.ExportDocumentType.WordRTF);
        textDocumentExportOptions.setPivotTableOption(this.mHonorPrintLayerRadio.isSelected() ? IExportOptions.PivotTableOptions.PTUsePrintLayerSetting : (this.mAllLayerRadio.isSelected() ? IExportOptions.PivotTableOptions.PTExportAllLayers : IExportOptions.PivotTableOptions.PTExportVisibleLayer));
        textDocumentExportOptions.setWideTablesOption(this.mWideTables.getSelectedOptionMV());
        textDocumentExportOptions.setPreserveBreakPoints(this.mPreserveBreakPointsCheckBox.isSelected());
        textDocumentExportOptions.setIncludeFootnotesAndCaptions(this.mFootNoteCaptionCheckBox.isSelected());
        textDocumentExportOptions.setModelViewOption(this.mViewsOfModels.getSelectedOptionMV());
        LinkedHashMap<Object, Object> linkedHashMap = this.mParent.getMWORDRTFOptionsHashMap();
        String[] stringArray = this.getResStringArray("IDS_EXPORTOUTPUT_DOC_COMMON_OPTIONS_NAMES");
        String string = this.getResString("IDS_EXPORTOUTPUT_OPTION_SELECTED");
        String string2 = this.getResString("IDS_EXPORTOUTPUT_OPTION_NOT_SELECTED");
        linkedHashMap.put(stringArray[0], this.mHonorPrintLayerRadio.isSelected() ? this.mHonorPrintLayerRadio.getText() : (this.mAllLayerRadio.isSelected() ? this.mAllLayerRadio.getText() : this.mVisibleLayerRadio.getText()));
        linkedHashMap.put(this.getResString("IDS_EXPORTOUTPUT_WIDETABLE_GROUP_TITLE"), this.mWideTables.getSelectedOptionUI());
        linkedHashMap.put(this.getResString("IDS_EXPORTOUTPUT_DOC_COMMON_HTML_PRESERVE_BREAK_POINTS"), this.mPreserveBreakPointsCheckBox.isSelected() ? string : string2);
        linkedHashMap.put(stringArray[1], this.mFootNoteCaptionCheckBox.isSelected() ? string : string2);
        linkedHashMap.put(this.getResString("IDS_EXPORTOUTPUT_MODEL_GROUP_TITLE"), this.mViewsOfModels.getSelectedOptionUI());
        this.loadPrefMapWordRtf(this.mParent.getWORDRTFUIMap());
    }

    private void updateDataStructurePpt() {
        PPTDocumentExportOptions pPTDocumentExportOptions = this.mParent.getMPPTDocumentExportOptions();
        pPTDocumentExportOptions.setDocumentType(IExportOptions.ExportDocumentType.PPT);
        pPTDocumentExportOptions.setPivotTableOption(this.mHonorPrintLayerRadio.isSelected() ? IExportOptions.PivotTableOptions.PTUsePrintLayerSetting : (this.mAllLayerRadio.isSelected() ? IExportOptions.PivotTableOptions.PTExportAllLayers : IExportOptions.PivotTableOptions.PTExportVisibleLayer));
        pPTDocumentExportOptions.setWideTablesOption(this.mWideTables.getSelectedOptionMV());
        pPTDocumentExportOptions.setIncludeFootnotesAndCaptions(this.mFootNoteCaptionCheckBox.isSelected());
        pPTDocumentExportOptions.setPPTUseViewerOutlines(this.mUseViewerOutlineCheckBox.isSelected());
        pPTDocumentExportOptions.setModelViewOption(this.mViewsOfModels.getSelectedOptionMV());
        LinkedHashMap<Object, Object> linkedHashMap = this.mParent.getMPPTOptionsHashMap();
        String[] stringArray = this.getResStringArray("IDS_EXPORTOUTPUT_DOC_PPT_OPTIONS_NAMES");
        String string = this.getResString("IDS_EXPORTOUTPUT_OPTION_SELECTED");
        String string2 = this.getResString("IDS_EXPORTOUTPUT_OPTION_NOT_SELECTED");
        linkedHashMap.put(stringArray[0], this.mHonorPrintLayerRadio.isSelected() ? this.mHonorPrintLayerRadio.getText() : (this.mAllLayerRadio.isSelected() ? this.mAllLayerRadio.getText() : this.mVisibleLayerRadio.getText()));
        linkedHashMap.put(this.getResString("IDS_EXPORTOUTPUT_WIDETABLE_GROUP_TITLE"), this.mWideTables.getSelectedOptionUI());
        linkedHashMap.put(stringArray[1], this.mFootNoteCaptionCheckBox.isSelected() ? string : string2);
        linkedHashMap.put(stringArray[2], this.mUseViewerOutlineCheckBox.isSelected() ? string : string2);
        linkedHashMap.put(this.getResString("IDS_EXPORTOUTPUT_MODEL_GROUP_TITLE"), this.mViewsOfModels.getSelectedOptionUI());
        this.loadPrefMapPpt(this.mParent.getPPTUIMap());
    }

    @Override
    public boolean exportData() {
        return true;
    }

    @Override
    public void reset() {
        this.setDefaults();
    }

    private void initVars() {
        this.mHonorPrintLayerRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_EXPORTOUTPUT_DOC_COMMON_HONOR_PRINT_RADIO"));
        this.mAllLayerRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_EXPORTOUTPUT_DOC_COMMON_EXPORT_ALL_RADIO"));
        this.mVisibleLayerRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_EXPORTOUTPUT_DOC_COMMON_EXPORT_VISIBLE_RADIO"));
        this.mInteractiveLayerCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_EXPORTOUTPUT_DOC_COMMON_EXPORT_INTERACTIVE_CHECK"));
        this.mFootNoteCaptionCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_EXPORTOUTPUT_DOC_COMMON_FOOTNOTE_CAPTION_CHECK"));
        this.mPreserveBreakPointsCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_EXPORTOUTPUT_DOC_COMMON_PRESERVE_BREAKPOINT_CHECK"));
        if (this.mIsPowerPoint) {
            this.mUseViewerOutlineCheckBox = new JCheckBox(new ToggleButtonAction(this, "IDS_EXPORTOUTPUT_DOC_COMMON_USE_VIEWER_OUTLINE_CHECK"));
        }
        this.mPivotTablesButtonGroup = new SpssButtonGroup();
        this.mPivotTablesButtonGroup.add(this.mHonorPrintLayerRadio);
        this.mPivotTablesButtonGroup.add(this.mAllLayerRadio);
        this.mPivotTablesButtonGroup.add(this.mVisibleLayerRadio);
        this.mViewsOfModels = new ViewsOfModelsButtonGroup(this);
        if (this.mCurrentDocType == IExportOptions.ExportDocumentType.WordRTF || this.mCurrentDocType == IExportOptions.ExportDocumentType.PPT) {
            this.mWideTables = new WideTablesButtonGroup(this);
            ToggleButtonAction toggleButtonAction = new ToggleButtonAction("IDS_EXPORTOUTPUT_PAGE_SETUP_BUTTON"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ExportOutputDocCommonOptions.this.runPageSetupDialog();
                }
            };
            this.mPageSetupButton = new JButton(toggleButtonAction);
        }
        this.mHtmlExportStyleRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_EXPORTOUTPUT_DOC_COMMON_HTML_STYLE_RADIO"));
        this.mHtmlExportNoStyleRadio = new JRadioButton(new ToggleButtonAction(this, "IDS_EXPORTOUTPUT_DOC_COMMON_HTML_NOSTYLE_RADIO"));
        this.mTablesTHMLButtonGroup = new SpssButtonGroup();
        this.mTablesTHMLButtonGroup.add(this.mHtmlExportStyleRadio);
        this.mTablesTHMLButtonGroup.add(this.mHtmlExportNoStyleRadio);
        this.setDefaults();
        this.mHonorPrintLayerRadio.addItemListener(this);
        this.mAllLayerRadio.addItemListener(this);
    }

    private void runPageSetupDialog() {
        Object object;
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageSetupExportOptions pageSetupExportOptions = null;
        if (this.mCurrentDocType == IExportOptions.ExportDocumentType.PPT) {
            pageSetupExportOptions = this.mParent.getPageSetupPpt();
        } else if (this.mCurrentDocType == IExportOptions.ExportDocumentType.WordRTF) {
            pageSetupExportOptions = this.mParent.getPageSetupWord();
        }
        if (pageSetupExportOptions == null) {
            return;
        }
        PageFormat pageFormat = PageSetupExportOptions.getPageFormat();
        if (pageFormat == null) {
            pageFormat = printerJob.defaultPage();
            object = (ViewerFrame)this.mParent.getOwner();
            pageFormat.setOrientation(PageSetupUtil.getOrientation((IViewerWindow)object, pageFormat.getOrientation()));
            Paper paper = PageSetupUtil.getPaper((IViewerWindow)object, pageFormat.getPaper());
            pageFormat.setPaper(paper);
            PageSetupExportOptions.setPageFormat((PageFormat)pageFormat);
        }
        if (!(object = printerJob.pageDialog(pageFormat)).equals(pageFormat)) {
            pageSetupExportOptions.setPage((PageFormat)object, true);
            PageSetupExportOptions.setPageFormat((PageFormat)object);
        }
    }

    private void setDefaults() {
        this.mHonorPrintLayerRadio.setSelected(true);
        this.mInteractiveLayerCheckBox.setEnabled(this.mCurrentDocType == IExportOptions.ExportDocumentType.HTML);
        this.mInteractiveLayerCheckBox.setSelected(false);
        this.mFootNoteCaptionCheckBox.setSelected(true);
        this.mPreserveBreakPointsCheckBox.setSelected(true);
        if (this.mIsPowerPoint) {
            this.mUseViewerOutlineCheckBox.setSelected(false);
        }
        DialogUtil.setSelectedButton(this.mViewsOfModels.getButtonGroup(), 0);
        if (this.mCurrentDocType == IExportOptions.ExportDocumentType.WordRTF || this.mCurrentDocType == IExportOptions.ExportDocumentType.PPT) {
            DialogUtil.setSelectedButton(this.mWideTables.getButtonGroup(), 0);
        }
        if (this.mCurrentDocType == IExportOptions.ExportDocumentType.HTML) {
            this.mHtmlExportStyleRadio.setSelected(true);
        }
    }

    @Override
    protected void init() {
        super.init();
        this.mCurrentDocType = ((ExportOutputDlg)((Object)this.getParent())).getCurrentDocType();
        this.mIsPowerPoint = this.mCurrentDocType == IExportOptions.ExportDocumentType.PPT;
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        JComponent[] jComponentArray = new JComponent[]{this.mHonorPrintLayerRadio, this.mAllLayerRadio, this.mVisibleLayerRadio, this.mInteractiveLayerCheckBox};
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JPanel jPanel2 = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, this.getResString("IDS_EXPORTOUTPUT_DOC_COMMON_PIVOT_TABLE_PANEL_TITLE"));
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(n2, insets.left, insets.bottom, insets.right);
        int n3 = 0;
        if (this.mCurrentDocType == IExportOptions.ExportDocumentType.WordRTF || this.mCurrentDocType == IExportOptions.ExportDocumentType.PPT) {
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            DialogUtil.addUsingGBL(jPanel, this.mWideTables.getPanel(), gridBagConstraints, 0, ++n3, 1, 1, n, insets2);
        }
        if (this.mCurrentDocType == IExportOptions.ExportDocumentType.HTML) {
            JComponent[] jComponentArray2 = new JComponent[]{this.mHtmlExportStyleRadio, this.mHtmlExportNoStyleRadio};
            JPanel jPanel3 = PanelFactory.getBasicPanel(jComponentArray2, PanelFactory.PanelType.yaxis, this.getResString("IDS_EXPORTOUTPUT_DOC_COMMON_HTML_TABLES_AS_HTML"));
            DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, ++n3, 1, 1, n, insets);
        }
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        if (this.mCurrentDocType == IExportOptions.ExportDocumentType.WordRTF) {
            DialogUtil.addUsingGBL(jPanel, this.mPreserveBreakPointsCheckBox, gridBagConstraints, 0, ++n3, 1, 1, n, insets);
        }
        DialogUtil.addUsingGBL(jPanel, this.mFootNoteCaptionCheckBox, gridBagConstraints, 0, ++n3, 1, 1, n, insets);
        if (this.mIsPowerPoint) {
            DialogUtil.addUsingGBL(jPanel, this.mUseViewerOutlineCheckBox, gridBagConstraints, 0, ++n3, 1, 1, n, insets);
        }
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mViewsOfModels.getPanel(), gridBagConstraints, 0, ++n3, 1, 1, n, insets2);
        if (this.mCurrentDocType == IExportOptions.ExportDocumentType.WordRTF || this.mCurrentDocType == IExportOptions.ExportDocumentType.PPT) {
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            insets2.set(n2, insets.left, n2, insets.right);
            DialogUtil.addUsingGBL(jPanel, this.mPageSetupButton, gridBagConstraints, 0, ++n3, 1, 1, n, insets2);
        }
        this.setFocusTraversalPolicy();
        this.pack();
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mPivotTablesButtonGroup);
        vector.add(this.mInteractiveLayerCheckBox);
        if (this.mCurrentDocType == IExportOptions.ExportDocumentType.WordRTF || this.mCurrentDocType == IExportOptions.ExportDocumentType.PPT) {
            vector.add(this.mWideTables.getButtonGroup());
        }
        if (this.mCurrentDocType == IExportOptions.ExportDocumentType.HTML) {
            vector.add(this.mTablesTHMLButtonGroup);
        }
        if (this.mCurrentDocType == IExportOptions.ExportDocumentType.WordRTF) {
            vector.add(this.mPreserveBreakPointsCheckBox);
        }
        vector.add(this.mFootNoteCaptionCheckBox);
        if (this.mIsPowerPoint) {
            vector.add(this.mUseViewerOutlineCheckBox);
        }
        vector.add(this.mViewsOfModels.getButtonGroup());
        if (this.mCurrentDocType == IExportOptions.ExportDocumentType.WordRTF || this.mCurrentDocType == IExportOptions.ExportDocumentType.PPT) {
            vector.add(this.mPageSetupButton);
        }
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getItem();
        if (object == this.mHonorPrintLayerRadio || object == this.mAllLayerRadio) {
            JRadioButton jRadioButton = (JRadioButton)object;
            this.mInteractiveLayerCheckBox.setEnabled(jRadioButton.isSelected() && this.mCurrentDocType == IExportOptions.ExportDocumentType.HTML);
        }
    }
}

