/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.documents.output.output_export;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.dialogs.documents.output.output_export.BaseExportDialog;
import com.spss.java_client.ui.dialogs.documents.output.output_export.ExportOutputDlg;
import com.spss.shared.export.BMPGraphExportOptions;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.NumberSpinner;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

public class ExportOutputBMPOptions
extends BaseExportDialog {
    private JLabel mImageSizeLabel;
    private NumberSpinner mImageSizeSpinner;
    private JCheckBox mCompressImageCheck;
    private ExportOutputDlg mParent;

    public ExportOutputBMPOptions(ExportOutputDlg exportOutputDlg, String string, boolean bl) {
        super(exportOutputDlg, string, bl, false, CommonDlgResBundle.getDefaultResourceBundleName(), CommonDlgResBundle.getImageFolder());
        this.mParent = exportOutputDlg;
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idh_bmp_options";
    }

    @Override
    public String getPreferenceName() {
        return "bmp_export_options";
    }

    @Override
    HashMap<Object, Object> getValuesToLoadSubDlg() {
        return this.mParent.getBMPUIMap();
    }

    @Override
    public HashMap<Object, Object> getPreferenceValues() {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        String string = "Yes";
        String string2 = "No";
        hashMap.put("bmp_size", ((JTextField)this.mImageSizeSpinner.getEditor()).getText());
        hashMap.put("bmp_compress_image", this.mCompressImageCheck.isSelected() ? string : string2);
        return hashMap;
    }

    @Override
    public void loadStateFromPref(HashMap hashMap) {
        Set set = hashMap.keySet();
        Iterator iterator = set.iterator();
        String string = "Yes";
        while (iterator.hasNext()) {
            String string2 = iterator.next().toString();
            String string3 = hashMap.get(string2).toString();
            if (string2.equals("bmp_size")) {
                JTextField jTextField = (JTextField)this.mImageSizeSpinner.getEditor();
                jTextField.setText(string3);
                continue;
            }
            if (!string2.equals("bmp_compress_image")) continue;
            this.mCompressImageCheck.setSelected(string3.equalsIgnoreCase(string));
        }
    }

    @Override
    public void updateDataStructure() {
        String string = this.getResString("IDS_EXPORTOUTPUT_OPTION_SELECTED");
        String string2 = this.getResString("IDS_EXPORTOUTPUT_OPTION_NOT_SELECTED");
        String string3 = "Yes";
        String string4 = "No";
        BMPGraphExportOptions bMPGraphExportOptions = this.mParent.getMBMPGraphExportOptions();
        int n = Integer.parseInt(((JTextField)this.mImageSizeSpinner.getEditor()).getText());
        bMPGraphExportOptions.setGraphImageSize(n);
        bMPGraphExportOptions.setBMPCompressImage(this.mCompressImageCheck.isSelected());
        LinkedHashMap<Object, Object> linkedHashMap = this.mParent.getMBMPOptionsHashMap();
        HashMap<Object, Object> hashMap = this.mParent.getBMPUIMap();
        String[] stringArray = this.getResStringArray("IDS_EXPORTOUTPUT_GRAPHICS_BMP_OPTIONS_NAMES");
        linkedHashMap.put(stringArray[0], ((JTextField)this.mImageSizeSpinner.getEditor()).getText());
        linkedHashMap.put(stringArray[1], this.mCompressImageCheck.isSelected() ? string : string2);
        hashMap.put("bmp_size", ((JTextField)this.mImageSizeSpinner.getEditor()).getText());
        hashMap.put("bmp_compress_image", this.mCompressImageCheck.isSelected() ? string3 : string4);
    }

    @Override
    public boolean exportData() {
        return true;
    }

    @Override
    public void reset() {
        this.setDefaults();
    }

    @Override
    public boolean okContinuePressed() {
        JTextField jTextField = (JTextField)this.mImageSizeSpinner.getEditor();
        if (jTextField.getText().length() == 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_EXPORTOUTPUT_IMG_SIZE_EMPTY_ERROR_MSG"), VersionInfo.getAppVersionString());
            jTextField.requestFocus();
            return false;
        }
        int n = Integer.parseInt(jTextField.getText());
        if (n > 200) {
            int n2 = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_EXPORTOUTPUT_IMG_SIZE_GREATER_ERROR_MSG"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eQuestion, SpssAlertOptionPane.OptionType.YES_NO_OPTION);
            if (n2 != 1) {
                jTextField.requestFocus();
                return false;
            }
            jTextField.setText("200");
            return true;
        }
        return true;
    }

    private void initVars() {
        this.mImageSizeLabel = DialogUtil.createLabel(this, "IDS_EXPORTOUTPUT_GRAPHICS_IMAGE_SIZE_LABEL");
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(100, 1, 200, 1);
        IntTextField intTextField = new IntTextField(1, 200, true);
        intTextField.setAction((Action)new TextFieldAction(this, "IMAGE_SIZE_KEY"));
        this.mImageSizeSpinner = new NumberSpinner(intTextField, spinnerNumberModel);
        this.mImageSizeLabel.setLabelFor(this.mImageSizeSpinner.getEditor());
        this.mCompressImageCheck = new JCheckBox(new ToggleButtonAction(this, "IDS_EXPORTOUTPUT_GRAPHICS_COMPRESS_IMAGE_CHECK"));
        this.setDefaults();
    }

    private void setDefaults() {
        ((JTextField)this.mImageSizeSpinner.getEditor()).setText(String.valueOf(100));
        this.mCompressImageCheck.setSelected(false);
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.setUpImageSizePanel(), gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        JComponent[] jComponentArray = new JComponent[]{this.mCompressImageCheck};
        JPanel jPanel2 = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, "");
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    private JPanel setUpImageSizePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mImageSizeLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mImageSizeSpinner, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mImageSizeSpinner.getEditor());
        vector.add(this.mCompressImageCheck);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }
}

