/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.documents.output.output_export;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.syntax.ISyntaxDocument;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.doc_types.syntax.SyntaxFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.format.CommonState;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import com.spss.uitools.help.StatsHelp;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public abstract class BaseExportDialog
extends BaseDialog {
    private JButton continueButton;
    protected OkAction mOkAction;
    protected PasteAction mPasteAction;
    protected ContinueAction mContinueAction;
    protected ResetAction mResetAction;
    protected boolean mHasHiddenItems;
    protected ArrayList<String> mImageClassNames;
    protected boolean mHasSelectedItems;
    protected boolean mMainDialog;

    public BaseExportDialog(Window window, String string, boolean bl, boolean bl2, boolean bl3, ArrayList<String> arrayList, boolean bl4, String string2, String string3) {
        super(window, bl, ResUtil.getBundle(string2, ResUtil.getLocale()), string3);
        this.setTitle(this.getResString(string));
        this.setLocationRelativeTo(this.getParent());
        this.setDefaultCloseOperation(2);
        this.mHasHiddenItems = bl3;
        this.mImageClassNames = arrayList;
        this.mHasSelectedItems = bl4;
        this.mMainDialog = bl2;
        this.loadPanelAndCmdButton(bl2);
    }

    public BaseExportDialog(BaseExportDialog baseExportDialog, String string, boolean bl, boolean bl2, String string2, String string3) {
        super((BaseDialog)baseExportDialog, string, bl, ResUtil.getBundle(string2, ResUtil.getLocale()), string3);
        this.mMainDialog = bl2;
        this.setLocationRelativeTo(this.getParent());
        this.setDefaultCloseOperation(2);
        this.loadPanelAndCmdButtonForSubDlg(bl2);
    }

    public abstract String getDialogHelpID();

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, this.getDialogHelpID());
    }

    public boolean okContinuePressed() {
        return true;
    }

    public HashMap<Object, Object> readValuesForPref(String string) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("export_options").node(string);
        try {
            String[] stringArray = preferences2.keys();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = preferences2.get(string2, "");
                hashMap.put(string2, string3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return hashMap;
    }

    public HashMap<Object, Object> readValuesForPref(String string, String string2) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("export_options").node(string).node(string2);
        try {
            String[] stringArray = preferences2.keys();
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                String string4 = preferences2.get(string3, "");
                hashMap.put(string3, string4);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return hashMap;
    }

    protected void saveStateToPref(String string, String string2, HashMap hashMap) {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("export_options").node(string).node(string2);
        Object[] objectArray = hashMap.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            String string3 = (String)objectArray[i];
            String string4 = (String)hashMap.get(string3);
            preferences2.put(string3, string4);
        }
    }

    protected void saveSubDlgUIStateToPref(String string, HashMap hashMap) {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("export_options").node(string);
        Object[] objectArray = hashMap.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            String string2 = (String)objectArray[i];
            String string3 = (String)hashMap.get(string2);
            preferences2.put(string2, string3);
        }
    }

    protected void enableOk(boolean bl) {
        if (this.mOkAction != null) {
            this.mOkAction.setEnabled(bl);
        }
    }

    protected void enableContinue(boolean bl) {
        if (this.mContinueAction != null) {
            this.mContinueAction.setEnabled(bl);
        }
    }

    protected void init() {
        super.init();
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        this.mOkAction = new OkAction();
        this.mContinueAction = new ContinueAction();
        this.mResetAction = new ResetAction();
        this.mPasteAction = new PasteAction();
        boolean bl = VersionInfo.allowSyntax() && this.mMainDialog;
        this.continueButton = new JButton(this.mContinueAction);
        JButton jButton = new JButton(this.mResetAction);
        JButton jButton2 = new JButton(new CancelAction());
        JButton jButton3 = new JButton(new HelpAction());
        JButton jButton4 = new JButton(this.mPasteAction);
        DialogUtil.setupMacHelpButton(jButton3);
        Insets insets = DialogUtil.getStandardButtonInsets();
        if (UIToolDialogUtil.areCommandButtonsBelow()) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton3, gridBagConstraints, 0, 0, 1, 1, n2, null);
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                int n3 = 1;
                if (bl && CommonState.getApplicationType() == CommonState.AppType.STATISTICS) {
                    DialogUtil.addUsingGBL(jPanel, jButton4, gridBagConstraints, ++n3, 0, 1, 1, n2, insets2);
                }
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, ++n3, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, this.continueButton, gridBagConstraints, ++n3, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.continueButton);
                if (bl && CommonState.getApplicationType() == CommonState.AppType.STATISTICS) {
                    jPanel.add(jButton4);
                }
                jPanel.add(jButton);
                jPanel.add(jButton2);
                jPanel.add(jButton3);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(this.continueButton);
            if (bl) {
                jPanel.add(Box.createVerticalStrut(n));
                if (CommonState.getApplicationType() == CommonState.AppType.STATISTICS) {
                    jPanel.add(jButton4);
                }
            }
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton3);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.enableOk(false);
        this.getRootPane().setDefaultButton(this.continueButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    protected void saveStateToPref() {
        String string = this.getPreferenceName();
        HashMap<Object, Object> hashMap = this.getPreferenceValues();
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("export_options").node(string);
        Object[] objectArray = hashMap.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            String string2 = (String)objectArray[i];
            String string3 = (String)hashMap.get(string2);
            preferences2.put(string2, string3);
        }
    }

    protected HashMap<Object, Object> readPref() {
        String string = this.getPreferenceName();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("export_options").node(string);
        try {
            String[] stringArray = preferences2.keys();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = preferences2.get(string2, "");
                hashMap.put(string2, string3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return hashMap;
    }

    abstract String getPreferenceName();

    abstract HashMap<Object, Object> getPreferenceValues();

    abstract HashMap<Object, Object> getValuesToLoadSubDlg();

    abstract void loadStateFromPref(HashMap var1);

    abstract void updateDataStructure();

    abstract boolean exportData();

    abstract void reset();

    protected String generateSyntax() {
        return "";
    }

    private void setOkActionForContinue() {
        this.continueButton.setAction(this.mOkAction);
    }

    private void loadPanelAndCmdButton(boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (BaseExportDialog.this.isDisplayable()) {
                    HashMap<Object, Object> hashMap = BaseExportDialog.this.readPref();
                    BaseExportDialog.this.loadStateFromPref(hashMap);
                }
            }
        });
        if (bl) {
            this.setOkActionForContinue();
        }
    }

    private void loadPanelAndCmdButtonForSubDlg(boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (BaseExportDialog.this.isDisplayable()) {
                    HashMap<Object, Object> hashMap = BaseExportDialog.this.getValuesToLoadSubDlg();
                    BaseExportDialog.this.loadStateFromPref(hashMap);
                }
            }
        });
        if (bl) {
            this.setOkActionForContinue();
        }
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_HELP"));
            this.putValue("AcceleratorKey", 112);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BaseExportDialog.this.doHelp();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BaseExportDialog.this.dispose();
        }
    }

    class ResetAction
    extends AbstractAction {
        ResetAction() {
            String string = "IDS_RESET";
            this.putValue("Name", ResUtil.getCommonDlgString(string));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                string = string.replaceFirst("IDS_", "IDK_");
                this.putValue("MnemonicKey", ResUtil.getCommonDlgAccessKey(string));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BaseExportDialog.this.reset();
            BaseExportDialog.this.updateDataStructure();
        }
    }

    class PasteAction
    extends AbstractAction {
        PasteAction() {
            String string = "IDS_PASTE";
            this.putValue("Name", ResUtil.getCommonDlgString(string));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                string = string.replaceFirst("IDS_", "IDK_");
                this.putValue("MnemonicKey", ResUtil.getCommonDlgAccessKey(string));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (BaseExportDialog.this.okContinuePressed()) {
                BaseExportDialog.this.saveStateToPref();
                BaseExportDialog.this.updateDataStructure();
                BaseExportDialog.this.mGeneratedSyntax = BaseExportDialog.this.generateSyntax();
                if (BaseExportDialog.this.mGeneratedSyntax != null && BaseExportDialog.this.mGeneratedSyntax.length() > 0) {
                    SyntaxFrame syntaxFrame;
                    if (BaseExportDialog.this.mPasteExecuteSyntax && (syntaxFrame = (SyntaxFrame)SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.SYNTAX_DOC)) != null) {
                        BaseExportDialog.this.setVisible(false);
                        ISyntaxDocument iSyntaxDocument = (ISyntaxDocument)syntaxFrame.getCoreDocument();
                        iSyntaxDocument.pasteSyntax("\n" + BaseExportDialog.this.mGeneratedSyntax);
                    }
                } else {
                    ComponentState.trace1((String)"No syntax to execute in BaseProcedureDialog!", (int)15);
                }
                BaseExportDialog.this.dispose();
            }
        }
    }

    class ContinueAction
    extends AbstractAction {
        ContinueAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CONTINUE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (BaseExportDialog.this.okContinuePressed()) {
                BaseExportDialog.this.updateDataStructure();
                BaseExportDialog.this.dispose();
            }
        }
    }

    class OkAction
    extends AbstractAction {
        OkAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (BaseExportDialog.this.okContinuePressed()) {
                BaseExportDialog.this.saveStateToPref();
                BaseExportDialog.this.updateDataStructure();
                BaseExportDialog.this.dispose();
                BaseExportDialog.this.exportData();
            }
        }
    }
}

