/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.documents.output;

import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.documents.output.OutputItem;
import com.spss.java_client.core.resources.ComponentResBundle;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.doc_types.output.model_editor.ModelViewerFrame;
import com.spss.java_client.ui.interactive.JsonInteractiveFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.WindowsButtonGroup;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import com.spss.uitools.help.StatsHelp;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class PrintSettingDlg
extends BaseDialog
implements ItemListener,
ActionListener {
    private static ResourceBundle sBundle = ResUtil.getBundle("com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle", ResUtil.getLocale());
    private JRadioButton mPrintCurrentViewBtn;
    private JRadioButton mPrintAllViewsBtn;
    private OutputItem mOutputItem;
    private boolean mIncludeViewNum;
    private int mNumViews;
    private String mHelpId;
    private JButton mOkBtn;
    private JButton mCancelBtn;
    private JButton mHelpBtn;

    public PrintSettingDlg(JFrame jFrame) {
        this(jFrame, false);
    }

    public PrintSettingDlg(JFrame jFrame, boolean bl) {
        super(jFrame, "", true, ResUtil.getBundle(ComponentResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), "");
        this.setTitle(sBundle.getString("IDS_PRINT_SETTING_TITLE"));
        JPanel jPanel = this.getViewPanel();
        this.mIncludeViewNum = bl;
        this.addComponents(jPanel);
        this.pack();
        this.setResizable(true);
        this.setLocationRelativeTo(jFrame);
        this.setVisible(true);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.mOkBtn.setEnabled(true);
    }

    protected JPanel setupCmdButtonPanel() {
        return null;
    }

    private void addComponents(JPanel jPanel) {
        Serializable serializable;
        Object object;
        this.mPrintCurrentViewBtn = new JRadioButton(ResUtil.getString(sBundle, "IDS_PRINT_VISIBLE"));
        this.mPrintAllViewsBtn = new JRadioButton(ResUtil.getString(sBundle, "IDS_PRINT_ALL"));
        this.mPrintCurrentViewBtn.setMnemonic((Integer)ResUtil.getObject("IDS_PRINT_VISIBLE_KEY", sBundle));
        this.mPrintAllViewsBtn.setMnemonic((Integer)ResUtil.getObject("IDS_PRINT_ALL_KEY", sBundle));
        WindowsButtonGroup windowsButtonGroup = new WindowsButtonGroup();
        windowsButtonGroup.add(this.mPrintCurrentViewBtn);
        windowsButtonGroup.add(this.mPrintAllViewsBtn);
        this.mPrintCurrentViewBtn.setSelected(true);
        Container container = this.getParent();
        String string = null;
        if (container instanceof ModelViewerFrame) {
            this.mOutputItem = ((ModelViewerFrame)container).getModelItem();
            this.mHelpId = "idh_model_properties";
        } else if (container instanceof JsonInteractiveFrame) {
            this.mOutputItem = ((JsonInteractiveFrame)container).getJsonInteractiveItem();
            this.mNumViews = ((JsonInteractiveFrame)container).getViewCount();
            this.mHelpId = "idh_model_properties";
        }
        if (this.mOutputItem != null) {
            string = this.mOutputItem.getPrintSetting();
        }
        if (string != null && string.length() > 0) {
            if (string.equals("visible")) {
                this.mPrintCurrentViewBtn.setSelected(true);
            } else if (string.equals("all")) {
                this.mPrintAllViewsBtn.setSelected(true);
            }
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(ResUtil.getString(sBundle, "IDS_PRINT_SETTING")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        DialogUtil.addUsingGBL(jPanel2, this.mPrintCurrentViewBtn, gridBagConstraints, 0, 0, 1, 1, n, new Insets(5, 5, 5, 5));
        DialogUtil.addUsingGBL(jPanel2, this.mPrintAllViewsBtn, gridBagConstraints, 0, 1, 1, 1, n, new Insets(0, 5, 5, 5));
        if (this.mIncludeViewNum) {
            object = MessageFormat.format(ResUtil.getCommonDlgString("IDS_PRINT_NUM_VIEWS"), this.mNumViews);
            serializable = new JLabel((String)object);
            DialogUtil.addUsingGBL(jPanel2, serializable, gridBagConstraints, 0, 2, 1, 1, n, new Insets(0, 20, 5, 5));
        }
        gridBagConstraints.fill = 1;
        jPanel.setLayout(new GridBagLayout());
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, new Insets(0, 0, 0, 0));
        this.mOkBtn = new JButton(ResUtil.getCommonDlgString("IDS_PRINT_OK"));
        this.mCancelBtn = new JButton(ResUtil.getCommonDlgString("IDS_PRINT_CANCEL"));
        this.mHelpBtn = new JButton(ResUtil.getCommonDlgString("IDS_HELP"));
        object = new JPanel();
        ((Container)object).setLayout(new GridBagLayout());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        serializable = new Insets(4, 5, 4, 5);
        int n2 = OSCheck.getOSType() == OSInfo.OSType.MAC ? 1 : 0;
        int n3 = OSCheck.getOSType() == OSInfo.OSType.MAC ? 0 : 1;
        DialogUtil.addUsingGBL((Container)object, this.mOkBtn, gridBagConstraints, n2, 0, 1, 1, n, (Insets)serializable);
        DialogUtil.addUsingGBL((Container)object, this.mCancelBtn, gridBagConstraints, n3, 0, 1, 1, n, (Insets)serializable);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL((Container)object, this.mHelpBtn, gridBagConstraints, 2, 0, 1, 1, n, (Insets)serializable);
        UIToolDialogUtil.normalizeButtonWidths((JPanel)object);
        this.getRootPane().setDefaultButton(this.mOkBtn);
        DialogUtil.addUsingGBL(jPanel, (JComponent)object, gridBagConstraints, 0, 1, 1, 1, 26, (Insets)serializable);
        this.mPrintCurrentViewBtn.addItemListener(this);
        this.mPrintAllViewsBtn.addItemListener(this);
        this.mOkBtn.addActionListener(this);
        this.mCancelBtn.addActionListener(this);
        this.mHelpBtn.addActionListener(this);
    }

    protected boolean canBeRecalled() {
        return false;
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, this.mHelpId);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mOkBtn) {
            if (this.mPrintCurrentViewBtn.isSelected()) {
                this.mOutputItem.setPrintSetting("visible");
                this.dispose();
            } else if (this.mNumViews > 20) {
                String string = MessageFormat.format(ResUtil.getCommonDlgString("IDS_PRINT_NUM_ALERT"), this.mNumViews);
                int n = JOptionPane.showConfirmDialog(this.getParent(), string, ResUtil.getCommonDlgString("IDS_PRINT_SETTING_TITLE"), 0, 3);
                if (n == 0) {
                    this.mOutputItem.setPrintSetting("all");
                    this.dispose();
                } else {
                    this.mPrintCurrentViewBtn.setSelected(true);
                    this.mOutputItem.setPrintSetting("visible");
                }
            } else {
                this.mOutputItem.setPrintSetting("all");
                this.dispose();
            }
        } else if (object == this.mCancelBtn) {
            this.dispose();
        } else if (object == this.mHelpBtn) {
            this.doHelp();
        }
    }
}

