/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.documents.data;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.core.documents.data.dictionary.value_labels.SpssVLMapId;
import com.spss.java_client.core.documents.data.dictionary.value_labels.ValueLabelMap;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.VarViewTableModel;
import com.spss.java_client.ui.doc_types.data.undo.VarViewVariableTypeEdit;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.format.CellValueFormatter;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.SPSSTextField;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.util.IOptionConstants;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.text.Format;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class VariableTypeDlg
extends BaseDialog
implements ListSelectionListener,
DocumentListener {
    private static final String IDS_WKDAY9 = "Monday, Tuesday,...";
    private static final String IDS_WKDAY3 = "Mon, Tue, Wed,...";
    private static final String IDS_MONTH9 = "January, February,...";
    private static final String IDS_MONTH3 = "Jan, Feb, Mar,...";
    private static final String NUMERIC_RADIO_KEY = "IDS_NUMERIC_RADIO";
    private static final String COMMA_RADIO_KEY = "IDS_COMMA_RADIO";
    private static final String DOT_RADIO_KEY = "IDS_DOT_RADIO";
    private static final String SCIENTIFIC_RADIO_KEY = "IDS_SCI_RADIO";
    private static final String DATE_RADIO_KEY = "IDS_DATE_RADIO";
    private static final String DOLLAR_RADIO_KEY = "IDS_DOLLAR_RADIO";
    private static final String CUSTOM_CURRENCY_RADIO_KEY = "IDS_CUSTOM_RADIO";
    private static final String STRING_RADIO_KEY = "IDS_STRING_RADIO";
    private static final String RESTRICTED_NUMERIC_RADIO_KEY = "IDS_RESTRICTED_NUMERIC_RADIO";
    private static final String STANDARD_PANEL = "STD_PANEL";
    private static final String RESTRICTED_NUMERIC_PANEL = "RESTRICTED_NUMERIC_PANEL";
    private static final String DATE_PANEL = "DATE_PANEL";
    private static final String DOLLAR_PANEL = "DOLLAR_PANEL";
    private static final String CUSTOM_PANEL = "CUSTOM_PANEL";
    private static final String STRING_PANEL = "STRING_PANEL";
    private static final int MAX_WIDTH = 40;
    private static final int MAX_PRECISION = 16;
    private static final int NUM_CC_ITEMS = 5;
    private JList mDateList;
    private JList mDollarList;
    private JList mCCList;
    private JLabel mPosCCSample;
    private JLabel mNegCCSample;
    private JRadioButton mNumericRadio;
    private JRadioButton mCommaRadio;
    private JRadioButton mDotRadio;
    private JRadioButton mScientificRadio;
    private JRadioButton mDateRadio;
    private JRadioButton mDollarRadio;
    private JRadioButton mCCRadio;
    private JRadioButton mStringRadio;
    private JRadioButton mRestrictedNumericRadio;
    private IntTextField mStdWidthEdit;
    private IntTextField mResNumWidthEdit;
    private IntTextField mStdPrecisionEdit;
    private IntTextField mDollarWidthEdit;
    private IntTextField mDollarPrecisionEdit;
    private IntTextField mCCWidthEdit;
    private IntTextField mCCPrecisionEdit;
    private IntTextField mStringCharsEdit;
    private JButton mOkButton;
    private JButton mCancelButton;
    private JButton mHelpButton;
    private SpssButtonGroup mRadioGroup;
    private JTextArea mInfoTextArea;
    private JPanel mTypePanel;
    private JPanel mStandardPanel;
    private CardLayout mCardLayout;
    private String mLastRadioKey = "";
    private String mStrCachedWidth = "";
    private String mStrCachedPrecision = "";
    private ISpssVariable mVariable = null;
    private VarViewTableModel mTableModel = null;
    private int mRowIndex;
    private int mColumnIndex;
    private boolean mModalResult = false;
    private boolean mListAdjust = false;
    private Preferences mOptionsPrefs = null;
    private CustomCurrencyInfo[] mCurrencyInfo = new CustomCurrencyInfo[5];
    private CellValueFormatter mCCFormatter = new CellValueFormatter();
    private Vector<Object> mComponentOrder;

    public VariableTypeDlg(SpssFrame spssFrame, VarViewTableModel varViewTableModel, int n, int n2) {
        super((JFrame)spssFrame, ResUtil.getCommonDlgString("IDS_VARIABLE_TYPE"), true, ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), CommonDlgResBundle.getImageFolder());
        this.mTableModel = varViewTableModel;
        this.mRowIndex = n;
        this.mColumnIndex = n2;
        this.mVariable = varViewTableModel.getDataSource().getVariable(this.mRowIndex);
        if (this.mVariable == null) {
            this.mVariable = varViewTableModel.getDataSource().makeVariable(0, null);
        }
        this.loadData();
        this.pack();
        this.setLocationRelativeTo(spssFrame);
    }

    public boolean getModalResult() {
        return this.mModalResult;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting() || this.mListAdjust) {
            return;
        }
        int n = listSelectionEvent.getFirstIndex();
        if (n > -1) {
            if (listSelectionEvent.getSource() == this.mDollarList) {
                final Object e = this.mDollarList.getSelectedValue();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (e instanceof ListItem) {
                            VariableTypeDlg.this.mListAdjust = true;
                            SPSS_Format sPSS_Format = ((ListItem)e).mFormat;
                            VariableTypeDlg.this.mDollarWidthEdit.setText(String.format("%d", sPSS_Format.getWidth()));
                            VariableTypeDlg.this.mDollarPrecisionEdit.setText(String.format("%d", sPSS_Format.getDecimals()));
                            VariableTypeDlg.this.mListAdjust = false;
                        }
                    }
                });
            } else if (listSelectionEvent.getSource() == this.mCCList) {
                this.updateCCSamples();
            }
        } else assert (false);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.mDollarRadio.isSelected()) {
            this.selectDollarListItem();
        } else if (this.mCCRadio.isSelected()) {
            this.updateCCSamples();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.selectDollarListItem();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.selectDollarListItem();
    }

    private void selectDollarListItem() {
        if (this.mListAdjust) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VariableTypeDlg.this.mListAdjust = true;
                String string = VariableTypeDlg.this.mDollarWidthEdit.getText();
                String string2 = VariableTypeDlg.this.mDollarPrecisionEdit.getText();
                int n = string.length() > 0 ? Integer.valueOf(string) : 0;
                int n2 = string2.length() > 0 ? Integer.valueOf(string2) : 0;
                SPSS_Format sPSS_Format = new SPSS_Format(FormatType.DOLLAR, (short)n, (byte)n2);
                VariableTypeDlg.this.mDollarList.setValueIsAdjusting(true);
                DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)VariableTypeDlg.this.mDollarList.getSelectionModel();
                defaultListSelectionModel.clearSelection();
                VariableTypeDlg.this.mDollarList.setSelectedValue(new ListItem(sPSS_Format, ""), true);
                VariableTypeDlg.this.mDollarList.setValueIsAdjusting(false);
                VariableTypeDlg.this.mListAdjust = false;
            }
        });
    }

    private void updateCCSamples() {
        SPSS_Format sPSS_Format;
        String string = this.mCCWidthEdit.getText();
        String string2 = this.mCCPrecisionEdit.getText();
        Object e = this.mCCList.getSelectedValue();
        if (e instanceof ListItem && string.length() > 0) {
            sPSS_Format = ((ListItem)e).mFormat;
            if (string2.length() == 0) {
                string2 = "0";
            }
        } else {
            this.mPosCCSample.setText("");
            this.mNegCCSample.setText("");
            return;
        }
        sPSS_Format.setWidth(Short.valueOf(string).shortValue());
        sPSS_Format.setDecimals(Byte.valueOf(string2).byteValue());
        double d = 1.23456789E8 / Math.pow(10.0, sPSS_Format.getDecimals());
        CellValueFormatter.clearFormatCache();
        Format format = this.mCCFormatter.buildFormatter(sPSS_Format);
        this.mPosCCSample.setText(format.format(d));
        d = -d;
        this.mNegCCSample.setText(format.format(d));
    }

    private void switchControls(String string) {
        if (this.mLastRadioKey.equals(string)) {
            return;
        }
        if (string.equals(NUMERIC_RADIO_KEY) || string.equals(COMMA_RADIO_KEY) || string.equals(DOT_RADIO_KEY) || string.equals(SCIENTIFIC_RADIO_KEY)) {
            if (this.mLastRadioKey.equals(NUMERIC_RADIO_KEY) || this.mLastRadioKey.equals(COMMA_RADIO_KEY) || this.mLastRadioKey.equals(DOT_RADIO_KEY) || this.mLastRadioKey.equals(SCIENTIFIC_RADIO_KEY)) {
                this.mLastRadioKey = string;
                return;
            }
            this.mCardLayout.show(this.mTypePanel, STANDARD_PANEL);
        } else if (string.equals(RESTRICTED_NUMERIC_RADIO_KEY)) {
            this.mCardLayout.show(this.mTypePanel, RESTRICTED_NUMERIC_PANEL);
        } else if (string.equals(DATE_RADIO_KEY)) {
            this.mCardLayout.show(this.mTypePanel, DATE_PANEL);
        } else if (string.equals(DOLLAR_RADIO_KEY)) {
            this.mCardLayout.show(this.mTypePanel, DOLLAR_PANEL);
        } else if (string.equals(CUSTOM_CURRENCY_RADIO_KEY)) {
            this.mCardLayout.show(this.mTypePanel, CUSTOM_PANEL);
        } else if (string.equals(STRING_RADIO_KEY)) {
            this.mCardLayout.show(this.mTypePanel, STRING_PANEL);
        }
        this.saveIntValues();
        this.mLastRadioKey = string;
        this.putIntValues();
        this.setDialogTraversalPolicy();
    }

    private void setDialogTraversalPolicy() {
        this.mComponentOrder.clear();
        this.mComponentOrder.add(this.mRadioGroup);
        if (this.mLastRadioKey.equals(NUMERIC_RADIO_KEY) || this.mLastRadioKey.equals(DOT_RADIO_KEY) || this.mLastRadioKey.equals(SCIENTIFIC_RADIO_KEY) || this.mLastRadioKey.equals(COMMA_RADIO_KEY)) {
            this.mComponentOrder.add(this.mStdWidthEdit);
            this.mComponentOrder.add(this.mStdPrecisionEdit);
        } else if (this.mLastRadioKey.equals(DATE_RADIO_KEY)) {
            this.mComponentOrder.add(this.mDateList);
        } else if (this.mLastRadioKey.equals(DOLLAR_RADIO_KEY)) {
            this.mComponentOrder.add(this.mDollarList);
            this.mComponentOrder.add(this.mDollarWidthEdit);
            this.mComponentOrder.add(this.mDollarPrecisionEdit);
        } else if (this.mLastRadioKey.equals(CUSTOM_CURRENCY_RADIO_KEY)) {
            this.mComponentOrder.add(this.mCCList);
            this.mComponentOrder.add(this.mCCWidthEdit);
            this.mComponentOrder.add(this.mCCPrecisionEdit);
        } else if (this.mLastRadioKey.equals(STRING_RADIO_KEY)) {
            this.mComponentOrder.add(this.mStringCharsEdit);
        } else if (this.mLastRadioKey.equals(RESTRICTED_NUMERIC_RADIO_KEY)) {
            this.mComponentOrder.add(this.mResNumWidthEdit);
        }
        this.mComponentOrder.add(this.mOkButton);
        this.mComponentOrder.add(this.mCancelButton);
        this.mComponentOrder.add(this.mHelpButton);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.mComponentOrder, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void saveIntValues() {
        if (this.mLastRadioKey.length() == 0) {
            return;
        }
        if (this.mLastRadioKey.equals(NUMERIC_RADIO_KEY) || this.mLastRadioKey.equals(COMMA_RADIO_KEY) || this.mLastRadioKey.equals(DOT_RADIO_KEY) || this.mLastRadioKey.equals(SCIENTIFIC_RADIO_KEY)) {
            this.mStrCachedWidth = this.mStdWidthEdit.getText();
            this.mStrCachedPrecision = this.mStdPrecisionEdit.getText();
        } else if (this.mLastRadioKey.equals(RESTRICTED_NUMERIC_RADIO_KEY)) {
            this.mStrCachedWidth = this.mResNumWidthEdit.getText();
        } else if (this.mLastRadioKey.equals(DOLLAR_RADIO_KEY)) {
            this.mStrCachedWidth = this.mDollarWidthEdit.getText();
            this.mStrCachedPrecision = this.mDollarPrecisionEdit.getText();
        } else if (this.mLastRadioKey.equals(CUSTOM_CURRENCY_RADIO_KEY)) {
            this.mStrCachedWidth = this.mCCWidthEdit.getText();
            this.mStrCachedPrecision = this.mCCPrecisionEdit.getText();
        }
    }

    private void putIntValues() {
        if (this.mLastRadioKey.length() == 0) {
            return;
        }
        if (this.mLastRadioKey.equals(NUMERIC_RADIO_KEY) || this.mLastRadioKey.equals(COMMA_RADIO_KEY) || this.mLastRadioKey.equals(DOT_RADIO_KEY) || this.mLastRadioKey.equals(SCIENTIFIC_RADIO_KEY)) {
            this.mStdWidthEdit.setText(this.mStrCachedWidth);
            this.mStdPrecisionEdit.setText(this.mStrCachedPrecision);
        } else if (this.mLastRadioKey.equals(RESTRICTED_NUMERIC_RADIO_KEY)) {
            this.mResNumWidthEdit.setText(this.mStrCachedWidth);
        } else if (this.mLastRadioKey.equals(DOLLAR_RADIO_KEY)) {
            this.mDollarWidthEdit.setText(this.mStrCachedWidth);
            this.mDollarPrecisionEdit.setText(this.mStrCachedPrecision);
        } else if (this.mLastRadioKey.equals(CUSTOM_CURRENCY_RADIO_KEY)) {
            this.mCCPrecisionEdit.setText(this.mStrCachedPrecision);
            this.mCCWidthEdit.setText(this.mStrCachedWidth);
        }
    }

    private void loadData() {
        String string;
        if (this.mVariable == null) {
            return;
        }
        this.loadCustomCurrencyInfo();
        SPSS_Format sPSS_Format = this.mVariable.getFormat();
        FormatType formatType = sPSS_Format.getFormatType();
        this.mStrCachedWidth = String.format("%d", sPSS_Format.getWidth());
        this.mStrCachedPrecision = String.format("%d", sPSS_Format.getDecimals());
        this.mStringCharsEdit.setText(this.mStrCachedWidth);
        if (formatType.isDateOrTimeFormat()) {
            this.mLastRadioKey = DATE_RADIO_KEY;
            string = DATE_PANEL;
            this.mDateRadio.setSelected(true);
            this.mDateRadio.requestFocus();
            this.mDateList.setSelectedValue(new ListItem(sPSS_Format, ""), true);
        } else if (formatType.isStringFormat()) {
            this.mLastRadioKey = STRING_RADIO_KEY;
            string = STRING_PANEL;
            this.mStringRadio.setSelected(true);
            this.mStringRadio.requestFocus();
        } else if (formatType.isRestrictedNumericFormat()) {
            this.mLastRadioKey = RESTRICTED_NUMERIC_RADIO_KEY;
            string = RESTRICTED_NUMERIC_PANEL;
            this.mRestrictedNumericRadio.setSelected(true);
            this.mRestrictedNumericRadio.requestFocus();
            this.mResNumWidthEdit.setText(this.mStrCachedWidth);
        } else if (formatType.equals((Object)FormatType.DOLLAR)) {
            this.mLastRadioKey = DOLLAR_RADIO_KEY;
            string = DOLLAR_PANEL;
            this.mDollarRadio.setSelected(true);
            this.mDollarRadio.requestFocus();
            this.putIntValues();
            this.mDollarList.clearSelection();
            this.mDollarList.setSelectedValue(new ListItem(sPSS_Format, ""), true);
        } else if (formatType.isCurrencyFormat()) {
            this.mLastRadioKey = CUSTOM_CURRENCY_RADIO_KEY;
            string = CUSTOM_PANEL;
            this.mCCRadio.setSelected(true);
            this.mCCRadio.requestFocus();
            this.putIntValues();
            this.selectCCListItem(sPSS_Format.getFormatType());
            this.updateCCSamples();
        } else {
            if (formatType.equals((Object)FormatType.COMMA)) {
                this.mLastRadioKey = COMMA_RADIO_KEY;
                this.mCommaRadio.setSelected(true);
                this.mCommaRadio.requestFocus();
            } else if (formatType.equals((Object)FormatType.DOT)) {
                this.mLastRadioKey = DOT_RADIO_KEY;
                this.mDotRadio.setSelected(true);
                this.mDotRadio.requestFocus();
            } else if (formatType.equals((Object)FormatType.E)) {
                this.mLastRadioKey = SCIENTIFIC_RADIO_KEY;
                this.mScientificRadio.setSelected(true);
                this.mScientificRadio.requestFocus();
            } else {
                this.mLastRadioKey = NUMERIC_RADIO_KEY;
                this.mNumericRadio.setSelected(true);
                this.mNumericRadio.requestFocus();
            }
            string = STANDARD_PANEL;
            this.putIntValues();
        }
        this.mCardLayout.show(this.mTypePanel, string);
        this.setDialogTraversalPolicy();
    }

    private void selectCCListItem(FormatType formatType) {
        for (int i = 0; i < this.mCCList.getModel().getSize(); ++i) {
            ListItem listItem = (ListItem)this.mCCList.getModel().getElementAt(i);
            if (!listItem.mFormat.getFormatType().equals((Object)formatType)) continue;
            this.mCCList.setSelectedIndex(i);
            break;
        }
    }

    private boolean validateInput() {
        String string = "";
        IntTextField intTextField = null;
        this.saveIntValues();
        if (this.isLastFocusLostHadError()) {
            return false;
        }
        if (this.mLastRadioKey.equals(NUMERIC_RADIO_KEY) || this.mLastRadioKey.equals(COMMA_RADIO_KEY) || this.mLastRadioKey.equals(DOT_RADIO_KEY) || this.mLastRadioKey.equals(SCIENTIFIC_RADIO_KEY)) {
            int n;
            boolean bl = this.mLastRadioKey.equals(SCIENTIFIC_RADIO_KEY);
            int n2 = n = this.mStrCachedPrecision.length() > 0 ? Integer.valueOf(this.mStrCachedPrecision) : 0;
            if (this.mStrCachedWidth.length() == 0) {
                string = "ERR_ZERO_VAR_WIDTH_ERROR";
                intTextField = this.mStdWidthEdit;
            } else {
                int n3 = bl ? 6 : 1;
                int n4 = Integer.valueOf(this.mStrCachedWidth);
                if (n4 == 0) {
                    string = "ERR_ZERO_VAR_WIDTH_ERROR";
                    intTextField = this.mStdWidthEdit;
                } else if (n4 - n < n3) {
                    string = "ERR_SMALL_VAR_WIDTH_ERROR";
                    intTextField = this.mStdWidthEdit;
                }
            }
        } else if (this.mLastRadioKey.equals(RESTRICTED_NUMERIC_RADIO_KEY)) {
            if (this.mStrCachedWidth.length() == 0) {
                string = "ERR_ZERO_VAR_WIDTH_ERROR";
                intTextField = this.mResNumWidthEdit;
            } else {
                int n = Integer.valueOf(this.mStrCachedWidth);
                if (n <= 0 || n > 40) {
                    string = "ERR_INVALID_RESTRICTED_NUMERIC_WIDTH";
                    intTextField = this.mResNumWidthEdit;
                }
            }
        } else if (!this.mLastRadioKey.equals(DATE_RADIO_KEY)) {
            if (this.mLastRadioKey.equals(DOLLAR_RADIO_KEY)) {
                int n;
                int n5 = n = this.mStrCachedPrecision.length() > 0 ? Integer.valueOf(this.mStrCachedPrecision) : 0;
                if (this.mStrCachedWidth.length() == 0) {
                    string = "ERR_ZERO_VAR_WIDTH_ERROR";
                    intTextField = this.mDollarWidthEdit;
                } else {
                    int n6 = Integer.valueOf(this.mStrCachedWidth);
                    if (n6 == 0) {
                        string = "ERR_ZERO_VAR_WIDTH_ERROR";
                        intTextField = this.mStdWidthEdit;
                    } else if (n6 - n < 2) {
                        string = "ERR_DOLLAR_VAR_WIDTH_ERROR";
                        intTextField = this.mDollarWidthEdit;
                    }
                }
            } else if (this.mLastRadioKey.equals(CUSTOM_CURRENCY_RADIO_KEY)) {
                int n;
                int n7 = n = this.mStrCachedPrecision.length() > 0 ? Integer.valueOf(this.mStrCachedPrecision) : 0;
                if (this.mStrCachedWidth.length() == 0) {
                    string = "ERR_ZERO_VAR_WIDTH_ERROR";
                    intTextField = this.mCCWidthEdit;
                } else {
                    int n8 = Integer.valueOf(this.mStrCachedWidth);
                    if (n8 == 0) {
                        string = "ERR_ZERO_VAR_WIDTH_ERROR";
                        intTextField = this.mStdWidthEdit;
                    } else if (n8 - n < 1) {
                        string = "ERR_SMALL_VAR_WIDTH_ERROR";
                        intTextField = this.mCCWidthEdit;
                    }
                }
            } else if (this.mLastRadioKey.equals(STRING_RADIO_KEY)) {
                this.mStrCachedWidth = this.mStringCharsEdit.getText();
                if (this.mStrCachedWidth.length() == 0) {
                    string = "ERR_ZERO_VAR_WIDTH_ERROR";
                    intTextField = this.mStringCharsEdit;
                }
            }
        }
        if (string.length() > 0) {
            SPSSTextField.showWarningDialog((JComponent)this.mTypePanel, (String)ResUtil.getCommonDlgString(string), (String)VersionInfo.getAppVersionString());
            if (intTextField != null) {
                intTextField.requestFocus();
            }
            return false;
        }
        return true;
    }

    private SPSS_Format generateFormat() {
        int n;
        SPSS_Format sPSS_Format = null;
        int n2 = this.mStrCachedWidth.length() > 0 ? Integer.valueOf(this.mStrCachedWidth) : 0;
        int n3 = n = this.mStrCachedPrecision.length() > 0 ? Integer.valueOf(this.mStrCachedPrecision) : 0;
        if (this.mLastRadioKey.equals(NUMERIC_RADIO_KEY)) {
            sPSS_Format = new SPSS_Format(FormatType.F, (short)n2, (byte)n);
        } else if (this.mLastRadioKey.equals(COMMA_RADIO_KEY)) {
            sPSS_Format = new SPSS_Format(FormatType.COMMA, (short)n2, (byte)n);
        } else if (this.mLastRadioKey.equals(DOT_RADIO_KEY)) {
            sPSS_Format = new SPSS_Format(FormatType.DOT, (short)n2, (byte)n);
        } else if (this.mLastRadioKey.equals(SCIENTIFIC_RADIO_KEY)) {
            sPSS_Format = new SPSS_Format(FormatType.E, (short)n2, (byte)n);
        } else if (this.mLastRadioKey.equals(DATE_RADIO_KEY)) {
            Object e = this.mDateList.getSelectedValue();
            if (e instanceof ListItem) {
                sPSS_Format = ((ListItem)e).mFormat;
            }
        } else if (this.mLastRadioKey.equals(DOLLAR_RADIO_KEY)) {
            sPSS_Format = new SPSS_Format(FormatType.DOLLAR, (short)n2, (byte)n);
        } else if (this.mLastRadioKey.equals(CUSTOM_CURRENCY_RADIO_KEY)) {
            Object e = this.mCCList.getSelectedValue();
            if (e instanceof ListItem) {
                sPSS_Format = new SPSS_Format(((ListItem)e).mFormat.getFormatType(), (short)n2, (byte)n);
            }
        } else if (this.mLastRadioKey.equals(STRING_RADIO_KEY)) {
            sPSS_Format = new SPSS_Format(FormatType.A, (short)n2, 0);
        } else if (this.mLastRadioKey.equals(RESTRICTED_NUMERIC_RADIO_KEY)) {
            sPSS_Format = new SPSS_Format(FormatType.N, (short)n2, 0);
        }
        return sPSS_Format;
    }

    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        this.mComponentOrder = new Vector();
        this.mRadioGroup = new SpssButtonGroup();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, NUMERIC_RADIO_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VariableTypeDlg.this.switchControls(VariableTypeDlg.NUMERIC_RADIO_KEY);
            }
        };
        this.mNumericRadio = new JRadioButton(toggleButtonAction);
        DialogUtil.addUsingGBL(jPanel, this.mNumericRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mRadioGroup.add(this.mNumericRadio);
        ToggleButtonAction toggleButtonAction2 = new ToggleButtonAction(this, COMMA_RADIO_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VariableTypeDlg.this.switchControls(VariableTypeDlg.COMMA_RADIO_KEY);
            }
        };
        this.mCommaRadio = new JRadioButton(toggleButtonAction2);
        DialogUtil.addUsingGBL(jPanel, this.mCommaRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.mRadioGroup.add(this.mCommaRadio);
        ToggleButtonAction toggleButtonAction3 = new ToggleButtonAction(this, DOT_RADIO_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VariableTypeDlg.this.switchControls(VariableTypeDlg.DOT_RADIO_KEY);
            }
        };
        this.mDotRadio = new JRadioButton(toggleButtonAction3);
        DialogUtil.addUsingGBL(jPanel, this.mDotRadio, gridBagConstraints, 0, 2, 1, 1, n, insets);
        this.mRadioGroup.add(this.mDotRadio);
        ToggleButtonAction toggleButtonAction4 = new ToggleButtonAction(this, SCIENTIFIC_RADIO_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VariableTypeDlg.this.switchControls(VariableTypeDlg.SCIENTIFIC_RADIO_KEY);
            }
        };
        this.mScientificRadio = new JRadioButton(toggleButtonAction4);
        DialogUtil.addUsingGBL(jPanel, this.mScientificRadio, gridBagConstraints, 0, 3, 1, 1, n, insets);
        this.mRadioGroup.add(this.mScientificRadio);
        ToggleButtonAction toggleButtonAction5 = new ToggleButtonAction(this, DATE_RADIO_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VariableTypeDlg.this.switchControls(VariableTypeDlg.DATE_RADIO_KEY);
            }
        };
        this.mDateRadio = new JRadioButton(toggleButtonAction5);
        DialogUtil.addUsingGBL(jPanel, this.mDateRadio, gridBagConstraints, 0, 4, 1, 1, n, insets);
        this.mRadioGroup.add(this.mDateRadio);
        ToggleButtonAction toggleButtonAction6 = new ToggleButtonAction(this, DOLLAR_RADIO_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VariableTypeDlg.this.switchControls(VariableTypeDlg.DOLLAR_RADIO_KEY);
            }
        };
        this.mDollarRadio = new JRadioButton(toggleButtonAction6);
        DialogUtil.addUsingGBL(jPanel, this.mDollarRadio, gridBagConstraints, 0, 5, 1, 1, n, insets);
        this.mRadioGroup.add(this.mDollarRadio);
        ToggleButtonAction toggleButtonAction7 = new ToggleButtonAction(this, CUSTOM_CURRENCY_RADIO_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VariableTypeDlg.this.switchControls(VariableTypeDlg.CUSTOM_CURRENCY_RADIO_KEY);
            }
        };
        this.mCCRadio = new JRadioButton(toggleButtonAction7);
        DialogUtil.addUsingGBL(jPanel, this.mCCRadio, gridBagConstraints, 0, 6, 1, 1, n, insets);
        this.mRadioGroup.add(this.mCCRadio);
        ToggleButtonAction toggleButtonAction8 = new ToggleButtonAction(this, STRING_RADIO_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VariableTypeDlg.this.switchControls(VariableTypeDlg.STRING_RADIO_KEY);
            }
        };
        this.mStringRadio = new JRadioButton(toggleButtonAction8);
        DialogUtil.addUsingGBL(jPanel, this.mStringRadio, gridBagConstraints, 0, 7, 1, 1, n, insets);
        this.mRadioGroup.add(this.mStringRadio);
        ToggleButtonAction toggleButtonAction9 = new ToggleButtonAction(this, RESTRICTED_NUMERIC_RADIO_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VariableTypeDlg.this.switchControls(VariableTypeDlg.RESTRICTED_NUMERIC_RADIO_KEY);
            }
        };
        this.mRestrictedNumericRadio = new JRadioButton(toggleButtonAction9);
        DialogUtil.addUsingGBL(jPanel, this.mRestrictedNumericRadio, gridBagConstraints, 0, 8, 1, 1, n, insets);
        this.mRadioGroup.add(this.mRestrictedNumericRadio);
        JPanel jPanel2 = this.setupSubPanels();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 9, n, insets);
        JPanel jPanel3 = this.createInfoPanel();
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 10, 2, 1, n, new Insets(insets.top + 5, insets.left, insets.bottom, insets.right));
    }

    private JPanel createInfoPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.mInfoTextArea = new JTextArea(this.getResString("VAR_TYPE_DLG_INFO_TEXT"));
        this.mInfoTextArea.setEditable(false);
        this.mInfoTextArea.setOpaque(false);
        this.mInfoTextArea.setFocusable(false);
        this.mInfoTextArea.setWrapStyleWord(true);
        this.mInfoTextArea.setLineWrap(true);
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        JLabel jLabel = new JLabel();
        jLabel.setIcon(new ImageIcon(uRL));
        jPanel.add((Component)jLabel, "West");
        jPanel.add((Component)this.mInfoTextArea, "Center");
        return jPanel;
    }

    protected JPanel setupSubPanels() {
        this.mTypePanel = new JPanel(true);
        this.mCardLayout = new CardLayout();
        this.mTypePanel.setLayout(this.mCardLayout);
        this.mStandardPanel = this.setupStandardPanel();
        this.mTypePanel.add((Component)this.mStandardPanel, STANDARD_PANEL);
        JPanel jPanel = this.setupRestrictedNumericPanel();
        this.mTypePanel.add((Component)jPanel, RESTRICTED_NUMERIC_PANEL);
        JPanel jPanel2 = this.setupDatePanel();
        this.mTypePanel.add((Component)jPanel2, DATE_PANEL);
        JPanel jPanel3 = this.setupDollarPanel();
        this.mTypePanel.add((Component)jPanel3, DOLLAR_PANEL);
        JPanel jPanel4 = this.setupCustomPanel();
        this.mTypePanel.add((Component)jPanel4, CUSTOM_PANEL);
        JPanel jPanel5 = this.setupStringPanel();
        this.mTypePanel.add((Component)jPanel5, STRING_PANEL);
        return this.mTypePanel;
    }

    protected JPanel setupDatePanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        ListItem[] listItemArray = new ListItem[]{new ListItem(new SPSS_Format(FormatType.DATE, 11, 0), ResUtil.getCommonDlgString("IDS_DATE11")), new ListItem(new SPSS_Format(FormatType.DATE, 9, 0), ResUtil.getCommonDlgString("IDS_DATE9")), new ListItem(new SPSS_Format(FormatType.ADATE, 10, 0), ResUtil.getCommonDlgString("IDS_ADATE10")), new ListItem(new SPSS_Format(FormatType.ADATE, 8, 0), ResUtil.getCommonDlgString("IDS_ADATE8")), new ListItem(new SPSS_Format(FormatType.EDATE, 10, 0), ResUtil.getCommonDlgString("IDS_EDATE10")), new ListItem(new SPSS_Format(FormatType.EDATE, 8, 0), ResUtil.getCommonDlgString("IDS_EDATE8")), new ListItem(new SPSS_Format(FormatType.SDATE, 10, 0), ResUtil.getCommonDlgString("IDS_SDATE10")), new ListItem(new SPSS_Format(FormatType.SDATE, 8, 0), ResUtil.getCommonDlgString("IDS_SDATE8")), new ListItem(new SPSS_Format(FormatType.JDATE, 5, 0), ResUtil.getCommonDlgString("IDS_JDATE5")), new ListItem(new SPSS_Format(FormatType.JDATE, 7, 0), ResUtil.getCommonDlgString("IDS_JDATE7")), new ListItem(new SPSS_Format(FormatType.QYR, 8, 0), ResUtil.getCommonDlgString("IDS_QYR8")), new ListItem(new SPSS_Format(FormatType.QYR, 6, 0), ResUtil.getCommonDlgString("IDS_QYR6")), new ListItem(new SPSS_Format(FormatType.MOYR, 8, 0), ResUtil.getCommonDlgString("IDS_MOYR8")), new ListItem(new SPSS_Format(FormatType.MOYR, 6, 0), ResUtil.getCommonDlgString("IDS_MOYR6")), new ListItem(new SPSS_Format(FormatType.WKYR, 10, 0), ResUtil.getCommonDlgString("IDS_WKYR10")), new ListItem(new SPSS_Format(FormatType.WKYR, 8, 0), ResUtil.getCommonDlgString("IDS_WKYR8")), new ListItem(new SPSS_Format(FormatType.DATETIME, 17, 0), ResUtil.getCommonDlgString("IDS_DATETIME17")), new ListItem(new SPSS_Format(FormatType.DATETIME, 20, 0), ResUtil.getCommonDlgString("IDS_DATETIME20")), new ListItem(new SPSS_Format(FormatType.DATETIME, 23, 2), ResUtil.getCommonDlgString("IDS_DATETIME23_2")), new ListItem(new SPSS_Format(FormatType.YMDHMS, 16, 0), ResUtil.getCommonDlgString("IDS_YMDHMS16")), new ListItem(new SPSS_Format(FormatType.YMDHMS, 19, 0), ResUtil.getCommonDlgString("IDS_YMDHMS19")), new ListItem(new SPSS_Format(FormatType.YMDHMS, 22, 2), ResUtil.getCommonDlgString("IDS_YMDHMS22_2")), new ListItem(new SPSS_Format(FormatType.MTIME, 5, 0), ResUtil.getCommonDlgString("IDS_MTIME5")), new ListItem(new SPSS_Format(FormatType.MTIME, 8, 2), ResUtil.getCommonDlgString("IDS_MTIME8_2")), new ListItem(new SPSS_Format(FormatType.TIME, 5, 0), ResUtil.getCommonDlgString("IDS_TIME5")), new ListItem(new SPSS_Format(FormatType.TIME, 8, 0), ResUtil.getCommonDlgString("IDS_TIME8")), new ListItem(new SPSS_Format(FormatType.TIME, 11, 2), ResUtil.getCommonDlgString("IDS_TIME11_2")), new ListItem(new SPSS_Format(FormatType.DTIME, 9, 0), ResUtil.getCommonDlgString("IDS_DTIME9")), new ListItem(new SPSS_Format(FormatType.DTIME, 12, 0), ResUtil.getCommonDlgString("IDS_DTIME12")), new ListItem(new SPSS_Format(FormatType.DTIME, 15, 2), ResUtil.getCommonDlgString("IDS_DTIME15_2")), new ListItem(new SPSS_Format(FormatType.WKDAY, 9, 0), IDS_WKDAY9), new ListItem(new SPSS_Format(FormatType.WKDAY, 3, 0), IDS_WKDAY3), new ListItem(new SPSS_Format(FormatType.MONTH, 9, 0), IDS_MONTH9), new ListItem(new SPSS_Format(FormatType.MONTH, 3, 0), IDS_MONTH3)};
        this.mDateList = new JList<ListItem>(listItemArray);
        this.mDateList.setSelectionMode(0);
        this.mDateList.setSelectedIndex(0);
        DialogUtil.addUsingGBL(jPanel, new JScrollPane(this.mDateList), gridBagConstraints, 0, 0, 1, 1, n, insets);
        return jPanel;
    }

    protected JPanel setupDollarPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top + 2, insets.left, insets.bottom + 2, insets.right);
        int n = 23;
        ListItem[] listItemArray = new ListItem[]{new ListItem(new SPSS_Format(FormatType.DOLLAR, 2, 0), ResUtil.getCommonDlgString("IDS_DOLLAR2")), new ListItem(new SPSS_Format(FormatType.DOLLAR, 3, 0), ResUtil.getCommonDlgString("IDS_DOLLAR3")), new ListItem(new SPSS_Format(FormatType.DOLLAR, 4, 0), ResUtil.getCommonDlgString("IDS_DOLLAR4")), new ListItem(new SPSS_Format(FormatType.DOLLAR, 7, 2), ResUtil.getCommonDlgString("IDS_DOLLAR7_2")), new ListItem(new SPSS_Format(FormatType.DOLLAR, 6, 0), ResUtil.getCommonDlgString("IDS_DOLLAR6")), new ListItem(new SPSS_Format(FormatType.DOLLAR, 9, 2), ResUtil.getCommonDlgString("IDS_DOLLAR9_2")), new ListItem(new SPSS_Format(FormatType.DOLLAR, 8, 0), ResUtil.getCommonDlgString("IDS_DOLLAR8")), new ListItem(new SPSS_Format(FormatType.DOLLAR, 11, 2), ResUtil.getCommonDlgString("IDS_DOLLAR11_2")), new ListItem(new SPSS_Format(FormatType.DOLLAR, 12, 0), ResUtil.getCommonDlgString("IDS_DOLLAR12")), new ListItem(new SPSS_Format(FormatType.DOLLAR, 15, 2), ResUtil.getCommonDlgString("IDS_DOLLAR15_2")), new ListItem(new SPSS_Format(FormatType.DOLLAR, 16, 0), ResUtil.getCommonDlgString("IDS_DOLLAR16")), new ListItem(new SPSS_Format(FormatType.DOLLAR, 19, 2), ResUtil.getCommonDlgString("IDS_DOLLAR19_2"))};
        this.mDollarList = new JList<ListItem>(listItemArray);
        this.mDollarList.setSelectionMode(0);
        this.mDollarList.setSelectedIndex(0);
        DialogUtil.addUsingGBL(jPanel, new JScrollPane(this.mDollarList), gridBagConstraints, 0, 0, 2, 1, n, insets2);
        this.mDollarList.addListSelectionListener(this);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        JLabel jLabel = new JLabel(ResUtil.getCommonDlgString("IDS_WIDTH_COLON"));
        jLabel.setDisplayedMnemonic(this.getDlgAccessKey("IDK_WIDTH_COLON_KEY"));
        jLabel.setHorizontalAlignment(11);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        this.mDollarWidthEdit = new IntTextField(0, 40, true);
        Insets insets3 = this.mDollarWidthEdit.getMargin();
        if (insets3.left < 2) {
            insets3.left = 2;
            this.mDollarWidthEdit.setMargin(insets3);
        }
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mDollarWidthEdit, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        jLabel.setLabelFor((Component)this.mDollarWidthEdit);
        this.mDollarWidthEdit.getDocument().addDocumentListener(this);
        gridBagConstraints.weighty = 0.0;
        JLabel jLabel2 = new JLabel(ResUtil.getCommonDlgString("IDS_DECIMALS_COLON"));
        jLabel2.setDisplayedMnemonic(this.getDlgAccessKey("IDK_DECIMALS_COLON_KEY"));
        jLabel2.setHorizontalAlignment(11);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        this.mDollarPrecisionEdit = new IntTextField(0, 16, true);
        insets3 = this.mDollarPrecisionEdit.getMargin();
        if (insets3.left < 2) {
            insets3.left = 2;
            this.mDollarPrecisionEdit.setMargin(insets3);
        }
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mDollarPrecisionEdit, gridBagConstraints, 1, 2, 1, 1, n, insets2);
        jLabel2.setLabelFor((Component)this.mDollarPrecisionEdit);
        this.mDollarPrecisionEdit.getDocument().addDocumentListener(this);
        return jPanel;
    }

    protected JPanel setupCustomPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top + 2, insets.left, insets.bottom + 2, insets.right + 1);
        int n = 23;
        ListItem[] listItemArray = new ListItem[]{new ListItem(new SPSS_Format(FormatType.CCA, 10, 2), ResUtil.getCommonDlgString("IDS_CCA")), new ListItem(new SPSS_Format(FormatType.CCB, 10, 2), ResUtil.getCommonDlgString("IDS_CCB")), new ListItem(new SPSS_Format(FormatType.CCC, 10, 2), ResUtil.getCommonDlgString("IDS_CCC")), new ListItem(new SPSS_Format(FormatType.CCD, 10, 2), ResUtil.getCommonDlgString("IDS_CCD")), new ListItem(new SPSS_Format(FormatType.CCE, 10, 2), ResUtil.getCommonDlgString("IDS_CCE"))};
        this.mCCList = new JList<ListItem>(listItemArray);
        this.mCCList.setSelectionMode(0);
        this.mCCList.setSelectedIndex(0);
        LookAndFeel.installBorder(this.mCCList, "ScrollPane.border");
        Insets insets3 = new Insets(insets.top + 9, insets.left + 5, insets.bottom + 2, insets.right + 3);
        DialogUtil.addUsingGBL(jPanel, this.mCCList, gridBagConstraints, 0, 0, 1, 1, n, insets3);
        this.mCCList.addListSelectionListener(this);
        JPanel jPanel2 = new JPanel(true);
        jPanel2.setLayout(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(ResUtil.getCommonDlgString("IDS_SAMPLE"));
        jPanel2.setBorder(titledBorder);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets4 = new Insets(insets.top, insets.left + 2, insets.bottom + 4, insets.right);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 0, 3, 1, n, insets4);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        JLabel jLabel = new JLabel(" ");
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mPosCCSample = new JLabel(" ");
        DialogUtil.addUsingGBL(jPanel2, this.mPosCCSample, gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.mPosCCSample.setHorizontalAlignment(0);
        jLabel = new JLabel(" ");
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        this.mNegCCSample = new JLabel(" ");
        DialogUtil.addUsingGBL(jPanel2, this.mNegCCSample, gridBagConstraints, 0, 3, 1, 1, n, insets);
        this.mNegCCSample.setHorizontalAlignment(0);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        JLabel jLabel2 = new JLabel(ResUtil.getCommonDlgString("IDS_WIDTH_COLON"));
        jLabel2.setDisplayedMnemonic(this.getDlgAccessKey("IDK_WIDTH_COLON_KEY"));
        jLabel2.setHorizontalAlignment(11);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 3, 1, n, insets2);
        this.mCCWidthEdit = new IntTextField(0, 40, true);
        Insets insets5 = this.mCCWidthEdit.getMargin();
        if (insets5.left < 2) {
            insets5.left = 2;
            this.mCCWidthEdit.setMargin(insets5);
        }
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mCCWidthEdit, gridBagConstraints, 3, 1, 1, 1, n, insets2);
        jLabel2.setLabelFor((Component)this.mCCWidthEdit);
        JLabel jLabel3 = new JLabel(ResUtil.getCommonDlgString("IDS_DECIMALS_COLON"));
        jLabel3.setDisplayedMnemonic(this.getDlgAccessKey("IDK_DECIMALS_COLON_KEY"));
        jLabel3.setHorizontalAlignment(11);
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 0, 2, 3, 1, n, insets2);
        this.mCCPrecisionEdit = new IntTextField(0, 16, true);
        insets5 = this.mCCPrecisionEdit.getMargin();
        if (insets5.left < 2) {
            insets5.left = 2;
            this.mCCPrecisionEdit.setMargin(insets5);
        }
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mCCPrecisionEdit, gridBagConstraints, 3, 2, 1, 1, n, insets2);
        jLabel3.setLabelFor((Component)this.mCCPrecisionEdit);
        this.mCCWidthEdit.getDocument().addDocumentListener(this);
        this.mCCPrecisionEdit.getDocument().addDocumentListener(this);
        return jPanel;
    }

    private void loadCustomCurrencyInfo() {
        String[] stringArray = new String[]{"cca", "ccb", "ccc", "ccd", "cce"};
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        this.mOptionsPrefs = preferences.node("options");
        for (int i = 0; i < 5; ++i) {
            String string = this.getPrefsSubValue("currency", stringArray[i], "decimal_separator", PrefDefaults.DEF_CURRENCY_SEPARATOR);
            boolean bl = string.equals(IOptionConstants.CUSTOM_OUTPUT_FORMAT_SEPARATOR_VALUES[1]);
            CustomCurrencyInfo customCurrencyInfo = new CustomCurrencyInfo();
            customCurrencyInfo.mDecimal = (char)(bl ? 44 : 46);
            customCurrencyInfo.mNegPrefix = this.getPrefsSubValue("currency", stringArray[i], "neg_val_prefix", "-");
            customCurrencyInfo.mNegSuffix = this.getPrefsSubValue("currency", stringArray[i], "neg_val_suffix", " ");
            customCurrencyInfo.mAllPrefix = this.getPrefsSubValue("currency", stringArray[i], "all_val_prefix", "");
            customCurrencyInfo.mAllSuffix = this.getPrefsSubValue("currency", stringArray[i], "all_val_suffix", "");
            this.mCurrencyInfo[i] = customCurrencyInfo;
        }
    }

    protected String getPrefsSubValue(String string, String string2, String string3, String string4) {
        Preferences preferences;
        if (this.mOptionsPrefs == null) {
            preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
            this.mOptionsPrefs = preferences.node("options");
        }
        preferences = this.mOptionsPrefs.node(string);
        preferences = preferences.node(string2);
        return preferences.get(string3, string4);
    }

    protected JPanel setupStringPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top + 2, insets.left, insets.bottom + 2, insets.right);
        int n = 23;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        JLabel jLabel = new JLabel(" ");
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        JLabel jLabel2 = new JLabel(ResUtil.getCommonDlgString("IDS_CHARS_COLON"));
        jLabel2.setDisplayedMnemonic(this.getDlgAccessKey("IDK_CHARS_COLON_KEY"));
        jLabel2.setHorizontalAlignment(11);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        this.mStringCharsEdit = new IntTextField(1, Short.MAX_VALUE, true);
        Insets insets3 = this.mStringCharsEdit.getMargin();
        if (insets3.left < 2) {
            insets3.left = 2;
            this.mStringCharsEdit.setMargin(insets3);
        }
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mStringCharsEdit, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        jLabel2.setLabelFor((Component)this.mStringCharsEdit);
        return jPanel;
    }

    protected JPanel setupStandardPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top + 2, insets.left, insets.bottom + 2, insets.right);
        int n = 23;
        gridBagConstraints.weighty = 0.0;
        JLabel jLabel = new JLabel(" ");
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        JLabel jLabel2 = new JLabel(ResUtil.getCommonDlgString("IDS_WIDTH_COLON"));
        jLabel2.setDisplayedMnemonic(this.getDlgAccessKey("IDK_WIDTH_COLON_KEY"));
        jLabel2.setHorizontalAlignment(11);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        this.mStdWidthEdit = new IntTextField(0, 40, true);
        Insets insets3 = this.mStdWidthEdit.getMargin();
        if (insets3.left < 2) {
            insets3.left = 2;
            this.mStdWidthEdit.setMargin(insets3);
        }
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mStdWidthEdit, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        jLabel2.setLabelFor((Component)this.mStdWidthEdit);
        gridBagConstraints.weightx = 0.0;
        JLabel jLabel3 = new JLabel(ResUtil.getCommonDlgString("IDS_DECIMALS_COLON"));
        jLabel3.setDisplayedMnemonic(this.getDlgAccessKey("IDK_DECIMALS_COLON_KEY"));
        jLabel3.setHorizontalAlignment(11);
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        this.mStdPrecisionEdit = new IntTextField(0, 16, true);
        insets3 = this.mStdPrecisionEdit.getMargin();
        if (insets3.left < 2) {
            insets3.left = 2;
            this.mStdPrecisionEdit.setMargin(insets3);
        }
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mStdPrecisionEdit, gridBagConstraints, 1, 2, 1, 1, n, insets2);
        jLabel3.setLabelFor((Component)this.mStdPrecisionEdit);
        return jPanel;
    }

    protected JPanel setupRestrictedNumericPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top + 2, insets.left, insets.bottom + 2, insets.right);
        int n = 23;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        JLabel jLabel = new JLabel(" ");
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        JLabel jLabel2 = new JLabel(ResUtil.getCommonDlgString("IDS_WIDTH_COLON"));
        jLabel2.setDisplayedMnemonic(this.getDlgAccessKey("IDK_WIDTH_COLON_KEY"));
        jLabel2.setHorizontalAlignment(11);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        this.mResNumWidthEdit = new IntTextField(1, Short.MAX_VALUE, true);
        Insets insets3 = this.mResNumWidthEdit.getMargin();
        if (insets3.left < 2) {
            insets3.left = 2;
            this.mResNumWidthEdit.setMargin(insets3);
        }
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mResNumWidthEdit, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        jLabel2.setLabelFor((Component)this.mResNumWidthEdit);
        return jPanel;
    }

    protected JPanel setupCmdButtonPanel() {
        int n;
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        this.mOkButton = new JButton(new OkAction());
        this.mCancelButton = new JButton(new CancelAction());
        this.mHelpButton = new JButton(new HelpAction());
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, this.mHelpButton, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, this.mCancelButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, this.mOkButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mOkButton);
                jPanel.add(this.mCancelButton);
                jPanel.add(this.mHelpButton);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(this.mOkButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(this.mCancelButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(this.mHelpButton);
            jPanel.add(Box.createVerticalStrut(n));
        }
        Insets insets3 = this.mCancelButton.getMargin();
        if (insets3.left == 0 && insets3.right == 0) {
            insets3 = (Insets)insets3.clone();
            insets3.left = 2;
            this.mOkButton.setMargin(insets3);
            this.mCancelButton.setMargin(insets3);
            this.mHelpButton.setMargin(insets3);
        }
        this.getRootPane().setDefaultButton(this.mOkButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "IDH_DEFVAR_TYPE");
    }

    public boolean isLastFocusLostHadError() {
        boolean bl = false;
        if (this.mStdWidthEdit.isLastFocusLostHadError() || this.mResNumWidthEdit.isLastFocusLostHadError() || this.mStdPrecisionEdit.isLastFocusLostHadError() || this.mDollarWidthEdit.isLastFocusLostHadError() || this.mDollarPrecisionEdit.isLastFocusLostHadError() || this.mCCWidthEdit.isLastFocusLostHadError() || this.mCCPrecisionEdit.isLastFocusLostHadError() || this.mStringCharsEdit.isLastFocusLostHadError()) {
            bl = true;
        }
        return bl;
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            VariableTypeDlg.this.doHelp();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            VariableTypeDlg.this.dispose();
        }
    }

    class OkAction
    extends AbstractAction {
        OkAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            if (!VariableTypeDlg.this.validateInput()) {
                return;
            }
            short s = 0;
            if (VariableTypeDlg.this.mStringRadio.isSelected()) {
                object = VariableTypeDlg.this.mStringCharsEdit.getText();
                s = Short.valueOf((String)object);
            }
            object = VariableTypeDlg.this.generateFormat();
            if (ComponentState.isBtdRtlOrLtr() && VariableTypeDlg.this.mStringRadio.isSelected()) {
                VariableTypeDlg.this.mTableModel.addVariable(VariableTypeDlg.this.mRowIndex, s, null);
            } else {
                VariableTypeDlg.this.mTableModel.addVariable(VariableTypeDlg.this.mRowIndex, 0, null);
            }
            VariableTypeDlg.this.mVariable = VariableTypeDlg.this.mTableModel.getDataSource().getVariable(VariableTypeDlg.this.mRowIndex);
            boolean bl = true;
            if (s != 0 && VariableTypeDlg.this.mVariable.getType() == 0 || s == 0 && VariableTypeDlg.this.mVariable.getType() != 0) {
                IValueLabelMap iValueLabelMap = VariableTypeDlg.this.mVariable.getValueLabels();
                OBS oBS = new OBS();
                OBS oBS2 = new OBS();
                OBS oBS3 = new OBS();
                ISpssVariable.Rule rule = VariableTypeDlg.this.mVariable.getMissingValues(oBS, oBS2, oBS3);
                if (iValueLabelMap != null && iValueLabelMap.size() > 0 || !rule.equals((Object)ISpssVariable.Rule.none)) {
                    Toolkit.getDefaultToolkit().beep();
                    int n = JOptionPane.showConfirmDialog(VariableTypeDlg.this.mTableModel.getUndoManager().getSpssFrame(), String.format(ResUtil.getString("ERR_CLEAR_SPECIFICATIONS_WARNING"), VariableTypeDlg.this.mVariable.getName()), VersionInfo.getAppVersionString(), 2, 3);
                    if (n == 0) {
                        if (s == 0 && VariableTypeDlg.this.mVariable.getType() != 0) {
                            if (iValueLabelMap != null && iValueLabelMap.size() > 0) {
                                HashMap hashMap = new HashMap();
                                Set set = iValueLabelMap.getValueLabelEntries();
                                for (Map.Entry entry : set) {
                                    OBS oBS4 = CellValueFormatter.stringObsToObs((OBS)((OBS)entry.getKey()), (SPSS_Format)object);
                                    if (oBS4 == null) continue;
                                    hashMap.put(oBS4, entry.getValue());
                                }
                                ValueLabelMap valueLabelMap = new ValueLabelMap(SpssVLMapId.next(), hashMap);
                                VariableTypeDlg.this.mVariable.setValueLabels((IValueLabelMap)valueLabelMap);
                            }
                            if (!rule.equals((Object)ISpssVariable.Rule.none)) {
                                rule = ISpssVariable.Rule.none;
                                if (CellValueFormatter.stringObsToObs((OBS)oBS, (SPSS_Format)object) != null) {
                                    rule = ISpssVariable.Rule.one;
                                    if (CellValueFormatter.stringObsToObs((OBS)oBS2, (SPSS_Format)object) != null) {
                                        rule = ISpssVariable.Rule.two;
                                        if (CellValueFormatter.stringObsToObs((OBS)oBS3, (SPSS_Format)object) != null) {
                                            rule = ISpssVariable.Rule.three;
                                        }
                                    }
                                }
                                VariableTypeDlg.this.mVariable.setMissingValues(rule, CellValueFormatter.stringObsToObs((OBS)oBS, (SPSS_Format)object), CellValueFormatter.stringObsToObs((OBS)oBS2, (SPSS_Format)object), CellValueFormatter.stringObsToObs((OBS)oBS3, (SPSS_Format)object));
                            }
                        } else if (s != 0 && VariableTypeDlg.this.mVariable.getType() == 0) {
                            if (iValueLabelMap != null && iValueLabelMap.size() > 0) {
                                HashMap hashMap = new HashMap();
                                Set set = iValueLabelMap.getValueLabelEntries();
                                for (Map.Entry entry : set) {
                                    hashMap.put(CellValueFormatter.obsToStringObs((OBS)((OBS)entry.getKey()), (SPSS_Format)VariableTypeDlg.this.mVariable.getFormat()), entry.getValue());
                                }
                                ValueLabelMap valueLabelMap = new ValueLabelMap(SpssVLMapId.next(), hashMap);
                                VariableTypeDlg.this.mVariable.setValueLabels((IValueLabelMap)valueLabelMap);
                            }
                            if (!rule.equals((Object)ISpssVariable.Rule.none)) {
                                if (s <= 8 && !rule.equals((Object)ISpssVariable.Rule.range) && !rule.equals((Object)ISpssVariable.Rule.range_plus)) {
                                    VariableTypeDlg.this.mVariable.setMissingValues(rule, CellValueFormatter.obsToStringObs((OBS)oBS, (SPSS_Format)VariableTypeDlg.this.mVariable.getFormat()), CellValueFormatter.obsToStringObs((OBS)oBS2, (SPSS_Format)VariableTypeDlg.this.mVariable.getFormat()), CellValueFormatter.obsToStringObs((OBS)oBS3, (SPSS_Format)VariableTypeDlg.this.mVariable.getFormat()));
                                } else {
                                    VariableTypeDlg.this.mVariable.setMissingValues(ISpssVariable.Rule.none, null, null, null);
                                }
                            }
                        }
                    } else {
                        bl = false;
                    }
                }
            }
            if (bl) {
                new VarViewVariableTypeEdit(VariableTypeDlg.this.mTableModel, s, (SPSS_Format)object, VariableTypeDlg.this.mRowIndex, VariableTypeDlg.this.mColumnIndex);
                VariableTypeDlg.this.mModalResult = true;
                VariableTypeDlg.this.dispose();
            }
        }
    }

    class CustomCurrencyInfo {
        public char mDecimal = (char)46;
        public String mAllPrefix = "";
        public String mAllSuffix = "";
        public String mNegPrefix = "";
        public String mNegSuffix = "";

        CustomCurrencyInfo() {
        }
    }

    class ListItem {
        SPSS_Format mFormat;
        String mUserText;

        ListItem(SPSS_Format sPSS_Format, String string) {
            this.mFormat = sPSS_Format;
            this.mUserText = string;
        }

        public String toString() {
            return this.mUserText;
        }

        public boolean equals(Object object) {
            return object instanceof ListItem && ((ListItem)object).mFormat.equals((Object)this.mFormat);
        }
    }
}

