/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.documents.data;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.ui.controls.BasicACREvent;
import com.spss.java_client.ui.controls.BasicACRWidget;
import com.spss.java_client.ui.controls.IBasicACRListener;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.base.utilities.spell_check.SpellingDlg;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.dialogs.documents.data.ValueLabelHolder;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.VarViewTableModel;
import com.spss.java_client.ui.doc_types.data.undo.VarViewValueLabelsEdit;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.format.CellValueFormatter;
import com.spss.shared.core_tools.format.ValueFormatter;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.ContextEnabledTextField;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class ValueLabelsDlg
extends BaseDialog
implements IBasicACRListener,
DocumentListener,
KeyListener {
    private int MAX_LABEL_LEN = 120;
    private ContextEnabledTextField mValueEdit;
    private StringTextField mLabelEdit;
    private BasicACRWidget mACRWidget;
    private ISpssVariable mVariable = null;
    private SPSS_Format mVarFormat = null;
    private VarViewTableModel mTableModel = null;
    private int mRowIndex;
    private int mColumnIndex;
    private boolean mModalResult = false;
    private ValueLabelsSpellCheckDlg mSpellCheckDlg;

    public ValueLabelsDlg(SpssFrame spssFrame, VarViewTableModel varViewTableModel, int n, int n2) {
        super((JFrame)spssFrame, ResUtil.getCommonDlgString("IDS_VALUE_LABELS"), true, ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), CommonDlgResBundle.getImageFolder());
        this.mTableModel = varViewTableModel;
        this.mRowIndex = n;
        this.mColumnIndex = n2;
        this.mVariable = varViewTableModel.getDataSource().getVariable(this.mRowIndex);
        if (this.mVariable == null) {
            this.mVariable = varViewTableModel.getDataSource().makeVariable(0, null);
        }
        this.mVarFormat = this.mVariable.getFormat();
        this.loadData();
        this.pack();
        this.setLocationRelativeTo(spssFrame);
        this.enableControls();
    }

    public boolean getModalResult() {
        return this.mModalResult;
    }

    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        JPanel jPanel2 = new JPanel(true);
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.setBorder(new TitledBorder(ResUtil.getCommonDlgString("IDS_VALUE_LABELS")));
        JPanel jPanel3 = new JPanel(true);
        jPanel3.setLayout(new GridBagLayout());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel2, jPanel3, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        Insets insets2 = new Insets(insets.top + 2, insets.left, insets.bottom + 1, insets.right);
        JLabel jLabel = new JLabel(ResUtil.getCommonDlgString("IDS_VALUE"));
        jLabel.setDisplayedMnemonic(this.getDlgAccessKey("IDK_VALUE_KEY"));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel3, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        this.mValueEdit = new ContextEnabledTextField();
        gridBagConstraints.weightx = 0.4;
        DialogUtil.addUsingGBL(jPanel3, (JComponent)this.mValueEdit, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        jLabel.setLabelFor((Component)this.mValueEdit);
        gridBagConstraints.weightx = 0.6;
        DialogUtil.addUsingGBL(jPanel3, new JLabel("      "), gridBagConstraints, 2, 0, 1, 1, n, insets2);
        n = 23;
        gridBagConstraints.fill = 2;
        JLabel jLabel2 = new JLabel(ResUtil.getCommonDlgString("IDS_LABEL"));
        jLabel2.setDisplayedMnemonic(this.getDlgAccessKey("IDK_LABEL_KEY"));
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel3, jLabel2, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        this.mLabelEdit = new StringTextField();
        this.mLabelEdit.addKeyListener(this);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel3, (JComponent)((Object)this.mLabelEdit), gridBagConstraints, 1, 1, 2, 1, n, insets2);
        jLabel2.setLabelFor((Component)((Object)this.mLabelEdit));
        this.mACRWidget = new BasicACRWidget(BasicACRWidget.ButtonOrienation.eWEST, "VL_LIST_KEY");
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets2 = new Insets(insets.top + 2, 20, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel3, this.mACRWidget, gridBagConstraints, 0, 2, 3, 1, n, insets2);
        this.mACRWidget.addBasicACRListener(this);
        this.mACRWidget.setSerializable(false);
        this.mACRWidget.setAllowDuplicates(true);
        this.mACRWidget.setPreferredSize(new Dimension(300, 120));
        JButton jButton = new JButton(new SpellingAction());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        n = 23;
        DialogUtil.addUsingGBL(jPanel2, jButton, gridBagConstraints, 2, 0, 1, 1, n, insets2);
        this.mValueEdit.getDocument().addDocumentListener(this);
        this.mLabelEdit.getDocument().addDocumentListener(this);
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        JButton jButton = new JButton(new OkAction());
        JButton jButton2 = new JButton(new CancelAction());
        JButton jButton3 = new JButton(new HelpAction());
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton3, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(jButton);
                jPanel.add(jButton2);
                jPanel.add(jButton3);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton3);
            jPanel.add(Box.createVerticalStrut(n));
        }
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private void enableControls() {
    }

    private void loadData() {
        this.mACRWidget.clearListModel();
        int n = -1;
        IValueLabelMap iValueLabelMap = this.mVariable.getValueLabels();
        Set set = iValueLabelMap.getValueLabelEntries();
        for (Map.Entry entry : set) {
            ValueLabelHolder valueLabelHolder = new ValueLabelHolder(this.mVarFormat, (OBS)entry.getKey(), (String)entry.getValue());
            this.mACRWidget.addListItemAt(++n, valueLabelHolder);
        }
    }

    private boolean validateInput() {
        String string = "";
        if (this.mACRWidget.isAddEnabled() || this.mACRWidget.isChangeEnabled()) {
            string = "ERR_ACR_CONTINUE_WARNING";
        }
        if (string.length() > 0) {
            int n = JOptionPane.showConfirmDialog((Component)((Object)this), ResUtil.getCommonDlgString(string), VersionInfo.getAppVersionString(), 2);
            return n == 0;
        }
        return true;
    }

    private void enableACRButtons() {
        boolean bl;
        String string = this.mValueEdit.getText();
        String string2 = this.mLabelEdit.getText().trim();
        boolean bl2 = string.length() > 0;
        boolean bl3 = string2.length() > 0;
        boolean bl4 = this.mACRWidget.getListSelectedIndex() > -1;
        boolean bl5 = this.hasValue(this.mValueEdit.getText()) > -1;
        boolean bl6 = false;
        OBS oBS = new OBS();
        if (bl4 && this.stringToObs(string, oBS, false)) {
            ValueLabelHolder valueLabelHolder = new ValueLabelHolder(this.mVarFormat, oBS, string2);
            ValueLabelHolder valueLabelHolder2 = (ValueLabelHolder)this.mACRWidget.getListItemAt(this.mACRWidget.getListSelectedIndex());
            valueLabelHolder2.setLabel(valueLabelHolder2.getLabel().trim());
            bl6 = valueLabelHolder.equals(valueLabelHolder2);
        }
        boolean bl7 = bl = bl2 && bl3;
        if (bl) {
            bl = !bl4 || !bl5 && bl4;
        }
        this.mACRWidget.setAddEnabled(bl);
        this.mACRWidget.setChangeEnabled(bl2 && bl3 && bl4 && !bl6);
        this.mACRWidget.setRemoveEnabled(bl6);
    }

    private int hasValue(String string) {
        int n = 0;
        OBS oBS = new OBS();
        if (this.stringToObs(string, oBS, false)) {
            Object[] objectArray;
            for (Object object : objectArray = this.mACRWidget.getListItems()) {
                ValueLabelHolder valueLabelHolder = (ValueLabelHolder)object;
                if (valueLabelHolder.getValue().equals((Object)oBS)) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    private boolean handleDuplicates(OBS oBS) {
        int n = this.mACRWidget.getListSelectedIndex();
        for (int i = 0; i < this.mACRWidget.getListItemCount(); ++i) {
            ValueLabelHolder valueLabelHolder;
            if (i == n || !oBS.equals((Object)(valueLabelHolder = (ValueLabelHolder)this.mACRWidget.getListItemAt(i)).getValue())) continue;
            int n2 = JOptionPane.showConfirmDialog((Component)((Object)this), ResUtil.getCommonDlgString("ERR_DUP_VALUE_QUERY"), VersionInfo.getAppVersionString(), 2);
            if (n2 == 0) {
                valueLabelHolder.setLabel(this.mLabelEdit.getText().trim());
                if (n > -1) {
                    this.mACRWidget.removeListItemAt(n);
                }
                this.clearState();
            }
            return false;
        }
        return true;
    }

    private void clearState() {
        this.mValueEdit.getDocument().removeDocumentListener(this);
        this.mLabelEdit.getDocument().removeDocumentListener(this);
        this.mACRWidget.clearItemListSelection();
        this.mValueEdit.setText("");
        this.mLabelEdit.setText("");
        this.mACRWidget.setAddEnabled(false);
        this.mACRWidget.setChangeEnabled(false);
        this.mACRWidget.setRemoveEnabled(false);
        this.mValueEdit.getDocument().addDocumentListener(this);
        this.mLabelEdit.getDocument().addDocumentListener(this);
    }

    private void sortList() {
        Object[] objectArray = this.mACRWidget.getListItems();
        Arrays.sort(objectArray);
        int n = 0;
        this.mACRWidget.clearListModel();
        for (Object object : objectArray) {
            this.mACRWidget.addListItemAt(n++, object);
        }
    }

    private boolean stringToObs(String string, OBS oBS, boolean bl) {
        if (!CellValueFormatter.stringToObs((String)string, (SPSS_Format)this.mVarFormat, (OBS)oBS)) {
            Object object;
            if (this.mVarFormat.getFormatType().isDateOrTimeFormat() && (object = CellValueFormatter.parseDate((String)string)) instanceof Date) {
                oBS.setNum(ValueFormatter.convertJavaDateLongToDouble((long)((Date)object).getTime()));
                return true;
            }
            if (bl) {
                JOptionPane.showMessageDialog((Component)((Object)this), ResUtil.getCommonDlgString("ERR_MISSING_TYPE_ERROR"), VersionInfo.getAppVersionString(), 2);
                this.mValueEdit.selectAll();
                this.mValueEdit.requestFocus();
            }
            return false;
        }
        return true;
    }

    @Override
    public void acrEventOccured(BasicACREvent basicACREvent) {
        BasicACREvent.EventType eventType = basicACREvent.getEventType();
        if (eventType.equals((Object)BasicACREvent.EventType.addButtonPress)) {
            this.addValueLabel();
        } else if (eventType.equals((Object)BasicACREvent.EventType.changeButtonPress)) {
            this.changeValueLabel();
        } else if (eventType.equals((Object)BasicACREvent.EventType.removeButtonPress)) {
            this.removeValueLabel();
        } else if (eventType.equals((Object)BasicACREvent.EventType.listSelectionValueChange) && !this.mACRWidget.getList().getValueIsAdjusting()) {
            int n = this.mACRWidget.getListSelectedIndex();
            this.mACRWidget.setAddEnabled(false);
            this.mACRWidget.setChangeEnabled(false);
            this.mACRWidget.setRemoveEnabled(n > -1);
            if (n > -1) {
                ValueLabelHolder valueLabelHolder = (ValueLabelHolder)this.mACRWidget.getListItemAt(n);
                this.mValueEdit.setText(CellValueFormatter.obsToString((OBS)valueLabelHolder.getValue(), (SPSS_Format)this.mVarFormat));
                this.mLabelEdit.setText(valueLabelHolder.getLabel());
            }
        }
    }

    private void removeValueLabel() {
        this.removeSpellCheckDlg();
        int n = this.mACRWidget.getListSelectedIndex();
        if (n > -1) {
            this.mACRWidget.removeListItemAt(n);
            this.clearState();
            this.mValueEdit.requestFocus();
        }
    }

    private void changeValueLabel() {
        OBS oBS = new OBS();
        int n = this.mACRWidget.getListSelectedIndex();
        if (n > -1 && this.stringToObs(this.mValueEdit.getText(), oBS, true)) {
            if (this.mLabelEdit.getText().length() <= this.MAX_LABEL_LEN) {
                if (this.handleDuplicates(oBS)) {
                    ValueLabelHolder valueLabelHolder = (ValueLabelHolder)this.mACRWidget.getListItemAt(n);
                    valueLabelHolder.setValue(oBS);
                    valueLabelHolder.setLabel(this.mLabelEdit.getText().trim());
                    this.mACRWidget.getList().invalidate();
                    this.mACRWidget.getList().validate();
                    this.clearState();
                    this.sortList();
                    int n2 = this.mACRWidget.indexOf(valueLabelHolder);
                    if (n2 != -1) {
                        this.mACRWidget.setListSelectedIndex(n2);
                    }
                }
            } else {
                SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)this), ResUtil.getCommonDlgString("IDS_LABEL_LIMIT_MSG"), VersionInfo.getAppVersionString());
                this.mLabelEdit.requestFocusInWindow();
            }
        }
    }

    private void addValueLabel() {
        this.removeSpellCheckDlg();
        OBS oBS = new OBS();
        String string = this.mLabelEdit.getText();
        if (string.length() <= this.MAX_LABEL_LEN) {
            if (this.stringToObs(this.mValueEdit.getText(), oBS, true) && this.handleDuplicates(oBS)) {
                ValueLabelHolder valueLabelHolder = new ValueLabelHolder(this.mVarFormat, oBS, this.mLabelEdit.getText().trim());
                this.mACRWidget.addListItemAt(this.mACRWidget.getListItemCount(), valueLabelHolder);
                this.sortList();
                this.clearState();
                this.mValueEdit.requestFocus();
            }
        } else {
            SpssAlertOptionPane.showErrorMessageDialog((Window)((Object)this), ResUtil.getCommonDlgString("IDS_LABEL_LIMIT_MSG"), VersionInfo.getAppVersionString());
            this.mLabelEdit.requestFocusInWindow();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        if (document == this.mValueEdit.getDocument() || document == this.mLabelEdit.getDocument()) {
            this.enableACRButtons();
        }
        if (document == this.mValueEdit.getDocument()) {
            this.checkValueLength();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        if (document == this.mValueEdit.getDocument() || document == this.mLabelEdit.getDocument()) {
            this.enableACRButtons();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        if (document == this.mValueEdit.getDocument() || document == this.mLabelEdit.getDocument()) {
            this.enableACRButtons();
        }
        if (document == this.mValueEdit.getDocument()) {
            this.checkValueLength();
        }
    }

    private void checkValueLength() {
        String string;
        int n = 0;
        if (this.mVariable.getType() == 0 && (string = this.mValueEdit.getText()).length() > 0 && (string.charAt(0) == '+' || string.charAt(0) == '-')) {
            n = 1;
        }
        if (this.mValueEdit.getDocument().getLength() - n > this.mVarFormat.getWidth()) {
            final int n2 = n;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ValueLabelsDlg.this.mValueEdit.setText(ValueLabelsDlg.this.mValueEdit.getText().substring(0, ValueLabelsDlg.this.mVarFormat.getWidth() + n2));
                    Toolkit.getDefaultToolkit().beep();
                }
            });
        }
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "IDH_DEFVAR_LBL");
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.mLabelEdit && keyEvent.getKeyCode() == 10) {
            keyEvent.consume();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.mLabelEdit && keyEvent.getKeyCode() == 10) {
            keyEvent.consume();
            if (this.mACRWidget.isAddEnabled()) {
                this.addValueLabel();
            } else if (this.mACRWidget.isChangeEnabled()) {
                this.changeValueLabel();
            } else if (this.mACRWidget.isRemoveEnabled()) {
                this.removeValueLabel();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.mLabelEdit && keyEvent.getKeyCode() == 10) {
            keyEvent.consume();
        }
    }

    public void dispose() {
        super.dispose();
        this.removeSpellCheckDlg();
    }

    private void removeSpellCheckDlg() {
        if (this.mSpellCheckDlg != null) {
            this.mSpellCheckDlg.setVisible(false);
            this.mSpellCheckDlg = null;
        }
    }

    public class ValueLabelsSpellCheckDlg
    extends SpellingDlg {
        int mValueLabelIndex;
        boolean mFirstTime;
        int mOldSelectedIndex;

        public ValueLabelsSpellCheckDlg() {
            super(ValueLabelsDlg.this);
            this.mValueLabelIndex = 0;
            this.mFirstTime = true;
            this.mOldSelectedIndex = -1;
        }

        @Override
        protected void startSpellCheckSession(boolean bl) {
            super.startSpellCheckSession(bl);
            this.mValueLabelIndex = 0;
        }

        @Override
        public void doSpellCheck() {
            this.mOldSelectedIndex = ValueLabelsDlg.this.mACRWidget.getListSelectedIndex();
            this.startSpellCheckSession(true);
            this.doNextRow();
        }

        @Override
        protected void endSpellCheckSession() {
            super.endSpellCheckSession();
            if (this.mOldSelectedIndex != -1) {
                ValueLabelsDlg.this.mACRWidget.setListSelectedIndex(this.mOldSelectedIndex);
            }
        }

        @Override
        protected void doNextRow() {
            int n = this.cycleNextValueLabelIndex();
            if (n != -1) {
                this.spellCheckValue(n);
            } else {
                this.endSpellCheckSession();
            }
        }

        private int cycleNextValueLabelIndex() {
            if (!this.mFirstTime) {
                IValueLabelMap iValueLabelMap = ValueLabelsDlg.this.mVariable.getValueLabels();
                Set set = iValueLabelMap.getValueLabelEntries();
                ++this.mValueLabelIndex;
                if (this.mValueLabelIndex >= set.size()) {
                    this.mValueLabelIndex = -1;
                }
            } else {
                this.mValueLabelIndex = 0;
            }
            this.mFirstTime = false;
            return this.mValueLabelIndex;
        }

        private void spellCheckValue(int n) {
            String string;
            final ValueLabelHolder valueLabelHolder = (ValueLabelHolder)ValueLabelsDlg.this.mACRWidget.getListItemAt(n);
            String string2 = string = valueLabelHolder != null ? valueLabelHolder.getLabel() : null;
            if (string != null && string.length() > 0) {
                ValueLabelsDlg.this.mACRWidget.setListSelectedIndex(n);
                this.checkText(string, new SpellingDlg.CheckTextCallback(){

                    @Override
                    public void spellingChangeByUser(String string) {
                        valueLabelHolder.setLabel(string);
                        ValueLabelsDlg.this.mACRWidget.repaint();
                    }
                });
            } else {
                this.doNextRow();
            }
        }

        public HashMap<OBS, String> createDuplicateOBStoLabelMap(IValueLabelMap iValueLabelMap) {
            HashMap<OBS, String> hashMap = new HashMap<OBS, String>();
            for (Map.Entry entry : iValueLabelMap.getValueLabelEntries()) {
                hashMap.put((OBS)entry.getKey(), (String)entry.getValue());
            }
            return hashMap;
        }
    }

    private class SpellingAction
    extends AbstractAction {
        SpellingAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_SPELLING"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ValueLabelsDlg.this.mSpellCheckDlg = new ValueLabelsSpellCheckDlg();
            ValueLabelsDlg.this.mSpellCheckDlg.doSpellCheck();
        }
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ValueLabelsDlg.this.doHelp();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ValueLabelsDlg.this.dispose();
        }
    }

    class OkAction
    extends AbstractAction {
        OkAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!ValueLabelsDlg.this.validateInput()) {
                return;
            }
            ValueLabelsDlg.this.mTableModel.addVariable(ValueLabelsDlg.this.mRowIndex, 0, null);
            ValueLabelsDlg.this.mVariable = ValueLabelsDlg.this.mTableModel.getDataSource().getVariable(ValueLabelsDlg.this.mRowIndex);
            HashMap<OBS, String> hashMap = new HashMap<OBS, String>();
            for (int i = 0; i < ValueLabelsDlg.this.mACRWidget.getListItemCount(); ++i) {
                ValueLabelHolder valueLabelHolder = (ValueLabelHolder)ValueLabelsDlg.this.mACRWidget.getListItemAt(i);
                OBS oBS = valueLabelHolder.getValue();
                hashMap.put(oBS, valueLabelHolder.getLabel());
            }
            new VarViewValueLabelsEdit(ValueLabelsDlg.this.mTableModel, hashMap, ValueLabelsDlg.this.mRowIndex, ValueLabelsDlg.this.mColumnIndex);
            ValueLabelsDlg.this.mModalResult = true;
            ValueLabelsDlg.this.dispose();
        }
    }
}

