/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.documents.data;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.DatasourceAttributes;
import com.spss.java_client.core.documents.data.dictionary.ExtensionType;
import com.spss.java_client.core.documents.data.dictionary.IDatasourceAttributes;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ControlAction;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.data.VarViewTable;
import com.spss.java_client.ui.doc_types.data.VarViewTableModel;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SortVariableViewDlg
extends BaseProcedureDialog
implements ListSelectionListener,
ActionListener,
DocumentListener {
    private DataFrame mFrame = (DataFrame)SpssFrameMgr.getSpssFrameMgr().getDesignatedFrame(DocType.DE_DOC);
    private JList mAttributeList;
    private JRadioButton mAscendingRadio;
    private JCheckBox mSaveOrderCheck;
    private JLabel mAttrLabel;
    private StringTextField mAttrNameField;

    public SortVariableViewDlg(JFrame jFrame) throws HeadlessException {
        super(jFrame, ResUtil.getCommonDlgString("IDS_SVV_TITLE"), false, CommonDlgResBundle.getDefaultResourceBundleName(), CommonDlgResBundle.getImageFolder());
        this.initialize();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.updateTextFieldEnable();
        this.mAttributeList.addListSelectionListener(this);
        this.mSaveOrderCheck.addActionListener(this);
        this.mAttrNameField.getDocument().addDocumentListener(this);
    }

    @Override
    public String generateSyntax() {
        String string = "";
        Object e = this.mAttributeList.getSelectedValue();
        if (e instanceof ListAttr) {
            string = "SORT VARIABLES BY ";
            ListAttr listAttr = (ListAttr)e;
            String string2 = listAttr.getAttrId();
            String string3 = string2.startsWith("@") ? "ATTRIBUTE " + string2.substring(1) : string2.toUpperCase();
            if (string3.equals("TYPE")) {
                string3 = "FORMAT";
            }
            string = string + string3;
            string = string + " (" + (this.mAscendingRadio.isSelected() ? "A" : "D") + ").\n";
        }
        return string;
    }

    @Override
    public String getIActionKey() {
        return "data_sort_variables";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_sort_variable_view";
    }

    @Override
    public boolean okPastePressed() {
        boolean bl = super.okPastePressed();
        if (bl && this.mSaveOrderCheck.isSelected()) {
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(this.mFrame.getDatasetId());
            if (iSpssDataSrc != null && this.isValidAttrName()) {
                String string;
                int n;
                Object object;
                String string2 = this.mAttrNameField.getText();
                boolean bl2 = false;
                int n2 = iSpssDataSrc.columnCount();
                for (int i = 0; i < n2; ++i) {
                    ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(i);
                    object = iSpssVariable.getAttributes();
                    Vector vector = object.values(string2);
                    if (vector == null || vector.size() <= 0) continue;
                    bl2 = true;
                    break;
                }
                if (bl2 && (n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), (String)(object = String.format(string = this.getResString("ERR_ATTR_IN_USE_QUERY"), string2, string2)), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) != 0) {
                    bl = false;
                }
                if (bl) {
                    SortVariableViewDlg.saveCurrentVarOrder(this.mFrame, iSpssDataSrc, string2);
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public static void saveCurrentVarOrder(DataFrame dataFrame, ISpssDataSrc iSpssDataSrc, String string) {
        String string2;
        Object object;
        int n = iSpssDataSrc.columnCount();
        String string3 = n > 9999 ? "%05d" : (n > 999 ? "%04d" : (n > 99 ? "%03d" : (n > 9 ? "%02d" : "%d")));
        Vector<ISpssVariable> vector = new Vector<ISpssVariable>();
        for (int i = 0; i < n; ++i) {
            ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(i);
            object = iSpssVariable.getAttributes();
            Vector<String> vector2 = new Vector<String>();
            vector2.add(String.format(string3, i + 1));
            object.put(string, vector2);
            vector.add(iSpssVariable);
        }
        VarViewTable varViewTable = (VarViewTable)dataFrame.getDataView().getDataTable(1);
        object = (VarViewTableModel)varViewTable.getModel();
        Vector<String> vector3 = ((VarViewTableModel)object).getDisplayedAttributes();
        if (vector3.indexOf(string2 = "@" + string) == -1) {
            vector3.add(string2);
            IDatasourceAttributes iDatasourceAttributes = iSpssDataSrc.getAttributes();
            boolean bl = false;
            if (iDatasourceAttributes == null) {
                iDatasourceAttributes = new DatasourceAttributes();
                bl = true;
            }
            iDatasourceAttributes.put("$VariableView2", vector3);
            if (bl) {
                iSpssDataSrc.setAttributes(iDatasourceAttributes);
            }
            varViewTable.updateDisplayedAttributes();
            DataMgr.getDataMgr().sendDataSrcExtensionsMsg(iSpssDataSrc.getDataSetId(), iDatasourceAttributes.toString(), ExtensionType.kDatasetAttributes, 1);
        }
        iSpssDataSrc.setModified(true);
        DataMgr.getDataMgr().sendModifyVarsMsg(iSpssDataSrc.getDataSetId(), vector, false);
        dataFrame.getUndoManager().discardAllEdits();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.mSaveOrderCheck) {
            this.updateTextFieldEnable();
            this.updateCommandButtons();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateCommandButtons();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateCommandButtons();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateCommandButtons();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateCommandButtons();
    }

    private void updateCommandButtons() {
        boolean bl;
        boolean bl2 = bl = this.mAttributeList.getSelectedIndex() > -1;
        if (bl && this.mSaveOrderCheck.isSelected()) {
            bl = this.mAttrNameField.getDocument().getLength() > 0;
        }
        this.enableOkPaste(bl);
    }

    private boolean isValidAttrName() {
        String string = this.mAttrNameField.getText();
        boolean bl = true;
        VarNameValidator.ValidNameCode validNameCode = VarNameValidator.validateSPSSName((String)string, (boolean)true);
        if (validNameCode != VarNameValidator.ValidNameCode.SPSSNAME_STANDARD && validNameCode != VarNameValidator.ValidNameCode.SPSSNAME_WARN_UNDERSCORE) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_INVALID_ATTR_NAME"), VersionInfo.getAppVersionString());
            bl = false;
            this.mAttrNameField.requestFocus();
            this.mAttrNameField.selectAll();
        }
        return bl;
    }

    private void updateTextFieldEnable() {
        boolean bl = this.mSaveOrderCheck.isSelected();
        this.mAttrLabel.setEnabled(bl);
        this.mAttrNameField.setEnabled(bl);
        this.mAttrNameField.setBackground(bl ? Color.white : SystemColor.control);
        this.mAttrNameField.setForeground(bl ? Color.black : Color.gray);
    }

    private void initialize() {
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        JLabel jLabel = new JLabel(this.getResString("IDS_VAR_VIEW_COLUMNS"));
        if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
            jLabel.setDisplayedMnemonic(this.getDlgAccessKey("IDK_VAR_VIEW_COLUMNS_KEY"));
        }
        Insets insets2 = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        Insets insets3 = new Insets(insets.top, insets.left, insets.bottom + 4, insets.right);
        this.mAttributeList = new JList(this.getListAttributes());
        this.mAttributeList.setSelectionMode(0);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, new JScrollPane(this.mAttributeList), gridBagConstraints, 0, 1, 1, 1, n, insets3);
        jLabel.setLabelFor(this.mAttributeList);
        this.mAttributeList.setVisibleRowCount(10);
        Insets insets4 = new Insets(insets.top, insets.left, insets.bottom + 4, insets.right);
        JPanel jPanel2 = new JPanel(new GridBagLayout(), false);
        jPanel2.setBorder(new TitledBorder(this.getResString("IDS_SORT_ORDER")));
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n, insets4);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        Insets insets5 = new Insets(0, insets.left + 8, 0, insets.right);
        ControlAction controlAction = new ToggleButtonAction(this, "IDS_ASCENDING");
        this.mAscendingRadio = new JRadioButton(controlAction);
        if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
            this.mAscendingRadio.setMnemonic(this.getDlgAccessKey("IDK_ASCENDING_KEY"));
        }
        DialogUtil.addUsingGBL(jPanel2, this.mAscendingRadio, gridBagConstraints, 0, 0, 1, 1, n, insets5);
        spssButtonGroup.add(this.mAscendingRadio);
        controlAction = new ToggleButtonAction(this, "IDS_DESCENDING");
        JRadioButton jRadioButton = new JRadioButton(controlAction);
        if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
            jRadioButton.setMnemonic(this.getDlgAccessKey("IDK_DESCENDING_KEY"));
        }
        gridBagConstraints.weighty = 1.0;
        insets5.bottom = 3;
        DialogUtil.addUsingGBL(jPanel2, jRadioButton, gridBagConstraints, 0, 1, 1, 1, n, insets5);
        spssButtonGroup.add(jRadioButton);
        this.mAscendingRadio.setSelected(true);
        JPanel jPanel3 = new JPanel(new GridBagLayout(), false);
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 3, 1, 1, n, insets4);
        controlAction = new ToggleButtonAction(this, "IDS_SAVE_PRE_SORTED");
        this.mSaveOrderCheck = new JCheckBox(controlAction);
        if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
            this.mSaveOrderCheck.setMnemonic(this.getDlgAccessKey("IDK_SAVE_PRE_SORTED_KEY"));
        }
        if (CommandLine.isClementineCaller()) {
            this.mSaveOrderCheck.setEnabled(false);
        }
        DialogUtil.addUsingGBL(jPanel3, this.mSaveOrderCheck, gridBagConstraints, 0, 0, 2, 1, n, insets2);
        this.mAttrLabel = new JLabel(this.getResString("IDS_ATTR_NAME_PROMPT"), 10);
        if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
            this.mAttrLabel.setDisplayedMnemonic(this.getDlgAccessKey("IDK_ATTR_NAME_PROMPT_KEY"));
        }
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        Insets insets6 = new Insets(insets.top, insets.left + 20, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel3, this.mAttrLabel, gridBagConstraints, 0, 1, 1, 1, n, insets6);
        controlAction = new TextFieldAction(this, "IDS_ATTRIBUTE_TEXT");
        this.mAttrNameField = new StringTextField();
        this.mAttrNameField.setAction(controlAction);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel3, (JComponent)((Object)this.mAttrNameField), gridBagConstraints, 1, 1, 1, 1, n, insets4);
        this.mAttrLabel.setLabelFor((Component)((Object)this.mAttrNameField));
        this.mAttrNameField.setColumns(32);
    }

    private Vector<?> getListAttributes() {
        VarViewTable varViewTable = (VarViewTable)this.mFrame.getDataView().getDataTable(1);
        VarViewTableModel varViewTableModel = (VarViewTableModel)varViewTable.getModel();
        Vector<String> vector = varViewTableModel.getDisplayedAttributes();
        Vector<ListAttr> vector2 = new Vector<ListAttr>();
        for (String string : vector) {
            String string2 = VarViewTableModel.columnIdToColumnName(string);
            vector2.add(new ListAttr(string2, string));
        }
        return vector2;
    }

    @Override
    public void loadDialogState() {
        super.loadDialogState();
        if (this.getDialogDataModel().getInteger("SVV_VAR_ATTR") != null) {
            this.mAttributeList.setSelectedIndex(this.getDialogDataModel().getInteger("SVV_VAR_ATTR"));
        }
        this.updateTextFieldEnable();
        this.updateCommandButtons();
    }

    @Override
    public void saveDialogState() {
        super.saveDialogState();
        this.getDialogDataModel().putInteger("SVV_VAR_ATTR", this.mAttributeList.getSelectedIndex());
    }

    @Override
    public void reset() {
        super.reset();
        this.mAscendingRadio.setSelected(true);
        this.mSaveOrderCheck.setSelected(false);
        this.mAttrNameField.setText("");
        this.mAttributeList.clearSelection();
        this.updateTextFieldEnable();
        this.updateCommandButtons();
    }

    class ListAttr
    extends JLabel {
        private String mAttrId;

        public ListAttr(String string, String string2) {
            super(string);
            this.mAttrId = string2;
        }

        public String getAttrId() {
            return this.mAttrId;
        }

        @Override
        public String toString() {
            return this.getText();
        }
    }
}

