/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.documents.data;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.dialogs.documents.data.SortVariableViewDlg;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SaveVariableOrderDlg
extends BaseDialog
implements DocumentListener {
    protected JTextField mAttrNameEdit;
    protected ISpssDataSrc mDataSrc;
    protected DataFrame mFrame;
    protected boolean mOkToContinue = false;
    protected JButton mYesButton;
    protected JButton mNoButton;
    protected JButton mHelpButton;

    public SaveVariableOrderDlg(DataFrame dataFrame) throws HeadlessException {
        super((JFrame)dataFrame, true, ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), CommonDlgResBundle.getImageFolder());
        this.mFrame = dataFrame;
        this.mDataSrc = DataMgr.getDataMgr().getDataSource(dataFrame.getDatasetId());
        this.setTitle(this.getResString("IDS_SAVE_CURRENT_ORDER"));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_save_variable_order_attribute");
    }

    public boolean okToProceed() {
        return this.mOkToContinue;
    }

    public final String getIActionKey() {
        return "save_current_order";
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateYes();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateYes();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateYes();
    }

    protected boolean yesPressed() {
        String string;
        int n;
        Object object;
        if (!this.isValidAttrName()) {
            return false;
        }
        String string2 = this.mAttrNameEdit.getText();
        boolean bl = false;
        int n2 = this.mDataSrc.columnCount();
        for (int i = 0; i < n2; ++i) {
            ISpssVariable iSpssVariable = this.mDataSrc.getVariable(i);
            object = iSpssVariable.getAttributes();
            Vector vector = object.values(string2);
            if (vector == null || vector.size() <= 0) continue;
            bl = true;
            break;
        }
        if (bl && (n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), (String)(object = String.format(string = this.getResString("ERR_ATTR_IN_USE_QUERY"), string2, string2)), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) != 0) {
            return false;
        }
        SortVariableViewDlg.saveCurrentVarOrder(this.mFrame, this.mDataSrc, this.mAttrNameEdit.getText());
        return true;
    }

    protected void updateYes() {
        boolean bl = this.mAttrNameEdit.getDocument().getLength() > 0;
        this.mYesButton.setEnabled(bl);
    }

    private boolean isValidAttrName() {
        String string = this.mAttrNameEdit.getText();
        boolean bl = true;
        VarNameValidator.ValidNameCode validNameCode = VarNameValidator.validateSPSSName((String)string, (boolean)true);
        if (validNameCode != VarNameValidator.ValidNameCode.SPSSNAME_STANDARD && validNameCode != VarNameValidator.ValidNameCode.SPSSNAME_WARN_UNDERSCORE) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), this.getResString("ERR_INVALID_ATTR_NAME"), VersionInfo.getAppVersionString());
            bl = false;
            this.mAttrNameEdit.requestFocus();
            this.mAttrNameEdit.selectAll();
        }
        return bl;
    }

    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(2, 0, 2, 0);
        JLabel jLabel = new JLabel(this.getResString("IDS_SAVE_ORDER_PROMPT"), 10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 2, 1, n, insets);
        jLabel = new JLabel(this.getResString("IDS_ATTR_NAME_PROMPT"));
        insets = new Insets(DialogUtil.getComponentGroupGap(), 0, DialogUtil.getComponentGroupGap(), 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.mAttrNameEdit = new JTextField();
        insets = new Insets(DialogUtil.getComponentGroupGap(), 4, DialogUtil.getComponentGroupGap(), 0);
        Dimension dimension = new Dimension(280, 22);
        this.mAttrNameEdit.setPreferredSize(dimension);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mAttrNameEdit, gridBagConstraints, 1, 1, 1, 1, n, insets);
        jLabel.setLabelFor(this.mAttrNameEdit);
        this.mAttrNameEdit.setText("");
        this.mAttrNameEdit.setCaretPosition(0);
        this.mAttrNameEdit.getDocument().addDocumentListener(this);
        this.updateYes();
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        YesAction yesAction = new YesAction();
        this.mYesButton = new JButton(yesAction);
        NoButtonAction noButtonAction = new NoButtonAction();
        this.mNoButton = new JButton(noButtonAction);
        JButton jButton = new JButton(new CancelAction());
        HelpAction helpAction = new HelpAction();
        this.mHelpButton = new JButton(helpAction);
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, this.mHelpButton, gridBagConstraints, 0, 0, 1, 1, n2, null);
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 3, 0, 1, 1, n2, insets2);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, this.mNoButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, this.mYesButton, gridBagConstraints, 4, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mYesButton);
                jPanel.add(this.mNoButton);
                jPanel.add(jButton);
                jPanel.add(this.mHelpButton);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(this.mYesButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(this.mNoButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(this.mHelpButton);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(this.mYesButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SaveVariableOrderDlg.this.doHelp();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SaveVariableOrderDlg.this.mOkToContinue = false;
            SaveVariableOrderDlg.this.dispose();
        }
    }

    class NoButtonAction
    extends AbstractAction {
        NoButtonAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_NO"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SaveVariableOrderDlg.this.mOkToContinue = true;
            SaveVariableOrderDlg.this.dispose();
        }
    }

    class YesAction
    extends AbstractAction {
        YesAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_YES"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (SaveVariableOrderDlg.this.yesPressed()) {
                SaveVariableOrderDlg.this.mOkToContinue = true;
                SaveVariableOrderDlg.this.dispose();
            }
        }
    }
}

