/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.documents.data;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.ui.controls.DlgEditField;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.MissingValueTextField;
import com.spss.java_client.ui.doc_types.data.VarViewTableModel;
import com.spss.java_client.ui.doc_types.data.undo.MissingValueBucket;
import com.spss.java_client.ui.doc_types.data.undo.VarViewMissingValueEdit;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.format.CellValueFormatter;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.SPSSTextField;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.dialogs.DlgKeyPressListener;
import com.spss.uitools.dialogs.IDlgKeyPressListener;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.util.EncodingValidator;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.nio.charset.CoderResult;
import java.text.ParseException;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;

public class MissingValuesDlg
extends BaseDialog {
    private static final String NO_MISSING_RADIO_KEY = "IDS_NO_MISS_RADIO";
    private static final String DISCRETE_MISSING_RADIO_KEY = "IDS_DISCM_RADIO";
    private static final String RANGE_MISSING_RADIO_KEY = "IDS_RNGM_RADIO";
    private JRadioButton mNoMissingRadio;
    private JRadioButton mDiscreteMissingRadio;
    private JRadioButton mRangeMissingRadio;
    private MissingValueTextField mDiscreteField1;
    private MissingValueTextField mDiscreteField2;
    private MissingValueTextField mDiscreteField3;
    private JLabel mLowLabel;
    private JLabel mHighLabel;
    private JLabel mDiscreteLabel;
    private LowHighMissingValueTextField mLowRangeField;
    private LowHighMissingValueTextField mHighRangeField;
    private DlgEditField mDiscreteRangeField;
    private ISpssVariable mVariable = null;
    private VarViewTableModel mTableModel = null;
    private int mRowIndex;
    private int mColumnIndex;
    private boolean mModalResult = false;
    private EncodingValidator mEncodingValidator;
    private Vector<Object> mComponentOrder;
    private JButton mOkButton;
    private JButton mCancelButton;
    private JButton mHelpButton;

    public MissingValuesDlg(SpssFrame spssFrame, VarViewTableModel varViewTableModel, int n, int n2) {
        super((JFrame)spssFrame, ResUtil.getCommonDlgString("IDS_MISSING_VALUES"), true, ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), CommonDlgResBundle.getImageFolder());
        SPSS_Format sPSS_Format;
        this.mTableModel = varViewTableModel;
        this.mRowIndex = n;
        this.mColumnIndex = n2;
        this.mEncodingValidator = new EncodingValidator(ComponentState.getCurrentCharset());
        ISpssDataSrc iSpssDataSrc = varViewTableModel.getDataSource();
        this.mVariable = iSpssDataSrc.getVariable(this.mRowIndex);
        if (this.mVariable == null) {
            this.mVariable = varViewTableModel.getDataSource().makeVariable(0, null);
        }
        if ((sPSS_Format = this.mVariable.getFormat()).getFormatType().isNumericFormat() && sPSS_Format.getDecimals() < 3) {
            sPSS_Format.setDecimals((byte)3);
        }
        this.mDiscreteField1.setFormat(sPSS_Format);
        this.mDiscreteField2.setFormat(sPSS_Format);
        this.mDiscreteField3.setFormat(sPSS_Format);
        this.mLowRangeField.setFormat(sPSS_Format);
        this.mHighRangeField.setFormat(sPSS_Format);
        this.mDiscreteRangeField.setFormat(sPSS_Format);
        int n3 = this.mVariable.getFormat().getFormatType().isNumericFormat() ? 3 : 0;
        this.mDiscreteField1.setFocusLostBehavior(n3);
        this.mDiscreteField2.setFocusLostBehavior(n3);
        this.mDiscreteField3.setFocusLostBehavior(n3);
        this.mLowRangeField.setFocusLostBehavior(n3);
        this.mHighRangeField.setFocusLostBehavior(n3);
        this.mDiscreteRangeField.setFocusLostBehavior(n3);
        this.loadData();
        this.pack();
        this.setLocationRelativeTo(spssFrame);
        this.enableControls();
    }

    public boolean getModalResult() {
        return this.mModalResult;
    }

    protected void addDlgKeyPressListener() {
        this.mKeyAdapter.addDlgKeyPressListener((IDlgKeyPressListener)new MissingValuesDlgKeyPressListener());
    }

    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        this.mComponentOrder = new Vector();
        this.mComponentOrder.add(spssButtonGroup);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, NO_MISSING_RADIO_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MissingValuesDlg.this.enableControls();
            }
        };
        this.mNoMissingRadio = new JRadioButton(toggleButtonAction);
        DialogUtil.addUsingGBL(jPanel, this.mNoMissingRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        spssButtonGroup.add(this.mNoMissingRadio);
        toggleButtonAction = new ToggleButtonAction(this, DISCRETE_MISSING_RADIO_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MissingValuesDlg.this.enableControls();
            }
        };
        this.mDiscreteMissingRadio = new JRadioButton(toggleButtonAction);
        DialogUtil.addUsingGBL(jPanel, this.mDiscreteMissingRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        spssButtonGroup.add(this.mDiscreteMissingRadio);
        this.setupDiscreteEdits(jPanel);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        toggleButtonAction = new ToggleButtonAction(this, RANGE_MISSING_RADIO_KEY){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MissingValuesDlg.this.enableControls();
            }
        };
        Insets insets2 = new Insets(insets.top + 2, insets.left, insets.bottom, insets.right);
        this.mRangeMissingRadio = new JRadioButton(toggleButtonAction);
        DialogUtil.addUsingGBL(jPanel, this.mRangeMissingRadio, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        spssButtonGroup.add(this.mRangeMissingRadio);
        this.setupRangeEdits(jPanel);
        this.mComponentOrder.add(this.mOkButton);
        this.mComponentOrder.add(this.mCancelButton);
        this.mComponentOrder.add(this.mHelpButton);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.mComponentOrder, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setupDiscreteEdits(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        Insets insets2 = new Insets(insets.top, insets.left + 18, insets.bottom, insets.right);
        JPanel jPanel2 = new JPanel(true);
        jPanel2.setLayout(new GridBagLayout());
        this.mDiscreteField1 = new MissingValueTextField();
        DialogUtil.addUsingGBL(jPanel2, this.mDiscreteField1, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        this.mComponentOrder.add(this.mDiscreteField1);
        this.mDiscreteField2 = new MissingValueTextField();
        DialogUtil.addUsingGBL(jPanel2, this.mDiscreteField2, gridBagConstraints, 1, 0, 1, 1, n, insets);
        this.mComponentOrder.add(this.mDiscreteField2);
        this.mDiscreteField3 = new MissingValueTextField();
        DialogUtil.addUsingGBL(jPanel2, this.mDiscreteField3, gridBagConstraints, 2, 0, 1, 1, n, insets);
        this.mComponentOrder.add(this.mDiscreteField3);
        gridBagConstraints.weighty = 0.0;
        insets2 = new Insets(insets.top, insets.left, insets.bottom, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n, insets2);
    }

    private void setupRangeEdits(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        JPanel jPanel2 = new JPanel(true);
        jPanel2.setLayout(new GridBagLayout());
        this.mLowLabel = new JLabel(this.getResString("IDS_LOW_LABEL"));
        this.mLowLabel.setDisplayedMnemonic(this.getDlgAccessKey("IDK_LOW_LABEL_KEY"));
        Insets insets2 = new Insets(insets.top, insets.left + 18, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel2, this.mLowLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        this.mLowRangeField = new LowHighMissingValueTextField();
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel2, this.mLowRangeField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        this.mLowLabel.setLabelFor(this.mLowRangeField);
        this.mComponentOrder.add(this.mLowRangeField);
        Insets insets3 = new Insets(insets.top, insets.left + 4, insets.bottom, insets.right);
        this.mHighLabel = new JLabel(this.getResString("IDS_HIGH_LABEL"));
        this.mHighLabel.setDisplayedMnemonic(this.getDlgAccessKey("IDK_HIGH_LABEL_KEY"));
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel2, this.mHighLabel, gridBagConstraints, 2, 0, 1, 1, n, insets3);
        this.mHighRangeField = new LowHighMissingValueTextField();
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel2, this.mHighRangeField, gridBagConstraints, 3, 0, 1, 1, n, insets);
        this.mHighLabel.setLabelFor(this.mHighRangeField);
        this.mComponentOrder.add(this.mHighRangeField);
        JPanel jPanel3 = new JPanel(true);
        jPanel3.setLayout(new GridBagLayout());
        this.mDiscreteLabel = new JLabel(this.getResString("IDS_DISCRETE_LABEL"));
        this.mDiscreteLabel.setDisplayedMnemonic(this.getDlgAccessKey("IDK_DISCRETE_LABEL_KEY"));
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel3, this.mDiscreteLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        this.mDiscreteRangeField = new MissingValueTextField();
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel3, this.mDiscreteRangeField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        this.mDiscreteLabel.setLabelFor(this.mDiscreteRangeField);
        this.mComponentOrder.add(this.mDiscreteRangeField);
        JLabel jLabel = new JLabel("   ");
        DialogUtil.addUsingGBL(jPanel3, jLabel, gridBagConstraints, 2, 0, 1, 1, n, insets2);
        insets2 = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 4, 1, 1, n, insets2);
        insets2 = new Insets(7, 0, 0, 0);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 5, 1, 1, n, insets2);
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        this.mOkButton = new JButton(new OkAction());
        this.mCancelButton = new JButton(new CancelAction());
        this.mHelpButton = new JButton(new HelpAction());
        DialogUtil.setupMacHelpButton(this.mHelpButton);
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, this.mHelpButton, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, this.mCancelButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, this.mOkButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mOkButton);
                jPanel.add(this.mCancelButton);
                jPanel.add(this.mHelpButton);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(this.mOkButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(this.mCancelButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(this.mHelpButton);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(this.mOkButton);
        return jPanel;
    }

    private void enableControls() {
        if (this.mNoMissingRadio == null) {
            return;
        }
        Color color = OSInfo.getOSType() == OSInfo.OSType.WIN ? SystemColor.window : SystemColor.white;
        if (this.mVariable.getType() > 0) {
            this.mRangeMissingRadio.setEnabled(false);
        }
        boolean bl = this.mDiscreteMissingRadio.isSelected();
        boolean bl2 = this.mRangeMissingRadio.isSelected();
        this.mDiscreteField1.setEnabled(bl);
        this.mDiscreteField2.setEnabled(bl);
        this.mDiscreteField3.setEnabled(bl);
        this.mDiscreteField1.setBackground(bl ? color : SystemColor.control);
        this.mDiscreteField2.setBackground(bl ? color : SystemColor.control);
        this.mDiscreteField3.setBackground(bl ? color : SystemColor.control);
        this.mLowLabel.setEnabled(bl2);
        this.mHighLabel.setEnabled(bl2);
        this.mDiscreteLabel.setEnabled(bl2);
        this.mLowRangeField.setEnabled(bl2);
        this.mHighRangeField.setEnabled(bl2);
        this.mDiscreteRangeField.setEnabled(bl2);
        this.mLowRangeField.setBackground(bl2 ? color : SystemColor.control);
        this.mHighRangeField.setBackground(bl2 ? color : SystemColor.control);
        this.mDiscreteRangeField.setBackground(bl2 ? color : SystemColor.control);
    }

    private void loadData() {
        ISpssVariable.Rule rule;
        OBS oBS = new OBS();
        OBS oBS2 = new OBS();
        OBS oBS3 = new OBS();
        SPSS_Format sPSS_Format = this.mVariable.getFormat();
        if (sPSS_Format.getFormatType().isNumericFormat() && sPSS_Format.getDecimals() < 3) {
            sPSS_Format.setDecimals((byte)3);
        }
        if ((rule = this.mVariable.getMissingValues(oBS, oBS2, oBS3)).equals((Object)ISpssVariable.Rule.none)) {
            this.mNoMissingRadio.setSelected(true);
        } else if (rule.equals((Object)ISpssVariable.Rule.one) || rule.equals((Object)ISpssVariable.Rule.two) || rule.equals((Object)ISpssVariable.Rule.three)) {
            this.mDiscreteMissingRadio.setSelected(true);
            this.mDiscreteField1.setText(this.obsToString(oBS, sPSS_Format));
            if (!rule.equals((Object)ISpssVariable.Rule.one)) {
                this.mDiscreteField2.setText(this.obsToString(oBS2, sPSS_Format));
            }
            if (rule.equals((Object)ISpssVariable.Rule.three)) {
                this.mDiscreteField3.setText(this.obsToString(oBS3, sPSS_Format));
            }
        } else if (rule.equals((Object)ISpssVariable.Rule.range) || rule.equals((Object)ISpssVariable.Rule.range_plus)) {
            this.mRangeMissingRadio.setSelected(true);
            this.mLowRangeField.setText(this.obsWithLowHighToString(oBS, sPSS_Format));
            this.mHighRangeField.setText(this.obsWithLowHighToString(oBS2, sPSS_Format));
            if (rule.equals((Object)ISpssVariable.Rule.range_plus)) {
                this.mDiscreteRangeField.setText(this.obsToString(oBS3, sPSS_Format));
            }
        }
    }

    private String obsToString(OBS oBS, SPSS_Format sPSS_Format) {
        return CellValueFormatter.obsToString((OBS)oBS, (SPSS_Format)sPSS_Format);
    }

    private String obsWithLowHighToString(OBS oBS, SPSS_Format sPSS_Format) {
        if (sPSS_Format.getFormatType().isNumericFormat()) {
            ISpssDataSrc iSpssDataSrc = this.mTableModel.getDataSource();
            double d = iSpssDataSrc.getObslo();
            double d2 = iSpssDataSrc.getObshi();
            if (d == oBS.getNum()) {
                return "LO";
            }
            if (d2 == oBS.getNum()) {
                return "HI";
            }
        }
        return this.obsToString(oBS, sPSS_Format);
    }

    private boolean validateInput() {
        if (this.mNoMissingRadio.isSelected()) {
            return true;
        }
        DlgEditField dlgEditField = null;
        String string = "";
        OBS oBS = new OBS();
        OBS oBS2 = new OBS();
        OBS oBS3 = new OBS();
        ISpssVariable.Rule rule = this.getObsSelections(oBS, oBS2, oBS3);
        if (this.mDiscreteMissingRadio.isSelected()) {
            if (!this.mDiscreteField1.isFormattedCorrectly()) {
                string = "ERR_MISSING_TYPE_ERROR";
                dlgEditField = this.mDiscreteField1;
            } else if (!this.mDiscreteField2.isFormattedCorrectly()) {
                string = "ERR_MISSING_TYPE_ERROR";
                dlgEditField = this.mDiscreteField2;
            } else if (!this.mDiscreteField3.isFormattedCorrectly()) {
                string = "ERR_MISSING_TYPE_ERROR";
                dlgEditField = this.mDiscreteField3;
            }
            if (string.length() == 0) {
                if (this.mDiscreteField1.getUnformattedText().length() == 0) {
                    string = "ERR_MISSING_EMPTY_ERROR";
                    dlgEditField = this.mDiscreteField1;
                } else if (oBS.isEmpty()) {
                    string = "ERR_MISSING_TYPE_ERROR";
                    dlgEditField = this.mDiscreteField1;
                } else {
                    string = this.validateString(this.mDiscreteField1.getText());
                }
                if (string.length() == 0 && (rule.equals((Object)ISpssVariable.Rule.two) || rule.equals((Object)ISpssVariable.Rule.three))) {
                    if (this.mDiscreteField2.getText().length() != 0 && oBS2.isEmpty()) {
                        string = "ERR_MISSING_TYPE_ERROR";
                        dlgEditField = this.mDiscreteField2;
                    } else if (oBS2.equals((Object)oBS)) {
                        string = "ERR_MISSING_UNIQUE_ERROR";
                        dlgEditField = this.mDiscreteField2;
                    } else {
                        string = this.validateString(this.mDiscreteField2.getText());
                    }
                    if (string.length() == 0 && rule.equals((Object)ISpssVariable.Rule.three)) {
                        if (this.mDiscreteField3.getText().length() != 0 && oBS3.isEmpty()) {
                            string = "ERR_MISSING_TYPE_ERROR";
                            dlgEditField = this.mDiscreteField3;
                        } else if (oBS3.equals((Object)oBS) || oBS3.equals((Object)oBS2)) {
                            string = "ERR_MISSING_UNIQUE_ERROR";
                            dlgEditField = this.mDiscreteField3;
                        } else {
                            string = this.validateString(this.mDiscreteField3.getText());
                        }
                    }
                }
            }
        } else {
            if (!this.mLowRangeField.isFormattedCorrectly()) {
                string = "ERR_MISSING_TYPE_ERROR";
                dlgEditField = this.mLowRangeField;
            } else if (!this.mHighRangeField.isFormattedCorrectly()) {
                string = "ERR_MISSING_TYPE_ERROR";
                dlgEditField = this.mHighRangeField;
            } else if (!this.mDiscreteRangeField.isFormattedCorrectly()) {
                string = "ERR_MISSING_TYPE_ERROR";
                dlgEditField = this.mDiscreteRangeField;
            }
            if (string.length() == 0) {
                FormatType formatType = this.mVariable.getFormat().getFormatType();
                if (this.mLowRangeField.getText().length() > 0 && oBS.isEmpty()) {
                    string = "ERR_MISSING_TYPE_ERROR";
                    dlgEditField = this.mLowRangeField;
                } else if (this.mHighRangeField.getText().length() > 0 && oBS2.isEmpty()) {
                    string = "ERR_MISSING_TYPE_ERROR";
                    dlgEditField = this.mHighRangeField;
                } else if (oBS.isEmpty() || oBS2.isEmpty()) {
                    string = "ERR_MISSING_RANGE_ERROR";
                    dlgEditField = oBS.isEmpty() ? this.mLowRangeField : this.mHighRangeField;
                } else if (formatType.isNumericFormat() && oBS.getNum() >= oBS2.getNum() || formatType.isStringFormat() && oBS.getString().compareTo(oBS2.getString()) >= 0) {
                    string = "ERR_MISSING_RANGE_ERROR";
                    dlgEditField = this.mHighRangeField;
                }
                if (string.length() == 0 && rule.equals((Object)ISpssVariable.Rule.range_plus)) {
                    if (oBS3.isEmpty()) {
                        string = "ERR_MISSING_TYPE_ERROR";
                        dlgEditField = this.mDiscreteRangeField;
                    } else if (formatType.isNumericFormat() && !(oBS3.getNum() < oBS.getNum()) && !(oBS3.getNum() > oBS2.getNum()) || formatType.isStringFormat() && oBS3.getString().compareTo(oBS.getString()) >= 0 && oBS3.getString().compareTo(oBS2.getString()) <= 0) {
                        string = "ERR_MISSING_RANGE_ERROR";
                        dlgEditField = this.mDiscreteRangeField;
                    }
                }
            }
        }
        if (string.length() > 0) {
            SPSSTextField.showWarningDialog((JComponent)this.mDiscreteField1, (String)ResUtil.getCommonDlgString(string), (String)VersionInfo.getAppVersionString());
            if (dlgEditField != null) {
                dlgEditField.selectAll();
                dlgEditField.requestFocusInWindow();
            }
            return false;
        }
        return true;
    }

    public String validateString(String string) {
        String string2 = "";
        try {
            if (!this.mEncodingValidator.validateString(string)) {
                string2 = this.mEncodingValidator.getResult().equals(CoderResult.OVERFLOW) ? "ERR_MISSING_OVERFLOW_MSG" : "ERR_MISSING_UNMAPPABLE_MSG";
            }
        }
        catch (Exception exception) {
            string2 = "ERR_MISSING_TYPE_ERROR";
        }
        return string2;
    }

    protected ISpssVariable.Rule getObsSelections(OBS oBS, OBS oBS2, OBS oBS3) {
        ISpssVariable.Rule rule;
        if (this.mNoMissingRadio.isSelected()) {
            rule = ISpssVariable.Rule.none;
        } else if (this.mDiscreteMissingRadio.isSelected()) {
            this.getDiscreteObsFields(oBS, oBS2, oBS3);
            rule = !oBS3.isEmpty() ? ISpssVariable.Rule.three : (!oBS2.isEmpty() ? ISpssVariable.Rule.two : ISpssVariable.Rule.one);
        } else {
            this.getRangeObsFields(oBS, oBS2, oBS3);
            rule = this.mDiscreteRangeField.getText().length() > 0 ? ISpssVariable.Rule.range_plus : ISpssVariable.Rule.range;
        }
        return rule;
    }

    private void getDiscreteObsFields(OBS oBS, OBS oBS2, OBS oBS3) {
        OBS[] oBSArray = new OBS[]{oBS, oBS2, oBS3};
        oBS.setEmpty(true);
        oBS2.setEmpty(true);
        oBS3.setEmpty(true);
        String string = this.mDiscreteField1.getText();
        String string2 = this.mDiscreteField2.getText();
        String string3 = this.mDiscreteField3.getText();
        int n = 0;
        if (string.length() > 0) {
            this.stringToObs(string, oBSArray[n]);
            ++n;
        }
        if (string2.length() > 0) {
            this.stringToObs(string2, oBSArray[n]);
            ++n;
        }
        if (string3.length() > 0) {
            this.stringToObs(string3, oBSArray[n]);
            ++n;
        }
    }

    private void getRangeObsFields(OBS oBS, OBS oBS2, OBS oBS3) {
        oBS.setEmpty(true);
        oBS2.setEmpty(true);
        oBS3.setEmpty(true);
        String string = this.mLowRangeField.getText();
        String string2 = this.mHighRangeField.getText();
        String string3 = this.mDiscreteRangeField.getText();
        this.stringToObsLowHigh(string, oBS);
        this.stringToObsLowHigh(string2, oBS2);
        this.stringToObs(string3, oBS3);
    }

    private boolean stringToObs(String string, OBS oBS) {
        SPSS_Format sPSS_Format = this.mVariable.getFormat();
        if (sPSS_Format.getFormatType().isStringFormat() && sPSS_Format.getWidth() > 8) {
            sPSS_Format.setWidth((short)8);
        }
        return CellValueFormatter.stringToObs((String)string, (SPSS_Format)sPSS_Format, (OBS)oBS);
    }

    private boolean stringToObsLowHigh(String string, OBS oBS) {
        SPSS_Format sPSS_Format = this.mVariable.getFormat();
        if (sPSS_Format.getFormatType().isStringFormat() && sPSS_Format.getWidth() > 8) {
            sPSS_Format.setWidth((short)8);
        }
        if (string != null) {
            string = string.trim();
        }
        if (sPSS_Format.getFormatType().isNumericFormat() && string != null && string.length() > 0) {
            ISpssDataSrc iSpssDataSrc = this.mTableModel.getDataSource();
            double d = iSpssDataSrc.getObslo();
            double d2 = iSpssDataSrc.getObshi();
            if (string.equalsIgnoreCase("LO") || string.equalsIgnoreCase(this.getResString("IDS_LOWEST_STRING_VALUE_FOR_LO"))) {
                oBS.setNum(d);
                return true;
            }
            if (string.equalsIgnoreCase("HI") || string.equalsIgnoreCase(this.getResString("IDS_HIGHEST_STRING_VALUE_FOR_HI"))) {
                oBS.setNum(d2);
                return true;
            }
        }
        return CellValueFormatter.stringToObs((String)string, (SPSS_Format)sPSS_Format, (OBS)oBS);
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "IDH_DEFVAR_MSVAL");
    }

    public class LowHighMissingValueTextField
    extends DlgEditField {
        @Override
        public boolean isFormattedCorrectly() {
            return this.getText().equals("LO") || this.getText().equals("HI") || super.isFormattedCorrectly();
        }

        @Override
        public void setText(String string) {
            if (string != null) {
                string = string.trim();
                String string2 = this.getText();
                if (string.length() == 0 && string2 != null && string2.length() > 0) {
                    if ((string2 = string2.trim()).equalsIgnoreCase("LO") || string2.equalsIgnoreCase(MissingValuesDlg.this.getResString("IDS_LOWEST_STRING_VALUE_FOR_LO"))) {
                        string = "LO";
                    } else if (string2.equalsIgnoreCase("HI") || string2.equalsIgnoreCase(MissingValuesDlg.this.getResString("IDS_HIGHEST_STRING_VALUE_FOR_HI"))) {
                        string = "HI";
                    }
                }
            }
            super.setText(string);
        }

        @Override
        public void commitEdit() throws ParseException {
            String string = this.getText();
            if (string != null && string.length() > 0) {
                if ((string = string.trim()).equalsIgnoreCase("LO") || string.equalsIgnoreCase(MissingValuesDlg.this.getResString("IDS_LOWEST_STRING_VALUE_FOR_LO"))) {
                    super.setText("LO");
                } else if (string.equalsIgnoreCase("HI") || string.equalsIgnoreCase(MissingValuesDlg.this.getResString("IDS_HIGHEST_STRING_VALUE_FOR_HI"))) {
                    super.setText("HI");
                }
            }
            super.commitEdit();
        }

        @Override
        public String getText() {
            try {
                String string = this.getDocument().getText(0, this.getDocument().getLength());
                if (string != null) {
                    string = string.trim();
                }
                if (string == null || string.length() == 0) {
                    return "";
                }
                ISpssDataSrc iSpssDataSrc = MissingValuesDlg.this.mTableModel.getDataSource();
                double d = iSpssDataSrc.getObslo();
                double d2 = iSpssDataSrc.getObshi();
                try {
                    double d3 = Double.parseDouble(string);
                    if (d3 == d) {
                        return "LO";
                    }
                    if (d3 == d2) {
                        return "HI";
                    }
                }
                catch (Exception exception) {
                    if (string.equalsIgnoreCase("LO") || string.equalsIgnoreCase(MissingValuesDlg.this.getResString("IDS_LOWEST_STRING_VALUE_FOR_LO"))) {
                        return "LO";
                    }
                    if (string.equalsIgnoreCase("HI") || string.equalsIgnoreCase(MissingValuesDlg.this.getResString("IDS_HIGHEST_STRING_VALUE_FOR_HI"))) {
                        return "HI";
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
                return "";
            }
            return super.getText();
        }
    }

    class MissingValuesDlgKeyPressListener
    extends DlgKeyPressListener {
        MissingValuesDlgKeyPressListener() {
        }

        public void dialogKeyEvent(KeyEvent keyEvent) {
            JButton jButton;
            int n = keyEvent.getKeyCode();
            Object object = keyEvent.getSource();
            if (n == 10 && (object instanceof MissingValueTextField || object instanceof LowHighMissingValueTextField) && (jButton = this.getDefaultButton((Component)object)) != null) {
                jButton.doClick();
                keyEvent.consume();
            }
        }
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MissingValuesDlg.this.doHelp();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MissingValuesDlg.this.dispose();
        }
    }

    class OkAction
    extends AbstractAction {
        OkAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!MissingValuesDlg.this.validateInput()) {
                return;
            }
            MissingValuesDlg.this.mTableModel.addVariable(MissingValuesDlg.this.mRowIndex, 0, null);
            MissingValuesDlg.this.mVariable = MissingValuesDlg.this.mTableModel.getDataSource().getVariable(MissingValuesDlg.this.mRowIndex);
            OBS oBS = new OBS();
            OBS oBS2 = new OBS();
            OBS oBS3 = new OBS();
            ISpssVariable.Rule rule = MissingValuesDlg.this.getObsSelections(oBS, oBS2, oBS3);
            MissingValueBucket missingValueBucket = new MissingValueBucket(rule, oBS, oBS2, oBS3);
            new VarViewMissingValueEdit(MissingValuesDlg.this.mTableModel, missingValueBucket, MissingValuesDlg.this.mRowIndex, MissingValuesDlg.this.mColumnIndex);
            MissingValuesDlg.this.mModalResult = true;
            MissingValuesDlg.this.dispose();
        }
    }
}

