/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.documents.data;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class LastDocExitWarning
extends BaseDialog {
    MyAWTKeyEventListener mMyAWTKeyEventListener = new MyAWTKeyEventListener();
    private static final String DONT_SHOW_DIALOG = "dont_show_last_de_warning";
    private JCheckBox mDontShowAgainCheck;
    private boolean mDontShowAgain = false;
    private boolean mOKPressed = false;
    private JButton mYesButton;

    public LastDocExitWarning(JFrame jFrame) throws HeadlessException {
        super(jFrame, true, ResUtil.getBundle(null, null), null);
        this.setTitle(VersionInfo.getAppVersionString());
        Toolkit.getDefaultToolkit().addAWTEventListener(this.mMyAWTKeyEventListener, 8L);
        this.pack();
        this.setLocationRelativeTo(jFrame);
    }

    public static boolean runDialog(JFrame jFrame) throws HeadlessException {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("dialog_settings");
        int n = preferences2.getInt(DONT_SHOW_DIALOG, 0);
        if (n != 0) {
            return true;
        }
        LastDocExitWarning lastDocExitWarning = new LastDocExitWarning(jFrame);
        lastDocExitWarning.mYesButton.requestFocusInWindow();
        lastDocExitWarning.setVisible(true);
        return lastDocExitWarning.mOKPressed;
    }

    public void doHelp() {
    }

    protected void init() {
        super.init();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardDialogInsets();
        int n = 23;
        UIDefaults uIDefaults = UIManager.getLookAndFeel().getDefaults();
        JLabel jLabel = new JLabel(uIDefaults.getIcon("OptionPane.questionIcon", ResUtil.getLocale()));
        Insets insets2 = new Insets(8, insets.left, insets.bottom, 4);
        DialogUtil.addUsingGBL(this.getViewPanel(), jLabel, gridBagConstraints, 0, 0, 1, 2, n, insets2);
        JLabel jLabel2 = new JLabel(this.getResString("ERR_LAST_EDITOR_QUERY"));
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        insets2 = new Insets(8, 2, 2, insets.right);
        DialogUtil.addUsingGBL(this.getViewPanel(), jLabel2, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        JLabel jLabel3 = new JLabel(this.getResString("ERR_CONTINUE_PROMPT"));
        insets2 = new Insets(2, 2, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(this.getViewPanel(), jLabel3, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        JLabel jLabel4 = new JLabel("");
        DialogUtil.addUsingGBL(this.getViewPanel(), jLabel4, gridBagConstraints, 0, 2, 2, 1, n, insets2);
        this.mDontShowAgainCheck = new JCheckBox(new DontShowAgainAction());
        jLabel4.setLabelFor(this.mDontShowAgainCheck);
        gridBagConstraints.weighty = 1.0;
        insets2 = new Insets(2, insets.left, 2, insets.right);
        DialogUtil.addUsingGBL(this.getViewPanel(), this.mDontShowAgainCheck, gridBagConstraints, 0, 2, 2, 1, n, insets2);
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        this.mYesButton = new JButton(new YesAction());
        JButton jButton = new JButton(new NoAction());
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mYesButton);
        spssButtonGroup.add(jButton);
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                gridBagConstraints.fill = 2;
                int n2 = 24;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, this.mYesButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mYesButton);
                jPanel.add(jButton);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(this.mYesButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(this.mYesButton);
        return jPanel;
    }

    private void processYesAction() {
        this.mOKPressed = true;
        if (this.mDontShowAgain) {
            Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
            Preferences preferences2 = preferences.node("dialog_settings");
            preferences2.putInt(DONT_SHOW_DIALOG, 1);
        }
        this.dispose();
    }

    private void processNoAction() {
        this.dispose();
    }

    private class MyAWTKeyEventListener
    implements AWTEventListener {
        private MyAWTKeyEventListener() {
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            Object object = aWTEvent.getSource();
            if (object instanceof Component) {
                if (aWTEvent instanceof KeyEvent && ((KeyEvent)aWTEvent).getKeyCode() == ResUtil.getCommonDlgAccessKey("IDK_YES").intValue()) {
                    LastDocExitWarning.this.processYesAction();
                    Toolkit.getDefaultToolkit().removeAWTEventListener(LastDocExitWarning.this.mMyAWTKeyEventListener);
                } else if (aWTEvent instanceof KeyEvent && ((KeyEvent)aWTEvent).getKeyCode() == ResUtil.getCommonDlgAccessKey("IDK_NO").intValue()) {
                    LastDocExitWarning.this.processNoAction();
                    Toolkit.getDefaultToolkit().removeAWTEventListener(LastDocExitWarning.this.mMyAWTKeyEventListener);
                }
            }
        }
    }

    class DontShowAgainAction
    extends AbstractAction {
        public DontShowAgainAction() {
            super(LastDocExitWarning.this.getResString("IDS_DONT_SHOW_AGAIN"));
            if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
                this.putValue("MnemonicKey", LastDocExitWarning.this.getDlgAccessKey("IDK_DONT_SHOW_AGAIN_KEY"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LastDocExitWarning.this.mDontShowAgain = LastDocExitWarning.this.mDontShowAgainCheck.isSelected();
        }
    }

    class NoAction
    extends AbstractAction {
        NoAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_NO"));
            if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
                this.putValue("MnemonicKey", ResUtil.getCommonDlgAccessKey("IDK_NO"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LastDocExitWarning.this.processNoAction();
        }
    }

    class YesAction
    extends AbstractAction {
        YesAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_YES"));
            if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
                this.putValue("MnemonicKey", ResUtil.getCommonDlgAccessKey("IDK_YES"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LastDocExitWarning.this.processYesAction();
        }
    }
}

