/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.documents.data;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.command.ActionCatalog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.data.DataView;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.NumberSpinner;
import com.spss.uitools.controls.TypeAheadCombo;
import com.spss.uitools.help.StatsHelp;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class GoToDataDlg
extends BaseProcedureDialog
implements ChangeListener,
DocumentListener,
TypeAheadCombo.TAComboListener,
PopupMenuListener {
    public static final int CASE = 0;
    public static final int VARIABLE = 1;
    public static final int IMPUTATION = 2;
    private DataFrame mFrame;
    private JTabbedPane mTabbedPane;
    private NumberSpinner mCaseSpinner;
    private TypeAheadCombo mVariableCombo;
    private TypeAheadCombo mMultipleImputationDatasets;
    private JLabel mCaseLabel;
    private JLabel mVarLabel;
    private JButton mGoToCaseButton;
    private JButton mGoToVarButton;
    private JButton mGoToImputationButton;
    private Timer mOpenTimer;
    private int mPreviousGotoCaseNumber = -1;

    public GoToDataDlg(DataFrame dataFrame, int n) throws HeadlessException {
        super(dataFrame, ResUtil.getCommonDlgString("IDS_GO_TO"), false, CommonDlgResBundle.getDefaultResourceBundleName(), CommonDlgResBundle.getImageFolder());
        this.mFrame = dataFrame;
        this.initialize();
        this.pack();
        this.addListeners();
        this.setLocationRelativeTo(dataFrame);
        this.setActiveTab(n);
        this.mOpenTimer = new Timer(300, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GoToDataDlg.this.mOpenTimer.stop();
                GoToDataDlg.this.mOpenTimer = null;
                GoToDataDlg.this.mGoToVarButton.setEnabled(false);
                GoToDataDlg.this.updateCurrentLocation();
                GoToDataDlg.this.addRemoveImputationTab();
            }
        });
        this.mOpenTimer.start();
    }

    public void setActiveTab(int n) {
        this.mTabbedPane.setSelectedIndex(n);
        if (n == 0 || n == 2) {
            this.mFrame.getDataView().setActiveView(0);
        }
    }

    @Override
    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_goto_case_variable");
    }

    @Override
    public String generateSyntax() {
        return "";
    }

    @Override
    public String getDialogHelpID() {
        return null;
    }

    @Override
    public String getIActionKey() {
        return "edit_goto_imputation";
    }

    @Override
    public void dispose() {
        this.cleanup();
        super.dispose();
    }

    private void initialize() {
        JPanel jPanel = this.getViewPanel();
        this.mTabbedPane = new JTabbedPane();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mTabbedPane, gridBagConstraints, 0, 0, 1, 1, n, insets);
        CasePanel casePanel = new CasePanel();
        this.mTabbedPane.addTab(this.getResString("IDS_CASE"), casePanel);
        VarPanel varPanel = new VarPanel();
        this.mTabbedPane.addTab(this.getResString("IDS_VARIABLE"), varPanel);
        ImputationPanel imputationPanel = new ImputationPanel();
        SpssAction spssAction = ActionCatalog.getActionCatalog().getSpssAction("edit_goto_imputation");
        if (spssAction.isEnabled()) {
            this.mTabbedPane.addTab(this.getResString("IDS_IMPUTATION"), imputationPanel);
        }
    }

    private void doGoToCase() {
        DataView dataView = this.mFrame.getDataView();
        Object object = this.mCaseSpinner.getValue();
        int n = (int)dataView.getDataSrc().rowCount() - 1;
        if (object instanceof Integer) {
            int n2 = (Integer)object - 1;
            n2 = Math.min(n2, n);
            n2 = Math.max(n2, 0);
            if (this.mPreviousGotoCaseNumber < 0) {
                this.mPreviousGotoCaseNumber = n2;
            }
            JTable jTable = dataView.getDataTable(0);
            this.mFrame.getDataView().setActiveView(0);
            ListSelectionModel listSelectionModel = jTable.getColumnModel().getSelectionModel();
            int n3 = listSelectionModel.getLeadSelectionIndex();
            dataView.doSelectCells(n3, n3, n2, n2);
            Rectangle rectangle = jTable.getCellRect(n2, n3, false);
            if (rectangle == null) {
                return;
            }
            Rectangle rectangle2 = jTable.getVisibleRect();
            int n4 = (int)(rectangle2.getHeight() / rectangle.getHeight());
            if (n2 + n4 > n) {
                n = n2 + n4;
            }
            Rectangle rectangle3 = jTable.getCellRect(n, n3, false);
            if (this.mPreviousGotoCaseNumber > n2) {
                jTable.scrollRectToVisible(rectangle);
            } else if (this.mPreviousGotoCaseNumber <= n2 && rectangle3 != null) {
                jTable.scrollRectToVisible(rectangle3);
                jTable.scrollRectToVisible(rectangle);
            }
            this.focusTable(jTable);
            this.mPreviousGotoCaseNumber = n2;
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void doGoToVar() {
        DataView dataView = this.mFrame.getDataView();
        Object object = this.mVariableCombo.getSelectedItem();
        if (object instanceof ComboItem) {
            this.mVariableCombo.setSelectedItem(null);
            this.mVariableCombo.requestFocus();
            ComboItem comboItem = (ComboItem)object;
            LocallyUniqueId locallyUniqueId = this.mFrame.getDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            int n = iSpssDataSrc.findVarIndex(comboItem.getVariable().getName());
            if (dataView.getActiveView() == 0) {
                dataView.doSelectColumns(n, n);
                JTable jTable = dataView.getDataTable(0);
                Rectangle rectangle = jTable.getCellRect(0, n, false);
                if (rectangle != null) {
                    jTable.scrollRectToVisible(rectangle);
                }
                this.focusTable(jTable);
            } else {
                dataView.doSelectVarViewRows(n, n);
                JTable jTable = dataView.getDataTable(1);
                Rectangle rectangle = jTable.getCellRect(n, 0, false);
                if (rectangle != null) {
                    jTable.scrollRectToVisible(rectangle);
                }
                this.focusTable(jTable);
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void focusTable(final JTable jTable) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jTable.requestFocus();
            }
        });
    }

    private void doGoToImputation() {
        LocallyUniqueId locallyUniqueId = this.mFrame.getDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        Object object = this.mMultipleImputationDatasets.getSelectedItem();
        if (object instanceof String && iSpssDataSrc.isMultipleImputation()) {
            iSpssDataSrc.getImputationInfo().setCurrentImputedDataset(iSpssDataSrc.getImputationInfo().getImputationNumberFromName(iSpssDataSrc, (String)object));
            if (this.mFrame.getDataView().getActiveView() == 1) {
                this.mFrame.getDataView().setActiveView(0);
            }
            iSpssDataSrc.notifyImputationInfo();
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void cleanup() {
        if (this.mFrame != null) {
            this.mFrame.clearGoToDialog();
        }
        this.mFrame = null;
        this.mVariableCombo.removeContentListener((TypeAheadCombo.TAComboListener)this);
        this.mVariableCombo.removePopupMenuListener((PopupMenuListener)this);
        this.mMultipleImputationDatasets.removeContentListener((TypeAheadCombo.TAComboListener)this);
    }

    private void focusAndSelect(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (n == 0) {
                    JComponent jComponent = GoToDataDlg.this.mCaseSpinner.getEditor();
                    jComponent.requestFocus();
                    if (jComponent instanceof JTextField) {
                        ((JTextField)jComponent).selectAll();
                    }
                } else if (n == 1) {
                    GoToDataDlg.this.mVariableCombo.requestFocus();
                    GoToDataDlg.this.mVariableCombo.getEditor().selectAll();
                } else if (n == 2) {
                    GoToDataDlg.this.mMultipleImputationDatasets.requestFocus();
                    GoToDataDlg.this.mMultipleImputationDatasets.getEditor().selectAll();
                }
            }
        });
    }

    private void updateCurrentLocation() {
        DataView dataView = this.mFrame.getDataView();
        int n = dataView.getDataTable(0).getSelectionModel().getLeadSelectionIndex();
        this.mCaseSpinner.setValue((Object)(n + 1));
        JComponent jComponent = this.mCaseSpinner.getEditor();
        if (jComponent instanceof JTextField) {
            ((JTextField)jComponent).selectAll();
        }
        LocallyUniqueId locallyUniqueId = this.mFrame.getDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        boolean bl = iSpssDataSrc.rowCount() != 0L;
        this.enableCaseControls(bl);
    }

    protected void addRemoveImputationTab() {
        LocallyUniqueId locallyUniqueId = this.mFrame.getDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (!iSpssDataSrc.isMultipleImputation()) {
            if (this.mTabbedPane.getComponentCount() > 2 && this.mTabbedPane.getComponent(2) != null) {
                int n = this.mTabbedPane.getSelectedIndex();
                this.mTabbedPane.remove(2);
                n = n < 0 || n == 2 ? 1 : n;
                this.focusAndSelect(n);
                this.setActiveTab(n);
            }
        } else if (this.mTabbedPane.getComponentCount() <= 2) {
            ImputationPanel imputationPanel = new ImputationPanel();
            this.mTabbedPane.addTab(this.getResString("IDS_IMPUTATION"), imputationPanel);
            this.focusAndSelect(2);
            this.setActiveTab(2);
        }
    }

    @Override
    protected boolean cancelPressed() {
        ProcedureDlgMgr.getMgr().saveDialogSize(this.getIActionKey(), this.getSize());
        ProcedureDlgMgr.getMgr().saveDialogLocation(this.getIActionKey(), this.getLocation());
        return true;
    }

    @Override
    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = super.setupCmdButtonPanel();
        jPanel.remove(this.getOkButton());
        jPanel.remove(this.getPasteButton());
        jPanel.remove(this.getResetButton());
        return jPanel;
    }

    private void loadVariableCombo() {
        this.mVariableCombo.removeAllItems();
        LocallyUniqueId locallyUniqueId = this.mFrame.getDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        Object[] objectArray = new ComboItem[iSpssDataSrc.columnCount()];
        for (int i = 0; i < iSpssDataSrc.columnCount(); ++i) {
            objectArray[i] = new ComboItem(iSpssDataSrc.getVariable(i));
        }
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            this.mVariableCombo.addItem(object);
        }
        boolean bl = this.mVariableCombo.getModel().getSize() > 0;
        this.mVariableCombo.setSelectedItem(null);
        this.enableControls(bl);
    }

    private void loadMultipleImputationDatasetsCombo() {
        this.mMultipleImputationDatasets.removeAllItems();
        LocallyUniqueId locallyUniqueId = this.mFrame.getDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (iSpssDataSrc != null && iSpssDataSrc.isMultipleImputation()) {
            this.mMultipleImputationDatasets.removeAllItems();
            for (String string : iSpssDataSrc.getImputationInfo().getImputedDatasetNames(iSpssDataSrc)) {
                this.mMultipleImputationDatasets.addItem((Object)string);
            }
            int n = iSpssDataSrc.getImputationInfo().getCurrentImputedDataset();
            if (n == -1) {
                n = 0;
            }
            this.mMultipleImputationDatasets.setSelectedItem(iSpssDataSrc.getImputationInfo().getImputedDatasetNames(iSpssDataSrc).get(n));
            this.mMultipleImputationDatasets.setEnabled(true);
        } else {
            this.mMultipleImputationDatasets.setEnabled(false);
        }
    }

    private void enableControls(boolean bl) {
        this.mCaseSpinner.setEnabled(bl);
        this.mVariableCombo.setEnabled(bl);
        this.mCaseLabel.setEnabled(bl);
        this.mVarLabel.setEnabled(bl);
        this.mGoToCaseButton.setEnabled(bl);
        this.mGoToVarButton.setEnabled(bl);
    }

    private void enableCaseControls(boolean bl) {
        this.mCaseSpinner.setEnabled(bl);
        this.mCaseLabel.setEnabled(bl);
        this.mGoToCaseButton.setEnabled(bl);
    }

    private void addListeners() {
        this.mTabbedPane.addChangeListener(this);
        this.mVariableCombo.addContentListener((TypeAheadCombo.TAComboListener)this);
        this.mVariableCombo.addPopupMenuListener((PopupMenuListener)this);
        this.mMultipleImputationDatasets.addContentListener((TypeAheadCombo.TAComboListener)this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                GoToDataDlg.this.checkForVarChanges();
                GoToDataDlg.this.updateCurrentLocation();
            }
        });
        JComponent jComponent = this.mCaseSpinner.getEditor();
        if (jComponent instanceof JTextField) {
            jComponent.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        GoToDataDlg.this.mGoToCaseButton.doClick();
                    }
                }
            });
            ((JTextField)jComponent).getDocument().addDocumentListener(this);
        }
        this.mMultipleImputationDatasets.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    GoToDataDlg.this.mGoToImputationButton.doClick();
                }
            }
        });
        Component component = this.mVariableCombo.getEditor().getEditorComponent();
        if (component instanceof JTextField) {
            component.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        GoToDataDlg.this.mGoToVarButton.doClick();
                    }
                }
            });
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                GoToDataDlg.this.addRemoveImputationTab();
            }
        });
    }

    private void checkForVarChanges() {
        int n;
        boolean bl = false;
        LocallyUniqueId locallyUniqueId = this.mFrame.getDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        Object[] objectArray = new ComboItem[iSpssDataSrc.columnCount()];
        for (n = 0; n < iSpssDataSrc.columnCount(); ++n) {
            objectArray[n] = new ComboItem(iSpssDataSrc.getVariable(n));
        }
        Arrays.sort(objectArray);
        n = this.mVariableCombo.getModel().getSize();
        if (objectArray.length != n) {
            bl = true;
        } else {
            for (int i = 0; i < n; ++i) {
                if (this.mVariableCombo.getModel().getElementAt(i).equals(objectArray[i])) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            this.loadVariableCombo();
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        int n = this.mTabbedPane.getSelectedIndex();
        this.focusAndSelect(n);
        JButton jButton = null;
        if (n == 0) {
            jButton = this.mGoToCaseButton;
        } else if (n == 1) {
            jButton = this.mGoToVarButton;
        } else if (n == 2) {
            jButton = this.mGoToImputationButton;
        }
        if (jButton != null) {
            this.getRootPane().setDefaultButton(jButton);
            this.mKeyAdapter.resetDefaultButton();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateCaseGoButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateCaseGoButton();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateCaseGoButton();
    }

    private void updateCaseGoButton() {
        String string = ((JTextField)this.mCaseSpinner.getEditor()).getText();
        boolean bl = string != null && string.length() > 0 && !string.equals("0");
        this.mGoToCaseButton.setEnabled(bl);
    }

    public void contentChanged(boolean bl) {
        this.mGoToVarButton.setEnabled(bl);
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        this.focusAndSelect(1);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    class GoToImputationAction
    extends AbstractAction {
        GoToImputationAction() {
            this.putValue("Name", GoToDataDlg.this.getResString("IDS_GO"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GoToDataDlg.this.doGoToImputation();
        }
    }

    class GoToVarAction
    extends AbstractAction {
        GoToVarAction() {
            this.putValue("Name", GoToDataDlg.this.getResString("IDS_GO"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GoToDataDlg.this.doGoToVar();
        }
    }

    class GoToCaseAction
    extends AbstractAction {
        GoToCaseAction() {
            this.putValue("Name", GoToDataDlg.this.getResString("IDS_GO"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GoToDataDlg.this.doGoToCase();
        }
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GoToDataDlg.this.doHelp();
        }
    }

    class CloseAction
    extends AbstractAction {
        CloseAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CLOSE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ProcedureDlgMgr.getMgr().saveDialogSize(GoToDataDlg.this.getIActionKey(), GoToDataDlg.this.getSize());
            ProcedureDlgMgr.getMgr().saveDialogLocation(GoToDataDlg.this.getIActionKey(), GoToDataDlg.this.getLocation());
            GoToDataDlg.this.dispose();
        }
    }

    class ImputationPanel
    extends JPanel {
        public ImputationPanel() {
            super(new GridBagLayout(), true);
            this.init();
            GoToDataDlg.this.loadMultipleImputationDatasetsCombo();
        }

        private void init() {
            JLabel jLabel = new JLabel(GoToDataDlg.this.getResString("IDS_GOTO_DATASET"));
            jLabel.setDisplayedMnemonic(GoToDataDlg.this.getDlgAccessKey("IDK_GOTO_DATASET_KEY"));
            GoToDataDlg.this.mMultipleImputationDatasets = new TypeAheadCombo();
            GoToDataDlg.this.mMultipleImputationDatasets.setEditable(false);
            GoToDataDlg.this.mMultipleImputationDatasets.setMaximumRowCount(10);
            jLabel.setLabelFor((Component)GoToDataDlg.this.mMultipleImputationDatasets);
            Dimension dimension = GoToDataDlg.this.mMultipleImputationDatasets.getPreferredSize();
            dimension.width = 150;
            GoToDataDlg.this.mMultipleImputationDatasets.setPreferredSize(dimension);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            Insets insets = DialogUtil.getStandardControlInsets();
            Insets insets2 = (Insets)insets.clone();
            Insets insets3 = (Insets)insets.clone();
            insets2.top += DialogUtil.getComponentGroupGap();
            insets3.bottom += DialogUtil.getComponentGroupGap();
            int n = 23;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            DialogUtil.addUsingGBL(this, jLabel, gridBagConstraints, 0, 0, 2, 1, n, insets2);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            DialogUtil.addUsingGBL(this, (JComponent)GoToDataDlg.this.mMultipleImputationDatasets, gridBagConstraints, 0, 1, 1, 1, n, insets3);
            GoToDataDlg.this.mGoToImputationButton = new JButton(new GoToImputationAction());
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            DialogUtil.addUsingGBL(this, GoToDataDlg.this.mGoToImputationButton, gridBagConstraints, 1, 1, 1, 1, n, insets3);
        }
    }

    class VarPanel
    extends JPanel {
        public VarPanel() {
            super(new GridBagLayout(), true);
            this.init();
            GoToDataDlg.this.loadVariableCombo();
        }

        private void init() {
            GoToDataDlg.this.mVarLabel = new JLabel(GoToDataDlg.this.getResString("IDS_GOTO_VARIABLE"));
            GoToDataDlg.this.mVarLabel.setDisplayedMnemonic(GoToDataDlg.this.getDlgAccessKey("IDK_GOTO_VARIABLE_KEY"));
            GoToDataDlg.this.mVariableCombo = new TypeAheadCombo();
            GoToDataDlg.this.mVariableCombo.setEditable(true);
            GoToDataDlg.this.mVariableCombo.setMaximumRowCount(10);
            GoToDataDlg.this.mVarLabel.setLabelFor((Component)GoToDataDlg.this.mVariableCombo);
            Dimension dimension = GoToDataDlg.this.mVariableCombo.getPreferredSize();
            dimension.width = 150;
            GoToDataDlg.this.mVariableCombo.setPreferredSize(dimension);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            Insets insets = DialogUtil.getStandardControlInsets();
            Insets insets2 = (Insets)insets.clone();
            Insets insets3 = (Insets)insets.clone();
            insets2.top += DialogUtil.getComponentGroupGap();
            insets3.bottom += DialogUtil.getComponentGroupGap();
            int n = 23;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            DialogUtil.addUsingGBL(this, GoToDataDlg.this.mVarLabel, gridBagConstraints, 0, 0, 2, 1, n, insets2);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            DialogUtil.addUsingGBL(this, (JComponent)GoToDataDlg.this.mVariableCombo, gridBagConstraints, 0, 1, 1, 1, n, insets3);
            GoToDataDlg.this.mGoToVarButton = new JButton(new GoToVarAction());
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            DialogUtil.addUsingGBL(this, GoToDataDlg.this.mGoToVarButton, gridBagConstraints, 1, 1, 1, 1, n, insets3);
        }
    }

    class CasePanel
    extends JPanel {
        public CasePanel() {
            super(new GridBagLayout(), true);
            this.init();
        }

        private void init() {
            GoToDataDlg.this.mCaseLabel = new JLabel(GoToDataDlg.this.getResString("IDS_GOTO_CASE_NUM"));
            GoToDataDlg.this.mCaseLabel.setDisplayedMnemonic(GoToDataDlg.this.getDlgAccessKey("IDK_GOTO_CASE_NUM_KEY"));
            SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1);
            IntTextField intTextField = new IntTextField(true);
            GoToDataDlg.this.mCaseSpinner = new NumberSpinner(intTextField, spinnerNumberModel);
            GoToDataDlg.this.mCaseLabel.setLabelFor((Component)GoToDataDlg.this.mCaseSpinner);
            Dimension dimension = GoToDataDlg.this.mCaseSpinner.getPreferredSize();
            dimension.width = 150;
            GoToDataDlg.this.mCaseSpinner.setPreferredSize(dimension);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            Insets insets = DialogUtil.getStandardControlInsets();
            Insets insets2 = (Insets)insets.clone();
            Insets insets3 = (Insets)insets.clone();
            insets2.top += DialogUtil.getComponentGroupGap();
            insets3.bottom += DialogUtil.getComponentGroupGap();
            int n = 23;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            DialogUtil.addUsingGBL(this, GoToDataDlg.this.mCaseLabel, gridBagConstraints, 0, 0, 2, 1, n, insets2);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            DialogUtil.addUsingGBL(this, (JComponent)GoToDataDlg.this.mCaseSpinner, gridBagConstraints, 0, 1, 1, 1, n, insets3);
            GoToDataDlg.this.mGoToCaseButton = new JButton(new GoToCaseAction());
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            DialogUtil.addUsingGBL(this, GoToDataDlg.this.mGoToCaseButton, gridBagConstraints, 1, 1, 1, 1, n, insets3);
        }
    }

    class ComboItem
    implements Comparable<ComboItem> {
        private ISpssVariable mVariable;

        public ComboItem(ISpssVariable iSpssVariable) {
            this.mVariable = iSpssVariable;
        }

        public ISpssVariable getVariable() {
            return this.mVariable;
        }

        public String toString() {
            return this.mVariable.getName();
        }

        public boolean equals(Object object) {
            if (object instanceof ComboItem) {
                ComboItem comboItem = (ComboItem)object;
                return this.mVariable.getName().equals(comboItem.mVariable.getName());
            }
            return false;
        }

        @Override
        public int compareTo(ComboItem comboItem) {
            return this.toString().compareTo(comboItem.toString());
        }
    }
}

