/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.documents.data;

import com.spss.java_client.core.server.messages.ReportedErrorDataMsg;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class DatasourceErrorDlg
extends BaseDialog {
    private ReportedErrorDataMsg mErrorMsg;
    private boolean mIsFatal;
    private JCheckBox mDontShowAgainCheck;
    private boolean mDontShowAgain = false;

    public DatasourceErrorDlg(JFrame jFrame, ReportedErrorDataMsg reportedErrorDataMsg) throws HeadlessException {
        super(jFrame, ResUtil.getCommonDlgString("IDS_DS_MSGS"), true, ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), CommonDlgResBundle.getImageFolder());
        this.mErrorMsg = reportedErrorDataMsg;
        this.mIsFatal = this.mErrorMsg.getSeverityCode().equals((Object)ReportedErrorDataMsg.SeverityCode.kFatalError);
        this.initialize();
        this.pack();
        this.setLocationRelativeTo(jFrame);
    }

    public boolean getDontShowAgain() {
        return this.mDontShowAgain;
    }

    public void doHelp() {
    }

    private void initialize() {
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        Icon icon = UIManager.getIcon(this.mIsFatal ? "OptionPane.errorIcon" : "OptionPane.warningIcon");
        JLabel jLabel = icon != null ? new JLabel(icon) : new JLabel();
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JTextArea jTextArea = new JTextArea(this.mErrorMsg.getStrErrorText(), 4, 30);
        jTextArea.setEditable(false);
        jTextArea.setBackground(SystemColor.control);
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 1, 0, 1, 1, n, insets);
        if (!this.mIsFatal) {
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 2;
            this.mDontShowAgainCheck = new JCheckBox(this.getResString("IDS_STOP_DS_WARNINGS"), false);
            DialogUtil.addUsingGBL(jPanel, this.mDontShowAgainCheck, gridBagConstraints, 0, 1, 2, 1, n, insets);
        }
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
        int n = insets.left + insets.right;
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            FlowLayout flowLayout = new FlowLayout(2, n, 0);
            jPanel.setLayout(flowLayout);
        } else {
            FlowLayout flowLayout = new FlowLayout(1, n, 0);
            jPanel.setLayout(flowLayout);
        }
        JButton jButton = new JButton(new OkAction());
        jPanel.add(jButton);
        this.getRootPane().setDefaultButton(jButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    class OkAction
    extends AbstractAction {
        OkAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!DatasourceErrorDlg.this.mIsFatal) {
                DatasourceErrorDlg.this.mDontShowAgain = DatasourceErrorDlg.this.mDontShowAgainCheck.isSelected();
            }
            DatasourceErrorDlg.this.dispose();
        }
    }
}

