/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.documents.data;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.DatasourceAttributes;
import com.spss.java_client.core.documents.data.dictionary.ExtensionType;
import com.spss.java_client.core.documents.data.dictionary.IDatasourceAttributes;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.ui.controls.PlainListArrowButton;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.data.VarViewTableModel;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.row_management_table.AbstractListTableModel;
import com.spss.uitools.controls.row_management_table.RowManagementTablePanel;
import com.spss.uitools.controls.row_management_table.TableRowManagementHelper;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.util.TableUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class CustomizeVariableViewDlg
extends BaseDialog {
    public final String SHOW_COLUMN_NAME = this.getResString("IDS_CVV_SHOW_COLUMN");
    public final String[] COLUMN_NAMES = new String[]{this.SHOW_COLUMN_NAME, this.getResString("IDS_CVV_NAME_COLUMN")};
    private AttributeTable mAttributeTable;
    private boolean mOkAction = false;
    private JButton mOKButton;
    private JButton mRestoreButton;
    private boolean mFromOptions;
    private boolean mIsDefault = false;
    private Vector<String> mOptionsAttrs;

    public CustomizeVariableViewDlg(DataFrame dataFrame) throws HeadlessException {
        super((JFrame)dataFrame, ResUtil.getCommonDlgString("IDS_CVV_TITLE"), true, ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), CommonDlgResBundle.getImageFolder());
        this.mFromOptions = false;
        this.mOptionsAttrs = null;
        this.myInit();
        this.setLocationRelativeTo(dataFrame);
    }

    public CustomizeVariableViewDlg(BaseDialog baseDialog, Vector<String> vector) throws HeadlessException {
        super(baseDialog, ResUtil.getCommonDlgString("IDS_CVV_TITLE"), true, ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), CommonDlgResBundle.getImageFolder());
        this.mFromOptions = true;
        this.mOptionsAttrs = vector;
        this.myInit();
        this.setLocationRelativeTo((Component)baseDialog);
    }

    public boolean isOkAction() {
        return this.mOkAction;
    }

    public DataFrame getDataFrame() {
        return (DataFrame)this.getOwner();
    }

    public void doHelp() {
        if (this.mFromOptions) {
            StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_customize_default_variable_order");
        } else {
            StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_customize_variable_order");
        }
    }

    private Vector<String> getCustomAttributeNames() {
        ISpssDataSrc iSpssDataSrc = this.getDataFrame().getDataView().getDataSrc();
        HashSet hashSet = new HashSet();
        if (iSpssDataSrc != null) {
            int n = iSpssDataSrc.columnCount();
            for (int i = 0; i < n; ++i) {
                Object object = iSpssDataSrc.getVariable(i);
                IDatasourceAttributes iDatasourceAttributes = object.getAttributes();
                Vector vector = SpssVariable.getAttributeNames((IDatasourceAttributes)iDatasourceAttributes);
                hashSet.addAll(vector);
            }
        }
        Vector<String> vector = new Vector<String>();
        for (Object object : hashSet) {
            if (((String)object).startsWith("@") || ((String)object).startsWith("$")) continue;
            vector.add((String)object);
        }
        return vector;
    }

    private boolean isValidColumnId(String string) {
        return string.startsWith("@") || string.equals("name") || string.equals("type") || string.equals("width") || string.equals("decimals") || string.equals("label") || string.equals("values") || string.equals("missing") || string.equals("columns") || string.equals("alignment") || string.equals("measure") || string.equals("role");
    }

    private void myInit() {
        Vector<AttributeInfo> vector = this.createAttributeInfos(false);
        JPanel jPanel = this.getViewPanel();
        this.setupViewPanel(jPanel, vector);
        this.setTitle(this.getResString("IDS_CVV_TITLE"));
        this.setLocationRelativeTo(this.getParent());
        this.pack();
        Dimension dimension = this.getSizeConstraints();
        this.setSizeConstraints(new Dimension((int)dimension.getWidth(), (int)dimension.getHeight() - 100));
    }

    /*
     * WARNING - void declaration
     */
    private Vector<AttributeInfo> createAttributeInfos(boolean bl) {
        Vector<String> vector;
        Vector<AttributeInfo> vector2 = new Vector<AttributeInfo>();
        Vector<String> vector3 = !this.mFromOptions ? this.getCustomAttributeNames() : new Vector();
        Collections.sort(vector3);
        Vector vector4 = PrefsMgr.getPrefsMgr().getDefaultVarViewDisplayColumns();
        Vector<Object> vector5 = new Vector(vector4);
        Vector vector6 = null;
        if (!this.mFromOptions) {
            void var9_14;
            ISpssDataSrc iSpssDataSrc = this.getDataFrame().getDataView().getDataSrc();
            IDatasourceAttributes object2 = iSpssDataSrc.getAttributes();
            if (object2 == null) {
                DatasourceAttributes datasourceAttributes = new DatasourceAttributes();
                iSpssDataSrc.setAttributes((IDatasourceAttributes)datasourceAttributes);
            }
            vector6 = var9_14.values("$de.displayedattributes");
            vector = var9_14.values("$VariableView2");
        } else {
            vector = this.mOptionsAttrs;
        }
        if (vector == null) {
            vector = new Vector();
        }
        for (int i = vector.size() - 1; i >= 0; --i) {
            String string = vector.get(i);
            if (this.isValidColumnId(string)) continue;
            vector.remove(string);
        }
        if (!this.mFromOptions && vector6 != null && vector6.size() > 0) {
            for (String string : vector6) {
                vector5.add("@" + string);
            }
        } else if (!bl && vector.size() > 0) {
            vector5 = new Vector<String>(vector);
        } else if (!this.mFromOptions) {
            for (String string : vector3) {
                vector5.add("@" + string);
            }
            this.mIsDefault = true;
        }
        for (String string : vector5) {
            AttributeInfo attributeInfo = new AttributeInfo(string, true);
            vector2.add(attributeInfo);
        }
        Vector<String> vector7 = this.makeAllNamesVector();
        this.appendHiddenAttributes(vector2, vector7, vector3);
        return vector2;
    }

    private Vector<String> makeAllNamesVector() {
        Vector<String> vector = new Vector<String>();
        vector.add("name");
        vector.add("type");
        vector.add("width");
        vector.add("decimals");
        vector.add("label");
        vector.add("values");
        vector.add("missing");
        vector.add("columns");
        vector.add("alignment");
        vector.add("measure");
        vector.add("role");
        return vector;
    }

    private Vector<String> appendHiddenAttributes(Vector<AttributeInfo> vector, Vector<String> vector2, Vector<String> vector3) {
        AttributeInfo attributeInfo;
        for (String string : vector2) {
            attributeInfo = this.findAttributeInfo(vector, string, false);
            if (attributeInfo != null) continue;
            vector.add(new AttributeInfo(string, false));
        }
        for (String string : vector3) {
            attributeInfo = this.findAttributeInfo(vector, string, true);
            if (attributeInfo != null) continue;
            vector.add(new AttributeInfo("@" + string, false));
        }
        return null;
    }

    private AttributeInfo findAttributeInfo(Vector<AttributeInfo> vector, String string, boolean bl) {
        AttributeInfo attributeInfo = null;
        if (string != null && string.length() > 0) {
            for (AttributeInfo attributeInfo2 : vector) {
                if (!string.equalsIgnoreCase(attributeInfo2.getName()) || (!bl || !attributeInfo2.mIsCustomAttributeName) && (bl || attributeInfo2.mIsCustomAttributeName)) continue;
                attributeInfo = attributeInfo2;
                break;
            }
        }
        return attributeInfo;
    }

    private void setupViewPanel(JPanel jPanel, Vector<AttributeInfo> vector) {
        AttributePanel attributePanel = this.createAttributePanel(vector);
        RestoreDefaultsAction restoreDefaultsAction = new RestoreDefaultsAction();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_CVV_TABLE_STATIC_TEXT");
        jLabel.setLabelFor(this.mAttributeTable);
        this.mRestoreButton = new JButton(restoreDefaultsAction);
        this.mRestoreButton.setEnabled(!this.mFromOptions && !this.mIsDefault);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 18;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)attributePanel), gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 13;
        DialogUtil.addUsingGBL(jPanel, this.mRestoreButton, gridBagConstraints, 0, 2, 1, 1, n, new Insets(1, 1, 1, 50));
    }

    private AttributePanel createAttributePanel(Vector<AttributeInfo> vector) {
        AttributeTableModel attributeTableModel = new AttributeTableModel(vector);
        this.mAttributeTable = new AttributeTable((TableModel)((Object)attributeTableModel));
        this.mAttributeTable.setAutoResizeMode(3);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
            }
        };
        this.mAttributeTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 0), "tabOut");
        this.mAttributeTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 1), "tabIn");
        this.mAttributeTable.getActionMap().put("tabIn", abstractAction2);
        this.mAttributeTable.getActionMap().put("tabOut", abstractAction);
        return new AttributePanel(this.mAttributeTable);
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
        this.mOKButton = new JButton(new OkAction());
        JButton jButton = new JButton(new CancelAction());
        JButton jButton2 = new JButton(new HelpAction());
        DialogUtil.setupMacHelpButton(jButton2);
        Insets insets = DialogUtil.getStandardButtonInsets();
        int n = insets.left + insets.right;
        if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            Insets insets2 = new Insets(0, n, 0, 0);
            int n2 = 23;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 2;
            DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 0, 0, 1, 1, n2, null);
            n2 = 24;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 0;
            DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            DialogUtil.addUsingGBL(jPanel, this.mOKButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
        } else {
            FlowLayout flowLayout = new FlowLayout(1, n, 0);
            jPanel.setLayout(flowLayout);
            jPanel.add(this.mOKButton);
            jPanel.add(jButton);
            jPanel.add(jButton2);
        }
        this.getRootPane().setDefaultButton(this.mOKButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private void enableControls() {
        if (this.mOKButton != null) {
            boolean bl = this.mAttributeTable.getSelectedAttributes(false).size() >= 1;
            this.mOKButton.setEnabled(bl);
        }
    }

    class AttributeInfo
    implements Comparable<AttributeInfo> {
        private String mName;
        private boolean mIsCustomAttributeName;
        private boolean mIsSelected;
        private String mDisplayText;

        public AttributeInfo(String string) {
            this(string, true);
        }

        public AttributeInfo(String string, boolean bl) {
            this.mIsCustomAttributeName = string.indexOf("@") == 0;
            this.mName = this.removeCustomAttributeFlag(string);
            this.mIsSelected = bl;
            this.mDisplayText = this.getFormattedName(this.mName);
        }

        private String getFormattedName(String string) {
            String string2 = VarViewTableModel.columnIdToColumnName(string);
            string2 = string2 != null && string2.length() > 0 ? string2 : string;
            string2 = this.mIsCustomAttributeName ? "[" + string2 + "]" : string2;
            return string2;
        }

        public boolean equals(Object object) {
            if (object instanceof AttributeInfo) {
                return this.mName.equals(((AttributeInfo)object).getName());
            }
            return super.equals(object);
        }

        @Override
        public int compareTo(AttributeInfo attributeInfo) {
            return this.mName.compareTo(attributeInfo.getName());
        }

        public String getName() {
            return this.mName;
        }

        public void setName(String string) {
            this.mName = string;
        }

        public String getDisplayText() {
            return this.mDisplayText;
        }

        public boolean isSelected() {
            return this.mIsSelected;
        }

        public void setSelected(boolean bl) {
            this.mIsSelected = bl;
        }

        private String removeCustomAttributeFlag(String string) {
            return this.mIsCustomAttributeName && string.length() > 1 ? string.substring(1) : string;
        }
    }

    class AttributeTableModel
    extends AbstractListTableModel {
        public AttributeTableModel(Vector<AttributeInfo> vector) {
            this.addAttributeInfos(vector);
        }

        public void setAttributeInfos(Vector<AttributeInfo> vector) {
            this.setList(vector);
        }

        protected String[] createDefaultColumnNames() {
            return new String[]{CustomizeVariableViewDlg.this.getResString("IDS_CVV_SHOW_COLUMN"), CustomizeVariableViewDlg.this.getResString("IDS_CVV_NAME_COLUMN")};
        }

        protected Object createDefaultEntry() {
            return " ";
        }

        public void fireTableChanged(TableModelEvent tableModelEvent) {
            super.fireTableChanged(tableModelEvent);
            if (CustomizeVariableViewDlg.this.mRestoreButton != null) {
                CustomizeVariableViewDlg.this.mRestoreButton.setEnabled(!CustomizeVariableViewDlg.this.mFromOptions);
            }
        }

        public int getRowCount() {
            return this.getAttributeInfos().size();
        }

        public int getColumnCount() {
            return CustomizeVariableViewDlg.this.COLUMN_NAMES.length;
        }

        public String getColumnName(int n) {
            return CustomizeVariableViewDlg.this.COLUMN_NAMES[n];
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.getAttributeInfos().get(n).isSelected();
            }
            return this.getAttributeInfos().get(n);
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0 && object instanceof Boolean) {
                AttributeInfo attributeInfo = this.getAttributeInfos().get(n);
                attributeInfo.setSelected((Boolean)object);
                CustomizeVariableViewDlg.this.mRestoreButton.setEnabled(!CustomizeVariableViewDlg.this.mFromOptions);
                CustomizeVariableViewDlg.this.enableControls();
            }
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            return AttributeInfo.class;
        }

        private void addAttributeInfos(Vector<AttributeInfo> vector) {
            if (vector == null) {
                vector = new Vector();
            }
            Object[] objectArray = vector.toArray(new AttributeInfo[vector.size()]);
            Arrays.sort(objectArray);
            this.setList(vector);
        }

        private List<AttributeInfo> getAttributeInfos() {
            return this.getList();
        }

        private Vector<String> getAttributeNames(boolean bl, boolean bl2) {
            Vector<String> vector = new Vector<String>();
            for (AttributeInfo attributeInfo : this.getAttributeInfos()) {
                String string;
                String string2 = string = bl2 && attributeInfo.mIsCustomAttributeName ? "@" + attributeInfo.getName() : attributeInfo.getName();
                if (bl && attributeInfo.mIsSelected) {
                    vector.add(string);
                    continue;
                }
                if (bl || attributeInfo.mIsSelected) continue;
                vector.add(string);
            }
            return vector;
        }
    }

    class AttributeTable
    extends JTable {
        public AttributeTable(TableModel tableModel) {
            super(tableModel);
            this.getTableHeader().setReorderingAllowed(false);
            this.getTableHeader().setResizingAllowed(false);
            this.initShowColumn();
            this.initNameColumn();
        }

        @Override
        public void setModel(TableModel tableModel) {
            super.setModel(tableModel);
        }

        private void initNameColumn() {
            TableColumn tableColumn = this.getColumnModel().getColumn(1);
            tableColumn.setCellRenderer(new MyCellRenderer());
        }

        public Vector<String> getSelectedAttributes(boolean bl) {
            return ((AttributeTableModel)((Object)CustomizeVariableViewDlg.this.mAttributeTable.getModel())).getAttributeNames(true, bl);
        }

        public void setShowColSelectionState(boolean bl) {
            int[] nArray;
            for (int n : nArray = this.getSelectedRows()) {
                this.setValueAt(bl, n, 0);
            }
            this.repaint();
        }

        private void initShowColumn() {
            TableColumn tableColumn = this.getColumnModel().getColumn(0);
            int n = TableUtilities.calculateColumnHeaderTextWidth((JTable)this, (int)0);
            tableColumn.setWidth(n);
            tableColumn.setPreferredWidth(n);
            tableColumn.setMaxWidth(n);
        }

        @Override
        protected void processMouseEvent(MouseEvent mouseEvent) {
            int n = mouseEvent.getID();
            Point point = mouseEvent.getPoint();
            int n2 = this.rowAtPoint(point);
            boolean bl = TableUtilities.isSelectedRow((JTable)this, (int)n2);
            int n3 = this.columnAtPoint(point);
            if (n2 >= 0 && n3 >= 0) {
                String string = this.getColumnName(n3);
                boolean bl2 = string.equals(CustomizeVariableViewDlg.this.SHOW_COLUMN_NAME);
                int[] nArray = this.getSelectedRows();
                if (n == 501) {
                    if (bl) {
                        mouseEvent.consume();
                    }
                    if (bl2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        boolean bl3;
                        super.processMouseEvent(mouseEvent);
                        boolean bl4 = bl3 = (Boolean)this.getValueAt(n2, 0) == false;
                        if (nArray.length == 1 || bl) {
                            this.setShowColSelectionState(bl3);
                            mouseEvent.consume();
                        }
                    } else {
                        super.processMouseEvent(mouseEvent);
                    }
                } else if (n == 502 && bl2) {
                    if (nArray.length > 1) {
                        mouseEvent.consume();
                    }
                    super.processMouseEvent(mouseEvent);
                } else {
                    super.processMouseEvent(mouseEvent);
                }
            } else {
                super.processMouseEvent(mouseEvent);
            }
        }

        @Override
        protected void processKeyEvent(KeyEvent keyEvent) {
            int n;
            if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 32 && this.isRowSelected(n = this.getSelectionModel().getAnchorSelectionIndex())) {
                boolean bl = (Boolean)this.getValueAt(n, 0) == false;
                this.setShowColSelectionState(bl);
                keyEvent.consume();
            }
            super.processKeyEvent(keyEvent);
        }

        private class MyCellRenderer
        extends DefaultTableCellRenderer {
            private MyCellRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                if (ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0) {
                    super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2);
                } else {
                    super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                }
                if (object != null) {
                    AttributeInfo attributeInfo = (AttributeInfo)object;
                    String string = attributeInfo.getDisplayText();
                    this.setText(string);
                }
                return this;
            }

            @Override
            public void setText(String string) {
                if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                    super.setText(ComponentState.prepareStringForBidiRendering((String)string));
                } else {
                    super.setText(string);
                }
            }

            @Override
            public void setToolTipText(String string) {
                if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                    super.setToolTipText(ComponentState.prepareStringForBidiRendering((String)string));
                } else {
                    super.setToolTipText(string);
                }
            }
        }
    }

    private class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CustomizeVariableViewDlg.this.doHelp();
        }
    }

    private class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CustomizeVariableViewDlg.this.dispose();
        }
    }

    private class OkAction
    extends AbstractAction {
        OkAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Vector<String> vector = CustomizeVariableViewDlg.this.mAttributeTable.getSelectedAttributes(true);
            if (!CustomizeVariableViewDlg.this.mFromOptions) {
                ISpssDataSrc iSpssDataSrc = CustomizeVariableViewDlg.this.getDataFrame().getDataView().getDataSrc();
                iSpssDataSrc.setModified(true);
                IDatasourceAttributes iDatasourceAttributes = iSpssDataSrc.getAttributes();
                iDatasourceAttributes.put("$VariableView2", vector);
                iDatasourceAttributes.remove("$de.displayedattributes");
                DataMgr.getDataMgr().sendDataSrcExtensionsMsg(iSpssDataSrc.getDataSetId(), iDatasourceAttributes.toString(), ExtensionType.kDatasetAttributes, 1);
            } else {
                CustomizeVariableViewDlg.this.mOptionsAttrs.clear();
                CustomizeVariableViewDlg.this.mOptionsAttrs.addAll(vector);
            }
            CustomizeVariableViewDlg.this.mOkAction = true;
            CustomizeVariableViewDlg.this.dispose();
        }
    }

    class AttributePanel
    extends RowManagementTablePanel
    implements ListSelectionListener {
        private UpDownArrowButton mUpArrowButton;
        private UpDownArrowButton mDownArrowButton;

        public AttributePanel(AttributeTable attributeTable) {
            super((JTable)attributeTable);
            this.scrollPane.setPreferredSize(new Dimension(250, 250));
            this.mUpArrowButton = new UpDownArrowButton(SpssArrowButton.ButtonOrientation.up);
            this.mDownArrowButton = new UpDownArrowButton(SpssArrowButton.ButtonOrientation.down);
            this.addMoveUpButton(this.mUpArrowButton);
            this.addMoveDownButton(this.mDownArrowButton);
            ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
            this.mUpArrowButton.getAccessibleContext().setAccessibleName(resourceBundle.getString("DataLabelsPaletteMoveBtn0_SPEECH"));
            this.mDownArrowButton.getAccessibleContext().setAccessibleName(resourceBundle.getString("DataLabelsPaletteMoveBtn1_SPEECH"));
            attributeTable.getSelectionModel().setSelectionInterval(0, 0);
            this.updateArrows();
        }

        protected TableRowManagementHelper initRowEditableHelper() {
            return new TableRowManagementHelper();
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateArrows();
            CustomizeVariableViewDlg.this.mRestoreButton.setEnabled(!CustomizeVariableViewDlg.this.mFromOptions);
        }

        private void updateArrows() {
            this.mUpArrowButton.setEnabled(CustomizeVariableViewDlg.this.mAttributeTable.getSelectedRow() > 0);
            this.mUpArrowButton.setOpaque(CustomizeVariableViewDlg.this.mAttributeTable.getSelectedRow() > 0);
            int n = CustomizeVariableViewDlg.this.mAttributeTable.getRowCount();
            int n2 = CustomizeVariableViewDlg.this.mAttributeTable.getSelectionModel().getMaxSelectionIndex();
            this.mDownArrowButton.setEnabled(n2 + 1 < n);
            this.mDownArrowButton.setOpaque(n2 + 1 < n);
        }

        class UpDownArrowButton
        extends PlainListArrowButton {
            public UpDownArrowButton(SpssArrowButton.ButtonOrientation buttonOrientation) {
                super(buttonOrientation);
            }
        }
    }

    private class RestoreDefaultsAction
    extends ToggleButtonAction {
        public RestoreDefaultsAction() {
            super(CustomizeVariableViewDlg.this, "IDS_CVV_RESTORE_DEFAULTS_BUTTON");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Vector vector = CustomizeVariableViewDlg.this.createAttributeInfos(true);
            AttributeTableModel attributeTableModel = (AttributeTableModel)((Object)CustomizeVariableViewDlg.this.mAttributeTable.getModel());
            attributeTableModel.setAttributeInfos(vector);
            CustomizeVariableViewDlg.this.mRestoreButton.setEnabled(false);
        }
    }
}

