/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.direct_marketing;

import com.pasw.framework.common.ExtendedValue;
import com.pasw.framework.common.data.DataModel;
import com.pasw.framework.common.data.Field;
import com.pasw.framework.common.data.ModelOutputDescriptor;
import com.pasw.framework.common.data.ModelOutputRole;
import com.pasw.framework.common.data.RoleType;
import com.pasw.framework.common.data.StorageType;
import com.spss.cftool.ToolDataModelProvider;
import com.spss.java_client.core.common.fopen.RefFile;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.common.fopen.RemoteFileSystemView;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.core.comp_util.SysFileProxy;
import com.spss.java_client.core.resources.CoreResUtil;
import com.spss.java_client.core.script.base.options.FileLocationsOptions;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.core.server.messages.sysfilemsg.CFExecutionResponse;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.controls.FocusHighlighter;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.direct_marketing.AbstractDialogStateWizardPage;
import com.spss.java_client.ui.dialogs.direct_marketing.ParseScoringPropertiesXML;
import com.spss.java_client.ui.dialogs.direct_marketing.ScoringWizardDlg;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.pes.util.io.FileUtil;
import com.spss.repository.client.application.jaxws.RepositoryFolder;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.FocusableLabel;
import com.spss.uitools.util.AccessibilityUtil;
import com.spss.uitools.util.ComparatorFactory;
import com.spss.uitools.util.TraceSettings;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SelectModelPage
extends AbstractDialogStateWizardPage
implements ListSelectionListener,
ActionListener {
    private static final int SYNC_TIMEOUT_VALUE = 3600000;
    public static final String PES_FILE = "PESFILE";
    private static final String SELECT_SCORING_MODEL_LIST_KEY = "IDK_SCORING_WIZARD_P1_SELECT_MODEL_LIST_KEY";
    private static final String BROWSE_BUTTON_KEY = "IDS_SCORING_WIZARD_P1_BROWSE_BUTTON";
    private static final String SELECT_SCORING_MODEL_DIRECTORY_KEY = "IDK_SCORING_WIZARD_P1_SELECT_SCORING_MODEL_DIRECTORY_KEY";
    private String mSelectScoringModelDir;
    private ArrayList<String> mFilesInSelectedDir = new ArrayList();
    private DialogFocusTraversalPolicy mPolicy;
    private PlainList mMainFileList;
    private JScrollPane mSelectScoringModelScrollPane;
    private JTextArea mModelDetailsTextArea;
    private JScrollPane mModelDetailsScrollPane;
    private JButton mBrowseButton;
    private FocusableLabel mCurrentDirLabel;
    private DataModel mInputDataModel = null;
    private DataModel mOutputDataModel = null;
    private ParseScoringPropertiesXML.ScoringPropertiesInfo mScoringPropertiesInfo = null;
    private ScoringWizardDlg mParent;
    private Field mTargetField;
    private JLabel mHeadLabel1;
    private JLabel mHeadLabel2;
    MyTimer mTimer = new MyTimer();
    private static final String XML_FILE_EXT = ".xml";
    private static final String ZIP_FILE_EXT = ".zip";

    public SelectModelPage(BaseWizardDialog baseWizardDialog) {
        super("SelectModelPage", baseWizardDialog.getResString("IDS_SCORING_WIZARD_TITLE"), baseWizardDialog, true);
        this.mParent = (ScoringWizardDlg)baseWizardDialog;
        this.setNextFinishButtonState();
    }

    private void setNextFinishButtonState() {
        boolean bl = this.isPageValidToContinue();
        this.mParent.enableNext(bl);
        this.mParent.enableFinish(this.mParent.canFinish());
    }

    @Override
    protected void loadDialogState() {
        DialogDataModel dialogDataModel = this.mParent.getDialogDataModel();
        String string = dialogDataModel.getString(SELECT_SCORING_MODEL_DIRECTORY_KEY);
        this.mSelectScoringModelDir = string == null ? FileLocationsUtil.getDataFilesDirectoryPath() : string;
        this.mCurrentDirLabel.setText(this.mSelectScoringModelDir != null ? this.mSelectScoringModelDir : "");
        this.fillSelectScoringModelList();
    }

    @Override
    protected void saveDialogState() {
        this.presistSelectedFolder();
    }

    @Override
    public void init() {
        JSeparator jSeparator;
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n2, n2, n2);
        JPanel jPanel = this.setupPageHeader();
        if (jPanel.getComponentCount() > 0) {
            DialogUtil.normalizeLabelWidths(jPanel);
            DialogUtil.addUsingGBL(this.mWizardPage, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
            gridBagConstraints.fill = 2;
            insets.top = n2;
            jSeparator = new JSeparator();
            DialogUtil.addUsingGBL(this.mWizardPage, jSeparator, gridBagConstraints, 0, 1, 1, 1, n, insets);
        }
        jPanel = this.setupPageBody();
        DialogUtil.normalizeLabelWidths(jPanel);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.mWizardPage, jPanel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.top = n2;
        jSeparator = new JSeparator();
        DialogUtil.addUsingGBL(this.mWizardPage, jSeparator, gridBagConstraints, 0, 3, 1, 1, n, insets);
        this.setTabTraversalOrder();
    }

    private void initVars() {
        this.mBrowseButton = DialogUtil.createButton(this.mWizardDialog, BROWSE_BUTTON_KEY, this);
        this.mCurrentDirLabel = new FocusableLabel(this.mSelectScoringModelDir != null ? this.mSelectScoringModelDir : "");
        this.mMainFileList = new PlainList(SELECT_SCORING_MODEL_LIST_KEY, PlainList.DragType.eNoAutoDrag);
        this.mMainFileList.addListSelectionListener(this);
        this.mMainFileList.setMinimumSize(new Dimension(DialogUtil.getVarListWidth() * 2, DialogUtil.getVarListHeight()));
        this.mMainFileList.setCellRenderer(new MyListCellRenderer());
        this.mHeadLabel1 = DialogUtil.createLabel(this.mWizardDialog, "IDS_SCORING_WIZARD_P1_SELECT_MODEL_LIST_LABEL");
        this.mHeadLabel1.setLabelFor(this.mMainFileList);
        this.mSelectScoringModelScrollPane = new JScrollPane(this.mMainFileList);
        this.mSelectScoringModelScrollPane.setHorizontalScrollBarPolicy(31);
        this.mSelectScoringModelScrollPane.setVerticalScrollBarPolicy(20);
        this.mSelectScoringModelScrollPane.setPreferredSize(this.mMainFileList.getMinimumSize());
        this.mSelectScoringModelScrollPane.setMinimumSize(this.mMainFileList.getMinimumSize());
        this.mModelDetailsTextArea = new JTextArea();
        this.mModelDetailsTextArea.setOpaque(false);
        this.mModelDetailsTextArea.setEditable(false);
        this.mModelDetailsTextArea.setFocusable(true);
        this.mModelDetailsTextArea.setLineWrap(true);
        this.mModelDetailsTextArea.setWrapStyleWord(true);
        this.mModelDetailsTextArea.setMinimumSize(this.mMainFileList.getMinimumSize());
        this.mModelDetailsTextArea.addFocusListener(new FocusHighlighter(this.mModelDetailsTextArea));
        this.mHeadLabel2 = DialogUtil.createLabel(this.mWizardDialog, "IDS_SCORING_WIZARD_P1_MODEL_DETAILS_LIST_LABEL");
        this.mHeadLabel2.setLabelFor(this.mModelDetailsTextArea);
        this.mModelDetailsScrollPane = new JScrollPane(this.mModelDetailsTextArea);
        this.mModelDetailsScrollPane.setHorizontalScrollBarPolicy(31);
        this.mModelDetailsScrollPane.setVerticalScrollBarPolicy(20);
        this.mModelDetailsScrollPane.setPreferredSize(this.mModelDetailsTextArea.getMinimumSize());
        this.mModelDetailsScrollPane.setMinimumSize(this.mModelDetailsTextArea.getMinimumSize());
    }

    @Override
    public String getNextPage() {
        if (this.mScoringPropertiesInfo.isTimeSeriesModel()) {
            return "SelectScoringValuesToIncludePage";
        }
        return "MatchDatasetFieldsToModelFieldsPage";
    }

    @Override
    public boolean isLastPage() {
        return false;
    }

    @Override
    public boolean hasNextPage() {
        return true;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_scoring_wizard_select_model";
    }

    @Override
    public boolean validate() {
        return !this.mMainFileList.isSelectionEmpty() && super.validate();
    }

    @Override
    protected void aboutToShowPanel() {
        super.aboutToShowPanel();
        this.mWizardDialog.setFocusTraversalPolicy(this.mPolicy);
        this.mMainFileList.requestFocusInWindow();
        this.mParent.enableFinish(this.mParent.canFinish());
    }

    @Override
    protected void aboutToHidePanel() {
        super.aboutToHidePanel();
    }

    private void setTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mMainFileList);
        vector.add(this.mModelDetailsTextArea);
        vector.add(this.mBrowseButton);
        Vector<Object> vector2 = ((ScoringWizardDlg)this.mWizardDialog).addBaseWizardTabTraversal(vector);
        this.mPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    private JPanel setupPageHeader() {
        return new JPanel(new GridBagLayout());
    }

    private JPanel setupPageBody() {
        double[] dArray = new double[]{-1.0, DialogUtil.getComponentGroupGap(), -1.0};
        double[] dArray2 = new double[]{-2.0, -1.0, -2.0};
        TableLayout tableLayout = new TableLayout(dArray, dArray2);
        tableLayout.setHGap(5);
        tableLayout.setVGap(5);
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)tableLayout);
        jPanel.add((Component)this.mHeadLabel1, "0, 0, l, b");
        jPanel.add((Component)this.mHeadLabel2, "2, 0, l, b");
        jPanel.add((Component)this.mSelectScoringModelScrollPane, "0, 1");
        jPanel.add((Component)this.mModelDetailsScrollPane, "2, 1");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.mBrowseButton, "West");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)new JLabel("  "), "West");
        jPanel3.add((Component)this.mCurrentDirLabel, "Center");
        jPanel2.add((Component)jPanel3, "Center");
        jPanel.add((Component)jPanel2, "0, 2, l, b");
        return jPanel;
    }

    private void fillSelectScoringModelList() {
        if (this.mSelectScoringModelDir != null) {
            this.mFilesInSelectedDir = this.getAllXMLOrZipFilesFromPath(this.mSelectScoringModelDir);
            Collections.sort(this.mFilesInSelectedDir, ComparatorFactory.getCaseInsensitiveStringComparator());
            this.mMainFileList.setListData(this.mFilesInSelectedDir.toArray(new String[this.mFilesInSelectedDir.size()]));
            this.mMainFileList.setSelectedIndex(0);
        }
    }

    private ArrayList<String> getAllXMLOrZipFilesFromPath(String string) {
        ArrayList<String> arrayList;
        block7: {
            File[] fileArray;
            File file;
            block8: {
                File[] fileArray2;
                boolean bl;
                block6: {
                    arrayList = new ArrayList<String>();
                    bl = DataServerProxy.getDataProxy().isRemoteConnection();
                    if (!string.startsWith("spsscr:/")) break block6;
                    String string2 = string.substring(7);
                    try {
                        RepositoryFolder repositoryFolder = PES_Repository.getRepository().getFolder(string2);
                        List list = repositoryFolder.getFileObjects();
                        for (Object e : list) {
                            String string3 = e.toString();
                            if (!XML_FILE_EXT.regionMatches(true, 0, string3, string3.length() - XML_FILE_EXT.length(), XML_FILE_EXT.length()) && !ZIP_FILE_EXT.regionMatches(true, 0, string3, string3.length() - ZIP_FILE_EXT.length(), ZIP_FILE_EXT.length())) continue;
                            arrayList.add(string3);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    break block7;
                }
                if (!bl) break block8;
                RemoteFileSystemView remoteFileSystemView = RemoteFileSystemView.getFileSystemView();
                remoteFileSystemView.reset();
                remoteFileSystemView.textEditString(string);
                remoteFileSystemView.setFoldersOnlyMode(false);
                RefFile refFile = new RefFile(string);
                for (File file2 : fileArray2 = remoteFileSystemView.getFiles((File)refFile, true)) {
                    String string4;
                    if (file2.isDirectory() || !XML_FILE_EXT.regionMatches(true, 0, string4 = file2.getName(), string4.length() - XML_FILE_EXT.length(), XML_FILE_EXT.length()) && !ZIP_FILE_EXT.regionMatches(true, 0, string4, string4.length() - ZIP_FILE_EXT.length(), ZIP_FILE_EXT.length())) continue;
                    arrayList.add(string4);
                }
                break block7;
            }
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            if (!(file = new File(string)).exists() || !file.isDirectory()) break block7;
            for (File file3 : fileArray = file.listFiles()) {
                String string5;
                if (file3.isDirectory() || file3.isHidden() || !XML_FILE_EXT.regionMatches(true, 0, string5 = file3.getName(), string5.length() - XML_FILE_EXT.length(), XML_FILE_EXT.length()) && !ZIP_FILE_EXT.regionMatches(true, 0, string5, string5.length() - ZIP_FILE_EXT.length(), ZIP_FILE_EXT.length())) continue;
                arrayList.add(string5);
            }
        }
        return arrayList;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.clearModelInfo();
            this.mTimer.processModelSelection((String)this.mMainFileList.getSelectedValue());
        }
    }

    private void processModelSelection(String string) {
        this.clearModelInfo();
        if (string != null) {
            this.populateModelDetails(string);
        }
    }

    private void clearModelInfo() {
        this.mInputDataModel = null;
        this.mOutputDataModel = null;
        this.mScoringPropertiesInfo = null;
        this.setNextFinishButtonState();
    }

    public boolean isPageValidToContinue() {
        return this.mInputDataModel != null && this.mOutputDataModel != null && this.mScoringPropertiesInfo != null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        Object object = actionEvent.getSource();
        if (object == this.mBrowseButton && (string = this.processChangeDirectoryButton()) != null) {
            this.fillSelectScoringModelList();
            this.mMainFileList.setSelectedValue(string, true);
        }
    }

    public boolean isTargetString() {
        return this.getTargetStorageType() == StorageType.string;
    }

    private void populateModelDetails(String string) {
        if (string != null) {
            String string2 = SelectModelPage.getExecutionXML(true);
            CFExecutionResponse cFExecutionResponse = SysFileProxy.getSysFileProxy().executeBackendFrameworkOperation(SpssMgr.getSpssMgr().getActiveClientDatasetId(), string2.getBytes(), "InputPMMLContainer", null, this.getModelFilePath(), 3600000, false);
            if (cFExecutionResponse != null) {
                if (cFExecutionResponse.getErrorCode() == 0) {
                    String string3;
                    boolean bl;
                    boolean bl2 = bl = cFExecutionResponse.getErrorXml() == null;
                    if (!(cFExecutionResponse.getErrorXml() == null || cFExecutionResponse.getErrorXml().length <= 0 || (string3 = this.parseErrorMessage(new ByteArrayInputStream(cFExecutionResponse.getErrorXml()), -1)) == null && this.executionReponseHasModelXML(cFExecutionResponse))) {
                        bl = true;
                    }
                    if (bl) {
                        this.setModelDetails(this.mWizardDialog.getResString("IDS_NOT_A_VALID_MODEL"));
                        this.setNextFinishButtonState();
                    } else {
                        this.mScoringPropertiesInfo = this.readModelPropertiesXml(new String(cFExecutionResponse.getModelPropertiesXml()));
                        if (this.mScoringPropertiesInfo != null && !this.mScoringPropertiesInfo.isUnknownModel()) {
                            this.mInputDataModel = this.readModelFromXML(cFExecutionResponse.getInputDataModelXml());
                            this.mOutputDataModel = this.readModelFromXML(cFExecutionResponse.getOutputDataModelXml());
                            this.mScoringPropertiesInfo = this.readModelPropertiesXml(new String(cFExecutionResponse.getModelPropertiesXml()));
                            this.setModelDetails(this.mInputDataModel, this.mOutputDataModel, this.mScoringPropertiesInfo);
                            ((ScoringWizardDlg)this.mWizardDialog).getMatchDatasetFieldsToModelFieldsPage().updatePanel();
                            ((ScoringWizardDlg)this.mWizardDialog).getSelectScoringValuesToIncludePage().updatePanel();
                            if (!((ScoringWizardDlg)this.mWizardDialog).getMatchDatasetFieldsToModelFieldsPage().isValidTableModel() || !((ScoringWizardDlg)this.mWizardDialog).getSelectScoringValuesToIncludePage().isValidTableModel()) {
                                this.clearModelInfo();
                                this.setModelDetails(this.mWizardDialog.getResString("IDS_NOT_A_VALID_MODEL") + "\n  ");
                            }
                            this.mTargetField = this.getTargetFieldFromOutputModel(this.mOutputDataModel);
                            this.setNextFinishButtonState();
                        } else {
                            this.clearModelInfo();
                            this.setModelDetails(this.mWizardDialog.getResString("IDS_NOT_A_VALID_MODEL"));
                        }
                    }
                } else {
                    String string4 = cFExecutionResponse.getErrorCode() == 1 ? "ERR_NO_XFORMS" : "ERR_INTERNAL_ERROR";
                    String string5 = ResUtil.getCommonDlgString(string4);
                    this.setModelDetails(string5);
                    this.setNextFinishButtonState();
                }
            }
        }
    }

    private boolean executionReponseHasModelXML(CFExecutionResponse cFExecutionResponse) {
        return cFExecutionResponse.getInputDataModelXml() != null && cFExecutionResponse.getInputDataModelXml().length > 0 && cFExecutionResponse.getOutputDataModelXml() != null && cFExecutionResponse.getOutputDataModelXml().length > 0 && cFExecutionResponse.getModelPropertiesXml() != null && cFExecutionResponse.getModelPropertiesXml().length > 0;
    }

    public Field getTargetField() {
        return this.mTargetField;
    }

    private Field getTargetFieldFromOutputModel(DataModel dataModel) {
        Field field = null;
        if (dataModel != null) {
            for (int i = 0; i < dataModel.getFieldCount(); ++i) {
                ModelOutputDescriptor modelOutputDescriptor;
                Field field2 = dataModel.getField(dataModel.getFieldName(i));
                if (field2.getModelOutputDescriptor() == null || (modelOutputDescriptor = field2.getModelOutputDescriptor()).getModelOutputRole() != ModelOutputRole.predictedValue) continue;
                field = field2;
                break;
            }
        }
        return field;
    }

    private StorageType getTargetStorageType() {
        ModelOutputDescriptor modelOutputDescriptor;
        StorageType storageType = StorageType.unknown;
        if (this.mTargetField != null && this.mTargetField.getModelOutputDescriptor() != null && (modelOutputDescriptor = this.mTargetField.getModelOutputDescriptor()).getModelOutputRole() == ModelOutputRole.predictedValue) {
            storageType = (StorageType)modelOutputDescriptor.getExtendedValue(ExtendedValue.targetFieldStorage);
        }
        return storageType;
    }

    private DataModel readModelFromXML(byte[] byArray) {
        ToolDataModelProvider toolDataModelProvider = new ToolDataModelProvider();
        String string = null;
        try {
            string = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        if (string != null) {
            toolDataModelProvider.setDataModelFromXml(string);
        }
        return toolDataModelProvider.getDataModel();
    }

    private ParseScoringPropertiesXML.ScoringPropertiesInfo readModelPropertiesXml(String string) {
        return ParseScoringPropertiesXML.initParseScoringPropertiesFromXML(string);
    }

    private String parseErrorMessage(InputStream inputStream, int n) {
        String string = null;
        if (inputStream != null) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                documentBuilderFactory.setIgnoringElementContentWhitespace(true);
                documentBuilderFactory.setIgnoringComments(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(inputStream);
                NodeList nodeList = document.getElementsByTagName("Message");
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    node = node.getFirstChild();
                    stringBuffer.append(node.getNodeValue());
                    if (i >= n && n != -1) break;
                    if (i >= nodeList.getLength() - 1) continue;
                    stringBuffer.append("\n");
                }
                string = stringBuffer.toString().trim().length() > 0 ? stringBuffer.toString() : null;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                string = parserConfigurationException.getLocalizedMessage();
            }
            catch (SAXException sAXException) {
                string = sAXException.getLocalizedMessage();
            }
            catch (IOException iOException) {
                string = iOException.getLocalizedMessage();
            }
        }
        return string;
    }

    private void setModelDetails(DataModel dataModel, DataModel dataModel2, ParseScoringPropertiesXML.ScoringPropertiesInfo scoringPropertiesInfo) {
        String string = this.getSplitVariablesInfoText(dataModel);
        String string2 = this.getPredictorInfoText(dataModel);
        String string3 = this.getTargetInfoText(dataModel2);
        Object[] objectArray = new Object[]{scoringPropertiesInfo.getModelType(), scoringPropertiesInfo.getEnsembleType(), scoringPropertiesInfo.getAppName() + " " + scoringPropertiesInfo.getAppVersion(), string3, string, string2};
        String string4 = MessageFormat.format(this.mWizardDialog.getResString("IDS_MODEL_DETAILS"), objectArray);
        this.setModelDetails(string4);
    }

    private String getSplitVariablesInfoText(DataModel dataModel) {
        ArrayList<Field> arrayList = this.getFieldsOfRoleType(dataModel, RoleType.split);
        String string = this.createFieldNamesText(arrayList);
        return string.trim().length() > 0 ? string : "";
    }

    private String createFieldNamesText(ArrayList<Field> arrayList) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < arrayList.size(); ++i) {
            Field field = arrayList.get(i);
            stringBuffer.append(field.getFieldName());
            if (i + 1 >= arrayList.size()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    private String getTargetInfoText(DataModel dataModel) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < dataModel.getFieldCount(); ++i) {
            ModelOutputDescriptor modelOutputDescriptor;
            Field field = dataModel.getField(dataModel.getFieldName(i));
            if (field.getModelOutputDescriptor() == null || (modelOutputDescriptor = field.getModelOutputDescriptor()).getModelOutputRole() != ModelOutputRole.predictedValue || modelOutputDescriptor.getTargetField() == null) continue;
            if (i != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(modelOutputDescriptor.getTargetField());
        }
        return stringBuffer.toString();
    }

    private String getPredictorInfoText(DataModel dataModel) {
        ArrayList<RoleType> arrayList = new ArrayList<RoleType>();
        arrayList.add(RoleType.input);
        arrayList.add(RoleType.both);
        ArrayList<Field> arrayList2 = this.getFieldsOfRoleType(dataModel, arrayList);
        return this.createFieldNamesText(arrayList2);
    }

    private ArrayList<Field> getFieldsOfRoleType(DataModel dataModel, RoleType roleType) {
        ArrayList<RoleType> arrayList = new ArrayList<RoleType>();
        arrayList.add(roleType);
        return this.getFieldsOfRoleType(dataModel, arrayList);
    }

    private ArrayList<Field> getFieldsOfRoleType(DataModel dataModel, ArrayList<RoleType> arrayList) {
        ArrayList<Field> arrayList2 = new ArrayList<Field>();
        for (int i = 0; i < dataModel.getFieldCount(); ++i) {
            Field field = dataModel.getField(dataModel.getFieldName(i));
            if (!arrayList.contains(field.getFieldRole())) continue;
            arrayList2.add(field);
        }
        return arrayList2;
    }

    private void setModelDetails(String string) {
        this.mModelDetailsTextArea.setText(string);
        this.mModelDetailsTextArea.setCaretPosition(0);
        AccessibilityUtil.setAccessibleText((Component)this.mModelDetailsTextArea, (Object)(this.mHeadLabel2.getText() + " " + this.mWizardDialog.getResString("IDS_SCORING_WIZARD_P1_READ_ONLY_EDIT_STRING") + string));
    }

    private String processChangeDirectoryButton() {
        File file;
        String string = null;
        String string2 = this.mSelectScoringModelDir != null && this.mSelectScoringModelDir.length() == 0 ? FileLocationsOptions.getDataFilePath() : this.mSelectScoringModelDir;
        OpenFolderChooser openFolderChooser = this.showSelectFolderDialog((Component)((Object)this.mWizardDialog), new RefFile(string2), this.mWizardDialog.getResString("IDS_SCORING_WIZARD_P1_CHANGE_DIRECTORY_TITLE"), this.mWizardDialog.getResString("IDS_SCORING_WIZARD_P1_CHANGE_DIRECTORY_APPROVE_BUTTON_TEXT"), this.mWizardDialog.getDlgAccessKey("IDK_OMS_BROWSE_FOLDER_APPROVE_BUTTON_KEY"));
        if (openFolderChooser != null && (file = openFolderChooser.getSelectedFile()) != null) {
            String string3 = file.getPath();
            if ((string3 = string3.trim()) != null && string3.length() > 0) {
                string = FileUtil.getBaseNameAndExtension((String)string3);
                PesFile pesFile = PES_Repository.getPesFile((String)string3);
                if (pesFile != null) {
                    string3 = pesFile.getUri();
                    int n = string3.lastIndexOf(string);
                    if (n >= 0) {
                        string3 = string3.substring(0, n);
                    }
                } else {
                    string3 = FileUtil.getDirectoryName((String)string3);
                }
            }
            this.mSelectScoringModelDir = string3;
            this.mCurrentDirLabel.setText(this.mSelectScoringModelDir != null ? this.mSelectScoringModelDir : "");
            this.presistSelectedFolder();
            this.mParent.saveDialogState();
        }
        return string;
    }

    private void presistSelectedFolder() {
        DialogDataModel dialogDataModel = this.mParent.getDialogDataModel();
        dialogDataModel.putString(SELECT_SCORING_MODEL_DIRECTORY_KEY, this.mSelectScoringModelDir);
    }

    private OpenFolderChooser showSelectFolderDialog(Component component, RefFile refFile, String string, String string2, int n) {
        OpenFolderChooser openFolderChooser = new OpenFolderChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, refFile.getPath());
        openFolderChooser.setDialogTitle(string);
        openFolderChooser.setFileSelectionMode(0);
        openFolderChooser.setAcceptAllFileFilterUsed(false);
        openFolderChooser.setCurrentDirectory((File)refFile);
        openFolderChooser.addChoosableFileFilter((FileFilter)new RefFileFilter(this.mWizardDialog.getResString("IDS_SCORING_WIZARD_P1_CHANGE_DIRECTORY_FILTER"), "xml:zip", ":"));
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            openFolderChooser.setApproveButtonMnemonic(n);
        }
        int n2 = openFolderChooser.showDialog(component, string2);
        openFolderChooser.resetStrings();
        if (n2 == 0) {
            return openFolderChooser;
        }
        TraceSettings.trace1((String)"No Folder Selection Made", (int)15);
        return null;
    }

    public String getModelName() {
        String string = (String)this.mMainFileList.getSelectedValue();
        return string != null ? FileUtil.getBaseName((String)string) : "";
    }

    public String getModelFilePath() {
        String string = DataServerProxy.getDataProxy().isRemoteConnection() ? "" + RefFile.getSeparator() : System.getProperty("file.separator");
        return this.mSelectScoringModelDir + string + this.mFilesInSelectedDir.get(this.mMainFileList.getSelectedIndex());
    }

    public String getModelType() {
        return this.mScoringPropertiesInfo != null ? this.mScoringPropertiesInfo.getModelType() : "";
    }

    public DataModel getInputDataModel() {
        return this.mInputDataModel;
    }

    public DataModel getOutputDataModel() {
        return this.mOutputDataModel;
    }

    static String getExecutionXML(boolean bl) {
        String string = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\" ?>\n<Execution>\n<ContainerInputs>\n<ContainerInput id=\"InputPMMLContainer\"/>\n</ContainerInputs>\n<Operation componentId=\"scoring\" dependencyIds=\"\" id=\"1\" inputIds=\"\" moduleId=\"pasw.scoring\" version=\"2.0\">\n<Parameters>\n<Parameter name=\"missingValuePolicy\" value=\"";
        string = bl ? string + "scoreAsMissing" : string + "asMissingPredictor";
        string = string + "\"/>\n<Parameter name=\"encoding\" value=\"UTF-8\"/>\n<Parameter name=\"scoringDll\">\n<StructuredValue>\n<Attribute name=\"SmartScore\" value=\"mcscorersmart\"/>\n<Attribute name=\"NeuralNetwork\" value=\"mcscorernnet\"/>\n<Attribute name=\"MiningModel\" value=\"mcscorermining\"/>\n</StructuredValue>\n</Parameter>\n<Parameter name=\"modelDll\">\n<StructuredValue>\n<Attribute name=\"TreeModel\" value=\"TreeModel\"/>\n<Attribute name=\"discriminant-model\" value=\"discriminant-model\"/>\n<Attribute name=\"GeneralRegressionModel\" value=\"GeneralRegressionModel\"/>\n<Attribute name=\"ClusteringModel\" value=\"ClusteringModel\"/>\n<Attribute name=\"NeuralNetwork\" value=\"NeuralNetwork\"/>\n<Attribute name=\"AssociationModelLattice\" value=\"AssociationModelLattice\"/>\n<Attribute name=\"SeqAssociationLattice\" value=\"SeqAssociationLattice\"/>\n<Attribute name=\"NaiveBayesModel\" value=\"NaiveBayesModel\"/>\n<Attribute name=\"AssociationModel\" value=\"AssociationModel\"/>\n<Attribute name=\"RuleSetModel\" value=\"RuleSetModel\"/>\n<Attribute name=\"BayesNetModel\" value=\"BayesNetModel\"/>\n<Attribute name=\"SupportVectorMachineModel\" value=\"SupportVectorMachineModel\"/>\n<Attribute name=\"NearestNeighborModel\" value=\"NearestNeighborModel\"/>\n<Attribute name=\"MiningModel\" value=\"MiningModel\"/>\n</StructuredValue>\n</Parameter>\n<Parameter name=\"maxPredictions\" value=\"3\"/>\n<Parameter name=\"versionSupported\" value=\"4.0\"/>\n<Parameter name=\"isOutputInputData\" value=\"false\"/>\n<Parameter name=\"isOutputAll\" value=\"true\"/>\n<Parameter name=\"isPrediction\" value=\"true\"/>\n<Parameter name=\"isProbability\" value=\"false\"/>\n<Parameter name=\"isProbabilityCategory\" value=\"false\"/>\n<Parameter name=\"isConfidence\" value=\"true\"/>\n<Parameter name=\"isStandardDeviation\" value=\"false\"/>\n<Parameter name=\"isPropensity\" value=\"false\"/>\n<Parameter name=\"isRawPropensity\" value=\"false\"/>\n<Parameter name=\"isNodeID\" value=\"false\"/>\n<Parameter name=\"isCumHazard\" value=\"false\"/>\n<Parameter name=\"isNeighbor\" value=\"false\"/>\n<Parameter name=\"isDistance\" value=\"false\"/>\n<Parameter name=\"isOthers\" value=\"false\"/>\n<Parameter name=\"isEnsemble\" value=\"true\"/>\n<Parameter name=\"isBaseModels\" value=\"false\"/>\n<Parameter name=\"isReferenceModel\" value=\"false\"/>\n<Parameter name=\"modelID\">\n<StructuredValue>\n<Attribute name=\"TreeModel\" value=\"R\"/>\n<Attribute name=\"discriminant-model\" value=\"discriminant-model\"/>\n<Attribute name=\"GeneralRegressionModel\" value=\"L\"/>\n<Attribute name=\"ClusteringModel\" value=\"ClusteringModel\"/>\n<Attribute name=\"NeuralNetwork\" value=\"N\"/>\n<Attribute name=\"AssociationModelLattice\" value=\"AssociationModelLattice\"/>\n<Attribute name=\"SeqAssociationLattice\" value=\"SeqAssociationLattice\"/>\n<Attribute name=\"NaiveBayesModel\" value=\"NaiveBayesModel\"/>\n<Attribute name=\"AssociationModel\" value=\"AssociationModel\"/>\n<Attribute name=\"RuleSetModel\" value=\"RuleSetModel\"/>\n<Attribute name=\"BayesNetModel\" value=\"B\"/>\n<Attribute name=\"SupportVectorMachineModel\" value=\"S\"/>\n<Attribute name=\"NearestNeighborModel\" value=\"NearestNeighborModel\"/>\n<Attribute name=\"MiningModel\" value=\"MiningModel\"/>\n</StructuredValue>\n</Parameter>\n<Parameter name=\"resultType\">\n<StructuredValue>\n<Attribute name=\"prediction\" value=\"\"/>\n<Attribute name=\"probability\" value=\"P\"/>\n<Attribute name=\"probcategory\" value=\"P\"/>\n<Attribute name=\"confidence\" value=\"C\"/>\n<Attribute name=\"stddev\" value=\"S\"/>\n</StructuredValue>\n</Parameter>\n<Parameter name=\"namePattern\">\n<StructuredValue>\n<Attribute name=\"prediction\" value=\"${M}{S}-{T}\"/>\n<Attribute name=\"probability\" value=\"${M}{R}{S}-{T}\"/>\n<Attribute name=\"probcategory\" value=\"${M}{R}{S}-{C}\"/>\n<Attribute name=\"confidence\" value=\"${M}{R}{S}-{T}\"/>\n<Attribute name=\"stddev\" value=\"StdDev\"/>\n<Attribute name=\"tree-nodeid\" value=\"NodeID\"/>\n<Attribute name=\"cox-cumhazard\" value=\"CumHazard\"/>\n<Attribute name=\"knn-caseid\" value=\"Neighor\"/>\n<Attribute name=\"knn-distance\" value=\"Distance\"/>\n<Attribute name=\"adjustedpropensity\" value=\"$AP{S}-{T}\"/>\n<Attribute name=\"rawpropensity\" value=\"$RP{S}-{T}\"/>\n</StructuredValue>\n</Parameter>\n<Parameter name=\"nameList\">\n<StructuredValue>\n<Attribute name=\"prediction\" value=\"\"/>\n<Attribute name=\"probability\" value=\"\"/>\n<Attribute name=\"probcategory\">\n<ListValue/>\n</Attribute>\n<Attribute name=\"confidence\" value=\"\"/>\n<Attribute name=\"stddev\" value=\"\"/>\n<Attribute name=\"tree-nodeid\" value=\"\"/>\n<Attribute name=\"cox-cumhazard\" value=\"\"/>\n<Attribute name=\"knn-caseid\">\n<ListValue/>\n</Attribute>\n<Attribute name=\"knn-distance\">\n<ListValue/>\n</Attribute>\n<Attribute name=\"adjustedpropensity\" value=\"\"/>\n<Attribute name=\"rawpropensity\" value=\"\"/>\n</StructuredValue>\n</Parameter>\n<Parameter name=\"useNameList\" value=\"false\"/>\n<Parameter name=\"resolveNameConflict\" value=\"true\"/>\n<Parameter name=\"enableSQL\" value=\"false\"/>\n<Parameter name=\"maxCategories\" value=\"25\"/>\n<Parameter name=\"confidenceBasedOn\" value=\"onProbability\"/>\n<Parameter name=\"scoreValue\" value=\"\"/>\n</Parameters>\n<InputContainers>\n<Container id=\"InputPMMLContainer\" name=\"InputPMML\"/>\n</InputContainers>\n</Operation>\n</Execution>";
        return string;
    }

    class MyTimer
    extends Timer {
        String mSelectedModel;

        MyTimer() {
            super(400, null);
            this.addActionListener(new TimerActionListener());
        }

        void processModelSelection(String string) {
            this.mSelectedModel = string;
            this.restart();
        }

        class TimerActionListener
        implements ActionListener {
            TimerActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SelectModelPage.this.processModelSelection(MyTimer.this.mSelectedModel);
                    }
                });
                MyTimer.this.stop();
            }
        }
    }

    private class MyListCellRenderer
    extends DefaultListCellRenderer {
        private MyListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            this.setText((String)object);
            return this;
        }
    }

    class OpenFolderChooser
    extends RemoteFileChooser {
        public OpenFolderChooser(RemoteFileChooser.ChooserType chooserType, RemoteFileChooser.ChooserOption chooserOption, String string) {
            super(chooserType, chooserOption, string, true, false, true, true);
        }

        @Override
        protected void installStrings() {
            super.installStrings();
            UIManager.getDefaults().put("FileChooser.lookInLabelText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_SAVE_IN_LABEL_TEXT"));
            UIManager.getDefaults().put("FileChooser.filesOfTypeLabelText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_FILES_OF_TYPE_LABEL_TEXT"));
            UIManager.getDefaults().put("FileChooser.fileNameLabelText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_OPEN_FOLDER_LABEL_TEXT"));
        }

        public void resetStrings() {
            UIManager.getDefaults().put("FileChooser.lookInLabelText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_LOOK_IN_LABEL_TEXT"));
            UIManager.getDefaults().put("FileChooser.filesOfTypeLabelText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_FILES_OF_TYPE_LABEL_TEXT"));
            UIManager.getDefaults().put("FileChooser.fileNameLabelText", CoreResUtil.getString((String)"IDS_FILE_CHOOSER_FOLDER_LABEL_TEXT"));
        }
    }
}

