/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.direct_marketing;

import com.pasw.framework.common.data.Field;
import com.pasw.framework.common.data.MeasurementType;
import com.pasw.framework.common.data.ModelOutputRole;
import com.pasw.framework.common.data.RoleType;
import com.pasw.framework.common.data.StorageType;
import com.spss.cftool.format.ToolFieldFormat;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.dialogs.base.utilities.res.UtilitiesResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.IVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.direct_marketing.MatchDatasetFieldsToModelFieldsPage;
import com.spss.java_client.ui.dialogs.direct_marketing.ScoreFinishPage;
import com.spss.java_client.ui.dialogs.direct_marketing.SelectModelPage;
import com.spss.java_client.ui.dialogs.direct_marketing.SelectScoringValuesToIncludePage;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class ScoringWizardDlg
extends BaseWizardDialog {
    public static final int HEADER_LABEL_SIZE = 18;
    private static Hashtable<ModelOutputRole, String> sExpressionSyntaxTable = new Hashtable();
    protected DialogDataModel mDialogDataModel = new DialogDataModel();
    private SelectModelPage mSelectModelPage;
    private MatchDatasetFieldsToModelFieldsPage mMatchDatasetFieldsToModelFieldsPage;
    private SelectScoringValuesToIncludePage mSelectScoringValuesToIncludePage;
    private ScoreFinishPage mScoreFinishPage;
    private JFrame mParent;
    private Vector<ISpssVariable> mVarsFromActiveDataset;

    public ScoringWizardDlg(JFrame jFrame) {
        super(jFrame, true, UtilitiesResBundle.getDefaultResourceBundleName(), UtilitiesResBundle.getImageFolder());
        this.mParent = jFrame;
        this.setLocationRelativeTo(jFrame);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (ScoringWizardDlg.this.isDisplayable()) {
                    ProcedureDlgMgr.getMgr().loadPersistentState(ScoringWizardDlg.this.getIActionKey(), ScoringWizardDlg.this.getDialogDataModel());
                    ScoringWizardDlg.this.loadDialogState();
                }
            }
        });
    }

    protected void loadDialogState() {
        BaseProcedureDialog.loadState(this.getDialogDataModel(), (Container)((Object)this), BaseProcedureDialog.NameLabelOption.no_override);
        this.mSelectModelPage.loadDialogState();
    }

    protected void saveDialogState() {
        this.mSelectModelPage.saveDialogState();
        this.mMatchDatasetFieldsToModelFieldsPage.saveDialogState();
        this.mSelectScoringValuesToIncludePage.saveDialogState();
        this.mScoreFinishPage.saveDialogState();
        BaseProcedureDialog.saveState(this.getDialogDataModel(), (Container)((Object)this));
        ProcedureDlgMgr.getMgr().savePersistentState(this.getIActionKey(), this.getDialogDataModel());
    }

    public DialogDataModel getDialogDataModel() {
        return this.mDialogDataModel;
    }

    public String getResBundleName() {
        return UtilitiesResBundle.getDefaultResourceBundleName();
    }

    public String getImageFolderName() {
        return UtilitiesResBundle.getImageFolder();
    }

    void setVarMoveHandler(IVarMoveHandler iVarMoveHandler) {
        this.mVarMoveHandler = iVarMoveHandler;
    }

    @Override
    public void init() {
        super.init();
        this.mVarsFromActiveDataset = this.loadVarsFromActiveDataset();
        this.mSelectModelPage = new SelectModelPage(this);
        this.mMatchDatasetFieldsToModelFieldsPage = new MatchDatasetFieldsToModelFieldsPage(this);
        this.mSelectScoringValuesToIncludePage = new SelectScoringValuesToIncludePage(this);
        this.mScoreFinishPage = new ScoreFinishPage(this);
        this.enableFinish(false);
        try {
            this.registerPage(this.mSelectModelPage);
            this.registerPage(this.mMatchDatasetFieldsToModelFieldsPage);
            this.registerPage(this.mSelectScoringValuesToIncludePage);
            this.registerPage(this.mScoreFinishPage);
        }
        catch (BaseWizardDialog.PageAlreadyRegistered pageAlreadyRegistered) {
            pageAlreadyRegistered.printStackTrace();
        }
        this.pack();
    }

    public SelectModelPage getSelectModelPage() {
        return this.mSelectModelPage;
    }

    public ArrayList<SelectScoringValuesToIncludePage.ScoringValuesTableModel.ModelDataRowInfo> getSelectedScoringExpressions() {
        return this.mSelectScoringValuesToIncludePage.getSelectedScoringFunctions();
    }

    public ScoreFinishPage getScoreFinishPage() {
        return this.mScoreFinishPage;
    }

    public MatchDatasetFieldsToModelFieldsPage getMatchDatasetFieldsToModelFieldsPage() {
        return this.mMatchDatasetFieldsToModelFieldsPage;
    }

    public SelectScoringValuesToIncludePage getSelectScoringValuesToIncludePage() {
        return this.mSelectScoringValuesToIncludePage;
    }

    public String getDialogHelpID() {
        return "idh_freq";
    }

    private Vector<ISpssVariable> loadVarsFromActiveDataset() {
        ISpssDataSrc iSpssDataSrc;
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        Vector<ISpssVariable> vector = new Vector<ISpssVariable>();
        if (spssFrame instanceof DataFrame && (iSpssDataSrc = DataMgr.getDataMgr().getDataSource(((DataFrame)spssFrame).getDatasetId())) != null) {
            for (int i = 0; i < iSpssDataSrc.columnCount(); ++i) {
                ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(i);
                vector.add(iSpssVariable);
            }
        }
        return vector;
    }

    @Override
    public String generateSyntax() {
        int n;
        int n2;
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        String string = this.getValidModelName(this.mSelectModelPage.getModelName());
        String string2 = this.mSelectModelPage.getModelFilePath();
        String string3 = this.mSelectModelPage.getModelType();
        if (string3.equals("TSC_PMML") || string3.equals("TSC_XML")) {
            stringBuffer.append("\nPREDICT THRU END.\nTSAPPLY\n   /MODELSUMMARY  PRINT=[MODELFIT]\n   /MODELSTATISTICS  DISPLAY=YES MODELFIT=[ SRSQUARE]\n   /SERIESPLOT FORECAST\n   /OUTPUTFILTER DISPLAY=ALLMODELS");
            stringBuffer.append("\n   /SAVE ");
            ArrayList<SelectScoringValuesToIncludePage.ScoringValuesTableModel.ModelDataRowInfo> arrayList = this.mSelectScoringValuesToIncludePage.getSelectedScoringFunctions();
            for (SelectScoringValuesToIncludePage.ScoringValuesTableModel.ModelDataRowInfo modelDataRowInfo : arrayList) {
                ModelOutputRole modelOutputRole = modelDataRowInfo.getRole();
                String string4 = modelDataRowInfo.getFieldName();
                String string5 = sExpressionSyntaxTable.get(modelOutputRole);
                if (string5 == null) continue;
                if (string5.equals("PREDICT")) {
                    stringBuffer.append("PREDICTED(");
                    stringBuffer.append(string4);
                    stringBuffer.append(")");
                    continue;
                }
                if (string5.equals("RESIDUAL")) {
                    stringBuffer.append("NRESIDUAL(");
                    stringBuffer.append(string4);
                    stringBuffer.append(")");
                    continue;
                }
                if (string5.equals("UPCONFLIMIT")) {
                    stringBuffer.append("UCL(");
                    stringBuffer.append(string4);
                    stringBuffer.append(")");
                    continue;
                }
                if (!string5.equals("LOCONFLIMIT")) continue;
                stringBuffer.append("LCL(");
                stringBuffer.append(string4);
                stringBuffer.append(")");
            }
            stringBuffer.append("\n   /AUXILIARY  CILEVEL=95 REESTIMATE=NO\n   /MISSING USERMISSING=EXCLUDE\n   /MODEL FILE=");
            stringBuffer.append(CharacterUtil.smartQuote((String)string2));
            stringBuffer.append(".");
            return stringBuffer.toString();
        }
        boolean bl = this.mMatchDatasetFieldsToModelFieldsPage.useSYSMIS();
        String string6 = bl ? "SYSMIS" : "SUBSTITUTE";
        stringBuffer.append("MODEL HANDLE NAME=");
        stringBuffer.append(string);
        stringBuffer.append(" FILE=");
        stringBuffer.append(CharacterUtil.smartQuote((String)string2));
        stringBuffer.append("\n  /OPTIONS MISSING=");
        stringBuffer.append(string6);
        String string7 = "";
        String string8 = "";
        int n3 = this.mMatchDatasetFieldsToModelFieldsPage.getNumberOfFields();
        for (n2 = 0; n2 < n3; ++n2) {
            String string9 = this.mMatchDatasetFieldsToModelFieldsPage.getFieldNameFrom(n2, 0);
            String string10 = this.mMatchDatasetFieldsToModelFieldsPage.getFieldNameFrom(n2, 1);
            if (string9.length() <= 0 || string10.length() <= 0 || string9.equals(string10)) continue;
            string7 = string7 + string9 + " ";
            string8 = string8 + "\"" + string10 + "\" ";
        }
        if (string7.length() > 0 && string8.length() > 0) {
            stringBuffer.append("\n  /MAP VARIABLES=" + string7 + " " + "MODELVARIABLES=" + string8 + " ");
        }
        stringBuffer.append(".");
        n2 = this.mSelectModelPage.isTargetString() ? 1 : 0;
        Field field = this.mSelectModelPage.getTargetField();
        int n4 = 500;
        if (field != null && n2 != 0) {
            n = 0;
            n = field instanceof ToolFieldFormat ? ((ToolFieldFormat)field).getWidth() : this.getLongestCatValues(field);
            if (n > 0) {
                n4 = n;
            }
        }
        n = 0;
        String string11 = "";
        String string12 = "APPLYMODEL(";
        String string13 = "";
        if (n2 != 0) {
            string11 = "'";
            string13 = "STRAPPLYMODEL(";
        }
        boolean bl2 = false;
        boolean bl3 = false;
        String string14 = "";
        ArrayList<SelectScoringValuesToIncludePage.ScoringValuesTableModel.ModelDataRowInfo> arrayList = this.mSelectScoringValuesToIncludePage.getSelectedScoringFunctions();
        for (SelectScoringValuesToIncludePage.ScoringValuesTableModel.ModelDataRowInfo modelDataRowInfo : arrayList) {
            boolean bl4;
            String string15;
            bl2 = false;
            bl3 = false;
            ModelOutputRole modelOutputRole = modelDataRowInfo.getRole();
            String string16 = modelDataRowInfo.getFieldName();
            String string17 = modelDataRowInfo.getSelectedValue();
            String string18 = sExpressionSyntaxTable.get(modelOutputRole);
            if (string18 != null) {
                bl2 = true;
                if (string18.equals("PREDICT")) {
                    bl3 = true;
                }
            }
            if (!bl2) continue;
            if (bl3 && n2 != 0) {
                if (!this.isExistingVar(string16)) {
                    stringBuffer.append("\nSTRING " + string16 + "(A" + n4 + ").");
                    n = 1;
                }
                string14 = string16;
            }
            if ((string15 = this.getAlterTypeSyntax(string16, bl4 = bl3 && n2 != 0, n4)).length() > 0) {
                stringBuffer.append(string15);
            }
            stringBuffer.append("\nCOMPUTE ");
            stringBuffer.append(string16 + "=");
            if (bl3 && n2 != 0) {
                stringBuffer.append(string13);
            } else {
                stringBuffer.append(string12);
            }
            stringBuffer.append(string + ", '");
            stringBuffer.append(string18 + "'");
            if (string17 != null && string17.length() != 0) {
                if (string11.length() > 0) {
                    stringBuffer.append(", " + string11 + string17 + string11);
                } else if (string17.startsWith("-")) {
                    stringBuffer.append(", '" + string17 + "'");
                } else {
                    stringBuffer.append(", " + string11 + string17 + string11);
                }
            }
            stringBuffer.append(").");
        }
        if (n != 0 && n4 == 500) {
            stringBuffer.append("\nALTER TYPE " + string14 + " (AMIN).");
        } else {
            stringBuffer.append("\nEXECUTE.");
        }
        stringBuffer.append("\nMODEL CLOSE NAME=" + string);
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    private void setActionInfo(AbstractAction abstractAction, String string) {
        abstractAction.putValue("Name", ResUtil.getCommonDlgString(string));
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            String string2 = string;
            Integer n = ResUtil.getCommonDlgAccessKey(string2 = string2.replaceFirst("IDS_", "IDK_"));
            if (n != null) {
                abstractAction.putValue("MnemonicKey", n);
            }
        }
    }

    public String getModelType() {
        return this.mSelectModelPage != null ? this.mSelectModelPage.getModelType() : null;
    }

    public String getDisplayTextForRoleType(RoleType roleType) {
        String string = null;
        if (roleType != null) {
            switch (roleType) {
                case input: {
                    string = "IDS_SCORING_WIZARD_ROLE_PREDICTOR";
                    break;
                }
                case recordId: {
                    string = "IDS_SCORING_WIZARD_ROLE_RECORD_ID";
                    break;
                }
                case split: {
                    string = "IDS_SCORING_WIZARD_ROLE_SPLIT";
                    break;
                }
                default: {
                    string = "IDS_SCORING_WIZARD_ROLE_UNSUPPORTED";
                }
            }
            string = string != null ? string : roleType.toString();
        }
        return string != null ? this.getResString(string) : "";
    }

    public String getDisplayTextForScoringType(StorageType storageType) {
        String string = null;
        if (storageType != null) {
            switch (storageType) {
                case date: {
                    string = "IDS_SCORING_WIZARD_SCORING_TYPE_DATE";
                    break;
                }
                case integer: {
                    string = "IDS_SCORING_WIZARD_SCORING_TYPE_NUMERIC";
                    break;
                }
                case real: {
                    string = "IDS_SCORING_WIZARD_SCORING_TYPE_NUMERIC";
                    break;
                }
                case string: {
                    string = "IDS_SCORING_WIZARD_SCORING_TYPE_STRING";
                    break;
                }
                case time: {
                    string = "IDS_SCORING_WIZARD_SCORING_TYPE_TIME";
                    break;
                }
                case timestamp: {
                    string = "IDS_SCORING_WIZARD_SCORING_TYPE_TIMESTAMP";
                    break;
                }
                case unknown: {
                    string = "IDS_SCORING_WIZARD_SCORING_TYPE_UNKNOWN";
                }
            }
            string = string != null ? string : storageType.toString();
        }
        return string != null ? this.getResString(string) : "";
    }

    public String getDisplayTextForMeasureType(MeasurementType measurementType) {
        String string = null;
        if (measurementType != null) {
            switch (measurementType) {
                case continuous: {
                    string = "IDS_SCORING_WIZARD_MEASURMENT_TYPE_CONTINUOUS";
                    break;
                }
                case discrete: {
                    string = "IDS_SCORING_WIZARD_MEASURMENT_TYPE_NOMINAL";
                    break;
                }
                case flag: {
                    string = "IDS_SCORING_WIZARD_MEASURMENT_TYPE_FLAG";
                    break;
                }
                case nominal: {
                    string = "IDS_SCORING_WIZARD_MEASURMENT_TYPE_NOMINAL";
                    break;
                }
                case ordinal: {
                    string = "IDS_SCORING_WIZARD_MEASURMENT_TYPE_ORDINAL";
                    break;
                }
                case typeless: {
                    string = "IDS_SCORING_WIZARD_MEASURMENT_TYPE_TYPELESS";
                    break;
                }
                case unknown: {
                    string = "IDS_SCORING_WIZARD_MEASURMENT_TYPE_UNKNOWN";
                }
            }
            string = string != null ? string : measurementType.toString();
        }
        return string != null ? this.getResString(string) : "";
    }

    public String getDisplayTextForModelType(String string) {
        String string2 = null;
        if (string != null) {
            if (string.equals("UNKNOWN")) {
                string2 = "IDS_SCORING_WIZARD_MODEL_TYPE_UNKNOWN";
            }
            if (string.equals("MLR")) {
                string2 = "IDS_SCORING_WIZARD_MODEL_TYPE_MLR";
            }
            if (string.equals("CLR")) {
                string2 = "IDS_SCORING_WIZARD_MODEL_TYPE_CLR";
            }
            if (string.equals("LR")) {
                string2 = "IDS_SCORING_WIZARD_MODEL_TYPE_LR";
            }
            if (string.equals("BLR")) {
                string2 = "IDS_SCORING_WIZARD_MODEL_TYPE_BLR";
            }
            if (string.equals("GLR")) {
                string2 = "IDS_SCORING_WIZARD_MODEL_TYPE_GLR";
            }
            if (string.equals("GZLR")) {
                string2 = "IDS_SCORING_WIZARD_MODEL_TYPE_GZLR";
            }
            if (string.equals("OR")) {
                string2 = "IDS_SCORING_WIZARD_MODEL_TYPE_OR";
            }
            if (string.equals("DA")) {
                string2 = "IDS_SCORING_WIZARD_MODEL_TYPE_DA";
            }
            if (string.equals("CLUSTER_TWOSTEP")) {
                string2 = "IDS_SCORING_WIZARD_MODEL_TYPE_CLUSTER_TWOSTEP";
            }
            if (string.equals("CLUSTER_KMEANS")) {
                string2 = "IDS_SCORING_WIZARD_MODEL_TYPE_CLUSTER_KMEANS";
            }
            if (string.equals("CLUSTER_KOHONEN")) {
                string2 = "IDS_SCORING_WIZARD_MODEL_TYPE_CLUSTER_KOHONEN";
            }
            if (string.equals("ASSOCIATION")) {
                string2 = "IDS_SCORING_WIZARD_MODEL_TYPE_ASSOCIATION";
            }
            if (string.equals("ASSOCIATIONRULE")) {
                string2 = "IDS_SCORING_WIZARD_MODEL_TYPE_ASSOCIATIONRULE";
            }
            if (string.equals("SEQUENTIAL")) {
                string2 = "IDS_SCORING_WIZARD_MODEL_TYPE_SEQUENTIAL";
            }
            if (string.equals("TREE_PMML")) {
                string2 = "IDS_SCORING_WIZARD_MODEL_TYPE_TREE_PMML";
            }
            if (string.equals("TREE_RULESET")) {
                string2 = "IDS_SCORING_WIZARD_MODEL_TYPE_TREE_RULESET";
            }
            if (string.equals("TREE_BOOSTED")) {
                string2 = "IDS_SCORING_WIZARD_MODEL_TYPE_TREE_BOOSTED";
            }
            if (string.equals("NNETWORK_MLP")) {
                string2 = "IDS_SCORING_WIZARD_MODEL_TYPE_NNETWORK_MLP";
            }
            if (string.equals("NNETWORK_RBF")) {
                string2 = "IDS_SCORING_WIZARD_MODEL_TYPE_NNETWORK_RBF";
            }
            if (string.equals("NNETWORK_SOM")) {
                string2 = "IDS_SCORING_WIZARD_MODEL_TYPE_NNETWORK_SOM";
            }
            if (string.equals("NAIVE_BAYES")) {
                string2 = "IDS_SCORING_WIZARD_MODEL_TYPE_NAIVE_BAYES";
            }
            if (string.equals("ANOMALYDETECTION")) {
                string2 = "IDS_SCORING_WIZARD_MODEL_TYPE_ANOMALYDETECTION";
            }
            if (string.equals("RULESET")) {
                string2 = "IDS_SCORING_WIZARD_MODEL_TYPE_RULESET";
            }
            if (string.equals("RULESET_DL")) {
                string2 = "IDS_SCORING_WIZARD_MODEL_TYPE_RULESET_DL";
            }
            if (string.equals("SELF_LEARNING")) {
                string2 = "IDS_SCORING_WIZARD_MODEL_TYPE_SELF_LEARNING";
            }
            if (string.equals("COXREG")) {
                string2 = "IDS_SCORING_WIZARD_MODEL_TYPE_COXREG";
            }
            if (string.equals("CSCOXREG")) {
                string2 = "IDS_SCORING_WIZARD_MODEL_TYPE_CSCOXREG";
            }
            if (string.equals("BAYESNET")) {
                string2 = "IDS_SCORING_WIZARD_MODEL_TYPE_BAYESNET";
            }
            if (string.equals("SVM_CSVC")) {
                string2 = "IDS_SCORING_WIZARD_MODEL_TYPE_SVM_CSVC";
            }
            if (string.equals("SVM_EPSILONSVR")) {
                string2 = "IDS_SCORING_WIZARD_MODEL_TYPE_SVM_EPSILONSVR";
            }
            if (string.equals("KNN_CLS")) {
                string2 = "IDS_SCORING_WIZARD_MODEL_TYPE_KNN_CLS";
            }
            if (string.equals("KNN_REG")) {
                string2 = "IDS_SCORING_WIZARD_MODEL_TYPE_KNN_REG";
            }
            if (string.equals("KNN_MULRES")) {
                string2 = "IDS_SCORING_WIZARD_MODEL_TYPE_KNN_MULRES";
            }
            if (string.equals("KNN_NORESP")) {
                string2 = "IDS_SCORING_WIZARD_MODEL_TYPE_KNN_NORESP";
            }
            if (string.equals("MINING_CLS")) {
                string2 = "IDS_SCORING_WIZARD_MODEL_TYPE_MINING_CLS";
            }
            if (string.equals("MINING_REG")) {
                string2 = "IDS_SCORING_WIZARD_MODEL_TYPE_MINING_REG";
            }
            if (string.equals("EXTENDED")) {
                string2 = "IDS_SCORING_WIZARD_MODEL_TYPE_EXTENDED";
            }
            string2 = string2 != null ? string2 : string;
        }
        return string2 != null ? this.getResString(string2) : "";
    }

    public String getScoringDisplayTextForRole(ModelOutputRole modelOutputRole, boolean bl) {
        String string = modelOutputRole.toString();
        switch (modelOutputRole) {
            case recordId: {
                if (bl) {
                    string = "IDS_SCORING_WIZARD_ROLE_SCORE_NEAREST_KNEIGHBOR";
                    break;
                }
                string = "IDS_SCORING_WIZARD_ROLE_SCORE_NEAREST_NEIGHBOR";
                break;
            }
            case probability: 
            case propensity: {
                if (bl) {
                    string = "IDS_SCORING_WIZARD_ROLE_SCORE_SEL_PROBABLITY";
                    break;
                }
                string = "IDS_SCORING_WIZARD_ROLE_SCORE_PRED_PROBABLITY";
                break;
            }
            case entityAffinity: {
                if (bl) {
                    string = "IDS_SCORING_WIZARD_ROLE_SCORE_DISTANCE_KNN";
                    break;
                }
                string = "IDS_SCORING_WIZARD_ROLE_SCORE_DISTANCE_NN";
                break;
            }
            case predictedValue: 
            case clusterId: 
            case ruleValue: {
                string = "IDS_SCORING_WIZARD_ROLE_SCORE_PREDICTED_VALUE";
                break;
            }
            case confidence: {
                string = "IDS_SCORING_WIZARD_ROLE_SCORE_CONFIDENCE";
                break;
            }
            case cumulativeHazard: {
                string = "IDS_SCORING_WIZARD_ROLE_SCORE_CUM_HAZARD";
                break;
            }
            case entityId: {
                string = "IDS_SCORING_WIZARD_ROLE_SCORE_NODE_NUMBER";
                break;
            }
            case standardError: {
                string = "IDS_SCORING_WIZARD_ROLE_SCORE_STD_ERROR";
                break;
            }
            case residual: {
                string = "IDS_SCORING_WIZARD_ROLE_SCORE_NOISE_RESIDUALS";
                break;
            }
            case upperConfidenceLimit: {
                string = "IDS_SCORING_WIZARD_ROLE_SCORE_UPPER_CONFIDENCE_LIMITS";
                break;
            }
            case lowerConfidenceLimit: {
                string = "IDS_SCORING_WIZARD_ROLE_SCORE_LOWER_CONFIDENCE_LIMITS";
            }
        }
        return this.getResString(string);
    }

    public String getFieldNameForRole(ModelOutputRole modelOutputRole, boolean bl) {
        String string = modelOutputRole.toString();
        switch (modelOutputRole) {
            case recordId: {
                if (bl) {
                    string = "KNearestNeighbor";
                    break;
                }
                string = "NearestNeighbor";
                break;
            }
            case probability: 
            case propensity: {
                if (bl) {
                    string = "SelectedProbability";
                    break;
                }
                string = "PredictedProbability";
                break;
            }
            case entityAffinity: {
                if (bl) {
                    string = "DistanceKNN";
                    break;
                }
                string = "DistanceNN";
                break;
            }
            case predictedValue: 
            case clusterId: 
            case ruleValue: {
                string = "PredictedValue";
                break;
            }
            case confidence: {
                string = "Confidence";
                break;
            }
            case cumulativeHazard: {
                string = "CumulativeHazard";
                break;
            }
            case entityId: {
                string = "NodeNumber";
                break;
            }
            case standardError: {
                string = "StandardError";
            }
        }
        return string;
    }

    public boolean canFinish() {
        boolean bl = this.mSelectModelPage != null ? this.mSelectModelPage.isPageValidToContinue() : false;
        boolean bl2 = this.mMatchDatasetFieldsToModelFieldsPage != null ? this.mMatchDatasetFieldsToModelFieldsPage.isPageValidToContinue() : false;
        boolean bl3 = this.mSelectScoringValuesToIncludePage != null ? this.mSelectScoringValuesToIncludePage.isPageValidToContinue() : false;
        return bl && bl2 && bl3;
    }

    @Override
    protected BaseWizardDialog.DoFinishAction doFinish() {
        if (this.mScoreFinishPage.isPasteRadioSelected()) {
            return BaseWizardDialog.DoFinishAction.ePaste;
        }
        return BaseWizardDialog.DoFinishAction.eOK;
    }

    @Override
    protected boolean validateOnFinish() {
        return super.validateOnFinish();
    }

    public Vector<Object> addBaseWizardTabTraversal(Vector<Object> vector) {
        int n;
        Vector<Object> vector2 = new Vector<Object>();
        for (n = 0; n < vector.size(); ++n) {
            vector2.add(vector.elementAt(n));
        }
        for (n = 0; n < this.mCmdButtonPanel.getComponentCount(); ++n) {
            vector2.add(this.mCmdButtonPanel.getComponent(n));
        }
        return vector2;
    }

    @Override
    public String getIActionKey() {
        return "utilities_scoring_wizard";
    }

    public String getTitle() {
        return this.getResString("IDS_SCORING_WIZARD_TITLE");
    }

    public Vector<ISpssVariable> getVarsFromActiveDataset() {
        return this.mVarsFromActiveDataset;
    }

    public JFrame getParentFrame() {
        return this.mParent;
    }

    private boolean isExistingVar(String string) {
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(((DataFrame)spssFrame).getDatasetId());
        return iSpssDataSrc.findVarIndex(string) >= 0;
    }

    private String getAlterTypeSyntax(String string, boolean bl, int n) {
        String string2 = "";
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(((DataFrame)spssFrame).getDatasetId());
        int n2 = iSpssDataSrc.findVarIndex(string);
        if (n2 >= 0) {
            boolean bl2 = iSpssDataSrc.getVariable(n2).getFormat().getFormatType().isStringFormat();
            if (bl2 && bl || !bl2 && !bl) {
                return string2;
            }
            string2 = bl ? "\nALTER TYPE " + string + "(A" + n + ")." : "\nALTER TYPE " + string + " (F8.2).";
        }
        return string2;
    }

    private int getLongestCatValues(Field field) {
        int n = 0;
        if (field != null) {
            int n2 = 0;
            Iterator iterator = field.getValueLabelKeys();
            while (iterator != null && iterator.hasNext()) {
                n2 = iterator.next().toString().getBytes().length;
                if (n >= n2) continue;
                n = n2;
            }
        }
        return n;
    }

    private String getValidModelName(String string) {
        char c;
        int n;
        String string2 = string;
        if (string.contains(" ")) {
            string2 = string.replaceAll(" ", "");
        }
        int n2 = string2.length();
        for (n = 0; n < n2 && (Character.isDigit(c = string2.charAt(n)) || c == '$' || c == '#' || c == '_' || c == '.'); ++n) {
        }
        if (n > 0) {
            string2 = string2.substring(n, n2);
        }
        if ((n2 = string2.length()) > 0 && VarNameValidator.validateSPSSName((String)string2, (boolean)false) == VarNameValidator.ValidNameCode.SPSSNAME_STANDARD) {
            return string2;
        }
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(((DataFrame)spssFrame).getDatasetId());
        string2 = iSpssDataSrc.getUniqueVarName() + "_model";
        return string2;
    }

    static {
        sExpressionSyntaxTable.put(ModelOutputRole.predictedValue, "PREDICT");
        sExpressionSyntaxTable.put(ModelOutputRole.clusterId, "PREDICT");
        sExpressionSyntaxTable.put(ModelOutputRole.ruleValue, "PREDICT");
        sExpressionSyntaxTable.put(ModelOutputRole.probability, "PROBABILITY");
        sExpressionSyntaxTable.put(ModelOutputRole.propensity, "PROBABILITY");
        sExpressionSyntaxTable.put(ModelOutputRole.confidence, "CONFIDENCE");
        sExpressionSyntaxTable.put(ModelOutputRole.standardError, "STDDEV");
        sExpressionSyntaxTable.put(ModelOutputRole.cumulativeHazard, "CUMHAZARD");
        sExpressionSyntaxTable.put(ModelOutputRole.entityId, "NODEID");
        sExpressionSyntaxTable.put(ModelOutputRole.recordId, "NEIGHBOR");
        sExpressionSyntaxTable.put(ModelOutputRole.entityAffinity, "DISTANCE");
        sExpressionSyntaxTable.put(ModelOutputRole.residual, "RESIDUAL");
        sExpressionSyntaxTable.put(ModelOutputRole.upperConfidenceLimit, "UPCONFLIMIT");
        sExpressionSyntaxTable.put(ModelOutputRole.lowerConfidenceLimit, "LOCONFLIMIT");
    }
}

