/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.direct_marketing;

import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.dialogs.base.graphs.IMatrixListener;
import com.spss.java_client.ui.dialogs.base.graphs.ImageLabelKeyListenerEx;
import com.spss.java_client.ui.dialogs.base.graphs.MatrixImageEx;
import com.spss.java_client.ui.dialogs.base.graphs.MatrixImagesGroupEx;
import com.spss.java_client.ui.dialogs.common.BaseGatingDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.direct_marketing.res.DirectMarketingResBundle;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.util.AccessibilityUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class RFMGatingDialog
extends BaseGatingDialog
implements IMatrixListener {
    private MatrixImagesGroupEx controlChartsImageGroup;
    private MatrixImageEx mTransactionDataImage;
    private JLabel mTransactionDataLabel;
    private JTextArea mTransactionContextLabel;
    private JLabel panelTitle;
    private MatrixImageEx mCustomerImage;
    private JLabel mCustomerLabel;
    private JTextArea mCustomerContextLabel;
    private static final Border DASH_BORDER = new DashBorder();
    private static final Border WHITE_BORDER = BorderFactory.createLineBorder(Color.WHITE, 4);
    private static final Border SELECT_BORDER = BorderFactory.createLineBorder(Color.LIGHT_GRAY, 4);

    public RFMGatingDialog(JFrame jFrame) throws HeadlessException {
        super(jFrame, DirectMarketingResBundle.getDefaultResourceBundleName(), DirectMarketingResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_DIRECT_MARETING_RFM_FORMAT_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_dm_rfm_gating";
    }

    @Override
    public String getIActionKey() {
        return "application_direct_marketing_rfm_data_format";
    }

    @Override
    public boolean continuePressed() {
        return true;
    }

    @Override
    public String getNextProcDlgActionKey() {
        String string = null;
        if (this.mTransactionDataImage.isSelected()) {
            string = "analyze_rfm_transaction";
        } else if (this.mCustomerImage.isSelected()) {
            string = "analyze_rfm_customer";
        }
        return string;
    }

    @Override
    public void loadDialogState() {
        super.loadDialogState();
    }

    @Override
    public void saveDialogState() {
        super.saveDialogState();
    }

    @Override
    public void matrixImageEvent(IMatrixListener.EventType eventType, int n) {
        if (eventType == IMatrixListener.EventType.doubleClick) {
            this.mContinueAction.actionPerformed(new ActionEvent(this, 1, "launch"));
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, n2, 1, n2);
        JPanel jPanel2 = PanelFactory.getEmptyPanel("");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel2, this.mTransactionDataImage, gridBagConstraints, 0, 0, 1, 2, n, insets);
        gridBagConstraints.fill = 0;
        Insets insets2 = new Insets(0, n2, 1, n2 + 22);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel2, this.mTransactionDataLabel, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel2, this.mTransactionContextLabel, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        JPanel jPanel3 = PanelFactory.getEmptyPanel("");
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel3, this.mCustomerImage, gridBagConstraints, 0, 0, 1, 2, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets2.set(0, n2, 1, n2 + 22);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel3, this.mCustomerLabel, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel3, this.mCustomerContextLabel, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        insets.set(n2, 0, n2, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.panelTitle, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(n2, 0, n2 + 4, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(n2 + 4, 0, n2, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 2, 1, 1, n, insets);
        this.setTabPolicy();
        this.pack();
    }

    private void initVars() {
        this.panelTitle = DialogUtil.createLabel(this, "IDS_DIRECT_MARETING_RFM_FORMAT_MYDATA_LABEL");
        this.controlChartsImageGroup = new MatrixImagesGroupEx();
        this.mTransactionDataImage = new MatrixImageEx(this.getResImageURL("IDS_DIRECT_MARETING_RFM_FORMAT_TRANSACTION_IMAGE"));
        this.mTransactionDataLabel = DialogUtil.createLabel(this, "IDS_DIRECT_MARETING_RFM_FORMAT_TRANSACTION_DATA");
        Font font = this.mTransactionDataLabel.getFont();
        this.mTransactionDataImage.setFocusable(true);
        int n = font.getSize() + 1;
        this.mTransactionDataLabel.setFont(new Font(font.getName(), 1, n));
        this.mTransactionDataLabel.getAccessibleContext().setAccessibleName("");
        this.mTransactionContextLabel = DialogUtil.createCommonInfoArea(this, "IDS_DIRECT_MARETING_RFM_FORMAT_TRANSACTION_DATA_DESC", 400, 50);
        this.mCustomerImage = new MatrixImageEx(this.getResImageURL("IDS_DIRECT_MARETING_RFM_FORMAT_CUSTOMER_IMAGE"));
        this.mCustomerLabel = DialogUtil.createLabel(this, "IDS_DIRECT_MARETING_RFM_FORMAT_CUSTOMER_DATA");
        this.mCustomerLabel.setFont(new Font(font.getName(), 1, n));
        this.mCustomerLabel.getAccessibleContext().setAccessibleName("");
        this.mCustomerContextLabel = DialogUtil.createCommonInfoArea(this, "IDS_DIRECT_MARETING_RFM_FORMAT_CUSTOMER_DATA_DESC", 400, 50);
        Vector<MatrixImageEx> vector = new Vector<MatrixImageEx>();
        vector.add(this.mTransactionDataImage);
        vector.add(this.mCustomerImage);
        this.controlChartsImageGroup.addMatrixImages(vector);
        this.mCustomerImage.addMatrixListener(this);
        this.mTransactionDataImage.addMatrixListener(this);
    }

    private void setTabPolicy() {
        Vector<Object> vector = new Vector<Object>();
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            vector.add(this.controlChartsImageGroup);
            vector.add(this.mDefineButton);
            vector.add(this.mHelpButton);
            vector.add(this.mCancelButton);
        } else {
            vector.add(this.mDefineButton);
            vector.add(this.mCancelButton);
            vector.add(this.mHelpButton);
            vector.add(this.controlChartsImageGroup);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setDefaults() {
        this.mTransactionDataImage.setDefaultSelectedImage(true);
        AccessibilityUtil.setAccessibleDescription((Component)this.mTransactionDataImage, (Object)(this.getResString("IDS_DIRECT_MARETING_RFM_FORMAT_TRANSACTION_DATA") + this.getResString("IDS_DIRECT_MARETING_RFM_FORMAT_TRANSACTION_DATA_DESC") + "selected. use arrow keys to change selection."));
        this.mCustomerImage.setDefaultSelectedImage(false);
        AccessibilityUtil.setAccessibleDescription((Component)this.mCustomerImage, (Object)(this.getResString("IDS_DIRECT_MARETING_RFM_FORMAT_CUSTOMER_DATA") + this.getResString("IDS_DIRECT_MARETING_RFM_FORMAT_CUSTOMER_DATA_DESC")));
    }

    private void addMouseListener(MatrixImageEx matrixImageEx, Vector<MatrixImageEx> vector) {
        matrixImageEx.setBorder(WHITE_BORDER);
        MouseListener[] mouseListenerArray = matrixImageEx.getMouseListeners();
        EventListener[] eventListenerArray = mouseListenerArray;
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            MouseListener mouseListener = eventListenerArray[i];
            matrixImageEx.removeMouseListener(mouseListener);
        }
        matrixImageEx.addMouseListener(new DMImageMouseListener(matrixImageEx));
        for (EventListener eventListener : eventListenerArray = matrixImageEx.getFocusListeners()) {
            matrixImageEx.removeFocusListener((FocusListener)eventListener);
        }
        matrixImageEx.addFocusListener(new DMImageFocusListener(matrixImageEx));
        matrixImageEx.addKeyListener(new ImageLabelKeyListenerEx(vector, this.controlChartsImageGroup));
    }

    static class DashBorder
    extends EmptyBorder {
        private BasicStroke mStroke = null;

        public DashBorder() {
            super(1, 1, 1, 1);
            float[] fArray = new float[]{4.0f, 4.0f, 4.0f, 4.0f};
            this.mStroke = new BasicStroke(1.0f, 1, 1, 0.0f, fArray, 0.0f);
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (graphics instanceof Graphics2D) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Color color = graphics2D.getColor();
                Stroke stroke = graphics2D.getStroke();
                graphics2D.setColor(SystemColor.black);
                graphics2D.setStroke(this.mStroke);
                graphics2D.drawRect(n, n2, n3 - 1, n4 - 1);
                graphics2D.setStroke(stroke);
                graphics2D.setColor(color);
            }
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }

    class DMImageFocusListener
    extends FocusAdapter {
        private MatrixImageEx mImage;

        public DMImageFocusListener(MatrixImageEx matrixImageEx) {
            this.mImage = matrixImageEx;
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            Border border = BorderFactory.createLineBorder(Color.WHITE, 3);
            this.mImage.getImagesGroup().getSelectedMatrixImage().setBorder(BorderFactory.createCompoundBorder(DASH_BORDER, border));
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.mImage.getImagesGroup().getSelectedMatrixImage().setBorder(WHITE_BORDER);
        }
    }

    class DMImageMouseListener
    extends MouseAdapter {
        private MatrixImageEx mImage;

        public DMImageMouseListener(MatrixImageEx matrixImageEx) {
            this.mImage = matrixImageEx;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            MatrixImageEx matrixImageEx = (MatrixImageEx)mouseEvent.getSource();
            matrixImageEx.setSelected(true);
            Border border = BorderFactory.createLineBorder(Color.BLACK, 2);
            Border border2 = BorderFactory.createLineBorder(Color.WHITE, 2);
            matrixImageEx.setBorder(BorderFactory.createCompoundBorder(border, border2));
            matrixImageEx.requestFocusInWindow();
            if (!mouseEvent.isPopupTrigger() && mouseEvent.getClickCount() > 1) {
                this.mImage.fireMatrixEvent(IMatrixListener.EventType.doubleClick, this.mImage.getImagesGroup().getMatrixImageIndex(this.mImage));
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            MatrixImageEx matrixImageEx = (MatrixImageEx)mouseEvent.getSource();
            matrixImageEx.requestFocusInWindow();
            matrixImageEx.setBorder(SELECT_BORDER);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            MatrixImageEx matrixImageEx = (MatrixImageEx)mouseEvent.getSource();
            matrixImageEx.setBorder(WHITE_BORDER);
        }
    }
}

