/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.direct_marketing;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ParseScoringPropertiesXML {
    public static ScoringPropertiesInfo initParseScoringPropertiesFromXML(String string) {
        ScoringPropertiesInfo scoringPropertiesInfo = null;
        Document document = ParseScoringPropertiesXML.openIntoDocument(string);
        if (document != null) {
            scoringPropertiesInfo = new ScoringPropertiesInfo(document);
        }
        return scoringPropertiesInfo;
    }

    private static Document openIntoDocument(String string) {
        Document document = null;
        try {
            StringBuffer stringBuffer = new StringBuffer(string);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(stringBuffer.toString().getBytes("UTF-8"));
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(byteArrayInputStream);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return document;
    }

    public static class ScoringPropertiesInfo {
        private boolean mHasSplits = false;
        private String mEnsembleType;
        private String mAppName;
        private String mAppVersion;
        private String mModelType;

        public ScoringPropertiesInfo(Document document) {
            this.initFromXMLDoc(document);
        }

        private void initFromXMLDoc(Document document) {
            Node node;
            NodeList nodeList = document.getElementsByTagName("ModelProperties");
            if (nodeList != null && nodeList.getLength() != 0 && (node = nodeList.item(0)) != null) {
                this.initModelTypesSummary(node);
            }
        }

        public boolean isUnknownModel() {
            return this.mModelType.equals("UNKNOWN");
        }

        public boolean isTimeSeriesModel() {
            return this.mModelType.equals("TSC_PMML") || this.mModelType.equals("TSC_XML");
        }

        private void initModelTypesSummary(Node node) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                String string = node2.getNodeName();
                if (!string.equals("ModelTypesSummary")) continue;
                this.initModelType(node2);
                if (this.mModelType.equals("UNKNOWN")) continue;
                this.initHasSplits(node2);
                this.initEnsembleType(node2);
                this.initAppName(node2);
                this.initAppVeraion(node2);
            }
        }

        private void initHasSplits(Node node) {
            Node node2 = node.getAttributes().getNamedItem("hasSplits");
            String string = node2 != null ? node2.getNodeValue() : null;
            this.mHasSplits = string != null && string.equals("true");
        }

        private void initEnsembleType(Node node) {
            Node node2 = node.getAttributes().getNamedItem("ensembleType");
            this.mEnsembleType = node2 != null ? node2.getNodeValue() : "";
        }

        private void initAppName(Node node) {
            Node node2 = node.getAttributes().getNamedItem("appName");
            this.mAppName = node2 != null ? node2.getNodeValue() : "";
        }

        private void initAppVeraion(Node node) {
            Node node2 = node.getAttributes().getNamedItem("appVersion");
            this.mAppVersion = node2 != null ? node2.getNodeValue() : "";
        }

        private void initModelType(Node node) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                String string = node2.getNodeName();
                if (!string.equals("Model")) continue;
                Node node3 = node2.getAttributes().getNamedItem("modelType");
                this.mModelType = node3 != null ? node3.getNodeValue() : "";
            }
        }

        public String getModelType() {
            return this.mModelType;
        }

        public boolean isHasSplits() {
            return this.mHasSplits;
        }

        public String getEnsembleType() {
            return this.mEnsembleType;
        }

        public String getAppName() {
            return this.mAppName;
        }

        public String getAppVersion() {
            return this.mAppVersion;
        }
    }
}

