/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.direct_marketing;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFile;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.resources.CoreResUtil;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.dialogs.base.edit.OptionsUtil;
import com.spss.java_client.ui.dialogs.base.utilities.res.UtilitiesResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.fopen.FileValidator;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

public class MergeModelXMLDlg
extends BaseProcedureDialog
implements FocusListener,
ActionListener {
    static final String MODEL_XML_FILE_TEXT_KEY = "IDK_MODEL_XML_FILE_TEXT";
    static final String TRANSFORMATION_XML_FILE_TEXT_KEY = "IDK_TRANSFORMATION_XML_FILE_TEXT";
    static final String SAVED_MERGED_XML_FILE_TEXT_KEY = "IDK_SAVED_MERGED_XML_FILE_TEXT";
    private JTextArea mInfoTextArea;
    private JLabel mInputGroupboxLabel;
    private JLabel mModelXMLFileLabel;
    private JLabel mTransformationXMLFileLabel;
    private JLabel mSavedMergedXMLFileLabel;
    private FileTextField mModelXMLFileText;
    private FileTextField mTransformationXMLFileText;
    private FileTextField mSavedMergedXMLFileText;
    private JButton mModelBrowseButton;
    private JButton mTransformationBrowseButton;
    private JButton mSavedMergedBrowseButton;

    public MergeModelXMLDlg(JFrame jFrame) {
        super(jFrame, true, UtilitiesResBundle.getDefaultResourceBundleName(), UtilitiesResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_MERGE_XML_TITLE"));
        this.setDefaultCloseOperation(0);
        Dimension dimension = ProcedureDlgMgr.getMgr().getDialogSize(this.getIActionKey());
        if (dimension != null) {
            this.setSize(dimension);
            this.setLocationRelativeTo(this.getParent());
        }
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("TMS MERGE"));
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getMainCommandParamters("/MODEL INFILE="));
        stringBuffer.append(CharacterUtil.smartQuote((String)this.mModelXMLFileText.getText()));
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getMainCommandParamters("/TRANSFORMATIONS INFILE="));
        stringBuffer.append(CharacterUtil.smartQuote((String)this.mTransformationXMLFileText.getText()));
        stringBuffer.append("\n");
        stringBuffer.append(SyntaxUtil.getMainCommandParamters("/DESTINATION OUTFILE="));
        stringBuffer.append(CharacterUtil.smartQuote((String)this.mSavedMergedXMLFileText.getText()));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public String getIActionKey() {
        return "utilities_merge_model_xml";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_merge_model_xml";
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupMainPanel(jPanel);
        this.enableUIItems();
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MergeModelXMLDlg.this.dispose();
            }
        });
        this.pack();
    }

    @Override
    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = super.setupCmdButtonPanel();
        this.getRootPane().setDefaultButton(this.getOkButton());
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    @Override
    protected void loadDialogState() {
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        String string = dialogDataModel.getString(MODEL_XML_FILE_TEXT_KEY);
        if (string != null) {
            this.mModelXMLFileText.setText(string);
        }
        if ((string = dialogDataModel.getString(TRANSFORMATION_XML_FILE_TEXT_KEY)) != null) {
            this.mTransformationXMLFileText.setText(string);
        }
        if ((string = dialogDataModel.getString(SAVED_MERGED_XML_FILE_TEXT_KEY)) != null) {
            this.mSavedMergedXMLFileText.setText(string);
        }
    }

    @Override
    protected void saveDialogState() {
        this.getDialogDataModel().putString(MODEL_XML_FILE_TEXT_KEY, this.mModelXMLFileText.getText());
        this.getDialogDataModel().putString(TRANSFORMATION_XML_FILE_TEXT_KEY, this.mTransformationXMLFileText.getText());
        this.getDialogDataModel().putString(SAVED_MERGED_XML_FILE_TEXT_KEY, this.mSavedMergedXMLFileText.getText());
    }

    private void initVars() {
        TextFieldListener textFieldListener = new TextFieldListener();
        this.mInfoTextArea = new JTextArea(this.getResString("IDS_MERGE_MESSAGE_LABEL"));
        this.mInfoTextArea.setEditable(false);
        this.mInfoTextArea.setOpaque(false);
        this.mInfoTextArea.setFocusable(false);
        this.mInfoTextArea.setWrapStyleWord(true);
        this.mInfoTextArea.setLineWrap(true);
        this.mInputGroupboxLabel = DialogUtil.createLabel(this, "IDS_MERGE_XML_IMPUT_XML_GROUPBOX_LABEL");
        this.mModelXMLFileText = new FileTextField();
        this.mModelXMLFileText.setColumns(45);
        this.mModelXMLFileLabel = DialogUtil.createLabel(this, "IDS_MERGE_XML_MODEL_LABEL");
        this.mModelXMLFileLabel.setLabelFor((Component)((Object)this.mModelXMLFileText));
        this.mModelXMLFileText.getDocument().addDocumentListener(textFieldListener);
        this.mModelXMLFileText.addFocusListener(this);
        this.mTransformationXMLFileText = new FileTextField();
        this.mTransformationXMLFileText.setColumns(45);
        this.mTransformationXMLFileLabel = DialogUtil.createLabel(this, "IDS_MERGE_XML_TRANSFORMATION_LABEL");
        this.mTransformationXMLFileLabel.setLabelFor((Component)((Object)this.mTransformationXMLFileText));
        this.mTransformationXMLFileText.getDocument().addDocumentListener(textFieldListener);
        this.mTransformationXMLFileText.addFocusListener(this);
        this.mSavedMergedXMLFileText = new FileTextField();
        this.mSavedMergedXMLFileText.setColumns(45);
        this.mSavedMergedXMLFileLabel = DialogUtil.createLabel(this, "IDS_MERGE_XML_SAVED_MERGE_LABEL");
        this.mSavedMergedXMLFileLabel.setLabelFor((Component)((Object)this.mSavedMergedXMLFileText));
        this.mSavedMergedXMLFileText.getDocument().addDocumentListener(textFieldListener);
        this.mSavedMergedXMLFileText.addFocusListener(this);
        this.mModelBrowseButton = DialogUtil.createButton(this, "IDS_MERGE_XML_MODEL_BROWSE_BUTTON", this);
        this.mTransformationBrowseButton = DialogUtil.createButton(this, "IDS_MERGE_XML_TRANSFORMATION_BROWSE_BUTTON", this);
        this.mSavedMergedBrowseButton = DialogUtil.createButton(this, "IDS_MERGE_XML_SAVED_BROWSE_BUTTON", this);
    }

    private void setupMainPanel(JPanel jPanel) {
        Insets insets = (Insets)DialogUtil.getStandardDialogInsets().clone();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets2 = new Insets(0, n, n, n);
        int n2 = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mInfoTextArea, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.setupInputXMLFilesPanel(), gridBagConstraints, 0, 1, 2, 1, n2, new Insets(0, n, insets.bottom, n));
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mSavedMergedXMLFileLabel, gridBagConstraints, 0, 2, 1, 1, n2, insets2);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mSavedMergedXMLFileText), gridBagConstraints, 0, 3, 1, 1, n2, new Insets(0, n, insets.bottom, n));
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mSavedMergedBrowseButton, gridBagConstraints, 1, 3, 1, 1, n2, new Insets(0, n, insets.bottom, n));
    }

    private JPanel setupInputXMLFilesPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n, n, n);
        int n2 = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mModelXMLFileLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mModelXMLFileText), gridBagConstraints, 0, 1, 1, 1, n2, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mModelBrowseButton, gridBagConstraints, 1, 1, 1, 1, n2, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mTransformationXMLFileLabel, gridBagConstraints, 0, 2, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mTransformationXMLFileText), gridBagConstraints, 0, 3, 1, 1, n2, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mTransformationBrowseButton, gridBagConstraints, 1, 3, 1, 1, n2, insets);
        return OptionsUtil.setupControlOnBorder(jPanel, this.mInputGroupboxLabel);
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mModelXMLFileText);
        vector.add(this.mModelBrowseButton);
        vector.add(this.mTransformationXMLFileText);
        vector.add(this.mTransformationBrowseButton);
        vector.add(this.mSavedMergedXMLFileText);
        vector.add(this.mSavedMergedBrowseButton);
        vector.addAll(new Vector<Component>(Arrays.asList(this.getCmdButtonPanel().getComponents())));
        return vector;
    }

    private void setDefaults() {
        this.mModelXMLFileText.setText("");
        this.mTransformationXMLFileText.setText("");
        this.mSavedMergedXMLFileText.setText("");
        this.getOkButton().setEnabled(false);
        this.getPasteButton().setEnabled(false);
    }

    void enableUIItems() {
        boolean bl = this.mModelXMLFileText.getText().length() > 0 && this.mTransformationXMLFileText.getText().length() > 0 && this.mSavedMergedXMLFileText.getText().length() > 0;
        this.getOkButton().setEnabled(bl);
        this.getPasteButton().setEnabled(bl);
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    @Override
    public boolean okPastePressed() {
        boolean bl = true;
        if (!(this.validateFileField(this.mModelXMLFileText, true, false) && this.validateFileField(this.mTransformationXMLFileText, false, false) && this.validateFileField(this.mSavedMergedXMLFileText, false, true))) {
            bl = false;
        }
        return bl;
    }

    @Override
    protected boolean cancelPressed() {
        return true;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    private String getFileNameExt(String string) {
        String string2 = "";
        if (string.lastIndexOf(".") >= 0 && string.lastIndexOf(".") < string.length() - 1) {
            string2 = string.substring(string.lastIndexOf(".") + 1);
        }
        return string2;
    }

    private boolean validateFileField(FileTextField fileTextField, boolean bl, boolean bl2) {
        boolean bl3 = false;
        if (fileTextField != null && fileTextField.isEnabled()) {
            fileTextField.setText(fileTextField.getText().trim());
            if (fileTextField.getText().length() > 0) {
                ExtValidation extValidation;
                String string;
                if (!bl && ((string = this.getFileNameExt(fileTextField.getText())) == null || string.equals(""))) {
                    fileTextField.setText(fileTextField.getText() + ".xml");
                }
                if ((extValidation = this.validateFileExtension(fileTextField.getText(), bl)) != ExtValidation.ERROR) {
                    bl3 = this.validatePath(fileTextField.getText(), bl2);
                    if (bl3 && bl && extValidation == ExtValidation.EXT_ZIP && !(bl3 = this.validateZipfile(new File(fileTextField.getText())))) {
                        SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_MERGE_XML_ZIP_FILE_IS_NOT_SUPPORTED"), VersionInfo.getAppVersionString());
                    }
                } else if (bl2) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_MERGE_XML_INVALID_SAVE_FILE_PATH"), VersionInfo.getAppVersionString());
                } else {
                    string = String.format(CoreResUtil.getString((String)"ERR_FILE_NOT_FOUND_MESSAGE"), fileTextField.getText());
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string, VersionInfo.getAppVersionString());
                }
            }
        }
        if (fileTextField != null && !bl3) {
            fileTextField.requestFocusInWindow();
        }
        return bl3;
    }

    private ExtValidation validateFileExtension(String string, boolean bl) {
        ExtValidation extValidation = ExtValidation.ERROR;
        String string2 = this.getFileNameExt(string);
        if (string2 != null) {
            if (string2.equalsIgnoreCase("xml")) {
                extValidation = ExtValidation.EXT_XML;
            } else if (bl && string2.equalsIgnoreCase("zip")) {
                extValidation = ExtValidation.EXT_ZIP;
            }
        }
        return extValidation;
    }

    private boolean validatePath(String string, boolean bl) {
        boolean bl2;
        if (bl) {
            bl2 = FileValidator.validatePath((Component)((Object)this), string, true, true);
        } else {
            bl2 = FileValidator.validateOpenFile((Component)((Object)this), string, true, true);
            if (FileValidator.result() == 2) {
                bl2 = false;
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_MERGE_XML_INVALID_FILE_SPECIFICATION"), VersionInfo.getAppVersionString());
            }
        }
        return bl2;
    }

    private boolean validateZipfile(File file) {
        boolean bl = true;
        try {
            ZipFile zipFile = new ZipFile(file, 1);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            boolean bl2 = false;
            while (enumeration.hasMoreElements()) {
                if (bl2) {
                    bl = false;
                    break;
                }
                bl2 = true;
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory()) {
                    bl = false;
                    break;
                }
                if (zipEntry.getName().equalsIgnoreCase("file_no_key.xml")) continue;
                bl = false;
                break;
            }
            zipFile.close();
        }
        catch (IOException iOException) {
            bl = false;
            iOException.printStackTrace();
        }
        return bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mModelBrowseButton) {
            this.processBrowseButton(this.mModelXMLFileText, this.getResString("IDS_MERGE_XML_OR_ZIP_FILE_CHOOSE_TITLE"), false, FileLocationsUtil.getDataFilesDirectoryPath());
        } else if (object == this.mTransformationBrowseButton) {
            this.processBrowseButton(this.mTransformationXMLFileText, this.getResString("IDS_MERGE_XML_FILE_CHOOSE_TITLE"), false, FileLocationsUtil.getDataFilesDirectoryPath());
        } else if (object == this.mSavedMergedBrowseButton) {
            this.processBrowseButton(this.mSavedMergedXMLFileText, this.getResString("IDS_MERGE_XML_FILE_SAVE_TITLE"), true, FileLocationsUtil.getDataFilesDirectoryPath());
        }
    }

    private RemoteFileChooser processBrowseButton(FileTextField fileTextField, String string, boolean bl, String string2) {
        Serializable serializable;
        String string3 = fileTextField.getText().trim();
        if (string3.length() > 0) {
            serializable = new File(string3);
            if (!((File)serializable).isDirectory() && !((File)serializable).isFile()) {
                string3 = string2;
            }
        } else {
            string3 = string2;
        }
        serializable = string.equals(this.getResString("IDS_MERGE_XML_OR_ZIP_FILE_CHOOSE_TITLE")) ? this.showFileDialog(bl, this.getResString("IDS_MERGE_XML_OR_ZIP_FILE_EXTENSION"), this.getResString("IDS_MERGE_XML_OR_ZIP_FILE_FILTER"), string, string3, true) : this.showFileDialog(bl, this.getResString("IDS_MERGE_XML_FILE_EXTENSION"), this.getResString("IDS_MERGE_XML_FILE_FILTER"), string, string3, true);
        if (serializable != null) {
            int n;
            String string4 = ((RemoteFileChooser)serializable).getSelectedFilePath();
            String string5 = string4.toLowerCase();
            if (string.equals(this.getResString("IDS_MERGE_XML_FILE_CHOOSE_TITLE")) && ((n = string5.indexOf(this.getResString("IDS_MERGE_XML_FILE_EXTENSION"))) == -1 || string5.substring(n).compareToIgnoreCase(this.getResString("IDS_MERGE_XML_FILE_EXTENSION")) != 0)) {
                string4 = "." + string4.concat(this.getResString("IDS_MERGE_XML_FILE_EXTENSION"));
            }
            fileTextField.setText(string4);
        }
        return serializable;
    }

    private RemoteFileChooser showFileDialog(boolean bl, String string, String string2, String string3, String string4, boolean bl2) {
        RemoteFileChooser remoteFileChooser = bl ? new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, string4, true, false, true, bl2) : new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, string4, true, false, true, bl2);
        remoteFileChooser.setDialogTitle(string3);
        remoteFileChooser.setFileSelectionMode(0);
        RefFileFilter refFileFilter = string.contains(":") ? new RefFileFilter(string2, string, ":") : new RefFileFilter(string2, string);
        remoteFileChooser.addChoosableFileFilter((FileFilter)refFileFilter);
        if (bl) {
            remoteFileChooser.setAcceptAllFileFilterUsed(false);
            if (string4.trim().length() != 0) {
                remoteFileChooser.setCurrentDirectory((File)new RefFile(string4));
            }
        } else {
            remoteFileChooser.setAcceptAllFileFilterUsed(true);
        }
        remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
        int n = bl ? remoteFileChooser.showSaveDialog((Component)((Object)this)) : remoteFileChooser.showOpenDialog((Component)((Object)this));
        if (n == 0) {
            return remoteFileChooser;
        }
        return null;
    }

    private static enum ExtValidation {
        ERROR,
        EXT_XML,
        EXT_ZIP;

    }

    private class TextFieldListener
    implements DocumentListener {
        private TextFieldListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            MergeModelXMLDlg.this.enableUIItems();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            MergeModelXMLDlg.this.enableUIItems();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            MergeModelXMLDlg.this.enableUIItems();
        }
    }
}

