/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.direct_marketing;

import com.pasw.framework.common.data.DataModel;
import com.pasw.framework.common.data.Field;
import com.pasw.framework.common.data.RoleType;
import com.pasw.framework.common.data.StorageType;
import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.edit.OptionsUtil;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.direct_marketing.AbstractDialogStateWizardPage;
import com.spss.java_client.ui.dialogs.direct_marketing.ScoringWizardDlg;
import com.spss.java_client.ui.laf.SpssPlasticXPLookAndFeel;
import com.spss.uitools.controls.TypeAheadCombo;
import com.spss.uitools.util.IOptionConstants;
import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.text.Bidi;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class MatchDatasetFieldsToModelFieldsPage
extends AbstractDialogStateWizardPage
implements FocusListener {
    private static HashSet<RoleType> mValidModelInputRoles = new HashSet();
    public static final int DATASET_FIELDS_COL = 0;
    public static final int MODEL_FIELDS_COL = 1;
    public static final int ROLE_COL = 2;
    public static final int MEASURE_COL = 3;
    public static final int TYPE_COL = 4;
    private VarToFieldsTable mTable;
    private JScrollPane mTableScrollPane;
    private JRadioButton mUseValueSubstitutionRadio;
    private JRadioButton mUseSystemMissingRadio;
    private JLabel mModelNameLabel;
    private JLabel mModelTypeLabel;
    private boolean mInRender = false;
    private TableStringRenderer mTableStringRender = new TableStringRenderer();
    private DialogFocusTraversalPolicy mPolicy;
    public final VarCellRenderer mVarCellRenderer = new VarCellRenderer();
    private ScoringWizardDlg mParent;
    private ArrayList<String> mTableColNames;
    private VarToFieldsTableModel mVarToFieldsTableModel = null;
    private DatasetFieldsComboEditor mComboEditor = null;
    static boolean canMatch;
    MyTimer mTimer = new MyTimer();

    public MatchDatasetFieldsToModelFieldsPage(BaseWizardDialog baseWizardDialog) {
        super("MatchDatasetFieldsToModelFieldsPage", baseWizardDialog.getResString("IDS_SCORING_WIZARD_TITLE"), baseWizardDialog, true);
        this.mParent = (ScoringWizardDlg)baseWizardDialog;
        this.initTableColumnNames();
    }

    private void initTableColumnNames() {
        this.mTableColNames = new ArrayList();
        this.mTableColNames.add(this.mWizardDialog.getResString("IDS_SCORING_WIZARD_P2_TABLE_COL1_LABEL"));
        this.mTableColNames.add(this.mWizardDialog.getResString("IDS_SCORING_WIZARD_P2_TABLE_COL2_LABEL"));
        this.mTableColNames.add(this.mWizardDialog.getResString("IDS_SCORING_WIZARD_P2_TABLE_COL3_LABEL"));
        this.mTableColNames.add(this.mWizardDialog.getResString("IDS_SCORING_WIZARD_P2_TABLE_COL4_LABEL"));
        this.mTableColNames.add(this.mWizardDialog.getResString("IDS_SCORING_WIZARD_P2_TABLE_COL5_LABEL"));
    }

    @Override
    protected void loadDialogState() {
    }

    @Override
    protected void saveDialogState() {
    }

    @Override
    public void init() {
        JSeparator jSeparator;
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n2, n2, n2);
        JPanel jPanel = this.setupPageHeader();
        if (jPanel.getComponentCount() > 0) {
            DialogUtil.normalizeLabelWidths(jPanel);
            DialogUtil.addUsingGBL(this.mWizardPage, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
            gridBagConstraints.fill = 2;
            insets.top = n2;
            jSeparator = new JSeparator();
            DialogUtil.addUsingGBL(this.mWizardPage, jSeparator, gridBagConstraints, 0, 1, 1, 1, n, insets);
        }
        jPanel = this.setupPageBody();
        DialogUtil.normalizeLabelWidths(jPanel);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.mWizardPage, jPanel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets.top = n2;
        jSeparator = new JSeparator();
        DialogUtil.addUsingGBL(this.mWizardPage, jSeparator, gridBagConstraints, 0, 3, 1, 1, n, insets);
        this.setTabTraversalOrder();
    }

    private void initVars() {
        Vector<ISpssVariable> vector = this.mParent != null ? this.mParent.getVarsFromActiveDataset() : new Vector<ISpssVariable>();
        this.mVarToFieldsTableModel = new VarToFieldsTableModel(null, vector);
        this.mTable = new VarToFieldsTable(this.mVarToFieldsTableModel);
        this.mTable.setFocusable(true);
        this.mTable.setRowHeight(22);
        this.mTable.setColumnSelectionAllowed(true);
        this.mTable.setRowSelectionAllowed(true);
        this.mTable.setCellSelectionEnabled(true);
        this.mTable.getTableHeader().setReorderingAllowed(false);
        this.mTable.getTableHeader().setResizingAllowed(false);
        this.mTable.setGridColor(Color.darkGray);
        this.mTable.getTableHeader().setReorderingAllowed(false);
        this.mTableScrollPane = new JScrollPane(this.mTable);
        this.mTableScrollPane.setVerticalScrollBarPolicy(20);
        this.mTableScrollPane.setHorizontalScrollBarPolicy(31);
        this.mTableScrollPane.setMinimumSize(new Dimension(400, 200));
        this.mTableScrollPane.setPreferredSize(new Dimension(400, 200));
        JTableHeader jTableHeader = this.mTable.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.setDefaultRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = null;
                jLabel = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? (JLabel)super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                jLabel.setHorizontalAlignment(0);
                jLabel.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                jLabel.setBackground(jTable.getTableHeader().getBackground());
                jLabel.setForeground(jTable.getTableHeader().getForeground());
                jLabel.setFont(jTable.getTableHeader().getFont().deriveFont(1));
                return jLabel;
            }
        });
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_SCORING_WIZARD_P2_USE_VALUE_SUBSTITUTION_RADIO");
        this.mUseValueSubstitutionRadio = new JRadioButton(toggleButtonAction);
        spssButtonGroup.add(this.mUseValueSubstitutionRadio);
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_SCORING_WIZARD_P2_USE_SYSTEM_MISSING_RADIO");
        this.mUseSystemMissingRadio = new JRadioButton(toggleButtonAction);
        spssButtonGroup.add(this.mUseSystemMissingRadio);
        this.mUseValueSubstitutionRadio.setSelected(true);
        this.mTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
            }
        };
        this.mTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 0), "tabOut");
        this.mTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 1), "tabIn");
        this.mTable.getActionMap().put("tabIn", abstractAction2);
        this.mTable.getActionMap().put("tabOut", abstractAction);
    }

    private void setTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mTable);
        vector.add(this.mUseValueSubstitutionRadio);
        vector.add(this.mUseSystemMissingRadio);
        Vector<Object> vector2 = this.getScoringWizardDialog().addBaseWizardTabTraversal(vector);
        this.mPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    public boolean useSYSMIS() {
        return this.mUseSystemMissingRadio.isSelected();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_scoring_wizard_match_fields";
    }

    @Override
    public boolean validate() {
        boolean bl = true;
        return bl && super.validate();
    }

    @Override
    public String getNextPage() {
        return "SelectScoringValuesToIncludePage";
    }

    @Override
    public boolean isLastPage() {
        return false;
    }

    @Override
    public boolean hasNextPage() {
        return true;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    protected void aboutToShowPanel() {
        super.aboutToShowPanel();
        this.setupColumnWidths();
        this.mWizardDialog.setFocusTraversalPolicy(this.mPolicy);
        this.mTable.requestFocusInWindow();
        this.mTable.changeSelection(0, 0, false, false);
        this.setNextFinishButtonState();
    }

    @Override
    protected void aboutToHidePanel() {
        super.aboutToHidePanel();
    }

    protected boolean validateTab() {
        if (this.mTable.isEditing()) {
            this.mTable.getCellEditor().stopCellEditing();
        }
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.mTable.getModel();
        Vector<Vector> vector = defaultTableModel.getDataVector();
        int n = defaultTableModel.getRowCount();
        int n2 = 0;
        int n3 = -1;
        n2 = 0;
        if (n2 < n) {
            Vector vector2 = vector.get(n2);
            ISpssVariable iSpssVariable = (ISpssVariable)vector2.get(0);
            String string = "";
            return true;
        }
        return true;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
    }

    private JPanel setupPageHeader() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        return jPanel;
    }

    private JPanel setupPageBody() {
        double[] dArray = new double[]{-1.0};
        double[] dArray2 = new double[]{-2.0, -2.0, DialogUtil.getComponentGroupGap(), -2.0, -1.0, DialogUtil.getComponentGroupGap(), -2.0};
        TableLayout tableLayout = new TableLayout(dArray, dArray2);
        tableLayout.setHGap(5);
        tableLayout.setVGap(5);
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)tableLayout);
        String string = this.getScoringWizardDialog().getSelectModelPage().getModelName();
        String string2 = MessageFormat.format(this.mWizardDialog.getResString("IDS_SCORING_WIZARD_P2_MODEL_NAME_LABEL"), string);
        this.mModelNameLabel = new JLabel(string2);
        jPanel.add((Component)this.mModelNameLabel, "0, 0");
        string = this.getScoringWizardDialog().getDisplayTextForModelType(this.getScoringWizardDialog().getModelType());
        string2 = MessageFormat.format(this.mWizardDialog.getResString("IDS_SCORING_WIZARD_P2_MODEL_TYPE_LABEL"), string);
        this.mModelTypeLabel = new JLabel(string2);
        jPanel.add((Component)this.mModelTypeLabel, "0, 1");
        JLabel jLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_SCORING_WIZARD_P2_TABLE_LABEL");
        jLabel.setLabelFor(this.mTable);
        jPanel.add((Component)jLabel, "0, 3");
        jPanel.add((Component)this.mTableScrollPane, "0, 4");
        jPanel.add((Component)this.setupMissingValuesRadioGroup(), "0, 6, l, b");
        return jPanel;
    }

    private JPanel setupMissingValuesRadioGroup() {
        double[] dArray = new double[]{-2.0};
        double[] dArray2 = new double[]{-2.0, -2.0};
        TableLayout tableLayout = new TableLayout(dArray, dArray2);
        tableLayout.setHGap(5);
        tableLayout.setVGap(5);
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)tableLayout);
        jPanel.add((Component)this.mUseValueSubstitutionRadio, "0, 0");
        jPanel.add((Component)this.mUseSystemMissingRadio, "0, 1");
        JLabel jLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_SCORING_WIZARD_P2_MISSING_VALUES_RADIO_GROUP_LABEL");
        return OptionsUtil.setupControlOnBorder(jPanel, jLabel);
    }

    private VarToFieldsTableModel initTableModel() {
        Vector<ISpssVariable> vector = this.mParent != null ? this.mParent.getVarsFromActiveDataset() : new Vector<ISpssVariable>();
        this.mVarToFieldsTableModel = new VarToFieldsTableModel(this.mParent.getSelectModelPage().getInputDataModel(), vector);
        this.mTable.setModel(this.mVarToFieldsTableModel);
        this.mComboEditor = new DatasetFieldsComboEditor();
        this.mTable.getColumnModel().getColumn(0).setCellEditor(this.mComboEditor);
        this.mTable.getColumnModel().getColumn(0).setCellRenderer(this.mVarCellRenderer);
        this.mTable.getColumnModel().getColumn(1).setCellRenderer(this.mTableStringRender);
        this.mTable.getColumnModel().getColumn(2).setCellRenderer(this.mTableStringRender);
        this.mTable.getColumnModel().getColumn(3).setCellRenderer(this.mTableStringRender);
        this.mTable.getColumnModel().getColumn(4).setCellRenderer(this.mTableStringRender);
        return this.mVarToFieldsTableModel;
    }

    void processVariableSelection(int n, JComboBox jComboBox, ISpssVariable iSpssVariable) {
        Field field = this.getVarToFieldsTableModel().getFieldForRow(n);
        boolean bl = this.areEqualTypes(iSpssVariable, field);
        if (!bl) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mParent), this.mWizardDialog.getResString("IDS_VAR_FIELD_TYPE_MISMATCH"), "Title");
            ISpssVariable iSpssVariable2 = (ISpssVariable)this.mTable.getValueAt(n, 0);
            jComboBox.setSelectedItem(iSpssVariable2);
        } else if (iSpssVariable != null) {
            int n2 = this.getVarToFieldsTableModel().findVarInDataSetFieldsColumn(iSpssVariable, n);
            if (n2 != -1) {
                String string = MessageFormat.format(this.mWizardDialog.getResString("IDS_VARIABLE_ALREADY_ASSIGNED"), iSpssVariable.getName(), this.mTable.getModel().getValueAt(n2, 1));
                if (1 == SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mParent), string, "Title", SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.YES_NO_OPTION)) {
                    this.mTable.setValueAt(null, n2, 0);
                } else {
                    ISpssVariable iSpssVariable3 = (ISpssVariable)this.mTable.getValueAt(n, 0);
                    jComboBox.setSelectedItem(iSpssVariable3);
                }
            } else {
                this.mTable.setValueAt(iSpssVariable, n, 0);
            }
        } else {
            this.mTable.setValueAt(iSpssVariable, n, 0);
        }
        this.setNextFinishButtonState();
    }

    private void setupColumnWidths() {
        TableColumnModel tableColumnModel = this.mTable.getColumnModel();
        int n = this.mTable.getWidth();
        tableColumnModel.getColumn(0).setPreferredWidth((int)((double)n * 0.3));
        tableColumnModel.getColumn(1).setPreferredWidth((int)((double)n * 0.25));
        tableColumnModel.getColumn(2).setPreferredWidth((int)((double)n * 0.15));
        tableColumnModel.getColumn(3).setPreferredWidth((int)((double)n * 0.15));
        tableColumnModel.getColumn(4).setPreferredWidth((int)((double)n * 0.15));
    }

    public void updatePanel() {
        this.setModelNameLabel(this.getScoringWizardDialog().getSelectModelPage().getModelName());
        this.setModelTypeLabel(this.getScoringWizardDialog().getDisplayTextForModelType(this.getScoringWizardDialog().getModelType()));
        this.initTableModel();
        this.setNextFinishButtonState();
    }

    private ScoringWizardDlg getScoringWizardDialog() {
        return (ScoringWizardDlg)this.mWizardDialog;
    }

    private void setNextFinishButtonState() {
        boolean bl = this.isPageValidToContinue();
        this.mParent.enableNext(bl);
        this.mParent.enableFinish(this.mParent.canFinish());
    }

    public boolean isPageValidToContinue() {
        boolean bl = true;
        for (int i = 0; i < this.mTable.getModel().getRowCount(); ++i) {
            ISpssVariable iSpssVariable = this.getVarToFieldsTableModel().getUserSelectedFieldAt(i);
            if (iSpssVariable != null && !(iSpssVariable instanceof MySpssEmtpyVar)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private void setModelNameLabel(String string) {
        String string2 = MessageFormat.format(this.mWizardDialog.getResString("IDS_SCORING_WIZARD_P2_MODEL_NAME_LABEL"), string);
        if (ComponentState.isBtdRtlOrLtr() && string2 != null && string2.length() > 0) {
            this.mModelNameLabel.setText(ComponentState.prepareStringForBidiRendering((String)string2));
        } else {
            this.mModelNameLabel.setText(string2);
        }
    }

    private void setModelTypeLabel(String string) {
        String string2 = MessageFormat.format(this.mWizardDialog.getResString("IDS_SCORING_WIZARD_P2_MODEL_TYPE_LABEL"), string);
        if (ComponentState.isBtdRtlOrLtr() && string2 != null && string2.length() > 0) {
            this.mModelTypeLabel.setText(ComponentState.prepareStringForBidiRendering((String)string2));
        } else {
            this.mModelTypeLabel.setText(string2);
        }
    }

    public boolean isValidTableModel() {
        return this.getVarToFieldsTableModel().isValidModel();
    }

    public boolean areEqualTypes(ISpssVariable iSpssVariable, Field field) {
        boolean bl;
        boolean bl2 = bl = iSpssVariable == null || iSpssVariable instanceof MySpssEmtpyVar;
        if (iSpssVariable != null && field != null) {
            short s = iSpssVariable.getType();
            FormatType formatType = iSpssVariable.getFormat().getFormatType();
            StorageType storageType = field.getFieldStorage();
            if (s > 0) {
                bl = storageType == StorageType.string;
            } else if (storageType == StorageType.real || storageType == StorageType.integer) {
                bl = true;
            } else if (formatType.isDateOrTimeFormat()) {
                if ((formatType == FormatType.TIME || formatType == FormatType.MTIME || formatType == FormatType.DTIME) && storageType == StorageType.time) {
                    bl = true;
                }
                if ((formatType == FormatType.DATETIME || formatType == FormatType.YMDHMS) && storageType == StorageType.timestamp) {
                    bl = true;
                } else if (storageType == StorageType.date) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    private ISpssVariable findMatchingSpssVariable(Field field) {
        ISpssVariable iSpssVariable = null;
        for (ISpssVariable iSpssVariable2 : this.mParent.getVarsFromActiveDataset()) {
            if (iSpssVariable2 == null || field == null || !iSpssVariable2.getName().equals(field.getFieldName()) || !this.areEqualTypes(iSpssVariable2, field)) continue;
            iSpssVariable = iSpssVariable2;
            break;
        }
        return iSpssVariable;
    }

    protected VarToFieldsTableModel getVarToFieldsTableModel() {
        return (VarToFieldsTableModel)this.mTable.getModel();
    }

    public String getFieldNameFrom(int n, int n2) {
        if (n < 0 || n >= this.mTable.getRowCount() || n2 < 0 || n2 >= 2) {
            return "";
        }
        Object object = this.mTable.getValueAt(n, n2);
        if (object != null) {
            if (n2 == 0) {
                return ((ISpssVariable)object).getName();
            }
            return (String)object;
        }
        return "";
    }

    public int getNumberOfFields() {
        return this.mTable.getRowCount();
    }

    static {
        mValidModelInputRoles.add(RoleType.input);
        mValidModelInputRoles.add(RoleType.split);
        mValidModelInputRoles.add(RoleType.recordId);
        canMatch = false;
    }

    class MyTimer
    extends Timer {
        int mRow;
        JComboBox mComboBox;
        ISpssVariable mSpssVariable;

        MyTimer() {
            super(400, null);
            this.mRow = -1;
            this.mSpssVariable = null;
            this.addActionListener(new TimerActionListener());
        }

        public void processVariableSelection(int n, JComboBox jComboBox, ISpssVariable iSpssVariable) {
            this.mRow = n;
            this.mComboBox = jComboBox;
            this.mSpssVariable = iSpssVariable;
            this.restart();
        }

        class TimerActionListener
        implements ActionListener {
            TimerActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!MyTimer.this.mComboBox.isPopupVisible()) {
                            MatchDatasetFieldsToModelFieldsPage.this.processVariableSelection(MyTimer.this.mRow, MyTimer.this.mComboBox, MyTimer.this.mSpssVariable);
                        } else {
                            MyTimer.this.restart();
                        }
                    }
                });
                MyTimer.this.stop();
            }
        }
    }

    private class VarToFieldsTableModel
    extends DefaultTableModel {
        private ISpssVariable[] mUserSelectedFields;
        private ArrayList<Field> mFields = new ArrayList();
        private ArrayList<ISpssVariable> canVarMatchFieldList = new ArrayList();
        boolean mShowVarLabels = false;

        public VarToFieldsTableModel(DataModel dataModel, Vector<ISpssVariable> vector) {
            this.mFields = this.getFieldsWithSupportedRoles(dataModel);
            this.initDatasetFieldsColumn();
            this.initVarsThatCanMatchAField(vector);
            this.readDisplayPrefs();
        }

        private ArrayList<Field> getFieldsWithSupportedRoles(DataModel dataModel) {
            ArrayList<Field> arrayList = new ArrayList<Field>();
            if (dataModel != null) {
                for (int i = 0; i < dataModel.getFieldCount(); ++i) {
                    Field field = dataModel.getField(dataModel.getFieldName(i));
                    if (!mValidModelInputRoles.contains(field.getFieldRole())) continue;
                    arrayList.add(field);
                }
            }
            return arrayList;
        }

        public boolean canVarMapToAField(ISpssVariable iSpssVariable) {
            return this.canVarMatchFieldList.contains(iSpssVariable);
        }

        private void initVarsThatCanMatchAField(Vector<ISpssVariable> vector) {
            this.canVarMatchFieldList = new ArrayList();
            if (this.mFields != null) {
                block0: for (ISpssVariable iSpssVariable : vector) {
                    if (iSpssVariable == null) continue;
                    for (int i = 0; i < this.mFields.size(); ++i) {
                        Field field = this.mFields.get(i);
                        if (!MatchDatasetFieldsToModelFieldsPage.this.areEqualTypes(iSpssVariable, field)) continue;
                        this.canVarMatchFieldList.add(iSpssVariable);
                        continue block0;
                    }
                }
            }
        }

        private void initDatasetFieldsColumn() {
            if (this.mFields != null) {
                this.mUserSelectedFields = new ISpssVariable[this.mFields.size()];
                for (int i = 0; i < this.mFields.size(); ++i) {
                    ISpssVariable iSpssVariable;
                    Field field = this.mFields.get(i);
                    this.mUserSelectedFields[i] = iSpssVariable = MatchDatasetFieldsToModelFieldsPage.this.findMatchingSpssVariable(field);
                }
            }
        }

        public int findVarInDataSetFieldsColumn(ISpssVariable iSpssVariable) {
            return this.findVarInDataSetFieldsColumn(iSpssVariable, -1);
        }

        public int findVarInDataSetFieldsColumn(ISpssVariable iSpssVariable, int n) {
            int n2 = -1;
            for (int i = 0; i < this.mUserSelectedFields.length; ++i) {
                if (i == n || this.mUserSelectedFields[i] != iSpssVariable) continue;
                n2 = i;
                break;
            }
            return n2;
        }

        @Override
        public int getColumnCount() {
            return MatchDatasetFieldsToModelFieldsPage.this.mTableColNames != null ? MatchDatasetFieldsToModelFieldsPage.this.mTableColNames.size() : 0;
        }

        @Override
        public int getRowCount() {
            return this.mFields != null ? this.mFields.size() : 0;
        }

        @Override
        public String getColumnName(int n) {
            return (String)MatchDatasetFieldsToModelFieldsPage.this.mTableColNames.get(n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            switch (n2) {
                case 0: {
                    return true;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return false;
                }
            }
            return false;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                this.mUserSelectedFields[n] = (ISpssVariable)object;
                this.fireTableCellUpdated(n, n2);
            }
        }

        public ISpssVariable getUserSelectedFieldAt(int n) {
            return this.mUserSelectedFields[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Object object = "";
            if (this.mFields != null) {
                switch (n2) {
                    case 0: {
                        object = this.getUserSelectedFieldAt(n);
                        break;
                    }
                    case 1: {
                        object = this.mFields.get(n).getFieldName();
                        break;
                    }
                    case 2: {
                        Field field = this.getFieldForRow(n);
                        object = MatchDatasetFieldsToModelFieldsPage.this.getScoringWizardDialog().getDisplayTextForRoleType(field.getFieldRole());
                        break;
                    }
                    case 3: {
                        Field field = this.getFieldForRow(n);
                        object = MatchDatasetFieldsToModelFieldsPage.this.getScoringWizardDialog().getDisplayTextForMeasureType(field.getFieldMeasurement());
                        break;
                    }
                    case 4: {
                        Field field = this.getFieldForRow(n);
                        object = MatchDatasetFieldsToModelFieldsPage.this.getScoringWizardDialog().getDisplayTextForScoringType(field.getFieldStorage());
                        break;
                    }
                    default: {
                        object = super.getValueAt(n, n2);
                    }
                }
            }
            return object;
        }

        private Field getFieldForRow(int n) {
            return this.mFields.get(n);
        }

        private void readDisplayPrefs() {
            Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
            Preferences preferences2 = preferences.node("options");
            Preferences preferences3 = preferences2.node("general");
            this.mShowVarLabels = preferences3.get("var_list_display", PrefDefaults.DEF_VAR_LIST_DISPLAY_LABELS).equals(IOptionConstants.VAR_LIST_DISPLAY_VALUES[0]);
        }

        public boolean isShowLabels() {
            return this.mShowVarLabels;
        }

        public boolean isValidModel() {
            boolean bl = true;
            if (this.mFields == null) {
                bl = false;
            } else {
                for (int i = 0; i < this.mFields.size(); ++i) {
                    Field field = this.mFields.get(i);
                    if (field != null) {
                        if (field.getFieldRole() != null && field.getFieldMeasurement() != null) continue;
                        bl = false;
                        break;
                    }
                    bl = false;
                    break;
                }
            }
            return bl;
        }
    }

    private class VarToFieldsTable
    extends JTable {
        public VarToFieldsTable(VarToFieldsTableModel varToFieldsTableModel) {
            super(varToFieldsTableModel);
        }

        @Override
        public boolean editCellAt(int n, int n2, EventObject eventObject) {
            if (!super.editCellAt(n, n2, eventObject)) {
                return false;
            }
            Component component = this.getEditorComponent();
            component.requestFocus();
            if (component.getClass() == JComboBox.class) {
                final ComboBoxEditor comboBoxEditor = ((JComboBox)component).getEditor();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((JTextField)comboBoxEditor.getEditorComponent()).selectAll();
                    }
                });
            }
            return true;
        }
    }

    class DatasetFieldsComboEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private TypeAheadCombo mCombo = new TypeAheadCombo();

        DatasetFieldsComboEditor() {
            this.mCombo.addItem((Object)new MySpssEmtpyVar());
            for (ISpssVariable iSpssVariable : MatchDatasetFieldsToModelFieldsPage.this.mParent.getVarsFromActiveDataset()) {
                this.mCombo.addItem((Object)iSpssVariable);
            }
            this.mCombo.addActionListener((ActionListener)new ComboActionListener());
            this.mCombo.setEditable(false);
            this.mCombo.setRenderer((ListCellRenderer)MatchDatasetFieldsToModelFieldsPage.this.mVarCellRenderer);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object != null && object.toString().length() == 0) {
                object = null;
            }
            MatchDatasetFieldsToModelFieldsPage.this.mInRender = true;
            this.mCombo.setSelectedItem(object);
            MatchDatasetFieldsToModelFieldsPage.this.mInRender = false;
            return this.mCombo;
        }

        @Override
        public Object getCellEditorValue() {
            return this.mCombo.getSelectedItem();
        }
    }

    class MySpssEmtpyVar
    extends SpssVariable {
        public MySpssEmtpyVar() {
            this.setName("            ");
            this.setLabel("         ");
        }
    }

    class ComboActionListener
    implements ActionListener {
        ComboActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!MatchDatasetFieldsToModelFieldsPage.this.mInRender) {
                int n = MatchDatasetFieldsToModelFieldsPage.this.mTable.getEditingRow();
                ISpssVariable iSpssVariable = (ISpssVariable)((TypeAheadCombo)actionEvent.getSource()).getSelectedItem();
                MatchDatasetFieldsToModelFieldsPage.this.mTimer.processVariableSelection(n, (JComboBox)actionEvent.getSource(), iSpssVariable);
            }
        }

        private VarToFieldsTableModel getVarToFieldsTableModel() {
            return (VarToFieldsTableModel)MatchDatasetFieldsToModelFieldsPage.this.mTable.getModel();
        }
    }

    class VarCellRenderer
    extends JLabel
    implements ListCellRenderer,
    TableCellRenderer {
        VarCellRenderer() {
        }

        private void prepRendererComponent(Component component, Object object, boolean bl, boolean bl2) {
            boolean bl3 = object instanceof ISpssVariable;
            boolean bl4 = MatchDatasetFieldsToModelFieldsPage.this.mVarToFieldsTableModel.isShowLabels();
            boolean bl5 = false;
            ISpssVariable iSpssVariable = object != null ? (ISpssVariable)object : null;
            Icon icon = iSpssVariable != null ? this.getIcon((ISpssVariable)object) : null;
            this.setIcon(icon);
            String string = iSpssVariable != null && !(iSpssVariable instanceof MySpssEmtpyVar) ? iSpssVariable.getName() : "   ";
            this.setText(string);
            if (iSpssVariable != null && iSpssVariable.getId().isNull() && CommandLine.isClementineCaller() && !DialogDataModel.isSpecialVariable(iSpssVariable)) {
                bl5 = true;
            }
            if (UIManager.getLookAndFeel() instanceof SpssPlasticXPLookAndFeel) {
                component.setBackground(Color.white);
            }
            this.setOpaque(true);
            Color color = this.getForegroundColor(component, iSpssVariable, bl);
            Color color2 = this.getBackgroundColor(component, iSpssVariable, bl);
            this.setForeground(color);
            this.setBackground(color2);
            Border border = null;
            if (bl2) {
                String string2 = component.getClass().getCanonicalName();
                if (string2 == null) {
                    string2 = component.getName();
                }
                String string3 = string2 != null && string2.toLowerCase().endsWith(".list") ? "List" : "Table";
                if (bl) {
                    border = UIManager.getBorder(string3 + ".focusSelectedCellHighlightBorder");
                }
                if (border == null) {
                    border = UIManager.getBorder(string3 + ".focusCellHighlightBorder");
                }
            } else {
                border = new EmptyBorder(1, 1, 1, 1);
            }
            this.setBorder(border);
            this.setEnabled(component.isEnabled());
            this.setFont(component.getFont());
        }

        private Color getForegroundColor(Component component, ISpssVariable iSpssVariable, boolean bl) {
            Color color = component.getForeground();
            if (iSpssVariable == null || !MatchDatasetFieldsToModelFieldsPage.this.mVarToFieldsTableModel.canVarMapToAField(iSpssVariable)) {
                color = UIManager.getColor("Label.disabledForeground");
            } else if (bl) {
                if (component instanceof JTable) {
                    color = ((JTable)component).getSelectionForeground();
                } else if (component instanceof JList) {
                    color = ((JList)component).getSelectionForeground();
                }
            }
            return color;
        }

        private Color getBackgroundColor(Component component, ISpssVariable iSpssVariable, boolean bl) {
            Color color = component.getBackground();
            if (bl) {
                if (component instanceof JTable) {
                    color = ((JTable)component).getSelectionBackground();
                } else if (component instanceof JList) {
                    color = ((JList)component).getSelectionBackground();
                }
            } else if (iSpssVariable == null || !MatchDatasetFieldsToModelFieldsPage.this.mVarToFieldsTableModel.canVarMapToAField(iSpssVariable)) {
                color = UIManager.getColor("Label.disabledBackground");
            }
            return color;
        }

        public Icon getIcon(ISpssVariable iSpssVariable) {
            Icon icon = null;
            if (iSpssVariable != null && !(iSpssVariable instanceof MySpssEmtpyVar)) {
                icon = iSpssVariable != null ? iSpssVariable.getCustomIcon() : null;
                icon = icon != null ? icon : VariableList.getStandardIcon(iSpssVariable);
            }
            return icon;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.prepRendererComponent(jList, object, bl, bl2);
            return this;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.prepRendererComponent(jTable, object, bl, bl2);
            return this;
        }

        @Override
        public void setText(String string) {
            String string2 = string;
            if (string2 != null && string2.length() > 0 && string2.trim().length() > 0) {
                string2 = ComponentState.getBTD() == 1 && !new Bidi(Character.toString(string.charAt(0)), 1).isRightToLeft() ? '\u200f' + string : (ComponentState.getBTD() == 2 && new Bidi(Character.toString(string.charAt(0)), 1).isRightToLeft() ? '\u200e' + string : string);
            }
            super.setText(string2);
        }

        @Override
        public void setToolTipText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setToolTipText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setToolTipText(string);
            }
        }
    }

    class TableStringRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0) {
                super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2);
            } else {
                super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
            if (n2 != 0) {
                this.setForeground(Color.black);
                this.setOpaque(true);
            }
            this.setToolTipText(MatchDatasetFieldsToModelFieldsPage.this.mWizardDialog.getResString("IDS_MI_IMPUTE_MISSING_CONSTRAINTS_SUMMARY_TOOLTIP_TEXT"));
            return this;
        }

        @Override
        public void setText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setText(string);
            }
        }

        @Override
        public void setToolTipText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setToolTipText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setToolTipText(string);
            }
        }
    }
}

