/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.direct_marketing;

import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssMultiLineLabel;
import com.spss.java_client.ui.dialogs.base.graphs.IMatrixListener;
import com.spss.java_client.ui.dialogs.base.graphs.ImageLabelKeyListenerEx;
import com.spss.java_client.ui.dialogs.base.graphs.MatrixImageEx;
import com.spss.java_client.ui.dialogs.base.graphs.MatrixImagesGroupEx;
import com.spss.java_client.ui.dialogs.common.BaseGatingDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.MeasureLevelAlertDlg;
import com.spss.java_client.ui.dialogs.direct_marketing.res.DirectMarketingResBundle;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.util.AccessibilityUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class DirectMarketingGatingDialog
extends BaseGatingDialog
implements IMatrixListener {
    private MatrixImagesGroupEx mControlChartsImageGroup;
    private MatrixImageEx mRFMAnalysisImage;
    private JLabel mRFMAnalysisLabel;
    private MatrixImageEx mSegmentContactImage;
    private JLabel mSegmentContactLabel;
    private MatrixImageEx mProfileImage;
    private JLabel mProfileLabel;
    private MatrixImageEx mTopPostalCodeImage;
    private JLabel mPostalCodeLabel;
    private MatrixImageEx mPurchaseImage;
    private JLabel mPurchaseLabel;
    private MatrixImageEx mScoringImage;
    private JLabel mScoringLabel;
    private MatrixImageEx mControlPackageImage;
    private JLabel mControlPackageLabel;
    private JSeparator mSeparator;
    private static final Border DASH_BORDER = new DashBorder();
    private static final Border WHITE_BORDER = BorderFactory.createLineBorder(Color.WHITE, 4);
    private static final Border SELECT_BORDER = BorderFactory.createLineBorder(Color.LIGHT_GRAY, 4);

    public DirectMarketingGatingDialog(JFrame jFrame) throws HeadlessException {
        super(jFrame, DirectMarketingResBundle.getDefaultResourceBundleName(), DirectMarketingResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_DIRECT_MARETING_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_direct_marketing_gating";
    }

    @Override
    public String getIActionKey() {
        return "application_direct_marketing";
    }

    @Override
    public boolean continuePressed() {
        return true;
    }

    @Override
    public String getNextProcDlgActionKey() {
        String string = null;
        boolean bl = false;
        int n = 0;
        if (this.mRFMAnalysisImage.isSelected()) {
            string = "application_direct_marketing_rfm_data_format";
        } else if (this.mSegmentContactImage.isSelected()) {
            string = "cluster_analysis";
            bl = true;
            n = 0;
        } else if (this.mProfileImage.isSelected()) {
            string = "prospect_profiles";
            bl = true;
            n = 1;
        } else if (this.mTopPostalCodeImage.isSelected()) {
            string = "postal_code_resp";
            bl = true;
            n = 2;
        } else if (this.mPurchaseImage.isSelected()) {
            string = "propensity_to_purchase";
            bl = true;
            n = 3;
        } else if (this.mControlPackageImage.isSelected()) {
            string = "ctrl_pkg_test";
            bl = true;
            n = 4;
        } else if (this.mScoringImage.isSelected()) {
            string = "utilities_scoring_wizard";
            bl = false;
        }
        if (n == 2 || n == 4) {
            return string;
        }
        if (bl && DialogUtil.needMeasureLevelAlertDlg()) {
            MeasureLevelAlertDlg measureLevelAlertDlg = new MeasureLevelAlertDlg((JFrame)this.getParent());
            measureLevelAlertDlg.setVisible(true);
            if (!measureLevelAlertDlg.isScanDataButtonPressed()) {
                string = "";
            }
        }
        return string;
    }

    @Override
    public void loadDialogState() {
        super.loadDialogState();
    }

    @Override
    public void saveDialogState() {
        super.saveDialogState();
    }

    @Override
    public void matrixImageEvent(IMatrixListener.EventType eventType, int n) {
        if (eventType == IMatrixListener.EventType.doubleClick) {
            this.mContinueAction.actionPerformed(new ActionEvent(this, 1, "launch"));
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        int n2 = 10;
        int n3 = DialogUtil.getGroupBoxInnerMargin() + 2;
        Insets insets = new Insets(1, n3, 1, n3);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_DIRECT_MARETING_DESCRIPTION");
        JPanel jPanel2 = PanelFactory.getEmptyPanel("");
        DialogUtil.addUsingGBL(jPanel2, this.mRFMAnalysisImage, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel2, this.mRFMAnalysisLabel, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel2, this.mSegmentContactImage, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel2, this.mSegmentContactLabel, gridBagConstraints, 1, 1, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel2, this.mProfileImage, gridBagConstraints, 2, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel2, this.mProfileLabel, gridBagConstraints, 2, 1, 1, 1, n2, insets);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_DIRECT_MARETING_SUB_TITLE1");
        Font font = jLabel2.getFont();
        int n4 = (int)((double)font.getSize() * 1.5);
        jLabel2.setFont(new Font(font.getName(), font.getStyle(), n4));
        jLabel2.setLabelFor(jPanel2);
        JPanel jPanel3 = PanelFactory.getEmptyPanel("");
        DialogUtil.addUsingGBL(jPanel3, this.mTopPostalCodeImage, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel3, this.mPostalCodeLabel, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel3, this.mPurchaseImage, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel3, this.mPurchaseLabel, gridBagConstraints, 1, 1, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel3, this.mControlPackageImage, gridBagConstraints, 2, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel3, this.mControlPackageLabel, gridBagConstraints, 2, 1, 1, 1, n2, insets);
        JLabel jLabel3 = DialogUtil.createLabel(this, "IDS_DIRECT_MARETING_SUB_TITLE2");
        jLabel3.setFont(new Font(font.getName(), font.getStyle(), n4));
        jLabel3.setLabelFor(jPanel3);
        JPanel jPanel4 = PanelFactory.getEmptyPanel("");
        DialogUtil.addUsingGBL(jPanel4, this.mScoringImage, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel4, this.mScoringLabel, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        JLabel jLabel4 = DialogUtil.createLabel(this, "IDS_DIRECT_MARKETING_SUB_TITLE3");
        jLabel4.setFont(new Font(font.getName(), font.getStyle(), n4));
        jLabel4.setLabelFor(jPanel4);
        insets.set(n3, 0, n3, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, 10, insets);
        insets.set(n3, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets.set(0, 0, n3, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        insets.set(0, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mSeparator, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 1.0;
        insets.set(n3, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 0, 4, 1, 1, n, insets);
        insets.set(0, 0, n3, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 5, 1, 1, n, insets);
        insets.set(0, 0, 0, 0);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, new JSeparator(), gridBagConstraints, 0, 6, 1, 1, n, insets);
        insets.set(n3, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel4, gridBagConstraints, 0, 7, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        insets.set(0, 0, n3, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 8, 1, 1, n, insets);
        this.setTabPolicy();
        this.pack();
    }

    private void initVars() {
        this.mControlChartsImageGroup = new MatrixImagesGroupEx();
        this.mRFMAnalysisImage = new MatrixImageEx(this.getResImageURL("IDS_DIRECT_MARETING_RFM_ANALYSIS_IMAGE"));
        int n = this.mRFMAnalysisImage.getIcon().getIconWidth() * 2 + 10;
        this.mRFMAnalysisLabel = DialogUtil.createMultiLineLabel(this, "IDS_DIRECT_MARETING_RFM_ANALYSIS_LABEL", n);
        this.mRFMAnalysisLabel.setLabelFor(this.mRFMAnalysisImage);
        this.mSegmentContactImage = new MatrixImageEx(this.getResImageURL("IDS_DIRECT_MARETING_SEGMENT_CONTACT_IMAGE"));
        this.mSegmentContactLabel = DialogUtil.createMultiLineLabel(this, "IDS_DIRECT_MARETING_SEGMENT_CONTACT_LABEL", n);
        this.mSegmentContactLabel.setLabelFor(this.mSegmentContactImage);
        this.mProfileImage = new MatrixImageEx(this.getResImageURL("IDS_DIRECT_MARETING_PROFILE_IMAGE"));
        this.mProfileLabel = DialogUtil.createMultiLineLabel(this, "IDS_DIRECT_MARETING_PROFILE_LABEL", n);
        this.mProfileLabel.setLabelFor(this.mProfileImage);
        this.mTopPostalCodeImage = new MatrixImageEx(this.getResImageURL("IDS_DIRECT_MARETING_POSTAL_CODE_IMAGE"));
        this.mPostalCodeLabel = DialogUtil.createMultiLineLabel(this, "IDS_DIRECT_MARETING_POSTAL_CODE_LABEL", n);
        this.mPostalCodeLabel.setLabelFor(this.mTopPostalCodeImage);
        this.mPurchaseImage = new MatrixImageEx(this.getResImageURL("IDS_DIRECT_MARETING_PURCHASE_IMAGE"));
        this.mPurchaseLabel = DialogUtil.createMultiLineLabel(this, "IDS_DIRECT_MARETING_PURCHASE_LABEL", n);
        this.mPurchaseLabel.setLabelFor(this.mPurchaseImage);
        this.mControlPackageImage = new MatrixImageEx(this.getResImageURL("IDS_DIRECT_MARETING_CONTROL_PACKAGE_IMAGE"));
        this.mControlPackageLabel = DialogUtil.createMultiLineLabel(this, "IDS_DIRECT_MARETING_CONTROL_PACKAGE_LABEL", n);
        this.mControlPackageLabel.setLabelFor(this.mControlPackageImage);
        this.mScoringImage = new MatrixImageEx(this.getResImageURL("IDS_DIRECT_MARETING_SCORING_IMAGE"));
        this.mScoringLabel = DialogUtil.createMultiLineLabel(this, "IDS_DIRECT_MARETING_SCORING_LABEL", n);
        this.mScoringLabel.setLabelFor(this.mScoringImage);
        Vector<MatrixImageEx> vector = new Vector<MatrixImageEx>();
        vector.add(this.mRFMAnalysisImage);
        vector.add(this.mSegmentContactImage);
        vector.add(this.mProfileImage);
        vector.add(this.mTopPostalCodeImage);
        vector.add(this.mPurchaseImage);
        vector.add(this.mControlPackageImage);
        vector.add(this.mScoringImage);
        this.mControlChartsImageGroup.addMatrixImages(vector);
        this.mSeparator = new JSeparator();
        this.mRFMAnalysisImage.addMatrixListener(this);
        this.mSegmentContactImage.addMatrixListener(this);
        this.mProfileImage.addMatrixListener(this);
        this.mTopPostalCodeImage.addMatrixListener(this);
        this.mPurchaseImage.addMatrixListener(this);
        this.mControlPackageImage.addMatrixListener(this);
        this.mScoringImage.addMatrixListener(this);
    }

    private void addMouseListener(MatrixImageEx matrixImageEx, Vector<MatrixImageEx> vector) {
        matrixImageEx.setBorder(WHITE_BORDER);
        MouseListener[] mouseListenerArray = matrixImageEx.getMouseListeners();
        EventListener[] eventListenerArray = mouseListenerArray;
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            MouseListener mouseListener = eventListenerArray[i];
            matrixImageEx.removeMouseListener(mouseListener);
        }
        matrixImageEx.addMouseListener(new DMImageMouseListener(matrixImageEx));
        for (EventListener eventListener : eventListenerArray = matrixImageEx.getFocusListeners()) {
            matrixImageEx.removeFocusListener((FocusListener)eventListener);
        }
        matrixImageEx.addFocusListener(new DMImageFocusListener(matrixImageEx));
        matrixImageEx.addKeyListener(new ImageLabelKeyListenerEx(vector, this.mControlChartsImageGroup));
    }

    private void setTabPolicy() {
        Vector<Object> vector = new Vector<Object>();
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            vector.add(this.mControlChartsImageGroup);
            vector.add(this.mDefineButton);
            vector.add(this.mHelpButton);
            vector.add(this.mCancelButton);
        } else {
            vector.add(this.mDefineButton);
            vector.add(this.mCancelButton);
            vector.add(this.mHelpButton);
            vector.add(this.mControlChartsImageGroup);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setDefaults() {
        this.mRFMAnalysisImage.setDefaultSelectedImage(true);
        AccessibilityUtil.setAccessibleDescription((Component)this.mRFMAnalysisImage, (Object)(this.getResString("IDS_DIRECT_MARETING_SUB_TITLE1") + " " + ((SpssMultiLineLabel)this.mRFMAnalysisLabel).getLabelText() + "selected. use arrow keys to change selection."));
        this.mSegmentContactImage.setDefaultSelectedImage(false);
        AccessibilityUtil.setAccessibleDescription((Component)this.mSegmentContactImage, (Object)(this.getResString("IDS_DIRECT_MARETING_SUB_TITLE1") + " " + ((SpssMultiLineLabel)this.mSegmentContactLabel).getLabelText()));
        this.mProfileImage.setDefaultSelectedImage(false);
        String string = this.mProfileLabel instanceof SpssMultiLineLabel ? ((SpssMultiLineLabel)this.mProfileLabel).getLabelText() : this.mProfileLabel.getText();
        AccessibilityUtil.setAccessibleDescription((Component)this.mProfileImage, (Object)(this.getResString("IDS_DIRECT_MARETING_SUB_TITLE1") + " " + string));
        this.mTopPostalCodeImage.setDefaultSelectedImage(false);
        AccessibilityUtil.setAccessibleDescription((Component)this.mTopPostalCodeImage, (Object)(this.getResString("IDS_DIRECT_MARETING_SUB_TITLE2") + " " + ((SpssMultiLineLabel)this.mPostalCodeLabel).getLabelText()));
        this.mPurchaseImage.setDefaultSelectedImage(false);
        AccessibilityUtil.setAccessibleDescription((Component)this.mPurchaseImage, (Object)(this.getResString("IDS_DIRECT_MARETING_SUB_TITLE2") + " " + ((SpssMultiLineLabel)this.mPurchaseLabel).getLabelText()));
        this.mControlPackageImage.setDefaultSelectedImage(false);
        AccessibilityUtil.setAccessibleDescription((Component)this.mControlPackageImage, (Object)(this.getResString("IDS_DIRECT_MARETING_SUB_TITLE2") + " " + ((SpssMultiLineLabel)this.mControlPackageLabel).getLabelText()));
        this.mScoringImage.setDefaultSelectedImage(false);
        AccessibilityUtil.setAccessibleDescription((Component)this.mScoringImage, (Object)(this.getResString("IDS_DIRECT_MARKETING_SUB_TITLE3") + " " + ((SpssMultiLineLabel)this.mScoringLabel).getLabelText()));
    }

    static class DashBorder
    extends EmptyBorder {
        private BasicStroke mStroke = null;

        public DashBorder() {
            super(1, 1, 1, 1);
            float[] fArray = new float[]{4.0f, 4.0f, 4.0f, 4.0f};
            this.mStroke = new BasicStroke(1.0f, 1, 1, 0.0f, fArray, 0.0f);
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (graphics instanceof Graphics2D) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Color color = graphics2D.getColor();
                Stroke stroke = graphics2D.getStroke();
                graphics2D.setColor(SystemColor.black);
                graphics2D.setStroke(this.mStroke);
                graphics2D.drawRect(n, n2, n3 - 1, n4 - 1);
                graphics2D.setStroke(stroke);
                graphics2D.setColor(color);
            }
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }

    class DMImageFocusListener
    extends FocusAdapter {
        private MatrixImageEx mImage;

        public DMImageFocusListener(MatrixImageEx matrixImageEx) {
            this.mImage = matrixImageEx;
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            Border border = BorderFactory.createLineBorder(Color.WHITE, 3);
            this.mImage.getImagesGroup().getSelectedMatrixImage().setBorder(BorderFactory.createCompoundBorder(DASH_BORDER, border));
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.mImage.getImagesGroup().getSelectedMatrixImage().setBorder(WHITE_BORDER);
        }
    }

    class DMImageMouseListener
    extends MouseAdapter {
        private MatrixImageEx mImage;

        public DMImageMouseListener(MatrixImageEx matrixImageEx) {
            this.mImage = matrixImageEx;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            MatrixImageEx matrixImageEx = (MatrixImageEx)mouseEvent.getSource();
            matrixImageEx.setSelected(true);
            Border border = BorderFactory.createLineBorder(Color.BLACK, 2);
            Border border2 = BorderFactory.createLineBorder(Color.WHITE, 2);
            matrixImageEx.setBorder(BorderFactory.createCompoundBorder(border, border2));
            matrixImageEx.requestFocusInWindow();
            if (!mouseEvent.isPopupTrigger() && mouseEvent.getClickCount() > 1) {
                this.mImage.fireMatrixEvent(IMatrixListener.EventType.doubleClick, this.mImage.getImagesGroup().getMatrixImageIndex(this.mImage));
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            MatrixImageEx matrixImageEx = (MatrixImageEx)mouseEvent.getSource();
            matrixImageEx.requestFocusInWindow();
            matrixImageEx.setBorder(SELECT_BORDER);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            MatrixImageEx matrixImageEx = (MatrixImageEx)mouseEvent.getSource();
            matrixImageEx.setBorder(WHITE_BORDER);
        }
    }
}

