/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.ctables.undo;

import com.spss.java_client.ui.dialogs.ctables.AssignVarsTab;
import com.spss.uitools.canvas.tables.CanvasState;
import com.spss.uitools.res.UIToolResUtil;
import javax.swing.JCheckBox;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class StatVisibilityEdit
extends AbstractUndoableEdit {
    private AssignVarsTab mAssignVarsTab;
    private JCheckBox mHideStatCheck;
    private boolean mOldStatHide;
    private boolean mNewStatHide;
    private CanvasState mCanvasState;

    public StatVisibilityEdit(UndoManager undoManager, AssignVarsTab assignVarsTab, CanvasState canvasState, JCheckBox jCheckBox) {
        this.mAssignVarsTab = assignVarsTab;
        this.mOldStatHide = canvasState.getStatsHidden();
        this.mNewStatHide = jCheckBox.isSelected();
        this.mCanvasState = canvasState;
        this.mHideStatCheck = jCheckBox;
        this.mCanvasState.setStatsHidden(this.mNewStatHide);
        this.mAssignVarsTab.updateLowerControls();
        undoManager.addEdit(this);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.doAction(this.mOldStatHide);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.doAction(this.mNewStatHide);
    }

    @Override
    public String getPresentationName() {
        return UIToolResUtil.getString((String)"IDS_CANVASMENU_UNDO_VIS");
    }

    @Override
    public void die() {
        super.die();
        this.mAssignVarsTab = null;
        this.mHideStatCheck = null;
        this.mCanvasState = null;
    }

    private void doAction(boolean bl) {
        this.mCanvasState.setStatsHidden(bl);
        this.mHideStatCheck.removeItemListener(this.mAssignVarsTab);
        this.mHideStatCheck.setSelected(bl);
        this.mHideStatCheck.addItemListener(this.mAssignVarsTab);
        this.mAssignVarsTab.updateLowerControls();
        this.mAssignVarsTab.getTableCanvas().repaint();
    }
}

