/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.ctables.undo;

import com.spss.java_client.ui.dialogs.ctables.AssignVarsTab;
import com.spss.uitools.canvas.tables.CanvasState;
import com.spss.uitools.canvas.tables.TableDimension;
import com.spss.uitools.res.UIToolResUtil;
import javax.swing.JComboBox;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class StatSrcComboEdit
extends AbstractUndoableEdit {
    private AssignVarsTab mAssignVarsTab;
    private JComboBox mStatSrcCombo;
    private TableDimension.Type mOldStatSrcDimType;
    private TableDimension.Type mNewStatSrcDimType;
    private CanvasState mCanvasState;

    public StatSrcComboEdit(UndoManager undoManager, AssignVarsTab assignVarsTab, CanvasState canvasState, JComboBox jComboBox, TableDimension.Type type) {
        this.mAssignVarsTab = assignVarsTab;
        this.mOldStatSrcDimType = canvasState.getStatSource();
        this.mNewStatSrcDimType = type;
        this.mCanvasState = canvasState;
        this.mStatSrcCombo = jComboBox;
        this.mCanvasState.setStatSource(type);
        this.mAssignVarsTab.updateLowerControls();
        undoManager.addEdit(this);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.doAction(this.mOldStatSrcDimType);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.doAction(this.mNewStatSrcDimType);
    }

    @Override
    public String getPresentationName() {
        return UIToolResUtil.getString((String)"IDS_CANVASMENU_UNDO_SUMSRC");
    }

    @Override
    public void die() {
        super.die();
        this.mAssignVarsTab = null;
        this.mStatSrcCombo = null;
        this.mOldStatSrcDimType = null;
        this.mNewStatSrcDimType = null;
        this.mCanvasState = null;
    }

    private void doAction(TableDimension.Type type) {
        this.mCanvasState.setStatSource(type);
        this.mStatSrcCombo.removeItemListener(this.mAssignVarsTab);
        this.mStatSrcCombo.setSelectedIndex(this.mAssignVarsTab.findStatComboIndex(this.mStatSrcCombo, type));
        this.mStatSrcCombo.addItemListener(this.mAssignVarsTab);
        this.mAssignVarsTab.updateLowerControls();
        this.mAssignVarsTab.getTableCanvas().repaint();
    }
}

