/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.ctables.undo;

import com.spss.java_client.ui.dialogs.ctables.AssignVarsTab;
import com.spss.uitools.canvas.tables.CanvasState;
import com.spss.uitools.canvas.tables.TableDimension;
import com.spss.uitools.res.UIToolResUtil;
import javax.swing.JComboBox;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class StatPositionEdit
extends AbstractUndoableEdit {
    private AssignVarsTab mAssignVarsTab;
    private JComboBox mStatPosCombo;
    private TableDimension.Type mOldStatPosDimType;
    private TableDimension.Type mNewStatPosDimType;
    private CanvasState mCanvasState;

    public StatPositionEdit(UndoManager undoManager, AssignVarsTab assignVarsTab, CanvasState canvasState, JComboBox jComboBox, TableDimension.Type type) {
        this.mAssignVarsTab = assignVarsTab;
        this.mOldStatPosDimType = canvasState.getStatPosition();
        this.mNewStatPosDimType = type;
        this.mCanvasState = canvasState;
        this.mStatPosCombo = jComboBox;
        this.mCanvasState.setStatPosition(type);
        this.mAssignVarsTab.updateLowerControls();
        this.mAssignVarsTab.getTableCanvas().repaint();
        undoManager.addEdit(this);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.doAction(this.mOldStatPosDimType);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.doAction(this.mNewStatPosDimType);
    }

    @Override
    public String getPresentationName() {
        return UIToolResUtil.getString((String)"IDS_CANVASMENU_UNDO_POS");
    }

    @Override
    public void die() {
        super.die();
        this.mAssignVarsTab = null;
        this.mStatPosCombo = null;
        this.mOldStatPosDimType = null;
        this.mNewStatPosDimType = null;
        this.mCanvasState = null;
    }

    private void doAction(TableDimension.Type type) {
        this.mCanvasState.setStatPosition(type);
        this.mStatPosCombo.removeItemListener(this.mAssignVarsTab);
        this.mStatPosCombo.setSelectedIndex(this.mAssignVarsTab.findStatComboIndex(this.mStatPosCombo, type));
        this.mStatPosCombo.addItemListener(this.mAssignVarsTab);
        this.mAssignVarsTab.updateLowerControls();
        this.mAssignVarsTab.getTableCanvas().repaint();
    }
}

