/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.ctables.undo;

import com.spss.java_client.ui.dialogs.ctables.CatsAndTotalsSubDlg;
import com.spss.uitools.canvas.tables.BaseTableCanvas;
import com.spss.uitools.canvas.tables.TreeNode;
import com.spss.uitools.res.UIToolResUtil;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class CatsTotalsEdit
extends AbstractUndoableEdit {
    private TreeNode[] mClonedOldNodes;
    private TreeNode[] mClonedNewNodes;
    private BaseTableCanvas mCanvas;
    private TreeNode[] mNodes;

    public CatsTotalsEdit(UndoManager undoManager, CatsAndTotalsSubDlg catsAndTotalsSubDlg, BaseTableCanvas baseTableCanvas, TreeNode[] treeNodeArray) {
        this.mNodes = treeNodeArray;
        this.mCanvas = baseTableCanvas;
        this.mClonedOldNodes = new TreeNode[this.mNodes.length];
        this.mClonedNewNodes = new TreeNode[this.mNodes.length];
        for (int i = 0; i < this.mNodes.length; ++i) {
            TreeNode treeNode = this.mNodes[i];
            try {
                this.mClonedOldNodes[i] = treeNode.clone();
                catsAndTotalsSubDlg.updateNode(treeNode);
                this.mClonedNewNodes[i] = treeNode.clone();
                continue;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
        }
        baseTableCanvas.refresh();
        undoManager.addEdit(this);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.doAction(this.mClonedOldNodes);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.doAction(this.mClonedNewNodes);
    }

    @Override
    public String getPresentationName() {
        return UIToolResUtil.getString((String)"IDS_CANVASMENU_UNDO_CAT");
    }

    @Override
    public void die() {
        super.die();
        this.mNodes = null;
        this.mClonedOldNodes = null;
        this.mClonedNewNodes = null;
        this.mCanvas = null;
    }

    private void doAction(TreeNode[] treeNodeArray) {
        for (int i = 0; i < this.mNodes.length; ++i) {
            this.mNodes[i].setNodeFlags(treeNodeArray[i].getNodeFlags());
            Vector vector = treeNodeArray[i].getCatVector();
            this.mNodes[i].setCatVector(vector);
            this.mNodes[i].setStrSortStat(treeNodeArray[i].getStrSortStat());
            this.mNodes[i].setTotalsBefore(treeNodeArray[i].getTotalsBefore());
        }
        this.mCanvas.refresh();
    }
}

