/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.ctables.undo;

import com.spss.java_client.ui.dialogs.ctables.AssignVarsTab;
import com.spss.uitools.canvas.tables.CanvasState;
import com.spss.uitools.res.UIToolResUtil;
import javax.swing.JComboBox;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class CatPositionEdit
extends AbstractUndoableEdit {
    private AssignVarsTab mAssignVarsTab;
    private JComboBox mCatPosCombo;
    private CanvasState.ComperimeterState mOldCompState;
    private CanvasState.ComperimeterState mNewCompState;
    private CanvasState mCanvasState;

    public CatPositionEdit(UndoManager undoManager, AssignVarsTab assignVarsTab, CanvasState canvasState, JComboBox jComboBox, CanvasState.ComperimeterState comperimeterState) {
        this.mAssignVarsTab = assignVarsTab;
        this.mOldCompState = canvasState.getCatPosition();
        this.mNewCompState = comperimeterState;
        this.mCanvasState = canvasState;
        this.mCatPosCombo = jComboBox;
        this.mCanvasState.setCatPosition(comperimeterState);
        this.mAssignVarsTab.updateLowerControls();
        this.mAssignVarsTab.getTableCanvas().repaint();
        undoManager.addEdit(this);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.doAction(this.mOldCompState);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.doAction(this.mNewCompState);
    }

    @Override
    public String getPresentationName() {
        return UIToolResUtil.getString((String)"IDS_CANVASMENU_UNDO_CATPOS");
    }

    @Override
    public void die() {
        super.die();
        this.mAssignVarsTab = null;
        this.mCatPosCombo = null;
        this.mOldCompState = null;
        this.mNewCompState = null;
        this.mCanvasState = null;
    }

    private void doAction(CanvasState.ComperimeterState comperimeterState) {
        this.mCanvasState.setCatPosition(comperimeterState);
        this.mCatPosCombo.removeItemListener(this.mAssignVarsTab);
        this.mCatPosCombo.setSelectedIndex(this.mAssignVarsTab.findStatComboIndex(this.mCatPosCombo, comperimeterState));
        this.mCatPosCombo.addItemListener(this.mAssignVarsTab);
        this.mAssignVarsTab.updateLowerControls();
        this.mAssignVarsTab.getTableCanvas().repaint();
    }
}

