/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.ctables;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.ContextEnabledTextArea;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class TitlesTab
extends BaseProcedureTab {
    private static String sDateText;
    private static String sTimeText;
    private static String sTableExText;
    private JButton mDateButton;
    private JButton mTimeButton;
    private JButton mTableExpButton;
    private ContextEnabledTextArea mTitleArea;
    private ContextEnabledTextArea mCaptionArea;
    private ContextEnabledTextArea mCornerArea;
    private ContextEnabledTextArea mLastFocusArea;

    public TitlesTab(BaseDialog baseDialog, boolean bl) {
        super(baseDialog, bl);
        this.reset();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_table_titles";
    }

    @Override
    public void reset() {
        super.reset();
        this.mTitleArea.setText("");
        this.mCaptionArea.setText("");
        this.mCornerArea.setText("");
        this.mLastFocusArea = null;
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.setupTopPanel();
        this.setupCenterPanel();
        this.setFocusTraversalPolicy();
    }

    @Override
    protected void loadTabState(DialogDataModel dialogDataModel, BaseProcedureDialog.NameLabelOption nameLabelOption) {
        super.loadTabState(dialogDataModel, nameLabelOption);
        this.mTitleArea.setText(dialogDataModel.getString("title"));
        this.mCaptionArea.setText(dialogDataModel.getString("caption"));
        this.mCornerArea.setText(dialogDataModel.getString("corner"));
    }

    @Override
    protected void saveTabState(DialogDataModel dialogDataModel) {
        super.saveTabState(dialogDataModel);
        dialogDataModel.putString("title", this.mTitleArea.getText());
        dialogDataModel.putString("caption", this.mCaptionArea.getText());
        dialogDataModel.putString("corner", this.mCornerArea.getText());
    }

    protected void generateSyntax(StringBuffer stringBuffer) {
        String string = this.mTitleArea.getText();
        String string2 = this.mCornerArea.getText();
        String string3 = this.mCaptionArea.getText();
        if (string.length() > 0 || string2.length() > 0 || string3.length() > 0) {
            stringBuffer.append('\n');
            stringBuffer.append(SyntaxUtil.getSubCommand("/TITLES"));
            if (string.length() > 0) {
                stringBuffer.append("\n    TITLE=");
                stringBuffer.append(this.formatEditForSyntax(string));
            }
            if (string2.length() > 0) {
                stringBuffer.append("\n    CORNER=");
                stringBuffer.append(this.formatEditForSyntax(string2));
            }
            if (string3.length() > 0) {
                stringBuffer.append("\n    CAPTION=");
                stringBuffer.append(this.formatEditForSyntax(string3));
            }
        }
    }

    private void setupTopPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2));
        this.mDateButton = new JButton(new DateAction());
        this.mDateButton.setIcon(new ImageIcon(this.getResImageURL("IDI_DATE_ENABLED_IMAGE")));
        this.mDateButton.setRolloverEnabled(true);
        jPanel.add(this.mDateButton);
        this.mTimeButton = new JButton(new TimeAction());
        this.mTimeButton.setIcon(new ImageIcon(this.getResImageURL("IDI_TIME_ENABLED_IMAGE")));
        this.mTimeButton.setRolloverEnabled(true);
        jPanel.add(this.mTimeButton);
        this.mTableExpButton = new JButton(new TableExAction());
        this.mTableExpButton.setIcon(new ImageIcon(this.getResImageURL("IDI_TABLE_EX_ENABLED_IMAGE")));
        this.mTableExpButton.setRolloverEnabled(true);
        jPanel.add(this.mTableExpButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = new Insets(0, 0, 0, 0);
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
    }

    private void setupTextAreaGroup(JTextArea jTextArea, String string, String string2, String string3, int n) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        int n2 = 23;
        int n3 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n3, 0, 2, 0);
        JLabel jLabel = DialogUtil.createLabel(this.mParent, string);
        jLabel.setDisplayedMnemonic(this.getDlgAccessKey(string2));
        jLabel.setIcon(new ImageIcon(this.getResImageURL(string3)));
        jLabel.setLabelFor(jTextArea);
        DialogUtil.addUsingGBL(this, jLabel, gridBagConstraints, 0, n, 1, 1, n2, insets);
        jTextArea.setFocusTraversalKeys(0, null);
        jTextArea.setFocusTraversalKeys(1, null);
        jTextArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                Component component = focusEvent.getComponent();
                if (component instanceof ContextEnabledTextArea) {
                    TitlesTab.this.mLastFocusArea = (ContextEnabledTextArea)component;
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        insets = new Insets(0, 0, 0, 0);
        DialogUtil.addUsingGBL(this, jScrollPane, gridBagConstraints, 0, ++n, 2, 1, n2, insets);
    }

    private void setupCenterPanel() {
        this.mTitleArea = new ContextEnabledTextArea(ComponentState.getCurrentCharset());
        this.mCaptionArea = new ContextEnabledTextArea(ComponentState.getCurrentCharset());
        this.mCornerArea = new ContextEnabledTextArea(ComponentState.getCurrentCharset());
        this.mTitleArea.setValidateOnFocusLost(true);
        this.mCaptionArea.setValidateOnFocusLost(true);
        this.mCornerArea.setValidateOnFocusLost(true);
        int n = 1;
        this.setupTextAreaGroup((JTextArea)this.mTitleArea, "IDS_TITLE", "IDK_TITLE_KEY", "IDI_TITLE_IMAGE", n);
        this.setupTextAreaGroup((JTextArea)this.mCaptionArea, "IDS_CAPTION", "IDK_CAPTION_KEY", "IDI_CAPTION_IMAGE", n += 2);
        this.setupTextAreaGroup((JTextArea)this.mCornerArea, "IDS_CORNER", "IDK_CORNER_KEY", "IDI_CORNER_IMAGE", n += 2);
    }

    private void setFocusTraversalPolicy() {
        this.mComponentOrder.add(this.mDateButton);
        this.mComponentOrder.add(this.mTimeButton);
        this.mComponentOrder.add(this.mTableExpButton);
        this.mComponentOrder.add(this.mTitleArea);
        this.mComponentOrder.add(this.mCaptionArea);
        this.mComponentOrder.add(this.mCornerArea);
    }

    private JTextArea getLastFocusArea() {
        if (this.mLastFocusArea == null) {
            this.mLastFocusArea = this.mTitleArea;
        }
        return this.mLastFocusArea;
    }

    private void insertText(String string) {
        JTextArea jTextArea = this.getLastFocusArea();
        int n = jTextArea.getCaretPosition();
        jTextArea.insert(string, n);
    }

    private String formatEditForSyntax(String string) {
        String string2 = CharacterUtil.smartQuote((String)string);
        char c = string2.charAt(0);
        String string3 = new String(new char[]{c});
        string2 = string2.replace("\n", string3 + " " + string3);
        string2 = string2.replace(this.getDateText(), ")DATE");
        string2 = string2.replace(this.getTimeText(), ")TIME");
        string2 = string2.replace(this.getTableExText(), ")TABLE");
        return string2;
    }

    private String getDateText() {
        if (sDateText == null && (sDateText = this.getResString("IDS_DATE_INSERTION")) == null) {
            sDateText = "&[Current Date]";
        }
        return sDateText;
    }

    private String getTimeText() {
        if (sTimeText == null && (sTimeText = this.getResString("IDS_TIME_INSERTION")) == null) {
            sTimeText = "&[Current Time]";
        }
        return sTimeText;
    }

    private String getTableExText() {
        if (sTableExText == null && (sTableExText = this.getResString("IDS_TABLE_EX_INSERTION")) == null) {
            sTableExText = "&[Table Expression]";
        }
        return sTableExText;
    }

    class TableExAction
    extends AbstractAction {
        TableExAction() {
            this.putValue("Name", TitlesTab.this.getResString("IDS_TABLE_EX_LABEL"));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                this.putValue("MnemonicKey", TitlesTab.this.getDlgAccessKey("IDK_TABLE_EX_LABEL_KEY"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TitlesTab.this.insertText(TitlesTab.this.getTableExText());
        }
    }

    class TimeAction
    extends AbstractAction {
        TimeAction() {
            this.putValue("Name", TitlesTab.this.getResString("IDS_TIME_LABEL"));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                this.putValue("MnemonicKey", TitlesTab.this.getDlgAccessKey("IDK_TIME_LABEL_KEY"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TitlesTab.this.insertText(TitlesTab.this.getTimeText());
        }
    }

    class DateAction
    extends AbstractAction {
        DateAction() {
            this.putValue("Name", TitlesTab.this.getResString("IDS_DATE_LABEL"));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                this.putValue("MnemonicKey", TitlesTab.this.getDlgAccessKey("IDK_DATE_LABEL_KEY"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TitlesTab.this.insertText(TitlesTab.this.getDateText());
        }
    }
}

